'$DYNAMIC
'QUADB24.BAS
'QuadBLOX
'vers: 2.4
'created by Derek Andrews

'This is a TETRIS type game in which the player uses the arrow keys
'to direct falling blocks to fit into a well. The goal is to score as many
'points as possible. There are two ways to score points. One is to drop
'blocks into the well. The number of points you receive is the number of
'colored blocks in the current block. The main way of scoring points is
'to complete horizontal lines of colored blocks. When one or more is complete,
'the line disappears and the player scores points. When the player completes
'ten lines, the speed and level are incremented.


'subs

DEFINT A-Z
DECLARE SUB DisplayHighScores (HighLight%)
DECLARE SUB SaveHighScores ()
DECLARE SUB GetInput (comment$, user.input$, Y%, X%, limit%)
DECLARE SUB InitHighScores ()
DECLARE SUB BlockInc (HitBottom%)
DECLARE SUB CheckLevel ()
DECLARE SUB CheckRows ()
DECLARE SUB ClearBuffer ()
DECLARE SUB Delay (Time!, Interval%)
DECLARE SUB Demo ()
DECLARE SUB DrawWell ()
DECLARE SUB Font (strng$, SX%, SY%, XF!, YF!, C%, C2%)
DECLARE SUB GameOver (Branch%)
DECLARE SUB GetStartLevel ()
DECLARE SUB InitPlay ()
DECLARE SUB InitProg ()
DECLARE SUB Menu ()
DECLARE SUB NewBlock ()
DECLARE SUB PlaceBlock ()
DECLARE SUB PlayGame ()
DECLARE SUB ReadDemoData ()
DECLARE SUB ReadStyleData ()
DECLARE SUB RemoveBlock ()
DECLARE SUB ResetScreen ()
DECLARE SUB ScoreUp (Increment%)
DECLARE SUB ShowNextBlock ()
DECLARE SUB ShowStatus ()
DECLARE SUB WaitUntilEvent ()
DECLARE SUB WellClear (colour%)
DECLARE SUB WellScreenDump ()


'functions

DECLARE FUNCTION CanMove% (BX%, BY%, BR%)
DECLARE FUNCTION CanPlace% (BX%, BY%, BR%)
DECLARE FUNCTION HitKey% ()
DECLARE FUNCTION NumSquares% ()

'stores high score entry
TYPE HighScoreType
    NameStr AS STRING * 10
    Score AS LONG
END TYPE

'constants

CONST True% = 1                  'true
CONST False% = 0                 'false
CONST LevelUp% = 10              'number of lines to get to next level
CONST TopScore& = 999999         'highest score player can get
CONST WellWidth% = 10            'well width
CONST WellHeight% = 14           'well height
CONST MaxDemo% = 2502            'maximum demo size
CONST NumStyles% = 7             'number of block styles
CONST NumRotations% = 4          'number of rotations per block
CONST StyleWidth% = 4            'max width of block styles
CONST StyleHeight% = 4           'max height of block styles
CONST BackGroundColor% = 176     'background color
CONST KeyLeft% = 75              'moves current block left
CONST KeyRight% = 77             'moves current block right
CONST KeyUp% = 72                'rotates block
CONST KeyDown% = 80              'drops block
CONST Enter% = 28                'enter key
CONST Quit% = 16                 'Q key
CONST Pause% = 25                'P key
CONST MaxHighScores% = 10        'total number of high score entries
CONST BlockDrop$ = "T255L64MLMFO1ABCDCBA"     'sound effects
CONST BlockSpin$ = "T255L64MLMBO2AEA"
CONST LineClear$ = "T75L64MLMBO3CDEBGDEBC"

'global variables

DIM SHARED Score&, ClearLines%    'score variables
DIM SHARED ClearedLines%          'temporary number of lines cleared
DIM SHARED BlockX%, BlockY%       'current block coordinates
DIM SHARED CurrentBlock%          'current block being used
DIM SHARED NextBlock%             'next block to be used
DIM SHARED BlockRotation%         'rotation of current block
DIM SHARED Speed%                 'delay for dropping of block
DIM SHARED Level%, StartLevel%    'current level and level player starts at
DIM SHARED BlockIncCount%         'flag stored for BlockInc procedure


'global arrays

'stores blocks currently in well
'
DIM SHARED Well%(1 TO WellWidth%, 1 TO WellHeight%)

'stores block styles
'
DIM SHARED BlockStyles%(1 TO StyleWidth%, 1 TO StyleHeight%, 1 TO NumRotations%, 1 TO NumStyles%)

'stores y coordinates of cleared lines
'
DIM SHARED LineClearCoord%(1 TO StyleHeight%)

'stores demo instructions
'
DIM SHARED DemoButtons%(1 TO MaxDemo%)

'stores ten high scores
'
DIM SHARED HighScores(1 TO MaxHighScores%) AS HighScoreType

'main program block

InitProg                       'program startup---called only once
PlayGame                       'enter main loop
END
ErrHdl:
RESUME NEXT

'style data---you can edit these or add your own---the added ones
'will be used only if you change the constant NumStyles% and make sure
'that each new block has 4 4x4 DATA blocks.

'style 1

DATA 0,0,0,0
DATA 40,40,40,40
DATA 0,0,0,0
DATA 0,0,0,0

DATA  0,40,0,0
DATA  0,40,0,0
DATA  0,40,0,0
DATA  0,40,0,0
      
DATA 0,0,0,0
DATA 40,40,40,40
DATA 0,0,0,0
DATA 0,0,0,0

DATA 0,40,0,0
DATA 0,40,0,0
DATA 0,40,0,0
DATA 0,40,0,0

'style 2

DATA 0,0,0,0
DATA 36,36,0,0
DATA 0,36,36,0
DATA 0,0,0,0

DATA 0,0,0,0
DATA 0,0,36,0
DATA 0,36,36,0
DATA 0,36,0,0

DATA 0,0,0,0
DATA 36,36,0,0
DATA 0,36,36,0
DATA 0,0,0,0

DATA 0,0,0,0
DATA 0,0,36,0
DATA 0,36,36,0
DATA 0,36,0,0

'style 3

DATA 0,0,0,0
DATA 0,48,48,0
DATA 48,48,0,0
DATA 0,0,0,0

DATA 0,0,0,0
DATA 48,0,0,0
DATA 48,48,0,0
DATA 0,48,0,0

DATA 0,0,0,0
DATA 0,48,48,0
DATA 48,48,0,0
DATA 0,0,0,0

DATA 0,0,0,0
DATA 48,0,0,0
DATA 48,48,0,0
DATA 0,48,0,0

'style 4

DATA 0,0,0,0
DATA 42,0,0,0
DATA 42,42,42,0
DATA 0,0,0,0

DATA 0,0,0,0
DATA 0,42,42,0
DATA 0,42,0,0
DATA 0,42,0,0

DATA 0,0,0,0
DATA 0,0,0,0
DATA 42,42,42,0
DATA 0,0,42,0

DATA 0,0,0,0
DATA 0,42,0,0
DATA 0,42,0,0
DATA 42,42,0,0

'style 5

DATA 0,0,0,0
DATA 107,107,107,0
DATA 107,0,0,0
DATA 0,0,0,0

DATA 107,107,0,0
DATA 0,107,0,0
DATA 0,107,0,0
DATA 0,0,0,0

DATA 0,0,107,0
DATA 107,107,107,0
DATA 0,0,0,0
DATA 0,0,0,0

DATA 0,107,0,0
DATA 0,107,0,0
DATA 0,107,107,0
DATA 0,0,0,0

'style 6

DATA 0,0,0,0
DATA 44,44,44,0
DATA 0,44,0,0
DATA 0,0,0,0

DATA 0,44,0,0
DATA 44,44,0,0
DATA 0,44,0,0
DATA 0,0,0,0

DATA 0,44,0,0
DATA 44,44,44,0
DATA 0,0,0,0
DATA 0,0,0,0

DATA 0,44,0,0
DATA 0,44,44,0
DATA 0,44,0,0
DATA 0,0,0,0

'style 7

DATA 0,0,0,0
DATA 0,32,32,0
DATA 0,32,32,0
DATA 0,0,0,0

DATA 0,0,0,0
DATA 0,32,32,0
DATA 0,32,32,0
DATA 0,0,0,0

DATA 0,0,0,0
DATA 0,32,32,0
DATA 0,32,32,0
DATA 0,0,0,0

DATA 0,0,0,0
DATA 0,32,32,0
DATA 0,32,32,0
DATA 0,0,0,0

'demo data---these are variables from a session I played and recorded.
'used in demo procedure

DATA 156,6,5,156,6,5,156,6,5,156,6,5,156,6,5,156,6,5,156,6,5,156,6,5,156
DATA 6,5,156,6,5,156,6,5,156,6,5,156,6,5,156,6,5,156,6,5,156,6,5,72,6
DATA 5,72,6,5,75,6,5,75,6,5,75,6,5,75,6,5,80,6,5,80,6,5,80,6,5
DATA 80,6,5,80,6,5,80,6,5,80,6,5,80,6,5,80,6,5,80,6,5,80,6,5,80
DATA 6,5,80,5,7,208,5,7,77,5,7,77,5,7,77,5,7,72,5,7,72,5,7,77,5
DATA 7,205,5,7,205,5,7,80,5,7,80,5,7,80,5,7,80,5,7,80,5,7,80,5,7
DATA 80,5,7,80,5,7,80,5,7,80,5,7,80,5,7,80,5,7,80,7,2,80,7,2,80
DATA 7,2,208,7,2,77,7,2,77,7,2,77,7,2,205,7,2,80,7,2,80,7,2,80,7
DATA 2,80,7,2,80,7,2,80,7,2,80,7,2,80,7,2,80,7,2,80,2,3,80,2,3
DATA 208,2,3,75,2,3,75,2,3,72,2,3,75,2,3,75,2,3,75,2,3,80,2,3,80
DATA 2,3,80,2,3,80,2,3,80,2,3,80,2,3,80,2,3,80,2,3,80,2,3,80,3
DATA 6,80,3,6,80,3,6,208,3,6,75,3,6,203,3,6,72,3,6,200,3,6,80,3,6
DATA 80,3,6,80,3,6,80,3,6,80,3,6,80,3,6,80,3,6,80,3,6,80,3,6,80
DATA 6,7,80,6,7,208,6,7,77,6,7,77,6,7,205,6,7,205,6,7,72,6,7,77,6
DATA 7,77,6,7,77,6,7,80,6,7,80,6,7,80,6,7,80,6,7,80,6,7,80,6,7
DATA 80,6,7,80,6,7,80,7,5,80,7,5,208,7,5,77,7,5,205,7,5,205,7,5,80
DATA 7,5,80,7,5,80,7,5,80,7,5,80,7,5,80,7,5,80,7,5,80,7,5,80,7
DATA 5,80,7,5,80,7,5,208,5,1,208,5,1,80,5,1,80,5,1,208,5,1,208,5,1
DATA 208,5,1,208,5,1,208,5,1,208,5,1,208,5,1,72,5,1,200,5,1,80,5,1,80
DATA 5,1,80,5,1,80,5,1,80,5,1,80,5,1,80,5,1,80,5,1,80,5,1,80,5
DATA 1,80,5,1,80,1,3,80,1,3,80,1,3,80,1,3,208,1,3,75,1,3,203,1,3
DATA 72,1,3,75,1,3,75,1,3,75,1,3,203,1,3,80,1,3,80,1,3,80,1,3,80
DATA 1,3,80,1,3,80,1,3,80,1,3,80,3,6,80,3,6,80,3,6,208,3,6,75,3
DATA 6,203,3,6,72,3,6,200,3,6,75,3,6,203,3,6,203,3,6,80,3,6,80,3,6
DATA 80,3,6,80,3,6,80,3,6,80,3,6,80,3,6,80,3,6,80,6,7,80,6,7,80
DATA 6,7,208,6,7,77,6,7,77,6,7,72,6,7,200,6,7,72,6,7,72,6,7,77,6
DATA 7,205,6,7,205,6,7,205,6,7,80,6,7,80,6,7,80,6,7,80,6,7,80,6,7
DATA 80,6,7,80,6,7,80,6,7,80,7,4,80,7,4,80,7,4,80,7,4,208,7,4,75
DATA 7,4,203,7,4,203,7,4,80,7,4,80,7,4,80,7,4,80,7,4,80,7,4,80,7
DATA 4,80,7,4,80,7,4,208,4,6,208,4,6,208,4,6,208,4,6,77,4,6,77,4,6
DATA 205,4,6,205,4,6,205,4,6,205,4,6,205,4,6,205,4,6,205,4,6,72,4,6,200
DATA 4,6,72,4,6,72,4,6,200,4,6,200,4,6,200,4,6,80,4,6,80,4,6,80,4
DATA 6,80,4,6,80,4,6,80,4,6,80,4,6,80,4,6,80,4,6,80,4,6,80,4,6
DATA 80,6,1,80,6,1,208,6,1,75,6,1,203,6,1,72,6,1,72,6,1,200,6,1,200
DATA 6,1,80,6,1,80,6,1,80,6,1,80,6,1,80,6,1,80,6,1,80,6,1,80,6
DATA 1,80,6,1,80,6,1,80,1,6,80,1,6,208,1,6,77,1,6,77,1,6,77,1,6
DATA 72,1,6,200,1,6,200,1,6,200,1,6,200,1,6,77,1,6,80,1,6,80,1,6,80
DATA 1,6,80,1,6,80,1,6,80,1,6,208,1,6,77,1,6,77,1,6,205,1,6,80,1
DATA 6,77,6,3,77,6,3,77,6,3,77,6,3,72,6,3,200,6,3,200,6,3,200,6,3
DATA 200,6,3,200,6,3,72,6,3,200,6,3,80,6,3,80,6,3,80,6,3,80,6,3,80
DATA 6,3,80,6,3,80,6,3,80,6,3,80,6,3,80,6,3,80,3,6,80,3,6,80,3
DATA 6,208,3,6,75,3,6,75,3,6,72,3,6,75,3,6,75,3,6,203,3,6,80,3,6
DATA 80,3,6,80,3,6,80,3,6,80,3,6,80,3,6,80,6,7,208,6,7,75,6,7,75
DATA 6,7,72,6,7,72,6,7,200,6,7,200,6,7,200,6,7,200,6,7,200,6,7,72,6
DATA 7,200,6,7,80,6,7,80,6,7,80,6,7,80,6,7,80,6,7,80,6,7,80,6,7
DATA 80,6,7,80,7,5,208,7,5,208,7,5,77,7,5,205,7,5,205,7,5,80,7,5,80
DATA 7,5,80,7,5,80,7,5,80,7,5,80,7,5,80,7,5,80,7,5,80,7,5,80,7
DATA 5,80,5,1,80,5,1,208,5,1,208,5,1,77,5,1,205,5,1,205,5,1,205,5,1
DATA 205,5,1,205,5,1,205,5,1,205,5,1,205,5,1,205,5,1,205,5,1,205,5,1,205
DATA 5,1,205,5,1,205,5,1,80,5,1,80,5,1,80,5,1,80,5,1,80,5,1,80,5
DATA 1,80,5,1,80,5,1,80,1,2,208,1,2,208,1,2,75,1,2,75,1,2,72,1,2
DATA 200,1,2,75,1,2,75,1,2,203,1,2,80,1,2,80,1,2,80,1,2,80,1,2,80
DATA 1,2,80,1,2,80,2,1,80,2,1,208,2,1,77,2,1,77,2,1,77,2,1,72,2
DATA 1,200,2,1,80,2,1,80,2,1,80,2,1,80,2,1,80,2,1,80,2,1,80,2,1
DATA 80,2,1,80,1,3,80,1,3,80,1,3,208,1,3,208,1,3,208,1,3,208,1,3,208
DATA 1,3,208,1,3,208,1,3,208,1,3,72,1,3,200,1,3,77,1,3,205,1,3,205,1
DATA 3,80,1,3,80,1,3,80,1,3,80,1,3,80,1,3,80,1,3,80,1,3,80,1,3
DATA 80,3,5,208,3,5,75,3,5,203,3,5,72,3,5,200,3,5,80,3,5,80,3,5,80
DATA 3,5,80,3,5,80,3,5,80,3,5,80,3,5,80,3,5,80,3,5,80,3,5,80,3
DATA 5,80,5,6,80,5,6,80,5,6,80,5,6,80,5,6,208,5,6,208,5,6,72,5,6
DATA 200,5,6,200,5,6,80,5,6,80,5,6,80,5,6,80,5,6,80,5,6,80,5,6,80
DATA 5,6,80,5,6,80,6,7,80,6,7,208,6,7,77,6,7,77,6,7,205,6,7,72,6
DATA 7,200,6,7,72,6,7,72,6,7,80,6,7,80,6,7,80,6,7,80,6,7,80,6,7
DATA 80,6,7,80,6,7,80,6,7,80,6,7,80,6,7,80,7,5,80,7,5,208,7,5,77
DATA 7,5,77,7,5,77,7,5,80,7,5,80,7,5,208,7,5,208,7,5,208,7,5,208,7
DATA 5,80,7,5,80,7,5,80,7,5,80,7,5,80,7,5,80,7,5,80,7,5,80,5,2
DATA 80,5,2,80,5,2,208,5,2,77,5,2,77,5,2,77,5,2,205,5,2,80,5,2,80
DATA 5,2,208,5,2,208,5,2,208,5,2,75,5,2,75,5,2,75,5,2,75,5,2,72,5
DATA 2,200,5,2,200,5,2,72,5,2,200,5,2,200,5,2,80,5,2,80,5,2,80,5,2
DATA 80,5,2,80,5,2,80,2,5,208,2,5,208,2,5,208,2,5,72,2,5,200,2,5,77
DATA 2,5,205,2,5,80,2,5,80,2,5,80,2,5,80,2,5,80,2,5,80,2,5,80,2
DATA 5,80,2,5,80,2,5,80,5,4,80,5,4,208,5,4,208,5,4,208,5,4,77,5,4
DATA 77,5,4,77,5,4,205,5,4,72,5,4,77,5,4,77,5,4,77,5,4,205,5,4,80
DATA 5,4,80,5,4,80,5,4,80,5,4,80,5,4,80,5,4,80,5,4,80,5,4,208,4
DATA 3,208,4,3,208,4,3,75,4,3,203,4,3,203,4,3,203,4,3,203,4,3,203,4,3
DATA 203,4,3,77,4,3,77,4,3,77,4,3,77,4,3,77,4,3,72,4,3,72,4,3,200
DATA 4,3,72,4,3,77,4,3,77,4,3,77,4,3,80,4,3,80,4,3,80,4,3,80,4
DATA 3,80,4,3,208,3,7,208,3,7,208,3,7,208,3,7,208,3,7,77,3,7,77,3,7
DATA 77,3,7,72,3,7,200,3,7,80,3,7,80,3,7,80,3,7,80,3,7,80,3,7,80
DATA 3,7,80,3,7,80,7,4,80,7,4,208,7,4,75,7,4,75,7,4,203,7,4,203,7
DATA 4,80,7,4,80,7,4,80,7,4,80,7,4,80,7,4,80,7,4,80,7,4,75,4,1
DATA 203,4,1,203,4,1,72,4,1,72,4,1,200,4,1,200,4,1,80,4,1,80,4,1,80
DATA 4,1,80,4,1,80,4,1,80,4,1,80,4,1,75,1,4,75,1,4,75,1,4,203,1
DATA 4,72,1,4,200,1,4,200,1,4,200,1,4,200,1,4,200,1,4,200,1,4,72,1,4
DATA 200,1,4,200,1,4,80,1,4,80,1,4,80,1,4,80,1,4,80,1,4,80,1,4,80
DATA 1,4,80,1,4,80,1,4,80,1,4,80,1,4,77,4,5,77,4,5,77,4,5,205,4
DATA 5,205,4,5,205,4,5,205,4,5,205,4,5,72,4,5,72,4,5,200,4,5,72,4,5
DATA 77,4,5,205,4,5,205,4,5,205,4,5,205,4,5,80,4,5,80,4,5,80,4,5,80
DATA 4,5,80,4,5,80,4,5,80,4,5,80,4,5,208,5,2,208,5,2,75,5,2,203,5
DATA 2,203,5,2,203,5,2,203,5,2,203,5,2,203,5,2,203,5,2,203,5,2,203,5,2
DATA 203,5,2,72,5,2,200,5,2,75,5,2,75,5,2,75,5,2,80,5,2,80,5,2,80
DATA 5,2,80,5,2,80,5,2,80,5,2,80,5,2,80,5,2,80,5,2,80,5,2,80,5
DATA 2,208,2,7,80,2,7,80,2,7,208,2,7,208,2,7,208,2,7,208,2,7,75,2,7
DATA 75,2,7,75,2,7,72,2,7,75,2,7,75,2,7,80,2,7,80,2,7,80,2,7,80
DATA 2,7,80,2,7,208,7,1,80,7,1,80,7,1,77,7,1,77,7,1,205,7,1,205,7
DATA 1,205,7,1,205,7,1,80,7,1,80,7,1,80,7,1,80,7,1,80,7,1,80,7,1
DATA 80,7,1,208,1,2,77,1,2,205,1,2,205,1,2,72,1,2,200,1,2,200,1,2,200
DATA 1,2,200,1,2,200,1,2,200,1,2,200,1,2,200,1,2,72,1,2,200,1,2,200,1
DATA 2,80,1,2,80,1,2,80,1,2,80,1,2,80,1,2,80,1,2,80,1,2,80,1,2
DATA 80,1,2,80,1,2,208,2,7,208,2,7,208,2,7,208,2,7,208,2,7,208,2,7,16
DATA 2,7

REM $STATIC
DEFSNG A-Z
'increments block every speed% loops
'this was the source of a major bug---the demo needs the BlockIncCount% variable
'to be reset every time, so I shared it with all the modules so InitPlay
'could reset it.
'
SUB BlockInc (HitBottom%)

HitBottom% = False%
BlockIncCount% = BlockIncCount% + 1       'increment incflag
IF BlockIncCount% >= Speed% THEN    'increments block's y coord if true
     BlockIncCount% = 0
     IF CanMove%(BlockX%, BlockY% + 1, BlockRotation%) = True% THEN BlockY% = BlockY% + 1 ELSE HitBottom% = True%
     PlaceBlock
END IF

END SUB

'tests if block can fit into BX%, BY% at rotation BR%
'
FUNCTION CanMove% (BX%, BY%, BR%)

RemoveBlock    'remove current block so block can't run into itself
NonOverlap% = 0
FOR Y = 1 TO StyleHeight%     'counts number of non-overlapping squares
     FOR X = 1 TO StyleWidth%
          IF BlockStyles%(X, Y, BR%, CurrentBlock%) <> BackGroundColor% AND X + BX% >= 1 AND Y + BY% >= 1 AND X + BX% <= WellWidth% AND Y + BY% <= WellHeight% THEN
               IF Well%(X + BX%, Y + BY%) = BackGroundColor% THEN NonOverlap% = NonOverlap% + 1
          END IF
     NEXT X
NEXT Y
IF NumSquares% = NonOverlap% THEN     'if number of squares equals the number of non-overlapping
     CanMove% = True%                  'squares, then the block will fit, otherwise, it won't
ELSE
     CanMove% = False%
END IF

END FUNCTION

'this function tests if current block can fit into well
'used to detect game over, i.e., to detect when well is full
'
FUNCTION CanPlace% (BX%, BY%, BR%)

FOR S = 1 TO NumStyles%
     FOR Y = 1 TO StyleHeight%
          FOR X = 1 TO StyleWidth%
               IF X + BX% >= 1 AND Y + BY% >= 1 AND X + BX% <= WellWidth% AND Y + BY% <= WellHeight% THEN    'if block in question is in well, then..
                    IF Well%(X + BX%, Y + BY%) <> BackGroundColor% AND BlockStyles%(X, Y, BR%, S) <> BackGroundColor% THEN
                         CanPlace% = False%
                         EXIT FUNCTION
                    END IF
               END IF
          NEXT X
     NEXT Y
NEXT S
CanPlace% = True%

END FUNCTION

'increments level when player clears LevelUp% lines
'
SUB CheckLevel

IF ClearedLines% >= LevelUp% THEN
     ClearedLines% = 0
     IF Speed% > 3 THEN
          Speed% = Speed% - 1
          Level% = Level% + 1
     END IF
END IF

END SUB

'checks to see if player has completed any horizontal lines and clears them
'
SUB CheckRows

LineClearCount% = 0     'index variable for cleared line coords array
FOR Y = 1 TO WellHeight%     'checks each row for a completed one
     RowCount% = 0
     FOR X = 1 TO WellWidth%     'counts number of colored blocks in row
          IF Well%(X, Y) <> BackGroundColor% THEN RowCount% = RowCount% + 1
     NEXT X
     IF RowCount% = WellWidth% THEN     'found a completed line
          LineClearCount% = LineClearCount% + 1
          LineClearCoord%(LineClearCount%) = Y    'store coordinate of cleared line
          ClearedLines% = ClearedLines% + 1
          ClearLines% = ClearLines% + 1
          CheckLevel     'check to see if player has completed enough lines for level increment
     END IF
NEXT Y
IF LineClearCount% THEN     'if player completed at least one line then clear all completed lines
     PLAY LineClear$
     FOR Flash% = 1 TO 10     'makes completed row(s) flash
          FOR X = 1 TO WellWidth%
               FOR Y = 1 TO LineClearCount%
                    ClearCoord% = LineClearCoord%(Y)
                    IF Flash% / 2 = INT(Flash% / 2) THEN
                         Well%(X, ClearCoord%) = 0
                    ELSE
                         Well%(X, ClearCoord%) = 15
                    END IF
               NEXT Y
               ClearBuffer
          NEXT X
          Delay .01, 0
          WellScreenDump
     NEXT Flash%
     FOR X = 1 TO WellWidth%     'this loop clears completed lines
          FOR Y = 1 TO LineClearCount%
               ClearCoord% = LineClearCoord%(Y)
               Well%(X, ClearCoord%) = BackGroundColor%
          NEXT Y
          ClearBuffer
     NEXT X
     WellScreenDump
     FOR Y = 1 TO LineClearCount%     'this loop moves remaining blocks down one
          FOR DY = LineClearCoord%(Y) TO 1 STEP -1
               FOR X = 1 TO WellWidth%
                    IF DY = 1 THEN Well%(X, DY) = BackGroundColor% ELSE Well%(X, DY) = Well%(X, DY - 1)
               NEXT X
          NEXT DY
          Delay .01, 0
          ClearBuffer
          WellScreenDump
     NEXT Y
     SELECT CASE LineClearCount%
          CASE 1
               ScoreUp 100
          CASE 2
               ScoreUp 500
          CASE 3
               ScoreUp 1000
          CASE 4
               ScoreUp 5000
     END SELECT
END IF

END SUB

'waits until INKEY$ is null
'
SUB ClearBuffer

WHILE LEN(INKEY$): WEND

END SUB

'delays for Time! every interval% calls.
'
SUB Delay (Time!, Interval%)

STATIC YesPause%     'save YesPause%
IF YesPause% >= Interval% THEN     'if YesPause% is bigger than Interval%, then pause for Time!
    T! = TIMER
    DO
         ClearBuffer     'clear keyboard buffer to avoid annoying beep
         IF TIMER - T! < 0 THEN T! = TIMER
    LOOP UNTIL TIMER - T! >= Time!
    YesPause% = 0
END IF
IF Interval% > 0 THEN YesPause% = YesPause% + 1

END SUB

'uses information in DemoButtons% to play demo
'
SUB Demo

DemoIndex% = 1
Level% = 0
Speed% = 15
InitPlay     'initialize variables
DO
     BlockX% = 3            'reset block variables
     BlockY% = -1
     BlockRotation% = 1
     BlockIncCount% = 0
     IF DemoIndex% + 1 > MaxDemo% OR DemoIndex% + 2 > MaxDemo% THEN Delay 1, 0: EXIT SUB
     CurrentBlock% = DemoButtons%(DemoIndex% + 1)
     NextBlock% = DemoButtons%(DemoIndex% + 2)
     ShowNextBlock          'display next block to be dropped
     Delay .2, 0
     ScanCode% = HitKey%
     DO
          PlaceBlock         'place block into well
          WellScreenDump     'dump well information to screen
          SELECT CASE DemoButtons%(DemoIndex%) 'get demo instruction
               CASE KeyLeft%
                    IF CanMove%(BlockX% - 1, BlockY%, BlockRotation%) = True% THEN BlockX% = BlockX% - 1
                    PlaceBlock
                    BlockInc HitBottom%
                    IF HitBottom% = True% THEN EXIT DO
                    Delay .01, 0
               CASE KeyRight%
                    IF CanMove%(BlockX% + 1, BlockY%, BlockRotation%) = True% THEN BlockX% = BlockX% + 1
                    PlaceBlock
                    BlockInc HitBottom%
                    IF HitBottom% = True% THEN EXIT DO
                    Delay .01, 0
               CASE KeyUp%
                    IF BlockRotation% < 4 THEN
                         IF CanMove%(BlockX%, BlockY%, BlockRotation% + 1) = True% THEN
                              BlockRotation% = BlockRotation% + 1
                              IF BlockRotation% = 5 THEN BlockRotation% = 1
                              PLAY BlockSpin$
                         END IF
                         BlockInc HitBottom%
                         IF HitBottom% = True% THEN EXIT DO
                    ELSEIF BlockRotation% = 4 THEN
                         IF CanMove%(BlockX%, BlockY%, 1) = True% THEN
                              BlockRotation% = BlockRotation% + 1
                              IF BlockRotation% = 5 THEN BlockRotation% = 1
                              PLAY BlockSpin$
                         END IF
                         BlockInc HitBottom%
                         IF HitBottom% = True% THEN EXIT DO
                    END IF
                    PlaceBlock
                    BlockInc HitBottom%
                    IF HitBottom% = True% THEN EXIT DO
                    Delay .1, 0
               CASE KeyDown%
                    RemoveBlock
                    IF CanMove%(BlockX%, BlockY% + 1, BlockRotation%) = False% THEN EXIT DO
                    IF CanMove%(BlockX%, BlockY% + 1, BlockRotation%) = True% THEN BlockY% = BlockY% + 1
                    PlaceBlock
          END SELECT
          Delay .01, 0
          IF DemoButtons%(DemoIndex%) <> KeyDown% THEN
               BlockInc HitBottom%
               IF HitBottom% = True% THEN EXIT DO
          END IF
          IF HitKey% <> ScanCode% THEN EXIT SUB
          IF DemoIndex% + 3 > MaxDemo% THEN Delay 1, 0: EXIT SUB
          DemoIndex% = DemoIndex% + 3
     LOOP
     DemoIndex% = DemoIndex% + 3
     ScoreUp NumSquares%             'block has dropped; increment score by number of squares in current block
     PlaceBlock                     'put block in well
     WellScreenDump                 'draw all blocks in well
     PLAY BlockDrop$                'make sound effects for dropped block
     CheckRows                      'check to see if player has completed any lines
     ShowStatus                     'display score, number of lines completed, and level
LOOP

END SUB

SUB DisplayHighScores (HighLight%)

    FOR i = 0 TO 255
        OUT &H3C8, i
        OUT &H3C9, 0
        OUT &H3C9, 0
        OUT &H3C9, 0
    NEXT i
    LINE (0, 0)-(319, 199), 32, BF
    FOR i = 1 TO 10
        IF i = HighLight% THEN
            Font STR$(i) + ".", 60, 40 + i * 10, 1, 1, 0, 11
            Font HighScores(i).NameStr + "....." + STR$(HighScores(i).Score), 95, 40 + i * 10, 1, 1, 0, 11
        ELSE
            Font STR$(i) + ".", 60, 40 + i * 10, 1, 1, 0, 15
            Font HighScores(i).NameStr + "....." + STR$(HighScores(i).Score), 95, 40 + i * 10, 1, 1, 0, 15
        END IF
    NEXT i
    PY = 0
    Font "High Scores:", 70, 20, 2, 1, 0, 15
    FOR X = 0 TO 320 STEP 16
        LINE (X, PY)-STEP(15, 0), 25
        LINE (X + 15, PY)-STEP(0, 12), 25
        LINE (X, PY)-STEP(0, 12), 23
        LINE (X, PY + 12)-STEP(15, 0), 23
        LINE (X + 1, PY + 1)-STEP(13, 10), 40, BF

        LINE (X, PY + 187)-STEP(15, 0), 25
        LINE (X + 15, PY + 187)-STEP(0, 12), 25
        LINE (X, PY + 187)-STEP(0, 12), 23
        LINE (X, PY + 12 + 187)-STEP(15, 0), 23
        LINE (X + 1, PY + 1 + 187)-STEP(13, 10), 40, BF
    NEXT X
    PALETTE
    WHILE INKEY$ = "": WEND

END SUB

'draws well borders
'
SUB DrawWell

col% = 31
FOR i = 0 TO 9
     col% = col% - 1
     LINE (0, i)-(320, i), col%
NEXT i
col% = 31
FOR i = 72 TO 81
     col% = col% - 1
     LINE (i, 10)-(i, 200), col%
NEXT i
col% = 20
FOR i = 232 TO 241
     col% = col% + 1
     LINE (i, 10)-(i, 200), col%
NEXT i
col% = 20
FOR i = 192 TO 201
     col% = col% + 1
     LINE (0, i)-(320, i), col%
NEXT i

END SUB

'prints strng$ to screen in one of SCREEN 13's many black attributes
'and then scales it by XF! and YF! and increments the image by SX%, SY%
'it makes a shadow background with C2%
'
SUB Font (strng$, SX%, SY%, XF!, YF!, C%, C2%)

LOCATE 1, 1
PRINT SPACE$(LEN(strng$) + 1)     'clear space for printing
LOCATE 1, 1
COLOR 16
PRINT strng$     'print strng$ in one of SCREEN 13's many black attributes
FOR Y = 0 TO 7
     FOR X = 0 TO (LEN(strng$) * 8)
          IF POINT(X, Y) <> 0 THEN     'if the pixel at x, y is not black, scale it.
               X2 = X * XF!
               Y2 = Y * YF!
               LINE (X2 + SX%, Y2! + SY%)-STEP(XF! - .5, YF! - .5), C%, BF
               LINE (X2 + (SX% - 1), Y2! + (SY% - 1))-STEP(XF! - .5, YF! - .5), C2%, BF
               ClearBuffer
          END IF
     NEXT X
NEXT Y

END SUB

DEFINT A-Z
'tells player that his/her game is over
'
SUB GameOver (Branch%)

WellClear 127
WellScreenDump
Font "GAME OVER", 120, 90, 1, 3, 0, 15
HighScoresDisplayed% = 0
FOR i = 1 TO 10
    IF Score& >= HighScores(i).Score THEN
        Font "High Score!", 120, 120, 1, 1, 0, 15
        COLOR 15
        DrawWell
        GetInput "Enter your name:", ScoreName$, 17, 10, 10
        FOR j = 10 TO i STEP -1
            IF j > 1 THEN HighScores(j) = HighScores(j - 1)
        NEXT j
        HighScores(i).NameStr = ScoreName$
        HighScores(i).Score = Score&
        DisplayHighScores i
        HighScoresDisplayed% = 1
        EXIT FOR
    END IF
NEXT i
Font "Play Again? Y/N", 98, 160, 1, 1, 0, 15
IF HighScoresDisplayed% = 1 THEN
    PY = 0
    Font "High Scores:", 70, 20, 2, 1, 0, 15
    FOR X = 0 TO 320 STEP 16
        LINE (X, PY)-STEP(15, 0), 25
        LINE (X + 15, PY)-STEP(0, 12), 25
        LINE (X, PY)-STEP(0, 12), 23
        LINE (X, PY + 12)-STEP(15, 0), 23
        LINE (X + 1, PY + 1)-STEP(13, 10), 40, BF

        LINE (X, PY + 187)-STEP(15, 0), 25
        LINE (X + 15, PY + 187)-STEP(0, 12), 25
        LINE (X, PY + 187)-STEP(0, 12), 23
        LINE (X, PY + 12 + 187)-STEP(15, 0), 23
        LINE (X + 1, PY + 1 + 187)-STEP(13, 10), 40, BF
    NEXT X
ELSE
    DrawWell
END IF
Delay .5, 0
Pkey$ = ""
DO
     Pkey$ = ""
     WHILE Pkey$ = "": Pkey$ = INKEY$: WEND
     Pkey$ = UCASE$(Pkey$)
LOOP UNTIL Pkey$ = "Y" OR Pkey$ = "N"
IF Pkey$ = "Y" THEN Branch% = 0 ELSE Branch% = 1
WellScreenDump

END SUB

DEFSNG A-Z
SUB GetInput (comment$, user.input$, Y%, X%, limit%)
  
LOCATE Y%, X%
PRINT comment$; user.input$; CHR$(95)
DO
     key$ = ""
     WHILE LEN(INKEY$): WEND
     WHILE key$ = "": key$ = INKEY$: WEND
     IF key$ = CHR$(13) THEN EXIT DO
     IF key$ = CHR$(8) AND LEN(user.input$) > 0 THEN
          user.input$ = LEFT$(user.input$, LEN(user.input$) - 1)
     END IF
     IF key$ <> CHR$(8) AND key$ <> CHR$(27) AND key$ <> CHR$(95) AND key$ <> CHR$(9) AND LEN(key$) = 1 THEN
          IF LEN(user.input$) < limit% THEN
               user.input$ = user.input$ + key$
          END IF
     END IF
     LOCATE Y%, X%
     PRINT comment$; user.input$; CHR$(95); " "
LOOP
LOCATE Y%, X% + LEN(comment$) + LEN(user.input$)
PRINT " "

END SUB

'gets scancode from keyboard port
'The extra code here may not seem necessary, but on some computers,
'the scancode is irregular for the arrow keys. This ignores all codes
'above 215.
'
FUNCTION HitKey%

STATIC PrevCode%     'save previous scancode
ScanCode% = INP(96)
IF ScanCode% > 215 THEN HitKey% = PrevCode% ELSE HitKey% = ScanCode%
IF ScanCode% <= 215 THEN PrevCode% = ScanCode%

END FUNCTION

SUB InitHighScores

    DEF SEG = VARSEG(HighScores(1))
    BLOAD "hiscore.hi", 0

END SUB

'initializes program for play and draws background
'
SUB InitPlay

LINE (0, 0)-(320, 200), 0, BF
Tog% = 1
FOR Y = 0 TO 200 STEP 10    'draws brick background
     Tog% = -Tog%
     FOR X = -20 TO 320 STEP 20
          IF Tog% > 0 THEN Brick% = 10 ELSE Brick% = 0
          LINE (X + Brick%, Y)-STEP(18, 8), 111, BF
          LINE (X + Brick%, Y)-STEP(18, 0), 25
          LINE ((X + Brick%) + 18, Y)-STEP(0, 8), 25
          LINE (X + Brick%, Y)-STEP(0, 8), 28
          LINE (X + Brick%, Y + 8)-STEP(18, 0), 28
     NEXT X
NEXT Y
LINE (0, 40)-(71, 109), 0, BF             'draws title and status bars
Font "QuadBLOX", 3, 45, 1, 3, 76, 170
Font "   by   ", 0, 70, 1, 1, 32, 26
Font "Derek", 15, 80, 1, 1, 32, 15
Font "Andrews", 7, 90, 1, 1, 32, 15
Font "vers 2.4", 3, 100, 1, 1, 32, 26
Font "Next:", 244, 33, 1, 1, 32, 15
Font "Score:", 244, 50, 1, 1, 32, 15
Font "Lines:", 244, 73, 1, 1, 32, 15
Font "Level:", 244, 95, 1, 1, 32, 15
DrawWell
Score& = 0
ClearLines% = 0
ClearedLines% = 0
ShowStatus
NewBlock
ShowNextBlock
CurrentBlock% = NextBlock%
WellClear BackGroundColor%
WellScreenDump

END SUB

'program startup---called ONCE
'
SUB InitProg

SCREEN 13           'set 320x200x256 res
RANDOMIZE TIMER     'use timer for random number seed
CLS                 'clear VRAM
ReadStyleData                 'read DATA into BlockStyles% array
ReadDemoData                  'read DATA into DemoButtons% array
InitHighScores                'init high score table
WellClear BackGroundColor%    'set elements in Well% to BackGroundColor%

END SUB

SUB Menu

StartMenu:
CLS
Tog% = 1
FOR Y = 0 TO 200 STEP 10    'draws brick background
     Tog% = -Tog%
     FOR X = -20 TO 320 STEP 20
          IF Tog% > 0 THEN Brick% = 10 ELSE Brick% = 0
          LINE (X + Brick%, Y)-STEP(18, 8), 111, BF
          LINE (X + Brick%, Y)-STEP(18, 0), 25
          LINE ((X + Brick%) + 18, Y)-STEP(0, 8), 25
          LINE (X + Brick%, Y)-STEP(0, 8), 28
          LINE (X + Brick%, Y + 8)-STEP(18, 0), 28
     NEXT X
NEXT Y
LINE (0, 0)-(320, 120), BackGroundColor%, BF
FOR Y = 18 TO 110 STEP 92
     FOR X = 0 TO 320 STEP 16
          IF Y = 110 THEN PY = Y - 1 ELSE PY = Y
          LINE (X, PY)-STEP(15, 0), 25
          LINE (X + 15, PY)-STEP(0, 12), 25
          LINE (X, PY)-STEP(0, 12), 23
          LINE (X, PY + 12)-STEP(15, 0), 23
          LINE (X + 1, PY + 1)-STEP(13, 10), 40, BF
     NEXT X
NEXT Y
FOR X = 0 TO 305 STEP 305
     FOR Y = 18 TO 120 STEP 13
          IF X = 305 THEN PX = X - 1 ELSE PX = X
          LINE (PX, Y)-STEP(15, 0), 25
          LINE (PX + 15, Y)-STEP(0, 12), 25
          LINE (PX, Y)-STEP(0, 12), 23
          LINE (PX, Y + 12)-STEP(15, 0), 23
          LINE (PX + 1, Y + 1)-STEP(13, 10), 40, BF
     NEXT Y
NEXT X
Selected% = 1
BoxCol% = 17
BoxColInc% = 1
LINE (95, 122)-(223, 200), 32, BF
col% = 30
FOR i = 95 TO 83 STEP -1
     col% = col% - 1
     LINE (i, 122)-(i, 200), col%
NEXT i
col% = 30
FOR i = 224 TO 236
     col% = col% - 1
     LINE (i, 122)-(i, 200), col%
NEXT i
Font "vers 2.4", 66, 35, .8, 1, 32, 26
Font "QuadBLOX", 17, 40, 4.4, 7, 76, 170
Font "created by Derek Andrews", 77, 100, .9, 1, 32, 15
StartGameY% = 136
StartLevelY% = 150
HighScoresY% = 164
ExitY% = 180
Font "Start Game", 115, StartGameY%, 1.2, 1, 0, 15
Font "Start Level", 100, StartLevelY%, 1.2, 1, 0, 15
Font STR$(StartLevel%), 200, StartLevelY%, 1.2, 1, 0, 42
Font "High Scores", 108, HighScoresY%, 1.2, 1, 0, 15
Font "Exit", 138, ExitY%, 1.2, 1, 0, 15
LINE (0, 0)-(320, 17), 32, BF
Time! = TIMER
DO
     IF TIMER - Time! < 0 THEN Time! = TIMER
     IF TIMER - Time! >= 15 THEN
          Demo
          GOTO StartMenu
     END IF
     BoxCol% = BoxCol% + BoxColInc%
     IF BoxCol% = 28 OR BoxCol% = 16 THEN BoxColInc% = -BoxColInc%
     Delay .01, 2
     SELECT CASE Selected%
          CASE 1
               LINE (113, StartGameY% - 3)-(212, StartGameY% + 8), BoxCol%, B
               LINE (112, StartGameY% - 4)-(213, StartGameY% + 9), BoxCol%, B
               LINE (98, StartLevelY% - 3)-(221, StartLevelY% + 8), 32, B
               LINE (97, StartLevelY% - 4)-(222, StartLevelY% + 9), 32, B
          CASE 2
               LINE (98, StartLevelY% - 3)-(221, StartLevelY% + 8), BoxCol%, B
               LINE (97, StartLevelY% - 4)-(222, StartLevelY% + 9), BoxCol%, B
               LINE (113, StartGameY% - 3)-(212, StartGameY% + 8), 32, B
               LINE (112, StartGameY% - 4)-(213, StartGameY% + 9), 32, B
               LINE (98, HighScoresY% - 3)-(221, HighScoresY% + 8), 32, B
               LINE (97, HighScoresY% - 4)-(222, HighScoresY% + 9), 32, B
          CASE 3
               LINE (98, HighScoresY% - 3)-(221, HighScoresY% + 8), BoxCol%, B
               LINE (97, HighScoresY% - 4)-(222, HighScoresY% + 9), BoxCol%, B
               LINE (98, StartLevelY% - 3)-(221, StartLevelY% + 8), 32, B
               LINE (97, StartLevelY% - 4)-(222, StartLevelY% + 9), 32, B
               LINE (136, ExitY% - 3)-(177, ExitY% + 8), 32, B
               LINE (135, ExitY% - 4)-(178, ExitY% + 9), 32, B
          CASE 4
               LINE (136, ExitY% - 3)-(177, ExitY% + 8), BoxCol%, B
               LINE (135, ExitY% - 4)-(178, ExitY% + 9), BoxCol%, B
               LINE (98, HighScoresY% - 3)-(221, HighScoresY% + 8), 32, B
               LINE (97, HighScoresY% - 4)-(222, HighScoresY% + 9), 32, B
     END SELECT
     SELECT CASE HitKey%
          CASE KeyUp%
               Time! = TIMER
               IF Selected% > 1 THEN
                    Delay .1, 0
                    Selected% = Selected% - 1
               END IF
          CASE KeyDown%
               Time! = TIMER
               IF Selected% < 4 THEN
                    Delay .1, 0
                    Selected% = Selected% + 1
               END IF
          CASE KeyLeft%
               Time! = TIMER
               IF Selected% = 2 THEN
                    IF StartLevel% > 0 THEN
                         Delay .2, 0
                         Font STR$(StartLevel%), 200, StartLevelY%, 1.2, 1, 32, 32
                         StartLevel% = StartLevel% - 1
                         Font STR$(StartLevel%), 200, StartLevelY%, 1.2, 1, 0, 42
                         LINE (0, 0)-(320, 17), 32, BF
                    END IF
               END IF
          CASE KeyRight%
               Time! = TIMER
               IF Selected% = 2 THEN
                    IF StartLevel% < 9 THEN
                         Delay .2, 0
                         Font STR$(StartLevel%), 200, StartLevelY%, 1.2, 1, 32, 32
                         StartLevel% = StartLevel% + 1
                         Font STR$(StartLevel%), 200, StartLevelY%, 1.2, 1, 0, 42
                         LINE (0, 0)-(320, 17), 32, BF
                    END IF
               END IF
          CASE Enter%
               Time! = TIMER
               IF Selected% = 1 THEN EXIT DO
               IF Selected% = 3 THEN
                   DisplayHighScores 0
                   GOTO StartMenu
               END IF
               IF Selected% = 4 THEN ResetScreen: SaveHighScores: END
     END SELECT
LOOP

END SUB

'randomly chooses current block
'
SUB NewBlock

STATIC PrevBlock%     'save previous block
DO     'this loop makes sure new block is different
     NextBlock% = INT((RND * NumStyles%) + 1)
LOOP UNTIL NextBlock% <> PrevBlock%
PrevBlock% = NextBlock%
BlockX% = 3            'reset block variables
BlockY% = -1
BlockRotation% = 1
BlockIncCount% = 0

END SUB

'returns number of colored squares in current block
'
FUNCTION NumSquares%

SquareCount% = 0
FOR Y = 1 TO StyleHeight%
     FOR X = 1 TO StyleWidth%
          IF BlockStyles%(X, Y, BlockRotation%, CurrentBlock%) <> BackGroundColor% THEN SquareCount% = SquareCount% + 1
     NEXT X
NEXT Y
NumSquares% = SquareCount%

END FUNCTION

'places current block into Well% array according to BlockRotation%
'
SUB PlaceBlock

FOR Y = 1 TO StyleHeight%
     FOR X = 1 TO StyleWidth%
          IF BlockStyles%(X, Y, BlockRotation%, CurrentBlock%) <> BackGroundColor% AND X + BlockX% >= 1 AND Y + BlockY% >= 1 AND X + BlockX% <= WellWidth% AND Y + BlockY% <= WellHeight% THEN
               Well%(X + BlockX%, Y + BlockY%) = BlockStyles%(X, Y, BlockRotation%, CurrentBlock%)
          END IF
     NEXT X
NEXT Y
                  
END SUB

'main play loop
'
SUB PlayGame

DO
StartGame:
     Menu         'invoke menu interface
StartPlay:
     Speed% = 15
     Level% = 0
     DO UNTIL Level% = StartLevel%
          IF Speed% > 3 THEN
               Speed% = Speed% - 1
               Level% = Level% + 1
          END IF
     LOOP
     InitPlay     'initialize variables
     DO
          NewBlock            'randomly choose block
          ShowNextBlock          'display next block to be dropped
          IF CanPlace%(BlockX%, BlockY%, BlockRotation%) = False% THEN
               GameOver Branch%
               IF Branch% = 0 THEN GOTO StartPlay
               IF Branch% = 1 THEN GOTO StartGame
          END IF
          Delay .2, 0
          DO
               PlaceBlock         'place block into well
               WellScreenDump     'dump well information to screen
               ClearBuffer        'clear keyboard buffer
               ScanCode% = HitKey%     'get keyboard scancode for anylization
               SELECT CASE ScanCode%  'anylize scancode
                    CASE KeyLeft%
                         IF CanMove%(BlockX% - 1, BlockY%, BlockRotation%) = True% THEN BlockX% = BlockX% - 1
                         PlaceBlock
                         BlockInc HitBottom%
                         IF HitBottom% = True% THEN EXIT DO
                         Delay .01, 0
                    CASE KeyRight%
                         IF CanMove%(BlockX% + 1, BlockY%, BlockRotation%) = True% THEN BlockX% = BlockX% + 1
                         PlaceBlock
                         BlockInc HitBottom%
                         IF HitBottom% = True% THEN EXIT DO
                         Delay .01, 0
                    CASE KeyUp%
                         IF BlockRotation% < 4 THEN
                              IF CanMove%(BlockX%, BlockY%, BlockRotation% + 1) = True% THEN
                                   BlockRotation% = BlockRotation% + 1
                                   IF BlockRotation% = 5 THEN BlockRotation% = 1
                                   PLAY BlockSpin$
                              END IF
                              BlockInc HitBottom%
                              IF HitBottom% = True% THEN EXIT DO
                         ELSEIF BlockRotation% = 4 THEN
                              IF CanMove%(BlockX%, BlockY%, 1) = True% THEN
                                   BlockRotation% = BlockRotation% + 1
                                   IF BlockRotation% = 5 THEN BlockRotation% = 1
                                   PLAY BlockSpin$
                              END IF
                              BlockInc HitBottom%
                              IF HitBottom% = True% THEN EXIT DO
                         END IF
                         PlaceBlock
                         BlockInc HitBottom%
                         IF HitBottom% = True% THEN EXIT DO
                         Delay .1, 0
                    CASE KeyDown%
                         RemoveBlock
                         IF CanMove%(BlockX%, BlockY% + 1, BlockRotation%) = False% THEN EXIT DO
                         IF CanMove%(BlockX%, BlockY% + 1, BlockRotation%) = True% THEN BlockY% = BlockY% + 1
                         PlaceBlock
                    CASE Pause%
                         RemoveBlock
                         WellScreenDump
                         Font "*PAUSED*", 125, 100, 1, 1, 0, 15
                         DrawWell
                         Pkey$ = ""
                         DO: ClearBuffer: LOOP UNTIL HitKey% > 100
                         DO
                              Pkey$ = ""
                              WHILE Pkey$ = "": Pkey$ = INKEY$: WEND
                              Pkey$ = UCASE$(Pkey$)
                         LOOP UNTIL Pkey$ = "P"
                         DO: ClearBuffer: LOOP UNTIL HitKey% > 100
                    CASE Quit%
                         RemoveBlock
                         WellScreenDump
                         Font "Quit? Y/N", 120, 100, 1, 1, 0, 15
                         DrawWell
                         Pkey$ = ""
                         DO: ClearBuffer: LOOP UNTIL HitKey% > 100
                         DO
                              Pkey$ = ""
                              WHILE Pkey$ = "": Pkey$ = INKEY$: WEND
                              Pkey$ = UCASE$(Pkey$)
                         LOOP UNTIL Pkey$ = "Y" OR Pkey$ = "N"
                         DO: ClearBuffer: LOOP UNTIL HitKey% > 100
                         IF Pkey$ = "Y" THEN GOTO StartGame
               END SELECT
               Delay .01, 0
               IF ScanCode% <> KeyDown% THEN
                    BlockInc HitBottom%
                    IF HitBottom% = True% THEN EXIT DO
               END IF
          LOOP
          ScoreUp NumSquares%            'block has dropped; increment score by number of squares in current block
          PlaceBlock                     'put block in well
          WellScreenDump                 'draw all blocks in well
          PLAY BlockDrop$                'make sound effects for dropped block
          CheckRows                      'check to see if player has completed any lines
          ShowStatus                     'display score, number of lines completed, and level
          CurrentBlock% = NextBlock%     'get next block
     LOOP
LOOP

END SUB

'reads DATA into DemoButtons% array
'
SUB ReadDemoData

FOR i = 1 TO MaxDemo%
     READ DemoButtons%(i)
NEXT i

END SUB

'read DATA into BlockStyles% array
'
SUB ReadStyleData

FOR S = 1 TO NumStyles%
     FOR R = 1 TO NumRotations%
          FOR Y = 1 TO StyleHeight%
               FOR X = 1 TO StyleWidth%
                    READ BlockStyles%(X, Y, R, S)
                    IF BlockStyles%(X, Y, R, S) = 0 THEN BlockStyles%(X, Y, R, S) = BackGroundColor%
               NEXT X
          NEXT Y
     NEXT R
NEXT S

END SUB

'removes current block from well
'
SUB RemoveBlock

FOR Y = 1 TO StyleHeight%
     FOR X = 1 TO StyleWidth%
          IF BlockStyles%(X, Y, BlockRotation%, CurrentBlock%) <> BackGroundColor% AND X + BlockX% >= 1 AND Y + BlockY% >= 1 AND X + BlockX% <= WellWidth% AND Y + BlockY% <= WellHeight% THEN
               Well%(X + BlockX%, Y + BlockY%) = BackGroundColor%
          END IF
     NEXT X
NEXT Y

END SUB

'resets screen for DOS
'
SUB ResetScreen

SCREEN 0: CLS
WIDTH 80, 25
COLOR 7, 0

END SUB

SUB SaveHighScores

    DEF SEG = VARSEG(HighScores(1))
    BSAVE "hiscore.hi", 0, 140

END SUB

'adds Increment% to Score&
'
SUB ScoreUp (Increment%)

IF Score& <= TopScore& AND Score& + Increment% <= TopScore& THEN Score& = Score& + Increment% ELSE Score& = TopScore&

END SUB

'displays next block to be used
'
SUB ShowNextBlock

IX% = 1     'index variables
IY% = 1
LINE (285, 16)-(317, 47), 20, BF
LINE (285, 15)-(318, 48), 4, B
FOR Y = 10 TO 34 STEP 8
     FOR X = 8 TO 32 STEP 8
          IF BlockStyles%(IX%, IY%, 1, NextBlock%) <> BackGroundColor% THEN
               LINE ((X + 277) + 2, (Y + 5) + 2)-STEP(5, 5), BlockStyles%(IX%, IY%, 1, NextBlock%), BF
               LINE ((X + 277) + 1, (Y + 5) + 1)-STEP(6, 0), 25
               LINE ((X + 277) + 8, (Y + 5) + 1)-STEP(0, 6), 25
               LINE ((X + 277) + 1, (Y + 5) + 1)-STEP(0, 7), 23
               LINE ((X + 277) + 1, (Y + 5) + 8)-STEP(7, 0), 23
          END IF
          IX% = IX% + 1
     NEXT X
     IX% = 1
     IY% = IY% + 1
NEXT Y

END SUB

'prints score and number of lines the player has completed
'
SUB ShowStatus

LINE (245, 60)-(320, 67), 20, BF
LINE (245, 59)-(320, 68), 4, B
Font LTRIM$(STR$(Score&)), 246, 61, 1.3, 1, 32, 15
LINE (245, 83)-(320, 90), 20, BF
LINE (245, 82)-(320, 91), 4, B
Font LTRIM$(STR$(ClearLines%)), 246, 84, 1.3, 1, 32, 15
LINE (245, 105)-(320, 112), 20, BF
LINE (245, 104)-(320, 113), 4, B
Font LTRIM$(STR$(Level%)), 246, 106, 1.3, 1, 32, 15
DrawWell

END SUB

'waits until player hits a key
'
SUB WaitUntilEvent

WHILE INKEY$ = "": WEND

END SUB

'clears all elements in Well% as colour%
'
SUB WellClear (colour%)

FOR Y = 1 TO WellHeight%
     FOR X = 1 TO WellWidth%
          Well%(X, Y) = colour%
     NEXT X
NEXT Y

END SUB

'dumps color info in Well% to screen
'
SUB WellScreenDump

IX% = 1     'index variables
IY% = 1
FOR Y = 10 TO 180 STEP 13     'dump loops
     FOR X = 82 TO 222 STEP 15
          IF Well%(IX%, IY%) = BackGroundColor% OR Well%(IX%, IY%) = 15 OR Well%(IX%, IY%) = 0 THEN
               LINE (X, Y)-STEP(14, 12), Well%(IX%, IY%), BF
          END IF
          IF Well%(IX%, IY%) <> BackGroundColor% AND Well%(IX%, IY%) <> 15 AND Well%(IX%, IY%) <> 0 THEN
               PSET (X, Y)
               DRAW "C25R14D12C23L14U12"
               LINE (X + 1, Y + 1)-STEP(12, 10), Well%(IX%, IY%), BF
          END IF
          IX% = IX% + 1
     NEXT X
     IX% = 1
     IY% = IY% + 1
NEXT Y

END SUB

