'
' wormy2.bas -
'  written by Jessac Mathias Baird
'
' contact me at: dos_programmer@yahoo.com
' visit FlyingSoft at: http://flyingsoft.zext.net
'
' the source to wormy v2 is here, all ready to run
' from the QuickBASIC IDE. Simply load the program
' with QuickBASIC like this: QB.EXE WORMY2 /L WORMY2
'
' i am not responsbile for alleged damages done to your
' computer by this code!! run at your own risk.
'
' ok! so here it is! i have actually commented some of
' the program.. i hope you can figure it out. about
' half-way through the project, i lost interest, so
' some of the code may be poorly optimised and unclear.
' but the program works, and i am satisfied. have fun!

DEFINT A-Z
REM $DYNAMIC

'/ -----------------------------
'/ global constant definitions:
'/ -----------------------------

 CONST false% = 0, true% = -1       '/ true/false conditionals

 CONST maxlevel% = 15                 '/ number of level sin the game..
 CONST maxlength% = 4800              '/ maximum length of the worm
 CONST maxapples% = 20                '/ number of apples on screen

 CONST slowspeed% = 80                '/ milli-seconds to delay on 'slow'
 CONST medspeed% = 70                 '/ ... for the medium speed
 CONST fastspeed% = 50                '/ ... and for the fast speed

 '/ directions for the worm segments...
 '/ the gfx for the tail traveling LEFT would be left%

 CONST up% = 1, down% = 2
 CONST left% = 3, right% = 4

 '/ constants for key codes used in the menu
 '/ system and in the game...

 CONST kup% = 72, kleft% = 75           '/ up and left cursor keys
 CONST kright% = 77, kdown% = 80        '/ right and down cursor keys
 CONST kpgup% = 73, kpgdown% = 81       '/ page up and page down

 '/ constants for the fm sounds played in the game:

 CONST sndgetapple% = 1                 '/ when the worm eats an apple
 CONST sndgainlife% = 2                 '/ when the user gains a life
 CONST sndmenuselect1% = 3              '/ selecting a menu item
 CONST sndcountdown% = 4                '/ timer count-down
 CONST sndmenumove% = 5                 '/ moving in the menu
 CONST sndmenuselect2% = 6               '/ menu selected

'/ -------------------------
'/ global type definitions:
'/ -------------------------

 '/ the type for the worm's segment, contains the
 '/ following: x,y location (horizontal, vertical), and direction (d):

 TYPE segt                      '/ type for the worm segments (3x3 on screen)
  x AS INTEGER                  '/ the x location in the MAP, not on screen
  y AS INTEGER                  '/ the y location in the MAP, not on screen
  d AS INTEGER                  '/ direction (see the CONSTANTS above)
 END TYPE                       '/ ... 6 bytes per array element

 TYPE pal13t                    '/ type for the virtual palette array
  r AS STRING * 1               '/ red component
  g AS STRING * 1               '/ green component
  b AS STRING * 1               '/ blue component
 END TYPE                       '/ ... 3 bytes per element, 768 bytes total

'/ -------------------------------
'/ global procedure declarations:
'/ -------------------------------

REM $INCLUDE: 'WORMY2.BI'

'/ ------------------------------
'/ global variable declarations:
'/ ------------------------------

 DIM SHARED hgfx%(0 TO 6, 1 TO 4)                    '/ gfx for worm head
 DIM SHARED tgfx%(0 TO 6, 1 TO 4)                    '/ gfx for worm tail
 DIM SHARED agfx%(0 TO 6, 0 TO 1)                    '/ gfx for the apple
 DIM SHARED bgfx%(0 TO 6, 1 TO 4, 0 TO 2)            '/ gfx for the body
 DIM SHARED block%(0 TO 6)                          '/ gfx for the walls
 DIM SHARED bg%(0 TO 201)                            '/ background tile

 DIM SHARED speed%                                   '/ game difficulty ?
 DIM SHARED timeon%                                  '/ keep track of time ?
 DIM SHARED sndon%                                   '/ sound on/off ?
 DIM SHARED musicon%                                 '/ music on/off ?
 DIM SHARED score%                                   '/ user's score ?
 DIM SHARED lives%                                   '/ user's life ?
 DIM SHARED growthrate%                              '/ growth rate ?
 DIM SHARED startlevel%                              '/ starting level ?
 DIM SHARED level%                                   '/ current level ?

 DIM SHARED pal13(0 TO 255) AS pal13t                '/ virtual palette array
 DIM SHARED font(32 TO 127, 0 TO 7) AS STRING * 1   '/ default font array

 DIM SHARED bufary%(0 TO 31999)                 '/ offscreen buffer, 64k
 DIM SHARED bufseg%, bufofs%                    '/ seg and ofs of bufary%

 REDIM SHARED worm(maxlength%) AS segt          '/ worm data
 REDIM SHARED snd(1 TO 20) AS STRING * 30       '/ sound data
 REDIM SHARED music%(16384)                     '/ music buffer (32k)

 REDIM SHARED map(1 TO 80, 1 TO 60) AS STRING * 1   '/ map array

'/ ------------------------------
'/ main code and local variables:
'/ ------------------------------

bufseg% = VARSEG(bufary%(0))    '/ get offscreen buffer's seg address
bufofs% = VARPTR(bufary%(0))    '/ and the buffer's offset address

DEF SEG = VARSEG(bg%(0))                '/ BLOAD the background tile
 BLOAD "GFX\BG.GFX", VARPTR(bg%(0))
DEF SEG

RANDOMIZE TIMER         '/ seed the random number generator

CALL init               '/ set up everything..

SCREEN 13

pal13put

DO
 SELECT CASE (domenu%)          '/ get info from the main menu
  CASE 1: CALL dogame           '/ returned 1 ? play the game
  CASE 2: CALL dooptions        '/ returned 2 ? show the options menu
  CASE 3: CALL dohiscores       '/ returned 3 ? show the high scores
  CASE 4: EXIT DO               '/ returned 4 ? exit to the OS
 END SELECT
LOOP

removetimer             '/ remove the new timer ISR

stopsong                '/ stop playing the song
closemusic              '/ remove the fm timer ISR

CLEAR
SCREEN 0: CLS
WIDTH 80, 25

PRINT " Qb Wormy v2 by Jessac Mathias Baird "
PRINT " Brought to you by FlyingSoft, 2000 "
PRINT
PRINT " email me: dos_programmer@yahoo.com"
PRINT " FlyingSoft url: http://flyingsoft.zext.net"
PRINT
PRINT

SYSTEM

'/ ---------------------------
'/ additional DATA statements:
'/ ---------------------------

'/ what follows is the data statements for the graphics
'/ used in the game. each is a 3x3 bitmapped graphic
'/ for screen mode 13h ... and each entry is one colour

DATA 120,122,124, 048,051,054, 048,051,054:      '/ head, up
DATA 054,051,048, 054,051,048, 124,122,120:      '/ head, down
DATA 124,054,054, 122,051,051, 120,048,048:      '/ head, left
DATA 048,048,120, 051,051,122, 054,054,124:      '/ head, right

DATA 048,051,054, 048,051,054, 120,124,122:      '/ tail, up
DATA 120,122,124, 054,051,048, 054,051,048:      '/ tail, down
DATA 054,054,120, 051,051,122, 048,048,124:      '/ tail, left
DATA 124,048,048, 122,051,051, 120,054,054:      '/ tail, right

DATA 048,051,054, 048,051,054, 048,051,054:      '/ body, up
DATA 054,054,054, 051,051,054, 048,051,054:      '/ body, up, left
DATA 048,048,048, 048,051,051, 048,051,054:      '/ body, up, right

DATA 054,051,048, 054,051,048, 054,051,048:      '/ body, down
DATA 054,051,048, 051,051,048, 048,048,048:      '/ body, down, left
DATA 054,051,048, 054,051,051, 054,054,054:      '/ body, down, right

DATA 054,054,054, 051,051,051, 048,048,048:      '/ body, left
DATA 048,051,054, 048,051,051, 048,048,048:      '/ body, left, up
DATA 054,054,054, 054,051,051, 054,051,048:      '/ body, left, down

DATA 048,048,048, 051,051,051, 054,054,054:      '/ body, right
DATA 048,051,054, 051,051,054, 054,054,054:      '/ body, right, up
DATA 048,048,048, 051,051,048, 054,051,048:      '/ body, right, down

DATA 035,038,035, 040,042,040, 040,042,040:      '/ red apple = 5 points
DATA 192,195,192, 197,199,197, 197,199,197:      '/ gold apple = 10 points

DATA 115,115,116, 115,116,117, 116,117,118:      '/ the wall gfx

REM $STATIC
'----------------------------------------------------------------------------
' doapples -
'  desc: puts the apples on the playing field
'----------------------------------------------------------------------------
SUB doapples

STATIC cnt%
STATIC x%, y%
STATIC redseg%, redofs%
STATIC goldseg%, goldofs%

 redseg% = VARSEG(agfx%(0, 0))
 redofs% = VARPTR(agfx%(0, 0))
 goldseg% = VARSEG(agfx%(0, 1))
 goldofs% = VARPTR(agfx%(0, 1))

 FOR cnt% = 1 TO maxapples%
  DO
   x% = INT(RND * 77) + 2
   y% = INT(RND * 47) + 2
  LOOP UNTIL (map(x%, y%) = " ")

  IF (INT(RND * 10) < 8) THEN
   map(x%, y%) = "1"
   gssolidput x% * 3, y% * 3, &HA000, 0, redseg%, redofs%
  ELSE
   map(x%, y%) = "2"
   gssolidput x% * 3, y% * 3, &HA000, 0, goldseg%, goldofs%
  END IF
 
 NEXT cnt%

END SUB

REM $DYNAMIC
'----------------------------------------------------------------------------
' doerror -
'  desc: exits to screen mode 3h, displays txt$,
'   waits for a key press, and terminates the program
'----------------------------------------------------------------------------
SUB doerror (txt$)

SCREEN 0: CLS
WIDTH 80, 25

PRINT txt$
PRINT
PRINT "Press any key to continue..."

WHILE (INKEY$ <> ""): WEND
WHILE (INKEY$ = ""): WEND

CLEAR
SYSTEM

END SUB

'----------------------------------------------------------------------------
' doapples -
'  desc: performs the game (kind of ... ) it loads levels,
'   but then it calls another routine to play that level
'----------------------------------------------------------------------------
SUB dogame

lives% = 3                      '/ reset number of lives
score% = 0                      '/ reset the score

level% = startlevel%            '/ get the first level from startlevel%

startgame:

'/ load a random song from the disk:

IF (musicon%) THEN
 tmp% = INT(RND * 2) + 1
 loadsong "SOUND\SONG0" + LTRIM$(STR$(tmp%)) + ".BAM" + CHR$(0)
END IF

'/ load the level from the disk:

IF (level% < 10) THEN getmap ("DATA\LEVEL0" + LTRIM$(STR$(level%) + ".MAP"))
IF (level% > 9) THEN getmap ("DATA\LEVEL" + LTRIM$(STR$(level%)) + ".MAP")

DO

 '/ draw the screen:

 drwscr
 drwbox 2, 155, 243, 198, 115, 115
 fontdrws "Level:" + STR$(level%), 10, 162, 48, 1, bufseg%, bufofs%
 fontdrws "Lives:" + STR$(lives%), 10, 174, 48, 1, bufseg%, bufofs%
 fontdrws "Score:" + STR$(score%), 90, 174, 48, 1, bufseg%, bufofs%
 fontdrws "Time:", 90, 162, 48, 1, bufseg%, bufofs%
 drwmap

 '/ alert the user to the level and wait for a keypress:

 drwbox 80, 60, 180, 105, 115, 115
 fontdrws "Level" + STR$(level%), 100, 70, 115, 1, bufseg%, bufofs%
 fontdrws "Press Enter", 88, 86, 115, 1, bufseg%, bufofs%
 gspcopy bufseg%, bufofs%, &HA000, 0


 DO: LOOP UNTIL (INKEY$ = CHR$(13))

 '/ draw the playing field

 drwmap
 gspcopy bufseg%, bufofs%, &HA000, 0

 '/ place the apples and play the level!

 doapples
 IF (doplay%) THEN
  level% = level% + 1
  IF (level% <= maxlevel%) THEN GOTO startgame
  lives% = -1
 END IF

LOOP UNTIL (lives% < 0)

IF (musicon%) THEN stopsong

'/ call the endgame procedure

endgame

END SUB

REM $STATIC
'----------------------------------------------------------------------------
' dohiscores -
'  desc: shows the high score menu !
'----------------------------------------------------------------------------
SUB dohiscores

STATIC ff%                                 '/ file handle variable
STATIC cnt%                                '/ counter
STATIC tmp$                                '/ temporary string
CONST dataf = "DATA\HISCORES.DAT"          '/ location of the file on disk

ff% = FREEFILE
OPEN dataf FOR BINARY AS #ff%

'/ make sure it was not erased...

IF (LOF(ff%) = 0) THEN
 CLOSE #ff%
 OPEN dataf FOR OUTPUT AS #ff%
  FOR cnt% = 1 TO 8
   PRINT #ff%, "No Entry,0"
  NEXT cnt%
END IF
CLOSE #ff%

'/ show the program section:

drwbox 80, 2, 239, 22, 116, 116
fontdrws "High Scores!", 999, 8, 95, -1, bufseg%, bufofs%
drwbox 40, 40, 279, 190, 116, 116
fontdrws "Press Any Key To Return", 999, 48, 116, 1, bufseg%, bufofs%

'/ draw the menu to the buffer:

OPEN dataf FOR INPUT AS #ff%

FOR cnt% = 1 TO 8
 INPUT #ff%, tmp$
 fontdrws tmp$, 49, 64 + (cnt% * 12), 52, 1, bufseg%, bufofs%
 INPUT #ff%, tmp$
 fontdrws tmp$, 270 - (LEN(tmp$) * 8), 64 + (cnt% * 12), 52, 1, bufseg%, bufofs%
NEXT cnt%

CLOSE #ff%

'/ copy the buffer, and wait for a key press:

gspcopy bufseg%, bufofs%, &HA000, 0

WHILE (INKEY$ <> ""): WEND
WHILE (INKEY$ = ""): WEND

END SUB

'---------------------------------------------------------------------------
' domenu% -
'  desc: it is the main menu at the beginning of the program. offers escape
'   to the option menu, or to play the game with the current options.
'  post: returns the option selected,
'   1 to play the game, 2 to options, 3 to exit the program
'---------------------------------------------------------------------------
FUNCTION domenu%

'/ local variables

DIM x%
DIM y%
DIM key$
DIM blockseg%
DIM blockofs%
REDIM menutxt$(1 TO 4)

'/ set up the menu text

menutxt$(1) = "Play Wormy!"
menutxt$(2) = "Game Options"
menutxt$(3) = "High Scores"
menutxt$(4) = "Exit Wormy"

drwscr

'/ draw the title

drwbox 80, 2, 239, 22, 116, 116
fontdrws "Main Menu", 999, 8, 95, -1, bufseg%, bufofs%
drwbox 50, 50, 269, 180, 116, 116

'/ print the menu to the user

FOR x% = 1 TO 4
 fontdrws menutxt$(x%), 999, x% * 16 + 60, 48, 1, bufseg%, bufofs%
NEXT x%

fontdrws "By Jessac Mathias Baird", 999, 154, 56, -1, bufseg%, bufofs%
fontdrws "See README.TXT For Help", 999, 166, 48, 0, bufseg%, bufofs%
gspcopy bufseg%, bufofs%, &HA000, 0

y% = 1

'/ draw a box around the menu item...

DO

 gsbox &HA000, 0, 60, (y% * 16) + 56, 259, (y% * 16) + 70, 15

 DO
  key$ = INKEY$
 LOOP UNTIL (key$ <> "")
 SELECT CASE key$
  CASE CHR$(0) + CHR$(kdown%)
   IF (y% < 4) THEN
    gsbox &HA000, 0, 60, (y% * 16) + 56, 259, (y% * 16) + 70, 116
     y% = y% + 1
    IF (sndon% = true) THEN sndplay sndmenumove%
   END IF
  CASE CHR$(0) + CHR$(kup%)
   IF (y% > 1) THEN
    gsbox &HA000, 0, 60, (y% * 16) + 56, 259, (y% * 16) + 70, 116
     y% = y% - 1
    IF (sndon% = true) THEN sndplay sndmenumove%
   END IF
  CASE CHR$(13), CHR$(32)
   IF (sndon% = true%) THEN sndplay sndmenuselect2%
   EXIT DO
  CASE CHR$(27)
   y% = 4: EXIT DO
 END SELECT
LOOP

'/ exit with the menu option selected

domenu% = y%

'/ de-allocate the menutxt$ buffer

ERASE menutxt$

END FUNCTION

REM $DYNAMIC
SUB dooptions

'/ game options
'/  * sound: (on/off)
'/  * speed: (slow,fast,medium)
'/  * time: (infite,finite)
'/  * growth rate: (slow,fast)
'/  * main menu

'/ local variables

DIM x%
DIM y%
DIM spd%
DIM key$

SELECT CASE speed%
 CASE medspeed%: spd% = 1
 CASE fastspeed%: spd% = 2
 CASE ELSE: spd% = 0
END SELECT

'/ draw the title

drwbox 80, 2, 239, 22, 116, 116
fontdrws "Options", 999, 8, 95, -1, bufseg%, bufofs%
drwbox 40, 40, 279, 190, 116, 116
fontdrws "PgUp/PgDown To Change", 999, 48, 116, 1, bufseg%, bufofs%

y% = 1

'/ print the menu to the user

showoptions:

gsboxf bufseg%, bufofs%, 44, 60, 275, 7 * 16 + 54, 116

FOR x% = 1 TO 7
 SELECT CASE x%
  CASE 1
   key$ = "Music: "
    IF (musicon%) THEN key$ = key$ + "On" ELSE key$ = key$ + "Off"
  CASE 2
   key$ = "Sound: "
    IF (sndon%) THEN key$ = key$ + "On" ELSE key$ = key$ + "Off"
  CASE 3
   key$ = "Speed: "
    SELECT CASE (spd%)
     CASE 0
      speed% = slowspeed%
      key$ = key$ + "Slow"
     CASE 1
      speed% = medspeed%
      key$ = key$ + "Medium"
     CASE 2
      speed% = fastspeed%
      key$ = key$ + "Fast"
    END SELECT
  CASE 4
   key$ = "Time: "
    IF (timeon%) THEN key$ = key$ + "Finite" ELSE key$ = key$ + "Infinite"
  CASE 5
   key$ = "Growth Rate: "
    SELECT CASE growthrate%
     CASE 5: key$ = key$ + "Slow"
     CASE 8: key$ = key$ + "Fast"
    END SELECT
  CASE 6
   key$ = "Start Level:" + STR$(startlevel%)
  CASE 7
   key$ = "Main Menu"
  END SELECT
 fontdrws key$, 999, 54 + (x% * 16), 120, 0, bufseg%, bufofs%
NEXT x%

gsbox bufseg%, bufofs%, 55, 50 + (y% * 16), 264, 64 + (y% * 16), 15
gspcopy bufseg%, bufofs%, &HA000, 0

'IF (sndon%) THEN sndplay sndmenumove%

DO
 gsbox &HA000, 0, 55, 50 + (y% * 16), 264, 64 + (y% * 16), 15

 DO
  key$ = INKEY$
 LOOP UNTIL LEN(key$)
 WHILE (INKEY$ <> ""): WEND

 SELECT CASE key$
  CASE CHR$(27)
   EXIT DO
  CASE CHR$(13)
   IF (y% = 7) THEN EXIT DO
  CASE CHR$(0) + CHR$(kdown%)
   IF (y% < 7) THEN
    gsbox &HA000, 0, 55, 50 + (y% * 16), 264, 64 + (y% * 16), 116
    IF (sndon%) THEN sndplay sndmenumove%
    y% = y% + 1
   END IF
  CASE CHR$(0) + CHR$(kup%)
   IF (y% > 1) THEN
    gsbox &HA000, 0, 55, 50 + (y% * 16), 264, 64 + (y% * 16), 116
    IF (sndon%) THEN sndplay sndmenumove%
    y% = y% - 1
   END IF
 
  CASE CHR$(0) + CHR$(kpgup%), CHR$(0) + CHR$(kpgdown%)
   IF (sndon% = true%) THEN sndplay sndmenuselect1%
  
   SELECT CASE y%
    CASE 1: musicon% = NOT musicon%
    CASE 2: sndon% = NOT sndon%
    CASE 3: spd% = (spd% + 1) MOD 3
    CASE 4: timeon% = NOT timeon%
    CASE 5
     IF (growthrate% = 5) THEN growthrate% = 8 ELSE growthrate% = 5
    CASE 6
     IF ASC(RIGHT$(key$, 1)) = kpgup% THEN
      IF (startlevel% < maxlevel%) THEN startlevel% = startlevel% + 1
     ELSE
      IF (startlevel% > 1) THEN startlevel% = startlevel% - 1
     END IF
   END SELECT
 
IF (y% < 7) THEN GOTO showoptions


 END SELECT

LOOP

END SUB

REM $STATIC
'----------------------------------------------------------------------------
' doplay -
'  desc: performs the game for the current level
'  post: outcome of the game, if it has passed, etc
'----------------------------------------------------------------------------
FUNCTION doplay%

STATIC sec%                     '/ seconds passed during game play
STATIC timeleft%                '/ how much time will be left ?
STATIC numapples%               '/ number of apples on the screen
STATIC delayflag%               '/ whether to delay or not ?
STATIC oldscore%                '/  previous score, before updating it
STATIC tmpseg%, tmpofs%         '/ for the graphics
STATIC length%, growth%         '/ length of the snake, and growth rate

STATIC hloc%, newd%             '/ data from the 'head' of the worm
STATIC newx%, newy%

STATIC tloc%, tmpd%             '/ random data variables
STATIC tmpx%, tmpy%

sec% = speed%                   '/ set the speed (milli seconds)
timeleft% = 35 + level%                   '/ given the time left ...

length% = 0             '/ default length of the worm
hloc% = 0               '/ location of the 'head' in the worm array
growth% = 10            '/ default growth rate

newx% = 40              '/ position the worm
newy% = 49
newd% = up%

IF (score% = 0) THEN oldscore% = 0      '/ reset the oldscre
numapples% = maxapples%                 '/ apples have been drawn ?

clearkbd                '/ clear the keyboard buffer

DO
 delayflag% = true              '/ set the delay flag
 map(newx%, newy%) = "9"         '/ given the map an arbitrary value,
                                '/ of where the worm is in the map

 WAIT &H3DA, 8: WAIT &H3DA, 8, 8          '/ try to reduce flicker

 '/ draw the head graphics and the time counter:

 gssolidput newx% * 3, newy% * 3, &HA000, 0, VARSEG(hgfx%(0, newd%)), VARPTR(hgfx%(0, newd%))
 fontover STR$(timeleft%), 130, 162, 48, 115, &HA000, 0

 '/ put the body segment of the worm:

 IF (length% > 0) THEN
  tmpd% = 0
  tloc% = hloc% - 1
  IF (worm(tloc%).d% <> newd%) THEN
   tmpd% = newd%
   IF (tmpd% > 2) THEN tmpd% = tmpd% - 2
  END IF
  gssolidput worm(tloc%).x% * 3, worm(tloc%).y% * 3, &HA000, 0, VARSEG(bgfx%(0, worm(tloc%).d%, tmpd%)), VARPTR(bgfx%(0, worm(tloc%).d%, tmpd%))
  worm(tloc%).d% = newd%
 END IF

 '/ save the direction and location of the worm's head:

 worm(hloc%).d% = newd%
 worm(hloc%).x% = newx%
 worm(hloc%).y% = newy%

 '/ put the tail on the screen

 IF (growth = 0) THEN
  tloc% = hloc% - length%
  gssolidput worm(tloc%).x% * 3, worm(tloc%).y% * 3, &HA000, 0, VARSEG(tgfx%(0, worm(tloc%).d%)), VARPTR(tgfx%(0, worm(tloc%).d%))
 END IF

 '/ have all the apples been eaten ? yes; exit the function

 IF (numapples% = 0) THEN
  doplay% = 1
  EXIT FUNCTION
 END IF

 '/ get user input

 key$ = INKEY$
 IF (key$ <> "") THEN
  SELECT CASE key$
  CASE CHR$(27)
   lives% = -1
   EXIT DO
  CASE CHR$(0) + CHR$(kright%)
   IF (newd% = right%) THEN delayflag% = false
   IF (newd% <> left%) THEN newd% = right% ELSE clearkbd
  CASE CHR$(0) + CHR$(kleft%)
   IF (newd% = left%) THEN delayflag% = false
   IF (newd% <> right%) THEN newd% = left% ELSE clearkbd
  CASE CHR$(0) + CHR$(kup%)
   IF (newd% = up%) THEN delayflag% = false
   IF (newd% <> down%) THEN newd% = up% ELSE clearkbd
  CASE CHR$(0) + CHR$(kdown%)
   IF (newd% = down%) THEN delayflag% = false
   IF (newd% <> up%) THEN newd% = down% ELSE clearkbd
  CASE "p", "P"
   clearkbd
   gspcopy &HA000, 0, bufseg%, bufofs%
   fontdrws "Paused (P to Continue)", 999, 88, 16, 1, &HA000, 0
   DO: LOOP UNTIL UCASE$(INKEY$) = "P"
   gspcopy bufseg%, bufofs%, &HA000, 0
   msdelay 50
   clearkbd
  CASE ELSE
   clearkbd
  END SELECT
 END IF

 '/ test for the new directions:

 SELECT CASE newd%
  CASE up%: newy% = newy% - 1
  CASE down%: newy% = newy% + 1
  CASE right%: newx% = newx% + 1
  CASE left%: newx% = newx% - 1
 END SELECT

 '/ check if the user got an apple:

 SELECT CASE (map(newx%, newy%))
  CASE " "
  CASE "1", "2"
   score% = score% + 5
   IF (map(newx%, newy%) = "2") THEN score% = score% + 10
   IF (score% > 30000) THEN score% = 30000
   IF (sndon%) THEN sndplay 1
   IF (score% - oldscore% >= 300) THEN
    IF (sndon%) THEN sndplay sndgainlife%
    oldscore% = score%
    IF (lives% < 8) THEN lives% = lives% + 1
     fontover STR$(lives%), 58, 174, 48, 115, &HA000, 0
   END IF
  
    gsboxf &HA000, 0, 140, 170, 230, 186, 115
    fontdrws STR$(score%), 138, 174, 48, 1, &HA000, 0
   numapples% = numapples% - 1
   growth% = growth% + growthrate%
  CASE ELSE
   doplay% = 0                  '/ not an apple; the user dies
   lives% = lives% - 1
   EXIT FUNCTION
 END SELECT

 IF (delayflag%) THEN msdelay speed%    '/ call the milli-second delay

 '/ update the time remaining:

 IF (timeon%) THEN
  sec% = sec% + speed%
  IF (sec% >= 1000) THEN
   IF (timeleft% < 11) THEN IF (sndon%) THEN sndplay sndcountdown%
   sec% = speed%
   timeleft = timeleft% - 1
  END IF
  IF (timeleft% < 0) THEN
   CALL doapples
   timeleft% = 35 + level%
   numapples% = numapples% + maxapples%
  END IF
 END IF

 '/ reset data in the map array:
                         
 IF (growth% = 0) THEN
  tloc% = hloc% - length%
  tmpx% = worm(tloc%).x%
   tmpy% = worm(tloc%).y%
    map(tmpx%, tmpy%) = " "
   tmpx% = tmpx% * 3
  tmpy% = tmpy% * 3
  gsboxf &HA000, 0, tmpx%, tmpy%, tmpx% + 2, tmpy% + 2, 0
 END IF

 '/ is the worm growing ?

 IF (growth% > 0) THEN
  growth% = growth% - 1
  length% = length% + 1         '/ yes; increase the length
 END IF

 '/ if the head location in the worm array gets close
 '/ to exceeding the array bounds, then reset the worm:

 hloc% = hloc% + 1
 IF (hloc% = maxlength%) THEN
  hloc% = hloc% - length%
  FOR tmpx% = 0 TO length%
   worm(tmpx%).d% = worm(hloc%).d%
   worm(tmpx%).x% = worm(hloc%).x%
   worm(tmpx%).y% = worm(hloc%).y%
   hloc% = hloc% + 1
  NEXT tmpx%
  hloc% = length%
 END IF

LOOP

END FUNCTION

REM $DYNAMIC
'----------------------------------------------------------------------------
' drwbox -
'  desc: draws a graphical box with a small gradient
'----------------------------------------------------------------------------
SUB drwbox (x1%, y1%, x2%, y2%, bc%, c%)

DIM x%

FOR x% = 0 TO 3
 gsbox bufseg%, bufofs%, x1% + x%, y1% + x%, x2% - x%, y2% - x%, bc% + x%
NEXT x%

gsboxf bufseg%, bufofs%, x1% + 4, y1% + 4, x2% - 4, y2% - 4, c%

END SUB

'----------------------------------------------------------------------------
' drwmap -
'  desc: draws the map to the screen, with the walls
'----------------------------------------------------------------------------
SUB drwmap

STATIC x%, y%
STATIC blockseg%, blockofs%

blockseg% = VARSEG(block%(0))
blockofs% = VARPTR(block%(0))

drwbox 2, 2, 243, 153, 115, 0

'/ draws it to the off-screen buffer:

FOR y% = 2 TO 49
 FOR x% = 2 TO 79
  IF (map(x%, y%) = "0") THEN
   gssolidput x% * 3, y% * 3, bufseg%, bufofs%, blockseg%, blockofs%
  ELSE
   map(x%, y%) = " "
  END IF
 NEXT x%
NEXT y%

END SUB

REM $STATIC
DEFSNG A-Z
SUB drwscr

STATIC x%
STATIC y%
STATIC blockseg%
STATIC blockofs%

'/ draw all the background tiles

blockseg% = VARSEG(bg%(0))
blockofs% = VARPTR(bg%(0))

FOR y% = 0 TO 180 STEP 20
 FOR x% = 0 TO 300 STEP 20
  gssolidput x%, y%, bufseg%, bufofs%, blockseg%, blockofs%
 NEXT x%
NEXT y%

'/ write the title to the upper right

fontdrws "Qb Wormy", 250, 8, 89, -1, bufseg%, bufofs%
fontdrws "  Ver 2", 250, 20, 82, 1, bufseg%, bufofs%

END SUB

DEFINT A-Z
'----------------------------------------------------------------------------
' endgame -
'  desc: checks for a high score before exiting the game
'----------------------------------------------------------------------------
SUB endgame

DIM ff%
DIM cnt%
REDIM names$(1 TO 8)
REDIM scores%(1 TO 8)

CONST dataf = "DATA\HISCORES.DAT"

ff% = FREEFILE
OPEN dataf FOR BINARY AS #ff%
IF (LOF(ff%) = 0) THEN
 CLOSE #ff%: KILL dataf
 FOR cnt% = 1 TO 8
  names$(cnt%) = "No Entry"
  scores%(cnt%) = 0
 NEXT cnt%
ELSE
 CLOSE #ff%
 OPEN dataf FOR INPUT AS #ff%
 FOR cnt% = 1 TO 8
  INPUT #ff%, names$(cnt%)
  INPUT #ff%, scores%(cnt%)
 NEXT cnt%
 CLOSE #ff%
END IF

drwscr
drwbox 80, 2, 239, 22, 116, 116
fontdrws "Game Over", 999, 8, 95, -1, bufseg%, bufofs%
drwbox 40, 80, 279, 120, 116, 116
fontdrws "Final Score:" + STR$(score%), 999, 88, 16, 1, bufseg%, bufofs%
fontdrws "Press Enter", 999, 104, 116, 1, bufseg%, bufofs%
gspcopy bufseg%, bufofs%, &HA000, 0

clearkbd
DO: LOOP UNTIL LEN(INKEY$)

OPEN dataf FOR OUTPUT AS #ff%

num% = 0
FOR cnt% = 1 TO 8
 IF (score% > scores%(cnt%)) THEN
  IF (num% = 0) THEN
  drwbox 30, 80, 289, 120, 116, 116
  fontdrws "High Score! Enter Your Name:", 999, 88, 16, 1, bufseg%, bufofs%
  gspcopy bufseg%, bufofs%, &HA000, 0
  num% = 8
  WHILE (num% > cnt%)
   scores%(num%) = scores%(num% - 1)
   names$(num%) = names$(num% - 1)
   num% = num% - 1
  WEND

  scores%(cnt%) = score%
  names$(cnt%) = getname$(18, 104)

 END IF
 END IF

 PRINT #ff%, names$(cnt%); ","; LTRIM$(STR$(scores%(cnt%)))

NEXT

CLOSE #ff%

ERASE names$
ERASE scores%

dohiscores

END SUB

REM $DYNAMIC
'----------------------------------------------------------------------------
' fontdrw by J Mathias Baird -
'  desc: i have made some font routines and placed a few subs of them here.
'   this particular sub will draw txt$ to any pixel at (x%,y%) of colour c%,
'
'  note: i have modified this from its original
'----------------------------------------------------------------------------
SUB fontdrw (txt$, x%, y%, c%, cd%, dseg%, dofs%)

'/ local variables:
                               
STATIC col%
STATIC char%, byte%
STATIC xloc%, yloc%
STATIC ch%, y1%

'/ local code:

xloc% = x%
IF (xloc% = 999) THEN xloc% = 160 - ((LEN(txt$) \ 2) * 8)

FOR ch% = 1 TO LEN(txt$)
 col% = c%
 char% = ASC(MID$(txt$, ch%, 1))      '/ get the character's ascii value

 '/ y1% loops through the 8 bytes containing this
 '/ character's binary data.. each bit set in the byte%
 '/ means that the pixel is to be drawn

 IF ((char% > 32) AND (char% < 127)) THEN

  yloc% = y%                             '/ start at the y% vertical pixel
  FOR y1% = 0 TO 7
   byte% = ASC(font(char%, y1%))    '/ get this row's binary data

   '/ check each bit and draw the pixel if it is set..
   '/ this is actually faster than an x loop..

   IF (1 AND byte%) THEN gspset (xloc% + 7), yloc%, dseg%, dofs%, col%
   IF (2 AND byte%) THEN gspset (xloc% + 6), yloc%, dseg%, dofs%, col%
   IF (4 AND byte%) THEN gspset (xloc% + 5), yloc%, dseg%, dofs%, col%
   IF (8 AND byte%) THEN gspset (xloc% + 4), yloc%, dseg%, dofs%, col%
   IF (16 AND byte%) THEN gspset (xloc% + 3), yloc%, dseg%, dofs%, col%
   IF (32 AND byte%) THEN gspset (xloc% + 2), yloc%, dseg%, dofs%, col%
   IF (64 AND byte%) THEN gspset (xloc% + 1), yloc%, dseg%, dofs%, col%
   IF (128 AND byte%) THEN gspset xloc%, yloc%, dseg%, dofs%, col%

   col% = col% + cd%
   yloc% = yloc% + 1             '/ go to the next row..
  NEXT y1%

 END IF

 xloc% = xloc% + 8      '/ move right 8 pixels on the screen
NEXT ch%

END SUB

SUB fontdrws (txt$, x%, y%, c%, cd%, dseg%, dofs%)

STATIC xloc%
xloc% = x%

IF (xloc% = 999) THEN
 xloc% = 160 - ((LEN(txt$) / 2) * 8)
END IF

fontdrw txt$, xloc% - 1, y%, 0, 0, dseg%, dofs%
fontdrw txt$, xloc% + 1, y%, 0, 0, dseg%, dofs%
fontdrw txt$, xloc%, y% - 1, 0, 0, dseg%, dofs%
fontdrw txt$, xloc%, y% + 1, 0, 0, dseg%, dofs%
fontdrw txt$, xloc%, y%, c%, cd%, dseg%, dofs%

END SUB

'----------------------------------------------------------------------------
' fontload by J Mathias Baird -
'  desc: loads the character set stored on disk under fontf$ into the
'   font array passed as fary()
'----------------------------------------------------------------------------
SUB fontload (fontf$)

DIM ff%
DIM ch%, y%
DIM ch1%, ch2%
DIM byte AS STRING * 1

ff% = FREEFILE

OPEN fontf$ FOR BINARY AS #ff%

IF (LOF(ff%) = 0) THEN
 CLS
 WIDTH 80, 25
  PRINT "ERROR: font file contains no data"
  PRINT "press any key to terminate..."
 WHILE (INKEY$ = ""): WEND
 CLOSE
 SYSTEM
END IF

GET #ff%, , byte
IF (ASC(byte) <> 255) THEN GOTO EndProc

GET #ff%, , byte
ch1% = ASC(byte)
GET #ff%, , byte
ch2% = ASC(byte)

IF (ch1% > ch2%) THEN GOTO EndProc

FOR ch% = ch1% TO ch2%
 FOR y% = 0 TO 7
  IF (EOF(ff%)) THEN GOTO EndProc
   GET #ff%, , font(ch%, y%)
 NEXT y%
NEXT ch%

EndProc:
CLOSE #ff%

END SUB

REM $STATIC
'----------------------------------------------------------------------------
' fontover -
'  desc: draws a font, and erases the background of it
'----------------------------------------------------------------------------
SUB fontover (txt$, x%, y%, c%, bc%, dseg%, dofs%)

xloc% = x%

IF (xloc% = 999) THEN
 xloc% = 160 - ((LEN(txt$) / 2) * 8)
END IF

gsboxf dseg%, dofs%, xloc% - 1, y% - 1, xloc% + (LEN(txt$) + 1) * 8, y% + 10, bc%
fontdrws txt$, x%, y%, c%, 1, dseg%, dofs%

END SUB

REM $DYNAMIC
SUB getmap (mapf$)

DIM x%
DIM y%
DIM ff%
DIM byte AS STRING * 1

ff% = FREEFILE
OPEN "B", ff%, mapf$

FOR y% = 1 TO 50
 FOR x% = 1 TO 80 STEP 2
  GET #ff%, , byte
  map(x%, y%) = CHR$(32)
  map(x% + 1, y%) = CHR$(32)
  IF (ASC(byte) AND &HF0) THEN map(x%, y%) = "0"
  IF (ASC(byte) AND &HF) THEN map(x% + 1, y%) = "0"
 NEXT x%
NEXT y%

CLOSE #ff%

END SUB

REM $STATIC
'----------------------------------------------------------------------------
' getname$ -
'  desc: a simple high-score input routine
'  post: the user's desired high-score name, or "Nobody"
'----------------------------------------------------------------------------
FUNCTION getname$ (maxlen%, yloc%)

DIM key$
DIM name$
DIM drawname%

name$ = ""

DO
 drawname% = false%
 DO
  key$ = INKEY$
 LOOP UNTIL LEN(key$)
 SELECT CASE ASC(key$)
  CASE 13: EXIT DO
  CASE 8
   IF (LEN(name$)) THEN
    name$ = LEFT$(name$, LEN(name$) - 1)
    drawname% = true%
   END IF
  CASE 32 TO 126
   IF (LEN(name$) < maxlen%) THEN
    name$ = name$ + key$
    drawname% = true%
   END IF
 END SELECT

 IF (drawname%) THEN
  fontover SPACE$(maxlen%), 999, yloc%, 16, 116, bufseg%, bufofs%
  fontdrws name$, 999, yloc%, 16, 1, bufseg%, bufofs%
  gspcopy bufseg%, bufofs%, &HA000, 0
 END IF

LOOP

IF (name$ = "") THEN name$ = "Nobody"
getname$ = name$

END FUNCTION

REM $DYNAMIC
SUB init

DIM x%
DIM y%
DIM cnt%
DIM dir%

SCREEN 0: CLS
WIDTH 80, 25

PRINT " Loading ... "
PRINT " Graphics ... "


RESTORE

'/ READ in the graphics for the head:

FOR cnt% = 1 TO 4
 CALL readgfx(VARSEG(hgfx%(0, cnt%)), VARPTR(hgfx%(0, cnt%)))
NEXT cnt%

'/ READ in the graphics for the tail:

FOR cnt% = 1 TO 4
 CALL readgfx(VARSEG(tgfx%(0, cnt%)), VARPTR(tgfx%(0, cnt%)))
NEXT cnt%

'/ READ in the graphics for each body part

FOR cnt% = 1 TO 4
 FOR dir% = 0 TO 2
  readgfx VARSEG(bgfx%(0, cnt%, dir%)), VARPTR(bgfx%(0, cnt%, dir%))
 NEXT dir%
NEXT cnt%

'/ READ in the graphics for the apples:

readgfx VARSEG(agfx%(0, 0)), VARPTR(agfx%(0, 0))
readgfx VARSEG(agfx%(0, 1)), VARPTR(agfx%(0, 1))

'/ READ in the graphics for the 'block' on the field:

readgfx VARSEG(block%(0)), VARPTR(block%(0))

'/ load the default palette and font:

PRINT " Font ... "

CALL fontload("GFX\DEF.FNT")

PRINT " Palette ... "

CALL pal13load("GFX\DEF.PAL")

'/ load the sound fx:

PRINT " Sounds ... "

SELECT CASE sndload%("SOUND\WORMY2.SND")
 CASE 0: doerror "Sound Loader: Error: file not found"
 CASE 1: doerror "Sound Loader: Unknown file format"
 CASE 2: doerror "Sound Loader: Advanced file format encountered"
END SELECT

'/ set the default variable values:

speed% = slowspeed%
startlevel% = 1
growthrate% = 5
timeon% = true
sndon% = false
musicon% = false

'/ set up the music buffer, and a given volume:

PRINT " Music ... "

setupmusic music%()
resetfm
setfmvol 10

'/ finally, install the new timer isr:

installtimer

PRINT : PRINT " Done."

END SUB

'----------------------------------------------------------------------------
' pal13load -
'  desc: loads a virtual palette from the disk, and executes it
'----------------------------------------------------------------------------
SUB pal13load (palf$)

DIM ff%
DIM col%
DIM byte AS STRING * 1

ff% = FREEFILE
OPEN "B", ff%, palf$
FOR col% = 0 TO 255
 OUT &H3C8, col%
 GET #ff%, , pal13(col%).r: OUT &H3C9, ASC(pal13(col%).r)
 GET #ff%, , pal13(col%).g: OUT &H3C9, ASC(pal13(col%).g)
 GET #ff%, , pal13(col%).b: OUT &H3C9, ASC(pal13(col%).b)
NEXT col%
CLOSE #ff%

END SUB

'---------------------------------------------------------------------------
' pal13put -
'  desc: puts the virtual palette to the screen
'---------------------------------------------------------------------------
SUB pal13put

FOR c% = 0 TO 255
 OUT &H3C8, c%
 OUT &H3C9, ASC(pal13(c%).r)
 OUT &H3C9, ASC(pal13(c%).g)
 OUT &H3C9, ASC(pal13(c%).b)
NEXT c%

END SUB

'----------------------------------------------------------------------------
' readgfx -
'  desc: reads a 3x3 data statement into memory by POKE and PEEK
'----------------------------------------------------------------------------
SUB readgfx (aryseg%, aryofs%)

DIM x%
DIM y%
DIM col%
DIM pixelofs&

DEF SEG = aryseg%
 POKE aryofs%, 3 * 8
 POKE aryofs% + 2, 3
 FOR y% = 0 TO 2
  pixelofs& = (y% * 3) + aryofs% + 4
  FOR x% = 0 TO 2
   READ col%
   POKE pixelofs&, col%
   pixelofs& = pixelofs& + 1
  NEXT x%
 NEXT y%
DEF SEG

END SUB

'----------------------------------------------------------------------------
' sndload% -
'  desc: loads a sound lab fm sound effects file from disk
'  post: success or failure; if failure, the error code
'----------------------------------------------------------------------------
FUNCTION sndload% (sndf$)

DIM ff%
DIM cnt%
DIM numsound%
DIM id AS STRING * 4
DIM temp AS STRING * 20

ff% = FREEFILE
OPEN sndf$ FOR BINARY AS #ff%
IF LOF(ff%) = 0 THEN
 sndload% = 0: EXIT FUNCTION
END IF

GET #ff%, , id
 IF MID$(id, 1, 2) <> "SL" THEN sndload% = 1: CLOSE #ff%: EXIT FUNCTION
 IF MID$(id, 3, 2) <> "10" THEN sndload% = 2: CLOSE #ff%: EXIT FUNCTION
GET #ff%, , numsound%

REDIM snd(1 TO numsound%) AS STRING * 30
FOR cnt% = 1 TO numsound%
 GET #ff%, , snd(cnt%)
 GET #ff%, , temp
NEXT cnt%
CLOSE #ff%

sndload% = -1

END FUNCTION

'----------------------------------------------------------------------------
' sndplay -
'  desc: plays fm music effect
'----------------------------------------------------------------------------
SUB sndplay (num%)

DIM i%
DIM ii%
DIM temp%

FOR i% = 1 TO 15
  OUT &H388, ASC(MID$(snd(num%), (i% * 2) - 1, 1))
  FOR ii% = 1 TO 6
   temp% = INP(&H388)
  NEXT ii%

  OUT &H389, ASC(MID$(snd(num%), (i% * 2)))
  FOR ii% = 1 TO 35
   temp% = INP(&H388)
  NEXT ii%
NEXT i%

END SUB

