// PONG
// Da 13 de Febrero por la tarde.
// Por OPA a.k.a NATHAN o como te de la gana.

// Compila en Borland C++ 3.1

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

#include "tempo.cpp"					// Clase temporizador de WOPR

#define FALSO 0
#define CIERTO 1

// Ratn

#define MOUSE_INT           0x33
#define MOUSE_RESET         0x00
#define MOUSE_GETPRESS      0x05
#define MOUSE_GETRELEASE    0x06
#define MOUSE_GETMOTION     0x0B
#define LEFT_BUTTON         0x00
#define RIGHT_BUTTON        0x01
#define MIDDLE_BUTTON       0x02

typedef short sword;                  /* signed word */
typedef short LOGICO;
typedef unsigned char  byte;
typedef unsigned short word;
typedef unsigned long  dword;

typedef struct            /* the structure for a mouse. */
{
	byte on;
	byte button1;
	byte button2;
	byte button3;
	int num_buttons;
	sword x;
	sword y;
} MOUSE;

void get_mouse_motion(sword *dx, sword *dy)
{
	union REGS regs;

	regs.x.ax = MOUSE_GETMOTION;
	int86(MOUSE_INT, &regs, &regs);
	*dx=regs.x.cx;
	*dy=regs.x.dx;
}

sword init_mouse(MOUSE *mouse)
{
	sword dx,dy;
	union REGS regs;

	regs.x.ax = MOUSE_RESET;
	int86(MOUSE_INT, &regs, &regs);
	mouse->on=regs.x.ax;
	mouse->num_buttons=regs.x.bx;
	mouse->button1=0;
	mouse->button2=0;
	mouse->button3=0;
	mouse->x=40;
	mouse->y=12;
	get_mouse_motion(&dx,&dy);
	return mouse->on;
}

char numeros[10][5][3]={   			// Nmeros gordos
							  {
								{1,1,1},
								{1,0,1},
								{1,0,1},
								{1,0,1},
								{1,1,1}
							  },{
								{0,1,0},
								{0,1,0},
								{0,1,0},
								{0,1,0},
								{0,1,0}
							  },{
								{1,1,1},
								{0,0,1},
								{1,1,1},
								{1,0,0},
								{1,1,1}
							  },{
								{1,1,1},
								{0,0,1},
								{0,1,1},
								{0,0,1},
								{1,1,1}
							  },{
								{1,0,1},
								{1,0,1},
								{1,1,1},
								{0,0,1},
								{0,0,1}
							  },{
								{1,1,1},
								{1,0,0},
								{1,1,1},
								{0,0,1},
								{1,1,1}
							  },{
								{1,0,0},
								{1,0,0},
								{1,1,1},
								{1,0,1},
								{1,1,1},
							  },{
								{1,1,1},
								{0,0,1},
								{0,0,1},
								{0,0,1},
								{0,0,1}
							  },{
								{1,1,1},
								{1,0,1},
								{1,1,1},
								{1,0,1},
								{1,1,1}
							  },{
								{1,1,1},
								{1,0,1},
								{1,1,1},
								{0,0,1},
								{1,1,1}
							  }
							 };


void pinta_numero(int,int,unsigned char);
void pinta_digito(int,int,unsigned char);
void pinta_punto(int,int);
void borra_punto(int,int);
void pinta_paddle(int,int);

void main(void)
{
	sword dx,dy;
	int i,j;
	int paddle1=10,paddle2=10;
	int puntos1=0,puntos2=0;
	int x,y,cx,cy;
	int mx,my;
	LOGICO terminado=FALSO;
	LOGICO acabado=FALSO;
	tempo temporizador;
	char basura;
	char ks[255], sc[255], du[255]; // Arrays utilizados para leer el teclado.

	// Ratn:

	MOUSE mouse;

	if (!init_mouse(&mouse))
	{
		printf("Mouse not found.\n");
		exit(1);
	}


	// INICIALIZO ARRAYS CON SCANCODES

	for(i=0;i<128;i++)
	{
		sc[i]=i;
		du[i]=1;
		ks[i]=0;
	}

	for(i=128;i<256;i++)
	{
		sc[i]=i-128;
		du[i]=0;
		ks[i]=0;
	}

	asm mov ax,0x01
	asm int 0x10

	temporizador.set_fps(24.2);

	// Ponemos la pantalla

	for(i=0;i<39;i++)
	{
		pinta_punto(i,0);
		pinta_punto(i,24);
	}
	for(i=1;i<39;i+=2)
	{
		pinta_punto(19,i);
	}

	pinta_numero(5,2,puntos1);
	pinta_numero(27,2,puntos2);

	// Empezamos

	cx=20;y=5;

	pinta_paddle(0,paddle1);
	pinta_paddle(38,paddle2);

	getch();

	do
	{
	// Nueva pelota. Qu direccin?

		if(random(2)==0)
		{
			mx=1;
			my=1;
			x=20;
			y=random(15)+1;
		}
		else
		{
			mx=-1;
			my=1;
			x=18;
			y=random(15)+1;
		}

		acabado=FALSO;

		pinta_paddle(0,paddle1);
		pinta_paddle(38,paddle2);

		do
		{

			// Muevo la pelota

			x+=mx;
			y+=my;

			// Colisiones:

			if(y==1 || y==23) my=-my;		// Con las paredes

			if(x==1 && y>=paddle1 && y<paddle1+4) mx=-mx;	// Con Paddle 1

			if(x==37 && y>=paddle2 && y<paddle2+4) mx=-mx;	// Con Paddle 1

			// Borro, pinto, actualizo:

			borra_punto(cx,cy);

			pinta_numero(5,2,puntos1);
			pinta_numero(27,2,puntos2);
			for(i=1;i<39;i+=2)
			{
				pinta_punto(19,i);
			}
			pinta_paddle(0,paddle1);
			pinta_paddle(38,paddle2);

			pinta_punto(x,y);
			cx=x;
			cy=y;

			// Vemos si puntua:

			if(x==0)	// Ooops: Punto para Paddle 2
			{
				puntos2++;
				if(puntos2==100)
				{
					puntos1=0;
					puntos2=0;
				}
				acabado=CIERTO;
			}

			if(x==38)	// Ooops: Punto para Paddle 1
			{
				puntos1++;
				if(puntos1==100)
				{
					puntos1=0;
					puntos2=0;
				}
				acabado=CIERTO;
			}

			// Muevo los paddles:

			for(i=0;i<255;i++)
				ks[i]=0;

			while(temporizador.leer()<1)
			{
				if(kbhit()) basura=getch();
				fflush(stdin);
				i=inportb(0x60);
				outportb(0x61,inportb(0x61) | 0x82);
				outportb(0x20,0x20);
				ks[sc[i]]=du[i];        	 // Leo las teclas pulsadas

				get_mouse_motion(&dx,&dy);

				if(dy<0)					// Paddle 2 arriba
					if(paddle2>1)
					{
						borra_punto(38,paddle2);
						borra_punto(38,paddle2+1);
						borra_punto(38,paddle2+2);
						borra_punto(38,paddle2+3);
						paddle2+=dy/20; if(paddle2<1) paddle2=1;
						pinta_paddle(38,paddle2);
					}

				if(dy>0)					// Paddle 2 abajo
					if(paddle2<19)
					{
						borra_punto(38,paddle2);
						borra_punto(38,paddle2+1);
						borra_punto(38,paddle2+2);
						borra_punto(38,paddle2+3);
						paddle2+=dy/20; if(paddle2>20) paddle2=20;
						pinta_paddle(38,paddle2);
					}
			}

			temporizador.reiniciar();

			if(ks[16]==1)					// Paddle 1 arriba
				if(paddle1>1)
				{
					paddle1--;
					pinta_paddle(0,paddle1);
					borra_punto(0,paddle1+4);
				}

			if(ks[44]==1)					// Paddle 1 abajo
				if(paddle1<19)
				{
					paddle1++;
					pinta_paddle(0,paddle1);
					borra_punto(0,paddle1-1);
				}

			if(ks[1]==1)
			{
				acabado=CIERTO;
				terminado=CIERTO;
			}

		}while(!acabado);

	}while(!terminado);

	getch();

	asm mov ax,0x03
	asm int 0x10

}

void pinta_numero(int x,int y, unsigned char numero)
{
	if(numero<10)
	{
		pinta_digito(x,y,0);
		pinta_digito(x+4,y,numero);
	}
	else
	{
		pinta_digito(x,y,numero/10);
		pinta_digito(x+4,y,numero%10);
	}
}

void pinta_digito(int x,int y, unsigned char digito)
{
	int i,j;

	for(i=0;i<5;i++)
		for(j=0;j<3;j++)
		{
			if(numeros[digito][i][j]==1)
				pinta_punto(x+j,y+i);
			else
				borra_punto(x+j,y+i);
		}
}

void pinta_punto(int x,int y)
{
	pokeb(0xB800,80*y+2*x,219);
	pokeb(0xB800,80*y+2*x+1,15);
}

void borra_punto(int x,int y)
{
	pokeb(0xB800,80*y+2*x,32);
	pokeb(0xB800,80*y+2*x+1,15);
}

void pinta_paddle(int x,int y)
{
	int i;

	for(i=0;i<4;i++)
		pinta_punto(x,y+i);
}