{xxx2das freeware 1998 v1.2 beta 2}
{$M 8192,90000,90000}
USES crt, dos;

type
  bytefile = file of byte;

const
  vers='1.2 beta 2 ';

  {import c64 plck engine map}
  trans: array[0..15] of byte =(
  16, 20, 3, 2, 56, 42, 86, 1, 9, 50, 87, 57, 6, 4, 37, 0);

  {table for guess a delay value for c64 map}
  {not very exact, since there is a different level delay!}
  transverz: array[0..15] of byte =(
  17, 17, 0, 0, 0, 0, 0, 0, 32, 32, 27, 17, 0, 0, 0, 0);

  {import Amiga engine map}
  transa: array[0..21] of byte =(
  0, 184, 57, 42, 16, 2, 3, 3, 1, 50, 9, 20, 56, 56, 87, 74, 86, 42, 4, 6, 37, 56);

  {patch to disable password protection in boulderoid gamefiles.    ;->      }
  thief: array[$2c..$3f] of byte =(               $09,$a0,$90,$49,
  $c7,$19,$2d,$4d,$3b,$e8,$59,$29,$20,$8b,$86,$5e,$64,$41,$46,$34);

  {import c64 bd1 engine map}
  bd2todas: array[0..63] of byte =(
   0,  1,  2,  3,  4,  5,255, 56,  9, 10, 11,  8, 13, 14, 15, 12,
  16, 17, 18, 19, 20, 21, 22, 23,255,255, 74, 75, 76, 77, 78, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40,255, 42, 43,255,255,255,255,
  50, 51, 48, 49, 54, 55, 52, 53, 80, 81, 87, 88, 86,  6,  7, 57);

  {import c64 plck engine effects}
  bdverz2das: array[0..63] of byte =(
   0,  1,  2,  3,  4,  5,255, 56, 13, 14, 15, 12, 13, 14, 15, 12,
  17, 17, 19, 19, 21, 21, 23, 23,255,255, 74, 75, 76, 77, 78, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40,255, 43, 43,255,255,255,255,
  54, 55, 52, 53, 54, 55, 52, 53, 81, 81, 88, 88, 86,  6,  7, 57);

  {import Boulderroid engine map}
  roid2das: array[0..127] of byte =(
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
    0,255,255,255,255,255,255,255,255,255,255,255,255,255,  1,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255, 49, 51,255,255, 86,255,  6,255,255,255,255,255,255,  9,
   37, 11,255,255,255,255, 46, 56,  4,255,255,255,255,255,255,255,
  255, 87, 48, 50, 20,255,255,255,255,255,255,255,255,  3,255,  8,
  255, 10, 16, 57,255,255, 44,  2, 42,255,255,255,255,255,255,255);

  {relative level pointers in c64-bd1-engine}
  bd1order: array[1..20] of longint =(
  $5806, $5808, $580a, $580c, $5826,
  $580e, $5810, $5812, $5814, $5828,
  $5816, $5818, $581a, $581c, $582a,
  $581e, $5820, $5822, $5824, $582c);

  {c64-bd1 name order}
  bd1names: string[20] =('ABCDQEFGHRIJKLSMNOPT');

var

  inp: bytefile;

  ins: text;

  out: text;

  done, names, slime, amoebe, filter, amsizer: boolean;

  a, b, c, d: byte;

  x, y, z: integer;

  db, i, j, k, l, fo: longint;

  r: real;

  s: string[12];

  roids: string[160];

Function Quelle(off:longint):string;
  var a,b,c,d:byte;
  begin
    if (not done) and (off<filesize(inp)) then begin
      seek(inp,off);
      read(inp,a);
      read(inp,b);
      read(inp,c);
      read(inp,d);
      Quelle:=chr(a)+chr(b)+chr(c)+chr(d);
    end else begin
      Quelle:='';
    end;
  end;

function right(s:string;n:integer):string;
  begin
    right:=copy(s,succ(length(s))-n,n);
  end;

function left(s:string;n:integer):string;
  begin
    left:=copy(s,1,n);
  end;

procedure support;
  begin
    writeln;
    writeln('  Supported file formats:');
    writeln('  -PC64 image');
    writeln('  -raw C64 RAM image');
    writeln('  -.Pxx files');
    writeln('  -raw C64 files (usually .PRG)');
    writeln('  -raw Amiga and PC files');
    writeln;
    writeln('  Supprted Boulder Dash types:');
    writeln('  -C64 BD1-engine games');
    writeln('  -C64 PLCK-engine games (most levelpacker*)');
    writeln('   For a GAM file run the game and make a RAM back up.');
    writeln('   In CCS64 press F12 to get the file C64.RAM, in PC64 press SHIFT-F11');
    writeln('  -C64 CAV/INT files*');
    writeln('  -Amiga CAV/INT files');
    writeln('  -Amiga GAM files');
    writeln('  -Boulderoid MAP files');
    writeln;
    writeln('  *: full Diego-effects support now.');
  end;

function ASC(s:char):integer; {not optimized}
  var
    i: integer;
  begin
    for i:=0 to 255 do begin
      if chr(i)=s then asc:=i;
    end;
  end;

Function Exist (as: String): Boolean;
  Var
    f: File;
  Begin
    {$I-}
    Assign(f, as);
    Reset(f);
    Close(f);
    {$I+}
    Exist := (IOResult = 0) and (as <> '');
  End;

function makestr(i:longint):string;
  var
    s:string;
  begin
    Str(i, s);
    makestr:=s;
  end;

procedure blueboxtext(s:string);
  var
    i:integer;
  begin
    textcolor(white);
    textbackground(blue);
    Write('');
    for i:=1 to length(s) do begin
      write('');
    end;
    write('');
    textbackground(black);
    writeln;
    textbackground(blue);
    Write('',s,'');
    textbackground(black);
    writeln;
    textbackground(blue);
    Write('');
    for i:=1 to length(s) do begin
      write('');
    end;
    Write('');
    textbackground(black);
    writeln;
    textcolor(lightgray);
  end;

function WordOfBCD(bcd:word):word;
  begin
    WordOfBCD:=(bcd and $f)
    + 10*((bcd div$10)and $f)
    + 100*((bcd div $100)and $f);
  end;

Procedure BoulderoidMap;
  var inter: integer;
  begin
    write('Converting Level: ');
    inter:=0;
    d:=0;
    assign(ins,paramstr(1));
    reset(ins);
    assign(out,paramstr(2));
    rewrite(out);
    writeln(out,'level');
    writeln(out,1);
    repeat
      readln(ins,roids);
      if roids='intermission' then begin
        inter:=1;
      end;
      if left(roids,5)='name ' then begin
        writeln(out,'name');
        writeln(out,right(roids,length(roids)-5));
      end;
      if left(roids,6)='width ' then begin
        writeln(out,'size');
        Val(right(roids,length(roids)-5),x,z);
        writeln(out,x);
        readln(ins,roids);
        Val(right(roids,length(roids)-6),y,z);
        writeln(out,y);
      end;
      if left(roids,8)='amrate1 ' then begin
        writeln(out,'amspeed');
        Val(right(roids,length(roids)-8),i,z);
        writeln(out,101-i);
        writeln(out,101-i);
      end;
      if left(roids,7)='amoeba ' then begin
        writeln(out,'ammax');
        Val(right(roids,length(roids)-7),i,z);
        writeln(out,round(x*y*(i-0.3)/100));
      end;
      if roids='mapstart' then begin
        writeln(out,'boxb');
        writeln(out,0);
        writeln(out,0);
        writeln(out,x);
        writeln(out,y);
        for j:=1 to y do begin
          readln(ins,roids);
          for i:=1 to x do begin
            writeln(out,roid2das[asc(roids[i])and 127]);
            if roid2das[asc(roids[i])and 127]=255 then d:=1;
          end;
        end;
      end;
      if left(roids,6)='delay ' then begin
        writeln(out,'delay');
        Val(right(roids,length(roids)-5),r,z);
        r:=i/280;
        if r<0.05 then r:=0.05;
        if r>1 then r:=1;
        writeln(out,r);
      end;
      if left(roids,5)='time ' then begin
        writeln(out,'time');
        writeln(out,right(roids,length(roids)-5));
      end;
      if left(roids,8)='require ' then begin
        writeln(out,'need');
        writeln(out,right(roids,length(roids)-8));
      end;
      if left(roids,8)='dpoints ' then begin
        writeln(out,'vor');
        writeln(out,right(roids,length(roids)-8));
      end;
      if left(roids,7)='dextra ' then begin
        writeln(out,'bonus');
        writeln(out,right(roids,length(roids)-7));
      end;
      if left(roids,10)='permeable ' then begin
        writeln(out,'slimed');
        writeln(out,right(roids,length(roids)-10));
      end;
      if left(roids,9)='milltime ' then begin
        writeln(out,'filterzeit');
        writeln(out,right(roids,length(roids)-9));
        writeln(out,'filtertype');
        writeln(out,0);
      end;
    until eof(ins);
    writeln(out,'cavetype');
    writeln(out,inter);
    writeln(out,'level');
    writeln(out,1);
    close(ins);
    close(out);
    if d>0 then write('(Cave contains unsupported items!)',#7);
    writeln('done.');
    done:=true;
  end;

procedure amigaparmsout(fo:longint);
  begin
    seek(inp,fo);
    read(inp,b);
    read(inp,c);
    read(inp,b);
    read(inp,c);
    a:=WordOfBCD($100*b+c);
    if a>0 then begin
      writeln(out,'time');
      writeln(out,a);
    end;
    read(inp,b);
    read(inp,c);
    a:=WordOfBCD($100*b+c);
    writeln(out,'need');
    writeln(out,a);
    read(inp,b);
    read(inp,c);
    a:=WordOfBCD($100*b+c);
    if a>0 then begin
      writeln(out,'vor');
      writeln(out,a);
    end;
    read(inp,b);
    read(inp,c);
    a:=WordOfBCD($100*b+c);
    if a>0 then begin
      writeln(out,'bonus');
      writeln(out,a);
    end;
    read(inp,b);
    read(inp,c);
    a:=WordOfBCD($100*b+c);
    if slime then begin
      writeln(out,'slimed');
      if a>0 then begin
        writeln(out,100-a);
      end else begin
        writeln(out,1);
      end;
    end;
    read(inp,b);
    read(inp,c);
    a:=WordOfBCD($100*b+c);
    if amoebe then begin
      writeln(out,'amtime');
      if a=0 then begin
        writeln(out,999);
      end else begin
        writeln(out,a);
      end;
    end;
    read(inp,b);
    read(inp,c);
    a:=WordOfBCD($100*b+c);
    if filter then begin
      writeln(out,'filtertype');
      writeln(out,0);
      writeln(out,'filterzeit');
      if a=0 then begin
        writeln(out,999);
      end else begin
        writeln(out,a);
      end;
    end;
    for a:=0 to 31 do read(inp,b);
  end;

Procedure Amigacave;
  begin
    assign(out,paramstr(2));
    rewrite(out);
    writeln(out,'level');
    writeln(out,1);
    writeln(out,'name');
    writeln(out,paramstr(1));
    writeln(out,'cavetype');
    if s='BDCA' then begin
      writeln(out,0);
    end else begin
      writeln(out,1);
    end;
    seek(inp,4);
    writeln(out,'boxb');
    writeln(out,0);
    writeln(out,0);
    writeln(out,40);
    writeln(out,22);
    seek(inp,$4+fo);
    for y:=0 to 39 do begin
      for x:=0 to 21 do begin
        read(inp,a);
        if a<22 then begin
          writeln(out,transa[a]);
        end else begin
          writeln('Level contains unsupported items!',#7);
          writeln(out,255);
        end;
        case a of
        6..7: filter:=true;
        14: amoebe:=true;
        2: slime:=true;
        end;
      end;
    end;
    amigaparmsout($374);
    writeln(out,'level');
    writeln(out,1);
    close(out);
    writeln('done.');
  end;

Procedure AmigaGame;
  begin
    assign(out,paramstr(2));
    rewrite(out);
    writeln('Converting Levels:');
    seek(inp,4);
    read(inp,b);
    read(inp,c);
    k:=pred(WordOfBCD($100*b+c));
    seek(inp,8);
    for i:=1 to k do begin
      if i>1 then write(',');
      if wherex>65 then writeln;
      write(' ',i);
      writeln(out,'level');
      read(inp,a);
      read(inp,a);
      read(inp,a);
      if (a=0) and (i>1) then begin
        writeln(out,-i);
        write('N');
      end else begin
        writeln(out,i);
        write('Y');
      end;
      writeln(out,'name');
      writeln(out,'Cave '+makestr(i));
      read(inp,a);
      writeln(out,'cavetype');
      if a=1 then begin
        writeln(out,0);
      end else begin
        writeln(out,1);
      end;
      filter:=true;
      amoebe:=true;
      slime:=true;
      amigaparmsout(filepos(inp));
      writeln(out,'boxb');
      writeln(out,0);
      writeln(out,0);
      writeln(out,40);
      writeln(out,22);
      read(inp,a);
      read(inp,a);
      db:=0;
      repeat
        read(inp,a);
        if a<>255 then begin
          if a<128 then begin
            inc(db);
            if a<22 then begin
              writeln(out,transa[a]);
            end else begin
              if wherex>37 then writeln;
              write('(Cave contains unsupported items!)',#7);
              writeln(out,255);
            end;
          end else begin
            a:=a and 127;
            read(inp,b);
            for j:=0 to b do begin
              inc(db);
              if a<22 then begin
                writeln(out,transa[a]);
              end else begin
                if wherex>37 then writeln;
                write('(Cave contains unsupported items!)',#7);
                writeln(out,255);
              end;
            end;
          end;
        end;
      until a=255;
      if db<>880 then begin
        if wherex>50 then writeln;
        write('(Cave has benn damaged!)',#7);
      end;
      r:=frac(filepos(inp)/2);
      if r>0 then read(inp,a);
    end;
    writeln(out,'level');
    writeln(out,1);
    close(out);
    writeln;
    writeln('done.');
  end;

procedure plc64caveout(fo:longint);
  var dl: word;
  begin
    dl:=0;
    slime:=false;
    amoebe:=false;
    filter:=false;
    writeln(out,'boxb');
    writeln(out,0);
    writeln(out,0);
    writeln(out,40);
    writeln(out,21);
    seek(inp,$14+fo);
    for y:=0 to 20 do begin
      for x:=0 to 19 do begin
        read(inp,a);
        b:=a div 16;
        c:=a and 15;
        writeln(out,trans[b]);
        writeln(out,trans[c]);
        dl:=dl+transverz[b]+transverz[c];
        case b of
        2: filter:=true;
        10: amoebe:=true;
        11: slime:=true;
        end;
        case c of
        2: filter:=true;
        10: amoebe:=true;
        11: slime:=true;
        end;
      end;
    end;
    seek(inp,$1da+fo);
    read(inp,a);
    writeln(out,'cavetype');
    if a>1 then a:=1;
    writeln(out,a);
    seek(inp,$1b8+fo);
    read(inp,a);
    writeln(out,'delay');
    writeln(out,(0.05+0.012*a+0*dl/10000));
    seek(inp,$1ba+fo);
    read(inp,a);
    if a>0 then begin
      writeln(out,'time');
      writeln(out,a);
    end;
    seek(inp,$1bc+fo);
    read(inp,a);
    writeln(out,'need');
    writeln(out,a);
    seek(inp,$1be+fo);
    read(inp,a);
    if a>0 then begin
      writeln(out,'vor');
      writeln(out,a);
    end;
    seek(inp,$1c0+fo);
    read(inp,a);
    if a>0 then begin
      writeln(out,'bonus');
      writeln(out,a);
    end;
    if slime then begin
      seek(inp,$1c2+fo);
      read(inp,a);
      writeln(out,'slimed');
      writeln(out,a);
      writeln(out,'slimetype');
      writeln(out,1);
    end;
    if amoebe then begin
      seek(inp,$1c4+fo);
      read(inp,a);
      writeln(out,'amtime');
      if a=0 then begin
        writeln(out,999);
      end else begin
        writeln(out,a);
      end;
    end;
    if filter then begin
      writeln(out,'filtertype');
      writeln(out,0);
      seek(inp,$1c6+fo);
      read(inp,a);
      writeln(out,'filterzeit');
      if a=0 then begin
        writeln(out,999);
      end else begin
        writeln(out,a);
      end;
    end;
    seek(inp,$1ef+fo);
    read(inp,a);
    if amsizer then begin
      if amoebe then begin
        writeln(out,'ammax');
        writeln(out,a);
      end;
      seek(inp,$1ea+fo);
      read(inp,a);
      writeln(out,'effect');
      writeln(out,201);
      writeln(out,bdverz2das[a]);
      read(inp,a);
      writeln(out,'effect');
      writeln(out,204);
      writeln(out,bd2todas[a]);
      read(inp,a);
      writeln(out,'effect');
      writeln(out,77);
      writeln(out,bdverz2das[a]);
      read(inp,a);
      if a=34 then begin
        writeln(out,'effect');
        writeln(out,1);
        writeln(out,41);
      end;
      read(inp,a);
      if a=46 then begin
        writeln(out,'effect');
        writeln(out,42);
        writeln(out,194);
      end;
    end;
  end;

function c64(off:longint):boolean;
  var done:boolean;
  begin
    done:=false;

    {CAV/INT?}
    if Quelle(off)=#0+#$be+#$44+#$44 then begin
      seek(inp,$1e7+off);
      read(inp,a);
      read(inp,b);
      read(inp,c);
      {Diego-Effects?}
      if (a=$20) and (b=$90) and (c=$46) then begin
        amsizer:=true;
        Writeln('Found an Effect Construction Kit Game.');
      end else begin
        amsizer:=false;
        Writeln('Found a Peter Liepa Construction Kit Game.');
      end;
      writeln('Converting Level.');
      assign(out,paramstr(2));
      rewrite(out);
      writeln(out,'level');
      writeln(out,1);
      writeln(out,'name');
      if s='C64F' then begin
        seek(inp,off-$12);
        s:='';
        for j:=1 to 16 do begin
          read(inp,a);
          if a<>0 then s:=s+chr(a);
        end;
      end else begin
        s:=paramstr(1);
      end;
      writeln(out,s);
      plc64caveout(2+off);
      writeln(out,'level');
      writeln(out,1);
      close(out);
      writeln('done.');
      done:=true;
    end;

    {PLCK in C64 ram image?}
    if Quelle($7000+off)=#$44+#$44+#$44+#$44 then begin
      seek(inp,$71e5+off);
      read(inp,a);
      read(inp,b);
      read(inp,c);
      if (a=$20) and (b=$90) and (c=$46) then begin
        amsizer:=true;
        Writeln('Found an Effect Construction Kit Game.');
      end else begin
        amsizer:=false;
        Writeln('Found a Peter Liepa Construction Kit Game.');
      end;
      seek(inp,$5e8c+off);
      read(inp,a);
      if (a=$19) or (a=$0e) then begin
        names:=false;
        writeln('Game has no cave names. Using Cave 1, Cave 2 etc..');
      end else begin
        names:=true;
      end;
      writeln('Converting Levels:');
      i:=0;
      assign(out,paramstr(2));
      rewrite(out);
      repeat
        inc(i);
        if i>1 then write(',');
        if wherex>65 then writeln;
        write(' ',i);
        writeln(out,'level');
        if names then begin
          seek(inp,$5e97+off+13*pred(i));
        end else begin
          seek(inp,$5e8b+off+pred(i));
        end;
        read(inp,a);
        if (a=$0e) and (i>1) then begin
          writeln(out,-i);
          write('N');
        end else begin
          writeln(out,i);
          write('Y');
        end;
        writeln(out,'name');
        if names then begin
          seek(inp,$5e8b+off+13*pred(i));
          s:='';
          for j:=1 to 12 do begin
            read(inp,a);
            if (a<>32) and (a<>0) then s:=s+chr(a);
          end;
          writeln(out,s);
        end else begin
          writeln(out,'Cave '+makestr(i));
        end;
        seek(inp,$7000+off+pred(i)*$200);
        read(inp,a);
        read(inp,b);
        read(inp,c);
        read(inp,d);
        if not((a=$44) and (b=$44) and (c=$44) and (d=$44)) then begin
          if wherex>50 then writeln;
          write('(Level ',i,' coul',#39,'t be damaged!)',#7);
        end;
        plc64caveout($7000+off+pred(i)*$200);
        if names then begin
          seek(inp,$5e97+off+13*i);
          end else begin
          seek(inp,$5e8b+off+i);
        end;
        read(inp,a);
      until ((a<>$19) and (a<>$0e)) or (i=48);
      writeln(out,'level');
      writeln(out,1);
      close(out);
      writeln(' done.');
      done:=true;
    end;

    {BD1-Engine?}
    if Quelle($5f3a+off)=#$44+#$44+#$48+#$48 then begin
      Writeln('Found a BD1-Engine Game.');
      writeln('Converting Levels:');
      i:=0;
      assign(out,paramstr(2));
      rewrite(out);
      repeat
        inc(i);
        if i>1 then write(',');
        if wherex>65 then writeln;
        write(' ',bd1names[i]);
        writeln(out,'level');
        if (i=5) or (i=10) or (i=15) or (i=20) then begin
          writeln(out,-i);
          write('N');
        end else begin
          writeln(out,i);
          write('Y');
        end;
        writeln(out,'name');
        writeln(out,paramstr(1),' Cave ',bd1names[i]);
        writeln(out,'cavetype');
        if (i=5) or (i=10) or (i=15) or (i=20) then begin
          writeln(out,1);
          writeln(out,'delay');
          writeln(out,'.08');
        end else begin
          writeln(out,0);
        end;
        seek(inp,bd1order[i]+off);
        read(inp,a);
        read(inp,b);
        k:=a;
        l:=b;
        fo:=k+$100*l+$582e+off;
        if fo<filesize(inp) then begin
          slime:=false;
          amoebe:=false;
          filter:=false;
          seek(inp,fo+28);
          read(inp,a);
          read(inp,b);
          read(inp,c);
          read(inp,d);
          if (a<>0) or (b<>0) or (c<>0) or (d<>0) then begin
            writeln(out,'wurf');
            seek(inp,fo+4);
            read(inp,a);
            writeln(out,a);
            seek(inp,fo+24);
            for j:=0 to 3 do begin
              read(inp,a);
              writeln(out,bd2todas[a]);
              b:=a and 63;
              case b of
              3: filter:=true;
              58..59: amoebe:=true;
              63: slime:=true;
              end;
              if bd2todas[b]=255 then begin
                if wherex>35 then writeln;
                write('(Cave ',bd1names[i],' contains unsupported items!)',#7);
              end;
           end;
             for j:=0 to 3 do begin
              read(inp,a);
              writeln(out,a);
            end;
          end;
          seek(inp,fo+32);
          repeat
            read(inp,a);
            b:=a and 63;
            case b of
            3: filter:=true;
            58..59: amoebe:=true;
            63:
              begin
                if a<>255 then slime:=true;
              end;
            end;
            if bd2todas[b]=255 then begin
              if wherex>35 then writeln;
              write('(Cave ',bd1names[i],' contains unsupported items!)',#7);
            end;
            case a of
            0..63:
              begin
                writeln(out,'set');
                writeln(out,bd2todas[b]);
                read(inp,c);
                writeln(out,c);
                read(inp,c);
                writeln(out,c-2);
              end;
            64..127:
              begin
                writeln(out,'line');
                writeln(out,bd2todas[b]);
                read(inp,c);
                writeln(out,c);
                read(inp,c);
                writeln(out,c-2);
                read(inp,c);
                writeln(out,c);
                read(inp,c);
                writeln(out,c);
              end;
            128..191:
              begin
                writeln(out,'boxp');
                writeln(out,bd2todas[b]);
                read(inp,c);
                writeln(out,c);
                read(inp,c);
                writeln(out,c-2);
                read(inp,c);
                writeln(out,c);
                read(inp,c);
                writeln(out,c);
                read(inp,c);
                writeln(out,bd2todas[c]);
                case c of
                3: filter:=true;
                58..59: amoebe:=true;
                63: slime:=true;
                end;
                if bd2todas[c]=255 then begin
                  if wherex>35 then writeln;
                  write('(Cave ',bd1names[i],' contains unsupported items!)',#7);
                end;
              end;
            192..254:
              begin
                writeln(out,'box');
                writeln(out,bd2todas[b]);
                read(inp,c);
                writeln(out,c);
                read(inp,c);
                writeln(out,c-2);
                read(inp,c);
                writeln(out,c);
                read(inp,c);
                writeln(out,c);
              end;
            end;
          until a=255;
          seek(inp,fo+1);
          read(inp,a);
          if filter then begin
            writeln(out,'filter');
            writeln(out,a);
            writeln(out,'filtertype');
            writeln(out,3);
          end;
          if amoebe then begin
            writeln(out,'amtime');
            writeln(out,a);
          end;
          read(inp,a);
          if a>0 then begin
            writeln(out,'vor');
            writeln(out,a);
          end;
          read(inp,a);
          if a>0 then begin
            writeln(out,'bonus');
            writeln(out,a);
          end;
          seek(inp,fo+9);
          read(inp,a);
          if a>0 then begin
            writeln(out,'need');
            writeln(out,a);
          end;
          seek(inp,fo+14);
          read(inp,a);
          if a>0 then begin
            writeln(out,'time');
            writeln(out,a);
          end;
          seek(inp,fo+22);
          read(inp,a);
          if slime then begin
            writeln(out,'slimed');
            writeln(out,a);
            writeln(out,'slimetype');
            writeln(out,1);
          end;
        end else begin
          if wherex>45 then writeln;
          write('(Cave ',bd1names[i],' is out of filerange!)',#7);
        end;
      until i=20;
      writeln(out,'level');
      writeln(out,1);
      close(out);
      writeln(' done.');
      done:=true;
    end;

    c64:=done;
  end;




{main}



begin
  done:=false;
  blueboxtext(' XXX to DAS - FREEWARE 1999 by Marek. '+vers);
  if (paramcount=1) and (paramstr(1)='-s') then begin
    support;
    halt(0);
  end;
  if (paramcount=3) and (paramstr(3)='-thief') then begin
    if not exist(paramstr(1)) then begin
      Writeln('File not found: ',paramstr(1));
      writeln(#7);
      halt(255);
    end;
    roids:=' /C copy >nul '+paramstr(1)+' '+paramstr(2)+' /y';
    Exec(GetEnv('COMSPEC'),roids);
    if not exist(paramstr(2)) then begin
      Writeln('Can not write: ',paramstr(2));
      writeln(#7);
      halt(255);
    end;
    assign(inp,paramstr(2));
    reset(inp);
    seek(inp,$2c);
    for i:=$2c to $3f do
      Write(inp,thief[i]);
    close(inp);
    halt(0);
  end;
  if paramcount<>2 then begin
    Writeln('Usage: [-s] XXX2DAS source.xxx target.DAS [-thief]');
    Writeln;
    Writeln(' -s     : List of supported formats.');
    Writeln(' -thief : Removes the password protection from an Boulderoid .GAM file.');
    Writeln('          With this switch a new Boulderoid file with same Levels will be');
    Writeln('          written. Boulderoid can descramble the new file without any');
    Writeln('          password so you will be able to extract all the maps included.');
    Writeln('          Use this switch on your own risk!');
    halt(0);
  end;
  if not exist(paramstr(1)) then begin
    Writeln('File not found: ',paramstr(1));
    writeln(#7);
    halt(255);
  end;
  assign(inp,paramstr(1));
  reset(inp);

  if Quelle(0)='C64I' then begin
    Writeln('PC64 RAM-Image detected.');
    s:='';
    done:=c64(9);
  end;

  if Quelle(0)='C64F' then begin
    Writeln('PC64 File-Image detected.');
    s:='C64F';
    done:=c64($1a);
  end;

  if (Quelle(0)='BDCA') or (Quelle(0)='BDIN') then begin
    done:=true;
    Writeln('Found an Amiga Construction Kit Cave or Intermission.');
    Amigacave;
  end;

  if Quelle(0)='BDGA' then begin
    done:=true;
    Writeln('Found an Amiga game sequence.');
    Amigagame;
  end;

  if not done then begin
    Writeln('Checking for raw C64 file.');
    s:='';
    done:=c64(0);
  end;

  if Left(Quelle(0),2)=#$23+#$20 then begin
    done:=true;
    Writeln('Found a Boulderoid MAP.');
    BoulderoidMap;
  end;

  if not done then begin
    writeln('Cannot convert: unknown Boulder Dash Engine or Fileformat!'+#7);
    support;
  end;
  close(inp);
End.