' Monster Maze level editor
' by John Wantland

' I created this program to help me with level creation.  After typing in
' my first maze by hand, I realized that it would be extremely difficult
' to make very many mazes.  At first, it was very sloppy and still required
' a lot of manual work to actually create a maze and use it in the game.
' After using it for a while, I thought that other people might want to
' create their own mazes, so I cleaned up the code and automated the maze
' creation process so that anyone could create a new maze.  I also "idiot-
' proofed" it, to prevent someone from accidently making a mistake that
' could crash the game.  Here are the instructions:
'
' This program will allow you to create new mazes for my maze game.
' Draw paths through the maze by clicking the left mouse button.
' Spacebar switches between draw and erase mode.
' c clears the screen and starts over.
' s saves your maze so you can edit it later.
' l loads a maze you have saved.
' w writes the maze into the MAZE.DAT file.  This way your maze will be
' included in the game.  It will become the last level, and you can make
' as many levels as you want.
' NOTE:  There is no way to modify mazes once you have written then to the
' MAZE.DAT file.  Also, there is no online help, but all the instructions
' are included above.  Be sure that you have at least one path from the
' upper-left corner to the exit in the lower-right corner, or the maze
' will be unbeatable.
DEFINT A-Z
DECLARE SUB getmouse (mode%)
DECLARE SUB initmouse ()
DECLARE SUB mouse (OnOff%)
DECLARE SUB readdata ()
DECLARE FUNCTION Interupt% (Num%, ax%, bx%, cx%, dx%)
DIM SHARED XCoord%, YCoord%, Click%
DIM SHARED ml%(45)
DIM maze(23, 35)

CLS
WIDTH 40
readdata
initmouse
getmouse mode%
mouse 1
mode = 1
GOSUB clean:
co = 1
DO
getmouse 0
x = INT(XCoord% / 16 + 1)
y = INT(YCoord% / 8 + 1)
IF x > 34 THEN x = 34
IF x < 2 THEN x = 2
IF y > 22 THEN y = 22
IF y < 2 THEN y = 2
IF mode = 2 AND Click% = 1 AND x > 1 AND x < 35 AND y > 1 AND y < 23 THEN LOCATE y, x: PRINT "": maze(y - 1, x - 1) = 1
IF mode = 1 AND Click% = 1 AND x > 1 AND x < 35 AND y > 1 AND y < 23 THEN LOCATE y, x: PRINT " ": maze(y - 1, x - 1) = 2
maze(1, 1) = 2: LOCATE 2, 2: COLOR 2: PRINT CHR$(1): COLOR 7
a$ = INKEY$
IF a$ = " " AND mode = 1 THEN mode = 2: GOTO skip
IF a$ = " " AND mode = 2 THEN mode = 1
IF LCASE$(a$) = "s" THEN GOSUB save:
IF LCASE$(a$) = "w" THEN GOSUB writ:
IF LCASE$(a$) = "c" THEN GOSUB clean:
IF LCASE$(a$) = "l" THEN GOSUB load:
skip:
LOOP UNTIL a$ = CHR$(27)
END

writ:
OPEN "maze.dat" FOR INPUT AS #1
OPEN "mazed.dat" FOR OUTPUT AS #2
INPUT #1, n
PRINT #2, n + 1
DO
LINE INPUT #1, a$
PRINT #2, a$
LOOP UNTIL (EOF(1))
CLOSE
OPEN "mazed.dat" FOR INPUT AS #1
OPEN "maze.dat" FOR OUTPUT AS #2
DO
LINE INPUT #1, a$
PRINT #2, a$
LOOP UNTIL (EOF(1))
CLOSE
OPEN "maze.dat" FOR APPEND AS #1
PRINT #1, CHR$(13)
FOR y = 0 TO 22
PRINT #1, "1";
FOR x = 1 TO 34
IF maze(y, x) = 1 THEN maze$ = "1" ELSE maze$ = "2"
PRINT #1, ","; maze$;
NEXT x
IF y <> 22 THEN PRINT #1, " "
NEXT y
CLOSE
LOCATE 1, 36: COLOR co, 0: PRINT "Saved": COLOR 7, 0: co = co + 1
IF co > 15 THEN co = 1
RETURN

save:
OPEN "mazesave.dat" FOR OUTPUT AS #1
FOR y = 0 TO 22
PRINT #1, "1";
FOR x = 1 TO 34
IF maze(y, x) = 1 THEN maze$ = "1" ELSE maze$ = "2"
PRINT #1, ","; maze$;
NEXT x
IF y <> 22 THEN PRINT #1, " "
NEXT y
CLOSE
LOCATE 1, 36: COLOR co, 0: PRINT "Saved": COLOR 7, 0: co = co + 1
IF co > 15 THEN co = 1
RETURN

load:
OPEN "mazesave.dat" FOR INPUT AS #1
FOR y = 0 TO 22
FOR x = 0 TO 34
INPUT #1, n
IF n = 1 THEN LOCATE y + 1, x + 1: PRINT "" ELSE LOCATE y + 1, x + 1: PRINT " "
maze(y, x) = n
NEXT x
NEXT y
CLOSE
RETURN

clean:
FOR x = 0 TO 34
FOR y = 0 TO 22
maze(y, x) = 1
LOCATE y + 1, x + 1: PRINT ""
NEXT y
NEXT x
maze(21, 34) = 0: LOCATE 22, 35: PRINT " "
RETURN

change:
MID$(a$, 10, LEN(STR$(n))) = STR$(n + 1)
n = 0
RETURN

MS.Data:               '<!--- WARNING - Do not change this... ---!>
 DATA 55,8b,ec,56,57
 DATA 8b,76,0c,8b,04
 DATA 8b,76,0a,8b,1c
 DATA 8b,76,08,8b,0c
 DATA 8b,76,06,8b,14
 DATA cd,21
 DATA 8b,76,0c,89,04
 DATA 8b,76,0a,89,1c
 DATA 8b,76,08,89,0c
 DATA 8b,76,06,89,14
 DATA 5f,5e,5d
 DATA ca,08,00
 DATA #

SUB getmouse (mode%)

  R% = Interupt%(&H33, 3, bx%, cx%, dx%)

  Click% = bx%

  IF mode% THEN
   XCoord% = cx% / 16 + 1
   YCoord% = dx% / 16 + 1
  ELSE
   XCoord% = cx%
   YCoord% = dx%
  END IF


END SUB

SUB initmouse

'Calls mouse interrupts...

 R% = Interupt%(&H33, 0, bx%, cx%, dx%)

END SUB

FUNCTION Interupt% (Num%, ax%, bx%, cx%, dx%)

 IF ml%(0) = 0 THEN   'Error, no MS.Data statment...
 BEEP
 BEEP
 END
 END IF

 DEF SEG = VARSEG(ml%(0))
 POKE VARPTR(ml%(0)) + 26, Num%

 CALL ABSOLUTE(ax%, bx%, cx%, dx%, VARPTR(ml%(0)))

 Interupt% = ax%


END FUNCTION

SUB mouse (OnOff%)

 IF OnOff% = 0 THEN OnOff% = 2 ELSE OnOff% = 1
 R% = Interupt%(&H33, OnOff%, bx%, cx%, dx%)

END SUB

SUB readdata

'Reads machine language thingy MS.Data...

RESTORE MS.Data
 DEF SEG = VARSEG(ml%(0))

 FOR i% = 0 TO 99
  READ Octet$
  IF Octet$ = "#" THEN EXIT FOR
  POKE VARPTR(ml%(0)) + i%, VAL("&H" + Octet$)
 NEXT i%

END SUB

