'********************************************************************
'  Soubor:     MAXRUBIN.BAS
'  Ucel:       vyukovy sachovy program
'  Projekt:    MiniMAX v jazyce QBasic (verze Max Rubin 1.0)
'  Kompilator: pro preklad do *.EXE souboru vyuzit QuickBasic 7.1
'  Autori:     D.Steinwender, Ch.Donninger (puvodni MiniMax 1.0)
'              P.Hase (Max Rubin ma navic graficke rozhrani, upravene
'              ovladani, zmeny v ocenovaci funkci, zmenene struktury dat,
'              malou knihovnu zahajeni a muze hrat i na casovy limit)
'  Datum:      01.05.2000 -  31.6.2000
'********************************************************************

' deklarace podprogramu
DECLARE SUB CistiRadek (odcisla%, docisla%)
DECLARE SUB KresliFiguru (x%, y%, figura%, Kurzor%)
DECLARE SUB KresliSachovnici ()
DECLARE SUB KresliDesku ()
DECLARE SUB TiskniRamecky ()
DECLARE SUB NapisKdoTahne (posltahy%)
DECLARE SUB ZmenaPoziceKurzoru (npk%)
DECLARE SUB PosunKurzoruSipkou (Ovladac$)
DECLARE SUB PrepoctiPoziciKurzoru (posun%)
DECLARE SUB ChybneZadani ()
DECLARE SUB VypisOvladani (Part%)
DECLARE SUB Initialisiere (Nova%)
DECLARE SUB KommandoSchleife ()
DECLARE SUB Vystup (i%)
DECLARE SUB MazZnak (Prikaz$)
DECLARE FUNCTION VstupKlavesnice% ()
DECLARE FUNCTION AlphaBeta% (Alpha%, Beta%, Distanz%)
DECLARE SUB GeneriereZuege (AlleZuege%)
DECLARE SUB ZugAusfuehren (AktZug%)
DECLARE SUB ZugZuruecknehmen (AktZug%)
DECLARE SUB KopiereHvar (AktZug%)
DECLARE FUNCTION AttackiertFeld% (Feld%, Seite%)
DECLARE FUNCTION BewerteStellung% (Alpha%, Beta%, Seite%)
DECLARE SUB InitBewertung ()
DECLARE SUB Brettausgabe (NurBrett%)
DECLARE SUB Computerzug ()
DECLARE SUB InitSpielbaum ()
DECLARE SUB ZeigeZug (AktZug%)
DECLARE SUB ZeigeHvar ()
DECLARE SUB DruckeZug (AktZug%)
DECLARE SUB DruckeStellung ()
DECLARE SUB DruckeZurueck ()
DECLARE FUNCTION Feldnotation$ (FeldNum%)
DECLARE FUNCTION Feldnummer% (Feldnot$)
DECLARE SUB NotiereUmwandlung (von%, nach%)
DECLARE SUB NotiereZug (von%, nach%)
DECLARE SUB NotiereSchlagzug (von%, nach%)
DECLARE SUB NotiereEpzug (von%, nach%, ep%)
DECLARE SUB Spielende ()
DECLARE SUB Stellungseingabe ()
DECLARE SUB Zugliste ()
DECLARE SUB ZugZurueck ()
DECLARE SUB LiesSteine (figura%, pole%)
DECLARE FUNCTION NaechstbesterZug% ()
DECLARE FUNCTION SBBewertung% (entwickelt%)
DECLARE FUNCTION WBBewertung% (entwickelt%)
DECLARE FUNCTION Zugeingabe% (Zug$)
DECLARE SUB Options (index%)
DECLARE SUB KeyBufferNull ()
DECLARE SUB PrehrajPartii (Pocettahu%, pomalu%)
DECLARE SUB Hodiny ()
DECLARE SUB VypisCasu (Cas%, barva%, radek%, sloupec%)
DECLARE SUB Vlajka ()
DECLARE FUNCTION ZapisFigury% (figura%, pole%)

'-------------------------------------------------------------------
'  definice datovych typu
'-------------------------------------------------------------------
' informace pro kazdy tah, vyuziva generator tahu
TYPE ZugTyp
   tah          AS INTEGER    ' informace o vychozim a cilovem poli
   extra        AS INTEGER    ' brani, rochada, premena, ep, tahy pescem
                              ' slouzi take k ukladani cisla tahu,
                              ' od ktereho je nutne hledat moznou remizu
                              ' opakovanim tahu nebo dle pravidla 50 tahu.
   wert         AS INTEGER    ' oceneni pro razeni tahu
END TYPE

' index pro figury v offsetovem seznamu - od jake pozice nacitat smery
' pohybu a zda smi pres vice poli
' (nutne pro generator tahu)
TYPE FigOffsetTyp
   Anfang       AS INTEGER
   ende         AS INTEGER
   Langschritt  AS INTEGER
END TYPE

' informace o konstelacich pescu a figur
TYPE BeideFarbenTyp
   Weiss        AS INTEGER
   Schwarz      AS INTEGER
END TYPE

' datova struktura pro ulozeni killer-tahu
TYPE KillerTyp
   Killer1      AS INTEGER
   Killer2      AS INTEGER
   Killer3      AS INTEGER
   Killer4      AS INTEGER
END TYPE

TYPE SezFigTyp
   pole         AS INTEGER  ' umisteni figury na desce, 0 -> mimo sachovnici
   pohyb        AS INTEGER  ' pohyb dane figury v seznamu pro detekci rochady
   figura       AS INTEGER  ' typ figury v seznamu
END TYPE

'--------------------------------------------------------------------
'  definice globalnich promennych a tabulek
'--------------------------------------------------------------------
DIM SHARED brett(119) AS INTEGER
DIM SHARED EpFeld(17) AS INTEGER
DIM SHARED PocetPescu AS INTEGER
DIM SHARED Promena AS INTEGER  'informace, ze na pozici 8 a vice se v seznamu
                                  'figur nachazi figura
DIM SHARED PozSez(17) AS INTEGER  'pozice brane figury, nebo
                                  'veze u rochady v seznamu figur
DIM SHARED ZugStapel(1000) AS ZugTyp
DIM SHARED SezFigBile(15) AS SezFigTyp   ' pro urychleni generatoru tahu a
DIM SHARED SezFigCerne(15) AS SezFigTyp  ' ocenovaci funkce.
DIM SHARED Rochade(2) AS INTEGER    ' zda byla hrana rochada
DIM SHARED index AS INTEGER         ' index v  zasobniku tahu
DIM SHARED StapelGrenze(17) AS INTEGER ' zasobnik tahu
DIM SHARED HVar(17, 17) AS INTEGER     ' tabulka hlavni varianty
DIM SHARED KillerTab(17) AS KillerTyp  ' tabulka killer-tahu

' tabulky pro ocenovaci funkci
DIM SHARED BKontrolle(119) AS BeideFarbenTyp ' pole pod kontrolou pescu
DIM SHARED Bauern(8 + 1) AS BeideFarbenTyp ' pocet pescu ve sloupci
DIM SHARED Tuerme(8 + 1) AS BeideFarbenTyp ' pocet vezi ve sloupci
DIM SHARED Mobilitaet(17) AS INTEGER   ' pohyblivost strelcu a vezi
DIM SHARED NachFeld(17) AS INTEGER     ' cilove pole
DIM SHARED MatBilanz(17) AS INTEGER ' materialni bilance z hlediska bileho
DIM SHARED MatSumme(17) AS INTEGER  ' celkovy material na desce (bez pescu,
                                    ' pro detekci koncovky)
DIM SHARED Farbe AS INTEGER         ' kdo je na tahu
DIM SHARED PocetHracu AS INTEGER    ' rezimy autoplay/partie/zadani
DIM SHARED MaxErweiterung AS INTEGER  ' rozsireni vyhledavaciho stromu
                                    ' na zaklade sachu se provadi jen do
                                    ' teto hloubky
DIM SHARED tiefe AS INTEGER         ' hloubka hledani z vychozi pozice
DIM SHARED LetzterZug AS INTEGER    ' naposledy provedeny tah
DIM SHARED InSchach AS INTEGER      ' strana na tahu stoji v sachu
DIM SHARED ZugNr AS INTEGER         ' pocet odehranych pultahu
DIM SHARED ZuletztWeiss AS INTEGER  ' pro rizeni tisku
DIM SHARED PoziceKurzoru AS INTEGER
DIM SHARED Preruseni AS INTEGER     ' ukonci podle situace (klavesa, cas)
                                    ' vypocet tahu
DIM SHARED Level AS INTEGER         ' slouzi jako cislo zaznamu v "level.dat",
                                    ' odkud bere udaje o nastaveni levelu
DIM SHARED BookIndex AS INTEGER     ' aktualni poradi zaznamu v knihovne zahajeni
DIM SHARED CasBily AS INTEGER
DIM SHARED CasCerny AS INTEGER
DIM SHARED Offset(15) AS INTEGER    ' tabulky pro generator tahu
DIM SHARED FigOffset(6) AS FigOffsetTyp 'tabulky pro typ tahu jednotlivych figur
DIM SHARED ZentrumTab(98) AS INTEGER  ' centralizacni tabulky pro figury
DIM SHARED wBFeldWert(88) AS INTEGER  ' centralizacni tabulky pro bile pesce
DIM SHARED sBFeldWert(88) AS INTEGER  ' centralizacni tabulky pro cerne pesce
DIM SHARED FigMaterial(6) AS INTEGER  ' materialni hodnota figur
DIM SHARED FigSymbol(6) AS STRING * 1
DIM SHARED DruckSymbol(6) AS STRING * 1

'--------------------------------------------------------------------
'  zde zacina samotny program
'--------------------------------------------------------------------
SCREEN 12
'ON ERROR GOTO NeosetrenaChyba
OPEN "maxrubin.ini" FOR RANDOM AS #4 LEN = 2
GET #4, 7, i%
IF i% = 0 THEN OPEN "vyst-cze.dat" FOR RANDOM AS #2 LEN = 24 'soubory textu pro
IF i% = 1 THEN OPEN "vyst-cze.dat" FOR RANDOM AS #2 LEN = 24 'jednotlive jazyky
IF i% = 2 THEN OPEN "vyst-cze.dat" FOR RANDOM AS #2 LEN = 24
OPEN "aktuagam.mru" FOR RANDOM AS #3 LEN = 2 'soubor se zaznamem posledni partie
OPEN "level.dat" FOR RANDOM AS #5 LEN = 2 'soubor s daty k jednotlivym levelum
OPEN "sour-xy.dat" FOR RANDOM AS #6 LEN = 2 'soubor s cisly souradnic
OPEN "maxrubin.teo" FOR RANDOM AS #7 LEN = 2 'knihovna zahajeni
OPEN "oceneni.mru" FOR RANDOM AS #1 LEN = 2 'soubor s daty pro ocenovaci funkci
RANDOMIZE TIMER  'nastaveni nahodneho cisla pro variabilitu v zahajeni
FOR i% = 0 TO 98
   GET #1, i% + 1, ZentrumTab(i%)
NEXT i%
FOR i% = 0 TO 88
   GET #1, i% + 100, wBFeldWert(i%)
NEXT i%
FOR i% = 0 TO 88
   GET #1, i% + 189, sBFeldWert(i%)
NEXT i%
FOR i% = 0 TO 6
   GET #1, i% + 278, FigMaterial(i%)
NEXT i%
FOR i% = 0 TO 15
   GET #1, 285 + i%, Offset(i%)
NEXT i%
FOR i% = 0 TO 6
    GET #1, 301 + i% * 3, FigOffset(i%).Anfang
    GET #1, 301 + i% * 3 + 1, FigOffset(i%).ende
    GET #1, 301 + i% * 3 + 2, FigOffset(i%).Langschritt
NEXT i%
CLOSE #1
DruckSymbol(0) = " "    'ostatni hodnoty a pole FigSymbol se nacitaji
DruckSymbol(1) = " "    'v procedure 'vlajka' kvuli moznym zmenam.
FOR i% = 0 TO 6
    GET #2, 113 + i%, a$
    FigSymbol(i%) = RTRIM$(a$)
    IF i% > 1 THEN DruckSymbol(i%) = RTRIM$(a$)
NEXT i%
GET #4, 6, PocetHracu%
GET #4, 4, Level%
CALL Initialisiere(0)
CALL KresliSachovnici
CALL TiskniRamecky
CALL KommandoSchleife
'--------------------------------------------------------------------
'  zde program konci, jeho dalsi beh ridi procedura KommandoSchleife
'--------------------------------------------------------------------
'toto je chybovy podprogram
NeosetrenaChyba:
CLS
Vystup 111
PRINT
Vystup 112
PRINT
Vystup 64
PRINT ; " "; ERR;
SLEEP
SYSTEM
RESUME

'--------------------------------------------------------------------
' Alpha-Beta-Baumsuche
' Gibt Bewertung aus der Sicht der am Zug befindlichen Seite zurck.
' "Alpha" ist untere Schranke, "Beta" obere Schranke und "Distanz"
' die Anzahl der Halbzge bis zum Horizont.
' Ist "Distanz" positiv, wird normale Alpha-Beta-Suche ausgefhrt,
' im Falle kleiner gleich 0 die Ruhesuche.
' Es wird der NegaMax-Wert aus der Sicht der Seite am Zug zurck-
' gegeben.
' Diese Prozedur wird rekursiv aufgerufen.
'
' Lokale Variablen: i%, Wert%, BesterWert%, Schach%
'---------------------------------------------------------------------
FUNCTION AlphaBeta% (Alpha%, Beta%, Distanz%)
   HVar(tiefe, tiefe) = 0         ' Lsche bisherige Hauptvariante

   ' Stellung wird immer, d.h. auch im Inneren des Baumes bewertet.
   ' Dies ist wegen Matt- und Patt-Erkennung notwendig. Desweiteren
   ' wird die Bewertung zur Steuerung der Suche/Erweiterung verwendet.
   ' Die Knotenanzahl im Inneren des Baumes ist viel kleiner als jene
   ' am Horizont. D.h. das Programm wird dadurch nicht wesentlich
   ' langsamer.

   ' Bewertung aus der Sicht der Seite die am Zug ist.
   wert% = BewerteStellung%(Alpha%, Beta%, Farbe)

   ' Im Falle eines Schachs wird die Suche erweitert, maximal um insgesamt
   ' vier Halbzge. Ansonsten kann es passieren, da der Suchbaum
   ' bei gegenseitigen Schach und Schlagsequenzen extrem gro wird.
   ' In der Regel sind diese Zugfolgen vollkommen sinnlos.

   Schach% = InSchach
   ' Seite am Zug steht im Schach, erweitere Suche
   Bedingung1% = (Schach% = 1 AND tiefe + Distanz% < MaxErweiterung + 1)
  
   ' Bei Schlagen und Rckschlagen auf dasselbe Feld wird Suche
   ' erweitert, falls die Materialbilanz ungefhr im Gleichgewicht
   ' bleibt und auerdem bisher noch nicht zuviele Erweiterungen
   ' gemacht wurden.
   Bedingung2% = (tiefe >= 2 AND tiefe + Distanz% < MaxErweiterung)
   Bedingung2% = Bedingung2% AND NachFeld(tiefe) = NachFeld(tiefe - 1)
   Bedingung2% = Bedingung2% AND wert% >= Alpha% - 150 AND wert% <= Beta% + 150
  
   IF Bedingung1% OR Bedingung2% THEN Distanz% = Distanz% + 1

   ' Falls bereits mehr als 5 Zge in der Ruhesuche ausgefhrt wurden,
   ' oder der Gegner Matt ist oder auf Grund der Datenstrukturen maximale
   ' Suchtiefe erreicht ist, beende Suche.
  
   IF Distanz% < -5 OR wert% = 32000 - tiefe OR tiefe >= 17 THEN
      AlphaBeta% = wert%
      EXIT FUNCTION
   END IF

   ' Falls in der Ruhesuche die Seite am Zug gut steht, wird Suche
   ' abgebrochen, da per Definition der Wert in der Ruhesuche nur
   ' besser werden kann.
   ' Achtung: Es wird auch bereits bei Distanz 1, d.h. einen Halbzug
   '          vor dem Horizont abgebrochen, falls Seite am Zug nicht
   '          im Schach steht. Dies ist eine selektive Abweichung vom
   '          Brute-force-Alpha-Beta-Schema.

   IF wert% >= Beta% AND Distanz% + Schach% <= 1 THEN
      AlphaBeta% = wert%
      EXIT FUNCTION
   END IF

   ' Erzeuge Zge. Falls distanz <= 0 ist (Ruhesuche) werden nur
   ' Schlagzge und Umwandlungen erzeugt.

   CALL GeneriereZuege(Distanz%)   ' Abfrage, ob berhaupt Zge vorhanden
   IF Distanz% > 0 THEN            ' sind, wird indirekt von der Festlegung
      BesterWert% = -32000     ' von BesterWert mit erledigt.
   ELSE                  ' In Ruhesuche ist die aktuelle Stellungsbewertung
      BesterWert% = wert%          ' untere Schranke fr den Suchwert.
   END IF
   ' Untersuche alle Zge in sortierter Reihenfolge.
   i% = NaechstbesterZug%
   DO WHILE i% >= 0                     ' Solange es noch Zge gibt
      CALL ZugAusfuehren(i%)
      ' NegaMax-Prinzip: Vorzeichen wird umgedreht,
      ' Rolle von Alpha und Beta vertauscht.
      wert% = -AlphaBeta(-Beta%, -Alpha%, Distanz% - 1)
      CALL ZugZuruecknehmen(i%)
      IF wert% > BesterWert% THEN       ' neuer bester Wert gefunden
         BesterWert% = wert%
         IF wert% >= Beta% THEN         ' Cutoff gefunden
            ' Im Inneren des Baumes wird noch neue Hauptvariante notiert.
            IF Distanz% > 0 THEN CALL KopiereHvar(i%)
            GOTO fertig
         END IF
         IF wert% > Alpha% THEN      ' Wert ist verbesserte untere Schranke
            IF Distanz% > 0 THEN CALL KopiereHvar(i%)  ' Hauptvariante notieren
            Alpha% = wert%           ' Verbesserter Alpha-Wert
         END IF
      END IF
      i% = NaechstbesterZug%
   LOOP

fertig:
   ' Guter Zug, der Cutoff erzeugt, wird in Killertabelle eingetragen.
   ' Bewahre den bisher besten Killer als zweitbesten Killer auf.
   IF wert% >= Beta% AND i% >= 0 THEN
      KillerTab(tiefe).Killer4 = KillerTab(tiefe).Killer3
      KillerTab(tiefe).Killer3 = KillerTab(tiefe).Killer2
      KillerTab(tiefe).Killer2 = KillerTab(tiefe).Killer1
      KillerTab(tiefe).Killer1 = ZugStapel(i%).tah
   END IF
  
   ' Falls Seite keinen legalen Zug mehr hat, ...
   IF BesterWert% = -(32000 - (tiefe + 1)) THEN
      IF Schach% = 0 THEN    ' ... aber nicht im Schach steht,
         AlphaBeta% = 0            ' dann ist es Patt
         EXIT FUNCTION
      END IF
   END IF
   AlphaBeta% = BesterWert%
END FUNCTION

'--------------------------------------------------------------------
' berprft, ob Spieler "Seite" das Feld "Feld" attackiert. Gibt
' "Wahr" zurck, wenn Feld von 'Seite' attackiert wird, sonst "Falsch".
' Methode: Stelle quasi auf "Feld" eine Superfigur, die in alle
'          Richtungen ziehen kann. "Schlgt" diese Superfigur z.B.
'          einen Turm von "Seite", dann attackiert in Wirklichkeit
'          der Turm das Feld.
'
' Lokale Variablen: i%, Richtung%, nach%, Figur%, gleiten%
'--------------------------------------------------------------------
FUNCTION AttackiertFeld% (Feld%, Seite%)
   ' Teste zuerst Spezialfall Bauern. Haben dieselbe Richtung wie Lufer,
   ' gleiten aber nicht.

   IF Seite% = 1 THEN
   ' Mu umgekehrte Richtung als Bauer gehen. D5 wird von Bauer E4
   ' attackiert.
      IF brett(Feld% - 9) = 1 OR brett(Feld% - 11) = 1 THEN
         AttackiertFeld% = 1
         EXIT FUNCTION
      END IF
   END IF
   IF Seite% = -1 THEN
      IF brett(Feld% + 9) = -1 OR brett(Feld% + 11) = -1 THEN
         AttackiertFeld% = 1
         EXIT FUNCTION
      END IF
   END IF

   ' Untersuche Springer
   FOR i% = 8 TO 15                  ' Springer-Richtungen
      nach% = Feld% + Offset(i%)
      IF brett(nach%) = 0 OR brett(nach%) = 100 THEN GOTO w1
      IF Seite% = 1 THEN
         IF brett(nach%) = 4 THEN
            AttackiertFeld% = 1
            EXIT FUNCTION
         END IF
      ELSEIF brett(nach%) = -4 THEN
         AttackiertFeld% = 1
         EXIT FUNCTION
      END IF
w1:
   NEXT i%

   ' Untersuche gleitende Figuren und Knig.
   FOR i% = 0 TO 7
      nach% = Feld%
      Richtung% = Offset(i%)
      gleiten% = 0
weitergleiten1:
      gleiten% = gleiten% + 1
      nach% = nach% + Richtung%
      IF brett(nach%) = 0 THEN
         GOTO weitergleiten1
      END IF
      ' Wenn am Rand angelangt, dann nchste Richtung
      IF brett(nach%) = 100 THEN GOTO w2

      ' Auf Figur getroffen. Figur mu von Farbe "F" sein.
      ' Auerdem mu die aktuelle Richtung eine mgliche Zugrichtung der
      ' Figur sein. Der Knig darf nur einen Schritt tun.

      figur% = brett(nach%)
      IF Seite% = 1 THEN
         IF figur% > 0 THEN                      ' Weie Figur
            IF figur% = 6 THEN
               IF gleiten% <= 1 THEN       ' Knig ist Kurzschrittler
                  AttackiertFeld% = 1
                  EXIT FUNCTION
               END IF
            ELSE
               ' Bei gleitenden Figuren mu aktuelle Richtung eine
               ' mgliche Zugrichtung der Figur sein.

               IF FigOffset(figur%).Anfang <= i% THEN
                  IF FigOffset(figur%).ende >= i% THEN
                     AttackiertFeld% = 1
                     EXIT FUNCTION
                  END IF
               END IF
            END IF
         END IF
      ELSE
         IF figur% < 0 THEN                      ' schwarze Figur
            IF figur% = -6 THEN
               IF gleiten% <= 1 THEN
                  AttackiertFeld% = 1
                  EXIT FUNCTION
               END IF
            ELSE
               IF FigOffset(-figur%).Anfang <= i% THEN
                  IF FigOffset(-figur%).ende >= i% THEN
                     AttackiertFeld% = 1
                     EXIT FUNCTION
                  END IF
               END IF
            END IF
         END IF
      END IF
w2:
   NEXT i%

   ' Alle Richtungen durchsucht, auf keine passende Figur gestoen,
   ' D.h. "F" attackiert das Feld nicht.

   AttackiertFeld% = 0
END FUNCTION

'--------------------------------------------------------------------
' Stellungsbewertung
' Wert wird aus der Sicht von "Seite" zurckgegeben.
' Wenn Materialwert zu weit vom Alpha-Beta-Fenster abweicht,
' wird nur Material bewertet.
' Falls "Seite" Matt setzt, wird Mattwert-Tiefe zurckgegeben.
' Falls "Seite" im Schach steht, wird Variable InSchach auf "Wahr"
' gesetzt.
' Achtung: Die Funktion nimmt sowohl fr Schach/Matt als auch fr
'          die Knigsopposition an, da "Seite" am Zug ist.
'
' Lokale Variablen:
' Wert%, PosWert%, i%, j%, k%, Feld%, wLaeufer%, sLaeufer%
' MatSum%, wtauf7%, STauf2%
' wentwickelt%, sentwickelt%
'--------------------------------------------------------------------
FUNCTION BewerteStellung% (Alpha%, Beta%, Seite%)
   ' berprfe zuerst, ob Gegner Matt ist
   ' oder "Seite" im Schach steht
   IF Seite% = 1 THEN
      IF AttackiertFeld%(SezFigCerne(0).pole, 1) = 1 THEN
         BewerteStellung% = 32000 - tiefe
         EXIT FUNCTION
      END IF
      InSchach = AttackiertFeld%(SezFigBile(0).pole, -1)  ' Steht Wei im Schach?
   ELSE
      IF AttackiertFeld%(SezFigBile(0).pole, -1) = 1 THEN
         BewerteStellung% = 32000 - tiefe
         EXIT FUNCTION
      END IF
      InSchach = AttackiertFeld%(SezFigCerne(0).pole, 1)  ' Steht Schwarz im Schach?
   END IF

   ' Positionelle Bewertungsfaktoren wiegen starkes Materialungleichgewicht
   ' nicht auf. Daher wird in diesem Fall auf Positionsbewertung verzichtet
   ' Ausnahme: Sptes Endspiel. Freibauern haben hohe Bewertung.
   '           Leichtfigur ohne Bauern ist wirkungslos.

   wert% = MatBilanz(tiefe)
   MatSum% = MatSumme(tiefe)
   IF MatSum% > 360 + 360 THEN
      IF wert% < Alpha% - 360 OR wert% > Beta% + 360 THEN
         BewerteStellung% = wert%
         EXIT FUNCTION
      END IF
   END IF

   ' Initialisiere die Turm- und Bauernlinien und die Bauernkontrollen.
   ' Das knnte man wesentlich schneller auch bei der Ausfhrung (und
   ' der Zurcknahme) von  Zgen inkrementell berechnen. Allerdings ist
   ' diese inkrementelle Berechnung auch wegen der Spezialflle Rochade,
   ' Enpassant und Umwandlung lstig und fehleranfllig.
   ' Man knnte auch in 'InitBewertung' eine Figurenliste aufbauen und
   ' in der zweiten Runde diese Figurenliste durchgehen (und nicht mehr
   ' das gesamte Brett).
   ' Die schnellste Lsung besteht darin, auch diese Figurenliste
   ' inkrementell zu berechnen. Allerdings werden dann die Funktionen
   ' "Zugausfuehren" und "Zugzuruecknehmen" noch komplizierter.
   ' Nach dem KISS-Prinzip (Keep It Simple und Stupid) wurde in MiniMAX
   ' diese Lsung gewhlt.

   CALL InitBewertung
   Poswert% = 0

   '  Werden fr Bewertung des Luferpaares verwendet.
   sLaeufer% = 0
   wLaeufer% = 0

   ' Pouzije se pro stanoveni nedostatecneho materialu, vliv ma pri hodnoceni
   'dvojice strelcu.
   PocetPescu% = 0
   
   ' Weie Trme auf 7/8-ter Reihe, schwarze auf 1/2-ter
   WTauf7% = 0
   STauf2% = 0

   ' hodnoceni vyvinu
   ' po odehrani 30 pultahu si s dokoncenim vyvinu musi poradit podle
   ' hodnoceni poli ...
   IF ZugNr > 30 THEN
      sentwickelt% = 6
      wentwickelt% = 6
   ELSE
      ' Stand der Entwicklung: Rochiert und Leichtfiguren entwickelt.
      wentwickelt% = Rochade(2) 'pricte cislo rochady bileho
      sentwickelt% = Rochade(0) 'pricte cislo rochady cerneho
      FOR i% = 4 TO 7
        IF SezFigCerne(i%).pohyb > 0 THEN sentwickelt% = sentwickelt% + 1
        IF SezFigBile(i%).pohyb > 0 THEN wentwickelt% = wentwickelt% + 1
      NEXT i%
   END IF

   ' Lies ganzes Brett und bewerte jede einzelne Figur.
   ' Es wird aus der Sicht von Wei bewertet. Bei den schwarzen
   ' Figuren bedeutet eine positive Bewertung, da dieses Merkmal
   ' fr Schwarz schlecht ist.
   Poswert% = Poswert% + WBBewertung%(wentwickelt%)
   Poswert% = Poswert% - SBBewertung%(sentwickelt%)
   FOR k% = 0 TO 15 + 2 * Promena%
      IF k% < 8 + Promena% THEN
        figura% = SezFigBile(k%).figura
        Feld% = SezFigBile(k%).pole
      ELSE
        figura% = SezFigCerne(k% - 8 - Promena%).figura
        Feld% = SezFigCerne(k% - 8 - Promena%).pole
      END IF
      IF Feld% = 0 OR ABS(figura%) = 1 THEN
      ELSE    'je-li pole 0, nedelej nic, figura je mimo sachovnici
        j% = Feld% MOD 10
        i% = Feld% \ 10
        SELECT CASE figura%
         CASE -4                                        ' Schwarzer Springer
            Poswert% = Poswert% - ZentrumTab(Feld%) \ 2
            sJezdec% = sJezdec% + 1
         CASE 4
            Poswert% = Poswert% + ZentrumTab(Feld%) \ 2
            wJezdec% = wJezdec% + 1
         CASE -3
            ' Lufer soll nicht schwarze d7/e7 Bauern verstellen
            ' Lufer wird auch im Zuggenerator durch Variable Mobilitt
            ' bewertet.
            IF (Feld% = 74 OR Feld% = 75) AND brett(Feld% + 10) = -1 THEN
               Poswert% = Poswert% + 25
            END IF
            sLaeufer% = sLaeufer% + 1   ' Anzahl der Lufer fr Luferpaar
         CASE 3
            ' Lufer soll nicht Bauern auf D3/E3 blockieren.
            IF (Feld% = 44 OR Feld% = 45) AND brett(Feld% - 10) = 1 THEN
               Poswert% = Poswert% - 25
            END IF
            wLaeufer% = wLaeufer% + 1
         CASE -2                       ' Turm geht auch bei Knigsbewertung ein
            ' Schwarzer Turm ist auf Reihe 1 oder 2 eingebrochen
            IF Feld% <= 38 THEN STauf2% = STauf2% + 1
            ' Trme von a- und h-Linien ins Zentrum bringen
            IF j% >= 3 AND j% <= 5 THEN Poswert% = Poswert% - 4
            ' Trme auf halboffene und offene Linien
            IF Bauern(j%).Weiss = 0 THEN
               Poswert% = Poswert% - 8         ' Turm auf halboffener Linie
               ' Turm auf offener Linie
               IF Bauern(j%).Schwarz = 0 THEN Poswert% = Poswert% - 20
            END IF
         CASE 2
            ' Weier Turm auf 7-ter oder 8-ter Reihe
            IF Feld% >= 81 THEN WTauf7% = WTauf7% + 1
            ' Trme von a- und h-Linien ins Zentrum bringen
            IF j% >= 3 AND j% <= 5 THEN Poswert% = Poswert% + 4
            ' Trme auf halboffene und offene Linien bringen
            IF Bauern(j%).Schwarz = 0 THEN
               Poswert% = Poswert% + 8       ' Turm auf halboffener Linie
               ' Turm auf offener Linie
               IF Bauern(j%).Weiss = 0 THEN Poswert% = Poswert% + 20
            END IF
         CASE -5
            ' Vermeide Damenausflge zu Beginn des Spieles
            IF sentwickelt% < 4 THEN
               IF Feld% < 91 THEN Poswert% = Poswert% + 15
            ELSE ' Falls Entwicklung abgeschlossen, plaziere Dame in der
               ' Nhe des gegnerischen Knigs. Reihen- und Linienabstand
               ' zwischen Dame und gegn. Knig sollte mglichst klein sein
               ReihenDiff% = ABS(SezFigBile(0).pole \ 10 - Feld% \ 10)
               LinienDiff% = ABS(SezFigBile(0).pole MOD 10 - Feld% MOD 10)
               Poswert% = Poswert% + 2 * (ReihenDiff% + LinienDiff%)
            END IF
         CASE 5
            ' Vermeide Damenausflge zu Beginn des Spieles
            IF wentwickelt% < 4 THEN
               IF Feld% > 28 THEN Poswert% = Poswert% - 15
            ELSE  ' Plaziere Dame in der Nhe des gegnerischen Knigs.
                  ' Reihen- und Linienabstand zwischen Dame und gegn.
                  ' Knig sollte mglichst klein sein.
               ReihenDiff% = ABS(SezFigCerne(0).pole \ 10 - Feld% \ 10)
               LinienDiff% = ABS(SezFigCerne(0).pole MOD 10 - Feld% MOD 10)
               Poswert% = Poswert% - 2 * (ReihenDiff% + LinienDiff%)
            END IF
         CASE -6
            IF MatSum% < 2920 THEN   ' Endspielbewertung fr Knig
               ' Zentralisiere im Endspiel den Knig
               Poswert% = Poswert% - ZentrumTab(Feld%)
            ELSE
               ' Noch nicht rochiert, aber Rochaderecht verloren
               IF Rochade(0) = 0 THEN
                  IF SezFigCerne(0).pohyb > 0 OR (SezFigCerne(2).pohyb > 0 AND SezFigCerne(3).pohyb > 0) THEN
                     Poswert% = Poswert% + 35
                  END IF
               END IF
               ' Knig mglichst nicht im Zentrum
               Poswert% = Poswert% + 4 * ZentrumTab(Feld%)
               FOR l% = -1 TO 1
                  IF (SezFigCerne(0).pole > 90 AND SezFigCerne(0).pole < 94) OR SezFigCerne(0).pole > 96 THEN
                    ' Bonus fr Bauernschirm vor Knig
                    IF brett(Feld% - 10 + l%) = -1 THEN Poswert% = Poswert% - 15
                    ' Bauernschirm 2 Reihen vor Knig
                    IF brett(Feld% - 20 + l%) = -1 THEN Poswert% = Poswert% - 6
                  END IF
                  ' Malus fr halboffene Linie, die von gegnerischen Turm
                  ' besetzt ist.
                  IF Bauern(j% + l%).Weiss = 0 AND Tuerme(j% + l%).Weiss > 0 THEN
                     Poswert% = Poswert% + 10
                  END IF
               NEXT l%
            END IF
         CASE 6
            IF MatSum% < 2920 THEN  ' Endspielbewertung fr Knig
               ' Zentralisiere im Endspiel den Knig
               Poswert% = Poswert% + ZentrumTab(Feld%)
               ' Nah-Opposition der Knige
               IF ABS(Feld% - SezFigCerne(0).pole) = 20 OR ABS(Feld% - SezFigCerne(0).pole) = 2 THEN
                  k% = 10
                  ' Opposition im Bauernendspiel
                  IF MatSum% = 0 THEN k% = 30
                  IF Farbe = 1 THEN
                     Poswert% = Poswert% - k%
                  ELSE
                     Poswert% = Poswert% + k%
                  END IF
               END IF
            ELSE
               ' Noch nicht rochiert, aber Rochaderecht verloren
               IF Rochade(2) = 0 THEN
                  IF SezFigBile(0).pohyb > 0 OR (SezFigBile(2).pohyb > 0 AND SezFigBile(3).pohyb > 0) THEN
                     Poswert% = Poswert% - 35
                  END IF
               END IF
               ' Knig mglichst nicht im Zentrum
               Poswert% = Poswert% - 4 * ZentrumTab(Feld%)
               FOR l% = -1 TO 1
                  IF SezFigBile(0).pole < 24 OR (SezFigBile(0).pole > 26 AND SezFigBile(0).pole < 29) THEN
                    ' Bonus fr Bauernschirm vor Knig
                    IF brett(Feld% + 10 + l%) = 1 THEN Poswert% = Poswert% + 15
                    ' Bauernschirm 2 Reihen vor Knig
                    IF brett(Feld% + 20 + l%) = 1 THEN Poswert% = Poswert% + 6
                  END IF
                  ' Malus fr halboffene Linie, die von gegnerischen Turm
                  ' besetzt ist.
                  IF Bauern(j% + l%).Schwarz = 0 AND Tuerme(j% + l%).Schwarz > 0 THEN
                     Poswert% = Poswert% - 10
                  END IF
               NEXT l%
            END IF
         END SELECT
        END IF
   NEXT k%

   ' Keine Bauern mehr am Brett und ungengendes Material
   ' Erkennt alle elementaren Remis-Situationen
   ' KK, KLK, KSK, KSSK, KLKL, KSKL.
   IF PocetPescu% = 0 THEN
      Bed1% = MatSum% <= 360                ' weniger als ein Lufer
      Bed2% = MatSum% = 2 * 340             ' zwei Springer
      ' zwei Lufer, aber Materialunterschied weniger als ein Bauer
      Bed3% = MatSum% <= 2 * 360 AND ABS(MatBilanz(tiefe)) < 100
      IF Bed1% OR Bed2% OR Bed3% THEN
         BewerteStellung% = 0
         EXIT FUNCTION
      END IF
   END IF

   ' Je-li hodne pescu, muze byt pozice zablokovana, pak jezdec neni horsi nez strelec
   Poswert% = Poswert% + (wJezdec% - sJezdec%) * PocetPescu%
   ' Luferpaar-Bonus fr Wei
   IF wLaeufer% >= 2 THEN Poswert% = Poswert% + 20
   ' Luferpaar-Bonus fr Schwarz
   IF sLaeufer% >= 2 THEN Poswert% = Poswert% - 20
   ' weie Trme auf 7/8-ter Reihe und schwarzer Knig auch noch
   ' auf diesen Reihen
   IF WTauf7% > 0 AND SezFigCerne(0).pole >= 81 THEN
      Poswert% = Poswert% + 10
      ' Verdoppelt ist extra gefhrlich
      IF WTauf7% > 1 THEN Poswert% = Poswert% + 30
   END IF
   ' schwarze Trme auf 1/2-ter Reihe und weier Knig auch noch
   ' auf diesen Reihen
   IF STauf2% > 0 AND SezFigBile(0).pole <= 38 THEN
      Poswert% = Poswert% - 10
      IF STauf2% > 1 THEN Poswert% = Poswert% - 30
   END IF

   IF Seite% = -1 THEN     ' Bewertung erfolgte aus der Sicht von Wei,
      Poswert% = -Poswert%       ' drehe daher fr Schwarz Wert um
   END IF
  
   ' Bercksichtige die Mobilitt der Lufer und Trme
   ' Wird von Zuggenerator berechnet. Mobilitaet(Tiefe) ist die
   ' Mobilitt der anderen Farbe, Mobilitaet(Tiefe-1) jene von
   ' "Seite" (bevor die andere Farbe einen Zug ausgefhrt hat).
   IF tiefe >= 1 THEN
      Poswert% = Poswert% - ((Mobilitaet(tiefe) - Mobilitaet(tiefe - 1)) \ 12)
   END IF

   BewerteStellung% = wert% + Poswert%
END FUNCTION

'--------------------------------------------------------------------
' Ausgabe des Spielbrettes und des Spiel/Brettstatus
' Spiel/Brettstatus wird nur ausgegeben, wenn "NurBrett" falsch ist
'
' Die SGN-Funktion (Signum) liefert das Vorzeichen, also -1 oder +1
' Die ABS-Funktion den Absolut-Wert (ohne Vorzeichen)
'--------------------------------------------------------------------
SUB Brettausgabe (NurBrett%)
   LOCATE 11, 55
   Vystup 106: PRINT " "; MatBilanz(tiefe);
   LOCATE 12, 55
   Vystup 107: PRINT " "; Feldnotation$(EpFeld(tiefe));
  
   ' Rochade ist noch prinzipiell mglich, wenn sich Knig und
   ' jeweiliger Turm noch nicht bewegt haben.
   LOCATE 13, 55
   Vystup 108
   LOCATE 14, 55
   COLOR 15: Vystup 109
   COLOR 7
   IF SezFigBile(0).pohyb = 0 THEN
      IF SezFigBile(2).pole = 28 AND SezFigBile(2).pohyb = 0 THEN PRINT " 0-0  ";
      IF SezFigBile(3).pole = 28 AND SezFigBile(3).pohyb = 0 THEN PRINT " 0-0  ";
      IF SezFigBile(2).pole = 21 AND SezFigBile(2).pohyb = 0 THEN PRINT " 0-0-0";
      IF SezFigBile(3).pole = 21 AND SezFigBile(3).pohyb = 0 THEN PRINT " 0-0-0";
   END IF
   LOCATE 15, 55
   COLOR 12: Vystup 110
   COLOR 7
   IF SezFigCerne(0).pohyb = 0 THEN
      IF SezFigCerne(2).pole = 98 AND SezFigCerne(2).pohyb = 0 THEN PRINT " 0-0  ";
      IF SezFigCerne(3).pole = 98 AND SezFigCerne(3).pohyb = 0 THEN PRINT " 0-0  ";
      IF SezFigCerne(2).pole = 91 AND SezFigCerne(2).pohyb = 0 THEN PRINT " 0-0-0";
      IF SezFigCerne(3).pole = 91 AND SezFigCerne(3).pohyb = 0 THEN PRINT " 0-0-0";
   END IF
   SLEEP
END SUB

SUB ChybneZadani
  CistiRadek 29, 29
  COLOR 12
  FOR i% = 1 TO 3
  LOCATE , 55
  PRINT STRING$(15, " ");
  SOUND 140, 3
  SLEEP 1
  LOCATE , 55
  Vystup 105
  SLEEP 1
  NEXT i%
  COLOR 7
END SUB

SUB CistiRadek (odcisla%, docisla%)
  FOR i% = odcisla% TO docisla%
    LOCATE i%, 53
    PRINT ; ""; STRING$(26, " "); "";
  NEXT i%
END SUB

'--------------------------------------------------------------------
' Vypocet dalsiho tahu pocitace, hledani probiha iterativne az do
' stanovene hloubky, pouziva se pritom Alfa-Beta odsekavani. Proces
' vyhledavani se da prerusit nebo urychlit klavesami Esc a F10.
'--------------------------------------------------------------------
SUB Computerzug
   Preruseni% = 0           'pred kazdym tahem musi nastavit na nulu

   'nacte hodnoty pro rizeni delky vypoctu
   GET #5, Level%, i%
   GET #5, Level% + 1, j%
   GET #5, Level% + 2, Solltiefe%
   DIM Cas AS INTEGER
   IF Level% > 25 AND Level% < 82 THEN
        IF Farbe% = 1 THEN
            k% = CasBily%
            l% = l% - (ZugNr% + 1) \ 2
        ELSE
            k% = CasCerny%
            l% = l% - (ZugNr%) \ 2
        END IF
        IF l% < 1 THEN l% = l% + j%         'hodnotou se deli, nesmi byt nula,
                                            'jedna se o pocet tahu do cas. kontroly
        IF Level% > 54 THEN
            Cas% = (i% - k%) \ 120
        ELSE
            Cas% = (i% - k%) \ l% \ 8
            IF l% > 1 THEN Cas% = Cas% * 3
        END IF
   END IF
   IF Level% > 81 THEN Cas% = i%
  
   DIM tmp AS ZugTyp                 ' Temporre ZugTyp-Variable
  
   CALL InitSpielbaum
   ' Oceneni vychozi pozice. Ma-li souper mat, ukonci hledani.
   wert% = BewerteStellung%(-32000, 32000, Farbe)
   NapisKdoTahne 1
  
   CistiRadek 19, 27
   FOR i% = 19 TO 22
    LOCATE i%, 55: Vystup 72 + i%
   NEXT i%
   LOCATE 27, 55: Vystup 95
  
   COLOR 15
   IF BookIndex% <> 0 THEN
        GET #7, BookIndex%, k%
        Varianta% = CINT(RND * 9) + 1
        FOR okruh% = 0 TO (k% - 1)
          GET #7, BookIndex% + 3 * okruh% + 2, l%  'nacti pravdepodobnost daneho tahu
          Varianta% = Varianta% - l%
          IF Varianta% <= 0 THEN
            'urcen tah, nacti ho a zadej jako pri zadani tahu
            GET #7, BookIndex% + 3 * okruh% + 1, tah% 'hodnota tahu
            LOCATE 20, 67: PRINT ; "BOOK      ";
            von% = tah% \ 100
            nach% = tah% MOD 100
            tah$ = UCASE$(Feldnotation$(von%) + Feldnotation$(nach%))
            IF Zugeingabe%(tah$) = 1 THEN
              COLOR 7
              LOCATE 19, 55: Vystup 98: PRINT ; " ";
              COLOR 15
              LOCATE 19, 67: PRINT Feldnotation$(von%); "-"; Feldnotation$(nach%);
              COLOR 7
              EXIT SUB 'tah nalezen, zkontrolovan a zahran
            ELSE
              BookIndex% = 0    'nejaka chyba v knihovne, teoreticky
              EXIT FOR          'tah nelze zahrat, makej
            END IF
          END IF
        NEXT okruh%
   END IF
   
   IF wert% = 32000 THEN
      LOCATE 27, 55
      Vystup 96
      IF PocetHracu% = 2 THEN
        PocetHracu% = 1  'Uz neni co analyzovat
        NapisKdoTahne 1
      END IF
      COLOR 7
      EXIT SUB
   END IF

   ' ulozeni, zda je sach, na konci hledani se pouzije pro rozliseni
   ' matu a patu
   Schach% = InSchach
  
   'pocatecni cas vypoctu, pouzije se pro urceni rychlosti hledani
   StartCas = TIMER

   ' generuj vsechny pseudolegalni tahy
   CALL GeneriereZuege(1)

   ' Man knnte/sollte hier alle illegalen Zge aus dem Zugstapel
   ' entfernen und nur mit den legalen Zgen weiter rechnen.
   ' (Hat aber nur optische Effekte, da Suche nach der Ausfhrung des
   ' illegalen Zuges sowieso sofort abbricht).

   ' Iteratives Vertiefen: Distanz ist die Anzahl der Halbzge bis zum
   ' Horizont. Ist insofern nicht gleich der Tiefe, da im Laufe des
   ' Suchprozesses die Distanz erhht werden kann (z.B. bei Schachs).

   FOR Distanz% = 1 TO Solltiefe%
      IF Distanz% = 1 THEN     ' Auf Tiefe 1 wird mit offenen Fenster gerechnet
         Alpha% = -32000   ' Wir haben noch keinen guten Schtzwert fr
         Beta% = 32000     ' die Stellung.
      ELSE                     ' Auf den hheren Stufen sollte sich Resultat
         Beta% = Alpha% + 100  ' nicht wesentlich vom Resultat der vorher-
         Alpha% = Alpha% - 100 ' gehenden Tiefe unterscheiden.
      END IF

      ' Bei Schlagzgen und Schachs wird Suche erweitert.
      ' Diese Variable begrenzt die Erweiterungen.
      MaxErweiterung = Distanz% + 3
      IF Preruseni% = 0 THEN LOCATE 21, 67: PRINT ; Distanz%;
      ZuegeInZeile% = 0
     
      ' Berechne den Wert jedes Zuges
      FOR i% = 0 TO StapelGrenze(1) - 1
         IF TIMER < StartCas THEN StartCas = StartCas - 86400
         IF TIMER - StartCas > Cas% AND Level% > 27 THEN Preruseni% = 2
         IF TIMER - StartCas > Cas% * 6 AND Level% > 27 AND Distanz% > 1 THEN Preruseni% = 1
         IF Preruseni% = 1 THEN IF i% > 2 THEN EXIT FOR
         a$ = INKEY$
         IF LEN(a$) > 0 THEN
            Preruseni% = 3
            IF PocetHracu% = 0 THEN PocetHracu% = 1: PUT #4, 6, PocetHracu% 'Vrat se do rezimu partie
            EXIT FOR
         END IF
         'LOCATE 29, 67: PRINT ; i% + 1; "/"; StapelGrenze(1);
         ZuegeInZeile% = ZuegeInZeile% + 1
         ' Initialisiere die Hauptvariante und zeige
         ' den gerade untersuchten Zug an.
         HVar(tiefe, tiefe) = 0
         LOCATE 27, 67
         CALL ZeigeZug(i%)
         ' Zug ausfhren, Wert berechnen, Zug zurcknehmen.
         CALL ZugAusfuehren((i%))
         wert% = -AlphaBeta(-Beta%, -Alpha%, Distanz% - 1)
         CALL ZugZuruecknehmen((i%))
         IF i% = 0 THEN       ' War es der erste Zug (der bisher beste)?
                              ' Fr diesen Zug wird ein exakter Wert bentigt
            IF wert% < Alpha% THEN
               ' Suche des bisher besten Zuges fllt nach unten aus dem
               ' Fenster (Programm erkennt Unglck). Neuerliche Suche
               ' mit nach unten geffneten Fenster notwendig.
               Alpha% = -32000
               Beta% = wert%
               ZuegeInZeile% = 0
               CALL ZugAusfuehren((i%))
               wert% = -AlphaBeta(-Beta%, -Alpha%, Distanz% - 1)
               CALL ZugZuruecknehmen((i%))
            ELSEIF wert% >= Beta% THEN        ' fllt nach oben
               Alpha% = wert%
               Beta% = 32000
               ZuegeInZeile% = 0
               CALL ZugAusfuehren((i%))
               wert% = -AlphaBeta(-Beta%, -Alpha%, Distanz% - 1)
               CALL ZugZuruecknehmen((i%))
            END IF

            ' Die Chance, da ein nachfolgender Zug noch besser ist,
            ' ist gering. Es wird mit einem Null-Fenster weiter
            ' gerechnet, da dadurch die Suche beschleunigt wird.

            Alpha% = wert%
            Beta% = Alpha% + 1
            LOCATE 19, 67
            CALL ZeigeZug(i%)
            LOCATE 20, 67
            PRINT ; wert%; "   ";
            CALL KopiereHvar(i%)
            CALL ZeigeHvar
            ZuegeInZeile% = 0
         ELSE        ' Bereits bisher bester Zug auf Suchtiefe berechnet
            IF wert% > Alpha% THEN
               ' Neuer bester Zug gefunden. Man wei im Moment nur,
               ' da er besser ist. Exakter Wert mu noch einmal mit
               ' offenem Fenster berechnet werden.
               BesterWert% = Alpha%
               Alpha% = wert%
               Beta% = 32000
               CALL ZugAusfuehren((i%))
               wert% = -AlphaBeta(-Beta%, -Alpha%, Distanz% - 1)
               CALL ZugZuruecknehmen((i%))

               ' Ist er auch mit offenem Fenster besser?
               ' Bei reiner Anwendung von Alpha-Beta mu der Zug
               ' auch bei offenem Fenster immer besser sein. Da bei
               ' den Erweiterungen und in der Selektivitt das
               ' Fenster mit eingeht, kann es in unserem Fall auch
               ' anders kommen.

               IF wert% > BesterWert% THEN
                  Alpha% = wert%
                  Beta% = Alpha% + 1
                  LOCATE 19, 67
                  CALL ZeigeZug(i%)
                  LOCATE 20, 67
                  PRINT ; wert%; "   ";
                  CALL KopiereHvar(i%)
                  CALL ZeigeHvar
                  ZuegeInZeile% = 0
                  ' Plaziere besten Zug an die erste Stelle der Zugliste.
                  ' Schiebe die anderen Zge um eine Position nach oben
                  tmp = ZugStapel(i%)
                  FOR j% = i% TO 1 STEP -1
                     ZugStapel(j%) = ZugStapel(j% - 1)
                  NEXT j%
                  ZugStapel(0) = tmp
               END IF
            END IF
         END IF
      NEXT i%
      IF Preruseni% > 0 THEN EXIT FOR
   NEXT Distanz%

   KonecCas = TIMER
  
   IF Alpha% > -(32000 - 1) THEN
      COLOR 7
      LOCATE 19, 55
      Vystup 98: PRINT ; " ";
      COLOR 15
      CALL ZeigeZug(0)            ' Bester Zug wird immer an Position 0
                                  ' des Zugstapels sortiert
     
     
      COLOR 7
      Cas% = KonecCas - StartCas
      ' Verhindere Division durch Null bei Knoten/Sekunde
      IF Cas% = 0 THEN Cas% = 1
      CistiRadek 27, 27
      LOCATE 27, 55: PRINT ; Cas%; " s";
      IF Farbe = 1 THEN
        CasBily% = CasBily% + Cas%
      ELSE
        CasCerny% = CasCerny% + Cas%
      END IF
      CALL ZugAusfuehren(0)
      j% = ZugStapel(AktZug%).tah
      PUT #3, 1, ZugNr%
      PUT #3, (ZugNr% * 3), j%
      j% = ABS(brett(ZugStapel(AktZug%).tah MOD 100))
      PUT #3, (ZugNr% * 3) + 1, j%
      j% = ZugStapel(AktZug%).extra
      PUT #3, (ZugNr% * 3) + 2, j%
      PUT #4, 8, CasBily%
      PUT #4, 9, CasCerny%
      CALL DruckeZug(0)
      IF Alpha% >= 32000 - 10 THEN
         i% = (32000 - 2 - Alpha%) \ 2
         CistiRadek 20, 20
         LOCATE 20, 55
         IF i% <> 0 THEN
            COLOR 15
            Vystup 99: PRINT ; " "; i%; " "; : Vystup 100
            COLOR 7
         ELSE
            COLOR 15
            Vystup 99
            COLOR 7
            CistiRadek 23, 26
         END IF
      ELSE
         IF Alpha% <= -32000 + 10 THEN
            LOCATE 20, 55
            Vystup 101: PRINT ; " "; (Alpha% + 32000 - 1) \ 2; " "; : Vystup 100
         END IF
      END IF
   ELSE
      IF Schach% = 1 THEN
         LOCATE 26, 55
         PRINT STRING$(25, " ");
         LOCATE 26, 55
         Vystup 102
         LOCATE 27, 55
         PRINT STRING$(25, " ");
         LOCATE 27, 55
         Vystup 103
      ELSE
         LOCATE 27, 55
         PRINT STRING$(25, " ");
         LOCATE 27, 55
         Vystup 104
      END IF
      IF PocetHracu% = 0 THEN
        PocetHracu% = 1: PUT #4, 6, PocetHracu% 'Uz neni co analyzovat
      END IF
   END IF
END SUB

'--------------------------------------------------------------------
' Druckt die aktuelle Stellung im ChessBase- bzw. Fritz-Format
' ACHTUNG: Das Format dieser Ausgabe nicht verndern, da ansonsten
'          der Chess332-Treiber nicht mehr funktioniert
'--------------------------------------------------------------------
SUB DruckeStellung
   GET #4, 5, Drucker%
   IF Drucker% = 0 THEN EXIT SUB

   IF ZuletztWeiss = 1 THEN
      LPRINT
      ZuletztWeiss = 0
   END IF

   LPRINT "(wK";
   LPRINT Feldnotation$(SezFigBile(0).pole);                    ' zuerst den Knig
   FOR i% = 21 TO 98                               ' andere weie Figuren
      IF brett(i%) > 0 AND brett(i%) < 6 THEN
         LPRINT ","; FigSymbol(brett(i%));
         LPRINT Feldnotation$(i%);
      END IF
   NEXT i%
   LPRINT "; sK";
   LPRINT Feldnotation$(SezFigCerne(0).pole);                    ' zuerst den Knig
   FOR i% = 21 TO 98                               ' andere schwarze Figuren
      IF brett(i%) < 0 AND brett(i%) > -6 THEN
         LPRINT ","; FigSymbol(ABS(brett(i%)));
         LPRINT Feldnotation$(i%);
      END IF
   NEXT i%
   LPRINT ")"
END SUB

'--------------------------------------------------------------------
' Es wird der aktuelle Zug ausgedruckt.
' ACHTUNG: Das Format dieser Ausgabe NICHT verndern, da
'          ansonsten der Noname-Treiber fr das CHESS232-Brett
'          und den Autoplayer AUTO232 nicht mehr funktioniert.
'
' Anmerkungen:
' CHR$(9) ist das Tabulatorzeichen
'--------------------------------------------------------------------
SUB DruckeZug (AktZug%)
   IF Drucker = 0 THEN EXIT SUB  ' Nur wenn Druckfunktion aktiviert
   IF Farbe = -1 THEN            ' Wenn Schwarz am Zug ist,
                                       ' war der letzte Zug von Wei.
      LPRINT USING "###.   "; ZugNr% \ 2 + 1;
      ZuletztWeiss = 1
   ELSE                                ' schwarzer Zug
      IF ZuletztWeiss = 1 THEN
         LPRINT "   ";
      ELSE
         LPRINT USING "###.    ... !   "; ZugNr% \ 2 + 1; CHR$(9);
      END IF
      ZuletztWeiss = 0
   END IF

   IF ZugStapel(AktZug%).extra = 7 THEN
      LPRINT "  0-0 ";
   ELSEIF ZugStapel(AktZug%).extra = 8 THEN
      LPRINT " 0-0-0";
   ELSE
      LPRINT DruckSymbol(ABS(brett(ZugStapel(AktZug%).tah MOD 100)));
      von$ = LCASE$(Feldnotation$((ZugStapel(AktZug%).tah) \ 100))
      LPRINT von$;
      IF ZugStapel(AktZug%).extra > 0 THEN
         IF ZugStapel(AktZug%).extra MOD 10 < 7 THEN
            LPRINT "x";
         ELSE
            LPRINT "-";
         END IF
      ELSE
         LPRINT "-";
      END IF
      nach$ = LCASE$(Feldnotation$(ZugStapel(AktZug%).tah MOD 100))
      LPRINT nach$;
      IF ZugStapel(AktZug%).extra < 100 AND ZugStapel(AktZug%).extra > 9 THEN
         LPRINT DruckSymbol((ZugStapel(AktZug%).extra) \ 10);
      END IF
   END IF
   ' Abschlieend ein Tabulatorzeichen fr weien Zug
   ' oder Zeilenschaltung fr schwarzen Zug
   IF Farbe = -1 THEN
      LPRINT CHR$(9);
   ELSE
      LPRINT
   END IF
END SUB

'--------------------------------------------------------------------
' Drucke das Zugzurcknehmen-Kommando
'--------------------------------------------------------------------
SUB DruckeZurueck
   IF Drucker = 0 THEN EXIT SUB   ' Nur wenn Druckfunktion aktiviert
   IF Farbe = 1 THEN
      LPRINT "   ZURUECK"
      ZuletztWeiss = 0
   ELSE
      LPRINT USING "###.   ZURUECK!"; ZugNr% \ 2 + 1; CHR$(9);
      ZuletztWeiss = 1
   END IF
END SUB

'-----------------------------------------------------------------------
' Verwandelt interne Feldnummer in Feldnotation.
' Falls die Nummer nicht im Brett liegt, wird '--' zurckgegeben.
'
' Anmerkungen:
' Der Operator \ ist die ganzzahlige Division.
' Der Operator mod (Modulo) liefert den Rest einer ganzzahligen Division.
'-----------------------------------------------------------------------
FUNCTION Feldnotation$ (FeldNum%)
   ' berprfe Korrektheit
   IF FeldNum% < 21 OR FeldNum% > 98 OR brett(FeldNum%) = 100 THEN
      Feldnotation$ = "--"
   ELSE
      S$ = CHR$(ASC("A") - 1 + FeldNum% MOD 10)          ' Linie
      S$ = S$ + CHR$(ASC("1") - 2 + FeldNum% \ 10)       ' Reihe
      Feldnotation$ = LCASE$(S$)
   END IF
END FUNCTION

'--------------------------------------------------------------------
' Verwandelt Feldnotation (z.B. "A1") in interne Feldnummer.
' Falls Eingabe nicht korrekt, wird "Illegal" zurckgegeben.
' Linienkoordinaten mssen als Grobuchstaben bergeben werden.
'--------------------------------------------------------------------
FUNCTION Feldnummer% (Feldnot$)
   Linie$ = LEFT$(Feldnot$, 1)
   Reihe$ = MID$(Feldnot$, 2, 1)
   ' Prfe Korrektheit
   IF Linie$ < "A" OR Linie$ > "H" OR Reihe$ < "1" OR Reihe$ > "8" THEN
      Feldnummer% = 0
      EXIT FUNCTION
   END IF
   Feldnummer% = (ASC(Linie$) - ASC("A") + 1) + 10 * (ASC(Reihe$) - ASC("1") + 2)
END FUNCTION

'--------------------------------------------------------------------
' Generiert Zge und legt sie auf ZugStapel.
' Gibt die Anzahl der Zge zurck.
' Falls "AlleZuege" grsser 0 ist, werden alle pseudolegalen
' Zge erzeugt, sonst alle pseudolegalen Schlagzge,
' Umwandlungen, Enpassant und die Rochade.
'--------------------------------------------------------------------
SUB GeneriereZuege (AlleZuege%)
   index = StapelGrenze(tiefe)     ' Anfang der Zugliste auf aktueller Tiefe
   Mobilitaet(tiefe) = 0

   FOR j% = 15 TO 0 STEP -1
      IF Farbe = 1 THEN
        figur% = SezFigBile(j%).figura
        von% = SezFigBile(j%).pole
      ELSE
        figur% = ABS(SezFigCerne(j%).figura)
        von% = SezFigCerne(j%).pole
      END IF
      IF von% = 0 THEN GOTO NaechstesFeld
      IF figur% = 1 THEN   ' Bauernzge
         IF Farbe = 1 THEN
            IF brett(von% + 10) = 0 THEN
               IF von% >= 81 THEN
                  CALL NotiereUmwandlung(von%, von% + 10)
               ELSEIF AlleZuege% > 0 THEN
                  CALL NotiereZug(von%, von% + 10)
                  ZugStapel(index - 1).extra = -1
                  ' Doppelschritt mglich?
                  IF von% <= 38 AND brett(von% + 20) = 0 THEN
                     CALL NotiereZug(von%, von% + 20)
                     ' Notiere Zug hat Index schon erhht
                     ZugStapel(index - 1).extra = (von% + 10) * 100
                  END IF
               END IF
            END IF
            IF brett(von% + 11) < 0 THEN  ' Bauer kann schwarze Figur schlagen
               IF von% >= 81 THEN
                  CALL NotiereUmwandlung(von%, von% + 11)
               ELSE
                  CALL NotiereSchlagzug(von%, von% + 11)
               END IF
            END IF
            IF brett(von% + 9) < 0 THEN  ' Ebenso in anderer Schlagrichtung
               IF von% >= 81 THEN
                  CALL NotiereUmwandlung(von%, von% + 9)
               ELSE
                  CALL NotiereSchlagzug(von%, von% + 9)
               END IF
            END IF
         ELSEIF Farbe = -1 THEN    ' Selbiges fr schwarze Bauern
            IF brett(von% - 10) = 0 THEN
               IF von% <= 38 THEN
                  CALL NotiereUmwandlung(von%, von% - 10)
               ELSEIF AlleZuege% > 0 THEN
                  CALL NotiereZug(von%, von% - 10)
                  ZugStapel(index - 1).extra = -1
                  ' Doppelschritt mglich?
                  IF von% >= 81 AND brett(von% - 20) = 0 THEN
                     CALL NotiereZug(von%, von% - 20)
                     ' Notiere Zug hat Index schon erhht
                     ZugStapel(index - 1).extra = (von% - 10) * 100
                  END IF
               END IF
            END IF
            ' Bei schwarzen Bauern mu man auch nach Rand abfragen,
            ' bei weien nicht, da der Rand>0 ist.
            IF brett(von% - 11) > 0 AND brett(von% - 11) <> 100 THEN
               IF von% <= 38 THEN
                  CALL NotiereUmwandlung(von%, von% - 11)
               ELSE
                  CALL NotiereSchlagzug(von%, von% - 11)
               END IF
            END IF
            IF brett(von% - 9) > 0 AND brett(von% - 9) <> 100 THEN
               IF von% <= 38 THEN
                  CALL NotiereUmwandlung(von%, von% - 9)
               ELSE
                  CALL NotiereSchlagzug(von%, von% - 9)
               END IF
            END IF
         END IF
         GOTO NaechstesFeld                    ' Untersuche nchstes Feld
      END IF

      ' Zge fr alle anderen Figuren werden ber
      ' Zugoffset berechnet.

      Langschritt% = FigOffset(figur%).Langschritt
      FOR i% = FigOffset(figur%).Anfang TO FigOffset(figur%).ende
         Richtung% = Offset(i%)
         nach% = von%
weitergleiten2:
         nach% = nach% + Richtung%
         IF brett(nach%) = 0 THEN
            IF AlleZuege% > 0 THEN
               CALL NotiereZug(von%, nach%)
            END IF
            IF Langschritt% THEN        ' Lufer, Turm und Dame
               GOTO weitergleiten2
            ELSE                        ' Springer und Knig
               GOTO NaechsteRichtung
            END IF
         END IF
         IF brett(nach%) = 100 THEN  ' Auf Randfeld getroffen, in anderer
            GOTO NaechsteRichtung      ' Richtung weitersuchen.
         END IF
         ' Auf Figur gestossen. Mu von richtiger Farbe sein.
         Schlagzug% = Farbe = 1 AND brett(nach%) < 0
         Schlagzug% = Schlagzug% OR (Farbe = -1 AND brett(nach%) > 0)
         IF Schlagzug% THEN CALL NotiereSchlagzug(von%, nach%)
NaechsteRichtung:
      NEXT i%
NaechstesFeld:
   NEXT j%

   ' Enpassant Zug

   IF EpFeld(tiefe) <> 0 THEN
      ep% = EpFeld(tiefe)
      IF Farbe = 1 THEN
         IF brett(ep% - 9) = 1 THEN
            CALL NotiereEpzug(ep% - 9, ep%, ep% - 10)
         END IF
         IF brett(ep% - 11) = 1 THEN
            CALL NotiereEpzug(ep% - 11, ep%, ep% - 10)
         END IF
      ELSE
         IF brett(ep% + 9) = -1 THEN
            CALL NotiereEpzug(ep% + 9, ep%, ep% + 10)
         END IF
         IF brett(ep% + 11) = -1 THEN
            CALL NotiereEpzug(ep% + 11, ep%, ep% + 10)
         END IF
      END IF
   END IF

   ' Rochade wird auch in Ruhesuche ausgefhrt, weil sie die Bewertung
   ' stark verndert. (Ob das sinnvoll ist, darber scheiden sich
   ' auch bei den Spitzenprogrammierern die Geister).

   ' Berechne Rochade
   IF Farbe = 1 THEN
      IF SezFigBile(0).pole = 25 AND SezFigBile(0).pohyb = 0 THEN
         ' je kratka rochada mozna ? (v tomto provedeni akceptuji moznou
         ' chybnou detekci rochady pri trech vezich na sachovnici)
         OK% = (SezFigBile(2).pole = 28 AND SezFigBile(2).pohyb = 0) OR (SezFigBile(3).pole = 28 AND SezFigBile(3).pohyb = 0)
         OK% = OK% AND brett(26) = 0 AND brett(27) = 0
         OK% = OK% AND AttackiertFeld%(25, -1) = 0
         OK% = OK% AND AttackiertFeld%(26, -1) = 0
         OK% = OK% AND AttackiertFeld%(27, -1) = 0
         IF OK% THEN
            CALL NotiereZug(25, 27)         ' Notiere Knigszug
            ZugStapel(index - 1).extra = 7
         END IF
         ' je dlouha rochada mozna ? (v tomto provedeni akceptuji moznou
         ' chybnou detekci rochady pri trech vezich na sachovnici)
         OK% = (SezFigBile(2).pole = 21 AND SezFigBile(2).pohyb = 0) OR (SezFigBile(3).pole = 21 AND SezFigBile(3).pohyb = 0)
         OK% = OK% AND brett(24) = 0
         OK% = OK% AND brett(23) = 0
         OK% = OK% AND brett(22) = 0
         OK% = OK% AND AttackiertFeld%(25, -1) = 0
         OK% = OK% AND AttackiertFeld%(24, -1) = 0
         OK% = OK% AND AttackiertFeld%(23, -1) = 0
         IF OK% THEN
            CALL NotiereZug(25, 23)           ' Notiere Knigszug
            ' Notiere Art der Rochade
            ZugStapel(index - 1).extra = 8
         END IF
      END IF
   ELSE                                         ' Schwarz am Zug
      IF SezFigCerne(0).pole = 95 AND SezFigCerne(0).pohyb = 0 THEN
         ' je kratka rochada mozna ? (v tomto provedeni akceptuji moznou
         ' chybnou detekci rochady pri trech vezich na sachovnici)
         OK% = (SezFigCerne(2).pole = 98 AND SezFigCerne(2).pohyb = 0) OR (SezFigCerne(3).pole = 98 AND SezFigCerne(3).pohyb = 0)
         OK% = OK% AND brett(96) = 0 AND brett(97) = 0
         OK% = OK% AND AttackiertFeld%(95, 1) = 0
         OK% = OK% AND AttackiertFeld%(96, 1) = 0
         OK% = OK% AND AttackiertFeld%(97, 1) = 0
         IF OK% THEN
            CALL NotiereZug(95, 97)           ' Notiere Knigszug
            ZugStapel(index - 1).extra = 7
         END IF
         ' je dlouha rochada mozna ? (v tomto provedeni akceptuji moznou
         ' chybnou detekci rochady pri trech vezich na sachovnici)
         OK% = (SezFigCerne(2).pole = 91 AND SezFigCerne(2).pohyb = 0) OR (SezFigCerne(3).pole = 91 AND SezFigCerne(3).pohyb = 0)
         OK% = OK% AND brett(94) = 0
         OK% = OK% AND brett(93) = 0
         OK% = OK% AND brett(92) = 0
         OK% = OK% AND AttackiertFeld%(95, 1) = 0
         OK% = OK% AND AttackiertFeld%(94, 1) = 0
         OK% = OK% AND AttackiertFeld%(93, 1) = 0
         IF OK% THEN
            CALL NotiereZug(95, 93)           ' Notiere Knigszug
            ' Notiere Art der Rochade
            ZugStapel(index - 1).extra = 8
         END IF
      END IF
   END IF
   StapelGrenze(tiefe + 1) = index              ' Merke Ende der Zugliste
END SUB

SUB Hodiny
  IF Level% > 25 AND Level% < 80 THEN
    GET #5, Level%, i%
    IF Level% > 25 AND Level% < 55 THEN
        GET #5, Level% + 1, l%
        IF ZugNr% \ 2 = l% THEN             'po zahrani stanoveneho poctu
            CasBily% = CasBily% - i%        'tahu je treba snizit hodnotu,
            CasCerny% = CasCerny% - i%      'aby neprekrocila rozsah integer.
        END IF
    END IF
    j% = i% - CasBily%
    k% = i% - CasCerny%
  ELSE
    IF CasBily% > 21600 THEN CasBily% = 0   'po sesti hodinach se nuluji hodiny,
    IF CasCerny% > 21600 THEN CasCerny% = 0 'protoze hodnota nesmi prekrocit
                                            'rozsah integer do ca 32000 !
    j% = CasBily%
    k% = CasCerny%
  END IF
  VypisCasu j%, 15, 9, 58
  VypisCasu k%, 12, 9, 68
END SUB

'--------------------------------------------------------------------
' Berechnet die Bauernkontrolle und die Linien auf denen Bauern und
' Trme stehen. Wird von der Bewertungsfunktion zu Beginn
' aufgerufen.
'--------------------------------------------------------------------
SUB InitBewertung
   ' Lsche Bauernkontrolle
   FOR i% = 21 TO 98
      BKontrolle(i%).Weiss = 0
      BKontrolle(i%).Schwarz = 0
   NEXT i%

   ' Rnder mit initialisieren. Damit braucht man
   ' bei Randlinien nicht extra abfragen.

   FOR i% = 0 TO 9
      Bauern(i%).Weiss = 0
      Bauern(i%).Schwarz = 0
      Tuerme(i%).Weiss = 0
      Tuerme(i%).Schwarz = 0
   NEXT i%

   FOR i% = 0 TO 31
      IF i% < 16 THEN
        figura% = SezFigBile(i%).figura
        pole% = SezFigBile(i%).pole
      ELSE
        figura% = SezFigCerne(i% - 16).figura
        pole% = SezFigCerne(i% - 16).pole
      END IF
      IF pole% = 0 THEN GOTO NaechstFeld
      IF ABS(figura%) > 2 THEN GOTO NaechstFeld
      SELECT CASE figura%
      CASE 1
         BKontrolle(pole% + 9).Weiss = BKontrolle(pole% + 9).Weiss + 1
         BKontrolle(pole% + 11).Weiss = BKontrolle(pole% + 11).Weiss + 1
         Bauern(pole% MOD 10).Weiss = Bauern(pole% MOD 10).Weiss + 1
      CASE -1
         BKontrolle(pole% - 9).Schwarz = BKontrolle(pole% - 9).Schwarz + 1
         BKontrolle(pole% - 11).Schwarz = BKontrolle(pole% - 11).Schwarz + 1
         Bauern(pole% MOD 10).Schwarz = Bauern(pole% MOD 10).Schwarz + 1
      CASE -2
         Tuerme(pole% MOD 10).Schwarz = Tuerme(pole% MOD 10).Schwarz + 1
      CASE 2
         Tuerme(pole% MOD 10).Weiss = Tuerme(pole% MOD 10).Weiss + 1
      CASE ELSE
      END SELECT
NaechstFeld:
   NEXT i%
END SUB

'--------------------------------------------------------------------
'  Initialisiert das Brett und den Spielstatus
'--------------------------------------------------------------------
SUB Initialisiere (Nova%)
   CLS
   IF Nova% = 1 THEN
      OPEN "zaklpos.mru" FOR RANDOM AS #1 LEN = 2
      i% = 0
      PUT #3, 2, i%
      BookIndex% = 1
      CasBily% = 0
      CasCerny% = 0
   ELSE
      GET #3, 2, i%
      IF i% = 1 THEN
        OPEN "lastpos.mru" FOR RANDOM AS #1 LEN = 2
        BookIndex% = 0               'malo pravdepodobne, ze zadana
                                     'pozice je v knize zahajeni
        'Initialisiere 1 'kvuli nezname chybe nutne takto
        'EXIT SUB
      ELSE
        OPEN "zaklpos.mru" FOR RANDOM AS #1 LEN = 2
        BookIndex% = 1
      END IF
   END IF
   FOR i% = 0 TO 119
     GET #1, i% + 1, j%
     brett(i%) = j%
   NEXT i%
   GET #1, 121, ZugNr%
   FOR i% = 0 TO 2
      GET #1, 122 + i%, j%
      Rochade(i%) = j%
   NEXT i%
   GET #1, 125, EpFeld(0)
   GET #1, 126, MatSumme(0)
   GET #1, 127, MatBilanz(0)
   GET #1, 128, StapelGrenze(0)
   GET #1, 129, tiefe%
   GET #1, 130, Farbe%
   GET #1, 131, Preruseni%
   GET #1, 132, PoziceKurzoru%
   CLS
   FOR i% = 0 TO 15
      GET #1, i% * 3 + 133, SezFigBile(i%).figura
      GET #1, i% * 3 + 134, SezFigBile(i%).pole
      GET #1, i% * 3 + 135, SezFigBile(i%).pohyb
      GET #1, i% * 3 + 181, SezFigCerne(i%).figura
      GET #1, i% * 3 + 182, SezFigCerne(i%).pole
      GET #1, i% * 3 + 183, SezFigCerne(i%).pohyb
   NEXT i%
   CLOSE #1
   IF Nova% = 0 THEN
      GET #3, 1, k%       'Pocet tahu ulozene partie, nelze pouzit ZugNr%, protoze je pri nacitani menena
      GET #4, 8, CasBily%
      GET #4, 9, CasCerny%
      IF k% > 0 THEN
        PrehrajPartii k%, 0
      END IF
   END IF
END SUB

'--------------------------------------------------------------------
' Initialisiere den Spielbaum
'--------------------------------------------------------------------
SUB InitSpielbaum
   ' In Tiefe 0 ist noch nichts gerechnet, Spielbaum bereits initialisiert
   IF tiefe = 0 THEN EXIT SUB
   EpFeld(0) = EpFeld(1)
   MatBilanz(0) = MatBilanz(1)
   MatSumme(0) = MatSumme(1)
   tiefe = 0
END SUB

SUB KeyBufferNull
DO
LOOP UNTIL INKEY$ = ""
END SUB

'----------------------------------------------------------------------
'  Liest in einer Schleife die Kommandos des Spielers ein und ruft
'  die entsprechenden Funktionen auf. Schleife wird durch das "EN"
'  Kommando beendet.
'  Wird die Eingabe nicht als Kommando erkannt, wird sie als Zug
'  interpretiert (in Darstellung "e2e4" (vonfeld,nachfeld)).
'  Das Kommando fr die Zugeingabe entfllt daher.
'  Nove umoznuje take ovladani pomoci kurzoru
'--------------------------------------------------------------------
SUB KommandoSchleife
startovladace:
   Hodiny
   StartCas = TIMER
smycka:
   IF TIMER < StartCas THEN StartCas = StartCas - 86400
   COLOR 7
   ende% = 0
   NapisKdoTahne 1
   Preruseni% = 0
   KeyBufferNull
   CistiRadek 29, 29
   LOCATE , 55: Vystup 86: PRINT ; ":";
   Prikaz$ = ""
   i% = 0
   DO
    j% = VstupKlavesnice%
    IF j% = 0 THEN
    Preruseni% = FIX(RND)
    ELSE
     IF j% < 326 THEN CistiRadek 11, 17: NapisKdoTahne 1
     SELECT CASE j%
        CASE 314             'F1
          VypisOvladani 1
        CASE 315             'F2
          VypisOvladani 0
        CASE 316             'F3
          Prikaz$ = "TI"
          i% = 1
        CASE 317             'F4
          Prikaz$ = "PB"
          i% = 1
        CASE 318             'F5
          Prikaz$ = "ZS"
          i% = 1
        CASE 319             'F6
          Prikaz$ = "ZT"
          i% = 1
        CASE 320             'F7
          Prikaz$ = "BD"
          i% = 1
        CASE 321             'F8
          Prikaz$ = "DR"
          i% = 1
        CASE 322             'F9
          Prikaz$ = "MZ"
          i% = 1
        CASE 323             'F10
          Prikaz$ = "SP"
          i% = 1
        CASE 2               'Ctrl+B
          Prikaz$ = "ZU"
          i% = 1
        CASE 10             'Ctrl+J
          CALL Options(5)
          TiskniRamecky
        CASE 11             'Ctrl+K
          BookIndex% = 0    'vypni knihovnu, pri volbe nova partie se sama zapne
        CASE 14             'Ctrl+N
          Prikaz$ = "AN"
          i% = 1
        CASE 24             'Ctrl+X
          Prikaz$ = "EN"
          i% = 1
        CASE 13             'enter
          'Pokousi se odeslat prikaz
          IF LEN(Prikaz$) = 2 THEN
            'pokyn k nejake cinnosti
            IF VAL(RIGHT$(Prikaz$, 1)) = 0 THEN
                i% = 1 'ukonci smycku a testuj prikaz
            ELSE
                'zadava cilove pole Enterem
                Prikaz$ = Prikaz$ + UCASE$(Feldnotation$(PoziceKurzoru))
                i% = 1
            END IF
          ELSE
            IF LEN(Prikaz$) < 2 THEN 'ber to jako zadani vychoziho pole
                Prikaz$ = Feldnotation$(PoziceKurzoru)
            ELSE ' a tohle ber jako pokus o odeslani tahu
                i% = 1 'ukonci smycku a testuj prikaz
            END IF
          END IF
        CASE 8, 27          'esc nebo back maze posledni znak
          MazZnak Prikaz$
        CASE ELSE            'pismeno nebo cislo, rozsah ascii=65-90,48-57
          IF (j% > 64 AND j% < 91) OR (j% > 47 AND j% < 58) THEN
            IF LEN(Prikaz$) < 5 THEN
              Prikaz$ = Prikaz$ + CHR$(j%)
            ELSE
              Prikaz$ = LEFT$(Prikaz$, 4) + CHR$(j%)
            END IF
          END IF
     END SELECT
     Prikaz$ = UCASE$(Prikaz$)      ' Umwandlung in Grobuchstaben
     CistiRadek 29, 29
     LOCATE , 55: Vystup 86: PRINT ; ": "; Prikaz$;
    END IF
   LOOP UNTIL i% = 1
      SELECT CASE Prikaz$
         CASE "EN"
            ende% = 1
            CALL Spielende
         CASE "AN"
            CALL Initialisiere(1)
            CALL KresliSachovnici
            CALL TiskniRamecky
            GOTO startovladace
         CASE "BR"
            CALL CistiRadek(11, 27)
            CALL Brettausgabe(0)
            CALL CistiRadek(11, 27)
            CALL Zugliste
            CALL TiskniRamecky
         CASE "PB"
            CALL CistiRadek(11, 27)
            CALL Stellungseingabe
            CALL TiskniRamecky
            GOTO startovladace
         CASE "SP"
            ZmenaPoziceKurzoru 0 'Nehyzdi desku kurzorem behem analyzy
            IF PocetHracu% = 2 THEN PocetHracu% = 1: PUT #4, 6, PocetHracu%'Uz ti nezadavam tahy, makej
            DO
              CistiRadek 29, 29
              CALL Computerzug
              KresliSachovnici
              NapisKdoTahne 1
              Hodiny
            LOOP UNTIL PocetHracu% > 0 'Pokud si mel analyzovat, tahej dokud te neprerusim
            ZmenaPoziceKurzoru ZugStapel(AktZug%).tah MOD 100
            GOTO startovladace
         CASE "BD"
            CALL Options(2)
         CASE "DR"
            CALL Options(4)
         CASE "MZ"
            PocetHracu% = PocetHracu% + 1
            IF PocetHracu% > 2 THEN PocetHracu% = 0
            PUT #4, 6, PocetHracu%
            NapisKdoTahne 1
         CASE "ZU"
            CALL ZugZurueck
         CASE "TI"
            CALL Options(3)
            GOTO startovladace
         CASE "BE"
            CALL InitSpielbaum
            COLOR 7
            LOCATE 27, 55
            Vystup 90
            PRINT ; BewerteStellung%(-32000, 32000, Farbe);
         CASE "ZS"
            CALL Options(1)
         CASE "ZT"
            CALL Options(0)
         CASE ELSE
            IF Zugeingabe%(Prikaz$) = 0 THEN
               KeyBufferNull
               ChybneZadani
               ZmenaPoziceKurzoru 35
            ELSE
               KeyBufferNull
               KresliSachovnici
               Cas% = TIMER - StartCas
               IF Farbe = -1 THEN
                    CasBily% = CasBily% + Cas%
               ELSE
                    CasCerny% = CasCerny% + Cas%
               END IF
               Hodiny
               IF PocetHracu% < 2 THEN   'Mas-li hrat, tahej
                  DO
                    CistiRadek 29, 29
                    CALL Computerzug
                    KresliSachovnici
                    NapisKdoTahne 1
                    Hodiny
                  LOOP UNTIL PocetHracu% > 0 'Pokud si mel analyzovat, tahej dokud te neprerusim
                  ZmenaPoziceKurzoru ZugStapel(AktZug%).tah MOD 100
                  GOTO startovladace
               END IF
            END IF
      END SELECT
     GOTO smycka
END SUB

'--------------------------------------------------------------------
' Trgt den aktuellen Zug in die Hauptvariante ein und kopiert
' die Fortsetzung, die auf der nchsten Tiefe gefunden wurde.
'--------------------------------------------------------------------
SUB KopiereHvar (AktZug%)
   ' Neue Hauptvariante ist Fortsetzung dieser Variante
   HVar(tiefe, tiefe) = ZugStapel(AktZug%).tah
   i% = 0
   DO
      i% = i% + 1
      HVar(tiefe, tiefe + i%) = HVar(tiefe + 1, tiefe + i%)
   LOOP UNTIL HVar(tiefe + 1, tiefe + i%) = 0
END SUB

SUB KresliDesku
GET #4, 1, Otoceni%
IF Otoceni% = 0 THEN
    FOR i% = 0 TO 8
    LINE (20, 64 + 48 * i%)-(404, 64 + 48 * i%), 8
    LINE (20 + 48 * i%, 64)-(20 + 48 * i%, 448), 8
    IF i% < 8 THEN LOCATE 6 + 3 * i%, 1: PRINT USING "#"; 8 - i%;
    NEXT i%
    LOCATE 30, 6: PRINT ; "a     b     c     d     e     f     g     h";
ELSE
    FOR i% = 0 TO 8
    LINE (20, 64 + 48 * i%)-(404, 64 + 48 * i%), 8
    LINE (20 + 48 * i%, 64)-(20 + 48 * i%, 448), 8
    IF i% <> 8 THEN LOCATE 6 + 3 * i%, 1: PRINT USING "#"; i% + 1;
    NEXT i%
    LOCATE 30, 6: PRINT ; "h     g     f     e     d     c     b     a";
END IF
END SUB

SUB KresliFiguru (x%, y%, figura%, Kurzor%)
  GET #4, 2, SvetlaP%
  GET #4, 3, TmavaP%
  IF (x% + 4) MOD 96 = 48 AND (y% + 8) MOD 96 = 0 OR (x% + 4) MOD 96 = 0 AND (y% + 8) MOD 96 = 48 THEN
    PAINT (x%, y%), SvetlaP%, 8
  ELSE
    PAINT (x%, y%), TmavaP%, 8
  END IF
  IF Kurzor% = 1 THEN
    LINE (x% - 21, y% - 21)-(x% + 23, y% + 21), 1
    LINE (x% - 21, y% + 21)-(x% + 23, y% - 21), 1
    FOR i% = 14 TO -21 STEP -7
    LINE (x% - 21, y% - i%)-(x% + i%, y% + 21), 1
    LINE (x% - i%, y% - 21)-(x% + 21, y% + i%), 1
    LINE (x% - i%, y% + 21)-(x% + 21, y% - i%), 1
    LINE (x% - 21, y% + i%)-(x% + i%, y% - 21), 1
    NEXT i%
  END IF
  IF figura% = 0 THEN EXIT SUB
  COLOR 0
  IF SGN(figura%) = 1 THEN
    vypln% = 15
  ELSE
    vypln% = 0
  END IF
  SELECT CASE ABS(figura%)
    CASE 1
      LINE (x% - 15, y% + 20)-(x% + 15, y% + 20)
      LINE (x% - 15, y% + 20)-(x% - 12, y% + 13)
      LINE (x% + 15, y% + 20)-(x% + 12, y% + 13)
      LINE (x% - 5, y% + 13)-(x% - 12, y% + 13)
      LINE (x% + 5, y% + 13)-(x% + 12, y% + 13)
      LINE (x% - 5, y% + 13)-(x% - 5, y% - 4)
      LINE (x% + 5, y% + 13)-(x% + 5, y% - 4)
      LINE (x% - 10, y% - 4)-(x% - 5, y% - 4)
      LINE (x% + 10, y% - 4)-(x% + 5, y% - 4)
      LINE (x% - 10, y% - 4)-(x% - 10, y% - 7)
      LINE (x% + 10, y% - 4)-(x% + 10, y% - 7)
      LINE (x% - 5, y% - 7)-(x% - 10, y% - 7)
      LINE (x% + 5, y% - 7)-(x% + 10, y% - 7)
      CIRCLE (x%, y% - 7), 5, 0, 0#, 3.1415#
      PAINT (x%, y%), vypln%, 0
    CASE 2
      LINE (x% + 15, y% + 20)-(x% - 15, y% + 20)
      LINE (x% + 15, y% + 20)-(x% + 10, y% + 10)
      LINE (x% - 15, y% + 20)-(x% - 10, y% + 10)
      LINE (x% + 10, y% + 10)-(x% + 10, y%)
      LINE (x% - 10, y% + 10)-(x% - 10, y%)
      LINE (x% + 18, y% - 5)-(x% + 10, y%)
      LINE (x% - 18, y% - 5)-(x% - 10, y%)
      LINE (x% + 18, y% - 5)-(x% + 18, y% - 15)
      LINE (x% - 18, y% - 5)-(x% - 18, y% - 15)
      LINE (x% + 14, y% - 15)-(x% + 18, y% - 15)
      LINE (x% - 14, y% - 15)-(x% - 18, y% - 15)
      LINE (x% + 14, y% - 15)-(x% + 14, y% - 10)
      LINE (x% - 14, y% - 15)-(x% - 14, y% - 10)
      LINE (x% + 10, y% - 10)-(x% + 14, y% - 10)
      LINE (x% - 10, y% - 10)-(x% - 14, y% - 10)
      LINE (x% + 10, y% - 10)-(x% + 10, y% - 15)
      LINE (x% - 10, y% - 10)-(x% - 10, y% - 15)
      LINE (x% + 6, y% - 15)-(x% + 10, y% - 15)
      LINE (x% - 6, y% - 15)-(x% - 10, y% - 15)
      LINE (x% + 6, y% - 15)-(x% + 6, y% - 10)
      LINE (x% - 6, y% - 15)-(x% - 6, y% - 10)
      LINE (x% + 2, y% - 10)-(x% + 6, y% - 10)
      LINE (x% - 2, y% - 10)-(x% - 6, y% - 10)
      LINE (x% + 2, y% - 10)-(x% + 2, y% - 15)
      LINE (x% - 2, y% - 10)-(x% - 2, y% - 15)
      LINE (x% + 2, y% - 15)-(x% - 2, y% - 15)
      PAINT (x%, y%), vypln%, 0
    CASE 3
      LINE (x% - 15, y% + 20)-(x% + 15, y% + 20)
      LINE (x% - 15, y% + 20)-(x% - 13, y% + 13)
      LINE (x% + 15, y% + 20)-(x% + 13, y% + 13)
      LINE (x% - 6, y% + 13)-(x% - 13, y% + 13)
      LINE (x% + 6, y% + 13)-(x% + 13, y% + 13)
      LINE (x% - 6, y% + 13)-(x% - 12, y% - 2)
      LINE (x% + 6, y% + 13)-(x% + 12, y% - 2)
      LINE (x% - 4, y% - 20)-(x% - 12, y% - 2)
      LINE (x% + 4, y% - 20)-(x% + 12, y% - 2)
      LINE (x% - 4, y% - 20)-(x%, y% - 10)
      LINE (x% + 4, y% - 20)-(x%, y% - 10)
      PAINT (x%, y%), vypln%, 0
    CASE 4
      LINE (x% + 15, y% + 20)-(x% - 15, y% + 20)
      LINE (x% + 15, y% + 20)-(x% + 8, y% - 18)
      LINE (x% + 4, y% - 8)-(x% + 8, y% - 18)
      LINE (x% + 4, y% - 8)-(x%, y% - 18)
      LINE (x% - 4, y% - 8)-(x%, y% - 18)
      LINE (x% - 4, y% - 8)-(x% - 14, y% + 5)
      LINE (x% - 10, y% + 7)-(x% - 14, y% + 5)
      LINE (x% - 10, y% + 7)-(x% - 2, y% + 6)
      LINE (x% - 2, y% + 6)-(x%, y% + 6)
      LINE (x% - 15, y% + 20)-(x%, y% + 6)
      PAINT (x%, y%), vypln%, 0
    CASE 5
      LINE (x% + 10, y% + 20)-(x% - 10, y% + 20)
      LINE (x% + 10, y% + 20)-(x% + 20, y% - 20)
      LINE (x% - 10, y% + 20)-(x% - 20, y% - 20)
      LINE (x% + 20, y% - 20)-(x% + 10, y%)
      LINE (x% - 20, y% - 20)-(x% - 10, y%)
      LINE (x% + 10, y%)-(x% + 7, y% - 20)
      LINE (x% - 10, y%)-(x% - 7, y% - 20)
      LINE (x%, y% - 1)-(x% + 7, y% - 20)
      LINE (x%, y% - 1)-(x% - 7, y% - 20)
      PAINT (x%, y%), vypln%, 0
    CASE ELSE
      LINE (x% - 15, y% + 20)-(x% + 15, y% + 20)
      LINE (x% - 15, y% + 20)-(x% - 20, y% - 5)
      LINE (x% + 15, y% + 20)-(x% + 20, y% - 5)
      LINE (x% - 20, y% - 5)-(x% - 15, y% - 15)
      LINE (x% + 20, y% - 5)-(x% + 15, y% - 15)
      LINE (x% - 10, y% - 5)-(x% - 15, y% - 15)
      LINE (x% + 10, y% - 5)-(x% + 15, y% - 15)
      LINE (x% - 10, y% - 5)-(x% - 4, y% - 5)
      LINE (x% + 10, y% - 5)-(x% + 4, y% - 5)
      LINE (x% - 4, y% - 10)-(x% - 4, y% - 5)
      LINE (x% + 4, y% - 10)-(x% + 4, y% - 5)
      LINE (x% - 4, y% - 10)-(x% - 9, y% - 10)
      LINE (x% + 4, y% - 10)-(x% + 9, y% - 10)
      LINE (x% - 9, y% - 15)-(x% - 9, y% - 10)
      LINE (x% + 9, y% - 15)-(x% + 9, y% - 10)
      LINE (x% - 9, y% - 15)-(x% - 4, y% - 15)
      LINE (x% + 9, y% - 15)-(x% + 4, y% - 15)
      LINE (x% - 4, y% - 20)-(x% - 4, y% - 15)
      LINE (x% + 4, y% - 20)-(x% + 4, y% - 15)
      LINE (x% - 4, y% - 20)-(x% + 4, y% - 20)
      PAINT (x%, y%), vypln%, 0
  END SELECT
  COLOR 7
END SUB

SUB KresliSachovnici
GET #4, 1, Otoceni%
KresliDesku
FOR i% = 9 TO 2 STEP -1             ' Pro vsechny rady
    FOR j% = 1 TO 8         ' Pro vsechny sloupce
      IF Otoceni% = 0 THEN
        GET #6, i% - 1, y%
        GET #6, j% + 8, x%
      ELSE
        GET #6, 10 - i%, y%
        GET #6, 17 - j%, x%
      END IF
      figura% = brett(i% * 10 + j%)
      IF PoziceKurzoru% = i% * 10 + j% THEN
        KresliFiguru x%, y%, figura%, 1
      ELSE
        KresliFiguru x%, y%, figura%, 0
      END IF
    NEXT j%
NEXT i%
END SUB

'--------------------------------------------------------------------
' Liest die Figuren/Steine fr die Seite "F"
' Format ist: <Figur><Feld> z.B. "Ke1".
' "." ist "leeres Feld", d.h. entfernt darauf stehende Figur.
'--------------------------------------------------------------------
SUB LiesSteine (figura%, pole%)
IF figura% <> 0 THEN
   IF ZapisFigury(figura% * Farbe, pole%) = 1 THEN
      brett(pole%) = figura% * Farbe  ' Setze Figur auf das Brett
      KresliSachovnici
   ELSE
      ChybneZadani
      EXIT SUB
   END IF
ELSE
   brett(pole%) = 0
   FOR i% = 0 TO 15
      IF SezFigBile(i%).pole = pole% THEN SezFigBile(i%).pole = 0
      IF SezFigCerne(i%).pole = pole% THEN SezFigCerne(i%).pole = 0
   NEXT i%
   KresliSachovnici
END IF
END SUB

SUB MazZnak (Prikaz$)
   IF LEN(Prikaz$) > 0 THEN
      Prikaz$ = LEFT$(Prikaz$, LEN(Prikaz$) - 1)
   ELSE
   END IF
END SUB

'--------------------------------------------------------------------
' Aus den mglichen Zgen einer bestimmten Tiefe wird der beste
' noch nicht gespielte Zug ausgewhlt. Gibt den Index des Zuges
' am Zugstapel zurck. Wenn bereits alle Zge gespielt wurden,
' wird ein unmglicher Index (-1) zurck gegeben.
' Der Wert eines Zuges wird vom Zuggenerator bestimmt.
' Diese Funktion erledigt die Zugsortierung in der Suche.
'--------------------------------------------------------------------
FUNCTION NaechstbesterZug%
   BesterZug% = -1
   BesterWert% = -32000
   FOR i% = StapelGrenze(tiefe) TO StapelGrenze(tiefe + 1) - 1
      IF ZugStapel(i%).wert > BesterWert% THEN ' Neuer bester Zug gefunden
         BesterZug% = i%
         BesterWert% = ZugStapel(i%).wert
      END IF
   NEXT i%
   ' Markiere ausgewhlten Zug, damit er beim nchsten Aufruf
   ' nicht noch einmal ausgewhlt wird.
   IF BesterZug% >= 0 THEN ZugStapel(BesterZug%).wert = -32000
   NaechstbesterZug% = BesterZug%
END FUNCTION

SUB NapisKdoTahne (posltahy%)
FOR i% = 5 TO 7
    LOCATE i%, 63
    PRINT STRING$(10, " ");
NEXT i%
COLOR 15
LOCATE 5, 64
Vystup 78 + PocetHracu%
LOCATE 6, 63
IF Level% < 28 THEN GET #5, Level% + 2, Solltiefe%: PRINT ; STR$(Solltiefe%); " "; : Vystup 81
IF Level% > 27 AND Level% < 55 THEN GET #5, Level%, PocetSekund%: GET #5, Level% + 1, Pocettahu%: PRINT ; STR$(PocetSekund% \ 60); "/"; STR$(Pocettahu%);
IF Level% > 54 AND Level% < 82 THEN GET #5, Level%, PocetSekund%: PRINT ; STR$(PocetSekund% \ 60); " "; : Vystup 82
IF Level% > 81 THEN GET #5, Level%, PocetSekund%: PRINT ; STR$(PocetSekund%); " "; : Vystup 83
LOCATE 7, 64
IF Farbe = 1 THEN
  Vystup 84
ELSE
  COLOR 12
  Vystup 85
END IF
IF posltahy% = 0 THEN COLOR 7: EXIT SUB
COLOR 7
CistiRadek 11, 17
k% = 0
FOR i% = ZugNr% - 13 TO ZugNr%
   IF i% > 0 THEN
    k% = k% + 1
    IF k% = 1 AND i% MOD 2 = 0 THEN k% = 0: GOTO preskoc
    GET #3, i% * 3, j%
    Prikaz$ = LCASE$(Feldnotation$(j% \ 100) + Feldnotation$(j% MOD 100))
    IF i% MOD 2 = 1 THEN
        COLOR 15
        LOCATE 11 + k% \ 2, 58 - LEN(STR$((i% + 1) \ 2)): PRINT ; STR$((i% + 1) \ 2); ".";
        LOCATE 11 + k% \ 2, 60
    ELSE
        COLOR 12
        LOCATE 11 + (k% - 1) \ 2, 70
    END IF
    GET #3, i% * 3 + 1, l%
    GET #3, i% * 3 + 2, m%
    IF m% > 0 THEN
      ep% = m% \ 100
      Promena% = (m% - ep% * 100) \ 10
      brani% = m% - ep% * 100 - Promena% * 10
      IF brani% > 6 THEN brani% = 0
    ELSE
      ep% = 0
      brani% = 0
      Promena% = 0
    END IF
    IF m% = 7 THEN PRINT "  0-0"; : GOTO preskoc
    IF m% = 8 THEN PRINT " 0-0-0"; : GOTO preskoc
    IF FigSymbol(l%) = "P" THEN
        PRINT " ";
    ELSE
        PRINT FigSymbol(l%);
    END IF
    PRINT Feldnotation$(j% \ 100);
    IF brani% < 1 THEN
        PRINT "-";
    ELSE
        PRINT ":";
    END IF
    PRINT Feldnotation$(j% MOD 100);
    IF Promena% > 0 THEN PRINT FigSymbol(Promena%);
   END IF
preskoc:
NEXT i%
COLOR 7
END SUB

'--------------------------------------------------------------------
' Trage Enpassant-Zug in Zugstapel ein.
'--------------------------------------------------------------------
SUB NotiereEpzug (von%, nach%, ep%)
   ' Knig kann nicht geschlagen werden
   IF brett(nach%) = 6 OR brett(nach%) = -6 THEN EXIT SUB
   ZugStapel(index).tah = von% * 100 + nach%
   ZugStapel(index).extra = 1 + 100 * ep%
   ZugStapel(index).wert = 100

   IF index < 1000 THEN     ' Verhindere berlauf des Zugstapels
      index = index + 1
   ELSE
      COLOR 7
      Vystup 77
      SLEEP
      SYSTEM                                     ' Zurck nach DOS
   END IF
END SUB

'--------------------------------------------------------------------
' Trage Schlagzug in Zugstapel ein.
'--------------------------------------------------------------------
SUB NotiereSchlagzug (von%, nach%)
   ' Knig kann nicht geschlagen werden
   IF brett(nach%) = 6 OR brett(nach%) = -6 THEN EXIT SUB

   FigWert% = FigMaterial(ABS(brett(nach%)))
   ZugStapel(index).tah = von% * 100 + nach%
   ZugStapel(index).extra = ABS(brett(nach%))

   ' Fr die Zugsortierung gilt: Schlage mit mglichst kleiner
   ' Figur mglichst wertvolle gegnerische Figuren
   ZugStapel(index).wert = FigWert% - (FigMaterial(ABS(brett(von%))) \ 8)

   ' Extra Bonus fr das Schlagen der zuletzt gezogenen Figur
   IF tiefe > 0 THEN
      IF nach% = NachFeld(tiefe - 1) THEN
         ZugStapel(index).wert = ZugStapel(index).wert + 300
      END IF
   END IF


   ' Bonus fr Hauptvarianten-Zge und "Killer"
   Killer1% = KillerTab(tiefe).Killer1% = von% * 100 + nach%
   Killer2% = KillerTab(tiefe).Killer2% = von% * 100 + nach%
   Killer3% = KillerTab(tiefe).Killer3% = von% * 100 + nach%
   Killer4% = KillerTab(tiefe).Killer4% = von% * 100 + nach%
   HvarZug% = HVar(0, tiefe) = von% * 100 + nach%
   IF HvarZug% THEN
      ZugStapel(index).wert = ZugStapel(index).wert + 500
   ELSEIF Killer1% THEN
      ZugStapel(index).wert = ZugStapel(index).wert + 250
   ELSEIF Killer2% THEN
      ZugStapel(index).wert = ZugStapel(index).wert + 150
   ELSEIF Killer3% THEN
      ZugStapel(index).wert = ZugStapel(index).wert + 100
   ELSEIF Killer4% THEN
      ZugStapel(index).wert = ZugStapel(index).wert + 50
   END IF
  
   IF index < 1000 THEN     ' Verhindere berlauf des Zugstapels
      index = index + 1
   ELSE
      COLOR 7
      LOCATE 27, 55: Vystup 77
      SLEEP
      SYSTEM                                     ' Zurck nach DOS
   END IF
END SUB

'--------------------------------------------------------------------
' Erzeuge alle mglichen Bauerumwandlungen
'--------------------------------------------------------------------
SUB NotiereUmwandlung (von%, nach%)
   IF brett(nach%) = 0 THEN
      FOR i% = 5 TO 2 STEP -1                    ' Reihenfolge Dame,Springer,Lufer,Turm
         CALL NotiereZug(von%, nach%)
         ZugStapel(index - 1).extra = i% * 10
      NEXT i%
   ELSE                                     ' Umwandlung mit Schlagen
      FOR i% = 5 TO 2 STEP -1
         CALL NotiereSchlagzug(von%, nach%)
         ZugStapel(index - 1).extra = i% * 10 + ZugStapel(index - 1).extra
      NEXT i%
   END IF
END SUB

'---------------------------------------------------------------------
' Trage normalen Zug in Zugstapel ein.
' Als Begleiteffekt ermittelt diese Prozedur noch die Mobilitt
' von Lufer und Turm sowie den Wert des Zuges fr die Vorsortierung.
'---------------------------------------------------------------------
SUB NotiereZug (von%, nach%)
   ' Erhhe die Mobilitt fr Lufer und Turm.
   ' Mobilitt im Zentrum wird hher gewichtet
   ' als Mobilitt am Rand.
  
   IF Farbe = 1 THEN
      IF brett(von%) = 3 OR brett(von%) = 2 THEN
         Mobilitaet(tiefe) = Mobilitaet(tiefe) + ZentrumTab(nach%)
      END IF
   ELSE
      IF brett(von%) = -3 OR brett(von%) = -2 THEN
         Mobilitaet(tiefe) = Mobilitaet(tiefe) + ZentrumTab(nach%)
      END IF
   END IF

   ' Bewerte Zug fr Zugsortierung. Bonus fr Hauptvariante oder "Killer"
   Killer1% = KillerTab(tiefe).Killer1% = von% * 100 + nach%
   Killer2% = KillerTab(tiefe).Killer2% = von% * 100 + nach%
   Killer3% = KillerTab(tiefe).Killer3% = von% * 100 + nach%
   Killer4% = KillerTab(tiefe).Killer4% = von% * 100 + nach%
   HvarZug% = HVar(0, tiefe) = von% * 100 + nach%
   IF HvarZug% THEN
      ZugStapel(index).wert = 500
   ELSEIF Killer1% THEN
      ZugStapel(index).wert = 250
   ELSEIF Killer2% THEN
      ZugStapel(index).wert = 150
   ELSEIF Killer3% THEN
      ZugStapel(index).wert = 100
   ELSEIF Killer4% THEN
      ZugStapel(index).wert = 50
   ELSE
      ZugStapel(index).wert = 0
   END IF

   ZugStapel(index).tah = von% * 100 + nach%
   ZugStapel(index).extra = 0

   IF index < 1000 THEN   ' Verhindere berlauf des Zugstapels
      index = index + 1
   ELSE
      COLOR 7
      LOCATE 27, 55: Vystup 77
      SLEEP
      SYSTEM                                     ' Zurck nach DOS
   END IF
END SUB

' -----------------------------------------------------------------
' Zadani levelu, bud cas na pocet tahu, nebo na partii, nebo nastaveni
' hloubky propoctu, zmena barvy poli
' -----------------------------------------------------------------
SUB Options (index%)
  SELECT CASE index%
    CASE 0
      GET #4, 2, SvetlaP%
      GET #4, 3, TmavaP%
      DO
        TmavaP% = TmavaP% + 1
        IF TmavaP% > 14 THEN TmavaP% = 2
      LOOP UNTIL TmavaP% <> 8 AND TmavaP% <> SvetlaP%
      PUT #4, 3, TmavaP%
      KresliSachovnici
    CASE 1
      GET #4, 2, SvetlaP%
      GET #4, 3, TmavaP%
      DO
        SvetlaP% = SvetlaP% + 1
        IF SvetlaP% > 15 THEN SvetlaP% = 2
      LOOP UNTIL SvetlaP% <> 8 AND SvetlaP% <> TmavaP%
      PUT #4, 2, SvetlaP%
      KresliSachovnici
    CASE 2
      GET #4, 1, Otoceni%
      IF Otoceni% = 0 THEN
        Otoceni% = 1
      ELSE
        Otoceni% = 0
      END IF
      PUT #4, 1, Otoceni%
      KresliSachovnici
    CASE 3
      DIM Chyba AS INTEGER
      Chyba% = 0
      CistiRadek 27, 27
      CistiRadek 29, 29
      VypisOvladani 2
      LOCATE 27, 55
      Vystup 34
      INPUT Ovladac$: PRINT ; "";
      Ovladac$ = UCASE$(Ovladac$)
      IF LEN(Ovladac$) <> 2 THEN Chyba% = 1
      IF ASC(LEFT$(Ovladac$, 1)) - 65 < 0 OR ASC(LEFT$(Ovladac$, 1)) - 65 > 3 THEN Chyba% = 1
      IF VAL(RIGHT$(Ovladac$, 1)) < 1 OR VAL(RIGHT$(Ovladac$, 1)) > 9 THEN Chyba% = 1
      IF Chyba% = 0 THEN
        Level% = ((ASC(LEFT$(Ovladac$, 1)) - 65) * 9 + VAL(RIGHT$(Ovladac$, 1))) * 3 - 2
        PUT #4, 4, Level%
      ELSE
        ChybneZadani
      END IF
      CistiRadek 12, 17
      NapisKdoTahne 1
      CistiRadek 26, 27
      GET #5, Level%, i%
      GET #5, Level% + 1, j%
      CasBily% = 0
      CasCerny% = 0
      IF Level% > 25 AND Level% < 55 THEN
        CasBily% = 0 + (i% \ j%) * ((ZugNr% + 1) \ 2)
        CasCerny% = 0 + (i% \ j%) * ((ZugNr%) \ 2)
      END IF
      Hodiny
    CASE 4
      CistiRadek 27, 27
      LOCATE 27, 55
      Vystup 87
      GET #4, 5, Drucker%
      IF Drucker% = 0 THEN
        Drucker% = 1
        PRINT ; " "; : Vystup 88
      ELSE
        Drucker% = 0
        PRINT ; " "; : Vystup 89
      END IF
      PUT #4, 5, Drucker%
    CASE 5
      GET #4, 7, i%
      i% = i% + 1
      IF i% > 2 THEN i% = 0
      CLOSE #2
      IF i% = 0 THEN OPEN "vyst-cze.dat" FOR RANDOM AS #2 LEN = 24
      IF i% = 1 THEN OPEN "vyst-ger.dat" FOR RANDOM AS #2 LEN = 24
      IF i% = 2 THEN OPEN "vyst-eng.dat" FOR RANDOM AS #2 LEN = 24
      PUT #4, 7, i%
    END SELECT
END SUB

SUB PosunKurzoruSipkou (Ovladac$)
GET #4, 1, Otoceni%
IF Otoceni% = 0 THEN
  i% = -1
ELSE
  i% = 1
END IF
IF Ovladac$ = CHR$(75) THEN PrepoctiPoziciKurzoru 1 * i%   'sipka doleva
IF Ovladac$ = CHR$(80) THEN PrepoctiPoziciKurzoru 10 * i%  'sipka dolu
IF Ovladac$ = CHR$(77) THEN PrepoctiPoziciKurzoru -1 * i%  'sipka doprava
IF Ovladac$ = CHR$(72) THEN PrepoctiPoziciKurzoru -10 * i% 'sipka nahoru
END SUB

SUB PrehrajPartii (Pocettahu%, pomalu%)
   KresliDesku
   FOR i% = 1 TO Pocettahu%
        GET #3, i% * 3, j%
        GET #3, (i% * 3) + 2, l%
        IF l% > 0 THEN
          Promena% = (l% MOD 100) \ 10
        ELSE
          Promena% = 0
        END IF
        Prikaz$ = UCASE$(Feldnotation$(j% \ 100) + Feldnotation$(j% MOD 100))
        IF Promena% > 0 THEN Prikaz$ = Prikaz$ + FigSymbol(Promena%)
        IF Zugeingabe%(Prikaz$) = 0 THEN
            EXIT SUB
        END IF          'nemela by byt chyba v zaznamu
   NEXT i%
   ZmenaPoziceKurzoru (j% MOD 100)
   KresliSachovnici
END SUB

SUB PrepoctiPoziciKurzoru (posun%)
'Je treba zajistit, aby se pri posunu sipkami kurzor nedostal na sachovnici
    npk% = PoziceKurzoru + posun%
    IF npk% MOD 10 = 0 THEN npk% = npk% - (npk% MOD 10) + 8
    IF npk% MOD 10 = 9 THEN npk% = npk% - (npk% MOD 10) + 1
    IF npk% < 21 THEN npk% = 90 + (npk% MOD 10)
    IF npk% > 98 THEN npk% = 20 + (npk% MOD 10)
    ZmenaPoziceKurzoru npk%
END SUB

'--------------------------------------------------------------------
' Bewertung eines schwarzen Bauern. Neben den Parametern mssen
' auch die Bauernkontrollen, Bauernlinien und Turmlinien richtig
' belegt sein.
' Gibt die Bewertung aus der Sicht von Schwarz zurck.
'--------------------------------------------------------------------
FUNCTION SBBewertung% (entwickelt%)
hodnota% = 0
FOR i% = 8 TO 15
  IF SezFigCerne(i%).figura <> -1 THEN
     IF SezFigCerne(i%).pole <> 0 THEN Promena% = 8
  ELSEIF SezFigCerne(i%).pole = 0 THEN 'v takovem pripade nedelej nic, nejedna se o cerneho pesce
  ELSE
   Feld% = SezFigCerne(i%).pole
   Reihe% = Feld% \ 10
   Linie% = Feld% MOD 10
   PocetPescu% = PocetPescu% + 1
   Reihe% = 11 - Reihe%   ' Reihe umdrehen. Hhere Reihe
                                           ' ist damit wie bei Wei besser.
   IF MatSumme(tiefe) > 2920 THEN ' Erffnung oder Mittelspiel
      wert% = sBFeldWert(Feld%)
      ' Falls Entwicklung nicht abgeschlossen, stoe Randbauern nicht vor
      IF entwickelt% < 4 THEN
         IF (Linie% >= 6 OR Linie% <= 2) AND Reihe% > 4 THEN
            wert% = wert% - 15
         END IF
      END IF
   ELSE                     ' Im Endspiel sind alle Linien gleich gut.
                            ' Bringe Bauern nach vorne.
      wert% = Reihe% * 4
   END IF

   ' Ist Bauer ein Isolani?
   ' Randbauern brauchen nicht extra behandelt werden. Bauern(ALinie-1) ist
   ' linker Rand, Bauern(HLinie+1) rechter Rand. Auf beiden Rndern steht
   ' kein Bauer.
   IF Bauern(Linie% - 1).Schwarz = 0 AND Bauern(Linie% + 1).Schwarz = 0 THEN
      wert% = wert% - 12                              ' Isolani
      ' Isolierter Doppelbauer
      IF Bauern(Linie%).Schwarz > 1 THEN wert% = wert% - 20
   END IF
   
   ' Doppelbauer
   IF Bauern(Linie%).Schwarz > 1 THEN wert% = wert% - 12

   ' Duo oder untersttzter Bauer bekommt Bonus
   ' z.B. e5,d5 ist Duo, d6 untersttzt e5
   IF BKontrolle(Feld%).Schwarz > 0 THEN wert% = wert% + Reihe%
   IF BKontrolle(Feld% - 10).Schwarz > 0 THEN
        wert% = wert% + Reihe%
        IF Reihe% > 4 THEN wert% = wert% + 3
   END IF
   
   IF Bauern(Linie%).Weiss = 0 THEN                   ' Halboffene Linie
      ' Rckstndiger Bauer auf halboffener Linie:
      ' Rckstndiger Bauer wird nicht von eigenen gesttzt...
      Bedingung1% = BKontrolle(Feld%).Schwarz = 0
      ' ... und kann nicht nach vorne, weil gegnerische Bauern das Feld
      ' vor ihm kontrollieren.
      Bedingung2% = BKontrolle(Feld% - 10).Weiss > BKontrolle(Feld% - 10).Schwarz
      IF Bedingung1% AND Bedingung2% THEN
         wert% = wert% - 20
         ' Turm kniet sich auf rckstndigen Bauer
         IF Tuerme(Linie%).Weiss > 0 THEN wert% = wert% - 10
      ELSE
         ' Bauer ist Freibauer, wenn auf halboffener Linie und die
         ' weiteren Felder auf seiner Linie nicht von gegnerischen
         ' Bauern kontrolliert werden.
         FOR j% = Feld% TO 41 STEP -10           ' bis zur dritten Reihe
            IF BKontrolle(j%).Weiss > 0 THEN
               GOTO novyokruh
            END IF
         NEXT j%
         ' Freibauer gefunden. Im Endspiel ist Freibauer wichtiger als
         ' im Mittelspiel.
         IF MatSumme(tiefe) < 2920 THEN
            wert% = wert% + Reihe% * 16        ' Je weiter vorne, desto besser
            ' Turm untersttzt Freibauer auf derselben Linie
            IF Tuerme(Linie%).Schwarz > 0 THEN wert% = wert% + Reihe% * 4
            ' gegnerischer Turm auf derselben Linie
            IF Tuerme(Linie%).Weiss > 0 THEN wert% = wert% - Reihe% * 2
            ' Reines Bauernendspiel. Freibauer besonders wertvoll
            IF MatSumme(tiefe) = 0 THEN wert% = wert% + Reihe% * 8
            ' Untersttzter Freibauer
            IF BKontrolle(Feld%).Schwarz > 0 OR BKontrolle(Feld% - 10).Schwarz > 0 THEN
               wert% = wert% + Reihe% * 6
            END IF
            ' Freibauer von weier Figur blockiert. Figur wird auch
            ' nicht von eigenen Bauern bedroht.
            IF brett(Feld% - 10) < 0 AND BKontrolle(Feld% - 10).Schwarz = 0 THEN
               wert% = wert% - Reihe% * 6
            END IF
         ELSE                              ' Freibauer im Mittelspiel
            wert% = wert% + Reihe% * 8
            ' Untersttzter Freibauer
            IF BKontrolle(Feld%).Schwarz > 0 OR BKontrolle(Feld% - 10).Schwarz > 0 THEN
               wert% = wert% + Reihe% * 4
            END IF
         END IF
      END IF
   END IF
  END IF
novyokruh:
  hodnota% = hodnota% + wert%
NEXT i%
SBBewertung% = hodnota%
END FUNCTION

'--------------------------------------------------------------------
' Speichert das Spiel und die Spielparamter auf der Festplatte ab.
' Notiz: In Version 1.0 nicht implementiert
'--------------------------------------------------------------------
SUB Spielende
   CLOSE
   SYSTEM
END SUB

'--------------------------------------------------------------------
' Eingabe einer beliebigen Stellung
'--------------------------------------------------------------------
SUB Stellungseingabe
   tiefe = 0                         ' Stellung wird Wurzel des Suchbaumes
   x% = 456: y% = 200
   LINE (x% - 24, y% - 24)-(x% + 24, y% + 24), 8, B
   KresliFiguru x%, y%, 6 * Farbe, 0
   FOR i% = 12 TO 27
    IF i% < 15 THEN
      LOCATE i%, 62
    ELSE
      LOCATE i%, 55
    END IF
    Vystup i% + 36
   NEXT i%
   figura% = 6
   Feld$ = Feldnotation$(PoziceKurzoru)
   Preruseni = 0
   Ovladac$ = ""
   IF PocetHracu% = 0 THEN PocetHracu% = 1
  
   IF figura% <> 0 THEN
          CistiRadek 29, 29
          LOCATE 29, 55: Vystup 65
          IF Farbe = 1 THEN COLOR 15
          IF Farbe = -1 THEN COLOR 12
          PRINT ; "  "; FigSymbol$(figura%); " ";
          COLOR 7
          Vystup 66
          PRINT ; " "; Feld$; " ";
          Vystup 67
   ELSE
          CistiRadek 29, 29
          LOCATE 29, 55: Vystup 68: PRINT ; "  "; Feld$; " "; : Vystup 67
   END IF
 
   DO
      k% = VstupKlavesnice%
      IF k% = 0 THEN
      ELSE
        SELECT CASE k%
          CASE 323  'F10 se pokusi zadat pozici
            Preruseni = 1
          CASE 3  'Ctrl+C > Vyprazdni desku
            FOR i% = 2 TO 9
              FOR j% = 1 TO 8
                brett(i% * 10 + j%) = 0
              NEXT j%
            NEXT i%
            KresliSachovnici
          CASE 9 'Tab, zmena barvy
            Farbe = Farbe * -1
            NapisKdoTahne 0
          CASE 11 'Kral (Ctrl+K)
            figura% = 6
          CASE 4  'Dama (Ctrl+D)
            figura% = 5
          CASE 22 'Vez (Ctrl+V)
            figura% = 2
          CASE 19 'Strelec (Ctrl+S)
            figura% = 3
          CASE 10 'Jezdec (Ctrl+J)
            figura% = 4
          CASE 16 'Pesec (Ctrl+P)
            figura% = 1
          CASE 21 'Vyprazdnit pole (Ctrl+U)
            figura% = 0
          CASE 13 'Enter, uloz danou figuru na pozici kurzoru
            pole% = PoziceKursoru
            LiesSteine figura%, pole%
          CASE ELSE
        END SELECT
        KresliFiguru 456, 200, figura% * Farbe, 0
        IF figura% <> 0 THEN
          CistiRadek 29, 29
          LOCATE 29, 55: Vystup 65
          IF Farbe = 1 THEN COLOR 15
          IF Farbe = -1 THEN COLOR 12
          PRINT ; "  "; FigSymbol$(figura%); " ";
          COLOR 7
          Vystup 66
          PRINT ; " "; Feld$; " ";
          Vystup 67
        ELSE
          CistiRadek 29, 29
          LOCATE 29, 55: Vystup 68: PRINT ; "  "; Feld$; " "; : Vystup 67
        END IF
        KeyBufferNull
      END IF
   LOOP UNTIL Preruseni = 1
   CistiRadek 29, 29
  
   ' Berechne Materialbilanz und berprfe, ob jede Seite genau
   ' einen Knig hat.
   MatBilanz(0) = 0
   MatSumme(0) = 0
   FOR i% = 21 TO 98                              ' Lies jedes Feld
      IF brett(i%) = 0 OR brett(i%) = 100 THEN
      ELSE
        ' Neue Materialbilanz
        ' Weier Stein geht in Bilanz positiv ein, schwarzer negativ
        MatBilanz(0) = MatBilanz(0) + SGN(brett(i%)) * FigMaterial(ABS(brett(i%)))
        IF ABS(brett(i%)) <> 1 THEN
          MatSumme(0) = MatSumme(0) + FigMaterial(ABS(brett(i%)))
        END IF
      END IF
    NEXT i%

wiederhole:  ' Eingabe darf nur mit legaler Stellung verlassen werden.
             ' Zuggenerator funktioniert sonst nicht.
     ' Materialbilanz wurde bisher aus
      IF Farbe = -1 THEN MatBilanz(0) = -MatBilanz(0)  ' der Sicht von Wei berechnet.

   EpFeld(0) = 0
   CistiRadek 12, 27
   LOCATE 12, 55
   radek = CSRLIN

   FOR i% = 0 TO 15
    SezFigBile(i%).pohyb = 1
    SezFigCerne(i%).pohyb = 1
   NEXT i%
  
   IF brett(25) = 6 THEN
      IF brett(21) = 2 THEN
        Vystup 71: INPUT Ovladac$: PRINT ; "";
        Ovladac$ = UCASE$(Ovladac$)
        IF Ovladac$ <> "N" THEN
          SezFigBile(0).pohyb = 0
          FOR i% = 1 TO 15
            IF SezFigBile(i%).pole = 21 THEN SezFigBile(i%).pohyb = 0
          NEXT i%
        END IF
      END IF
      IF brett(28) = 2 THEN
        LOCATE radek + 1, 55
        radek = CSRLIN
        Vystup 72: INPUT Ovladac$: PRINT ; "";
        Ovladac$ = UCASE$(Ovladac$)
        IF Ovladac$ <> "N" THEN
          SezFigBile(0).pohyb = 0
          FOR i% = 1 TO 15
            IF SezFigBile(i%).pole = 28 THEN SezFigBile(i%).pohyb = 0
          NEXT i%
        END IF
      END IF
   END IF
   IF brett(95) = -6 THEN
      IF brett(91) = -2 THEN
        LOCATE radek + 1, 55
        radek = CSRLIN
        Vystup 73: INPUT Ovladac$: PRINT ; "";
        Ovladac$ = UCASE$(Ovladac$)
        IF Ovladac$ <> "N" THEN
          SezFigCerne(0).pohyb = 0
          FOR i% = 1 TO 15
            IF SezFigCerne(i%).pole = 91 THEN SezFigCerne(i%).pohyb = 0
          NEXT i%
        END IF
      END IF
      IF brett(98) = -2 THEN
        LOCATE radek + 1, 55
        radek = CSRLIN
        Vystup 74: INPUT Ovladac$: PRINT ; "";
        Ovladac$ = UCASE$(Ovladac$)
        IF Ovladac$ = "N" THEN
          SezFigCerne(0).pohyb = 0
          FOR i% = 1 TO 15
            IF SezFigCerne(i%).pole = 98 THEN SezFigCerne(i%).pohyb = 0
          NEXT i%
        END IF
      END IF
   END IF
   IF Farbe% = 1 THEN
      FOR i% = 61 TO 68
        IF brett(i%) = 1 THEN
          IF brett(i% - 1) = -1 OR brett(i% + 1) = -1 THEN ep = 1
          EXIT FOR
        ELSE
          ep = 0
        END IF
      NEXT i%
   ELSE
      FOR i% = 51 TO 58
        IF brett(i%) = -1 THEN
          IF brett(i% - 1) = 1 OR brett(i% + 1) = 1 THEN ep = 1
          EXIT FOR
        ELSE
          ep = 0
        END IF
      NEXT i%
   END IF
   IF ep = 1 THEN
      LOCATE radek + 1, 55
      radek = CSRLIN
      Vystup 75: INPUT Ovladac$: PRINT ; "";
      Ovladac$ = UCASE$(Ovladac$)
        IF Ovladac$ = "A" THEN
          ' Eingabe des Enpassant Feldes. Falls keine korrekte Eingabe
          ' erfolgt, ist enpassant nicht mglich.
          LOCATE radek + 1, 55
          radek = CSRLIN
          Vystup 76: INPUT Ovladac$: PRINT ; "";
          Ovladac$ = UCASE$(Ovladac$)
          ep$ = LEFT$(Ovladac$, 1)
          IF ep$ >= "A" AND ep$ <= "H" THEN
            IF Farbe = 1 THEN
              EpFeld(0) = 71 + ASC(ep$) - ASC("A")
            ELSE
              EpFeld(0) = 41 + ASC(ep$) - ASC("A")
            END IF
          END IF
        END IF
   END IF
   IF Farbe = 1 THEN
      ZugNr% = 0            ' Rcksetzen der Zugnummer
   ELSE
      ZugNr% = 1
   END IF
   CistiRadek 12, 27
   CALL Brettausgabe(0)                   ' Neues Brett anzeigen
   CALL DruckeStellung

   OPEN "lastpos.mru" FOR RANDOM AS #1 LEN = 2
   FOR i% = 0 TO 119
     brett(i%) = j%
     PUT #1, i% + 1, j%
   NEXT i%
   PUT #1, 121, ZugNr%
   FOR i% = 0 TO 2
      Rochade(i%) = j%
      PUT #1, 122 + i%, j%
   NEXT i%
   PUT #1, 125, EpFeld(0)
   PUT #1, 126, MatSumme(0)
   PUT #1, 127, MatBilanz(0)
   PUT #1, 130, Farbe%
   PUT #1, 131, Preruseni%
   PUT #1, 132, PoziceKurzoru%
   FOR i% = 0 TO 15
      PUT #1, i% * 3 + 133, SezFigBile(i%).figura
      PUT #1, i% * 3 + 134, SezFigBile(i%).pole
      PUT #1, i% * 3 + 135, SezFigBile(i%).pohyb
      PUT #1, i% * 3 + 181, SezFigCerne(i%).figura
      PUT #1, i% * 3 + 182, SezFigCerne(i%).pole
      PUT #1, i% * 3 + 183, SezFigCerne(i%).pohyb
   NEXT i%
   CLOSE #1
   j% = 1
   PUT #3, 2, j%
   CasBily% = 0
   CasCerny% = 0
   PUT #4, 8, CasBily%
   PUT #4, 9, CasCerny%
END SUB

SUB TiskniRamecky
COLOR 7
LOCATE 1, 1: PRINT ; "ͻ";
LOCATE 2, 1: PRINT ; "                                                                          ";
LOCATE 3, 1: PRINT ; "ͼ";
FOR i% = 0 TO 3
  LOCATE 2, 6 + i% * 15
  Vystup i% + 38
  COLOR 15
  LOCATE 2, 3 + i% * 15
  Vystup 42 + i%
  COLOR 7
NEXT i%
LOCATE 4, 53: PRINT ; ""; STRING$(26, ""); "";
FOR okruh = 5 TO 29
IF okruh = 8 OR okruh = 10 OR okruh = 18 OR okruh = 28 THEN
  LOCATE okruh, 53: PRINT ; ""; STRING$(26, ""); "";
ELSE
  LOCATE okruh, 53: PRINT ; ""; SPC(26); "";
END IF
NEXT okruh
LOCATE 30, 53: PRINT ; ""; STRING$(26, ""); "";
LOCATE 5, 55: Vystup 35
LOCATE 6, 55: Vystup 36
LOCATE 7, 55: Vystup 37
COLOR 15
LOCATE 2, 64: Vystup 46
Vlajka
NapisKdoTahne 1
Hodiny
END SUB

SUB Vlajka
LINE (580, 60)-(628, 92), 8, B
GET #4, 7, jazyk%
SELECT CASE jazyk%
    CASE 0
        LINE (604, 76)-(628, 76), 8
        LINE (580, 60)-(604, 76), 8
        LINE (580, 92)-(604, 76), 8
        PAINT (582, 76), 1, 8
        PAINT (606, 74), 15, 8
        PAINT (606, 78), 4, 8
    CASE 1
        LINE (580, 71)-(628, 71), 8
        LINE (580, 81)-(628, 81), 8
        PAINT (582, 62), 14, 8
        PAINT (582, 73), 4, 8
    CASE 2
        PAINT (582, 62), 15, 8
        LINE (580, 73)-(598, 73), 8
        LINE (598, 73)-(598, 60), 8
        LINE (628, 73)-(610, 73), 8
        LINE (610, 73)-(610, 60), 8
        LINE (580, 79)-(598, 79), 8
        LINE (598, 79)-(598, 92), 8
        LINE (628, 79)-(610, 79), 8
        LINE (610, 79)-(610, 92), 8
        PAINT (604, 76), 4, 8
    CASE ELSE
END SELECT
FOR i% = 0 TO 6
    GET #2, 113 + i%, a$
    FigSymbol(i%) = RTRIM$(a$)
    IF i% > 1 THEN DruckSymbol(i%) = RTRIM$(a$)
NEXT i%
END SUB

FUNCTION VstupKlavesnice%
      Ovladac$ = INKEY$
      Ovladac$ = UCASE$(Ovladac$)
      IF Ovladac$ = "" THEN
        k% = 0
      ELSE
        IF LEN(Ovladac$) = 2 THEN
          k% = ASC(RIGHT$(Ovladac$, 1)) + 255
        ELSE
          k% = ASC(Ovladac$)
        END IF
      END IF
      IF k% > 326 AND k < 336 THEN PosunKurzoruSipkou CHR$(k% - 255) 'sipky
      VstupKlavesnice% = k%
END FUNCTION

SUB VypisCasu (Cas%, barva%, radek%, sloupec%)
  COLOR barva%
  LOCATE radek%, sloupec%
  a$ = STR$(Cas% \ 3600)
  IF Cas% \ 3600 < 10 THEN a$ = " " + RIGHT$(a$, 1)
  PRINT a$; ":";
  LOCATE radek%, sloupec% + 3
  a$ = STR$((Cas% \ 60) MOD 60)
  IF (Cas% \ 60) MOD 60 < 10 THEN a$ = "0" + RIGHT$(a$, 1)
  PRINT LTRIM$(a$); ":";
  LOCATE radek%, sloupec% + 6
  a$ = STR$(Cas% MOD 60)
  IF Cas% MOD 60 < 10 THEN a$ = "0" + RIGHT$(a$, 1)
  PRINT LTRIM$(a$);
  COLOR 7
END SUB

SUB VypisOvladani (Part%)
  CistiRadek 11, 17
  SELECT CASE Part%
   CASE 0
    FOR i% = 1 TO 10
      IF i% < 6 THEN COLOR 15: LOCATE 10 + i%, 55: Vystup i%
      IF i% > 5 THEN COLOR 7: LOCATE 5 + i%, 58: Vystup i%
    NEXT i%
   CASE 1
    FOR i% = 11 TO 22
      IF i% < 17 THEN COLOR 15: LOCATE i%, 55: Vystup i%
      IF i% > 16 THEN COLOR 7: LOCATE i% - 6, 61: Vystup i%
    NEXT i%
   CASE 2
    FOR i% = 23 TO 28
      LOCATE i% - 12, 55: Vystup i%
    NEXT i%
   CASE ELSE
  END SELECT
END SUB

SUB Vystup (i%)
GET #2, i%, a$
PRINT ; RTRIM$(a$);
END SUB

'--------------------------------------------------------------------
' Bewertung eines weien Bauern.
' Erfolgt analog der Bewertung fr schwarze Bauern.
' Gibt die Bewertung aus der Sicht von Wei zurck.
'--------------------------------------------------------------------
FUNCTION WBBewertung% (entwickelt%)
hodnota% = 0
Promena% = 0
FOR i% = 8 TO 15
  IF SezFigBile(i%).figura <> 1 THEN
     IF SezFigBile(i%).pole <> 0 THEN Promena% = 8
  ELSEIF SezFigBile(i%).pole = 0 THEN 'v takovem pripade nedelej nic, nejedna se o bileho pesce
  ELSE
   Feld% = SezFigBile(i%).pole
   Reihe% = Feld% \ 10
   Linie% = Feld% MOD 10
   PocetPescu% = PocetPescu% + 1
   IF MatSumme(tiefe) > 2920 THEN   ' Erffnung oder Mittelspiel
      wert% = wBFeldWert(Feld%)
   ' Falls Entwicklung nicht abgeschlossen, stoe Randbauern nicht vor
      IF entwickelt% < 4 THEN
         IF (Linie% >= 6 OR Linie% <= 2) AND Reihe% > 4 THEN
            wert% = wert% - 15
         END IF
      END IF
   ELSE                           ' Im Endspiel sind alle Linien gleich gut.
      wert% = Reihe% * 4          ' Bringe Bauern nach vorne.
   END IF

   ' Ist Bauer ein Isolani?
   ' Randbauern brauchen nicht extra behandelt werden. Bauern(ALinie-1) ist
   ' linker Rand, Bauern(HLinie+1) rechter Rand. Auf beiden Rndern steht
   ' kein Bauer.
   IF Bauern(Linie% - 1).Weiss = 0 AND Bauern(Linie% + 1).Weiss = 0 THEN
      wert% = wert% - 12                           ' Isolani
      ' Isolierter Doppelbauer
      IF Bauern(Linie%).Weiss > 1 THEN wert% = wert% - 20
   END IF
   
   ' Doppelbauer
   IF Bauern(Linie%).Weiss > 1 THEN wert% = wert% - 12

   ' Duo oder untersttzter Bauer bekommt Bonus
   IF BKontrolle(Feld%).Weiss > 0 THEN wert% = wert% + Reihe%
   IF BKontrolle(Feld% + 10).Weiss > 0 THEN
        wert% = wert% + Reihe%
        IF Reihe% > 4 THEN wert% = wert% + 3
   END IF
  
   IF Bauern(Linie%).Schwarz = 0 THEN              ' Halboffene Linie
      ' Rckstndiger Bauer auf halboffener Linie:
      ' Rckstndiger Bauer wird nicht von eigenen gesttzt...
      Bedingung1% = BKontrolle(Feld%).Weiss = 0
      ' ... und kann nicht nach vorne, weil gegnerische Bauern das Feld
      ' vor ihm kontrollieren.
      Bedingung2% = BKontrolle(Feld% + 10).Schwarz > BKontrolle(Feld% + 10).Weiss
      IF Bedingung1% AND Bedingung2% THEN
         wert% = wert% - 20
         ' Turm kniet sich auf rckstndigen Bauer
         IF Tuerme(Linie%).Schwarz > 0 THEN wert% = wert% - 10
      ELSE
         ' Bauer ist Freibauer, wenn auf halboffener Linie und die
         ' weiteren Felder auf seiner Linie nicht von gegnerischen
         ' Bauern kontrolliert werden.
         FOR j% = Feld% TO 78 STEP 10             ' bis zur sechsten Reihe
            IF BKontrolle(j%).Schwarz > 0 THEN
               GOTO novokruh
            END IF
         NEXT j%

         ' Freibauer gefunden. Im Endspiel ist Freibauer wichtiger als
         ' im Mittelspiel.
         IF MatSumme(tiefe) < 2920 THEN
            wert% = wert% + Reihe% * 16       ' Je weiter vorne, desto besser
            ' Turm untersttzt Freibauer auf derselben Linie
            IF Tuerme(Linie%).Weiss > 0 THEN wert% = wert% + Reihe% * 4
            ' gegnerischer Turm auf derselben Linie.
            IF Tuerme(Linie%).Schwarz > 0 THEN wert% = wert% - Reihe% * 2
            ' Reines Bauernendspiel. Freibauer besonders wertvoll.
            IF MatSumme(tiefe) = 0 THEN wert% = wert% + Reihe% * 8
            ' Untersttzter Freibauer
            IF BKontrolle(Feld%).Weiss > 0 OR BKontrolle(Feld% + 10).Weiss > 0 THEN
               wert% = wert% + Reihe% * 6
            END IF
            ' Freibauer von schwarzer Figur blockiert. Figur wird auch
            ' nicht von eigenen Bauern bedroht.
            IF brett(Feld% + 10) < 0 AND BKontrolle(Feld% + 10).Weiss = 0 THEN
               wert% = wert% - Reihe% * 6
            END IF
         ELSE                              ' Freibauer im Mittelspiel
            wert% = wert% + Reihe% * 8
            ' Untersttzter Freibauer
            IF BKontrolle(Feld%).Weiss > 0 OR BKontrolle(Feld% + 10).Weiss > 0 THEN
               wert% = wert% + Reihe% * 4
            END IF
         END IF
      END IF
   END IF
  END IF
novokruh:
  hodnota% = hodnota% + wert%
  'LOCATE 4, 1 + i% * 3: PRINT wert%;
NEXT i%
WBBewertung% = hodnota%
END FUNCTION

FUNCTION ZapisFigury% (figura%, pole%)
  SELECT CASE figura%
    CASE 6
      SezFigBile(0).pole = pole%
      SezFigBile(0).figura = figura%
      ZapisFigury% = 1
      EXIT FUNCTION
    CASE -6
      SezFigCerne(0).pole = pole%
      SezFigCerne(0).figura = figura%
      ZapisFigury% = 1
      EXIT FUNCTION
    CASE ELSE
      IF ABS(figura%) = 5 THEN i% = 1: j% = 1
      IF ABS(figura%) = 4 THEN i% = 6: j% = 7
      IF ABS(figura%) = 3 THEN i% = 4: j% = 5
      IF ABS(figura%) = 2 THEN i% = 2: j% = 3
      IF ABS(figura%) = 1 THEN i% = 8: j% = 15
      FOR okruh% = i% TO j%
        IF figura% > 0 THEN
          IF SezFigBile(okruh%).pole = 0 THEN
              SezFigBile(okruh%).pole = pole%
              SezFigBile(okruh%).figura = figura%
              ZapisFigury% = 1
              EXIT FUNCTION
           END IF
        ELSE
          IF SezFigCerne(okruh%).pole = 0 THEN
              SezFigCerne(okruh%).pole = pole%
              SezFigCerne(okruh%).figura = figura%
              ZapisFigury% = 1
              EXIT FUNCTION
          END IF
        END IF
      NEXT okruh%
      FOR okruh% = 15 TO 8 STEP -1
        IF figura% > 0 THEN
          IF SezFigBile(okruh%).pole = 0 THEN
              SezFigBile(okruh%).pole = pole%
              SezFigBile(okruh%).figura = figura%
              ZapisFigury% = 1
              EXIT FUNCTION
           END IF
        ELSE
          IF SezFigCerne(okruh%).pole = 0 THEN
              SezFigCerne(okruh%).pole = pole%
              SezFigCerne(okruh%).figura = figura%
              ZapisFigury% = 1
              EXIT FUNCTION
          END IF
        END IF
      NEXT okruh%
  END SELECT
  ZapisFigury% = 0
END FUNCTION

'--------------------------------------------------------------------
' Anzeige der aktuellen Hauptvariante. Es wird nur von-nach Feld
' angezeigt.
'--------------------------------------------------------------------
SUB ZeigeHvar
   FOR j% = 23 TO 26
      LOCATE j%, 54
      PRINT STRING$(26, " ");
   NEXT j%
   LOCATE 23, 58
   IF Farbe = 1 THEN
      j% = 7
   ELSE
      j% = 8
   END IF
   FOR i% = 1 TO j%
      IF HVar(0, i%) <> 0 THEN
        IF (Farbe% = 1 AND i% MOD 2 = 1) THEN LOCATE (22 + (i% + 1) \ 2), 68
        IF (Farbe% = 1 AND i% MOD 2 = 0) THEN LOCATE (23 + (i% + 1) \ 2), 58
        IF (Farbe% = -1 AND i% MOD 2 = 1) THEN LOCATE (22 + (i% + 1) \ 2), 58
        IF (Farbe% = -1 AND i% MOD 2 = 0) THEN LOCATE (22 + (i% + 1) \ 2), 68
        PRINT Feldnotation$(HVar(0, i%) \ 100); "-"; Feldnotation$(HVar(0, i%) MOD 100);
      ELSE
        EXIT SUB
      END IF
   NEXT i%
END SUB

'--------------------------------------------------------------------
' Gibt den aktuellen Zug in Schachnotation aus.
' Rochade ist 'E1-G1' und nicht O-O
' AktZug% ist der Index des Zuges im ZugStapel.
'--------------------------------------------------------------------
SUB ZeigeZug (AktZug%)
   von% = ZugStapel(AktZug%).tah \ 100
   nach% = ZugStapel(AktZug%).tah MOD 100
   Promena% = (ZugStapel(AktZug%).extra MOD 100) \ 10
   IF ZugStapel(AktZug%).extra = 7 THEN PRINT " 0-0  "; : EXIT SUB
   IF ZugStapel(AktZug%).extra = 8 THEN PRINT "0-0-0 "; : EXIT SUB
   IF ABS(brett(von%)) = 1 THEN
      SymbolFig$ = " "
   ELSE
      SymbolFig$ = FigSymbol(ABS(brett(von%)))
   END IF
   PRINT SymbolFig$;            ' Art der Figur
   PRINT Feldnotation$(von%);                    ' Ausgangsfeld
   IF ZugStapel(AktZug%).extra < 1 THEN
      PRINT "-";                                 ' Normaler Zug
   ELSE
      IF ZugStapel(AktZug%).extra MOD 10 > 0 THEN
          PRINT ":";                                 ' Schlagzug
      ELSE
          PRINT "-";
      END IF
   END IF
   PRINT Feldnotation$(nach%);                   ' Zielfeld
   ' Falls Umwandlung, fge Umwandlungs-Figur hinzu
   IF Promena% > 0 THEN PRINT FigSymbol(Promena%);
   PRINT "   ";
END SUB

SUB ZmenaPoziceKurzoru (npk%)
  GET #4, 1, Otoceni%
  i% = PoziceKurzoru% \ 10
  j% = PoziceKurzoru% MOD 10
  IF PoziceKurzoru% <> 0 THEN
    IF Otoceni% = 0 THEN
      GET #6, i% - 1, y%
      GET #6, j% + 8, x%
    ELSE
      GET #6, 10 - i%, y%
      GET #6, 17 - j%, x%
    END IF
    KresliFiguru x%, y%, brett(PoziceKurzoru%), 0
  END IF
  PoziceKurzoru% = npk%
  IF PoziceKurzoru% = 0 THEN EXIT SUB
  i% = PoziceKurzoru% \ 10
  j% = PoziceKurzoru% MOD 10
  IF Otoceni% = 0 THEN
    GET #6, i% - 1, y%
    GET #6, j% + 8, x%
  ELSE
    GET #6, 10 - i%, y%
    GET #6, 17 - j%, x%
  END IF
  KresliFiguru x%, y%, brett(PoziceKurzoru%), 1
END SUB

'--------------------------------------------------------------------
' Fhrt einen Zug am Brett aus und aktualisiert den Status und
' die Suchtiefe.
' Aktzug% ist der Index des Zuges im ZugStapel.
'--------------------------------------------------------------------
SUB ZugAusfuehren (AktZug%)
   ZugNr% = ZugNr% + 1          ' Zugnummer wird um einen Halbzug erhht
   von% = ZugStapel(AktZug%).tah \ 100
   nach% = ZugStapel(AktZug%).tah MOD 100
   IF ZugStapel(AktZug%).extra > 0 THEN
    ep% = ZugStapel(AktZug%).extra \ 100
    Promena% = (ZugStapel(AktZug%).extra - ep% * 100) \ 10
    brani% = ZugStapel(AktZug%).extra - ep% * 100 - Promena% * 10
    IF brani% > 6 THEN brani% = 0
   ELSE
    ep% = 0
    brani% = 0
    Promena% = 0
   END IF
   LetzterZug = AktZug%
   tiefe = tiefe + 1                 ' Eine Stufe tiefer im Baum
   NachFeld(tiefe) = nach%           ' Wird fr Zugsortierung und Er-
                                     ' weiterung der Suche verwendet.
   EpFeld(tiefe) = 0
   ' Materialbilanz wird immer aus der Sicht der Seite am Zug betrachtet.
   ' Daher mu das Vorzeichen umgedreht werden.
   MatBilanz(tiefe) = -MatBilanz(tiefe - 1)
   MatSumme(tiefe) = MatSumme(tiefe - 1)
   ' Figur bewegt sich von von-feld nach nach-feld

   FOR i% = 0 TO 15
    IF Farbe = 1 THEN
      IF SezFigBile(i%).pole = von% THEN
        SezFigBile(i%).pole = nach%
        SezFigBile(i%).pohyb = SezFigBile(i%).pohyb + 1
        IF Promena% > 0 THEN SezFigBile(i%).figura = Promena%
        EXIT FOR
      END IF
    ELSE
      IF SezFigCerne(i%).pole = von% THEN
        SezFigCerne(i%).pole = nach%
        SezFigCerne(i%).pohyb = SezFigCerne(i%).pohyb + 1
        IF Promena% > 0 THEN SezFigCerne(i%).figura = -Promena%
        EXIT FOR
      END IF
    END IF
   NEXT i%

   IF ep% > 0 THEN
      IF brett(ep%) = 0 THEN    ' Bauernzug von 2-ter auf 4-te Reihe
         EpFeld(tiefe) = ep%
      ELSE                  ' Gegnerischer Bauer wird enpassant geschlagen
         brett(ep%) = 0         ' geschlagenen Bauern entfernen
         FOR i% = 8 TO 15
          IF Farbe = 1 THEN
            IF SezFigCerne(i%).pole = ep% THEN
              SezFigCerne(i%).pole = 0
              PozSez(tiefe) = i%
              EXIT FOR
            END IF
          ELSE
            IF SezFigBile(i%).pole = ep% THEN
              SezFigBile(i%).pole = 0
              PozSez(tiefe) = i%
              EXIT FOR
            END IF
          END IF
         NEXT i%
      MatBilanz(tiefe) = MatBilanz(tiefe) - 100
      END IF
   ELSE    ' Falls Figur geschlagen wird, verndere Materialbilanz
      IF brani% > 0 THEN   ' Figur wurde geschlagen
         FOR i% = 1 TO 15
          IF Farbe = 1 THEN
            IF SezFigCerne(i%).pole = nach% THEN
              SezFigCerne(i%).pole = 0
              PozSez(tiefe) = i%
              EXIT FOR
            END IF
          ELSE
            IF SezFigBile(i%).pole = nach% THEN
              SezFigBile(i%).pole = 0
              PozSez(tiefe) = i%
              EXIT FOR
            END IF
          END IF
         NEXT i%
         MatVeraenderung% = FigMaterial(brani%)
         MatBilanz(tiefe) = MatBilanz(tiefe) - MatVeraenderung%
         ' In Materialsumme geht nur das Material von Figuren ein
         IF MatVeraenderung% <> 100 THEN
            MatSumme(tiefe) = MatSumme(tiefe) - MatVeraenderung%
         END IF
      END IF
   END IF
   brett(nach%) = brett(von%)           ' Zug am Brett setzen
   brett(von%) = 0
  
   ' Jetzt kommen die Sonderflle Umwandlung und Rochade
   IF Promena% > 0 THEN     ' Bauern-Umwandlung
      brett(nach%) = Farbe * Promena%
      MatVeraenderung% = FigMaterial(Promena%) - 100
      MatBilanz(tiefe) = MatBilanz(tiefe) - MatVeraenderung%
      ' Bauern werden in MatSumme nicht gezhlt.
      MatSumme(tiefe) = MatSumme(tiefe) + MatVeraenderung% + 100
   ELSE
      IF ZugStapel(AktZug%).extra = 7 THEN
         brett(nach% + 1) = 0    ' nach ist G1 oder G8 (je nach Farbe)
         brett(nach% - 1) = Farbe * 2' Auf F1/F8 weien/schwarzen Turm setzen
         FOR i% = 2 TO 15
          IF Farbe = 1 THEN
            IF SezFigBile(i%).pole = nach% + 1 THEN
              SezFigBile(i%).pole = nach% - 1
              SezFigBile(i%).pohyb = SezFigBile(i%).pohyb + 1
              PozSez(tiefe) = i%
              EXIT FOR
            END IF
          ELSE
            IF SezFigCerne(i%).pole = nach% + 1 THEN
              SezFigCerne(i%).pole = nach% - 1
              SezFigCerne(i%).pohyb = SezFigCerne(i%).pohyb + 1
              PozSez(tiefe) = i%
              EXIT FOR
            END IF
          END IF
         NEXT i%
         Rochade(Farbe + 1) = 1
      ELSEIF ZugStapel(AktZug%).extra = 8 THEN
         brett(nach% - 2) = 0    ' nach ist c1 bzw. c8
         brett(nach% + 1) = Farbe * 2
         FOR i% = 2 TO 15
          IF Farbe = 1 THEN
            IF SezFigBile(i%).pole = nach% - 2 THEN
              SezFigBile(i%).pole = nach% + 1
              SezFigBile(i%).pohyb = SezFigBile(i%).pohyb + 1
              PozSez(tiefe) = i%
              EXIT FOR
            END IF
          ELSE
            IF SezFigCerne(i%).pole = nach% - 2 THEN
              SezFigCerne(i%).pole = nach% + 1
              SezFigCerne(i%).pohyb = SezFigCerne(i%).pohyb + 1
              PozSez(tiefe) = i%
              EXIT FOR
            END IF
          END IF
         NEXT i%
         Rochade(Farbe + 1) = 1
      END IF
   END IF
   'ndere die Farbe (Seite die am Zug ist)
   Farbe = -Farbe
END SUB

'--------------------------------------------------------------------
' Versucht, den bergebenen String als Zug zu interpretieren.
' Liegt ein legaler Zug vor, wird der Zug ausgefhrt und die Funktion
' liefert den Wert "Wahr". Ist kein (legaler) Zug identifizierbar,
' liefert die Funktion den Wert 'Falsch'.
'--------------------------------------------------------------------
FUNCTION Zugeingabe% (Zug$)
   IF LEN(Zug$) < 4 THEN      ' Erlaubt ist nur von-nach-Darstellung
      Zugeingabe% = 0
      EXIT FUNCTION
   END IF

   von% = Feldnummer%(Zug$)
   nach% = Feldnummer%(MID$(Zug$, 3, 2))
   IF PocetHracu% < 2 THEN
        ZmenaPoziceKurzoru 0
   ELSE
        ZmenaPoziceKurzoru nach%
   END IF
   CALL GeneriereZuege(1)
   FOR i% = StapelGrenze(tiefe) TO StapelGrenze(tiefe + 1) - 1
      IF ZugStapel(i%).tah = von% * 100 + nach% THEN
         IF (ZugStapel(i%).extra MOD 100) \ 10 > 0 THEN ' Umwandlungen werden
            IF LEN(Zug$) < 5 THEN
                StartCas = TIMER
                LOCATE 29, 55: Vystup 65: PRINT ; " ("; FigSymbol(5); FigSymbol(2); FigSymbol(4); FigSymbol(3); ") ?";
                DO
                    IF StartCas > TIMER THEN StartCas = StartCas - 86400
                    b$ = UCASE$(LTRIM$(INKEY$))
                    IF b$ <> "" THEN Zug$ = Zug$ + b$: EXIT DO
                LOOP UNTIL (TIMER - StartCas) > 10
            END IF
            IF RIGHT$(Zug$, 1) = FigSymbol(4) THEN  ' in der Reihenfolge Dame, Springer
               i% = i% + 1                  ' Lufer und Turm erzeugt
            ELSEIF RIGHT$(Zug$, 1) = FigSymbol(3) THEN
               i% = i% + 2
            ELSEIF RIGHT$(Zug$, 1) = FigSymbol(2) THEN
               i% = i% + 3
            END IF
         END IF
         CALL InitSpielbaum
         LOCATE 29, 55
         Vystup 33
         CALL ZeigeZug(i%)
         tmp% = LetzterZug         ' Bisher letzten Zug zwischenspeichern.
         CALL ZugAusfuehren(i%)    ' Achtung: ZugAusfuehren verndert bereits
                                   ' die Farbe. Nchste Farbabfrage mu dies
                                   ' kompensieren.
         IF Farbe = -1 THEN
            IF AttackiertFeld%(SezFigBile(0).pole, -1) = 1 THEN
               CALL ZugZuruecknehmen((i%))
               LetzterZug = tmp%      ' Kein neuer Zug gemacht. Bisher letzten
               Zugeingabe% = 0  ' Zug wieder herstellen
               EXIT FUNCTION
            END IF
         ELSEIF AttackiertFeld%(SezFigCerne(0).pole, 1) = 1 THEN
            CALL ZugZuruecknehmen((i%))
            LetzterZug = tmp%
            Zugeingabe% = 0
            EXIT FUNCTION
         END IF
         CALL DruckeZug(i%)
         Zugeingabe% = 1
         j% = Feldnummer%(Zug$) * 100 + Feldnummer%(MID$(Zug$, 3, 2))
         PUT #3, 1, ZugNr%
         PUT #3, (ZugNr% * 3), j%
         j% = ABS(brett(nach%))
         PUT #3, (ZugNr% * 3) + 1, j%
         j% = ZugStapel(i%).extra
         PUT #3, (ZugNr% * 3) + 2, j%
         PUT #4, 8, CasBily%
         PUT #4, 9, CasCerny%
         IF BookIndex% <> 0 THEN
            PracIndex% = BookIndex%      'uloz stary index pro kontrolu,
                                         'zda byl nalezen teoreticky tah
            GET #7, BookIndex%, k%       'pocet teoretickych tahu v pozici
            FOR okruh% = 0 TO (k% - 1)
              GET #7, BookIndex% + 3 * okruh% + 1, l%  'tah knihovny
              j% = Feldnummer%(Zug$) * 100 + Feldnummer%(MID$(Zug$, 3, 2))
              IF j% = l% THEN
                'tah nalezen, nacti nove poradi zaznamu knihovny
                'pro aktualni pozici
                GET #7, BookIndex% + 3 * okruh% + 3, BookIndex%
                EXIT FOR
              END IF
            NEXT okruh%
            IF BookIndex% = PracIndex% THEN BookIndex% = 0'teorie skoncila
         END IF
         EXIT FUNCTION
      END IF
   NEXT i%
   Zugeingabe% = 0  ' Eingegebener Zug wurde in Zugliste nicht gefunden
END FUNCTION

' -----------------------------------------------------------------
' Generiert alle Zge und zeigt sie am Bildschirm an
' -----------------------------------------------------------------
SUB Zugliste
   LOCATE 11, 55
   CALL GeneriereZuege(1)
   IF Farbe = 1 THEN
      Mattgesetzt% = AttackiertFeld%(SezFigCerne(0).pole, 1)
   ELSE
      Mattgesetzt% = AttackiertFeld%(SezFigBile(0).pole, -1)
   END IF
   IF Mattgesetzt% THEN
      Vystup 30
      SLEEP
      EXIT SUB
   END IF
   Vystup 31
   PRINT ; index - StapelGrenze(tiefe);
   j% = 0
   FOR i% = StapelGrenze(tiefe) TO index - 1
      LOCATE 11 + (j% + 3) \ 3, 55 + ((j% MOD 3) * 8)
      CALL ZeigeZug(i%)
      IF j% = 42 THEN
        LOCATE 27, 55: Vystup 32
        SLEEP
        CistiRadek 11, 27
      END IF
      j% = j% + 1
   NEXT i%
   SLEEP
END SUB

' -----------------------------------------------------------------
' Nimmt einen Zug zurck
' Da die gespielten Zge nicht gespeichert werden, kann maximal
' ein Zug zurckgenommen werden.
' -----------------------------------------------------------------
SUB ZugZurueck
  k% = ZugNr% - 1
  IF k% >= 0 THEN PUT #3, 1, k%
  Initialisiere 0
  TiskniRamecky
  KresliSachovnici
END SUB

'--------------------------------------------------------------------
' Nimmt einen Zug im Baum zurck.
' Aktzug% ist der Index des Zuges im ZugStapel.
'--------------------------------------------------------------------
SUB ZugZuruecknehmen (AktZug%)
   ZugNr% = ZugNr% - 1
   von% = ZugStapel(AktZug%).tah \ 100
   nach% = ZugStapel(AktZug%).tah MOD 100
   IF ZugStapel(AktZug%).extra > 0 THEN
    ep% = ZugStapel(AktZug%).extra \ 100
    Promena% = (ZugStapel(AktZug%).extra - ep% * 100) \ 10
    brani% = ZugStapel(AktZug%).extra - ep% * 100 - Promena% * 10
    IF brani% > 6 THEN brani% = 0
   ELSE
    ep% = 0
    brani% = 0
    Promena% = 0
   END IF

   FOR i% = 0 TO 15
    IF Farbe = -1 THEN
      IF SezFigBile(i%).pole = nach% THEN
        SezFigBile(i%).pole = von%
        SezFigBile(i%).pohyb = SezFigBile(i%).pohyb - 1
        IF Promena% > 0 THEN SezFigBile(i%).figura = 1
        EXIT FOR
      END IF
    ELSE
      IF SezFigCerne(i%).pole = nach% THEN
        SezFigCerne(i%).pole = von%
        SezFigCerne(i%).pohyb = SezFigCerne(i%).pohyb - 1
        IF Promena% > 0 THEN SezFigCerne(i%).figura = -1
        EXIT FOR
      END IF
    END IF
   NEXT i%
   
   Farbe = -Farbe                           ' andere Seite am Zug
   tiefe = tiefe - 1                        ' eine Ebene hher im Baum
   brett(von%) = brett(nach%)               ' Figur zurcksetzen
   brett(nach%) = 0



   IF ep% > 0 AND brani% = 1 THEN
      brett(ep%) = -Farbe                   ' 1=Wei%, -1=-1
      IF Farbe = 1 THEN
         SezFigCerne(PozSez(tiefe + 1)).pole = ep%
         SezFigCerne(PozSez(tiefe + 1)).figura = -1
      ELSE
         SezFigBile(PozSez(tiefe + 1)).pole = ep%
         SezFigBile(PozSez(tiefe + 1)).figura = 1
      END IF
   ' Geschlagene Figur wieder zurck setzen
   ELSEIF brani% <> 0 THEN
      brett(nach%) = (-Farbe) * brani%
      IF Farbe = 1 THEN
         SezFigCerne(PozSez(tiefe + 1)).pole = nach%
         SezFigCerne(PozSez(tiefe + 1)).figura = -brani%
      ELSE
         SezFigBile(PozSez(tiefe + 1)).pole = nach%
         SezFigBile(PozSez(tiefe + 1)).figura = brani%
      END IF
   END IF
   ' Bei Rochade Turm zurck
   IF ZugStapel(AktZug%).extra = 7 THEN
      brett(nach% + 1) = Farbe * 2
      brett(nach% - 1) = 0
      IF Farbe = 1 THEN
          SezFigBile(PozSez(tiefe + 1)).pole = nach% + 1
          SezFigBile(PozSez(tiefe + 1)).pohyb = 0
      ELSE
          SezFigCerne(PozSez(tiefe + 1)).pole = nach% + 1
          SezFigCerne(PozSez(tiefe + 1)).pohyb = 0
      END IF
      Rochade(Farbe + 1) = 0
   ELSEIF ZugStapel(AktZug%).extra = 8 THEN
      brett(nach% - 2) = Farbe * 2
      brett(nach% + 1) = 0
      IF Farbe = 1 THEN
          SezFigBile(PozSez(tiefe + 1)).pole = nach% - 2
          SezFigBile(PozSez(tiefe + 1)).pohyb = 0
      ELSE
          SezFigCerne(PozSez(tiefe + 1)).pole = nach% - 2
          SezFigCerne(PozSez(tiefe + 1)).pohyb = 0
      END IF
      Rochade(Farbe + 1) = 0
   END IF
   IF Promena% > 0 THEN
      brett(von%) = Farbe           ' Bauernumwandlung zurcknehmen
   END IF
   ' Falls Knig gezogen hat, aktualisiere die Position des Knigs
END SUB

