' -----------------------------------------------------------------
'
' JiG source by Jessac Mathias Baird
'
'  here it is.. i cleaned it up and finalised the game,
'  note that the font routines were written by ME, but you
'  may use any part of this source if you separate it from
'  the main program for your own use. do not change anything
'  in this file, please distribute AS IS. thank you
'
' -----------------------------------------------------------------

DEFINT A-Z

'/ --------------------------
'/ global const definitions:
'/ --------------------------

CONST TRUE = -1, FALSE = 0

CONST kup% = 72               '/ for the up key, chr$(0) + chr$(kup%)
CONST kleft% = 75             '/ for the left key, chr$(0) + chr$(kleft%)
CONST kright% = 77            '/ for the right key, chr$(0) + chr$(kright%)
CONST kdown% = 80             '/ for the down key, chr$(0) + chr$(kdown%)

'/ --------------------------
'/ global type definitions:
'/ --------------------------

TYPE PalRec      ' type used for a palette array
 r AS INTEGER    ' .. red, from 0 to 63
 g AS INTEGER    ' .. blue, from 0 to 63
 b AS INTEGER    ' .. green, from 0 to 63
END TYPE         ' type = 6 bytes per element

TYPE font13t       ' type used for the font set
 y AS STRING * 1   ' .. binary data, 1 byte
END TYPE

'/ -------------------------------
'/ global variable declarations:
'/ -------------------------------

DIM SHARED pal(0 TO 255) AS PalRec               ' virutal palette array
DIM SHARED font13(0 TO 255, 0 TO 7) AS font13t   ' array for the font set
DIM SHARED tiles%(0 TO 201, 0 TO 5)              ' array for the tile set
DIM SHARED JiGmap%(0 TO 15, 0 TO 9)              ' map array for the game
DIM SHARED JiGrandom%                           ' indicates random maps

'/ -------------------------------------
'/ procedure and function declarations:
'/ -------------------------------------

REM $DYNAMIC
REM $INCLUDE: 'GSLIB.BI'

DECLARE SUB font13load (FontFile$, FontAry() AS font13t)
DECLARE SUB font13shadow (txt$, x%, y%, col%, zoom%, FontAry() AS font13t, dseg%, dofs%)
DECLARE SUB font13drw (txt$, x%, y%, col%, FontAry() AS font13t, dseg%, dofs%)
DECLARE SUB font13zoom (txt$, x%, y%, col%, zoom%, FontAry() AS ANY, dseg%, dofs%)

DECLARE SUB pal13load (PalF$, PalAry() AS PalRec)
DECLARE SUB pal13put (PalAry() AS PalRec)
DECLARE SUB pal13fto (PalAry() AS PalRec)
DECLARE SUB pal13fdown ()
DECLARE SUB pal13kill ()

DECLARE SUB tilesload (TileF$, TileAry%())

DECLARE SUB JiGintro ()
DECLARE SUB JiGinit ()
DECLARE SUB JiGerror (msg$)

DECLARE SUB JiGplay (MapF$)
DECLARE SUB drwBox (x1%, y1%, x2%, y2%, c1%, c2%, bc%, dseg%, dofs%)

'/ -----------------------------
'/ lobal variable declarations:
'/ -----------------------------

DIM key$

'/ -------------------
'/ main program code:
'/ -------------------

SCREEN 13       '/ enter the 320x200x256 vga mode, screen 13h

CALL font13load("GFX\JIG.FNT", font13())     '/ load the default JiG font
CALL tilesload("GFX\JIG.GFX", tiles())       '/ load the tile set

main:

CALL JiGintro           '/ call the intro routine and display the fs logo
CALL JiGinit            '/ call the init routine for the menu

'/ run the menu

DO
 key$ = INKEY$
 IF (key$ <> "") THEN WHILE (INKEY$ <> ""): WEND

 SELECT CASE (key$)
  CASE "1"
   CALL JiGplay("DATA\LEVEL1.DAT"): GOTO main
  CASE "2"
   CALL JiGplay("DATA\LEVEL2.DAT"): GOTO main
  CASE "3"
   CALL JiGplay("DATA\LEVEL3.DAT"): GOTO main
  CASE "4"
   CALL JiGplay("DATA\LEVEL4.DAT"): GOTO main
  CASE "5"
   CALL gsboxf(&HA000, 0, 18 * 8 + 100, 150, 18 * 8 + 100 + 40, 160, 55)
   IF (JiGrandom% = TRUE) THEN
    JiGrandom% = FALSE
    CALL font13drw(SPACE$(18) + "(off)", 100, 150, 15, font13(), &HA000, 0)
   ELSE
    JiGrandom% = TRUE
    CALL font13drw(SPACE$(18) + "(on)", 100, 150, 15, font13(), &HA000, 0)
   END IF
  CASE CHR$(27): GOTO JiGshutdown
 END SELECT

LOOP UNTIL (key$ = "6")

'/ shuts down the program...

JiGshutdown:

SCREEN 0
WIDTH 80, 25    '/ enter text mode 3h (80x25x15)
CLS

PRINT "JiG was programmed by Jessac Mathias Baird"
PRINT "Brought to you by 2000 Flying Software(tm)"
PRINT "http://flyingsoft.zext.net"
PRINT
PRINT "Special thanks to... "
PRINT "  Jason Gould, for writing GSLib"
PRINT
PRINT

WHILE (INKEY$ <> ""): WEND
WHILE (INKEY$ = ""): WEND

SYSTEM                          '/ close all files and escape to the os

REM $STATIC
SUB drwBox (x1%, y1%, x2%, y2%, c1%, c2%, bc%, dseg%, dofs%)

DIM y%, c%

c% = c1%

FOR y% = 0 TO 4

 c% = c% + c2%
 CALL gsbox(dseg%, dofs%, x1% + y%, y1% + y%, x2% - y%, y2% - y%, c%)

NEXT y%

CALL gsboxf(dseg%, dofs%, x1% + 5, y1% + 5, x2% - 5, y2% - 5, bc%)

END SUB

'----------------------------------------------------------------------------
' font13drw by JMB -
'  desc: for a pure qb font routine, this will pset each character in txt$
'   it is obviously slow but faster than most i have used! i did comment, but
'   i would urge you to remove the comments if your program is not to be
'   compiled, as this will make it run a bit faster. pass 999 in for x% to
'   center your text at the y% vertical row.
'
'  note: txt$ is your text, x% and y% are horizontal and vertical
'   coordinates, respectively. col% is the colour of the text, and FontAry()
'   is the array containing your character data (the font set). i replaced
'   the pset from the previously written routine to use gspset, so dseg%
'   and dofs% are your segment and offset addresses, respectively.
'
'----------------------------------------------------------------------------
SUB font13drw (txt$, x%, y%, col%, FontAry() AS font13t, dseg%, dofs%)

'/ local variables:

DIM char%, byte%
DIM xloc%, yloc%
DIM ch%, y1%

'/ get x and center it:

xloc% = x%
IF (xloc% = 999) THEN xloc% = 160 - ((LEN(txt$) \ 2) * 8)

'/ ch% loops thru each characterin txt$:

FOR ch% = 1 TO LEN(txt$)
 char% = ASC(MID$(txt$, ch%, 1))      '/ get the character's ascii value

 '/ y1% loops through the 8 bytes containing this
 '/ character's binary data.. each bit set in the byte%
 '/ means that the pixel is to be drawn

 yloc% = y%                             '/ start at the y% vertical pixel
 FOR y1% = 0 TO 7
  byte% = ASC(FontAry(char%, y1%).y)    '/ get this row's binary data

  '/ check each bit and draw the pixel if it is set..
  '/ this is actually faster than an x loop..

   IF (1 AND byte%) THEN gspset (xloc% + 7), yloc%, dseg%, dofs%, col%
   IF (2 AND byte%) THEN gspset (xloc% + 6), yloc%, dseg%, dofs%, col%
   IF (4 AND byte%) THEN gspset (xloc% + 5), yloc%, dseg%, dofs%, col%
   IF (8 AND byte%) THEN gspset (xloc% + 4), yloc%, dseg%, dofs%, col%
   IF (16 AND byte%) THEN gspset (xloc% + 3), yloc%, dseg%, dofs%, col%
   IF (32 AND byte%) THEN gspset (xloc% + 2), yloc%, dseg%, dofs%, col%
   IF (64 AND byte%) THEN gspset (xloc% + 1), yloc%, dseg%, dofs%, col%
   IF (128 AND byte%) THEN gspset xloc%, yloc%, dseg%, dofs%, col%
                                                                        
  yloc% = yloc% + 1             '/ go to the next row..
 NEXT y1%

 xloc% = xloc% + 8      '/ move right 8 pixels on the screen
NEXT ch%

END SUB

SUB font13load (FontFile$, FontAry() AS font13t)

DIM ff%, ch%, y%
DIM ch1%, ch2%
DIM byte AS STRING * 1

ff% = FREEFILE

OPEN FontFile$ FOR BINARY AS #ff%

IF (LOF(ff%) = 0) THEN
 CLS
 WIDTH 80, 25
  PRINT "ERROR: font file contains no data"
  PRINT "press any key to terminate..."
 WHILE (INKEY$ = ""): WEND
 CLOSE
 SYSTEM
END IF

GET #ff%, , byte
IF (ASC(byte) <> 255) THEN GOTO EndProc

GET #ff%, , byte
ch1% = ASC(byte)
GET #ff%, , byte
ch2% = ASC(byte)

IF ((ch1% < 0) OR (ch2% > 255) OR (ch1% > ch2%)) THEN GOTO EndProc

FOR ch% = ch1% TO ch2%
 FOR y% = 0 TO 7
  IF (NOT EOF(ff%)) THEN
   GET #ff%, , byte
   FontAry(ch%, y%).y = byte
  ELSE
   GOTO EndProc
  END IF
 NEXT y%
NEXT ch%

EndProc:
CLOSE #ff%

END SUB

SUB font13shadow (txt$, x%, y%, col%, zoom%, FontAry() AS font13t, dseg%, dofs%)

xloc% = x%

IF (zoom% > 1) THEN
 IF (xloc% = 999) THEN xloc% = 160 - ((LEN(txt$) / 2) * 8 * zoom%)
 CALL font13zoom(txt$, xloc% - 1, y%, 0, zoom%, font13(), dseg%, dofs%)
 CALL font13zoom(txt$, xloc% + 1, y%, 0, zoom%, font13(), dseg%, dofs%)
 CALL font13zoom(txt$, xloc%, y% - 1, 0, zoom%, font13(), dseg%, dofs%)
 CALL font13zoom(txt$, xloc%, y% + 1, 0, zoom%, font13(), dseg%, dofs%)
 CALL font13zoom(txt$, xloc%, y%, col%, zoom%, font13(), dseg%, dofs%)
ELSE
  IF (xloc% = 999) THEN xloc% = 160 - ((LEN(txt$) / 2) * 8)
 CALL font13drw(txt$, xloc% - 1, y%, 0, font13(), dseg%, dofs%)
 CALL font13drw(txt$, xloc% + 1, y%, 0, font13(), dseg%, dofs%)
 CALL font13drw(txt$, xloc%, y% - 1, 0, font13(), dseg%, dofs%)
 CALL font13drw(txt$, xloc%, y% + 1, 0, font13(), dseg%, dofs%)
 CALL font13drw(txt$, xloc%, y%, col%, font13(), dseg%, dofs%)
END IF

END SUB

'----------------------------------------------------------------------------
' font13zoom -
'  desc: for a pure qb font routine, this will zoom each character in txt$
'   by one pixel for each zoom%. i commented a bit, but you should remove
'   all comments in your programs if you do not wish to compile them.
'
'  note: txt$ is your text, x% and y% are horizontal and vertical
'   coordinates, respectively. col% is the colour of the text, zoom% is the
'   amount to zoom, and FontAry() is the array containing your character
'   data (the font set)
'----------------------------------------------------------------------------
SUB font13zoom (txt$, x%, y%, col%, zoom%, FontAry() AS font13t, dseg%, dofs%)

'/ local variables:

DIM char%, byte%
DIM xloc%, yloc%
DIM ch%, y1%, Z%, pz%

Z% = zoom%
IF (Z% > 10) THEN Z% = 10
IF (Z% < 1) THEN Z% = 1
pz% = Z% - 1

'/ get x and center it:

xloc% = x%
IF (xloc% = 999) THEN xloc% = 160 - ((LEN(txt$) \ 2) * 8 * Z%)

'/ ch% loops thru each characterin txt$:

FOR ch% = 1 TO LEN(txt$)
 char% = ASC(MID$(txt$, ch%, 1))      '/ get the character's ascii value

 '/ y1% loops through the 8 bytes containing this
 '/ character's binary data.. each bit set in the byte%
 '/ means that the pixel is to be drawn

 yloc% = y%                             '/ start at the y% vertical pixel
 FOR y1% = 0 TO 7
  byte% = ASC(FontAry(char%, y1%).y)    '/ get this row's binary data

  '/ check each bit and draw the pixel if it is set..
  '/ this is actually faster than an x loop..

   IF (1 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (7 * Z%), yloc%, xloc% + (7 * Z%) + pz%, yloc% + pz%, col%)
   IF (2 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (6 * Z%), yloc%, xloc% + (6 * Z%) + pz%, yloc% + pz%, col%)
   IF (4 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (5 * Z%), yloc%, xloc% + (5 * Z%) + pz%, yloc% + pz%, col%)
   IF (8 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (4 * Z%), yloc%, xloc% + (4 * Z%) + pz%, yloc% + pz%, col%)
   IF (16 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (3 * Z%), yloc%, xloc% + (3 * Z%) + pz%, yloc% + pz%, col%)
   IF (32 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (2 * Z%), yloc%, xloc% + (2 * Z%) + pz%, yloc% + pz%, col%)
   IF (64 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (1 * Z%), yloc%, xloc% + (1 * Z%) + pz%, yloc% + pz%, col%)
   IF (128 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc%, yloc%, xloc% + pz%, yloc% + pz%, col%)

  yloc% = yloc% + Z%         '/ go to the next row..
 NEXT y1%

 xloc% = xloc% + (Z% * 8)  '/ move right 8 pixels on the screen
NEXT ch%


END SUB

SUB JiGerror (msg$)

WIDTH 80, 25: CLS

PRINT msg$
PRINT
PRINT "press any key to continue..."

WHILE (INKEY$ = ""): WEND

SYSTEM

END SUB

SUB JiGinit

'/ local variables (habit from pascal)

DIM tileseg%, tileofs%
DIM x%, y%

tileseg% = VARSEG(tiles%(0, 3))
tileofs% = VARPTR(tiles%(0, 3))

CALL pal13kill                          '/ set all rgb values to 0
CALL pal13load("GFX\JIG.PAL", pal())    '/ load the default JiG palette

'/ draw the title screen's background

FOR y% = 0 TO 9
 FOR x% = 0 TO 15
  CALL gssolidput(x% * 20, y% * 20, &HA000, 0, tileseg%, tileofs%)
 NEXT x%
NEXT y%

'/ display the title

CALL font13shadow("JiG", 999, 7, 15, 5, font13(), &HA000, 0)
CALL font13shadow("By Jessac Mathias Baird", 999, 49, 15, 0, font13(), &HA000, 0)
CALL font13shadow("Flying Software 2000", 999, 60, 15, 0, font13(), &HA000, 0)

'/ display the menu

CALL drwBox(10, 80, 309, 198, 55, 1, 55, &HA000, 0)
CALL font13drw("Make A Selection", 999, 90, 15, font13(), &HA000, 0)
CALL font13drw("(1) SmAlL GaMe", 100, 110, 15, font13(), &HA000, 0)
CALL font13drw("(2) MeDiUm GaMe", 100, 120, 15, font13(), &HA000, 0)
CALL font13drw("(3) LaRgE GaMe", 100, 130, 15, font13(), &HA000, 0)
CALL font13drw("(4) HuGe GaMe", 100, 140, 15, font13(), &HA000, 0)
CALL font13drw("(5) ToGgLe RaNdOm", 100, 150, 15, font13(), &HA000, 0)
CALL font13drw("(6) ExIt", 100, 160, 15, font13(), &HA000, 0)
CALL font13drw("see README.TXT for instructions", 999, 180, 15, font13(), &HA000, 0)

IF (JiGrandom% = TRUE) THEN
 CALL font13drw(SPACE$(18) + "(on)", 100, 150, 15, font13(), &HA000, 0)
ELSE
 CALL font13drw(SPACE$(18) + "(off)", 100, 150, 15, font13(), &HA000, 0)
END IF

'/ put the palette to the screen

CALL pal13put(pal())

END SUB

SUB JiGintro

CALL pal13load("GFX\INTRO.PAL", pal())   '/ load the palette from the disk
CALL pal13kill                          '/ set all rgb values to 0

'/ load the flying software(tm) logo
'/ (c) 2000 flying software(tm)

DEF SEG = &HA000                '/ point to &ha000
 BLOAD "GFX\INTRO.BSV", 0        '/ dump intro.bsv to &hA000
DEF SEG                         '/ point back to the default data seg

CALL pal13fto(pal())            '/ fade the palette up
 SLEEP 1                         '/ display palette for 1 second
CALL pal13fdown                 '/ fade palette down

CLS

END SUB

SUB JiGplay (MapF$)

'/ local variables:

DIM ff%                     '/ the 'freefile' variable

DIM x%, y%
DIM px%, py%                 '/ used for tile placement
DIM elx%, ely%               '/ temporary x/y values, and tile placement
DIM mapx1%, mapy1%           '/ map extends from (mapx1%,mapy1%)
DIM mapx2%, mapy2%            ' ..to (mapx2%,mapy2%)
DIM mapx%, mapy%             '/ map width and height, respectively
DIM mapel%                   '/ always the current value from the map

DIM numtiles%               '/ when 0, the game has been won
DIM nummoves%               '/ keeps track of the number of moves made

DIM buf%((200 * 100) / 2 + 1)   '/ used for the window under JiGquit
DIM tileseg%, tileofs%          '/ for the tile you see behind the numbers
DIM csrseg%, csrofs%            '/ for the cursor (with the X in it)

'/ make sure the file exists:

ff% = FREEFILE
OPEN (MapF$) FOR BINARY AS #ff%
 IF (LOF(ff%) = 0) THEN
  CALL JiGerror("ERROR: Map File, " + MapF$ + " Empty!")
 END IF
CLOSE #ff%

'/ if it exists, the move on:

tileseg% = VARSEG(tiles%(0, 2))         '/ used for the the bg tiles
tileofs% = VARPTR(tiles%(0, 2))         '/ seg and ofs addr of the tile
csrseg% = VARSEG(tiles%(0, 4))          '/ cursor segment addr
csrofs% = VARPTR(tiles%(0, 4))          '/ cursor offset addr

OPEN (MapF$) FOR INPUT AS #ff%
 INPUT #ff%, mapx1%, mapy1%             '/ read the first coords of the map
 INPUT #ff%, mapx2%, mapy2%             '/ read the next coords of the map

 mapx% = (mapx2% - mapx1%) + 1
 mapy% = (mapy2% - mapy1%) + 1

 FOR ely% = 0 TO 9                       '/ loops thru the map vertically
  FOR elx% = 0 TO 15                     '/ loops thru the map horizontally
  
   INPUT #ff%, mapel%                    '/ get one map element from the file
  
   '/ place a tile and number it if we are within
   '/ the map's boundaries, otherwise place a tile
   '/ from the tile set loaded in tiles%
  
    JiGmap(elx%, ely%) = mapel%

  NEXT elx%
 NEXT ely%
CLOSE #ff%

IF (JiGrandom% = TRUE) THEN GOSUB JiGrandommap

GOSUB JiGdrawmap

'/ put the cursor on the screen

CALL gssolidput(px% * 20, py% * 20, &HA000, 0, csrseg%, csrofs%)

nummoves% = 1           '/ keep track of the # of moves

GOSUB JiGscanmap

DO

 '/ check to see if the game is over:

 IF (numtiles% = 0) THEN
  GOTO JiGwon
 END IF

 '/ get a key from the user:

 DO
  key$ = INKEY$
 LOOP UNTIL (key$ <> "")

 '/ clear the keyboard buffer:

 WHILE (INKEY$ <> ""): WEND

 '/ test the case of key$ and react accordingly:

 SELECT CASE (key$)
  
  CASE (CHR$(0) + CHR$(kup%))           '/ up cursor key
   IF (py% > mapy1%) THEN
    ely% = py% - 1
    elx% = px%
    GOSUB JiGmove
   END IF

  CASE (CHR$(0) + CHR$(kdown%))         '/ down cursor key
   IF (py% < mapy2%) THEN
    ely% = py% + 1
    elx% = px%
    GOSUB JiGmove
   END IF

  CASE (CHR$(0) + CHR$(kleft%))         '/ left cursor key
   IF (px% > mapy1%) THEN
    ely% = py%
    elx% = px% - 1
    GOSUB JiGmove
   END IF

  CASE (CHR$(0) + CHR$(kright%))        '/ right cursor key
   IF (px% < mapx2%) THEN
    ely% = py%
    elx% = px% + 1
    GOSUB JiGmove
   END IF

  CASE (CHR$(27))                       '/ escape key
   GOSUB JiGquit

 END SELECT
 
LOOP
GOTO JiGends

JiGmove:
 mapel% = JiGmap%(elx%, ely%)
  IF ((mapel% - 1) = (elx% - mapx1%) + ((ely% - mapy1%) * mapx%)) THEN
   numtiles% = numtiles% + 1
  ELSEIF ((mapel% - 1) = (px% - mapx1%) + ((py% - mapy1%) * mapx%)) THEN
   numtiles% = numtiles% - 1
  END IF
  IF (numtiles% = 0) THEN GOTO JiGwon
  JiGmap%(px%, py%) = mapel%
  JiGmap%(elx%, ely%) = 0
   CALL gssolidput(elx% * 20, ely% * 20, &HA000, 0, csrseg%, csrofs%)
   GOSUB JiGputtile
  px% = elx%
  py% = ely%
 IF (nummoves% = 32767) THEN GOSUB JiGlose
 nummoves% = nummoves% + 1
RETURN

JiGputtile:
 IF (mapel% > 0) THEN
  x% = px% * 20
  y% = py% * 20
  mapnum$ = LTRIM$(STR$(mapel))
  CALL gssolidput(x%, y%, &HA000, 0, tileseg%, tileofs%)
  CALL font13shadow(mapnum$, x% + 10 - (LEN(mapnum$) * 4), y% + 6, 15, 0, font13(), &HA000, 0)
 END IF
RETURN

JiGscanmap:
 numtiles% = mapx% * mapy% - 1
 FOR ely% = mapy1% TO mapy2%
  FOR elx% = mapx1% TO mapx2%
   mapel% = JiGmap%(elx%, ely%) - 1
   IF (mapel% = (elx% - mapx1%) + ((ely% - mapy1%) * mapx%)) THEN numtiles% = numtiles% - 1
  NEXT elx%
 NEXT ely%
RETURN

JiGrandommap:
 FOR ely% = mapy1% TO mapy2%            '/ clear each element in the map
  FOR elx% = mapx1% TO mapx2%
   JiGmap%(elx%, ely%) = 0
  NEXT elx%
 NEXT ely%

 FOR numtiles% = 1 TO (mapx% * mapy% - 1)
  DO
   elx% = INT(RND * mapx%) + mapx1%
   ely% = INT(RND * mapy%) + mapy1%
  LOOP UNTIL (JiGmap%(elx%, ely%) = 0)
  JiGmap%(elx%, ely%) = numtiles%
 NEXT numtiles%
RETURN

JiGdrawmap:
 elx% = px%
 ely% = py%
 FOR py% = 0 TO 9
  FOR px% = 0 TO 15
  
   mapel% = JiGmap%(px%, py%)
   IF ((px% <= mapx2%) AND (px% >= mapx1%) AND (py% >= mapy1%) AND (py% <= mapy2%)) THEN
   
    IF (mapel% = 0) THEN
     elx% = px%
     ely% = py%
    ELSE
     GOSUB JiGputtile
    END IF

   ELSE
    CALL gssolidput((px% * 20), (py% * 20), &HA000, 0, VARSEG(tiles%(0, mapel%)), VARPTR(tiles%(0, mapel%)))
   END IF
     
  NEXT px%
 NEXT py%
 px% = elx%
 py% = ely%
RETURN

JiGquit:
 GET (70, 50)-(270, 100), buf%
  CALL drwBox(70, 50, 270, 100, 55, 1, 55, &HA000, 0)
  CALL font13drw("Are you sure? (y/n)", 999, 65, 15, font13(), &HA000, 0)
 WHILE (INKEY$ <> ""): WEND
 DO
  DO
   key$ = INKEY$
  LOOP UNTIL (LEN(key$))
  IF (LCASE$(key$) = "y") THEN GOTO JiGends
 LOOP UNTIL (LCASE$(key$) = "n")
 CALL gssolidput(70, 50, &HA000, 0, VARSEG(buf%(0)), VARPTR(buf%(0)))
RETURN

JiGlose:
 CALL drwBox(10, 50, 309, 120, 55, 1, 55, &HA000, 0)
 CALL font13drw("You Lose!", 999, 60, 15, font13(), &HA000, 0)
 CALL font13drw("You have made too many moves", 999, 70, 15, font13(), &HA000, 0)
 CALL font13drw("Press A Key To Continue", 999, 100, 15, font13(), &HA000, 0)
 WHILE (INKEY$ <> ""): WEND
 WHILE (INKEY$ = ""): WEND
 GOTO JiGends

JiGwon:
 CALL drwBox(10, 50, 309, 120, 55, 1, 55, &HA000, 0)
 CALL font13drw("Congratulations!", 999, 60, 15, font13(), &HA000, 0)
 CALL font13drw("You won in" + STR$(nummoves%) + " moves", 999, 70, 15, font13(), &HA000, 0)
 CALL font13drw("Press A Key To Continue", 999, 100, 15, font13(), &HA000, 0)
 WHILE (INKEY$ <> ""): WEND
 WHILE (INKEY$ = ""): WEND

JiGends:

END SUB

'---------------------------------------------------------------------------
' pal13fdown -
'  desc: fades the entire palette down to rgb 0
'---------------------------------------------------------------------------
SUB pal13fdown

DIM cnt%, col%
DIM r%, g%, b%

FOR cnt% = 0 TO 63

 WAIT &H3DA, 8: WAIT &H3DA, 8, 8
 WAIT &H3DA, 8: WAIT &H3DA, 8, 8

 FOR col% = 0 TO 255

  OUT &H3C7, col%
  LET r% = INP(&H3C9): r% = r% + (r% > 0)
  LET g% = INP(&H3C9): g% = g% + (g% > 0)
  LET b% = INP(&H3C9): b% = b% + (b% > 0)

  OUT &H3C8, col%
  OUT &H3C9, r%
  OUT &H3C9, g%
  OUT &H3C9, b%

 NEXT col%
NEXT cnt%


END SUB

REM $DYNAMIC
'---------------------------------------------------------------------------
' pal13fto -
'  desc: fades the current 'visible' palette to PalAry()
'---------------------------------------------------------------------------
SUB pal13fto (PalAry() AS PalRec)

DIM cnt%, flag%
DIM r%, g%, b%

FOR cnt% = 0 TO 63

 WAIT &H3DA, 8: WAIT &H3DA, 8, 8
 WAIT &H3DA, 8: WAIT &H3DA, 8, 8

 FOR col% = 0 TO 255
  LET flag% = 0
 
  OUT &H3C7, col%
  r% = INP(&H3C9)
  g% = INP(&H3C9)
  b% = INP(&H3C9)
 
  IF (r% < PalAry(col%).r%) THEN r% = r% + 1: flag% = -1
  IF (r% > PalAry(col%).r%) THEN r% = r% - 1: flag% = -1
  IF (g% < PalAry(col%).g%) THEN g% = g% + 1: flag% = -1
  IF (g% > PalAry(col%).g%) THEN g% = g% - 1: flag% = -1
  IF (b% < PalAry(col%).b%) THEN b% = b% + 1: flag% = -1
  IF (b% > PalAry(col%).b%) THEN b% = b% - 1: flag% = -1

  IF (flag%) THEN
   OUT &H3C8, col%
   OUT &H3C9, r%
   OUT &H3C9, g%
   OUT &H3C9, b%
  END IF

 NEXT col%
NEXT cnt%

END SUB

REM $STATIC
'---------------------------------------------------------------------------
' pal13kill -
'  desc: kills the palette quickly to rgb 0
'---------------------------------------------------------------------------
SUB pal13kill

DIM col%

FOR col% = 0 TO 255
 OUT &H3C8, col%
 OUT &H3C9, 0
 OUT &H3C9, 0
 OUT &H3C9, 0
NEXT col%

END SUB

REM $DYNAMIC
'---------------------------------------------------------------------------
' pal13load -
'  desc: loads the palette file into PalAry but does not put the palette
'---------------------------------------------------------------------------
'
SUB pal13load (PalF$, PalAry() AS PalRec)

ff% = FREEFILE
OPEN PalF$ FOR BINARY AS #ff%
 FOR c% = 0 TO 255
  GET #ff%, , PalAry(c%).r
  GET #ff%, , PalAry(c%).g
  GET #ff%, , PalAry(c%).b
 NEXT c%
CLOSE #ff%

END SUB

REM $STATIC
'---------------------------------------------------------------------------
' pal13put -
'  desc: makes the virtual palette the 'visible' palette
'---------------------------------------------------------------------------
SUB pal13put (PalAry() AS PalRec)

DIM col%

FOR col% = 0 TO 255
 OUT &H3C8, col%
 OUT &H3C9, PalAry(col%).r%
 OUT &H3C9, PalAry(col%).g%
 OUT &H3C9, PalAry(col%).b%
NEXT col%

END SUB

SUB tilesload (TileF$, TileAry%())

DEF SEG = VARSEG(TileAry%(0, 0))
 BLOAD TileF$, VARPTR(TileAry%(0, 0))
DEF SEG

END SUB

