  '
  '                             Eamon-QB
  '
  '                      Control Parameter Conversion
  '                   
  '                           Version 1.0
  '
  '                          By John Nelson
  '
  '
  '
      KEY OFF
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     INPUT #1, Necro
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     GOTO Colorset
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
Colorset:
      CLS
      DIM MF.DATA$(36), M.DATA%(36), MFO.DATA$(36)
      DIM AF.DATA$(12), A.DATA%(12), AFO.DATA$(12)
      DIM RD%(10), RF.DIR$(10), RFO.DIR$(10)
      PRINT SPC(20); "Eamon-QB Dungeon Control Change"
      PRINT SPC(20); "         Version 1.00          "
      LOCATE 6, 1
      PRINT "This program is used when you want to change any control information"
      PRINT "after the adventure's files have been created. It will convert the room"
      PRINT "files and the room connection codes. Two disk drives or two separate"
      PRINT "directories are required, since conversion requires an input and an "
      PRINT "output diskette. If you decide against running this program, do not "
      PRINT "press 'C' when directed, and the run will be cancelled."
      PRINT
      PRINT "Insert adventure to be converted and press `C' key"
      A$ = ""
      WHILE A$ = ""
      A$ = INKEY$
      WEND
      IF UCASE$(A$) = "C" THEN GOTO GET.CONTROL
      CLS
      PRINT "Probably a smart move ..."
      END
GET.CONTROL:
      DEF FNRMCD (X)
          FNRMCD = 0
          ACT.ROOM = X
          IF BURY.ADJ < ACT.ROOM THEN ACT.ROOM = ACT.ROOM - BURY.ADJ: FNRMCD = 4: EXIT DEF
          IF HID.ADJ < ACT.ROOM THEN ACT.ROOM = ACT.ROOM - HID.ADJ: FNRMCD = 3: EXIT DEF
          IF EMB.ADJ < ACT.ROOM THEN ACT.ROOM = ACT.ROOM - EMB.ADJ: FNRMCD = 2: EXIT DEF
          IF INS.ADJ < ACT.ROOM THEN ACT.ROOM = ACT.ROOM - INS.ADJ: FNRMCD = 1: EXIT DEF
          IF ACT.ROOM < 0 THEN ACT.ROOM = ABS(ACT.ROOM) - 1: FNRMCD = -1: EXIT DEF
      END DEF
      DEF FNROOM (X, R)
          IF R = 0 THEN FNROOM = X: EXIT DEF
          IF R = 1 THEN FNROOM = X + NEW.INS.ADJ: EXIT DEF
          IF R = 2 THEN FNROOM = X + NEW.EMB.ADJ: EXIT DEF
          IF R = 3 THEN FNROOM = X + NEW.HID.ADJ: EXIT DEF
          IF R = 4 THEN FNROOM = X + NEW.BURY.ADJ: EXIT DEF
          IF R = -1 THEN FNROOM = -X - 1: EXIT DEF
      END DEF
      CLS
      LOCATE 6, 1
      PRINT "Input PATH of Input Eamon Adventure ==> ";
      LINE INPUT "", PATH.IN$
      LOCATE 8, 1
      PRINT "Input PATH of Output Eamon Adventure ==> ";
      LINE INPUT "", PATH.OUT$
      OPEN PATH.IN$ + "DESC.R0" FOR INPUT AS #1
      INPUT #1, NR
      INPUT #1, NA
      INPUT #1, NE
      INPUT #1, NM
      IF EOF(1) THEN
          ND = 6
          MAX.RM = 100
          MAX.ART = 100
          MAX.EFF = 100
          RM.LEN = 64
          RMN.LEN = 64
          MON.LEN = 128
          ART.LEN = 128
          DESC.LEN = 256
      ELSE
          INPUT #1, ND
          INPUT #1, MAX.RM
          INPUT #1, MAX.ART
          INPUT #1, MAX.EFF
          INPUT #1, RM.LEN
          INPUT #1, RMN.LEN
          INPUT #1, MON.LEN
          INPUT #1, ART.LEN
          INPUT #1, DESC.LEN
      END IF
      IF EOF(1) THEN
          MON.FLDS = 12
          ART.FLDS = 8
          RM.FLDS = ND + 1
          MN.LEN = 20
          AN.LEN = 20
      ELSE
          INPUT #1, MON.FLDS
          INPUT #1, ART.FLDS
          INPUT #1, RM.FLDS
          INPUT #1, MN.LEN
          INPUT #1, AN.LEN
      END IF
      INS.ADJ = MAX.RM
      EMB.ADJ = MAX.RM + MAX.ART
      HID.ADJ = MAX.RM * 2 + MAX.ART
      BURY.ADJ = MAX.RM * 3 + MAX.ART
      NEW.NA = NA
      NEW.NR = NR
      NEW.NE = NE
      NEW.NM = NM
      NEW.ND = ND
      NEW.MAX.RM = MAX.RM
      NEW.MAX.ART = MAX.ART
      NEW.MAX.EFF = MAX.EFF
      NEW.RM.LEN = RM.LEN
      NEW.RMN.LEN = RMN.LEN
      NEW.MON.LEN = MON.LEN
      NEW.ART.LEN = ART.LEN
      NEW.MN.LEN = MN.LEN
      NEW.AN.LEN = AN.LEN
      NEW.INS.ADJ = MAX.RM
      NEW.EMB.ADJ = MAX.RM + MAX.ART
      NEW.HID.ADJ = MAX.RM * 2 + MAX.ART
      NEW.BURY.ADJ = MAX.RM * 3 + MAX.ART
      CLOSE 1
MAIN.MENU:
      CLS
      LOCATE 1, 32
      PRINT "     Eamon-QB     "
      LOCATE 2, 32
      PRINT " Convert Control  "
      LOCATE 3, 32
      PRINT "   Version 1.0    "
      LOCATE 5, 32
      PRINT "  by John Nelson  "
      LOCATE 10, 20
      PRINT "Select Function:"
      LOCATE 12, 20
      PRINT "  1. Change Ctrl Variable"
      LOCATE 14, 20
      PRINT "  2. Change Record Length"
      LOCATE 16, 20
      PRINT "  3. Change Maximum Nbr Rooms/Art/Eff"
      LOCATE 18, 20
      PRINT "  4. Perform All Conversions Now & Quit"
      LOCATE 20, 20
      PRINT "  5. Quit without Conversion"
      LOCATE 22, 20
      PRINT "Input Number (1-5): ";
      A$ = ""
      WHILE A$ < "1" OR A$ > "5"
        A$ = INKEY$
      WEND
      ON VAL(A$) GOTO CHANGE.VARIABLE, CHANGE.LENGTHS, CHANGE.MAXIMUMS, CONVERSION.RTN, QUIT.RTN
CHANGE.VARIABLE:
      EDIT.TYPE = 1
      GOSUB DISPLAY.CONTROL
      GOSUB EDIT.CONTROL
      VC = -1
      GOTO MAIN.MENU
CONVERT.VARIABLES:
      OPEN PATH.OUT$ + "DESC.R0" FOR OUTPUT AS #1
      WRITE #1, NEW.NR
      WRITE #1, NEW.NA
      WRITE #1, NEW.NE
      WRITE #1, NEW.NM
      WRITE #1, NEW.ND
      WRITE #1, NEW.MAX.RM
      WRITE #1, NEW.MAX.ART
      WRITE #1, NEW.MAX.EFF
      WRITE #1, NEW.RM.LEN
      WRITE #1, NEW.RMN.LEN
      WRITE #1, NEW.MON.LEN
      WRITE #1, NEW.ART.LEN
      WRITE #1, NEW.DESC.LEN
      WRITE #1, NEW.MON.FLDS
      WRITE #1, NEW.ART.FLDS
      WRITE #1, NEW.RM.FLDS
      WRITE #1, NEW.MN.LEN
      WRITE #1, NEW.AN.LEN
      CLOSE 1
      RETURN
CHANGE.LENGTHS:
      GOSUB DISPLAY.CONTROL
      EDIT.TYPE = 3
      GOSUB EDIT.CONTROL
      LC = -1
      GOTO MAIN.MENU
CONVERT.LENGTHS:  
      IF NEW.RM.LEN <> RM.LEN THEN
          GOSUB COPY.RM.FILE
      END IF
      IF NEW.RMN.LEN <> RMN.LEN THEN
          GOSUB COPY.RMNAME.FILE
      END IF
      IF NEW.MON.LEN <> MON.LEN THEN
          GOSUB COPY.MON.FILE
      END IF
      IF NEW.ART.LEN <> ART.LEN THEN
          GOSUB COPY.ART.FILE
      END IF
      IF NEW.DESC.LEN <> DESC.LEN THEN
          GOSUB COPY.DESC.FILE
      END IF
      RETURN
COPY.RM.FILE:
      OPEN PATH.IN$ + "ROOMS.TXT" FOR RANDOM AS #1 LEN = RM.LEN
      FOR D = 1 TO ND
        FIELD 1, (D - 1) * 2 AS X$, 2 AS RF.DIR$(D)
      NEXT
      OPEN PATH.OUT$ + "ROOMS.TXT" FOR RANDOM AS #2 LEN = NEW.RM.LEN
      FOR D = 1 TO ND
        FIELD 2, (D - 1) * 2 AS X$, 2 AS RFO.DIR$(D)
      NEXT
      FOR R = 1 TO NR
          GET #1, R
          FOR D = 1 TO ND
          RD%(D) = CVI(RF.DIR$(D))
          NEXT
          FOR D = 1 TO ND
          RSET RFO.DIR$(D) = MKI$(RD%(D))
          NEXT
          PUT #2, R
      NEXT
      CLOSE 1
      CLOSE 2
      RETURN
COPY.RMNAME.FILE:
      OPEN PATH.IN$ + "RMNAMES.TXT" FOR RANDOM AS #1 LEN = RMN.LEN
      FIELD 1, RMN.LEN AS RMN.NAME$
      OPEN PATH.OUT$ + "RMNAMES.TXT" FOR RANDOM AS #2 LEN = NEW.RMN.LEN
      FIELD 2, NEW.RMN.LEN AS RMNO.NAME$
      FOR R = 1 TO NR
          GET #1, R
          RM.NAME$ = RMN.NAME$
          LSET RMNO.NAME$ = RM.NAME$
          PUT #2, R
      NEXT
      CLOSE 1
      CLOSE 2
      RETURN
COPY.ART.FILE:
      OPEN PATH.IN$ + "ARTIF.TXT" FOR RANDOM AS #1 LEN = ART.LEN
      FIELD 1, AN.LEN AS AF.NAME$
      FOR X = 1 TO ART.FLDS
        FIELD 1, AN.LEN AS X$, (X - 1) * 2 AS X$, 2 AS AF.DATA$(X)
      NEXT
      OPEN PATH.OUT$ + "ARTIF.TXT" FOR RANDOM AS #2 LEN = ART.LEN
      FIELD 2, NEW.AN.LEN AS AFO.NAME$
      FOR X = 1 TO ART.FLDS
        FIELD 2, NEW.AN.LEN AS X$, (X - 1) * 2 AS X$, 2 AS AFO.DATA$(X)
      NEXT
      FOR R = 1 TO NA
          GET #1, R
          A.NAME$ = AF.NAME$
          FOR D = 1 TO ART.FLDS
            A.DATA%(D) = CVI(AF.DATA$(D))
          NEXT
          LSET AFO.NAME$ = A.NAME$
          FOR D = 1 TO ART.FLDS
            RSET AFO.DATA$(D) = MKI$(A.DATA%(D))
          NEXT
          PUT #2, R
      NEXT
      CLOSE 1
      CLOSE 2
      RETURN
COPY.MON.FILE:
      OPEN PATH.IN$ + "MONST.TXT" FOR RANDOM AS #1 LEN = MON.LEN
      FIELD 1, MN.LEN AS MF.NAME$
      FOR D = 1 TO MON.FLDS
        FIELD 1, MN.LEN AS X$, (D - 1) * 2 AS MF.DATA$(D)
      NEXT
      OPEN PATH.OUT$ + "MONST.TXT" FOR RANDOM AS #2 LEN = NEW.MON.LEN
      FIELD 2, NEW.MN.LEN AS MFO.NAME$
      FOR D = 1 TO NEW.MON.FLDS
        FIELD 2, NEW.MN.LEN AS X$, (D - 1) * 2 AS MFO.DATA$(D)
      NEXT
      FOR R = 1 TO NA
          GET #1, R
          M.NAME$ = MF.NAME$
          FOR D = 1 TO MON.FLDS
            M.DATA%(D) = CVI(MF.DATA$(D))
          NEXT
          LSET MFO.NAME$ = M.NAME$
          FOR D = 1 TO NEW.MON.FLDS
            RSET MFO.DATA$(D) = MKI$(M.DATA%(D))
          NEXT
          PUT #2, R
      NEXT
      CLOSE 1
      CLOSE 2
      RETURN
COPY.DESC.FILE:
      OPEN PATH.IN$ + "DESC.TXT" FOR RANDOM AS #1 LEN = DESC.LEN
      FIELD 1, DESC.LEN - 1 AS DF.DESC$
      OPEN PATH.OUT$ + "DESC.TXT" FOR RANDOM AS #2 LEN = NEW.DESC.LEN
      FIELD 2, NEW.DESC.LEN - 1 AS DFO.DESC$
      FOR R = 1 TO NR
          GET #1, R
          DESC$ = DF.DESC$
          LSET DFO.DESC$ = DESC$
          PUT #2, R
      NEXT
      FOR R = 1 TO NA
          GET #1, R + MAX.RM
          DESC$ = DF.DESC$
          LSET DFO.DESC$ = DESC$
          PUT #2, R + NEW.MAX.RM
      NEXT
      FOR R = 1 TO NE
          GET #1, R + MAX.RM + MAX.ART
          DESC$ = DF.DESC$
          LSET DFO.DESC$ = DESC$
          PUT #2, R + NEW.MAX.RM + NEW.MAX.ART
      NEXT
      FOR R = 1 TO NM
          GET #1, R + MAX.RM + MAX.ART + MAX.EFF
          DESC$ = DF.DESC$
          LSET DFO.DESC$ = DESC$
          PUT #2, R + NEW.MAX.RM + NEW.MAX.ART + NEW.MAX.EFF
      NEXT
      CLOSE 1
      CLOSE 2
      RETURN
CHANGE.MAXIMUMS:
      EDIT.TYPE = 2
      GOSUB DISPLAY.CONTROL
      GOSUB EDIT.CONTROL
      CM = -1
      GOTO MAIN.MENU
CONVERT.MAXIMUMS:
      GOSUB COPY.DESC.FILE
      GOSUB CHANGE.ART.RMCODES
      GOSUB CHANGE.MON.RMCODES
      RETURN
CHANGE.ART.RMCODES:
      OPEN PATH.IN$ + "ARTIF.TXT" FOR RANDOM AS #1 LEN = ART.LEN
      FIELD 1, AN.LEN AS AF.NAME$
      FOR X = 1 TO ART.FLDS
        FIELD 1, AN.LEN AS X$, (X - 1) * 2 AS X$, 2 AS AF.DATA$(X)
      NEXT
      OPEN PATH.OUT$ + "ARTIF.TXT" FOR RANDOM AS #2 LEN = ART.LEN
      FIELD 2, NEW.AN.LEN AS AFO.NAME$
      FOR X = 1 TO ART.FLDS
        FIELD 2, NEW.AN.LEN AS X$, (X - 1) * 2 AS X$, 2 AS AFO.DATA$(X)
      NEXT
      FOR R = 1 TO NA
          GET #1, R
          A.NAME$ = AF.NAME$
          FOR D = 1 TO ART.FLDS
            A.DATA%(D) = CVI(AF.DATA$(D))
          NEXT
          RMCD = FNRMCD(A.DATA%(4))
          A.DATA%(4) = FNROOM(ACT.ROOM, RMCD)
          LSET AFO.NAME$ = A.NAME$
          FOR D = 1 TO ART.FLDS
            RSET AFO.DATA$(D) = MKI$(A.DATA%(D))
          NEXT
          PUT #2, R
      NEXT
      CLOSE 1
      CLOSE 2
      RETURN
CHANGE.MON.RMCODES:
      OPEN PATH.IN$ + "MONST.TXT" FOR RANDOM AS #1 LEN = MON.LEN
      FIELD 1, MN.LEN AS MF.NAME$
      FOR X = 1 TO MON.FLDS
        FIELD 1, MN.LEN AS X$, (X - 1) * 2 AS X$, 2 AS MF.DATA$(X)
      NEXT
      OPEN PATH.OUT$ + "MONST.TXT" FOR RANDOM AS #2 LEN = MON.LEN
      FIELD 2, NEW.MN.LEN AS MFO.NAME$
      FOR X = 1 TO MON.FLDS
        FIELD 2, NEW.MN.LEN AS X$, (X - 1) * 2 AS X$, 2 AS MFO.DATA$(X)
      NEXT
      FOR R = 1 TO NM
          GET #1, R
          M.NAME$ = MF.NAME$
          FOR D = 1 TO MON.FLDS
            M.DATA%(D) = CVI(MF.DATA$(D))
          NEXT
          RMCD = FNRMCD(M.DATA%(5))
          M.DATA%(5) = FNROOM(ACT.ROOM, RMCD)
          LSET MFO.NAME$ = M.NAME$
          FOR D = 1 TO MON.FLDS
            RSET MFO.DATA$(D) = MKI$(M.DATA%(D))
          NEXT
          PUT #2, R
      NEXT
      CLOSE 1
      CLOSE 2
      RETURN
QUIT.RTN:
      CLS
      LOCATE 6, 1
      PRINT "Confirm --- Quit Without Changes (y/n) ";
      A$ = ""
      WHILE A$ <> "Y" AND A$ <> "N"
          A$ = INKEY$
          A$ = UCASE$(A$)
      WEND
      IF A$ = "Y" THEN CLOSE : END
      GOTO MAIN.MENU
CONVERSION.RTN:
      IF VC THEN GOSUB CONVERT.VARIABLES
      IF CM THEN GOSUB CONVERT.MAXIMUMS
      IF LC THEN GOSUB CONVERT.LENGTHS
      CLOSE
      END
DISPLAY.CONTROL:
      CLS
      LOCATE 4, 10: PRINT "Number of Rooms      ... "; : PRINT USING "###"; NR
      LOCATE 5, 10: PRINT "Number of Artifacts  ... "; : PRINT USING "###"; NA
      LOCATE 6, 10: PRINT "Number of Effects   .... "; : PRINT USING "###"; NE
      LOCATE 7, 10: PRINT "Number of Monsters  .... "; : PRINT USING "###"; NM
      LOCATE 9, 10: PRINT "Number of Directions ... "; : PRINT USING " ##"; ND
      LOCATE 10, 10: PRINT "Maximum Nbr Rooms    ... "; : PRINT USING "###"; MAX.RM
      LOCATE 11, 10: PRINT "Maximum Nbr Artifacts .. "; : PRINT USING "###"; MAX.ART
      LOCATE 12, 10: PRINT "Maximum Nbr Effects .... "; : PRINT USING "###"; MAX.EFF
      LOCATE 14, 10: PRINT "Rooms File Length  ..... "; : PRINT USING " ##"; RM.LEN
      LOCATE 15, 10: PRINT "Room Names Length  ..... "; : PRINT USING " ##"; RMN.LEN
      LOCATE 16, 10: PRINT "Monster File Length  ... "; : PRINT USING "###"; MON.LEN
      LOCATE 17, 10: PRINT "Artifact File Length ... "; : PRINT USING "###"; ART.LEN
      LOCATE 18, 10: PRINT "Description Length ..... "; : PRINT USING "###"; DESC.LEN
      LOCATE 19, 10: PRINT "Number of Mon Fields ... "; : PRINT USING "###"; MON.FLDS
      LOCATE 20, 10: PRINT "Number of Art Fields ... "; : PRINT USING "###"; ART.FLDS
      LOCATE 21, 10: PRINT "Number of Room Fields .. "; : PRINT USING "###"; ART.FLDS
      LOCATE 22, 10: PRINT "Monster Name Length .... "; : PRINT USING "###"; MN.LEN
      LOCATE 23, 10: PRINT "Artifact Name Length ... "; : PRINT USING "###"; AN.LEN
      RETURN
PRESS.ANY.KEY:
      ESC = 0
      A$ = ""
      WHILE A$ = ""
        A$ = INKEY$
        IF A$ = CHR$(27) THEN ESC = -1
      WEND
      RETURN
EDIT.CONTROL:
      IF EDIT.TYPE = 2 GOTO EDIT.MAXIMUMS
      IF EDIT.TYPE = 3 GOTO EDIT.LENGTHS
      LOCATE 1, 1
EDIT.NR:
      ESC = 0
      LOCATE 4, 35
      FMT$ = "I3"
      DF = NR
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      NEW.NR = I.NUM
EDIT.NA:
      LOCATE 5, 35
      FMT$ = "I3"
      DF = NA
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      NEW.NA = I.NUM
EDIT.NE:
      LOCATE 6, 35
      FMT$ = "I3"
      DF = NE
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      NEW.NE = I.NUM
EDIT.NM:
      LOCATE 7, 35
      FMT$ = "I3"
      DF = NM
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      NEW.NM = I.NUM
EDIT.ND:
      LOCATE 9, 35
      FMT$ = "I3"
      DF = ND
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM <> 6 AND I.NUM <> 10 THEN GOTO EDIT.ND
      NEW.ND = I.NUM
      GOTO EDIT.MON.FLDS
EDIT.MAXIMUMS:
EDIT.MAX.RM:
      LOCATE 10, 35
      FMT$ = "I3"
      DF = MAX.RM
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 50 OR I.NUM > 400 THEN BEEP: GOTO EDIT.MAX.RM
      NEW.MAX.RM = I.NUM
EDIT.MAX.ART:
      LOCATE 11, 35
      FMT$ = "I3"
      DF = MAX.ART
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 50 OR I.NUM > 400 THEN BEEP: GOTO EDIT.MAX.ART
      NEW.MAX.ART = I.NUM
EDIT.MAX.EFF:
      LOCATE 12, 35
      FMT$ = "I3"
      DF = MAX.EFF
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 50 OR I.NUM > 400 THEN BEEP: GOTO EDIT.MAX.EFF
      NEW.MAX.EFF = I.NUM
      NEW.INS.ADJ = NEW.MAX.RM
      NEW.EMB.ADJ = NEW.MAX.RM + NEW.MAX.ART
      NEW.HID.ADJ = NEW.MAX.RM + NEW.MAX.ART * 2
      NEW.BURY.ADJ = NEW.MAX.RM + NEW.MAX.ART * 3
      RETURN
EDIT.LENGTHS:
EDIT.RM.LEN:
      LOCATE 14, 35
      FMT$ = "I3"
      DF = RM.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 12 OR I.NUM > 128 THEN BEEP: GOTO EDIT.RM.LEN
      NEW.RM.LEN = I.NUM
EDIT.RMN.LEN:
      LOCATE 15, 35
      FMT$ = "I3"
      DF = RMN.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 36 OR I.NUM > 256 THEN BEEP: GOTO EDIT.RMN.LEN
      NEW.RMN.LEN = I.NUM
EDIT.MON.LEN:
      LOCATE 16, 35
      FMT$ = "I3"
      DF = MON.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 32 OR I.NUM > 256 THEN BEEP: GOTO EDIT.ART.LEN
      NEW.MON.LEN = I.NUM
EDIT.ART.LEN:
      LOCATE 17, 35
      FMT$ = "I3"
      DF = ART.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 36 OR I.NUM > 256 THEN BEEP: GOTO EDIT.ART.LEN
      NEW.ART.LEN = I.NUM
EDIT.DESC.LEN:
      LOCATE 18, 35
      FMT$ = "I3"
      DF = DESC.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 160 OR I.NUM > 1024 THEN PRINT CHR$(7): GOTO EDIT.DESC.LEN
      NEW.DESC.LEN = I.NUM
      GOTO EDIT.MN.LEN
EDIT.MON.FLDS:
      LOCATE 19, 35
      FMT$ = "I3"
      DF = MON.FLDS
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 12 OR I.NUM > 36 THEN PRINT CHR$(7): GOTO EDIT.MON.FLDS
      NEW.MON.FLDS = I.NUM
EDIT.ART.FLDS:
      LOCATE 20, 35
      FMT$ = "I3"
      DF = ART.FLDS
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 8 OR I.NUM > 12 THEN PRINT CHR$(7): GOTO EDIT.ART.FLDS
      NEW.ART.FLDS = I.NUM
EDIT.RM.FLDS:
      LOCATE 21, 35
      FMT$ = "I3"
      DF = RM.FLDS
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < ND OR I.NUM > ND + 4 THEN PRINT CHR$(7): GOTO EDIT.RM.FLDS
      NEW.RM.FLDS = I.NUM
      RETURN
EDIT.MN.LEN:
      LOCATE 22, 35
      FMT$ = "I3"
      DF = MN.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 20 OR I.NUM > 64 THEN PRINT CHR$(7): GOTO EDIT.MN.LEN
      NEW.MN.LEN = I.NUM
EDIT.AN.LEN:
      LOCATE 23, 35
      FMT$ = "I3"
      DF = AN.LEN
      GOSUB GET.NUMBER
      IF ESC THEN GOTO FORGET.IT
      IF I.NUM < 20 OR I.NUM > 64 THEN PRINT CHR$(7): GOTO EDIT.AN.LEN
      NEW.AN.LEN = I.NUM
      RETURN
SET.CONTROLS:
      NR = NEW.NR
      NA = NEW.NA
      NE = NEW.NE
      NM = NEW.NM
      ND = NEW.ND
      MAX.RM = NEW.MAX.RM
      MAX.ART = NEW.MAX.ART
      MAX.EFF = NEW.MAX.EFF
      RM.LEN = NEW.RM.LEN
      RMN.LEN = NEW.RMN.LEN
      MON.LEN = NEW.MON.LEN
      ART.LEN = NEW.ART.LEN
      DESC.LEN = NEW.DESC.LEN
      GOTO DISPLAY.CONTROL
FORGET.IT:
      CLOSE
      END
GET.NUMBER:   ' Numeric I/O
      I.L% = VAL(MID$(FMT$, 2))
      I.U$ = RIGHT$("###,###,###,###", I.L% + INT((I.L% - 1) / 3))
      I$ = ""
      V% = CSRLIN
      H% = POS(1)
NIO.1:
      LOCATE V%, H%
      IF I$ <> "" THEN
          PRINT USING I.U$; VAL(I$);
      ELSE
          PRINT USING I.U$; DF;
      END IF
NIO.2:
      LOCATE V%, H% + LEN(I.U$) - 1:
      GOSUB GET.BYTE:
      IF A$ = CHR$(13) THEN GOTO NIO.RETURN
      IF A$ = CHR$(27) THEN ESC = -1: GOTO NIO.RETURN2
      IF A$ = CHR$(8) AND LEN(I$) > 0 THEN I$ = LEFT$(I$, LEN(I$) - 1): GOTO NIO.1
      IF A$ = CHR$(8) AND I$ = "" THEN BK = -1: GOTO NIO.RETURN2
      IF A$ = "-" AND LEFT$(I$, 1) <> "-" THEN I$ = "-" + I$: GOTO NIO.1
      IF A$ = "-" THEN I$ = MID$(I$, 2): GOTO NIO.1
      IF A$ >= "0" AND A$ <= "9" AND LEN(I$) < I.L% THEN I$ = I$ + A$: GOTO NIO.1
      PRINT CHR$(7);
      GOTO NIO.2
NIO.RETURN:
      IF I$ = "" THEN I$ = STR$(DF)
      I.NUM = VAL(I$)
      BK = 0
NIO.RETURN2:
      LOCATE , , 0: RETURN
GET.BYTE:  ' get a keystroke & convert to std 1 byte code
      LOCATE , , 1
      A$ = ""
      WHILE A$ = ""
        A$ = INKEY$
      WEND
      IF A$ = CHR$(127) THEN A$ = CHR$(8)
      IF A$ = CHR$(0) + CHR$(75) THEN A$ = CHR$(8)
      IF A$ = CHR$(0) + CHR$(77) THEN A$ = CHR$(21)
      A$ = LEFT$(A$, 1)
      IF CAPS THEN LOCATE , , 0: RETURN
      IF A$ >= "a" THEN A$ = CHR$(ASC(A$) - 32)
      LOCATE , , 0
      RETURN

