	'
	'                   AUTOEXT program
	'
	'        *** Automatic Extract of Apple Image ***
	'                  Eamon Adventures
	'
	'                   by John Nelson
	'
	'    This program auto extracts the adventure files from an
	'    Apple image disk format by shelling to the READDISK program
	'    and ASEXTRCT program written by Paul Gilbert.
	'    You will need to make sure you have the READDISK pgm and
	'    the ASEXTRCT programs in the Eamon\Util directory to use this.
	'
	'  Requirements:
	'     READDISK.EXE - a program by Paul Gilbert in execution path
	'     ASEXTRCT.EXE - a program by Paul Gilbert in execution path
	'     PKZIP.EXE - to archive the files after conversion.
	'
	DECLARE SUB GetYN (N!)
	DECLARE FUNCTION Capitalize$ (A$)
	CLS
	PRINT SPC(25); "Eamon Image Conversion Utility"
	PRINT SPC(33); "by John Nelson"
	LOCATE 6, 4
	PRINT "Adventure #";
	INPUT "", AdvNo$
	Dirnm$ = "ADV" + "#"+ RIGHT$("000" + AdvNo$, 3)
	LOCATE 8, 4
	PRINT "Extract files from Image? (Y/N) ";
	GetYN YN
   '     YN = 1
	Extracting = YN
	LOCATE 10, 4
	PRINT "Convert All Files? (Y/N)";
	GetYN YN
	AllFlag = YN
	CHDIR Dirnm$
	IF AllFlag THEN
	    BuildingName = YN
	    AFlag = YN
	    MFlag = YN
	    DFlag = YN
	    RFlag = YN
	    RNFlag = YN
	    PFlag = YN
	    GOTO SkipQuest
	END IF
	LOCATE 12, 4
	PRINT "Build Eamon.Nam File? (Y/N) ";
	GetYN YN
	BuildingName = YN
	LOCATE 14, 4
	PRINT "Convert Artifacts? (Y/N) ";
	GetYN YN
	AFlag = YN
	LOCATE 16, 4
	PRINT "Convert Monsters? (Y/N) ";
	GetYN YN
	MFlag = YN
	LOCATE 18, 4
	PRINT "Convert Descriptions? (Y/N) ";
	GetYN YN
	DFlag = YN
	LOCATE 20, 4
	PRINT "Convert Rooms? (Y/N) ";
	GetYN YN
	RFlag = YN
	LOCATE 22, 4
	PRINT "Convert Room Names? (Y/N) ";
	GetYN YN
	RNFlag = YN
	PRINT "Convert Programs? (Y/N) ";
	GetYN YN
	PFlag = YN
SkipQuest:
	IF BuildingName THEN
	    CLS
	    INPUT "Short Pgm Name:", Short$
	    IF LEN(Short$) > 8 OR INSTR(Short$, " ") THEN BEEP: GOTO SkipQuest
	    INPUT "Adventure Name:", AdvNam$
	    OPEN "EAMON.NAM" FOR OUTPUT AS #1
	    PRINT #1, Short$
	    PRINT #1, AdvNam$
	    CLOSE 1
	END IF
	DIM RC%(4), PP%(250)    '  RC%() = rec counter, PP%() = period position
	DIM MFF$(12)
	DIM AFF$(8)
	DIM RF$(10), RD%(10), F%(30)
	'   get the name of the image file (begins with 'ED' & ends with .DSK)
	SHELL "DIR ED*.DSK >FILNM.TMP"
	OPEN "FILNM.TMP" FOR INPUT AS #1
	DO
	    LINE INPUT #1, F$
	LOOP UNTIL LEFT$(F$, 2) = "ED"
	CLOSE 1
	filenam$ = LEFT$(F$, INSTR(F$, " ") - 1) + ".DSK"
	' okay - we got the image file name - now get the Apple directory
	'   from the image file...
	IF Extracting THEN
	    SHELL "READDISK " + filenam$ + " >APPDIR.TMP"
	END IF
    '   Now read through the directory of the Apple disk to get file numbers
	OPEN "APPDIR.TMP" FOR INPUT AS #1
	WHILE NOT EOF(1)
	    LINE INPUT #1, APPDLIN$
	    GOSUB ProcessLine
	WEND
	CLOSE 1
	'  Done getting the file numbers...
	'  Now extract the files we need...
	IF AFNO > 0 AND AFlag THEN
	    IF Extracting THEN
		SHELL "READDISK 1 " + filenam$ + STR$(AFNO) + " ARTIF.BIN"
	    END IF
	    GOSUB ConvertArtifacts
	END IF
	IF MFNO > 0 AND MFlag THEN
	    IF Extracting THEN
		SHELL "READDISK 1 " + filenam$ + STR$(MFNO) + " MONST.BIN"
	    END IF
	    GOSUB ConvertMonsters
	END IF
	IF RFNO > 0 AND RFlag THEN
	    IF Extracting THEN
		SHELL "READDISK 1 " + filenam$ + STR$(RFNO) + " ROOMS.BIN"
	    END IF
	    GOSUB ConvertRooms
	END IF
	IF RNNO > 0 AND RNFlag THEN
	    IF Extracting THEN
		SHELL "READDISK 1 " + filenam$ + STR$(RNNO) + " RMNAMES.BIN"
	    END IF
	    GOSUB ConvertRmnames
	END IF
	IF DFNO > 0 AND DFlag THEN
	    IF Extracting THEN
		SHELL "READDISK 1 " + filenam$ + STR$(DFNO) + " DESC.BIN"
	    END IF
	    GOSUB ConvertDescript
	END IF
	IF PRGNO > 0 AND PFlag THEN
	    IF Extracting THEN
		SHELL "READDISK 2 " + filenam$ + STR$(PRGNO) + " MAINPGM.ASB"
	    END IF
	    SHELL "ASEXTRCT MAINPGM.ASB >MAINPGMA.BAS"
	END IF
	IF LPPRGNO > 0 AND PFlag THEN
	    IF Extracting THEN
		SHELL "READDISK 2 " + filenam$ + STR$(LPPRGNO) + " LEADIN.ASB"
	    END IF
	    SHELL "ASEXTRCT LEADIN.ASB >" + Short$ + ".BAS"
	END IF
	SHELL "PKZIP " + "ADV" + AdvNo$ + " *.BIN"
	SHELL "PKZIP " + "ADV" + AdvNo$ + " *.ASB -a"
	SHELL "PKZIP " + "ADV" + AdvNo$ + " APPDIR -a"
	SHELL "PKZIP " + "ADV" + AdvNo$ + " *.TMP -a"
	SHELL "PKZIP " + "ADV" + AdvNo$ + " *.DSK -a"
	SHELL "DEL *.BIN"
	SHELL "DEL *.ASB"
	SHELL "DEL *.TMP"
	SHELL "COPY \EAMON\DDD\MAINPGM.BAS"
	SHELL "MOVE ADV" + AdvNo$ + ".ZIP \Eamon\Archive"
	CHDIR ".."
	END
ProcessLine:
	FILNO = VAL(APPDLIN$)
	IF FILNO = 0 THEN RETURN
	LPPGM$ = LTRIM$(RTRIM$(MID$(APPDLIN$, 3)))
	IF INSTR(LPPGM$, UCASE$(AdvNam$)) > 0 THEN
	    LPPRGNO = FILNO
	    RETURN
	END IF
	MP = INSTR(APPDLIN$, "MAIN PGM")
	IF MP > 0 THEN
		PRGNO = FILNO
		RETURN
	END IF
	AF = INSTR(APPDLIN$, " EAMON.")
	IF AF = 0 THEN RETURN
	FILNM$ = MID$(APPDLIN$, AF + 7)
	IF LEFT$(FILNM$, 3) = "ART" THEN
		AFNO = FILNO
	END IF
	IF LEFT$(FILNM$, 3) = "MON" THEN
		MFNO = FILNO
	END IF
	IF LEFT$(FILNM$, 5) = "ROOMS" THEN
		RFNO = FILNO
	END IF
	IF LEFT$(FILNM$, 6) = "ROOM N" THEN
		RNNO = FILNO
	END IF
	IF LEFT$(FILNM$, 4) = "DESC" THEN
		DFNO = FILNO
	END IF
	IF LEFT$(FILNM$, 4) = "NAME" THEN
		AVNO = FILNO
	END IF
	RETURN
ConvertMonsters:
	' Convert Monsters files from Native Apple format
	'     to Eamon QB format for PC version of Eamon
	IF MFlag = 0 THEN RETURN
	OPEN "MONST.BIN" FOR RANDOM AS #1 LEN = 128
	FIELD #1, 128 AS Rec$
	NM = LOF(1) \ 128
	MaxAN = 0
	FOR A = 1 TO NA
	    GET #1, A + 1
	    P = 1
	    DO UNTIL MID$(Rec$, P, 1) = CHR$(13) OR MID$(Rec$, P, 1) = CHR$(0)
		P = P + 1
	    LOOP
	    IF P > MaxAN THEN MaxAN = P
	NEXT
	MNLen = MaxAN
	IF MNLen < 20 THEN MNLen = 20
	OPEN "MONST.TXT" FOR RANDOM AS #2 LEN = 128
	FIELD 2, MNLen AS MFNam$
	FOR X = 1 TO 12
	FIELD 2, MNLen AS X$, (X - 1) * 2 AS Y$, 2 AS MFF$(X)
	NEXT
	FIELD 2, 128 AS MFFILL$
	FOR M = 1 TO NM
	GET #1, M + 1
	    M$ = ""
	    P = 1
	    DO UNTIL MID$(Rec$, P, 1) = CHR$(13) OR MID$(Rec$, P, 1) = CHR$(0)
		M$ = M$ + MID$(Rec$, P, 1)
		P = P + 1
	    LOOP
	    FOR Fld = 1 TO 12
		F$ = ""
		P = P + 1
		DO UNTIL MID$(Rec$, P, 1) = CHR$(13) OR MID$(Rec$, P, 1) = CHR$(0)
		     F$ = F$ + MID$(Rec$, P, 1)
		     P = P + 1
		LOOP
		F%(Fld) = VAL(F$)
	    NEXT
	    LSET MFFILL$ = SPACE$(128)
	    LSET MFNam$ = Capitalize$(M$)
	    FOR Fld = 1 TO 12
		RSET MFF$(Fld) = MKI$(F%(Fld))
	    NEXT
	    PUT #2, M
	NEXT
	CLOSE
	RETURN
ConvertArtifacts:
	'    Convert Eamon Artifacts from Apple Iie native format
	'    to IBM-PC format
	'
	'          by John Nelson
	'
	IF AFlag = 0 THEN RETURN
	OPEN "ARTIF.BIN" FOR RANDOM AS #1 LEN = 128
	FIELD #1, 128 AS Rec$
	NA = LOF(1) \ 128
	MaxAN = 0
	FOR A = 1 TO NA
	    GET #1, A + 1
	    P = 1
	    DO UNTIL MID$(Rec$, P, 1) = CHR$(13) OR MID$(Rec$, P, 1) = CHR$(0)
		P = P + 1
	    LOOP
	    IF P > MaxAN THEN MaxAN = P
	NEXT
	ANLen = MaxAN
	IF ANLen < 20 THEN ANLen = 20
	OPEN "ARTIF.TXT" FOR RANDOM AS #2 LEN = 128
	FIELD 2, ANLen AS AFNam$
	FOR X = 1 TO 8
	FIELD 2, ANLen AS X$, (X - 1) * 2 AS Y$, 2 AS AFF$(X)
	NEXT
	FIELD 2, 128 AS AFFILL$
	FOR A = 1 TO NA
	GET #1, A + 1
	    LSET AFFILL$ = SPACE$(128)
	    A$ = ""
	    P = 1
	    DO UNTIL MID$(Rec$, P, 1) = CHR$(13) OR MID$(Rec$, P, 1) = CHR$(0)
		A$ = A$ + MID$(Rec$, P, 1)
		P = P + 1
	    LOOP
	    FOR Fld = 1 TO 8
		F$ = ""
		F%(Fld) = 0
		P = P + 1
		DO UNTIL MID$(Rec$, P, 1) = CHR$(13) OR MID$(Rec$, P, 1) = CHR$(0)
		     F$ = F$ + MID$(Rec$, P, 1)
		     P = P + 1
		LOOP
		F%(Fld) = VAL(F$)
	    NEXT
	    LSET AFNam$ = LCASE$(A$)
	    FOR Fld = 1 TO 8
		RSET AFF$(Fld) = MKI$(F%(Fld))
	    NEXT
	    PUT #2, A
	NEXT
	CLOSE
	RETURN
ConvertDescript:
	' Convert Description File from Native Apple format
	'     to Eamon QB format for PC version of Eamon
	'
	IF DFlag = 0 THEN RETURN
	OPEN "DESC.BIN" FOR RANDOM AS #1 LEN = 256
	FIELD #1, 256 AS Desc$
	OPEN "DESC.TXT" FOR RANDOM AS #2 LEN = 256
	FIELD 2, 256 AS DFDesc$
	P = 0
	GET #1, 1
	' ---- First get the record counters from record zero
	FOR RC = 1 TO 4
	    F$ = ""
	    P = P + 1
	    DO UNTIL MID$(Desc$, P, 1) = CHR$(13) OR MID$(Desc$, P, 1) = CHR$(0)
		 F$ = F$ + MID$(Desc$, P, 1)
		 P = P + 1
	    LOOP
	    RC%(RC) = VAL(LTRIM$(RTRIM$(F$)))
	NEXT
	OPEN "DESC.R0" FOR OUTPUT AS #4
	FOR X = 1 TO 4
	PRINT #4, RC%(X)
	NEXT
	PRINT #4, 6
	PRINT #4, 100
	PRINT #4, 100
	PRINT #4, 100
	PRINT #4, 100
	PRINT #4, 64
	PRINT #4, 64
	PRINT #4, 128
	PRINT #4, 128
	PRINT #4, 256
	PRINT #4, 12
	PRINT #4, 8
	PRINT #4, 0
	PRINT #4, MNLen
	PRINT #4, ANLen
	CLOSE 4
	' ------------- Now read the descriptions -----------
	FOR RT = 1 TO 4      ' For each of the four types of descriptions
	  FOR M = 1 TO RC%(RT)       '  For number number of each type
	  R = M + (RT - 1) * 100     ' calculate record number
	  GET #1, R + 1              '  read the record
	  P = 0           ' position in string
	  S = 0           ' sentence counter
	    ' --- now pull the description out, finding sentences along the way
	    M$ = ""
	    P = 1
	    DO UNTIL MID$(Desc$, P, 1) = CHR$(13)
		P = P + 1
		IF MID$(Desc$, P, 1) = "." THEN S = S + 1: PP%(S) = P
		IF MID$(Desc$, P, 1) = "!" THEN S = S + 1: PP%(S) = P
		IF MID$(Desc$, P, 1) = "?" THEN S = S + 1: PP%(S) = P
	    LOOP
	    M$ = LCASE$(LEFT$(Desc$, P - 1))
	    NS = S
	    GOSUB FixCapitaliz
	    '  Fix upper / lowercase here...
	    IF LEN(M$) > 0 THEN MID$(M$, 1, 1) = UCASE$(MID$(M$, 1, 1))
	    LSET DFDesc$ = M$
	    PUT #2, R
	  NEXT
	NEXT
	CLOSE
	RETURN
FixCapitaliz:
	IF LEFT$(M$, 1) = CHR$(34) THEN M$ = MID$(M$, 2)
	IF RIGHT$(M$, 1) = CHR$(34) THEN M$ = LEFT$(M$, LEN(M$) - 1)
	P = 1
	S = 0
	DO
	    IF MID$(M$, P, 1) >= "a" AND MID$(M$, P, 1) <= "z" THEN
		MID$(M$, P, 1) = UCASE$(MID$(M$, P, 1))
		S = S + 1
		IF S > NS THEN EXIT DO
		P = PP%(S)
	    END IF
	    P = P + 1
	LOOP UNTIL P > LEN(M$)
	RETURN
ConvertRooms:
	'    Convert Rooms File from Apple IIe native format
	'    to IBM-PC format
	IF RFlag = 0 THEN RETURN
	OPEN "ROOMS.BIN" FOR RANDOM AS #1 LEN = 64
	FIELD #1, 64 AS Rec$
	NR = LOF(1) \ 64
	OPEN "ROOMS.TXT" FOR RANDOM AS #2 LEN = 64
	FOR X = 1 TO 10
	FIELD 2, (X - 1) * 2 AS X$, 2 AS RFDir$(X)
	NEXT
	FOR A = 1 TO NR
	    GET #1, A + 1
	    D = 0
	    P = 1
	    DO
	      F$ = ""
	      DO UNTIL MID$(Rec$, P, 1) = CHR$(13) OR MID$(Rec$, P, 1) = CHR$(0)
		     F$ = F$ + MID$(Rec$, P, 1)
		     P = P + 1
	      LOOP
	      IF MID$(Rec$, P, 1) = CHR$(0) THEN EXIT DO
	      D = D + 1
	      IF D <= 10 THEN RD%(D) = VAL(F$)
	      ' PRINT RD%(D); " ";
	      P = P + 1
	    LOOP
	    ND = D
	    IF ND > 10 THEN ND = 10
	    FOR Fld = 1 TO 10
		RSET RFDir$(Fld) = MKI$(RD%(Fld))
		RD%(Fld) = 0
	    NEXT
	    PUT #2, A
	NEXT
	CLOSE
	RETURN
ConvertRmnames:
	' Convert Room Names File from Native Apple format
	'     to Eamon QB format for PC version of Eamon
	IF RNFlag = 0 THEN RETURN
	OPEN "RMNAMES.BIN" FOR RANDOM AS #1 LEN = 64
	FIELD #1, 64 AS Rmnm$
	NR = LOF(1) \ 64
	OPEN "RMNAMES.TXT" FOR RANDOM AS #2 LEN = 64
	FIELD 2, 64 AS DFDesc$
	FOR M = 1 TO NR
	  GET #1, M + 1
	  P = 1
	  DO UNTIL MID$(Rmnm$, P, 1) = CHR$(13) OR MID$(Rmnm$, P, 1) = CHR$(0)
	      P = P + 1
	  LOOP
	  RMN$ = RTRIM$(LCASE$(LEFT$(Rmnm$, P - 1)))
	  IF LEFT$(RMN$, 1) = CHR$(34) THEN RMN$ = MID$(RMN$, 2)
	  IF RIGHT$(RTRIM$(RMN$), 1) = CHR$(34) THEN RMN$ = LEFT$(RMN$, LEN(RMN$) - 1)
	  LSET DFDesc$ = RMN$
	  PUT #2, M
	NEXT
	CLOSE
	RETURN

FUNCTION Capitalize$ (A$)
	IF LEFT$(A$, 1) = CHR$(34) THEN A$ = MID$(A$, 2)
	IF RIGHT$(A$, 1) = CHR$(34) THEN A$ = LEFT$(A$, LEN(A$) - 1)
	A$ = UCASE$(LEFT$(A$, 1)) + LCASE$(MID$(A$, 2))
	S = INSTR(A$, " ")
	WHILE S > 0
	    A$ = LEFT$(A$, S - 1) + UCASE$(MID$(A$, S, 2)) + MID$(A$, S + 2)
	    S = S + 1
	    S = INSTR(S, A$, " ")
	WEND
	Capitalize$ = A$
END FUNCTION

SUB GetYN (N)
	DO
	    A$ = INPUT$(1)
	LOOP WHILE UCASE$(A$) <> "Y" AND UCASE$(A$) <> "N"
	PRINT A$
	N = (UCASE$(A$) = "Y")

END SUB

