  '
  '                    Eamon Tour Program
  '
  '            This program allows you to walk into a Dungeon
  '            Scenario and look around.  You can add artifacts
  '            and monsters as you go.
  '
  '                      by John Nelson
  '
  '
    ' ͻ
    '                 National Eamon User's Club                    
    '                   Log of Program Changes                      
    '                                         
    '                                                               
    '    Date     Version      Description of Change                
    '  --------   -------     ------------------------------------- 
    '  01/22/2000   1.00      New Program Written                   
    ' ͼ
    DEFINT A-Z
    DECLARE SUB PGPRT (SP, LIT$)
    REM $INCLUDE: '\EAMON\COPY\COLORRTN.BAS'
    CLS
    OPEN "DESC.R0" FOR INPUT AS #1
    INPUT #1, NR, NZ, NE, NM
    INPUT #1, ND
    INPUT #1, MAX.RM
    INPUT #1, MAX.ART
    INPUT #1, MAX.EFF
    INPUT #1, MAX.MON
    INPUT #1, RM.LEN
    INPUT #1, RMN.LEN
    INPUT #1, MON.LEN
    INPUT #1, ART.LEN
    INPUT #1, DESC.LEN
    CLOSE
    ART.ADJ = MAX.RM
    EFF.ADJ = MAX.RM + MAX.ART
    MON.ADJ = MAX.RM + MAX.ART + MAX.EFF
    EMB.ADJ = MAX.RM + MAX.ART
    INS.ADJ = MAX.RM
    HID.ADJ = MAX.RM + MAX.ART
    BURY.ADJ = MAX.RM * 2 + MAX.ART
    NA = NZ
    DIM AN$(NA + 6), AD%(NA + 6, 9)
    DIM MN$(NM), MD%(NM, 16)
    GOSUB READ.ARTIFACTS ' LOAD ARTIFACT TABLE
    GOSUB READ.MONSTERS ' LOAD MONSTER TABLE
    READ NC
    DIM C$(NC)
    FOR C = 1 TO NC
	READ C$(C)
    NEXT
    R2 = 1
    GOTO INITIALIZE
DONT.UNDERSTAND:
    PGPRT 2, "I don't understand."
    GOTO MAIN.LOOP
ArentCarrying:
     PGPRT "You aren't carrying it.": GOTO MAIN.LOOP
MustOpen:    
     PGPRT 2, "You must first open it.": GOTO MAIN.LOOP
CantDo:
     PGPRT 2, "You can't " + C$(C) + " " + LCASE$(S$): GOTO MAIN.LOOP
Nobody:
     PGPRT 2, "Nobody here by that name!": GOTO MAIN.LOOP
' ---------------------------------------------------------------------------
MAIN.LOOP:
'    = MAIN =
     IF V%(Room) = 0 THEN
	GET #2, Room
	A$ = RTRIM$(DESC$)
	PGPRT 2, A$
     ELSE
	 GET #3, Room
	 A$ = RTRIM$(RN$)
	 PGPRT 2, "You are " + A$
     END IF
     FOR M = 1 TO NM
     IF MD%(M, 5) = Room THEN
	 IF MD%(M, 15) = 1 THEN
	     PGPRT 2, MN$(M) + " is here."
	 ELSE
	     GET #2, M + MON.ADJ
	     A$ = RTRIM$(DESC$)
	     PGPRT 2, A$
	     MD%(M, 15) = 1
	 END IF
     END IF
     NEXT
     FOR A = 1 TO NZ
	 IF AD%(A, 4) = Room THEN
	     IF AD%(A, 9) THEN
		 PGPRT 2, "You see " + AN$(A) + "."
	     ELSE
		 GET #2, A + ART.ADJ
		 A$ = RTRIM$(DESC$)
		 PGPRT 2, A$
		 AD%(A, 9) = 1
	     END IF
	 END IF
     NEXT
     PRINT
GET.COMMAND:      ' GET.COMMAND
     PGPRT 0, ""
     PRINT
     COLOR hfg%, hbg%
     PRINT "  Your Command ";
     COLOR fgc%, bgc%
     LINE INPUT " ", A$
     A$ = LTRIM$(RTRIM$(UCASE$(A$)))
     IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 17: PRINT A$
     IF A$ = "" THEN GOTO LIST.COMMANDS
     CZ$ = A$
     A = INSTR(A$, " ")
     IF A = 0 THEN
	 A = LEN(A$) + 1
     ELSE
	 V$ = LEFT$(A$, A - 1)
	 S$ = MID$(A$, A + 1)
	 S$ = LTRIM$(S$)
     END IF
     C = 0
     FOR A = 1 TO ND
     IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN C = A: A = ND
     NEXT
     IF C <> 0 THEN GOTO BRANCH.RTN
     F = 0
     FOR A = ND + 1 TO NC
	 IF UCASE$(C$(A)) = V$ THEN C = A: A = NC
	 IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN
	     F = F + 1
	     C = A
	     IF F > 1 THEN C = 0: A = NC
	 END IF
     NEXT
     IF C = 0 THEN GOTO LIST.COMMANDS
     GOTO BRANCH.RTN
LIST.COMMANDS:      ' LIST.COMMANDS
     PRINT
     PRINT "Huh? I only understand these commands ... "
     FOR C = 1 TO NC
	 IF C < ND OR C > 10 THEN PRINT C$(C); SPC(20 - LEN(C$(C)));
     NEXT
     PRINT
     GOTO GET.COMMAND
BRANCH.RTN:      ' BRANCH.RTN
     ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
     ON C - 5 GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, GET.RTN, Make.RTN
     ON C - 12 GOTO DROP.RTN, INVENTORY.RTN, SMILE.RTN, CREATE.RTN
     ON C - 16 GOTO READ.RTN, OPEN.RTN, QUIT.RTN
Get.Back:      ' GET.BACK
    GOTO MAIN.LOOP
' ---------------------------------------------------------------------------
INITIALIZE:
    MN$(0) = "You"
    MastPath$ = "\Eamon"
    GOSUB OPEN.DESC
    GOSUB OPEN.RMNAMES
    GOSUB OPEN.ROOMS
    Room = 1
    GOTO Move.it
    DATA 19
    DATA North,South,East,West,Up,Down,NE,NW,SE,SW
    DATA Get,Make,Drop
    DATA Inventory,Smile,Create
    DATA Read,Open,Quit
' ---------------------------------------------------------------------------
Game.Over:      ' GAME.OVER
    PRINT
    PRINT "(Press any key to continue) ";
    A$ = INPUT$(1)
    PRINT
    CLOSE
    TP = 0
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN
	IF AD%(A, 2) <> 0 THEN AD%(A, 1) = AD%(A, 1) * CH / 10
	TP = TP + AD%(A, 1)
    END IF
    NEXT
    PRINT TP; " gold pieces."
    PRINT
    PRINT
    PRINT "(Press any key to continue)  ";
    A$ = INPUT$(1)
    PRINT
    END
' --------------------------------------------------------------------------
MOVE.RTN:
    D = C
    R2 = RD%(D)
    IF R2 > MAX.RM AND R2 < EFF.ADJ THEN GOTO PASSAGE.BLOCKED
CHK.SPECIAL.MOVES:      ' CHK.SPECIAL.MOVES
    IF R2 > 0 AND R2 <= NR THEN GOTO Move.it
'     /// SPECIAL MOVES
    IF R2 = -99 THEN PGPRT 2, "You successfully ride off into the sunset.": GOTO Game.Over
    IF R2 = 0 THEN GOTO CANT.GO
'    /// INSERT HERE SPECIAL ROOM MOVE CHECKING
    IF AD%(3, 4) = Room THEN R2 = -R2: GOTO Move.it
    GOTO CANT.GO
PASSAGE.BLOCKED:
    GT = R2 - MAX.RM
    IF AD%(GT, 4) <> Room THEN R2 = AD%(GT, 5): GOTO CHK.SPECIAL.MOVES
    PGPRT 2, "The " + AN$(GT) + " blocks the way!"
    GOTO MAIN.LOOP
CANT.GO:
    PGPRT 2, "You can't go that way!"
    V%(Room) = 0
    GOTO MAIN.LOOP
Move.it:
    R3 = Room
    Room = R2
    GOSUB CHK.REACTIONS
    GOSUB Read.Room
    LT = -1
    GOTO END.LOOP
CHK.REACTIONS:
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room THEN
	IF MD%(M, 14) = 0
	    FR = MD%(M, 3)
	    IF FR > 0 AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
	    MD%(M, 14) = 1
	    IF FR > (100 * RND(1)) THEN
		MD%(M, 14) = 2
		IF FR > (100 * RND(1)) THEN MD%(M, 14) = 3
	    END IF
	END IF
    END IF
    NEXT
    RETURN
' --------------------------------------------------------------------------
GET.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO GET.ALL
    IF S$ = "TORCH" THEN PGPRT 2, "All torches are bolted to the wall and cannot be removed.": GOTO Get.Back
    EMB = Room + EMB.ADJ
    WH = Room
    HA = Room
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "I see no " + LCASE$(S$) + " here!": GOTO MAIN.LOOP
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO MAIN.LOOP
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, "You can't budge it!": GOTO MAIN.LOOP
    PGPRT 2, "Got it."
    AD%(A, 4) = -1
    GOTO Get.Back
GET.ALL:      ' GET.ALL
    FOR A = 1 TO NA
    IF AD%(A, 4) = Room THEN
	PGPRT 1, AN$(A) + " taken."
	AD%(A, 4) = -1
    END IF
    NEXT
    GOTO Get.Back
SPECIAL.ROOM.CHK:      ' SPECIAL.ROOM.CHK
    GET #2, Room
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    RETURN
' ---------------------------------------------------------------------------
MONSTER.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NM
    IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = WH OR MD%(X, 5) = HA) THEN FOUND = FOUND + 1: M = X: IF S$ = MN$(X) THEN X = 9999
    NEXT
    RETURN
' ---------------------------------------------------------------------------
ARTIFACT.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
LOCATE.ARTIFACT:
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NA
	IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = HA OR AD%(X, 4) = EMB) THEN FOUND = FOUND + 1: A = X: IF S$ = AN$(X) THEN X = 9999
    NEXT
    RETURN
' --------------------------------------------------------------------------
GET.SUBJ:
    WHILE S$ = ""
      PRINT
      PRINT C$(C); " What";
      INPUT S$
      PGPRT 2, ""
    WEND
    S$ = UCASE$(S$)
    RETURN
' --------------------------------------------------------------------------
DROP.RTN:
    GOSUB GET.SUBJ
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying a " + LCASE$(S$) + "!": GOTO MAIN.LOOP
    AD%(A, 4) = Room
    PGPRT 2, AN$(A) + " dropped."
    GOTO Get.Back
' ---------------------------------------------------------------------------
LOOK.RTN:
    IF LT = 0 THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    LK = 0
    IF S$ = "" THEN GOTO GENERAL.LOOK
    GOSUB EXAMINE.NONART
    IF LK THEN GOTO Get.Back
    WH = Room
    HA = -1
    EMB = Room + EMB.ADJ
    GOSUB LOCATE.ARTIFACT
    IF FOUND AND AD%(A, 4) = EMB THEN AD%(A, 4) = Room
    IF FOUND THEN GOSUB EXAMINE.ARTIFACT: GOTO Get.Back
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOSUB EXAMINE.MONSTER
GENERAL.LOOK:      ' GENERAL.LOOK
    IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
    FOR A = 1 TO NA
    IF AD%(A, 4) = Room + HID.ADJ THEN LK = -1: GOSUB FIND.ARTIFACT
    NEXT
    IF LK THEN PGPRT 2, "You found something.": GOTO Get.Back
    FOR X = 1 TO ND
    IF RD%(X) < 0 AND RD%(X) >= -NR THEN GOSUB SECRET.PASSAGE
    NEXT
NOTHIN.TA.SEE:      ' NOTHIN.TA.SEE
    V%(Room) = 0
    GOTO Get.Back
EXAMINE.MONSTER:      ' EXAMINE.MONSTER
    R = M + MAX.RM
    GOSUB PRINT.EFFECT
    RETURN
EXAMINE.NONART:      ' EXAMINE.NONART (S$)
    RETURN
SECRET.PASSAGE:
    RD%(X) = ABS(RD%(X))
    V%(Room) = 2
    IF LK = 0 THEN PGPRT 2, "You found a secret passage " + C$(X) + "!": NX = NX + 1
    RETURN
EXAMINE.ARTIFACT:
'     === EXAM ART A
    IF A > NZ THEN PGPRT 2, "This is your " + AN$(A) + "."
    IF A > NZ - NM THEN PGPRT 2, "Yes, he's dead!": RETURN
    IF A = 3 OR A = 13 THEN PGPRT 2, "The bottle says, 'Healing Potion'": RETURN
    GET #2, A + ART.ADJ
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    LK = -1
    AD%(A, 9) = 1
    RETURN
FIND.ARTIFACT:      ' FIND.ARTIFACT
'      == DISCOVER ARTIFACT A HIDDEN IN ROOM!
'    --- INSERT HERE ANY SPECIAL DISCOVERY MESSAGES ---
'        SUCH AS "YOU FOUND SOMETHING UNDER THE BED"
    LK = -1
    AD%(A, 4) = Room
    RETURN
' ---------------------------------------------------------------------------
ATTACK.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You swing wild --- nothing hit.": GOTO Get.Back
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOTO ATTACK.MON
    TA = 0
    GOTO ASSAULT.ARTIFACT
ATTACK.MON:
    IF MD%(0, 9) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO MAIN.LOOP
    OF = 0
    DF = M
    GOSUB TAKE.A.SWING
    IF HIT = 0 THEN GOTO MISSED
    IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
    IF -EA <= AE THEN GOTO Get.Back
    IF INT(100 * RND(1) + 1) <= MD%(0, 10) THEN GOTO MISSED
    A = 2
    IF EA + AE = -1 THEN A = 1
    AE = AE + A
    MD%(0, 10) = MD%(0, 10) + A
MISSED:
    IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO Get.Back
    MD%(DF, 3) = MD%(DF, 3) / 2
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
    NEXT
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO Get.Back
MON.GET.GUN:      ' MON.GET.GUN
'    -- MONSTER PICK-UP WEAPON
    IF MD%(OF, 10) = 0 THEN RETURN
    A = 0
    FOR X = 1 TO NA
    IF AD%(X, 4) = Room AND (AD%(X, 2) = 2 OR AD%(X, 2) = 3) THEN A = X: X = NA
    NEXT
    IF A = 0 THEN RETURN
    PGPRT 2, MN$(OF) + " picks up " + AN$(A) + "."
    AD%(A, 4) = 0
    MD%(OF, 9) = A
    MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5)
    MD%(OF, 4) = MD%(OF, 4) * 2
    RETURN
TAKE.A.SWING:
    HIT = 0
    IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
    IF DF = 0 AND IV THEN RETURN
    PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
    PRINT " --";
    RL = INT(100 * RND(1) + 1)
    HIT = 0
    IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = 1
    IF HIT THEN GOTO A.HIT
    IF RL < 97 THEN PGPRT 1, " A miss!": RETURN
    PGPRT 1, "A fumble!"
    FR = INT(100 * RND(1) + 1)
    IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PGPRT 1, "   fumble recovered.": RETURN
    IF FR < 76 THEN
	PGPRT 1, "  weapon dropped!"
	AD%(MD%(OF, 9), 4) = Room
	MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
	MD%(OF, 9) = -1
	MD%(OF, 4) = MD%(OF, 4) / 2
	RETURN
    END IF
    IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PGPRT 1, "Sparks fly from " + AN$(W) + "!": RETURN
    IF FR > 95 THEN GOTO SELF.OUCH
    PGPRT 1, "  weapon breaks!"
    AD%(MD%(OF, 9), 4) = 0
    MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
    MD%(OF, 9) = -1
    MD%(OF, 4) = MD%(OF, 4) / 2
    IF RND(1) > .5 THEN RETURN
    PGPRT 1, "  broken weapon hurts user!"
SELF.OUCH:
    IF FR = 100 THEN GOTO SELF.YEOW
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    DF = OF
    A = 1
    GOTO DO.DAMAGE
SELF.YEOW:
    D = MD%(OF, 11) * 2
    S = MD%(OF, 12)
    DF = OF
    A = 0
    GOTO DO.DAMAGE
A.HIT:
    INC = ABS(INT(100 * RND(1) + 1) > MD%(OF, 10))
    MD%(OF, 10) = MD%(OF, 10) + 2 * INC
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    A = 1
    IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO DO.DAMAGE
    PGPRT 1, "A critical hit!"
    R2 = INT(100 * RND(1) + 1)
    IF R2 < 51 THEN A = 0: GOTO DO.DAMAGE
    IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
    IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
    IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
    GOTO IS.DEAD
DO.DAMAGE:      ' DO.DAMAGE
    D2 = 0
    FOR D3 = 1 TO D
    D2 = D2 + INT(S * RND(1) + 1)
    NEXT
    D2 = D2 - A * MD%(DF, 8)
    IF DF > 8 AND DF < 13 AND OF = 0 AND MD%(0, 9) = 6 THEN D2 = D2 + 2
    IF D2 < 1 THEN PGPRT 1, "   blow bounces off armour.": RETURN
APPLY.DAMAGE:      ' APPLY.DAMAGE
    MD%(DF, 13) = MD%(DF, 13) + D2
    IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO DEAD.RTN
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + D2
SHOW.CONDITION:
    A$ = MN$(DF)
    ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:      ' GOOD.SHAPE
    PGPRT 2, A$ + " is still in good shape."
    RETURN
HURTING:      ' HURTING
    PGPRT 2, A$ + " is hurting."
    RETURN
IN.PAIN:      ' IN.PAIN
    PGPRT 2, A$ + " is in pain."
    RETURN
BADLY.INJURED:      ' BADLY.INJURED
    PGPRT 2, A$ + " is very badly injured."
    RETURN
DEATHS.DOOR:      ' DEATHS.DOOR
    PGPRT 2, A$ + " is at death's door, knocking loudly."
    RETURN
DEAD.RTN:
    IF DF = 0 THEN PGPRT 2, "You are dead!": DIE = -1: GOTO Game.Over
IS.DEAD:      ' IS.DEAD
'    /// MONSTER DIES
    PGPRT 2, MN$(DF) + " is dead!"
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
    MD%(DF, 5) = 0
    IF DF = 17 THEN RETURN
    IF (DF = 1 OR DF = 6) AND AD%(2, 4) = 0 THEN PGPRT 2, "A skeleton key drops from his clutches!": AD%(2, 4) = Room
    FOR AJ = 1 TO NA
    IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = Room
    NEXT
    IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = Room: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
GET.BODY:
    IF DF = 0 THEN DIE = 1: GOTO Game.Over
    A2 = DF + NZ - NM
    AD%(A2, 4) = Room
    RETURN
FLEE.RTN:
    IF NBTL = 0 THEN PGPRT 2, "There's nothing to flee from!": GOTO MAIN.LOOP
    IF LEN(S$) > 0 THEN
	FOR D = 1 TO ND
	    IF S$ = UCASE$(LEFT$(C$(D), LEN(S$))) THEN
		C = D
		R2 = RD%(D)
		S$ = "FLEE"
		EXIT FOR
	    END IF
	NEXT
    END IF
    IF NX = 0 THEN PGPRT 2, "There's no place to go!": GOTO MAIN.LOOP
    IF C <= ND THEN GOTO Move.it
    GOSUB FIND.EXIT
    GOTO Move.it
FIND.EXIT:
    IF NX = 0 THEN R2 = Room: PGPRT 1, " ... but can't find an exit!": RETURN
    R2 = RD%(ND * RND(1) + 1)
    IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
    RETURN
' ---------------------------------------------------------------------------
GIVE.RTN:
    IF S$ = "" THEN GOSUB GET.SUBJ
    A = 0
    M = 0
    M$ = ""
    A$ = ""
    SEP = INSTR(S$, " TO ")
    IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
    END IF
    SEP = INSTR(S$, " ")
    IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF FOUND THEN
	      M$ = S$
	      A$ = MID$(SAVE.S$, SP)
	      GOTO READY.SEARCH.GIVE
	  END IF
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
	    A$ = MID$(S$, SEP + 1)
	    M$ = LEFT$(S$, SEP - 1)
	ELSE
	    GOSUB GIVE.WHO
	    GOSUB GIVE.WHAT
	END IF
    ELSE
	GOSUB ARTIFACT.SEARCH
	IF FOUND THEN
	    A$ = AN$(A)
	ELSE
	    GOSUB MONSTER.SEARCH
	    IF FOUND THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
	    END IF
	END IF
    END IF
READY.SEARCH.GIVE:
    GOSUB GIVE.WHO
    GOSUB GIVE.WHAT
    IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
    END IF
    IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
	    S$ = A$
	    GOSUB ARTIFACT.SEARCH
	END IF
    END IF
    IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
    IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
    PGPRT 2, "I don't know what you mean."
    GOTO MAIN.LOOP
RESOLVE.GIVE:      ' RESOLVE.GIVE
    PGPRT 2, "Okay."
    POP = 0
    GOSUB GIVE.ART.MON
    IF POP <> 0 THEN GOTO MAIN.LOOP
    IF A = MD%(0, 9) THEN MD%(0, 9) = -1
    AD%(A, 4) = -M - 1
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
    IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO CHK.WGHT
GIVE.ART.MON:
 ' PUT SPECIAL CODE HERE FOR GIVING ITEM (A) TO MONSTER (M)
 ' IF MONSTER REFUSES OR SOME SPECIAL ACTION WHERE ITEM DOESN'T CHANGE
 ' HANDS OCCURS, THEN SET POP = -1 AND RETURN FROM THIS ROUTINE.
    RETURN
GIVE.GOLD:
    IF VAL(A$) > GOLD& THEN PGPRT 2, "You aren't carrying that much gold!": GOTO Get.Back
    GOLD& = INT(GOLD& - VAL(A$))
    MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
    GOTO COMPLETE.GIVE
GIVE.WHO:
    IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
    RETURN
GIVE.WHAT:
    IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
    RETURN
' ---------------------------------------------------------------------------
INVENTORY.RTN:
    IF IV THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    PGPRT 2, "You are carrying the following--"
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN
	PGPRT 1, " " + AN$(A) + LEFT$(" (Ready weapon)", 1 + 20 * ABS(A = MD%(0, 9)))
    END IF
    NEXT
    PGPRT 1, STR$(GOLD&) + " gold pieces."
    GOTO Get.Back
' --------------------------------------------------------------------------
BLAST.SPELL:
    GOSUB GET.SUBJ
    GOSUB MONSTER.SEARCH
    IF FOUND = 0 THEN GOTO BLASTED.DOOR
    S = 1
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO Get.Back
    PGPRT 2, "Direct Hit!"
    S = 5
    D = 2
    DF = M
    A = 0
    GOSUB DO.DAMAGE
    GOTO Get.Back
BLASTED.DOOR:
'    /// BLAST DOOR/GATE OR CONTAINER?
    TA = 1
    GOTO ASSAULT.ARTIFACT
' ---------------------------------------------------------------------------
CAST.SPELL:
    SUC = 0
    IF SA%(S) THEN RL = INT(100 * RND(1) + 1): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN SUC = 0
    IF SUC = 0 THEN PGPRT 2, "Nothing happened.": RETURN
    RL = INT(100 * RND(1) + 1)
    IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
    S2%(S) = S2%(S) * .8
    RETURN
' ---------------------------------------------------------------------------
HEAL.SPELL:
    S = 2
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO Get.Back
HEAL.WOUNDS:
    M = 0
    IF S$ <> "" THEN GOSUB MONSTER.SEARCH
    IF M = 0 THEN S$ = "your" ELSE S$ = MN$(M) + "'s"
    IF MD%(M, 13) THEN
	PGPRT 2, "Some of " + S$ + " wounds seem to clear up."
	MD%(M, 13) = MD%(M, 13) - INT(10 * RND(1) + 1)
    END IF
    IF MD%(M, 13) < 0 THEN MD%(M, 13) = 0
    DF = M
    GOSUB SHOW.CONDITION
    GOTO Get.Back
' --------------------------------------------------------------------------
POWER.SPELL:
    S = 4
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO Get.Back
    RAISE = 0
    FOR M = 1 TO NM
    M2 = NZ - NM + M
    IF AD%(M2, 4) = Room OR AD%(M2, 4) = -1 THEN RAISE = 1: GOSUB RAISE.DEAD
    NEXT M
    IF RAISE THEN R3 = Room: GOSUB CHK.REACTIONS: GOTO Get.Back
    FOR A = 1 TO NA
    IF AD%(A, 4) = Room THEN RAISE = -1: PGPRT 2, AN$(A) + " vanishes!": AD%(A, 4) = 0
    NEXT A: IF RAISE THEN PGPRT 1, " ": GOTO Get.Back
    RR = INT(RND(1) * 100 + 1)
    IF RR < 11 THEN PGPRT 2, "The section of tunnel you are in collapses and you die.": DIE = 1: GOTO Game.Over
    IF RR < 86 THEN PGPRT 2, "You hear a very loud sonic boom that echoes through the tunnels.": GOTO Get.Back
    IF RR > 95 THEN PGPRT 2, "All of your wounds are healed.": MD%(0, 13) = 0: GOTO Get.Back
    GOTO DO.SPEED
RAISE.DEAD:
    PGPRT 2, MN$(M) + " comes alive!": AD%(M2, 4) = 0: MD%(M, 5) = Room: MD%(M, 13) = 0: IF AD%(M2, 4) = -1 THEN WT = WT - AD%(M2, 3)
    RETURN
' --------------------------------------------------------------------------
SPEED.SPELL:
    S = 3
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO Get.Back
DO.SPEED:
    IF SPD <> 0 THEN PGPRT 2, "Nothing Happens.": GOTO MAIN.LOOP
    MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2)
    MD%(0, 2) = 2 * MD%(0, 2)
    SPD = SPD + INT(25 * RND(1) + 10)
    PGPRT 2, "You can feel the new agility flowing through you!"
    GOTO Get.Back
' --------------------------------------------------------------------------
SMILE.RTN:
    IF IV THEN GOTO Get.Back
    PGPRT 1, " "
    FOR M = 1 TO NM
      IF MD%(M, 5) = Room AND MD%(M, 15) <= 1 THEN
	  ON MD%(M, 14) GOSUB GROWLS, IGNORES, SMILES
      END IF
    NEXT
    PGPRT 1, " "
    GOTO Get.Back
GROWLS:
    PGPRT 1, MN$(M) + " growls at you!"
    RETURN
IGNORES:
    PGPRT 1, MN$(M) + " ignores you."
    RETURN
SMILES:
    PGPRT 1, MN$(M) + " " + LCASE$(C$(C)) + "s back."
    RETURN
' --------------------------------------------------------------------------
SAY.SOMETHING:
    GOSUB GET.SUBJ
    IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
    IF S$ = "HEAL" THEN GOTO HEAL.SPELL
    IF S$ = "POWER" THEN GOTO POWER.SPELL
    IF S$ = "SPEED" THEN GOTO SPEED.SPELL
    IF S$ = "MAGIC" AND AD%(8, 4) = 0 AND Room = AD%(25, 4) THEN PGPRT 2, "As you say the word, there is a small eruption from the stone and an": PGPRT 1, "emerald pops from it!": AD%(8, 4) = Room: GOTO Get.Back
    IF LEFT$(S$, 5) = "ROOM " THEN
	PGPRT 2, "As you say this, your vision blurs and your head spins..."
	R2 = VAL(MID$(S$, 6))
	GOTO Move.it
    END IF
    IF LEFT$(S$, 10) = "WHERE AM I" THEN
	PGPRT 2, "As you say this, you hear a voice say " + CHR$(34) + "Room " + STR$(Room) + "!" + CHR$(34)
	GOTO Get.Back
    END IF
    PGPRT 2, "Okay, " + CHR$(34) + S$ + CHR$(34)
    IF IV THEN GOSUB RATTLE.MONSTER
    GOTO Get.Back
' --------------------------------------------------------------------------
READY.WEAPON:
    GOSUB GET.SUBJ
    WH = -1
    HA = WH
    EMB = HA
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO MAIN.LOOP
    IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PGPRT 2, "That isn't a weapon!": GOTO MAIN.LOOP
CALCULATE.ODDS:
    MD%(0, 10) = (EA + AE) * ABS(-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
    MD%(0, 9) = A
    MD%(0, 11) = AD%(A, 7)
    MD%(0, 12) = AD%(A, 8)
    PGPRT 2, "Readied."
    GOTO Get.Back
' --------------------------------------------------------------------------
OPEN.RTN:
      IF NBTL THEN GOTO MOVE.RTN
      GOSUB GET.SUBJ
      WH = Room
      HA = -1
      EMB = Room + 200
      GOSUB LOCATE.ARTIFACT
      IF FOUND = 0 THEN GOTO HOWZAT
      IF A = 17 AND AD%(2, 4) = -1 THEN PGPRT 2, "As you open the iron grate, it crumbles to dust.": AD%(17, 4) = 0: GOTO Get.Back
      IF A = 16 AND E1 > 0 THEN PGPRT 2, "You can't open it.": GOTO Get.Back
      IF A = 16 THEN PGPRT 2, "As you begin to open the lid, a skeleton jumps out and attacks you! The lid slams back shut!": E1 = 1: MD%(1, 5) = Room: R3 = Room: GOSUB CHK.REACTIONS: GOTO Get.Back
      GOTO HOWZAT
HOWZAT:
      PGPRT 2, "Mind telling me how?"
      GOTO MAIN.LOOP
DRINK.RTN:
      GOSUB GET.SUBJ
      IF S$ = "WATER" AND AD%(5, 4) = -1 THEN PGPRT 2, "The water tastes salty, but does not appear to be poisonous.": GOTO Get.Back
      WH = Room
      HA = -1
      EMB = Room + 200
      GOSUB LOCATE.ARTIFACT
      IF FOUND = 0 THEN GOTO HOWZAT
      IF A = 4 THEN PGPRT 2, "The bottle is empty.": GOTO Get.Back
      PGPRT 2, "You can't do that."
      GOTO Get.Back
DIG.RTN:
      IF NBTL THEN GOTO MOVE.RTN
      IF AD%(9, 4) <> -1 THEN PGPRT 2, "The ground is too hard to dig with your fingers.": GOTO Get.Back
      IF Room <> 27 OR AD%(6, 4) > 0 THEN PGPRT 2, "You find nothing.": GOTO Get.Back
      PGPRT 2, "You find a bag of gold coins!"
      AD%(6, 4) = Room
      GOTO Get.Back
ENTER.RTN:
      IF (S$ = "WATER" OR S$ = "SEA") AND Room = 26 THEN PGPRT 2, "I'm afraid to go into the water without my life preserver!": GOTO Get.Back
      IF (S$ = "BOAT") AND AD%(3, 4) = Room THEN
	  PGPRT 2, "You climb into the boat."
	  GOTO Get.Back
      END IF
      PGPRT 2, "I'm not sure what you mean by that. Try giving a direction to move in."
      GOTO MAIN.LOOP
ASSAULT.ARTIFACT:
    IF TA = 0 THEN PGPRT 2, "Attack who?": GOTO MAIN.LOOP
    PGPRT 2, "You can't blast " + LCASE$(S$) + "!"
    GOTO MAIN.LOOP
' --------------------------------------------------------------------------
READ.RTN:
    IF IC <> 0 AND DD = 0 THEN PGPRT 2, "You can't see.": GOTO MAIN.LOOP
    GOSUB GET.SUBJ
    WH = Room
    HA = -1
    EMB = Room + EMB.ADJ
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN GOTO READ.NONART
    IF AD%(A, 2) = 7 THEN GOTO READ.ARTIFACT
    PGPRT 2, "You can't read the " + AN$(A) + "."
    GOTO Get.Back
READ.NONART:
'   ...  NON-ART - INSERT HERE SPECIAL READING ...
'   ...  EXAMPLE: READING WALLS OR CEILING, DOORS, ETC ...
    GOTO DONT.UNDERSTAND
READ.ARTIFACT:
'    /// READING A READABLE ARTIF.
    R = AD%(A, 5) + AD%(A, 7) - 1
    GOSUB PRINT.EFFECT
    AD%(A, 7) = AD%(A, 7) + 1
    IF AD%(A, 7) > AD%(A, 6) THEN AD%(A, 7) = 1
    GOTO Get.Back
' --------------------------------------------------------------------------
PRINT.EFFECT:
    GET #2, R + EFF.ADJ
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    RETURN
' --------------------------------------------------------------------------
FREE.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO MAYBE.FREE.LIL
    IF AD%(A, 2) <> 10 THEN GOTO DONT.UNDERSTAND
    M = AD%(A, 5)
    K = AD%(A, 6)
    G = AD%(A, 7)
    IF AD%(A, 4) <> Room THEN PGPRT 2, "I don't know what you are talking about.": GOTO MAIN.LOOP
    IF MD%(G, 5) = Room THEN PGPRT 2, MN$(G) + " won't let you do that!": GOTO Get.Back
    IF AD%(K, 4) <> -1 AND K <> 0 THEN PGPRT 2, "You don't have the key!": GOTO MAIN.LOOP
    PGPRT 2, "You have freed " + MN$(M) + "."
    MD%(M, 5) = Room
    AD%(A, 4) = 0
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO Get.Back
MAYBE.FREE.LIL:
      IF LEFT$(UCASE$(MN$(9)), LEN(S$)) = S$ OR RIGHT$(UCASE$(MN$(9)), LEN(S$)) = S$ THEN M = 9 ELSE M = 0
      IF M <> 9 THEN GOTO DONT.UNDERSTAND
      FREED = 0
      IF RZ <> 0 OR Room <> 52 THEN PGPRT 2, "Huh? How can I " + CZ$ + "!": GOTO MAIN.LOOP
      IF AD%(2, 4) <> -1 THEN PGPRT 2, "The bonds are locked with a heavy lock and you don't have a key!": GOTO MAIN.LOOP
      RZ = 1
      PGPRT 2, "You have freed " + MN$(9) + "!"
      MD%(9, 5) = Room
      MD%(9, 14) = 3
      GOTO Get.Back
' ---------------------------------------------------------------------------
EAT.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO NOT.HUNGRY
    IF AD%(A, 2) <> FOOD.ART THEN GOTO NOT.HUNGRY
    PGPRT 2, "Okay. You eat the " + LCASE$(AN$(A)) + "."
    AD%(A, 4) = 0
    GOTO Get.Back
NOT.HUNGRY:
    PGPRT 2, "You aren't THAT hungry!"
    GOTO Get.Back
' ---------------------------------------------------------------------------
WEAR.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.WEAR
    IF AD%(A, 2) = ARMOR.ART THEN GOTO WEAR.ARMOR
WEAR.SOMETHING:
 ' ..... INSERT HERE SPECIAL WORN ARTIFACTS ...
    GOTO DONT.WEAR
WEAR.ARMOR:
    EA = -AD%(A, 5)
    MD%(0, 8) = AD%(A, 7)
    PGPRT 2, "Okay. You have put on the " + AN$(A) + "."
    GOTO Get.Back
DONT.WEAR:
    PGPRT 2, "You can't wear that and stay respectable."
    GOTO MAIN.LOOP
' ---------------------------------------------------------------------------
SAVE.GAME:
    INPUT "Do you want to save this game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO SAVE.IT
    GOTO MAIN.LOOP
SAVE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
    REM $INCLUDE: '\Eamon\copy\SAVEgame.bas'
    GOSUB OPEN.ROOMS
    GOTO MAIN.LOOP
RESTORE.GAME:
    INPUT "Do you want to Restore a game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO RESTORE.IT
    GOTO MAIN.LOOP
RESTORE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
    REM $INCLUDE: '\Eamon\Copy\RESTGAME.BAS'
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO Move.it
GET.GAME.ID:
    PRINT
    INPUT "File Name: ", GAME.ID$
    IF LEN(GAME.ID$) > 8 THEN GOTO GET.GAME.ID
    GAME.ID$ = UCASE$(GAME.ID$)
    IF LEFT$(GAME.ID$, 1) < "A" OR LEFT$(GAME.ID$, 1) > "Z" THEN GOTO GET.GAME.ID
    GAME.ID$ = GAME.ID$ + ".GAM"
    RETURN
    REM $INCLUDE: '\Eamon\Copy\Chario.bas'
READ.ARTIFACTS:    ' ----- READ ARTIFACTS ---------------------
       OPEN "ARTIF.TXT" FOR RANDOM AS #3 LEN = LEN(Artifact)
       FOR A = 1 TO NA
       GET #3, A, Artifact
       AN$(A) = RTRIM$(Artifact.Nam$)
       AD%(A, 1) = Artifact.value
       AD%(A, 2) = Artifact.typ
       AD%(A, 3) = Artifact.Weight
       AD%(A, 4) = Artifact.room
       AD%(A, 5) = Artifact.Odds
       AD%(A, 6) = Artifact.wpntyp
       AD%(A, 7) = Artifact.Dice
       AD%(A, 8) = Artifact.Sides
       IF Artifact.typ > 1 AND Artifact.typ < 4 THEN NW = NW + 1
       NEXT
       CLOSE 3
       RETURN
READ.MONSTERS:  ' ------------- READ MONSTERS    ---------------------
       OPEN "MONST.TXT" FOR RANDOM AS #3 LEN = 128
       FOR A = 1 TO NM
       GET #3, A, Monster
       IF Monster.Friend < 0 THEN
	   Monster.Friend = ABS(Monster.Friend) - 1
	   MD%(A, 14) = 2
       END IF
       MN$(A) = RTRIM$(Monster.Nam$)
       MD%(A, 1) = Monster.Hd
       MD%(A, 2) = Monster.Ag
       MD%(A, 3) = Monster.Friend
       MD%(A, 4) = Monster.Courage
       MD%(A, 5) = Monster.Room
       MD%(A, 6) = Monster.Weight
       MD%(A, 7) = Monster.DefOdds
       MD%(A, 8) = Monster.Armor
       MD%(A, 9) = Monster.Weapon
       MD%(A, 10) = Monster.OffOdds
       MD%(A, 11) = Monster.Dice
       MD%(A, 12) = Monster.Sides
       NEXT
       CLOSE 3
       RETURN
OPEN.DESC:       ' ----------------- OPEN DESC FILE -------------------
       OPEN "DESC.TXT" FOR RANDOM AS #2 LEN = 256
       FIELD 2, 256 AS DESC$
       RETURN
OPEN.ROOMS:    ' ---------------- OPEN ROOM NAMES -------------------
       OPEN "ROOMS.TXT" FOR RANDOM AS #1 LEN = LEN(Rm)
       RETURN
OPEN.RMNAMES:    ' ---------------- OPEN ROOM NAMES -------------------
       OPEN "RMNAMES.TXT" FOR RANDOM AS #3 LEN = 64
       FIELD 3, 64 AS RMN$
       RETURN
Read.Room:
       GET #3, Room
       RN$ = RTRIM$(RMN$)
       GET #1, Room, Rm
       RD%(1) = Rm.North
       RD%(2) = Rm.South
       RD%(3) = Rm.East
       RD%(4) = Rm.West
       RD%(5) = Rm.Up
       RD%(6) = Rm.Down
       RD%(7) = Rm.NE
       RD%(8) = Rm.NW
       RD%(9) = Rm.SE
       RD%(10) = Rm.SW
       RETURN
'------- (end of include file) -------


SUB PGPRT (SP, LIT$)

STATIC PG.CNT
    IF SP = 0 THEN PG.CNT = 0: EXIT SUB
    IF LIT$ = "" THEN PG.CNT = PG.CNT + SP: EXIT SUB
    IF PG.CNT > 18 THEN
	LOCATE 24, 1
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-");
	A$ = INPUT$(1)
	PG.CNT = 0
	LOCATE CSRLIN, 1
	PRINT SPC(79);
    END IF
    IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	PG.CNT = PG.CNT + 1
	NEXT
    END IF
    PRINT LIT$
    PG.CNT = PG.CNT + INT(LEN(LIT$) / 80) + 1
END SUB

