'          Eamon QB - Adventure # 15
'
'            Heroes Castle
'
'            by John Nelson
'
'
'
    DEFINT A-Z
    DECLARE SUB PGPRT (SP, LIT$)
    REM $INCLUDE: '\eamon\copy\chardef.bas'
    REM $INCLUDE: '\EAMON\copy\colorrtn.bas'
    CLS
    DEF FNR (X) = INT(RND(1) * X + 1)
'    LINE INPUT "PATH:", PATH$
    REM $INCLUDE: '\EAMON\COPY\READCTL.BAS'
    DIM V%(NR), RD%(10), FD%(3), TD%(3), SA%(4), S2%(4), WA%(5), RF.DIR$(10)
    DIM FWN$(4), FWT$(4), FWC$(4), FWD$(4), FWS$(4), FWA$(5), FSA$(5)
    DIM AN$(NA + 6), AD%(NA + 6, 9)
    DIM MN$(NM), MD%(NM, 16)
    GOSUB READ.ARTIFACTS ' LOAD ARTIFACT TABLE
    GOSUB READ.MONSTERS  ' LOAD MONSTER TABLE
    NW = NW + 6
    DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
    READ NBR.CMD
    DIM C$(NBR.CMD)
    FOR C = 1 TO NBR.CMD
    READ C$(C)
    NEXT
    R2 = 1
    CONST GOLD.ART = 0
    CONST TREASURE.ART = 1
    CONST WEAPON.ART = 2
    CONST MAG.WEAPON = 3
    CONST CONTAIN.ART = 4
    CONST LIGHT.ART = 5
    CONST HEAL.ART = 6
    CONST READ.ART = 7
    CONST DOOR.ART = 8
    CONST KEY.ART = 9
    CONST BOUND.MON.ART = 10
    CONST ARMOR.ART = 11
    CONST FOOD.ART = 12
    CONST DRINK.ART = 13   ' DRINKABLE ARTIFACT --- PUT IN YOUR OWN EFFECTS
    GOTO INITIALIZE
DONT.UNDERSTAND:
    PGPRT 2, "I don't understand."
' ---------------------------------------------------------------------------
MAIN.LOOP:
'    = MAIN =
    IF SPD THEN SPD = SPD - 1: IF SPD = 0 THEN MD%(0, 2) = MD%(0, 2) / 2: MD%(0, 10) = MD%(0, 10) - 2 * MD%(0, 2): PGPRT 2, "YOUR SPEED SPELL HAS JUST EXPIRED!"
    IF IV THEN PGPRT 2, "You're invisible.": VC = VC + 1: IF VC > 5 THEN VC = 0: D2 = 3: DF = 0: GOSUB APPLY.DAMAGE
SHOW.ROOM:      ' SHOW.ROOM
    IF V%(Room) <> 0 THEN GET #3, Room: A$ = RTRIM$(RN$): PGPRT 2, "You are " + A$
    IF V%(Room) = 0 THEN GOSUB SPECIAL.ROOM.CHK
    FOR M = 1 TO NM
    IF MD%(M, 5) <> Room THEN GOTO NEXT.MON
    IF MD%(M, 15) = 1 THEN PGPRT 2, MN$(M) + " is here."
    IF MD%(M, 15) = 2 THEN PGPRT 2, MN$(M) + " is lying here."
    IF MD%(M, 15) = 0 THEN
	GET #2, M + MON.ADJ
	A$ = RTRIM$(Desc$)
	PGPRT 2, A$
	MD%(M, 15) = 1
    END IF
NEXT.MON:      ' NEXT.MON
    NEXT
    FOR A = 1 TO NZ
    IF AD%(A, 4) <> Room THEN GOTO NEXT.ART
    IF AD%(A, 9) THEN
	PGPRT 2, "You see " + AN$(A) + "."
    ELSE
	GET #2, A + ART.ADJ
	A$ = RTRIM$(Desc$)
	PGPRT 2, A$
	AD%(A, 9) = 1
    END IF
NEXT.ART:      ' NEXT.ART
    NEXT
    FOR A = A TO NA
    IF AD%(A, 4) = Room THEN
	PGPRT 2, "Your " + AN$(A) + " is here."
    END IF
    NEXT
    PRINT
GET.COMMAND:      ' GET.COMMAND
    PGPRT 0, ""
    PRINT
    COLOR hfg%, hbg%
    PRINT "  Your Command ";
    COLOR fgc%, bgc%
    LINE INPUT " ", A$
    A$ = LTRIM$(RTRIM$(UCASE$(A$)))
    IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 17: PRINT A$
    IF A$ = "" THEN GOTO LIST.COMMANDS
    CZ$ = A$
    A = INSTR(A$, " ")
    IF A = 0 THEN A = LEN(A$) + 1
    V$ = LEFT$(A$, A - 1)
    S$ = MID$(A$, A + 1)
    S$ = LTRIM$(S$)
    IF V$ = "EXIT" AND S$ = "NOW" THEN GOTO GAME.OVER
    C = 0
    FOR A = 1 TO ND
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN C = A: A = ND
    NEXT
    IF C <> 0 THEN GOTO BRANCH.RTN
    F = 0
    FOR A = ND + 1 TO NBR.CMD
    IF UCASE$(C$(A)) = V$ THEN C = A: A = NBR.CMD
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN
	F = F + 1
	C = A
	IF F > 1 THEN C = 0: A = NBR.CMD
    END IF
    NEXT
    IF C = 0 THEN GOTO LIST.COMMANDS
    GOTO BRANCH.RTN
LIST.COMMANDS:      ' LIST.COMMANDS
    PRINT
    PRINT "Huh? I only understand these commands ... "
    FOR C = 1 TO NBR.CMD
    PRINT C$(C); SPC(20 - LEN(C$(C)));
    NEXT
    PRINT
    PRINT
    GOTO GET.COMMAND
    IF UCASE$(C$(C)) = S$ THEN S$ = V$: V$ = C$(C)
BRANCH.RTN:      ' BRANCH.RTN
    ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 5 GOTO MOVE.RTN, GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN
    ON C - 10 GOTO LOOK.RTN, ATTACK.RTN, FLEE.RTN, GIVE.RTN, INVENTORY.RTN
    ON C - 15 GOTO BLAST.SPELL, HEAL.SPELL, POWER.SPELL, SPEED.SPELL, SMILE.RTN
    ON C - 20 GOTO SMILE.RTN, SAY.SOMETHING, READ.RTN, READY.WEAPON, OPEN.RTN
    ON C - 25 GOTO PUT.RTN, FREE.RTN, EAT.RTN, DRINK.RTN, WEAR.RTN, USE.RTN
    ON C - 31 GOTO SAVE.GAME, RESTORE.GAME, QUIT.RTN
GET.BACK:      ' GET.BACK
    REM $INCLUDE: '\EAMON\COPY\NEWBATL.BAS'
    IF DY > 0 THEN DY = DY + 1
    IF DY > DP THEN GOTO DYING
    IF DY > 0 AND DY = INT(DP * .8) THEN PGPRT 2, "You feel like you can't go on much longer.": PRINT "Maybe some sleep will help.."
    IF DY > 0 AND DY = INT(DP / 2) THEN PGPRT 2, "You feel like you are half dead! Find that antidote!!"
    IF HY > 0 THEN HY = HY + 1
    IF HY > HP THEN PGPRT 2, "You have become yourself again. You are no longer Mr. Hyde!": MD%(0, 1) = MD%(0, 1) / 1.1: MD%(0, 3) = MD%(0, 3) * 2: HY = 0: MN$(0) = MN$
    IF MD%(1, 5) = Room THEN GOSUB DOCTOR.DIAG
    GOTO MAIN.LOOP
DYING:
    PRINT "You have gone as far as you can... say your prayers.."
    FOR X = 1 TO 3000: NEXT X
    PRINT "The poison has finally gotten you. You fall on the floor, kick your"
    PRINT "feet three times and die.": DIE = 1: GOTO GAME.OVER
DOCTOR.DIAG:
    IF RND(1) > .5 THEN RETURN
    IF MD%(0, 13) > MD%(0, 1) / 1.3 THEN PGPRT 2, "Doctor recommends you take it easy.": RETURN
    IF MD%(0, 13) > MD%(0, 1) / 2 THEN PGPRT 2, "The Doctor looks concerned."
    RETURN
    REM $INCLUDE: '\EAMON\COPY\MONLEAVE.BAS'
' ---------------------------------------------------------------------------
INITIALIZE:
    REM $INCLUDE: '\Eamon\COPY\READMEAT.BAS'
    GOSUB OPEN.DESC
    GOSUB OPEN.RMNAMES
    GOSUB OPEN.ROOMS
    Room = 1
    GOTO MOVE.IT
    DATA 34
    DATA North,South,East,West,Up,Down
    DATA Get,Take,Drop,Look,Examine
    DATA Attack,Flee,Give,Inventory
    DATA Blast,Heal,Power,Speed,Smile
    DATA Wave,Say,Read,Ready,Open
    DATA Put,Free,Eat,Drink,Wear,Use
    DATA Save,Restore,Quit
' ---------------------------------------------------------------------------
GAME.OVER:      ' GAME.OVER
    PRINT
    PRINT "(Press any key to continue) ";
    A$ = INPUT$(1)
    PRINT
    CLOSE
    IF SPD THEN MD%(0, 2) = MD%(0, 2) / 2
    IF DIE <> 0 AND SAVED <> 0 THEN
	PRINT "Do you want to restart (Y/N)  ";
	YN$ = INPUT$(1)
	IF UCASE$(YN$) = "Y" THEN RUN
    END IF
    IF DIE <> 0 THEN GOTO GET.MASTER
    GOSUB CHK.SUCCESS
    FOR W = 1 TO 4
    WN$(W) = "NONE"
    NEXT
    W2 = 1
    FOR A = 1 TO NA
    IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 AND AD%(A, 4) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, 4) = 0
    NEXT A
    IF W2 < 6 THEN GOTO SELL.TREASURE
PLAYER.RETURNS:
    CLS
    LOCATE 5, 1
    PRINT "As you start to enter the main hall, Lord William Misslefire appears and"
    PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
    PRINT
    PRINT "Your weapons are--"
    FOR W = 1 TO W2 - 1
    PRINT SPC(4); W; "--"; WN$(W)
    NEXT
    PRINT
    PRINT "Enter the number of the weapon to sell  (1-"; W2 - 1; ") "
SELL.WEAPON:
    LOCATE CSRLIN - 1, 53
    INPUT A$
    W5 = VAL(A$)
    IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO SELL.WEAPON
    AD%(WP%(W5), 4) = -1
    WN$(W5) = WN$(W2 - 1)
    WP%(W5) = WP%(W2 - 1)
    W2 = W2 - 1
    IF W2 > 5 THEN GOTO PLAYER.RETURNS
SELL.TREASURE:
    IF MD%(0, 8) > AC THEN MD%(0, 8) = AC
    FOR W = 1 TO 4
    IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
    NEXT W
    CLS
    LOCATE 5, 1
    PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
    PRINT "things, he examines your goods and pays you ";
    TP = 0
    FOR A = 1 TO NA
    IF A = ArmPtr OR A = ShdPtr THEN GOTO NEXT.TREASURE 
    IF AD%(A, 4) <> -1 THEN GOTO NEXT.TREASURE
    IF AD%(A, 2) <> 0 THEN AD%(A, 1) = AD%(A, 1) * CH / 10
    TP = TP + AD%(A, 1)
NEXT.TREASURE:
    NEXT A
    PRINT TP; " gold pieces."
    PRINT
    GOLD& = GOLD& + TP
    IF GOLD& < 0 THEN GOLD& = 0
    PRINT
    PRINT "(Press any key to continue)  ";
    A$ = INPUT$(1)
    PRINT
GET.MASTER:
    GOSUB PAY.TAXES
    IF LK THEN
	PRINT
	PRINT "(Press any key to continue) ";
	A$ = INPUT$(1)
	PRINT
    END IF
    CLS
    LOCATE 5, 1
 '  PRINT "  Insert Eamon Master Diskette, and press <RETURN>  OR     "
 '  PRINT
 '  PRINT "  Enter Path of Master ===> ";
 '  INPUT "", MastPath$
    IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
    IF MastPath$ <> "" THEN CHDIR MastPath$
    ON ERROR GOTO Invalid.Path
    IF DIE THEN KILL "ADVENT": RUN "WORLD"
    CLOSE
    GOSUB OPEN.CHARACTERS
    Nam$ = MN$(0)
    HD = MD%(0, 1)
    AG = MD%(0, 2)
    GOSUB WRITE.CHARACTER
    CLOSE
    OPEN PATH$ + "ADVENT" FOR OUTPUT AS #1
    PRINT #1, MN$(0)
    PRINT #1, REC
    CLOSE
    RUN "HALL"
Invalid.Path:
    PRINT
    PRINT "Invalid Path, or Master Not Found. Please re-try ..."
    PRINT " (press any key to continue)";
    A$ = INPUT$(1)
    RESUME GET.MASTER
PAY.TAXES:
    LK = 0
    IF DIE THEN RETURN    ' TAX EXEMPT?
    IF TP > 18000 THEN PGPRT 2, "As you leave, a man from the I.R.S (Income Removal Service) takes 50% of": PRINT "your profits.": GOLD& = INT(GOLD& - (TP / 2)): LK = -1
    IF MD%(19, 5) = 1 THEN GOTO LOVER.LOOSE
    PGPRT 25, ""
    RETURN
LOVER.LOOSE:
    PGPRT 2, "You have freed the young lady's lover. When you see how happy they are, you": PRINT "give them "; INT(GOLD& / 5); " gold "; : PRINT "pieces for a wedding present": PRINT "What a nice guy!!!!"
    GOLD& = GOLD& - INT(GOLD& / 5)
    LK = -1
    RETURN
QUIT.RTN:
    PRINT "Do you want to Quit this game? (Y/N) ";
    A$ = INPUT$(1)
    IF UCASE$(A$) = "N" THEN GOTO GET.COMMAND
    CLOSE
    END
CHK.SUCCESS:
'    /// SUCCESSFUL?
    GOTO MISSION.OVER
MISSION.OVER:
    PRINT
    PRINT " (PRESS ANY KEY)      ";
    A$ = INPUT$(1)
    PRINT
    RETURN
' --------------------------------------------------------------------------
MOVE.RTN:
    IF IV = 0 THEN
	IF NBTL AND S$ <> "FLEE" THEN
	    IF TT = 0 THEN
		PGPRT 2, "You can't do that with unfriendlies about!"
		GOTO MAIN.LOOP
	    END IF
	END IF
    END IF
    D = C
    R2 = RD%(D)
    IF R2 > MAX.RM AND R2 < EFF.ADJ THEN GOTO PASSAGE.BLOCKED
CHK.SPECIAL.MOVES:      ' CHK.SPECIAL.MOVES
    IF R2 > 0 AND R2 <= NR THEN GOTO MOVE.IT
'     /// SPECIAL MOVES
    IF R2 = -99 THEN
	IF DY > 0 THEN PGPRT 2, "You cannot leave until you find an antidote to the poison you took.": GOTO MAIN.LOOP
	IF HY > 0 THEN PGPRT 2, "If you leave now, you will be trapped as Mr. Hyde all your life.": INPUT "Enter L for Leave or S for Stay:", H$: IF UCASE$(H$) = "S" THEN GOTO MAIN.LOOP
	PGPRT 2, "You successfully ride off into the sunset.": GOTO GAME.OVER
    END IF
    IF R2 = 0 THEN GOTO CANT.GO
'    /// INSERT HERE SPECIAL ROOM MOVE CHECKING
    IF R2 = -1 THEN PGPRT 2, "You have just passed through a hallographic projection of a wall.": PRINT "The wall that appeared to be there was not really there.": R2 = 16: GOTO MOVE.IT
    IF R2 = -2 OR R2 = -3 THEN GOTO FALL.DOWN
    IF R2 = -4 THEN PGPRT 2, "You have passed through a one way hole in space, and find yourself magically": PRINT "transported to the other end of the castle.": R2 = 75: GOTO MOVE.IT
    GOTO CANT.GO
FALL.DOWN:
    PGPRT 2, "In your clumsiness you have fallen down the long stairway instead of walking"
    PGPRT 1, "down like a human being!!!"
    COLOR hfg%, hbg%
    PRINT "CRASH!!! BOOM!!!! BANG!!!!!";
    COLOR fgc%, bgc%
    PRINT
    PGPRT 1, "Boy, are you lucky!!"
    PGPRT 1, "You landed on your head and therefore you didn't injure yourself!"
    IF R2 = -2 THEN R2 = 50: GOTO MOVE.IT
    IF R2 = -3 THEN R2 = 74: GOTO MOVE.IT
    GOTO MOVE.IT
PASSAGE.BLOCKED:
    GT = R2 - MAX.RM
    IF AD%(GT, 4) <> Room THEN R2 = AD%(GT, 5): GOTO CHK.SPECIAL.MOVES
    PGPRT 2, "The " + AN$(GT) + " blocks the way!"
    GOTO MAIN.LOOP
CANT.GO:
    PGPRT 2, "You can't go that way!"
    V%(Room) = 0
    GOTO MAIN.LOOP
MOVE.IT:
    IF C = 5 OR C = 6 THEN IF CL THEN PGPRT 2, "You can't take a loaded cart up or down the stairs!!": GOTO GET.BACK
    R3 = Room
    Room = R2
    GOSUB CHK.REACTIONS
    GET #1, Room
    NX = 0
    FOR X = 1 TO ND
    RD%(X) = CVI(RF.DIR$(X))
    IF RD%(X) < 0 AND RD%(X) > -NR AND V%(Room) > 1 THEN RD%(X) = ABS(RD%(X))
COUNT.EXITS:      ' COUNT.EXITS
    IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
    NEXT
    LT = -1
    GOTO END.LOOP
CHK.REACTIONS:
    TD%(1) = 0
    TD%(3) = MD%(0, 1)
    FD%(1) = 0
    FD%(3) = MD%(0, 13)
    FOR M = 1 TO NM
    IF MD%(M, 15) = 2 AND MD%(M, 5) = Room THEN GOTO MONSTER.NOT.HERE
    IF MD%(M, 5) = R3 THEN IF MD%(M, 14) = 3 OR (MD%(M, 14) = 1 AND 200 * RND(1) < MD%(M, 4)) THEN MD%(M, 5) = Room: GOTO ADD.SIDES
MONSTER.REACTS:      ' MONSTER.REACTS
    IF MD%(M, 5) <> Room THEN GOTO MONSTER.NOT.HERE
    IF MD%(M, 14) > 0 THEN GOTO ADD.SIDES
    FR = MD%(M, 3)
    IF FR > 0 AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
    MD%(M, 14) = 1
    IF FR > (100 * RND(1)) THEN MD%(M, 14) = 2: IF FR > (100 * RND(1)) THEN MD%(M, 14) = 3
ADD.SIDES:      ' ADD.SIDES
    A = MD%(M, 14)
    FD%(A) = FD%(A) + MD%(M, 13)
    TD%(A) = TD%(A) + MD%(M, 1)
MONSTER.NOT.HERE:
    NEXT
    GOTO SET.NBTL
SET.NBTL:
    NBTL = (TD%(1) > 0)
    RETURN
BRING.IN.BEASTS:
    MD%(M, 5) = Room
    MD%(M, 13) = 0
    R3 = Room
    GOSUB CHK.REACTIONS
    RETURN
' --------------------------------------------------------------------------
GET.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You can't find anything.": GOTO MAIN.LOOP
    IF S$ = "ALL" THEN GOTO GET.ALL
    EMB = Room + EMB.ADJ
    WH = Room
    HA = Room
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "I see no " + LCASE$(S$) + " here!": GOTO MAIN.LOOP
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO MAIN.LOOP
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, "You can't budge it!": GOTO MAIN.LOOP
    PGPRT 2, "Got it."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
    IF (AD%(A, 2) = 2 OR AD%(A, 2) = 3) AND MD%(0, 9) = -1 THEN GOTO CALCULATE.ODDS
    GOTO GET.BACK
GET.ALL:      ' GET.ALL
    FOR A = 1 TO NA
    IF AD%(A, 4) <> Room OR AD%(A, 2) = 10 THEN GOTO GET.NEXT
    GOSUB GET.SURPRISE
    IF GT = 0 THEN GOTO GET.NEXT
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, AN$(A) + " can't be moved.": GOTO GET.NEXT
    PGPRT 1, AN$(A) + " taken."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
GET.NEXT:      ' GET.NEXT
    NEXT
    GOTO GET.BACK
GET.SURPRISE:      ' GET.SURPRISE
'    /// INSERT HERE SPECIAL EFFECTS OF PICKING SOMETHING UP
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 1 AND ARMPTR = 0 THEN
	ARMPTR = A
	GOSUB Ready.Armor
    END IF
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 2 AND SHDPTR = 0 THEN
	SHDPTR = A
	GOSUB Ready.Armor
    END IF
    GT = 1
    IF IV THEN GOSUB RATTLE.MONSTER
    RETURN
RATTLE.MONSTER:      ' RATTLE.MONSTER
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room THEN
	PGPRT 1, MN$(M) + " is slightly unnerved!"
	MD%(M, 4) = MD%(M, 4) - 10
    END IF
    NEXT
    RETURN
SPECIAL.ROOM.CHK:      ' SPECIAL.ROOM.CHK
'    /// SPECIAL ROOM?
    GET #2, Room
    A$ = RTRIM$(Desc$)
    PGPRT 2, A$
    V%(Room) = V%(Room) + 1
    RETURN
' ---------------------------------------------------------------------------
MONSTER.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NM
    IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = WH OR MD%(X, 5) = HA) THEN FOUND = FOUND + 1: M = X: IF S$ = MN$(X) THEN X = 9999
    NEXT
    RETURN
' ---------------------------------------------------------------------------
ARTIFACT.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
LOCATE.ARTIFACT:
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NA
    IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = HA OR AD%(X, 4) = EMB) THEN FOUND = FOUND + 1: A = X: IF S$ = AN$(X) THEN X = 9999
    NEXT
    RETURN
' --------------------------------------------------------------------------
GET.SUBJ:
    WHILE S$ = ""
      PRINT
      PRINT C$(C); " What";
      INPUT S$
      PGPRT 2, ""
    WEND
    S$ = UCASE$(S$)
    RETURN
' --------------------------------------------------------------------------
DROP.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO DROP.ALL
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying a " + LCASE$(S$) + "!": GOTO MAIN.LOOP
    WT = WT - AD%(A, 3)
    AD%(A, 4) = Room
    PGPRT 2, AN$(A) + " dropped."
    GOSUB DROP.SPECIAL
CHK.WGHT:      ' CHK.WGHT
    IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAPON:
    IF MD%(0, 9) > 0 THEN IF AD%(MD%(0, 9), 4) <> -1 THEN MD%(0, 9) = -1
    GOTO GET.BACK
DROP.ALL:       ' DROP.ALL
    SR = Room
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 AND A <> ARMPTR THEN
	PGPRT 2, AN$(A) + " dropped."
	AD%(A, 4) = Room
	GOSUB DROP.SPECIAL
    END IF
    NEXT
    WT = 0
    GOTO CHK.DROP.WEAPON
DROP.SPECIAL:
    IF IV THEN GOSUB RATTLE.MONSTER
    IF A = ARMPTR OR A = SHDPTR THEN GOSUB DROP.ARMOR
    IF A = 6 THEN GOSUB DROP.CART: CL = 0
    RETURN
DROP.CART:
    FOR X = 1 TO NA
    IF AD%(X, 4) = -2 THEN AD%(X, 4) = Room
    NEXT
    RETURN
DROP.STEAK:
    PGPRT 2, "The tiger eats the steak!!"
    PGPRT 1, "You have made a friend for life!!"
    MD%(17, 3) = 100
    AD%(8, 4) = 0
    MD%(17, 14) = 0
    GOSUB CHK.REACTIONS
    RETURN
DROP.ARMOR:
    IF A = ARMPTR THEN ARMPTR = 0
    IF A = SHDPTR THEN SHDPTR = 0
    MD%(0, 8) = MD%(0, 8) - AD%(A, 7)
    EA = EA + AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
Ready.Armor:
    MD%(0, 8) = MD%(0, 8) + AD%(A, 7)
    EA = EA - AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
' ---------------------------------------------------------------------------
LOOK.RTN:
    IF LT = 0 THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    LK = 0
    IF S$ = "" THEN GOTO GENERAL.LOOK
    GOSUB EXAMINE.NONART
    IF LK THEN GOTO GET.BACK
    WH = Room
    HA = -1
    EMB = Room + EMB.ADJ
    GOSUB LOCATE.ARTIFACT
    IF FOUND AND AD%(A, 4) = EMB THEN AD%(A, 4) = Room
    IF FOUND THEN GOSUB EXAMINE.ARTIFACT: GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOSUB EXAMINE.MONSTER
GENERAL.LOOK:      ' GENERAL.LOOK
    IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
    FOR A = 1 TO NA
    IF AD%(A, 4) = Room + HID.ADJ THEN LK = -1: GOSUB FIND.ARTIFACT
    NEXT
    IF LK THEN PGPRT 2, "You found something.": GOTO GET.BACK
NOTHIN.TA.SEE:      ' NOTHIN.TA.SEE
    V%(Room) = 0
    GOTO GET.BACK
EXAMINE.MONSTER:      ' EXAMINE.MONSTER
    R = M + MAX.RM
    GOSUB PRINT.EFFECT
    RETURN
EXAMINE.NONART:      ' EXAMINE.NONART (S$)
    RETURN
SECRET.PASSAGE:
    RD%(X) = ABS(RD%(X))
    V%(Room) = 2
    IF LK = 0 THEN PGPRT 2, "You found a secret passage " + C$(X) + "!": NX = NX + 1
    RETURN
EXAMINE.ARTIFACT:
'     === EXAM ART A
    IF A > NZ THEN PGPRT 2, "This is your " + AN$(A) + "."
    IF A > NZ - NM THEN PGPRT 2, "Yes, he's dead!": RETURN
    GET #2, A + ART.ADJ
    A$ = RTRIM$(Desc$)
    PGPRT 2, A$
    LK = -1
    AD%(A, 9) = 1
    RETURN
FIND.ARTIFACT:      ' FIND.ARTIFACT
'      == DISCOVER ARTIFACT A HIDDEN IN ROOM!
'    --- INSERT HERE ANY SPECIAL DISCOVERY MESSAGES ---
'        SUCH AS "YOU FOUND SOMETHING UNDER THE BED"
    LK = -1
    AD%(A, 4) = Room
    RETURN
' ---------------------------------------------------------------------------
ATTACK.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You swing wild --- nothing hit.": GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOTO ATTACK.MON
    TA = 0
    GOTO ASSAULT.ARTIFACT
ATTACK.MON:
    IF MD%(0, 9) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO MAIN.LOOP
    IF MD%(0, 9) = 15 THEN GOSUB CHK.LOADED: IF BS < 0 THEN GOTO GET.BACK
    OF = 0
    DF = M
    GOSUB TAKE.A.SWING
    IF HIT = 0 THEN GOTO MISSED
    IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
    IF -EA <= AE THEN GOTO GET.BACK
    IF INT(100 * RND(1) + 1) <= MD%(0, 10) THEN GOTO MISSED
    A = 2
    IF EA + AE = -1 THEN A = 1
    AE = AE + A
    MD%(0, 10) = MD%(0, 10) + A
MISSED:
    IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO GET.BACK
    MD%(DF, 3) = MD%(DF, 3) / 2
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
    NEXT
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
CHK.LOADED:
    IF BS <= 0 THEN PGPRT 2, "The bazooka is not loaded.": BS = -1: RETURN
    BS = BS - 1
    IF BS = 0 THEN PGPRT 2, "This is your last shell.": AD%(32, 4) = 17
    RETURN
MON.GET.GUN:      ' MON.GET.GUN
'    -- MONSTER PICK-UP WEAPON
    IF MD%(OF, 10) = 0 THEN RETURN
    A = 0
    FOR X = 1 TO NA
    IF AD%(X, 4) = Room AND (AD%(X, 2) = 2 OR AD%(X, 2) = 3) THEN A = X: X = NA
    NEXT
    IF A = 0 THEN RETURN
    PGPRT 2, MN$(OF) + " picks up " + AN$(A) + "."
    AD%(A, 4) = -OF - 1
    MD%(OF, 9) = A
    MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5)
    MD%(OF, 4) = MD%(OF, 4) * 2
    RETURN
TAKE.A.SWING:
    HIT = 0
    IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
    IF DF = 0 AND IV THEN RETURN
    PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
    PRINT " --";
    RL = INT(100 * RND(1) + 1)
    HIT = 0
    IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = 1
    IF HIT THEN GOTO A.HIT
    IF RL < 97 THEN PGPRT 1, " A miss!": RETURN
    PGPRT 1, "A fumble!"
    FR = INT(100 * RND(1) + 1)
    IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PGPRT 1, "   fumble recovered.": RETURN
    IF FR < 76 THEN
	PGPRT 1, "  weapon dropped!"
	AD%(MD%(OF, 9), 4) = Room
	MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
	MD%(OF, 9) = -1
	MD%(OF, 4) = MD%(OF, 4) / 2
	RETURN
    END IF
    IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PGPRT 1, "Sparks fly from " + AN$(W) + "!": RETURN
    IF FR > 95 THEN GOTO SELF.OUCH
    PGPRT 1, "  weapon breaks!"
    AD%(MD%(OF, 9), 4) = 0
    MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
    MD%(OF, 9) = -1
    MD%(OF, 4) = MD%(OF, 4) / 2
    IF RND(1) > .5 THEN RETURN
    PGPRT 1, "  broken weapon hurts user!"
SELF.OUCH:
    IF FR = 100 THEN GOTO SELF.YEOW
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    DF = OF
    A = 1
    GOTO DO.DAMAGE
SELF.YEOW:
    D = MD%(OF, 11) * 2
    S = MD%(OF, 12)
    DF = OF
    A = 0
    GOTO DO.DAMAGE
A.HIT:
    INC = ABS(INT(100 * RND(1) + 1) > MD%(OF, 10))
    MD%(OF, 10) = MD%(OF, 10) + 2 * INC
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    A = 1
    IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO DO.DAMAGE
    PGPRT 1, "A critical hit!"
    R2 = INT(100 * RND(1) + 1)
    IF R2 < 51 THEN A = 0: GOTO DO.DAMAGE
    IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
    IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
    IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
    GOTO IS.DEAD
DO.DAMAGE:      ' DO.DAMAGE
    D2 = 0
    FOR D3 = 1 TO D
    D2 = D2 + INT(S * RND(1) + 1)
    NEXT
    D2 = D2 - A * MD%(DF, 8)
    IF DF > 8 AND DF < 13 AND OF = 0 AND MD%(0, 9) = 6 THEN D2 = D2 + 2
    IF D2 < 1 THEN PGPRT 1, "   blow bounces off armour.": RETURN
APPLY.DAMAGE:      ' APPLY.DAMAGE
    MD%(DF, 13) = MD%(DF, 13) + D2
    IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO DEAD.RTN
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + D2
SHOW.CONDITION:
    A$ = MN$(DF)
    ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:      ' GOOD.SHAPE
    PGPRT 2, A$ + " is still in good shape."
    RETURN
HURTING:      ' HURTING
    PGPRT 2, A$ + " is hurting."
    RETURN
IN.PAIN:      ' IN.PAIN
    PGPRT 2, A$ + " is in pain."
    RETURN
BADLY.INJURED:      ' BADLY.INJURED
    PGPRT 2, A$ + " is very badly injured."
    RETURN
DEATHS.DOOR:      ' DEATHS.DOOR
    PGPRT 2, A$ + " is at death's door, knocking loudly."
    RETURN
DEAD.RTN:
    IF DF = 0 THEN PGPRT 2, "You are dead!": DIE = -1: GOTO GAME.OVER
IS.DEAD:      ' IS.DEAD
'    /// MONSTER DIES
    PGPRT 2, MN$(DF) + " is dead!"
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
    MD%(DF, 5) = 0
    IF DF = 17 THEN RETURN
    FOR AJ = 1 TO NA
    IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = Room
    NEXT
    IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = Room: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
GET.BODY:
    IF DF = 0 THEN DIE = 1: GOTO GAME.OVER
    A2 = DF + NZ - NM
    AD%(A2, 4) = Room
    RETURN
FLEE.RTN:
    IF NBTL = 0 THEN PGPRT 2, "There's nothing to flee from!": GOTO MAIN.LOOP
    IF NX = 0 THEN PGPRT 2, "There's no place to go!": GOTO MAIN.LOOP
    IF S$ <> "" THEN
	C = 0
	FOR D = 1 TO ND
	    IF S$ = LEFT$(UCASE$(C$(D)), LEN(S$)) THEN C = D: EXIT FOR
	NEXT
	IF C > 0 THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
    END IF
    GOSUB FIND.EXIT
    GOTO MOVE.IT
FIND.EXIT:
    IF NX = 0 THEN R2 = Room: PGPRT 1, " ... but can't find an exit!": RETURN
    R2 = RD%(ND * RND(1) + 1)
    IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
    RETURN
' ---------------------------------------------------------------------------
GIVE.RTN:
    IF S$ = "" THEN GOSUB GET.SUBJ
    A = 0
    M = 0
    M$ = ""
    A$ = ""
    SEP = INSTR(S$, " TO ")
    IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
    END IF
    SEP = INSTR(S$, " ")
    IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF FOUND THEN M$ = S$: S$ = SAVE.S$: A$ = MID$(S$, SP + 1)
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
	    A$ = MID$(S$, SEP + 1)
	    M$ = LEFT$(S$, SEP - 1)
	ELSE
	    GOSUB GIVE.WHO
	    GOSUB GIVE.WHAT
	END IF
    ELSE
	GOSUB ARTIFACT.SEARCH
	IF FOUND THEN
	    A$ = AN$(A)
	ELSE
	    GOSUB MONSTER.SEARCH
	    IF FOUND THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
	    END IF
	END IF
    END IF
READY.SEARCH.GIVE:
    GOSUB GIVE.WHO
    GOSUB GIVE.WHAT
    IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
    END IF
    IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
	    S$ = A$
	    GOSUB ARTIFACT.SEARCH
	END IF
    END IF
    IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
    IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
    PGPRT 2, "I don't know what you mean."
    GOTO MAIN.LOOP
RESOLVE.GIVE:      ' RESOLVE.GIVE
    PGPRT 2, "Okay."
    POP = 0
    GOSUB GIVE.ART.MON
    IF POP <> 0 THEN GOTO MAIN.LOOP
    IF A = MD%(0, 9) THEN MD%(0, 9) = -1
    AD%(A, 4) = -M - 1
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
    IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO CHK.WGHT
GIVE.ART.MON:
 ' PUT SPECIAL CODE HERE FOR GIVING ITEM (A) TO MONSTER (M)
 ' IF MONSTER REFUSES OR SOME SPECIAL ACTION WHERE ITEM DOESN'T CHANGE
 ' HANDS OCCURS, THEN SET POP = -1 AND RETURN FROM THIS ROUTINE.
    IF A = SHDPTR OR A = ARMPTR THEN GOSUB DROP.ARMOR
    IF M = 17 AND A = 8 THEN GOSUB DROP.STEAK: POP = -1: RETURN
    RETURN
GIVE.GOLD:
    IF VAL(A$) > GOLD& THEN PGPRT 2, "You aren't carrying that much gold!": GOTO GET.BACK
    GOLD& = INT(GOLD& - VAL(A$))
    MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
    GOTO COMPLETE.GIVE
GIVE.WHO:
    IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
    RETURN
GIVE.WHAT:
    IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
    RETURN
' ---------------------------------------------------------------------------
INVENTORY.RTN:
    IF IV THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    PGPRT 2, "You are carrying the following--"
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN
	PRINT " " + AN$(A);
	IF A = MD%(0, 9) THEN PRINT " (Ready weapon)";
	IF A = ARMPTR THEN PRINT " (Worn Armor)";
	IF A = SHDPTR THEN PRINT " (Your Shield)";
	PGPRT 1, " "
    END IF
    NEXT
    PGPRT 1, STR$(GOLD&) + " gold pieces."
    IF CL = 0 THEN GOTO GET.BACK
    PRINT "The cart is also loaded."
    FOR A = 1 TO NA
     IF AD%(A, 4) = -2 THEN PGPRT 1, " " + AN$(A)
     NEXT
    GOTO GET.BACK
' --------------------------------------------------------------------------
BLAST.SPELL:
    GOSUB GET.SUBJ
    GOSUB MONSTER.SEARCH
    IF FOUND = 0 THEN GOTO BLASTED.DOOR
    S = 1
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    PGPRT 2, "Direct Hit!"
    S = 5
    D = 2
    DF = M
    A = 0
    GOSUB DO.DAMAGE
    GOTO GET.BACK
BLASTED.DOOR:
'    /// BLAST DOOR/GATE OR CONTAINER?
    TA = 1
    GOTO ASSAULT.ARTIFACT
' ---------------------------------------------------------------------------
CAST.SPELL:
    SUC = 0
    IF SA%(S) THEN RL = INT(100 * RND(1) + 1): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN SUC = 0
    IF SUC = 0 THEN PGPRT 2, "Nothing happened.": RETURN
    RL = INT(100 * RND(1) + 1)
    IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
    S2%(S) = S2%(S) * .8
    RETURN
' ---------------------------------------------------------------------------
HEAL.SPELL:
    S = 2
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
HEAL.WOUNDS:
    M = 0
    IF S$ <> "" THEN GOSUB MONSTER.SEARCH
    IF M = 0 THEN S$ = "your" ELSE S$ = MN$(M) + "'s"
    IF MD%(M, 13) THEN
	PGPRT 2, "Some of " + S$ + " wounds seem to clear up."
	MD%(M, 13) = MD%(M, 13) - INT(10 * RND(1) + 1)
    END IF
    IF MD%(M, 13) < 0 THEN MD%(M, 13) = 0
    DF = M
    GOSUB SHOW.CONDITION
    GOTO GET.BACK
' --------------------------------------------------------------------------
POWER.SPELL:
    S = 4
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    RR = INT(RND(1) * 100 + 1)
' --------------------------------------------------------------------------
SPEED.SPELL:
    S = 3
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    IF SPD <> 0 THEN PGPRT 2, "Nothing Happens.": GOTO MAIN.LOOP
    MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2)
    MD%(0, 2) = 2 * MD%(0, 2)
    SPD = SPD + INT(25 * RND(1) + 10)
    PGPRT 2, "You can feel the new agility flowing through you!"
    GOTO GET.BACK
' --------------------------------------------------------------------------
SMILE.RTN:
    IF IV THEN GOTO GET.BACK
    PGPRT 1, " "
    FOR M = 1 TO NM
      IF MD%(M, 5) = Room AND MD%(M, 15) <= 1 THEN
	  ON MD%(M, 14) GOSUB GROWLS, IGNORES, SMILES
      END IF
    NEXT
    PGPRT 1, " "
    GOTO GET.BACK
GROWLS:
    PGPRT 1, MN$(M) + " growls at you!"
    RETURN
IGNORES:
    PGPRT 1, MN$(M) + " ignores you."
    RETURN
SMILES:
    PGPRT 1, MN$(M) + " " + LCASE$(C$(C)) + "s back."
    RETURN
' --------------------------------------------------------------------------
SAY.SOMETHING:
    GOSUB GET.SUBJ
    IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
    IF S$ = "HEAL" THEN GOTO HEAL.SPELL
    IF S$ = "POWER" THEN GOTO POWER.SPELL
    IF S$ = "SPEED" THEN GOTO SPEED.SPELL
    IF S$ = "HOME" THEN R2 = 1: GOTO MOVE.IT
    PGPRT 2, "Okay, " + CHR$(34) + S$ + CHR$(34)
    IF IV THEN GOSUB RATTLE.MONSTER
    GOTO GET.BACK
' --------------------------------------------------------------------------
READY.WEAPON:
    GOSUB GET.SUBJ
    WH = -1
    HA = WH
    EMB = HA
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO MAIN.LOOP
    IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PGPRT 2, "That isn't a weapon!": GOTO MAIN.LOOP
CALCULATE.ODDS:
    MD%(0, 10) = (EA + AE) * ABS(-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
    MD%(0, 9) = A
    MD%(0, 11) = AD%(A, 7)
    MD%(0, 12) = AD%(A, 8)
    PGPRT 2, "Readied."
    GOTO GET.BACK
' --------------------------------------------------------------------------
OPEN.RTN:
    GOSUB GET.SUBJ
    POP = 0
    GOSUB CHK.OPEN.SPECIAL
    IF POP THEN GOTO MAIN.LOOP
    WH = Room
    HA = -1
    EMB = Room + EMB.ADJ
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN GOTO OPEN.DOOR
    IF A = 28 THEN GOTO OPEN.CONTAINER
    IF A = 22 THEN GOTO OPEN.CONTAINER
    IF S$ = "DOOR" OR S$ = "GATE" THEN PGPRT 2, "It will open when you approach.": GOTO MAIN.LOOP
    PGPRT 2, "That's not what you do with it."
    GOTO MAIN.LOOP
OPEN.CONTAINER:
    IF A = 28 THEN AD%(28, 4) = 0: MD%(30, 5) = Room: R3 = Room: GOSUB CHK.REACTIONS: GOTO MAIN.LOOP
    PGPRT 2, "You stumble upon some guard's stolen loot."
    AD%(24, 4) = Room
    GOTO GET.BACK
OPEN.DOOR:
    IF S$ = "DOOR" OR S$ = "GATE" THEN PGPRT 2, "Doors will open when approached.": GOTO GET.BACK
    PGPRT 2, "I don't know how to open that."
    GOTO GET.BACK
ASSAULT.ARTIFACT:
    IF TA = 0 THEN PGPRT 2, "Attack who?": GOTO MAIN.LOOP
    PGPRT 2, "You can't blast " + LCASE$(S$) + "!"
    GOTO MAIN.LOOP
CHK.OPEN.SPECIAL:
    RETURN
' --------------------------------------------------------------------------
PUT.RTN:
    IF S$ = "" THEN GOTO GET.PUT.DATA
    IF INSTR(S$, " INTO") > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 6): GOTO PUT.AWAY
    IF INSTR(S$, " IN") > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 3): GOTO PUT.AWAY
GET.PUT.DATA:      ' GET.PUT.DATA
    PGPRT 1, " "
    INPUT "Put what?", A$
    INPUT "Put into what?", B$
    PGPRT 2, ""
    GOTO PUT.AWAY
PUT.AWAY:
    S$ = A$
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.UNDERSTAND
    Z = A
    S$ = B$
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 OR A = Z THEN GOTO PUT.WHAT
    IF AD%(A, 2) = 4 THEN AD%(X, 4) = A + INS.ADJ: PGPRT 2, "Okay.": GOTO GET.BACK
PUT.WHAT:      ' PUT.WHAT
    PGPRT 2, "You can't do that."
    GOTO GET.BACK
' ---------------------------------------------------------------------------
READ.RTN:
    IF IC <> 0 AND DD = 0 THEN PGPRT 2, "You can't see.": GOTO MAIN.LOOP
    GOSUB GET.SUBJ
    WH = Room
    HA = -1
    EMB = Room + EMB.ADJ
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN GOTO READ.NONART
    IF A = 1 THEN GOTO READ.DIARY
    IF A = 2 THEN GOTO READ.SCROLL
READ.SCROLL:
    PGPRT 2, "The scroll is a letter from J.B. Hero. It mentions a treasure in the castle.": PRINT "From the letter you can tell that he is not the type of person to set a"
    PGPRT 1, "trap for an adventurer unless he gave them some chance for survival."
    PGPRT 1, "After you read the scroll, it disintegrates."
    AD%(2, 4) = 0
    GOTO MAIN.LOOP
READ.DIARY:
    PGPRT 2, "The diary was written by a member of the Guild of Free Adventurers"
    PGPRT 1, "It tells of finding a treasure. It tells of finding secret passages"
    PGPRT 1, "It tells of marking the way. It tells of A-A-AR-G-G"
    PGPRT 1, "The rest is smeared with red stains."
    GOTO MAIN.LOOP
    IF AD%(A, 2) = 7 THEN GOTO READ.ARTIFACT
    PGPRT 2, "You can't read it."
    GOTO GET.BACK
READ.NONART:
'   ...  NON-ART - INSERT HERE SPECIAL READING ...
'   ...  EXAMPLE: READING WALLS OR CEILING, DOORS, ETC ...
    GOTO DONT.UNDERSTAND
READ.ARTIFACT:
'    /// READING A READABLE ARTIF.
    R = AD%(A, 5) + AD%(A, 7) - 1
    GOSUB PRINT.EFFECT
    AD%(A, 7) = AD%(A, 7) + 1
    IF AD%(A, 7) > AD%(A, 6) THEN AD%(A, 7) = 1
    GOTO GET.BACK
' --------------------------------------------------------------------------
PRINT.EFFECT:
    GET #2, R + EFF.ADJ
    A$ = RTRIM$(Desc$)
    PGPRT 2, A$
    RETURN
' --------------------------------------------------------------------------
FREE.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.UNDERSTAND
    IF AD%(A, 2) <> 10 THEN GOTO DONT.UNDERSTAND
    M = AD%(A, 5)
    K = AD%(A, 6)
    G = AD%(A, 7)
    IF AD%(A, 4) <> Room THEN PGPRT 2, "I don't know what you are talking about.": GOTO MAIN.LOOP
    IF MD%(G, 5) = Room THEN PGPRT 2, MN$(G) + " won't let you do that!": GOTO GET.BACK
    IF AD%(K, 4) <> -1 AND K <> 0 THEN PGPRT 2, "You don't have the key!": GOTO MAIN.LOOP
    PGPRT 2, "You have freed " + MN$(M) + "."
    MD%(M, 5) = Room
    AD%(A, 4) = 0
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
' ---------------------------------------------------------------------------
USE.RTN:
      GOSUB GET.SUBJ
      GOSUB ARTIFACT.SEARCH
      IF FOUND = 0 THEN PGPRT 2, "I don't see any " + S$ + "!": GOTO MAIN.LOOP
      IF A <> 6 THEN GOTO USE.FIRST.AID
      PRINT "What do you want to put on the cart?"
      INPUT " :", S$
      S$ = UCASE$(S$)
      GOSUB ARTIFACT.SEARCH
      IF FOUND = 0 THEN PGPRT 2, "I don't see any " + S$ + ".": GOTO MAIN.LOOP
      AD%(A, 4) = -2
      PGPRT 2, "Okay."
      GOTO GET.BACK
USE.FIRST.AID:
      IF A <> 13 THEN GOTO USE.ELEVATOR
      IF MD%(0, 13) = 0 THEN PGPRT 2, "You aren't hurt, and shouldn't play with band-aids!": GOTO MAIN.LOOP
      IF FA < 0 THEN PGPRT 2, "There is nothing in the first aid kit.": GOTO GET.BACK
      PRINT "You feel better. The bleeding has stopped."
      MD%(0, 13) = MD%(0, 13) - 5
      FA = FA - 1
      IF FA < 0 THEN PRINT "The first aid kit is now empty."
      IF MD%(0, 13) < 0 THEN MD%(0, 13) = 1: PRINT "You feel almost like new": GOTO GET.BACK
      GOTO GET.BACK
USE.ELEVATOR:
      IF A <> 33 THEN GOTO USE.CUBE
      IF Room = 22 THEN R2 = 63: AD%(33, 4) = 63: GOTO MOVE.IT
      IF Room = 63 THEN R2 = 22: AD%(33, 4) = 22: GOTO MOVE.IT
      PGPRT 2, "What elevator?"
      GOTO MAIN.LOOP
USE.CUBE:
      IF A <> 23 THEN GOTO USE.SLEEP
      IF BC = 0 THEN BC = 1: PGPRT 2, "You have stumbled upon the magic of instantaneous transportation!!": PRINT "BUT BE WARNED!! You may not like where it will take you."
      PGPRT 2, "You feel a strange wrench in your stomach."
      PGPRT 1, "Everything goes black for a second. You find yourself back to reality."
      R2 = INT(RND(1) * NR + 1)
      GOTO MOVE.IT
USE.SLEEP:
      IF A <> 26 THEN GOTO USE.SHELLS
      PGPRT 2, "You fall asleep. Goodnight."
      MD%(0, 5) = 12
      IF DY > 0 THEN PGPRT 2, "The sleeping pills counteracted the poison you took!!": DY = 0
      GOTO GET.BACK
USE.SHELLS:
      IF A <> 32 THEN GOTO USE.HYPO
      BS = 12
      PGPRT 2, "You have loaded the bazooka!"
      GOTO GET.BACK
USE.HYPO:
      IF A <> 36 THEN PGPRT 2, "I don't know how to use that.": GOTO MAIN.LOOP
      PGPRT 2, "You have accidentally injected yourself with an experimental"
      PGPRT 1, "hardiness booster."
      HADD = INT(RND(1) * 5 + 1)
      MD%(0, 1) = HADD
      FD%(3) = FD%(3) + HADD
      IF NOT HY THEN FOR X = 1 TO 5000: NEXT X: GOTO HYDE.POTION
      GOTO GET.BACK
EAT.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO NOT.HUNGRY
    IF AD%(A, 2) <> FOOD.ART THEN GOTO NOT.HUNGRY
    PGPRT 2, "Okay. You eat the " + LCASE$(AN$(A)) + "."
    AD%(A, 4) = 0
    GOTO GET.BACK
NOT.HUNGRY:
    PGPRT 2, "You aren't THAT hungry!"
    GOTO GET.BACK
' ---------------------------------------------------------------------------
DRINK.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN PGPRT 2, "I don't understand.": GOTO MAIN.LOOP
    IF A = 27 THEN GOTO DRINK.SPECIAL
    IF AD%(A, 2) <> 6 THEN PGPRT 2, "You can't do that!": GOTO MAIN.LOOP
    IF AD%(A, 7) <= 0 THEN PGPRT 2, "There isn't any left.": GOTO GET.BACK
    IF AD%(A, 5) > FNR(100) THEN GOTO DRINK.HEAL
    PGPRT 2, "Nothing seems to happen."
    GOTO GET.BACK
DRINK.HEAL:
    AD%(A, 7) = AD%(A, 7) - 1
    MD%(0, 13) = MD%(0, 13) - AD%(A, 6)
    IF MD%(0, 13) < 0 THEN MD%(0, 13) = 0
    PGPRT 2, "Your wounds seem to " + MID$("openheal", ABS(AD%(A, 6) > 0) * 4 + 1, 4) + "!"
    GOTO GET.BACK
DRINK.SPECIAL:
      PT = RND(1) * 100
      PGPRT 2, "The potion was untested until now."
      IF TS$ <> "T" THEN AD%(27, 4) = 0: AD%(29, 4) = -1
      IF PT > 90 THEN GOTO AGIL.POTION
      IF PT > 70 THEN GOTO TELEPOTION
      IF PT > 50 THEN GOTO HYDE.POTION
      IF PT > 30 THEN GOTO LAUGH.POTION
      IF PT > 10 THEN GOTO POISON
      PGPRT 2, "It tastes like swamp water!!"
      GOTO GET.BACK
AGIL.POTION:
      PGPRT 2, "It has increased your agility!!"
      MD%(0, 2) = MD%(0, 2) + INT(RND(1) * 5)
      GOTO GET.BACK
TELEPOTION:
      CLS
      LOCATE 10, 6
      PGPRT 2, "The room goes black!!"
      FOR X = 1 TO 2000: NEXT
      CLS
      FOR X = 1 TO 10000: NEXT
      PGPRT 1, "You have blacked out. You are now reviving."
      PGPRT 1, "You feel like somebody tore you apart and put you back together again."
      R2 = 12
      GOTO MOVE.IT
HYDE.POTION:
      CLS
      PGPRT 2, "You choke and gasp !!"
      PGPRT 1, "You begin to grow hair in places that you didn't have hair on before!"
      PGPRT 1, "Your nose has gotten bigger, not to mention your teeth!! You have become"
      PGPRT 1, "a Mr. Hyde!!"
      PGPRT 2, "Your charisma is down, your hardiness is up! "
      MD%(0, 1) = MD%(0, 1) * 2
      MD%(0, 3) = MD%(0, 3) / 2
      FOR A = 1 TO NM
      IF MD%(A, 14) = 3 THEN MD%(A, 14) = 0: MD%(A, 3) = MD%(A, 3) / 2: MD%(A, 4) = MD%(A, 4) / 2
      NEXT A
      PGPRT 2, "You make your friends nervous."
      R3 = Room
      GOSUB CHK.REACTIONS
      PGPRT 2, "The potion should wear off sooner or later (You hope!)."
      HY = 1
      HP = RND(1) * 30 + 9
      MN$ = MN$(0)
      MN$(0) = "MR. HYDE"
      GOTO GET.BACK
LAUGH.POTION:
      PGPRT 2, "You hear a shrill laughing, but cannot tell where it is coming from."
      GOTO GET.BACK
POISON:
      PGPRT 2, "The potion was not perfected. You have drunk poison!"
      PGPRT 2, "You have one hour to find the antidote."
      DY = 1
      DP = 44
      PGPRT 2, "(That is about " + STR$(DP) + " commands.)"
      GOTO GET.BACK
' ---------------------------------------------------------------------------
WEAR.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.WEAR
    IF AD%(A, 2) = ARMOR.ART THEN GOTO WEAR.ARMOR
WEAR.SOMETHING:
 ' ..... INSERT HERE SPECIAL WORN ARTIFACTS ...
    GOTO DONT.WEAR
WEAR.ARMOR:
    EA = -AD%(A, 5)
    MD%(0, 8) = AD%(A, 7)
    PGPRT 2, "Okay. You have put on the " + AN$(A) + "."
    GOTO GET.BACK
DONT.WEAR:
    PGPRT 2, "You can't wear that and stay respectable."
    GOTO MAIN.LOOP
' ---------------------------------------------------------------------------
SAVE.GAME:
    INPUT "Do you want to save this game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO SAVE.IT
    GOTO MAIN.LOOP
SAVE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
    REM $INCLUDE: '\EAMON\copy\SAVEGAME.BAS'
    PRINT "Game is saved. To restore it, use restore command."
    SAVED = -1
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MAIN.LOOP
RESTORE.GAME:
    INPUT "Do you want to Restore a game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO RESTORE.IT
    GOTO MAIN.LOOP
RESTORE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
    REM $INCLUDE: '\EAMON\COPY\RESTGAME.BAS'
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MOVE.IT
GET.GAME.ID:
    PRINT
    INPUT "File Name: ", GAME.ID$
    IF LEN(GAME.ID$) > 8 THEN GOTO GET.GAME.ID
    GAME.ID$ = UCASE$(GAME.ID$)
    IF LEFT$(GAME.ID$, 1) < "A" OR LEFT$(GAME.ID$, 1) > "Z" THEN GOTO GET.GAME.ID
    GAME.ID$ = GAME.ID$ + ".GAM"
    RETURN
' ---------------------------------------------------------------------------
    REM $INCLUDE: '\EAMON\COPY\CHARIO.BAS'
    REM $INCLUDE: '\Eamon\COPY\ADVENIO.OLD'

SUB PGPRT (SP, LIT$)
STATIC PG.CNT
    IF SP = 0 THEN PG.CNT = 0: EXIT SUB
    IF LIT$ = "" THEN PG.CNT = PG.CNT + SP: EXIT SUB
    IF PG.CNT > 18 THEN
	LOCATE 24, 1
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-");
	A$ = INPUT$(1)
	PG.CNT = 0
	LOCATE CSRLIN, 1
	PRINT SPC(79);
    END IF
    IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	PG.CNT = PG.CNT + 1
	NEXT
    END IF
    PRINT LIT$
    PG.CNT = PG.CNT + INT(LEN(LIT$) / 80) + 1
END SUB

