'
'                     Eamon Adventure #9
'              -> Assault on the CloneMaster <-
'
'        Original By Donald Brown - IBM Version By John Nelson
'
'                     Revised 12-05-99
'
DECLARE SUB PGPRT (SP, LIT$)
    DEFINT A-Z
    DIM FF AS STRING * 30
REM $$INCL:'\EAMON\COPY\CHARDEF.BAS'
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
	'   Module:  CHARDEF.BAS
	'   Eamon Version:  Eamon-QB (or Eamon-PC)
	' ------------------------------------------------------------
	'  Character Definition for Eamon QB/PC
	'        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
	'                        or BASIC 7.0 PDS
	'       uses Field statements for record description
	'       This module will work for QBasic, but QBasic cannot
	'       support $INCLUDE: statements, so module must be copied
	'       into programs manually or merged using a utility
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
TYPE WeaponRec
	Nam             AS STRING * 20
	Wpntyp          AS INTEGER
	Odds            AS INTEGER
	Dice            AS INTEGER
	Sides           AS INTEGER
END TYPE

TYPE CharacterRecord
	Nam             AS STRING * 30
	Hd              AS INTEGER
	Ag              AS INTEGER
	Ch              AS INTEGER
	SA1             AS INTEGER
	SA2             AS INTEGER
	SA3             AS INTEGER
	SA4             AS INTEGER
	WA1             AS INTEGER
	WA2             AS INTEGER
	WA3             AS INTEGER
	WA4             AS INTEGER
	WA5             AS INTEGER
	Sex             AS STRING * 1
	Gold            AS LONG
	Bank            AS LONG
	AE              AS INTEGER
	ArmNam          AS STRING * 20
	ArmHit          AS INTEGER
	Armadj          AS INTEGER
	ShdNam          AS STRING * 20
	ShdHit          AS INTEGER
	ShdAdj          AS INTEGER
	Wpn1Nam         AS STRING * 20
	Wpn1typ         AS INTEGER
	Wpn1Wpntyp      AS INTEGER
	Wpn1odds        AS INTEGER
	Wpn1Dice        AS INTEGER
	Wpn1Sides       AS INTEGER
	Wpn2Nam         AS STRING * 20
	Wpn2typ         AS INTEGER
	Wpn2Wpntyp      AS INTEGER
	Wpn2odds        AS INTEGER
	Wpn2Dice        AS INTEGER
	Wpn2Sides       AS INTEGER
	Wpn3Nam         AS STRING * 20
	Wpn3typ         AS INTEGER
	Wpn3Wpntyp      AS INTEGER
	Wpn3odds        AS INTEGER
	Wpn3Dice        AS INTEGER
	Wpn3Sides       AS INTEGER
	Wpn4Nam         AS STRING * 20
	Wpn4typ         AS INTEGER
	Wpn4Wpntyp      AS INTEGER
	Wpn4odds        AS INTEGER
	Wpn4Dice        AS INTEGER
	Wpn4Sides       AS INTEGER
	Filler          AS STRING * 23
END TYPE
DIM Char AS CharacterRecord
TYPE CharControl
	NbrChar         AS INTEGER
	Filler          AS STRING * 254
END TYPE
DIM CharCtl AS CharControl

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\EAMON\COPY\COLORRTN.BAS'
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     GOTO Colorset
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
Colorset:

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\EAMON\COPY\ADVRECS.BAS'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  ADVRECS.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Adventure I/O Routines for Eamon Base Adventure Program
        '       Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        BASIC 7.0 PDS
        '       Record definition for ADVENIO2.BAS Adventure I/O routines
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        TYPE MonsterRec
           Nam          AS STRING * 30
           HD           AS INTEGER
           AG           AS INTEGER
           FRIEND       AS INTEGER
           courage      AS INTEGER
           Room         AS INTEGER
           Weight       AS INTEGER
           DefOdds      AS INTEGER
           Armor        AS INTEGER
           Weapon       AS INTEGER
           OffOdds      AS INTEGER
           Dice         AS INTEGER
           Sides        AS INTEGER
           filler       AS STRING * 72
        END TYPE
        TYPE ArtifactRec
           Nam          AS STRING * 30
           Value        AS INTEGER
           Typ          AS INTEGER
           Weight       AS INTEGER
           Room         AS INTEGER
           Odds         AS INTEGER
           Wpntyp       AS INTEGER
           Dice         AS INTEGER
           Sides        AS INTEGER
           Owner        AS INTEGER
           filler       AS STRING * 78
        END TYPE
        TYPE RoomRec
           North        AS INTEGER
           South        AS INTEGER
           East         AS INTEGER
           West         AS INTEGER
           Up           AS INTEGER
           Down         AS INTEGER
           NE           AS INTEGER
           NW           AS INTEGER
           SE           AS INTEGER
           SW           AS INTEGER
           Light        AS INTEGER
           Floor        AS INTEGER
           Air          AS INTEGER
           Temp         AS INTEGER
           filler       AS STRING * 36
        END TYPE
        TYPE DescRec
            Desc        AS STRING * 256
        END TYPE
        DIM Artifact AS ArtifactRec
        DIM Monster AS MonsterRec
        DIM Rm AS RoomRec
        DIM Dsc AS DescRec

    '------- (end of include file) -------    
 ' 
    RANDOMIZE TIMER
    DEF FNR (X) = (INT(X * RND(1)) + 1)
    CLS
REM $$INCL:'\EAMON\COPY\READCTL.BAS'
     CLOSE 1
     OPEN "DESC.R0" FOR INPUT AS #1
     INPUT #1, NR
     INPUT #1, NZ
     INPUT #1, NE
     INPUT #1, NM
     INPUT #1, ND
     INPUT #1, MAX.RM
     INPUT #1, MAX.ART
     INPUT #1, MAX.EFF
     INPUT #1, Max.Mon
     INPUT #1, Rm.Len
     INPUT #1, Rmn.Len
     INPUT #1, Mon.Len
     INPUT #1, Art.Len
     INPUT #1, Desc.Len
     INPUT #1, Mon.Flds
     INPUT #1, Art.Flds
     INPUT #1, RM.Flds
     INPUT #1, MN.Len
     INPUT #1, AN.Len
     CLOSE 1
     NA = NZ
     ART.ADJ = MAX.RM
     EFF.ADJ = MAX.RM + MAX.ART
     MON.ADJ = MAX.RM + MAX.ART + MAX.EFF
     EMB.ADJ = MAX.RM + MAX.ART
     INS.ADJ = MAX.RM
     HID.ADJ = MAX.RM * 2 + MAX.ART
     BURY.ADJ = MAX.RM * 3 + MAX.ART

    '------- (end of include file) -------    
 ' 
    DIM AN$(NA + 6), AD%(NA + 6, 9)
    DIM MN$(NM), MD%(NM, 15)
    DIM FD%(3), TD%(3), SA%(4), WA%(5), S2%(4), RD%(10), RF.DIR$(10)
    DIM CW(22)
    GOSUB READ.ARTIFACTS
    NW = NW + 6
    DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
    READ NC
    DIM C$(NC)
    FOR C = 1 TO NC
    READ C$(C)
    NEXT
    DIM V%(NR)
    GOTO INITIALIZE.RTN
Main.Loop:
    PGPRT 1, " "
    IF SPD > 0 THEN SPD = SPD - 1: IF SPD = 0 THEN MD%(0, 2) = MD%(0, 2) / 2: MD%(0, 10) = MD%(0, 10) - 2 * MD%(0, 2): IF RND(1) > .8 THEN PGPRT 2, "Your Speed spell has just expired!"
    IF INT(V%(Room) / 2) <> V%(Room) / 2 THEN
	PGPRT 2, "You are " + RN$
    END IF
    IF INT(V%(Room) / 2) = (V%(Room) / 2) THEN
	GET #2, Room
	A$ = RTRIM$(DESC$)
	PGPRT 2, A$
	V%(Room) = V%(Room) + 1
    END IF
145 IF F1 AND Room = 26 THEN PRINT "You see a secret passage to the north!": PRINT
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room THEN
	IF MD%(M, 15) = 0 THEN
	    GET #2, M + 300
	    A$ = RTRIM$(DESC$)
	    PGPRT 2, A$
	    MD%(M, 15) = 1
	ELSE
	    PGPRT 2, MN$(M) + " is here."
	END IF
    END IF
    NEXT
    FOR A = 1 TO NZ
      IF AD%(A, 4) = Room THEN
	IF AD%(A, 9) = 0 THEN
	    GET #2, A + 100
	    A$ = RTRIM$(DESC$)
	    PGPRT 2, A$
	    AD%(A, 9) = 1
	ELSE
	    PGPRT 2, "You see " + AN$(A) + "."
	END IF
      END IF
    NEXT
    FOR A = A TO NA
	IF AD%(A, 4) = Room THEN PGPRT 2, "Your " + AN$(A) + " is here."
    NEXT
GET.COMMAND:
    PGPRT 0, " "
    PGPRT 1, " "
    COLOR hfg%, hbg%
    PRINT " Your Command ";
    COLOR fgc%, bgc%
    LINE INPUT " ", A$
    A$ = LTRIM$(RTRIM$(A$))
    IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 16: PRINT A$
    IF A$ = "" THEN GOTO LIST.COMMANDS
    A$ = UCASE$(A$)
    CZ$ = A$
    V$ = ""
    A = INSTR(A$, " ")
    IF A > 0 THEN V$ = LEFT$(A$, A - 1): S$ = MID$(A$, A + 1)
    IF A = 0 THEN V$ = A$: S$ = ""
    S$ = LTRIM$(S$)
    C = 0
    FOR X = 1 TO 6
    IF LEFT$(UCASE$(C$(X)), LEN(V$)) = V$ THEN C = X
    NEXT
    IF C > 0 THEN GOTO APPROP.RTN
    F = 0
    FOR X = 7 TO NC
    IF UCASE$(C$(X)) = V$ THEN C = X: F = 1: X = NC: GOTO NEXT.CMD
    IF LEFT$(UCASE$(C$(X)), LEN(V$)) = V$ THEN F = F + 1: C = X
NEXT.CMD:
    NEXT
    IF F = 1 THEN GOTO APPROP.RTN
LIST.COMMANDS:
    PRINT
    PRINT "Huh? I only understand these commands --- ";
    FOR C = 1 TO NC
    PRINT C$(C); SPC(20 - LEN(C$(C)));
    NEXT
    PRINT
    PRINT
    GOTO GET.COMMAND
    IF C$(C) = S$ THEN S$ = V$: V$ = C$(C)
APPROP.RTN:
    ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 6 GOTO GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN, LOOK.RTN, ATTACK.RTN
    ON C - 12 GOTO FLEE.RTN, GIVE.RTN, INVENTORY.RTN, BLAST.SPELL, HEAL.SPELL
    ON C - 17 GOTO POWER.SPELL, SPEED.SPELL, SMILE.RTN, SMILE.RTN, SAY.SOMETHING
    ON C - 22 GOTO READ.RTN, READY.WEAPON, LIGHT.RTN, OPEN.RTN, PUT.RTN
    ON C - 27 GOTO DRINK.RTN, FREE.RTN, ENTER.RTN, TROLLSFIRE, DESTROY.IT
GET.BACK:
REM $$INCL:'\EAMON\COPY\NEWBATL.BAS'
    IF TT > 0 THEN TT = TT - 1: GOTO End.Battle
    IF NBTL = 0 THEN GOTO End.Battle
    FOR M = 1 TO NM
        IF MD%(M, 5) = ROOM AND TT = 0 THEN
            MR = FD%(MD%(M, 14)) / TD%(MD%(M, 14)) - FD%(4 - MD%(M, 14)) / TD%(4 - MD%(M, 14)) / 5 + INT(41 * RND(1) - 20)
            IF MD%(M, 4) < MR THEN
                GOSUB Find.Exit
                IF R2 > 0 THEN
                    PGPRT 2, MN$(M) + " flees!"
                    GOSUB MONSTER.LEAVES
                    EXIT FOR
                END IF
            END IF
            IF MD%(M, 14) = 3 THEN
                GOSUB GoodGuys.Attack
            ELSE
                GOSUB BadGuys.Attack
            END IF
        END IF
        NBTL = (FD%(1) < TD%(1))
        IF NBTL = 0 THEN EXIT FOR
    NEXT M
End.Battle:
    IF TT > 0 THEN TT = TT - 1
    GOTO End.Loop
BadGuys.Attack:
    OF = M
    IF TD%(1) = MD%(0, 1) THEN DF = 0: GOSUB Take.a.Swing: RETURN
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 3 AND RND(1) < .25 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    IF DF < 0 THEN DF = 0: GOSUB Take.a.Swing
    RETURN
GoodGuys.Attack:
    OF = M
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 1 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    RETURN
End.Loop:

    '------- (end of include file) -------    
 ' 
510   REM ///MOVE IN GUARDS
520   FOR M = 23 TO 43
      IF MD%(M, 5) = 0 OR MD%(M, 5) = Room OR RND(1) > .25 THEN 790
530   GET #6, (Room - 1) * 30 + MD%(M, 5)
      A = CVI(DF.DIRPT$)
      GET #1, MD%(M, 5)
      A3 = CVI(RF.DIR$(A))
540   MD%(M, 5) = A3
      IF A3 = Room THEN PGPRT 2, "" + MN$(M) + " entered the room!": PRINT
790   NEXT M
      R3 = Room
      GOSUB Chk.Reactions
800  IF AD%(10, 4) = 0 THEN GOTO Main.Loop
810  CT = CT - 1
     IF CT > 0 THEN GOTO Main.Loop
820  CT = 4
     IF CW = 0 THEN GOTO Main.Loop
830  M = CW(1)
     FOR A = 1 TO CW - 1
	 CW(A) = CW(A + 1)
     NEXT
     CW = CW - 1
840  MD%(M, 5) = 30
     MD%(M, 13) = 0
     IF Room = 30 THEN
	 PGPRT 2, MN$(M) + " steps out of the Clonatorium!"
	 R3 = Room
	 GOSUB Chk.Reactions
    END IF
    Room = 1
    GOTO Move.It
REM $$INCL:'\EAMON\COPY\MONLEAVE.BAS'
MONSTER.LEAVES:
    MD%(M, 5) = R2
    M2 = MD%(M, 14)
    TD%(M2) = TD%(M2) - MD%(M, 1)
    FD%(M2) = FD%(M2) - MD%(M, 13)
    NBTL = (FD%(1) < TD%(1))
    RETURN

    '------- (end of include file) -------    
 ' 
INITIALIZE.RTN:
    GOSUB READ.MONSTERS
REM $$INCL:'\Eamon\COPY\READMEAT.BAS'
    OPEN "MEAT" FOR INPUT AS #2
    INPUT #2, Nbr.Party
    INPUT #2, REC
    INPUT #2, MN$(0)
    INPUT #2, MD%(0, 1)
    INPUT #2, MD%(0, 2)
    INPUT #2, MD%(0, 3)
    CH = MD%(0, 3)
    FOR X = 1 TO 4
    INPUT #2, SA%(X)
    S2%(X) = SA%(X)
    NEXT
    FOR X = 1 TO 5
    INPUT #2, WA%(X)
    NEXT
    INPUT #2, SEX$
    INPUT #2, GOLD&
    INPUT #2, BANK&
    INPUT #2, AE
    INPUT #2, ArmNam$
    INPUT #2, ArmHit
    INPUT #2, ArmAdj
    INPUT #2, ShdNam$
    INPUT #2, ShdHit
    INPUT #2, ShdAdj
    FOR X = 1 TO 4
      INPUT #2, A$
      IF RTRIM$(A$) = "" THEN A$ = "NONE"
      WN$(X) = A$
      INPUT #2, WT%(X)
      INPUT #2, WC%(X)
      INPUT #2, WD%(X)
      INPUT #2, WS%(X)
      IF A$ <> "NONE" THEN
          NA = NA + 1
          AN$(NA) = WN$(X)
          AD%(NA, 2) = 2
          AD%(NA, 3) = 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
      END IF
    NEXT
    IF ArmHit <> 0 THEN
          WN$(5) = ArmNam$ + " Armor"
          WT%(5) = 1
          WD%(5) = ArmHit
          WC%(5) = ArmAdj
          NA = NA + 1
          MD%(0, 8) = ArmHit
          Armptr = NA
          AN$(NA) = WN$(5)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    IF ShdHit <> 0 THEN
          WN$(6) = ShdNam$ + " Shield"
          WT%(6) = 2
          WD%(6) = ShdHit
          WC%(6) = ShdAdj
          NA = NA + 1
          MD%(0, 8) = MD%(0, 8) + ShdHit
          Shdptr = NA
          AN$(NA) = WN$(6)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    INPUT #2, MastPath$
    CLOSE 2
    EA = -(ArmAdj + ShdAdj)
    MD%(0, 8) = ArmHit + ShdHit
    IF NA > NZ THEN
        MD%(0, 10) = MD%(0, 2) * 2 + WC%(1) + WA%(WT%(1)) + (EA + AE) * ABS(-EA > AE)
        MD%(0, 7) = 0
        MD%(0, 9) = NZ + 1
        MD%(0, 11) = WD%(1)
        MD%(0, 12) = WS%(1)
        MD%(0, 14) = 3
    END IF

    '------- (end of include file) -------    
 ' 
    GOSUB OPEN.DESC
    GOSUB OPEN.RMNAMES
    GOSUB OPEN.ROOMS
     Room = 1
     ND = 6
     R2 = 1
1160  OPEN "DIRECT.TXT" FOR RANDOM AS #6 LEN = 2
      FIELD 6, 2 AS DF.DIRPT$
1170 CW = 0: CT = 4
    GOTO Move.It
GET.OVERRIDE:
    PRINT
    PRINT "(PRESS ANY KEY TO CONTINUE) ";
    A$ = INPUT$(1)
    PRINT
    IF A$ = CHR$(15) THEN OV = -1: RETURN
    OV = 0
    RETURN
    DATA 32
    DATA NORTH,SOUTH,EAST,WEST,UP,DOWN,GET,TAKE,DROP
    DATA LOOK,EXAMINE,ATTACK,FLEE,GIVE,INVENTORY
    DATA BLAST,HEAL,POWER,SPEED,SMILE,WAVE,SAY,READ
    DATA READY,LIGHT,OPEN,PUT,DRINK
    DATA FREE,ENTER,TROLLSFIRE
    DATA  DESTROY
Game.Over:
    PRINT
    PRINT "(HIT ANY KEY TO CONTINUE)   ";
    A$ = INPUT$(1)
    PRINT
CLOSE.DOWN:
    CLOSE
    IF SPD > 0 THEN MD%(0, 2) = MD%(0, 2) / 2
    IF DIE THEN GOTO GET.MASTER
    FOR W = 1 TO 4
    WN$(W) = "NONE"
    NEXT
    W2 = 1
    FOR A = 1 TO NA
    IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 AND AD%(A, 4) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, 4) = 0
    NEXT A
    IF W2 < 6 THEN GOTO SELL.TREASURE
SELL.WEAPONS:
    CLS
    LOCATE 5, 1
    PRINT "As you start to enter the Main Hall, Lord William Misslefire appears and"
    PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
    PRINT
    PRINT "Your weapons are--"
    FOR W = 1 TO W2 - 1
    PRINT SPC(4); W; "--"; WN$(W)
    NEXT
    PRINT
    PRINT "Enter the number of the weapon to sell     (1-"; W2 - 1; ") "
GET.NBR.SELL:
    LOCATE CSRLIN - 1, 52
    INPUT A$
    W5 = VAL(A$)
    IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO GET.NBR.SELL
    AD%(WP%(W5), 4) = -1
    WN$(W5) = WN$(W2 - 1)
    WP%(W5) = WP%(W2 - 1)
    W2 = W2 - 1
    IF W2 > 5 THEN GOTO SELL.WEAPONS
SELL.TREASURE:
    FOR W = 1 TO 4
    IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
    NEXT W
    CLS
    LOCATE 5, 1
    PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
    PRINT "things, he examines your goods and pays you ";
    TP = 0
    FOR A = 1 TO NA
    IF A = ArmPtr OR A = ShdPtr THEN GOTO NEXT.TREAS
    IF AD%(A, 4) <> -1 THEN GOTO NEXT.TREAS
    IF AD%(A, 2) <> 0 THEN AD%(A, 1) = AD%(A, 1) * CH / 10
    TP = TP + AD%(A, 1)
NEXT.TREAS:
    NEXT A
    PRINT TP; " gold pieces."
    PRINT
    PRINT "The rebels gave you some small sheets of green paper with lots of zeros on it as a reward, you threw it away as valueless."
    GOLD& = GOLD& + TP
    IF GOLD& < 0 THEN GOLD& = 0
    PRINT
    IF MD%(9, 5) = Room THEN
	reward = INT(RND(1) * 90 + 15)
	PRINT "You are also given "; reward; " gold pieces for the safe return of"
	PRINT "Cynthia."
    END IF
    PRINT "(HIT ANY KEY TO CONTINUE)  ";
    A$ = INPUT$(1)
    PRINT
GET.MASTER:
    CLS
    LOCATE 5, 1
 '  PRINT "  Insert Eamon Master Diskette, and press <RETURN>  OR     "
 '  PRINT
 '  PRINT "  Enter Path of Master ===> ";
 '  INPUT "", MastPath$
    IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
    IF MastPath$ <> "" THEN CHDIR MastPath$
    ON ERROR GOTO Invalid.Path
    IF DIE THEN KILL "ADVENT": GOTO RUN.HALL
    CLOSE
    GOSUB OPEN.CHARACTERS
    Nam$ = MN$(0)
    HD = MD%(0, 1)
    AG = MD%(0, 2)
    GOSUB WRITE.CHARACTER
    OPEN Path$ + "ADVENT" FOR OUTPUT AS #2
    WRITE #2, MN$(0)
    WRITE #2, REC
    CLOSE
RUN.HALL:
    RUN "HALL"
Invalid.Path:
    PRINT
    PRINT "Invalid Path, or Master Not Found. Please re-try ..."
    PRINT " (press any key to continue)";
    A$ = INPUT$(1)
    RESUME GET.MASTER
MOVE.RTN:
3010  IF NBTL AND S$ <> "FLEE" THEN
	PGPRT 2, "You don't want to turn your back here."
	GOTO Main.Loop
    END IF
    R2 = RD%(C)
    IF R2 > 100 THEN GOTO PASSAGE.BLOCKED
CHK.MOVE:
    IF R2 > 0 THEN GOTO Move.It
' ///SPECIAL MOVES
    IF R2 = -99 THEN
	PGPRT 2, "You successfully ride off into the sunset."
	GOTO Game.Over
    END IF
    IF R2 = -27 AND F1 THEN R2 = ABS(R2): GOTO Move.It
    IF R2 = 0 THEN GOTO CANT.GO
   IF MD%(NM, 5) <> 0 OR AD%(10, 4) <> 0 THEN
       PGPRT 2, "If you leave without killing the clonemaster and destroying the clonatorium,  the archers out there will riddle you like a pincushion.":
       PRINT :
       GOTO Main.Loop
     END IF
3090   PGPRT 2, "The rebels take you back, throw a party that lasts three weeks, rewards you     handsomely, and shows you the space-time flaw that sends you home.": GOTO Game.Over
    GOTO CANT.GO
PASSAGE.BLOCKED:
    PBL = R2 - 100
    IF AD%(PBL, 7) = 0 THEN R2 = AD%(PBL, 5): GOTO CHK.MOVE
    IF AD%(PBL, 6) = 0 THEN R2 = AD%(PBL, 5): GOTO CHK.MOVE
    PGPRT 2, "The " + AN$(PBL) + " blocks the way!"
    GOTO Main.Loop
CANT.GO:
    PGPRT 2, "You can't go that way!"
    V%(Room) = 0
    GOTO Main.Loop
Move.It:
    R3 = Room
    Room = R2
    GOSUB Chk.Reactions
    GOSUB Read.Room
    NX = 0
    FOR X = 1 TO ND
    IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
    NEXT
    LT = NL OR LM
    GOTO Main.Loop
Chk.Reactions:
    TD%(1) = 0
    TD%(3) = MD%(0, 1)
    FD%(1) = 0
    FD%(3) = MD%(0, 13)
    FOR M = 1 TO NM
    IF MD%(M, 5) = R3 THEN IF MD%(M, 14) = 3 OR (MD%(M, 14) = 1 AND FNR(200) < MD%(M, 4)) THEN MD%(M, 5) = Room: GOTO ADD.SIDE
    IF MD%(M, 5) <> Room THEN GOTO NEXT.REACT
    IF MD%(M, 14) THEN GOTO ADD.SIDE
    FR = MD%(M, 3)
    IF FR AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
    MD%(M, 14) = 1
    IF FR > FNR(100) THEN MD%(M, 14) = 2: IF FR > FNR(100) THEN MD%(M, 14) = 3
ADD.SIDE:
    A = MD%(M, 14)
    FD%(A) = FD%(A) + MD%(M, 13)
    TD%(A) = TD%(A) + MD%(M, 1)
NEXT.REACT:
    NEXT M
    NBTL = (TD%(1) > 0)
    RETURN
GET.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO GET.ALL
    IF S$ = "TORCH" THEN PGPRT 2, "All torches are bolted to the wall and cannot be removed.": GOTO GET.BACK
    EMB = Room + 200
    WH = Room
    HA = Room
    GOSUB LOCATE.ART
    IF FO = 0 THEN PGPRT 2, "I see no " + LCASE$(S$) + " here!": GOTO Main.Loop
    GOSUB GET.SURPRISE
    IF NOT GT THEN GOTO Main.Loop
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, "It is too heavy for you.": GOTO Main.Loop
    PGPRT 2, "Got it."
    AD%(A, 4) = -1
    SZ = SZ + AD%(A, 0)
    WT = WT + AD%(A, 3)
    PGPRT 1, " "
    IF AD%(A, 2) >= 2 AND AD%(A, 2) <= 3 AND MD%(0, 9) = -1 THEN GOTO READY.WEAPON
    GOTO GET.BACK
GET.ALL:
    PGPRT 1, " "
    FOR A = 1 TO NA
    IF AD%(A, 4) <> Room THEN GOTO GET.NEXT
    GOSUB GET.SURPRISE
    IF NOT GT THEN GOTO GET.NEXT
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 1, AN$(A) + " is too heavy.": GOTO GET.NEXT
    PGPRT 1, AN$(A) + " taken."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
GET.NEXT:
    NEXT
    PGPRT 1, " "
    GOTO GET.BACK
GET.SURPRISE:
    GT = -1
' -1=successful get it ; 0=failure to get it
    RETURN
MONSTER.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
    FO = 0
    SL = LEN(S$)
    FOR X = 1 TO NM
    IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = Room OR MD%(X, 5) = HA) THEN FO = FO + 1: M = X: IF S$ = MN$(X) THEN X = 999
    NEXT
    RETURN
ARTIFACT.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
LOCATE.ART:
    FO = 0
    SL = LEN(S$)
    FOR X = 1 TO NA
    IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = EMB OR AD%(X, 4) = HA) THEN FO = FO + 1: A = X: IF S$ = AN$(X) THEN X = 999
    NEXT
    RETURN
GET.SUBJ:
    IF S$ = "" THEN PRINT : PRINT C$(C); " WHAT"; : INPUT S$: PGPRT 2, "": GOTO GET.SUBJ
    IF S$ = "BOX" OR S$ = "GLOWING BOX" THEN PGPRT 2, "THE BOX IS TOO HOT TO HOLD, AND YOU BURN   YOUR HAND.": D = 1: S = 3: A = 0: DF = 0: GOSUB Do.Damage: GOTO GET.BACK
    IF S$ = "MINER'S PICK" THEN S$ = "PICK"
    IF S$ = "TRAY" THEN S$ = "SERVING TRAY"
    IF S$ <> "PICK" THEN 4120
    FOR A = 4 TO 8
    IF AD%(A, 4) = Room THEN S$ = UCASE$(AN$(A))
    NEXT A
4120 '
    RETURN
DROP.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO DROP.ALL
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ART
    IF FO = 0 THEN PGPRT 2, "You aren't carrying a " + LCASE$(S$): GOTO Main.Loop
    WT = WT - AD%(A, 3)
    AD%(A, 4) = Room
    PGPRT 2, AN$(A) + " dropped."
    IF A = LS THEN
	LS = 0
	LC = 0
	LM = 0
	LT = Room.LIGHT
	PGPRT 2, "The " + AN$(A) + " goes out."
    END IF
CHK.WT:
    IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAP:
    IF MD%(0, 9) > 0 THEN IF AD%(MD%(0, 9), 4) <> -1 THEN MD%(0, 9) = -1
    GOTO GET.BACK
DROP.ALL:
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN PGPRT 2, AN$(A) + " dropped.": AD%(A, 4) = Room
    NEXT A
    WT = 0
    GOTO CHK.DROP.WEAP
LOOK.RTN:
    LK = 0
    IF S$ = "" THEN GOTO GENERAL.LOOK
    GOSUB ARTIFACT.SEARCH
    IF FO = 0 THEN GOTO CHK.LK.MON
    GOSUB EXAM.ART
    LK = -1
    AD%(A, 9) = 1
    IF AD%(A, 4) = EMB THEN AD%(A, 4) = Room
    IF LK THEN GOTO GET.BACK
CHK.LK.MON:
    GOSUB MONSTER.SEARCH
    IF FO <> 0 THEN GOSUB EXAM.MON: LK = -1
    IF LK THEN GOTO GET.BACK
    IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
GENERAL.LOOK:
    FOR X = 1 TO ND
	IF RD%(X) < 0 AND ABS(RD%(X)) <= NR THEN PGPRT 2, "You found a secret passage " + LCASE$(C$(X)) + "!": RD%(X) = ABS(RD%(X)): V%(Room) = 2
    NEXT
    WH = Room + 300
    HA = WH
    EMB = WH
    GOSUB LOCATE.ART
    IF FO <> 0 THEN AD%(A, 4) = Room: PGPRT 2, "You found something.": GOTO GET.BACK
    V%(Room) = V%(Room) + 1
    GOTO GET.BACK
EXAM.ART:
    IF A = 3 OR A = 13 THEN PGPRT 2, "The bottle says, 'Healing Potion'": RETURN
    GET #2, A + 100
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    RETURN
EXAM.MON:
    GET #2, M + 300
    A$ = RTRIM$(DESC$)
    PGPRT 2, A$
    LK = -1
    RETURN
NOTHIN.TA.SEE:
    V%(Room) = V%(Room) + 1
    GOTO GET.BACK
' Secret Passage - PUT MESSAGE HERE IF NEEDED
    PGPRT 2, "You found a secret passage " + LCASE$(C$(X)) + "!"
    RD%(X) = ABS(RD%(X))
    V%(Room) = 2
    RETURN
ATTACK.RTN:
    GOSUB GET.SUBJ
7020   IF S$ <> "GUARD" THEN 7050
7030   FOR M = 23 TO 42: IF MD%(M, 5) = Room THEN S$ = UCASE$(MN$(M))
7040   NEXT: GOTO 7280
7050   IF S$ <> "SERVANT" THEN 7080
7060   FOR M = 5 TO 14: IF MD%(M, 5) = Room THEN S$ = UCASE$(MN$(M))
7070   NEXT: GOTO 7280
7080   IF S$ <> "HAREM" AND S$ <> "HAREM GIRL" AND S$ <> "GIRL" THEN 7110
7090   FOR M = 15 TO 17: IF MD%(M, 5) = Room THEN S$ = UCASE$(MN$(M))
7100   NEXT: GOTO 7280
7110   IF S$ <> "MINER" THEN 7140
7120   FOR M = 18 TO 22: IF MD%(M, 5) = Room THEN S$ = UCASE$(MN$(M))
7130   NEXT: GOTO 7280
7140   IF S$ <> "BOX" AND S$ <> "GLOWING BOX" THEN 7280
7150   PRINT : PRINT
       COLOR hfg%, hbg%
       PRINT "As your weapon smashes into the glowing box, you hear the sizzle of someone     being hit by lightning.  you die."
7160  DIE = 1: GOTO Game.Over
7280 IF LT = 0 THEN PGPRT 2, "You swing wild --- nothing hit.": GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF FO = 0 THEN GOTO CHK.ATT.ART
    GOTO Attack.Monster
CHK.ATT.ART:
    WH = Room
    HA = Room
    EMB = Room + 200
    GOSUB LOCATE.ART
    IF FO = 0 THEN PGPRT 2, "Attack who?": GOTO Main.Loop
    IF AD%(A, 2) <> 8 AND AD%(A, 2) <> 4 THEN PGPRT 2, "Are you crazy?!": GOTO Main.Loop
    S = 7
    K = 6
    IF AD%(A, 2) = 4 THEN S = S - 1: K = K - 1
    D2 = 0
    FOR X = 1 TO MD%(0, 11)
    D2 = D2 + FNR(MD%(0, 12))
    NEXT
    AD%(A, S) = AD%(A, S) - D2
    IF AD%(A, S) <= 0 THEN AD%(A, S) = 0: AD%(A, K) = 0: PGPRT 2, "The " + AN$(A) + " shatters!": GOTO GET.BACK
    PGPRT 2, "WHAM!! You hit the " + AN$(A) + "!"
    GOTO GET.BACK
Attack.Monster:
    IF MD%(0, 9) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO Main.Loop
    OF = 0
    DF = M
    GOSUB TAKE.A.SWING
    IF NOT HIT THEN GOTO CHK.ATT.FRIEND
    IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
    IF -EA <= AE THEN GOTO GET.BACK
    IF FNR(100) <= MD%(0, 10) THEN GOTO CHK.ATT.FRIEND
    A = 2
    IF EA + AE = -1 THEN A = 1
    AE = AE + A
    MD%(0, 10) = MD%(0, 10) + A
CHK.ATT.FRIEND:
    IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO GET.BACK
    MD%(DF, 3) = MD%(DF, 3) / 2
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
    NEXT M
    R3 = Room
    GOSUB Chk.Reactions
    GOTO GET.BACK
MON.GET.GUN:
    IF MD%(OF, 10) = 0 THEN RETURN
    FOR A = 1 TO NA
    IF AD%(A, 4) = Room AND (AD%(A, 2) = 2 OR AD%(A, 2) = 3) THEN PGPRT 2, MN$(OF) + " picks up " + AN$(A) + ".": AD%(A, 4) = 0: MD%(OF, 9) = A: MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5): MD%(OF, 4) = MD%(OF, 4) * 2: A = NA
    NEXT
    RETURN
TAKE.A.SWING:
    HIT = 0
    IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
    PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
    PRINT " --";
    RL = FNR(100)
    HIT = 0
    IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = -1
    IF HIT THEN GOTO A.HIT
    IF RL < 97 THEN PGPRT 1, "a miss.": RETURN
    PGPRT 1, "a Fumble!"
    FR = FNR(100)
    IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PGPRT 1, "  fumble recovered.": RETURN
    IF FR < 76 THEN PGPRT 1, "  weapon dropped!": AD%(MD%(OF, 9), 4) = Room: MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5): MD%(OF, 9) = -1: MD%(OF, 4) = MD%(OF, 4) / 2: RETURN
    IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PGPRT 2, "Sparks fly from " + AN$(W) + "!": RETURN
    IF FR > 95 THEN GOTO HURT.SELF
    PGPRT 1, "  weapon broken!"
    AD%(MD%(OF, 9), 4) = 0
    MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
    MD%(OF, 9) = -1
    MD%(OF, 4) = MD%(OF, 4) / 2
    IF RND(1) > .5 THEN PGPRT 1, " ": RETURN
    PGPRT 1, "  broken weapon hurts user!"
HURT.SELF:
    IF FR = 100 THEN GOTO SELF.YEOW
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    DF = OF
    A = 1
    GOTO Do.Damage
SELF.YEOW:
    D = MD%(OF, 11) * 2
    S = MD%(OF, 12)
    DF = OF
    A = 0
    GOTO Do.Damage
A.HIT:
    INC = (FNR(100) > MD%(OF, 10))
    MD%(OF, 10) = MD%(OF, 10) + 2 * ABS(INC)
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    A = 1
    IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO Do.Damage
    PGPRT 1, "A Critical Hit!"
    R2 = FNR(100)
    IF R2 < 51 THEN A = 0: GOTO Do.Damage
    IF R2 < 86 THEN S = 1.5 * S: GOTO Do.Damage
    IF R2 < 96 THEN D = 2 * D: GOTO Do.Damage
    IF R2 < 100 THEN D = 3 * D: GOTO Do.Damage
    GOTO Is.Dead
Do.Damage:
    D2 = 0
    FOR D3 = 1 TO D
    D2 = D2 + FNR(S)
    NEXT
    D2 = D2 - A * MD%(DF, 8)
    IF D2 < 1 THEN PGPRT 1, " blow bounces off armour!": RETURN
    MD%(DF, 13) = MD%(DF, 13) + D2
    IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO Is.Dead
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + D2
SHOW.CONDITION:
    PRINT MN$(DF);
    ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:
    PGPRT 1, " is still in good shape."
    RETURN
HURTING:
    PGPRT 1, " is hurting."
    RETURN
IN.PAIN:
    PGPRT 1, " is in pain."
    RETURN
BADLY.INJURED:
    PGPRT 1, " is very badly injured!"
    RETURN
DEATHS.DOOR:
    PGPRT 1, " is at death's door, knocking loudly!"
    RETURN
Is.Dead:
    PGPRT 1, MN$(DF) + " is dead!"
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
    MD%(DF, 5) = 0
    IF (DF <> NM OR AD%(10, 4) = 0) AND MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = Room: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
    FOR AJ = 1 TO NA
    IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = Room
    NEXT
    IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = Room: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
    IF DF = 0 THEN DIE = 1: GOTO Game.Over
    RETURN
'    A2 = DF + NZ - NM
'    AD%(A2, 4) = Room
' PUT DEAD BODY IN Room
    IF DF < 23 OR AD%(10, 4) = 0 THEN RETURN
7730  CW = CW + 1: CW(CW) = DF: IF DF < 43 THEN RETURN
7740  CW(CW) = CW(1): CW(1) = DF: RETURN
RETURN
FLEE.RTN:
    IF NOT NBTL THEN PGPRT 2, "There's no reason to run!": GOTO Main.Loop
    IF NX = 0 THEN PGPRT 2, "There's no place to go!": GOTO Main.Loop
    IF S$ <> "" THEN
	C = 0
	FOR D = 1 TO ND
	    IF S$ = LEFT$(UCASE$(C$(D)), LEN(S$)) THEN C = D: EXIT FOR
	NEXT
	IF C > 0 THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
    END IF
    GOSUB FIND.EXIT
    GOTO Move.It
FIND.EXIT:
    IF NX = 0 THEN R2 = Room: PGPRT 1, " ... but can't find an exit!": RETURN
    D = FNR(ND)
    R2 = RD%(D)
    IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
    RETURN
GIVE.RTN:
    IF S$ = "" THEN GOSUB GET.SUBJ
    A = 0
    M = 0
    M$ = ""
    A$ = ""
    SEP = INSTR(S$, " TO ")
    IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
    END IF
    SEP = INSTR(S$, " ")
    IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF FOUND THEN
	      M$ = S$
	      A$ = MID$(SAVE.S$, SP)
	      GOTO READY.SEARCH.GIVE
	  END IF
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
	    A$ = MID$(S$, SEP + 1)
	    M$ = LEFT$(S$, SEP - 1)
	ELSE
	    GOSUB GIVE.WHO
	    GOSUB GIVE.WHAT
	END IF
    ELSE
	GOSUB ARTIFACT.SEARCH
	IF FOUND THEN
	    A$ = AN$(A)
	ELSE
	    GOSUB MONSTER.SEARCH
	    IF FOUND THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
	    END IF
	END IF
    END IF
READY.SEARCH.GIVE:
    GOSUB GIVE.WHO
    GOSUB GIVE.WHAT
    IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
    END IF
    IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
	    S$ = A$
	    GOSUB ARTIFACT.SEARCH
	END IF
    END IF
    IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
    IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
    PGPRT 2, "I don't know what you mean."
    GOTO Main.Loop
RESOLVE.GIVE:      ' RESOLVE.GIVE
    PGPRT 2, "Okay."
    POP = 0
    GOSUB GIVE.ART.MON
    IF POP <> 0 THEN GOTO Main.Loop
    IF A = MD%(0, 9) THEN MD%(0, 9) = -1
    AD%(A, 4) = -M - 1
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
    IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
    R3 = Room
    GOSUB Chk.Reactions
    GOTO CHK.WT
GIVE.ART.MON:
 ' PUT SPECIAL CODE HERE FOR GIVING ITEM (A) TO MONSTER (M)
 ' IF MONSTER REFUSES OR SOME SPECIAL ACTION WHERE ITEM DOESN'T CHANGE
 ' HANDS OCCURS, THEN SET POP = -1 AND RETURN FROM THIS ROUTINE.
    RETURN
GIVE.GOLD:
    IF VAL(A$) > GOLD& THEN PGPRT 2, "You aren't carrying that much gold!": GOTO GET.BACK
    GOLD& = INT(GOLD& - VAL(A$))
    MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
    GOTO COMPLETE.GIVE
GIVE.WHO:
    IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
    RETURN
GIVE.WHAT:
    IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
    RETURN

INVENTORY.RTN:
    PGPRT 2, "You are carrying the following ---"
    A0 = 0
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN PGPRT 1, " " + AN$(A) + LEFT$(" (Ready weapon)", 1 + 20 * ABS(A = MD%(0, 9)))
    NEXT
    GOTO GET.BACK
BLAST.SPELL:
    GOSUB GET.SUBJ
    GOSUB MONSTER.SEARCH
    IF FO = 0 THEN GOTO CANT.BLAST
    S = 1
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO GET.BACK
    PGPRT 2, "Direct Hit!"
    S = 6
    D = 1
    DF = M
    A = 0
    GOSUB Do.Damage
    GOTO GET.BACK
CANT.BLAST:
    PGPRT 2, "You can't Blast " + S$ + "!"
    GOTO Main.Loop
CAST.SPELL:
    SUC = 0
    IF SA%(S) THEN RL = FNR(100): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN GOTO FORGET.IT
    IF NOT SUC THEN PGPRT 2, "Nothing happened.": RETURN
    RL = FNR(100)
    IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
    S2%(S) = S2%(S) / 2
    RETURN
FORGET.IT:
    PGPRT 2, "The strain of attempting to cast this spell overloads your brain and you      forget it completely."
    SA%(S) = 0
    RETURN
HEAL.SPELL:
    S = 2
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO GET.BACK
    IF MD%(0, 13) THEN PGPRT 2, "Some of your wounds seem to clear up."
    MD%(0, 13) = MD%(0, 13) - FNR(10)
    IF MD%(0, 13) < 0 THEN MD%(0, 13) = 0
    DF = 0
    GOSUB SHOW.CONDITION
    GOTO GET.BACK
POWER.SPELL:
S = 4
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO GET.BACK
    RAISE = 0
13020  RR = INT(100 * RND(1) + 1): IF RR > 10 THEN 13100
13030   PGPRT 2, "A huge cave-in collapses the tunnel you   are in and you die.": PRINT : DIE = 1: GOTO Game.Over
13100   IF RR > 35 THEN 13150
13110   PGPRT 2, "A purple scintilating ray blasts from     your eyes and strikes everybody in the  room.": PRINT : FOR DF = 1 TO NM: IF MD%(DF, 5) = Room THEN GOSUB Is.Dead
13120   NEXT DF: GOTO GET.BACK
13150   IF RR > 60 THEN 13200
13160   PGPRT 2, "The scene shifts and you find yourself--": R2 = INT(30 * RND(1) + 1): GOTO Move.It
13200   IF RR > 90 THEN 13300
13210   PGPRT 2, "A bluish gas appears beside you.": PRINT : GOTO GET.BACK
13300   IF RR = 100 THEN 13500
13310   PGPRT 1, "All of your weapons fall to the ground.": PRINT : FOR A = 1 TO NA: IF AD%(A, 4) = -1 THEN AD%(A, 4) = Room
13320   NEXT: MD%(0, 9) = -1: GOTO GET.BACK
13500   PGPRT 2, "A fog settles about your mind and you      forget everything you have learned      about using weapons and armour.": PRINT
13510  AE = 0: WA%(1) = 5: WA%(2) = -10: WA%(3) = 20: WA%(4) = 10: WA%(5) = 0
13520   IF MD%(0, 9) > -1 THEN A = MD%(0, 9): GOTO 17980
13530   GOTO GET.BACK
SPEED.SPELL:
    S = 3
    GOSUB CAST.SPELL
    IF NOT SUC THEN GOTO GET.BACK
DO.SPEED:
    IF SPD = 0 THEN MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2): MD%(0, 2) = 2 * MD%(0, 2)
    SPD = SPD + FNR(25) + 10
    PGPRT 2, "You can feel the new agility flowing through you!"
    GOTO GET.BACK
SMILE.RTN:
    PGPRT 1, " "
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room THEN ON MD%(M, 14) GOSUB GROWL, IGNORE, SMILE
    NEXT
    GOTO GET.BACK
GROWL:
    PGPRT 1, MN$(M) + " growls at you!"
    RETURN
IGNORE:
    PGPRT 1, MN$(M) + " ignores you."
    RETURN
SMILE:
    PGPRT 1, MN$(M) + " " + LCASE$(V$) + "s back."
    RETURN
SAY.SOMETHING:
    GOSUB GET.SUBJ
    IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
    IF S$ = "HEAL" THEN GOTO HEAL.SPELL
    IF S$ = "POWER" THEN GOTO POWER.SPELL
    IF S$ = "SPEED" THEN GOTO SPEED.SPELL
    IF S$ = "TROLLSFIRE" THEN GOTO TROLLSFIRE
    PGPRT 2, "Okay, " + CHR$(34) + S$ + CHR$(34)
    GOTO GET.BACK
READY.WEAPON:
    GOSUB GET.SUBJ
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ART
    IF FO = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO Main.Loop
    IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PGPRT 2, "That isn't a legal weapon!": GOTO Main.Loop
17980 '
    MD%(0, 10) = (EA + AE) * (-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
    MD%(0, 9) = A
    MD%(0, 11) = AD%(A, 7)
    MD%(0, 12) = AD%(A, 8)
    PGPRT 2, "Readied."
    GOTO GET.BACK
LIGHT.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FO = 0 THEN PGPRT 2, "I don't know what you mean.": GOTO Main.Loop
    IF AD%(A, 2) <> 5 THEN PGPRT 2, "You burn yourself!": GOTO GET.BACK
    IF AD%(A, 4) <> -1 THEN PGPRT 2, "You have to pick it up first.": GOTO Main.Loop
    LT = Room.LIGHT
    IF AD%(A, 5) <= 0 THEN PGPRT 2, "It won't light!": GOTO Main.Loop
    LM = -1
    LT = -1
    LC = AD%(A, 5)
    LS = A
    PGPRT 2, "You've managed to light the " + AN$(A) + "."
    GOTO GET.BACK
DESTROY.IT:
18000   REM ///DESTROY EQUIPMENT
18010   IF NBTL THEN 3010
18020   IF Room <> AD%(10, 4) THEN PGPRT 2, "Nothing to destroy here!": PRINT : GOTO Main.Loop
18030   IF MD%(0, 9) = -1 THEN GOTO Attack.Monster
18040   IF RND(1) > MD%(0, 1) / 24 THEN PGPRT 2, "You smash at it but it remains standing": PRINT : GOTO GET.BACK
18050   PRINT "!!!!!!!!!!!!!  KA--BLAMMMM  !!!!!!! POW!!!   BANG!! !!!!!!!!!"
	PRINT
	PRINT "The machine starts exploding with great balls of fire and smoke !!!"
	PRINT
	PRINT "The Clonatorium has been destroyed!!!!"
	PRINT
	AD%(10, 4) = 0
	AD%(11, 4) = Room
	GOTO GET.BACK
OPEN.RTN:
    GOSUB GET.SUBJ
    WH = Room
    HA = -1
    EMB = Room + 200
    GOSUB LOCATE.ART
    IF FO = 0 THEN GOTO OPEN.WHAT
    IF A = 12 THEN GOTO OPEN.CHEST
    IF AD%(A, 2) = 4 THEN GOTO OPEN.CONTAINER
    IF AD%(A, 2) = 7 THEN PGPRT 2, "Try reading it.": GOTO Main.Loop
    IF AD%(A, 2) = 1 THEN PGPRT 2, "You'll make a mess. Wait till you leave.": GOTO Main.Loop
    IF AD%(A, 2) = 8 THEN GOTO OPEN.DOOR.GATE
    PGPRT 2, "That's not what you do with it."
    GOTO Main.Loop
OPEN.CONTAINER:
    IF AD%(A, 5) THEN IF AD%(AD%(A, 5), 4) <> -1 THEN PGPRT 2, "It's locked!": GOTO Main.Loop
    LK = 0
    WH = A + 100
    HA = WH
    Room = WH
    GOSUB LOCATE.ART
    IF FO <> 0 THEN AD%(A, 4) = Room: LK = -1:
    IF LK THEN PGPRT 2, "You found something inside!"
    GOTO GET.BACK
OPEN.WHAT:
    IF S$ = "DOOR" OR S$ = "GATE" THEN PGPRT 2, "It should open when you approach.": GOTO Main.Loop
    PGPRT 2, "I don't know how to open " + LCASE$(S$) + "."
    GOTO Main.Loop
OPEN.DOOR.GATE:
    IF AD%(A, 6) THEN IF AD%(AD%(A, 6), 4) <> -1 THEN PGPRT 2, "It's locked.": GOTO Main.Loop
    AD%(A, 6) = 0
    PGPRT 2, "You've opened the " + AN$(A) + "."
    FOR X = 1 TO ND
    IF RD%(X) = A + 100 THEN RD%(X) = AD%(A, 5)
    NEXT
    GOTO GET.BACK
OPEN.CHEST:
    PGPRT 1, " "
    R = 1
    GOSUB PRINT.EFFECT
    AD%(12, 4) = 0
    MD%(7, 5) = Room
    R3 = Room
    GOSUB Chk.Reactions
    GOTO Main.Loop
PUT.RTN:
    IF S$ = "" THEN GOTO PUT.WHAT.WHERE
    FOR X = 1 TO LEN(S$)
    IF MID$(S$, X, 5) = " INTO" AND X > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 6): GOTO PUT.AWAY
    IF MID$(S$, X, 3) = " IN" AND X > 2 THEN A$ = LEFT$(S$, X - 1): B$ = MID$(S$, X + 3): GOTO PUT.AWAY
    NEXT
PUT.WHAT.WHERE:
    PRINT
    INPUT "Put What?", A$
    INPUT "Put into What?", B$
    PGPRT 3, ""
    GOTO PUT.AWAY
PUT.AWAY:
    S$ = A$
    GOSUB ARTIFACT.SEARCH
    IF FO = 0 THEN PGPRT 2, "I don't know what you mean.": GOTO Main.Loop
    X = A
    S$ = B$
    GOSUB ARTIFACT.SEARCH
    IF FO = 0 OR A = X THEN GOTO PUT.NONSENSE
    AD%(X, 4) = A + 100
    PGPRT 2, "Okay."
    GOTO GET.BACK
PUT.NONSENSE:
    PGPRT 2, "You aren't making sense."
    GOTO Main.Loop
DRINK.RTN:
    GOSUB GET.SUBJ
    IF S$ = "POTION" THEN S$ = "BOTTLE"
    GOSUB ARTIFACT.SEARCH
    IF FO = 0 THEN PGPRT 2, "I don't understand.": GOTO Main.Loop
    IF AD%(A, 2) <> 6 THEN PGPRT 2, "You can't do that!": GOTO Main.Loop
    IF AD%(A, 7) <= 0 THEN PGPRT 2, "There isn't any left.": GOTO GET.BACK
    IF AD%(A, 5) > FNR(100) THEN GOTO DRINK.HEAL
    PGPRT 2, "Nothing seems to happen."
    GOTO GET.BACK
DRINK.HEAL:
    AD%(A, 7) = AD%(A, 7) - 1
    MD%(0, 13) = MD%(0, 13) - AD%(A, 6)
    IF MD%(0, 13) < 0 THEN MD%(0, 13) = 0
    PGPRT 2, "Your wounds seem to " + MID$("openheal", ABS(AD%(A, 6) > 0) * 4 + 1, 4) + "!"
    GOTO GET.BACK
READ.RTN:
    GOSUB GET.SUBJ
    WH = Room
    HA = -1
    EMB = Room + 200
    GOSUB LOCATE.ART
    IF FO = 0 THEN GOTO READ.NON.ART
    IF AD%(A, 2) = 7 THEN GOTO READ.ART
    PGPRT 2, "You can't read that."
    GOTO GET.BACK
READ.NON.ART:
    PGPRT 2, "There is nothing to read."
    GOTO Main.Loop
READ.ART:
    IF A = 9 THEN GOTO READ.BOOK
    FOR X = 1 TO AD%(A, 6)
    R = AD%(A, 5) - 1 + X
    GOSUB PRINT.EFFECT
    NEXT
    GOTO GET.BACK
READ.BOOK:
    R = 7
    GOSUB PRINT.EFFECT
    IF Room = 26 THEN R = 8: GOSUB PRINT.EFFECT: DIE = 1: GOTO Game.Over
    R = 9
    GOSUB PRINT.EFFECT
    DIE = 1
    GOTO Game.Over
PRINT.EFFECT:
    GET #2, R + 200
    A$ = RTRIM$(DESC$)
    PGPRT 1, A$
    RETURN
FREE.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FO = 0 THEN PGPRT 2, "I don't understand.": GOTO Main.Loop
    IF AD%(A, 2) <> 10 THEN PGPRT 2, "I don't understand.": GOTO Main.Loop
    M = AD%(A, 5)
    K = AD%(A, 6)
    G = AD%(A, 7)
    IF AD%(A, 4) <> Room THEN PGPRT 2, "I don't know what you are talking about.": GOTO Main.Loop
    IF MD%(G, 5) = Room THEN PGPRT 2, MN$(G) + " won't let you do that!": GOTO GET.BACK
    IF AD%(K, 4) <> -1 AND K <> 0 THEN PGPRT 2, "You don't have the key!": GOTO Main.Loop
    PGPRT 2, "You have freed " + MN$(M) + "."
    MD%(M, 5) = Room
    AD%(A, 4) = 0
    R3 = Room
    GOSUB Chk.Reactions
    GOTO GET.BACK
ENTER.RTN:
    IF (S$ = "WATER" OR S$ = "SEA") AND Room = 26 THEN PGPRT 2, "I'm afraid to go into the water without my life preserver!": GOTO Main.Loop
    IF S$ = "CAVE" AND Room = 1 THEN V$ = "S": GOTO MOVE.RTN
    PGPRT 2, "I'm not sure what you mean by that. Try giving a direction to move in."
    GOTO Main.Loop
TROLLSFIRE:
    IF AD%(10, 4) <> -1 THEN PGPRT 2, "Nothing happens.": GOTO GET.BACK
    IF TR = 0 THEN GOTO TF.IGNITE
    PGPRT 1, " "
    R = 6
    GOSUB PRINT.EFFECT
    TR = 0
    AD%(10, 8) = 6
    IF MD%(0, 9) = 10 THEN MD%(0, 12) = 6
    GOTO GET.BACK
TF.IGNITE:
    PGPRT 1, " "
    R = 4
    GOSUB PRINT.EFFECT
    IF MD%(0, 9) <> 10 THEN R = 5: GOSUB PRINT.EFFECT: D = 1: S = 5: DF = 0: GOSUB Do.Damage: GOTO GET.BACK
    TR = -1
    AD%(10, 8) = 10
    MD%(0, 12) = 10
    GOTO GET.BACK
REM $$INCL:'\Eamon\COPY\CHARIO.BAS'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  CHARIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Character File I/O Routines for Eamon QB/PC
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        or BASIC 7.0 PDS
        '       uses User defined types for record definition
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
OPEN.CHARACTERS:
      OPEN "CHARACT.DAT" FOR RANDOM AS #1 LEN = LEN(Char)
      RETURN
READ.NBR.CHARS:
      GET #1, 1, CharCtl
      NC = CharCtl.NbrChar
      IF NC > LOF(1) \ LEN(Char) THEN NC = LOF(1) \ LEN(Char) - 1
      RETURN
READ.CHARACTER:
      GET #1, REC, Char
      Nam$ = RTRIM$(Char.Nam$)
      HD = Char.Hd
      AG = Char.Ag
      CH = Char.Ch
      SA%(1) = Char.SA1
      SA%(2) = Char.SA2
      SA%(3) = Char.SA3
      SA%(4) = Char.SA4
      WA%(1) = Char.WA1
      WA%(2) = Char.WA2
      WA%(3) = Char.WA3
      WA%(4) = Char.WA4
      WA%(5) = Char.WA5
      SEX$ = Char.SEX
      GOLD& = Char.GOLD
      BANK& = Char.BANK
      AE = Char.AE
      ArmNam$ = RTRIM$(Char.ArmNam)
      ArmHit = Char.ArmHit
      ArmAdj = Char.ArmAdj
      ShdNam$ = RTRIM$(Char.ShdNam)
      ShdHit = Char.ShdHit
      ShdAdj = Char.ShdAdj
      WN$(1) = RTRIM$(Char.Wpn1Nam)
      WR%(1) = Char.Wpn1Typ
      WT%(1) = Char.Wpn1WpnTyp
      WC%(1) = Char.Wpn1Odds
      WD%(1) = Char.Wpn1Dice
      WS%(1) = Char.Wpn1Sides
      WN$(2) = RTRIM$(Char.Wpn2Nam)
      WR%(2) = Char.Wpn2Typ
      WT%(2) = Char.Wpn2WpnTyp
      WC%(2) = Char.Wpn2Odds
      WD%(2) = Char.Wpn2Dice
      WS%(2) = Char.Wpn2Sides
      WN$(3) = RTRIM$(Char.Wpn3Nam)
      WR%(3) = Char.Wpn3Typ
      WT%(3) = Char.Wpn3WpnTyp
      WC%(3) = Char.Wpn3Odds
      WD%(3) = Char.Wpn3Dice
      WS%(3) = Char.Wpn3Sides
      WN$(4) = RTRIM$(Char.Wpn4Nam)
      WR%(4) = Char.Wpn4Typ
      WT%(4) = Char.Wpn4WpnTyp
      WC%(4) = Char.Wpn4Odds
      WD%(4) = Char.Wpn4Dice
      WS%(4) = Char.Wpn4Sides
      RETURN
WRITE.CHARACTER:
      Char.Nam = Nam$
      Char.Hd = HD
      Char.Ag = AG
      Char.Ch = CH
      Char.SA1 = SA%(1)
      Char.SA2 = SA%(2)
      Char.SA3 = SA%(3)
      Char.SA4 = SA%(4)
      Char.WA1 = WA%(1)
      Char.WA2 = WA%(2)
      Char.WA3 = WA%(3)
      Char.WA4 = WA%(4)
      Char.WA5 = WA%(5)
      Char.SEX = SEX$
      Char.GOLD = GOLD&
      Char.BANK = BANK&
      Char.AE = AE
      Char.ArmNam = ArmNam$
      Char.ArmHit = ArmHit
      Char.ArmAdj = ArmAdj
      Char.ShdNam = ShdNam$
      Char.ShdHit = ShdHit
      Char.ShdAdj = ShdAdj
      Char.Wpn1Nam = WN$(1)
      Char.Wpn1Typ = WR%(1)
      Char.Wpn1WpnTyp = WT%(1)
      Char.Wpn1Odds = WC%(1)
      Char.Wpn1Dice = WD%(1)
      Char.Wpn1Sides = WS%(1)
      Char.Wpn2Nam = WN$(2)
      Char.Wpn2Typ = WR%(2)
      Char.Wpn2WpnTyp = WT%(2)
      Char.Wpn2Odds = WC%(2)
      Char.Wpn2Dice = WD%(2)
      Char.Wpn2Sides = WS%(2)
      Char.Wpn3Nam = WN$(3)
      Char.Wpn3Typ = WR%(3)
      Char.Wpn3WpnTyp = WT%(3)
      Char.Wpn3Odds = WC%(3)
      Char.Wpn3Dice = WD%(3)
      Char.Wpn3Sides = WS%(3)
      Char.Wpn4Nam = WN$(4)
      Char.Wpn4Typ = WR%(4)
      Char.Wpn4WpnTyp = WT%(4)
      Char.Wpn4Odds = WC%(4)
      Char.Wpn4Dice = WD%(4)
      Char.Wpn4Sides = WS%(4)
      PUT #1, REC, Char
      RETURN
WRITE.NBR.CHARS:
      CharCtl.NbrChar = NC
      PUT #1, 1, CharCtl
      RETURN

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\EAMON\COPY\ADVENIO.OLD'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  ADVENIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Adventure I/O Routines for Eamon Base Adventure Program
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        BASIC 7.0 PDS
        '       uses Field statements for record description
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
READ.ARTIFACTS:    ' ----- READ ARTIFACTS ---------------------
       IF Art.Len = 0 THEN Art.Len = 128
       IF Art.Flds = 0 THEN Art.Flds = 8
       IF AN.Len = 0 THEN AN.Len = 20
       OPEN "ARTIF.TXT" FOR RANDOM AS #3 LEN = Art.Len
       FIELD 3, AN.Len AS AF.NAME$
       DIM AF.DATA$(Art.Flds)
       FOR A2 = 1 TO Art.Flds
       FIELD 3, AN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS AF.DATA$(A2)
       NEXT
       FOR A = 1 TO NA
           GET #3, A
           AN$(A) = RTRIM$(AF.NAME$)
           FOR A2 = 1 TO Art.Flds
               AD%(A, A2) = CVI(AF.DATA$(A2))
           NEXT A2
           IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 THEN NW = NW + 1
       NEXT
       CLOSE 3
       RETURN
READ.MONSTERS:  ' ------------- READ MONSTERS    ---------------------
       IF MON.LEN = 0 THEN MON.LEN = 128
       IF Mon.Flds = 0 THEN Mon.Flds = 12
       IF MN.Len = 0 THEN MN.Len = 20
       OPEN "MONST.TXT" FOR RANDOM AS #3 LEN = MON.LEN
       FIELD 3, MN.Len AS MF.NAME$
       DIM MF.DATA$(Mon.Flds)
       FOR A2 = 1 TO Mon.Flds
           FIELD 3, MN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS MF.DATA$(A2)
       NEXT
       FOR A = 1 TO NM
           GET #3, A
           MN$(A) = RTRIM$(MF.NAME$)
           FOR A2 = 1 TO Mon.Flds
               MD%(A, A2) = CVI(MF.DATA$(A2))
           NEXT A2
           IF MD%(A, 3) < 0 THEN               ' Force nuetral if < 0
              MD%(A, 3) = ABS(MD%(A, 3)) - 1
              MD%(A, 14) = 2
           END IF
       NEXT
       CLOSE 3
       RETURN
OPEN.DESC:       ' ----------------- OPEN DESC FILE -------------------
       IF Desc.Len = 0 THEN Desc.Len = 256
       OPEN "DESC.TXT" FOR RANDOM AS #2 LEN = Desc.Len
       FIELD 2, Desc.Len - 1 AS Desc$
       RETURN
OPEN.RMNAMES:    ' ---------------- OPEN ROOM NAMES -------------------
       IF RMN.Len = 0 THEN RMN.Len = 64
       OPEN "RMNAMES.TXT" FOR RANDOM AS #3 LEN = RMN.Len
       FIELD 3, RMN.Len AS RN$
       RETURN
OPEN.ROOMS:      ' ---------------- OPEN ROOMS FILE -------------------
       IF RM.LEN = 0 THEN RM.LEN = 64
       OPEN "ROOMS.TXT" FOR RANDOM AS #1 LEN = RM.LEN
       FOR D = 1 TO 10
           FIELD 1, (D - 1) * 2 AS X$, 2 AS RF.DIR$(D)
       NEXT
       FIELD 1, 20 AS X$, 1 AS RF.LT$
       RETURN
Read.Room:
       GET #1, Room
       IF ND = 0 THEN ND = 6
       NX = 0
       FOR X = 1 TO ND
           RD%(X) = CVI(RF.DIR$(X))
           IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
       NEXT
       NL = VAL(RF.LT$)
       GET #3, Room
       RETURN
    '------- (end of include file) -------

    '------- (end of include file) -------    
 ' 
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
	'   Module:  ADVENIO.OLD  - special clonemaster version
	'   Eamon Version:  Eamon-QB (or Eamon-PC)
	' ------------------------------------------------------------
	'  Adventure I/O Routines for Eamon Base Adventure Program
	'        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
	'                        BASIC 7.0 PDS
	'       uses Field statements for record description
	'       This module will work for QBasic, but QBasic cannot
REM $$INCL:statements, so module must be built
	'       manually or merged using a utility
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
READ.ARTIFACTS:    ' ----- READ ARTIFACTS ---------------------
       OPEN "ARTIF.TXT" FOR RANDOM AS #3 LEN = 128
       FIELD 3, 30 AS AF.NAME$
       DIM AF.DATA$(8)
       FOR A2 = 1 TO 8
       FIELD 3, 30 AS X$, (A2 - 1) * 2 AS X$, 2 AS AF.DATA$(A2)
       NEXT
       FOR A = 1 TO NA
	   GET #3, A
	   AN$(A) = RTRIM$(AF.NAME$)
	   FOR A2 = 1 TO 8
	       AD%(A, A2) = CVI(AF.DATA$(A2))
	   NEXT A2
	   IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 THEN NW = NW + 1
       NEXT
       CLOSE 3
       RETURN
READ.MONSTERS:  ' ------------- READ MONSTERS    ---------------------
       OPEN "MONST.TXT" FOR RANDOM AS #3 LEN = 128
       FIELD 3, 30 AS MF.NAME$
       DIM MF.DATA$(12)
       FOR A2 = 1 TO 12
	   FIELD 3, 30 AS X$, (A2 - 1) * 2 AS X$, 2 AS MF.DATA$(A2)
       NEXT
       FOR A = 1 TO NM
	   GET #3, A
	   MN$(A) = RTRIM$(MF.NAME$)
	   FOR A2 = 1 TO 12
	       MD%(A, A2) = CVI(MF.DATA$(A2))
	   NEXT A2
	   IF MD%(A, 3) < 0 THEN               ' Force nuetral if < 0
	      MD%(A, 3) = ABS(MD%(A, 3)) - 1
	      MD%(A, 14) = 2
	   END IF
       NEXT
       CLOSE 3
       RETURN
OPEN.DESC:       ' ----------------- OPEN DESC FILE -------------------
       OPEN "DESC.TXT" FOR RANDOM AS #2 LEN = 256
       FIELD 2, 255 AS DESC$
       RETURN
OPEN.RMNAMES:    ' ---------------- OPEN ROOM NAMES -------------------
       OPEN "RMNAMES.TXT" FOR RANDOM AS #3 LEN = 64
       FIELD 3, 64 AS RN$
       RETURN
OPEN.ROOMS:      ' ---------------- OPEN ROOMS FILE -------------------
       OPEN "ROOMS.TXT" FOR RANDOM AS #1 LEN = 64
       FOR D = 1 TO 10
	   FIELD 1, (D - 1) * 2 AS X$, 2 AS RF.DIR$(D)
       NEXT
       FIELD 1, 20 AS X$, 1 AS RF.LT$
       RETURN
Read.Room:
       GET #1, Room
       FOR X = 1 TO ND
	   RD%(X) = CVI(RF.DIR$(X))
	   IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
       NEXT
       GET #3, Room
       NL = -1
       RETURN
    '------- (end of include file) -------

DEFSNG A-Z
SUB PGPRT (SP, LIT$)
    STATIC LINE.PG
    IF SP = 0 THEN LINE.PG = 0: EXIT SUB
    IF LIT$ = "" THEN LINE.PG = LINE.PG + SP: EXIT SUB
    IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	LINE.PG = LINE.PG + 1
	NEXT
    END IF
    IF LINE.PG > 20 THEN
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-")
	A$ = INPUT$(1)
	LOCATE CSRLIN - 1, 1
	PRINT SPC(79);
	LINE.PG = 0
    END IF
    PRINT LIT$
    LINE.PG = LINE.PG + LEN(LIT$) / 79 + 1
END SUB

