'               Castle of Doom - Adventure #5
'
'                      by Don Brown
'
'                IBM conversion by John Nelson
'
    DEFINT A-Z
    DECLARE SUB PGPRT (SP, LIT$)
    REM $INCLUDE: '\EAMON\COPY\CHARDEF.BAS'
    CLS
    DEF FNR (X) = INT(RND(1) * X) + 1
    CONST KH.CHARLENE = 4
'    LINE INPUT "PATH:", PATH$
    REM $INCLUDE: '\EAMON\COPY\COLORRTN.BAS'
    COLOR fgc%, bgc%
    CLS
    REM $INCLUDE: '\EAMON\COPY\READCTL.BAS'
    DIM V%(NR), RD%(10), FD%(3), TD%(3), SA%(4), S2%(4), WA%(5), RF.DIR$(10)
    DIM AN$(NA + 6), AD%(NA + 6, 9)
    DIM MN$(NM), MD%(NM, 16)
    GOSUB READ.ARTIFACTS    ' LOAD ARTIFACT TABLE
    GOSUB READ.MONSTERS     ' LOAD MONSTER TABLE
    NW = NW + 6
    DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
    READ NC
    DIM C$(NC)
    FOR C = 1 TO NC
    READ C$(C)
    NEXT
    R2 = 1
    CONST GOLD.ART = 0
    CONST TREASURE.ART = 1
    CONST WEAPON.ART = 2
    CONST MAG.WEAPON = 3
    CONST CONTAIN.ART = 4
    CONST LIGHT.ART = 5
    CONST HEAL.ART = 6
    CONST READ.ART = 7
    CONST DOOR.ART = 8
    CONST KEY.ART = 9
    CONST BOUND.MON.ART = 10
    CONST ARMOR.ART = 11
    CONST FOOD.ART = 12
    CONST DRINK.ART = 13   ' DRINKABLE ARTIFACT --- PUT IN YOUR OWN EFFECTS
    GOTO INITIALIZE
DONT.UNDERSTAND:
    PGPRT 2, "I don't understand."
' ---------------------------------------------------------------------------
MAIN.LOOP:
    IF SPD THEN
	SPD = SPD - 1
	IF SPD = 0 THEN
	    MD%(0, 2) = MD%(0, 2) / 2:
	    MD%(0, 10) = MD%(0, 10) - 2 * MD%(0, 2):
	    PGPRT 2, "Your Speed Spell has just expired!"
	END IF
    END IF
SHOW.ROOM:      ' SHOW.ROOM
    IF V%(Room) <> 0 THEN GET #3, Room: A$ = RTRIM$(RN$): PGPRT 2, "You are " + A$
    IF V%(Room) = 0 THEN GOSUB SPECIAL.ROOM.CHK
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room THEN
	IF MD%(M, 15) = 1 THEN PGPRT 2, MN$(M) + " is here."
	IF MD%(M, 15) = 2 THEN PGPRT 2, MN$(M) + " is lying here."
	IF MD%(M, 15) = 0 THEN
	    GET #2, M + MON.ADJ
	    A$ = RTRIM$(Desc$)
	    PGPRT 2, A$
	    MD%(M, 15) = 1
	END IF
    END IF
    NEXT
    FOR A = 1 TO NZ
    IF AD%(A, 4) <> Room THEN GOTO NEXT.ART
    IF AD%(A, 9) THEN
	PGPRT 2, "You see " + AN$(A) + "."
    ELSE
	GET #2, A + ART.ADJ
	A$ = RTRIM$(Desc$)
	PGPRT 2, A$
	AD%(A, 9) = 1
    END IF
NEXT.ART:      ' NEXT.ART
    NEXT
    FOR A = A TO NA
    IF AD%(A, 4) = Room THEN
	PGPRT 2, "Your " + AN$(A) + " is here."
    END IF
    NEXT
    IF Room = 26 AND E1 = 0 THEN PGPRT 2, E1$
    PRINT
GET.COMMAND:      ' GET.COMMAND
    PGPRT 0, ""
    PRINT
    COLOR hfg%, hbg%
    PRINT "  Your Command ";
    COLOR fgc%, bgc%
    LINE INPUT " ", A$
    A$ = LTRIM$(RTRIM$(UCASE$(A$)))
    IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 17: PRINT A$
    IF A$ = "" THEN GOTO LIST.COMMANDS
    CZ$ = A$
    A = INSTR(A$, " ")
    IF A = 0 THEN A = LEN(A$) + 1
    V$ = LEFT$(A$, A - 1)
    S$ = MID$(A$, A + 1)
    S$ = LTRIM$(S$)
    IF V$ = "EXIT" AND S$ = "NOW" THEN GOTO Game.Over
    IF V$ = "FUCK" THEN
	GOSUB MONSTER.SEARCH
	IF FOUND THEN
	    IF M = KH.CHARLENE THEN
		PGPRT 2, "Charlene says she is waiting for her wedding night."
		GOTO GET.COMMAND
	    END IF
	    PGPRT 2, MN$(M) + " doesn't want to be fucked!"
	END IF
    END IF
    C = 0
    FOR A = 1 TO ND
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN C = A: A = ND
    NEXT
    IF C <> 0 THEN GOTO BRANCH.RTN
    F = 0
    FOR A = ND + 1 + 4 * ABS(ND = 6) TO NC
    IF UCASE$(C$(A)) = V$ THEN C = A: A = NC
    IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN
	F = F + 1
	C = A
	IF F > 1 THEN C = 0: A = NC
    END IF
    NEXT
    IF C = 0 THEN GOTO LIST.COMMANDS
    GOTO BRANCH.RTN
LIST.COMMANDS:      ' LIST.COMMANDS
    PRINT
    PRINT "Huh? I only understand these commands ... "
    FOR C = 1 TO NC
    IF ND = 6 AND C > 6 AND C < 11 THEN C = 11 ELSE PRINT C$(C); SPC(20 - LEN(C$(C)));
    NEXT
    PRINT
    PRINT
    GOTO GET.COMMAND
    IF UCASE$(C$(C)) = S$ THEN S$ = V$: V$ = C$(C)
BRANCH.RTN:      ' BRANCH.RTN
    ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 5 GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
    ON C - 10 GOTO GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN
    ON C - 14 GOTO LOOK.RTN, ATTACK.RTN, FLEE.RTN, GIVE.RTN, INVENTORY.RTN
    ON C - 19 GOTO BLAST.SPELL, HEAL.SPELL, POWER.SPELL, SPEED.SPELL, SMILE.RTN
    ON C - 24 GOTO SMILE.RTN, SAY.SOMETHING, READ.RTN, READY.WEAPON, OPEN.RTN
    ON C - 29 GOTO EAT.RTN, DRINK.RTN, FREE.RTN, READ.RTN
    ON C - 33 GOTO SAVE.GAME, RESTORE.GAME, QUIT.RTN
GET.BACK:      ' GET.BACK
' =====
    IF TT > 0 THEN TT = TT - 1: GOTO End.Battle
    IF NBTL = 0 THEN GOTO End.Battle
    FOR M = 1 TO NM
        IF MD%(M, 5) = ROOM AND TT = 0 THEN
            MR = FD%(MD%(M, 14)) / TD%(MD%(M, 14)) - FD%(4 - MD%(M, 14)) / TD%(4 - MD%(M, 14)) / 5 + INT(41 * RND(1) - 20)
            IF MD%(M, 4) < MR THEN
                GOSUB Find.Exit
                IF R2 > 0 THEN
                    GOSUB MONSTER.LEAVES
                END IF
            END IF
            IF MD%(M, 14) = 3 THEN
                GOSUB GoodGuys.Attack
            ELSE
                GOSUB BadGuys.Attack
            END IF
        END IF
        NBTL = (FD%(1) < TD%(1))
        IF NBTL = 0 THEN EXIT FOR
    NEXT M
End.Battle:
    IF TT > 0 THEN TT = TT - 1
    GOTO End.Loop
BadGuys.Attack: 
    OF = M
    IF TD%(1) = MD%(0, 1) THEN DF = 0: GOSUB Take.a.Swing: RETURN
    DF = -1
    IF M = 9 THEN 
    	PGPRT 2, "You feel a mental attack, trying to take over your mind!!"
    	IF RND(1) < .05 THEN 
    	    PGPRT 2, "It succeeds! You are now a mindless slave to the Succubus."
    	    DIE = 1
    	    GOTO Game.Over
    	END IF    
    	RETURN
    END IF	
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 3 AND RND(1) < .25 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    IF DF < 0 THEN DF = 0: GOSUB Take.a.Swing
    RETURN
GoodGuys.Attack:
    OF = M
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 1 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    RETURN
End.Loop:
REM ///SPECIAL VAMPIRE STUFF
    IF AD%(59, 4) AND MD%(24, 1) THEN MD%(24, 13) = MD%(24, 13) - 1: IF MD%(24, 13) = 0 THEN MD%(24, 5) = AD%(59, 4): AD%(59, 4) = 0: IF MD%(24, 5) = Room THEN PGPRT 2, "Vampire comes alive!": GOSUB CHK.REACTIONS
    IF AD%(59, 4) = 0 AND MD%(24, 5) = 0 AND RND(1) < .25 THEN MD%(24, 5) = 44: IF Room = 44 THEN PGPRT 2, "A vampire just came out of the coffin!": GOSUB CHK.REACTIONS
    IF MD%(24, 5) <> Room AND MD%(24, 5) > 0 THEN R3 = Room: Room = MD%(24, 5): GOSUB FIND.EXIT: Room = R3: MD%(24, 5) = R2: IF R2 = Room THEN PGPRT 2, "A vampire just walked into the room!": GOSUB CHK.REACTIONS
    IF MD%(24, 5) = 44 AND Room <> 44 THEN MD%(24, 5) = 0
    FOR M = 13 TO 14
        IF MD%(M, 5) <> Room AND MD%(M, 5) <> 30 AND MD%(M, 5) > 0 AND MD%(M, 5) < 5 THEN MD%(M, 5) = 30
    NEXT
    IF Room < 5 AND RND(1) < .1 AND MD%(13, 5) = 30 AND MD%(14, 5) = 30 THEN MD%(13, 5) = Room: MD%(14, 5) = Room: GOSUB CHK.REACTIONS
    GOTO MAIN.LOOP
    REM $INCLUDE: '\EAMON\COPY\MONLEAVE.BAS'
' ---------------------------------------------------------------------------
INITIALIZE:
    REM $INCLUDE: '\Eamon\COPY\READMEAT.BAS'
    OPEN PATH$ + "LASTADV" FOR INPUT AS #1
    INPUT #1, A$
    IF A$ = MN$(0) THEN
	FOR M = 1 TO NM
	    FOR A = 1 TO 15
	    INPUT #1, MD%(M, A)
	    NEXT A
	NEXT M
	FOR A = 1 TO NZ
	    INPUT #1, AD%(A, 4)
	NEXT
    END IF
    CLOSE
    GOSUB OPEN.DESC
    GOSUB OPEN.RMNAMES
    GOSUB OPEN.ROOMS
    Room = 1
    E1$ = "You see a woman chained to a bedpost!"
    E1 = AD%(7, 4) OR MD%(9, 5) OR AD%(44, 4)
    GOTO MOVE.IT
    DATA 36
    DATA North,South,East,West,Up,Down
    DATA NE,NW,SE,SW
    DATA Get,Take,Drop,Look,Examine
    DATA Attack,Flee,Give,Inventory
    DATA Blast,Heal,Power,Speed,Smile
    DATA Wave,Say,Read,Ready,Open
    DATA Eat,Drink
    DATA Release,Study,Save,Restore,Quit
' ---------------------------------------------------------------------------
Game.Over:      ' GAME.OVER
    PRINT
    PRINT "(Press any key to continue) ";
    A$ = INPUT$(1)
    PRINT
    CLOSE
    IF SPD THEN MD%(0, 2) = MD%(0, 2) / 2
    IF DIE <> 0 AND SAVED <> 0 THEN
	PRINT "Do you want to restart (Y/N)  ";
	YN$ = INPUT$(1)
	IF UCASE$(YN$) = "Y" THEN RUN
    END IF
    IF DIE THEN OPEN "LASTADV" FOR OUTPUT AS #1: WRITE #1, " ": CLOSE : GOTO GET.MASTER
    OPEN "LASTADV" FOR OUTPUT AS #1
    WRITE #1, MN$(0)
    FOR M = 1 TO NM
    FOR A = 1 TO 15
    PRINT #1, MD%(M, A)
    NEXT A, M
    FOR A = 1 TO NZ
    PRINT #1, AD%(A, 4) * ABS(AD%(A, 4) <> -1)
    NEXT
    CLOSE
    GOSUB CHK.SUCCESS
    FOR W = 1 TO 4
    WN$(W) = "NONE"
    NEXT
    W2 = 1
    FOR A = 1 TO NA
    IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 AND AD%(A, 4) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, 4) = 0
    NEXT A
    IF W2 < 6 THEN GOTO SELL.TREASURE
PLAYER.RETURNS:
    CLS
    LOCATE 5, 1
    PRINT "As you start to enter the Main Hall, Lord William Misslefire appears and"
    PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
    PRINT
    PRINT "Your weapons are--"
    FOR W = 1 TO W2 - 1
    PRINT SPC(4); W; "--"; WN$(W)
    NEXT
    PRINT
    PRINT "Enter the number of the weapon to sell  (1-"; W2 - 1; ") "
SELL.WEAPON:
    LOCATE CSRLIN - 1, 53
    INPUT A$
    W5 = VAL(A$)
    IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO SELL.WEAPON
    AD%(WP%(W5), 4) = -1
    WN$(W5) = WN$(W2 - 1)
    WP%(W5) = WP%(W2 - 1)
    W2 = W2 - 1
    IF W2 > 5 THEN GOTO PLAYER.RETURNS
SELL.TREASURE:
    IF MD%(0, 8) > AC THEN MD%(0, 8) = AC
    FOR W = 1 TO 4
    IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
    NEXT W
    CLS
    LOCATE 5, 1
    PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
    PRINT "things, he examines your goods and pays you ";
    TP = 0
    FOR A = 1 TO NA
    IF A = ArmPtr OR A = ShdPtr THEN GOTO NEXT.TREASURE 
    IF AD%(A, 4) <> -1 THEN GOTO NEXT.TREASURE
    IF AD%(A, 2) <> 0 THEN AD%(A, 1) = AD%(A, 1) * CH / 10
    TP = TP + AD%(A, 1)
NEXT.TREASURE:
    NEXT A
    PRINT TP; " gold pieces."
    PRINT
    GOLD& = GOLD& + TP
    IF GOLD& < 0 THEN GOLD& = 0
    PRINT
    PRINT "(Press any key to continue)  ";
    A$ = INPUT$(1)
    PRINT
GET.MASTER:
    CLS
    LOCATE 5, 1
 '  PRINT "  Insert Eamon Master Diskette, and press <RETURN>  OR     "
 '  PRINT
 '  PRINT "  Enter Path of Master ===> ";
 '  INPUT "", MastPath$
    IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
    IF MastPath$ <> "" THEN CHDIR MastPath$
    ON ERROR GOTO Invalid.Path
    IF DIE THEN
	CLOSE
	CLEAR
	OPEN PATH$ + "ADVENT" FOR OUTPUT AS #1
	CLOSE
	KILL PATH$ + "ADVENT"
	RUN PATH$ + "WORLD"
    END IF
    CLOSE
    GOSUB OPEN.CHARACTERS
    Nam$ = MN$(0)
    HD = MD%(0, 1)
    AG = MD%(0, 2)
    GOSUB WRITE.CHARACTER
    CLOSE
    OPEN PATH$ + "ADVENT" FOR OUTPUT AS #1
    PRINT #1, MN$(0)
    PRINT #1, REC
    CLOSE
    CLEAR
    RUN "HALL"
Invalid.Path:
    PRINT
    PRINT "Invalid Path, or Master Not Found. Please re-try ..."
    PRINT " (press any key to continue)";
    A$ = INPUT$(1)
    RESUME GET.MASTER
QUIT.RTN:
    PRINT "Do you want to Quit this game? (Y/N) ";
    A$ = INPUT$(1)
    IF UCASE$(A$) = "N" THEN GOTO GET.COMMAND
    CLOSE
    END
CHK.SUCCESS:
'    /// SUCCESSFUL?
    GOTO MISSION.OVER
MISSION.OVER:
    PRINT
    PRINT " (PRESS ANY KEY)      ";
    A$ = INPUT$(1)
    PRINT
    RETURN
' --------------------------------------------------------------------------
MOVE.RTN:
    IF IV = 0 THEN
	IF NBTL AND S$ <> "FLEE" THEN
	    IF TT = 0 THEN
		PGPRT 2, "You can't do that with unfriendlies about!"
		GOTO MAIN.LOOP
	    END IF
	END IF
    END IF
    D = C
    R2 = RD%(D)
    GOSUB DecodeRoom
    IF Rmcd = 1 THEN GOTO PASSAGE.BLOCKED
CHK.SPECIAL.MOVES:
    IF R2 > 0 AND R2 <= NR THEN GOTO MOVE.IT
    IF R2 <> -99 THEN GOTO CANT.GO
    PRINT
    PRINT "You may leave if you wish, but whatever you take with you, you cannot use on your next visit, so you may want to drop some things."
    PRINT
    PRINT "Hit 'Y' to return to the Main Hall, 'N' to stay a short while longer  ";
    A$ = ""
    WHILE A$ <> "Y" AND A$ <> "N"
    A$ = UCASE$(INPUT$(1))
    WEND
    PRINT
    ON ABS(A$ = "N") + 1 GOTO Game.Over, MAIN.LOOP
    IF R2 = 0 THEN GOTO CANT.GO
    GOTO CANT.GO
PASSAGE.BLOCKED:
    GT = ACT.ROOM
    IF AD%(GT, 4) <> Room THEN R2 = AD%(GT, 5): GOTO CHK.SPECIAL.MOVES
    PGPRT 2, "The " + AN$(GT) + " blocks the way!"
    GOTO MAIN.LOOP
CANT.GO:
    PGPRT 2, "You can't go that way!"
    V%(Room) = 0
    GOTO MAIN.LOOP
MOVE.IT:
    R3 = Room
    Room = R2
    GOSUB CHK.REACTIONS
    GET #1, Room
    NX = 0
    FOR X = 1 TO ND
    RD%(X) = CVI(RF.DIR$(X))
    IF RD%(X) < 0 AND RD%(X) > -NR AND V%(Room) > 1 THEN RD%(X) = ABS(RD%(X))
COUNT.EXITS:      ' COUNT.EXITS
    IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
    NEXT
    LT = -1
    GOTO END.LOOP
CHK.REACTIONS:
    TD%(1) = 0
    TD%(3) = MD%(0, 1)
    FD%(1) = 0
    FD%(3) = MD%(0, 13)
    FOR M = 1 TO NM
    IF MD%(M, 15) = 2 AND MD%(M, 5) = Room THEN GOTO MONSTER.NOT.HERE
    IF MD%(M, 5) = R3 THEN IF MD%(M, 14) = 3 OR (MD%(M, 14) = 1 AND 200 * RND(1) < MD%(M, 4)) THEN MD%(M, 5) = Room: GOTO ADD.SIDES
MONSTER.REACTS:
    IF MD%(M, 5) <> Room THEN GOTO MONSTER.NOT.HERE
    IF MD%(M, 14) > 0 THEN GOTO ADD.SIDES
    FR = MD%(M, 3)
    IF FR > 0 AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
    MD%(M, 14) = 1
    IF FR > (100 * RND(1)) THEN MD%(M, 14) = 2: IF FR > (100 * RND(1)) THEN MD%(M, 14) = 3
ADD.SIDES:
    A = MD%(M, 14)
    FD%(A) = FD%(A) + MD%(M, 13)
    TD%(A) = TD%(A) + MD%(M, 1)
MONSTER.NOT.HERE:
    NEXT
    GOTO SET.NBTL
SET.NBTL:
    NBTL = (TD%(1) > 0)
    RETURN
BRING.IN.BEASTS:
    MD%(M, 5) = Room
    MD%(M, 13) = 0
    R3 = Room
    GOSUB CHK.REACTIONS
    RETURN
DecodeRoom:
    Select Case R2
        Case 1 To Max.Rm
            Rmcd = 0
            R = R2
        Case Ins.Adj + 1 To Ins.Adj + Max.Art
            Rmcd = 1
            R = R2 - Ins.Adj
        Case Emb.Adj + 1 To Emb.Adj + Max.Rm
            Rmcd = 2
            R = R2 - Emb.Adj
        Case Hid.Adj + 1 To Hid.Adj + Max.Rm
            Rmcd = 3
            R = R2 - Hid.Adj
        Case Bury.Adj + 1 To Bury.Adj + Max.Rm
            Rmcd = 4
            R = R2 - Bury.Adj
        Case Is < 0
            Rmcd = -1
            R = Abs(R2) - 1
        Case Else
    End Select
    RETURN
' --------------------------------------------------------------------------
GET.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You can't find anything.": GOTO MAIN.LOOP
    IF S$ = "ALL" THEN GOTO GET.ALL
    EMB = Room + EMB.ADJ
    WH = Room
    HA = Room
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "I see no " + LCASE$(S$) + " here!": GOTO MAIN.LOOP
    GOSUB GET.SURPRISE
    IF POP THEN GOTO MAIN.LOOP
    IF GT = 0 THEN GOTO MAIN.LOOP
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, "You can't budge it!": GOTO MAIN.LOOP
    PGPRT 2, "Got it."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
    IF (AD%(A, 2) = 2 OR AD%(A, 2) = 3) AND MD%(0, 9) = -1 THEN GOTO CALCULATE.ODDS
    GOTO GET.BACK
GET.ALL:
    FOR A = 1 TO NA
    IF AD%(A, 4) <> Room OR AD%(A, 2) = 10 THEN GOTO GET.NEXT
    GOSUB GET.SURPRISE
    IF POP THEN GOTO MAIN.LOOP
    IF GT = 0 THEN GOTO GET.NEXT
    IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, AN$(A) + " can't be moved.": GOTO GET.NEXT
    PGPRT 1, AN$(A) + " taken."
    AD%(A, 4) = -1
    WT = WT + AD%(A, 3)
GET.NEXT:      ' GET.NEXT
    NEXT
    GOTO GET.BACK
GET.SURPRISE:      ' GET.SURPRISE
'    /// INSERT HERE SPECIAL EFFECTS OF PICKING SOMETHING UP
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 1 AND ArmPtr = 0 THEN 
    	ArmPtr = A
    	GOSUB Ready.Armor
    END IF	
    IF AD%(A, 2) = 11 AND AD%(A, 6) = 2 AND ShdPtr = 0 THEN 
    	ShdPtr = A
    	GOSUB Ready.Armor
    END IF	
    GT = 1
    POP = 0
    IF A = 19 AND AD%(18, 4) <> -1 THEN PGPRT 2, "You have nothing to carry the holy water in!": GT = 0: RETURN
    IF A = 19 THEN PGPRT 2, "You put the holy water in the bottle.": AD%(19, 4) = 0: AD%(18, 4) = 0: AD%(17, 4) = -1: RETURN
    IF A = 14 THEN MD%(24, 10) = MD%(24, 10) - 10
    IF A = 5 THEN PGPRT 2, "As you touch the emerald, the scene around you shifts, and you find": PGPRT 1, "  yourself elsewhere.": R2 = 31: GOTO MOVE.IT
    IF A = 22 THEN PGPRT 2, "As you touch the Oscar, you feel the world spin around you, and when": PGPRT 1, "  your head clears, you discover--": R2 = 18: GOTO MOVE.IT
    IF A = 12 THEN
	PGPRT 2, "As you touch the statue, it grows in size to the full size of a man and comes"
	PGPRT 1, " to life!"
	AD%(A, 4) = 0
	MD%(8, 5) = Room
	GOSUB CHK.REACTIONS
	GT = 0
	POP = -1
    END IF
    RETURN
RATTLE.MONSTER:      ' RATTLE.MONSTER
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room THEN
	PGPRT 1, MN$(M) + " is slightly unnerved!"
	MD%(M, 4) = MD%(M, 4) - 10
    END IF
    NEXT
    RETURN
SPECIAL.ROOM.CHK:
    GET #2, Room
    A$ = RTRIM$(Desc$)
    PGPRT 2, A$
    V%(Room) = V%(Room) + 1
    RETURN
' ---------------------------------------------------------------------------
MONSTER.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NM
    IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = WH OR MD%(X, 5) = HA) THEN FOUND = FOUND + 1: M = X: IF S$ = MN$(X) THEN X = 9999
    NEXT
    RETURN
' ---------------------------------------------------------------------------
ARTIFACT.SEARCH:
    WH = Room
    HA = -1
    EMB = Room
LOCATE.ARTIFACT:
    FOUND = 0
    SL = LEN(S$)
    FOR X = 1 TO NA
    IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = HA OR AD%(X, 4) = EMB) THEN FOUND = FOUND + 1: A = X: IF S$ = AN$(X) THEN X = 9999
    NEXT
    RETURN
' --------------------------------------------------------------------------
GET.SUBJ:
    WHILE S$ = ""
      PRINT
      PRINT C$(C); " What";
      INPUT S$
      PGPRT 2, ""
    WEND
    S$ = UCASE$(S$)
    RETURN
' --------------------------------------------------------------------------
DROP.RTN:
    GOSUB GET.SUBJ
    IF S$ = "ALL" THEN GOTO DROP.ALL
    IF S$ = "WATER" THEN S$ = "HOLY WATER"
    IF S$ = "HOLY WATER" AND AD%(17, 4) = -1 THEN A = 19: GOTO DROP.SOMETHIN
    WH = -1
    HA = -1
    EMB = -1
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying a " + LCASE$(S$) + "!": GOTO MAIN.LOOP
DROP.SOMETHIN:
    WT = WT - AD%(A, 3)
    AD%(A, 4) = Room
    PGPRT 2, AN$(A) + " dropped."
    IF A = ArmPtr OR A = ShdPtr THEN MD%(0, 8) = MD%(0, 8) - AD%(A, 7)
    IF A = LS THEN LS = 0: LC = 0: LM = 0: LT = NL: PgPrt 2, "The " + AN$(A) + " goes out."
    GOSUB DROP.SPECIAL
CHK.WGHT:      ' CHK.WGHT
    IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAPON:
    IF MD%(0, 9) > 0 THEN IF AD%(MD%(0, 9), 4) <> -1 THEN MD%(0, 9) = -1
    GOTO GET.BACK
DROP.ALL:       ' DROP.ALL
    SR = Room
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 AND A <> ArmPtr THEN
	PGPRT 2, AN$(A) + " dropped."
	AD%(A, 4) = Room
	GOSUB DROP.SPECIAL
    END IF
    NEXT
    WT = 0
    GOTO CHK.DROP.WEAPON
DROP.SPECIAL:
    IF IV THEN GOSUB RATTLE.MONSTER
    IF A = ArmPtr OR A = ShdPtr THEN GOSUB Drop.Armor	
    D = 1
    IF A = 6 AND AD%(8, 4) = Room THEN GOTO DROP.FOOD
    IF A = 14 THEN MD%(24, 10) = MD%(24, 10) + 10
    IF A <> 17 AND A <> 19 THEN RETURN
    IF A = 19 AND AD%(17, 4) = -1 THEN AD%(17, 4) = 0: AD%(18, 4) = -1
    IF MD%(24, 5) <> Room AND MD%(6, 5) <> Room THEN RETURN
    AZ = A
    A = 0
    D = 3
    S = 8
    DF = 6
    IF MD%(24, 5) = Room THEN DF = 24
    PRINT "The " + MN$(DF) + " gives a horrible shriek as the holy water touches him!"
    PRINT
    GOSUB DO.DAMAGE
    A = AZ
    D = 0
    RETURN
Drop.Armor:
    IF A = ArmPtr THEN ArmPtr = 0
    IF A = ShdPtr THEN ShdPtr = 0
    MD%(0, 8) = MD%(0, 8) - AD%(A, 7)
    EA = EA + AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
Ready.Armor:
    MD%(0, 8) = MD%(0, 8) + AD%(A, 7)
    EA = EA - AD%(A, 5)
    W = MD%(0, 9)
    MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
    RETURN
DROP.FOOD:
    PRINT
    PRINT "The brown chest reveals itself to be a chest-mimic and goes off in a corner"
    PRINT "to eat the lamb chop."
    PRINT
    AD%(A, 4) = 0
    AD%(8, 4) = 0
    MD%(12, 5) = Room
    MD%(12, 14) = 2
    D = 0
    RETURN
' ---------------------------------------------------------------------------
LOOK.RTN:
    IF LT = 0 THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    LK = 0
    IF S$ = "" THEN GOTO GENERAL.LOOK
    GOSUB EXAMINE.NONART
    IF LK THEN GOTO GET.BACK
    WH = Room
    HA = -1
    EMB = Room + EMB.ADJ
    GOSUB LOCATE.ARTIFACT
    IF FOUND AND AD%(A, 4) = EMB THEN AD%(A, 4) = Room
    IF FOUND THEN GOSUB EXAMINE.ARTIFACT: GOTO GET.BACK
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOSUB EXAMINE.MONSTER
GENERAL.LOOK:      ' GENERAL.LOOK
    IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
    FOR A = 1 TO NA
    IF AD%(A, 4) = HID.ADJ + Room THEN LK = -1: GOSUB FIND.ARTIFACT
    NEXT
    IF LK THEN PGPRT 2, "You found something.": GOTO GET.BACK
    FOR X = 1 TO ND
    IF RD%(X) < 0 AND RD%(X) >= -NR THEN GOSUB SECRET.PASSAGE
    NEXT
NOTHIN.TA.SEE:      ' NOTHIN.TA.SEE
    V%(Room) = 0
    GOTO GET.BACK
EXAMINE.MONSTER:      ' EXAMINE.MONSTER
    R = M + MAX.EFF
    GOSUB PRINT.EFFECT
    RETURN
EXAMINE.NONART:      ' EXAMINE.NONART (S$)
    RETURN
SECRET.PASSAGE:
    RD%(X) = ABS(RD%(X))
    V%(Room) = 2
    IF LK = 0 THEN PGPRT 2, "You found a secret passage " + C$(X) + "!": NX = NX + 1
    RETURN
EXAMINE.ARTIFACT:
'     === EXAM ART A
    IF A > NZ THEN PGPRT 2, "This is your " + AN$(A) + "."
    IF A > NZ - NM THEN PGPRT 2, "Yes, he's dead!": RETURN
    GET #2, A + ART.ADJ
    A$ = RTRIM$(Desc$)
    PGPRT 2, A$
    LK = -1
    AD%(A, 9) = 1
    RETURN
FIND.ARTIFACT:      ' FIND.ARTIFACT
'      == DISCOVER ARTIFACT A HIDDEN IN ROOM!
'    --- INSERT HERE ANY SPECIAL DISCOVERY MESSAGES ---
'        SUCH AS "YOU FOUND SOMETHING UNDER THE BED"
    LK = -1
    AD%(A, 4) = Room
    RETURN
' ---------------------------------------------------------------------------
ATTACK.RTN:
    GOSUB GET.SUBJ
    IF LT = 0 THEN PGPRT 2, "You swing wild --- nothing hit.": GOTO GET.BACK
    IF S$ = "WOMAN" AND Room = MD%(9, 5) THEN S$ = "SUCCUBUS"
    IF LEFT$(S$, 5) = "CHEST" THEN S$ = "MIMIC"
    GOSUB MONSTER.SEARCH
    IF FOUND THEN GOTO ATTACK.MON
    TA = 0
    GOTO ASSAULT.ARTIFACT
ATTACK.MON:
    IF MD%(0, 9) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO MAIN.LOOP
    OF = 0
    DF = M
    GOSUB TAKE.A.SWING
    IF HIT = 0 THEN GOTO MISSED
    IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
    IF -EA <= AE THEN GOTO GET.BACK
    IF INT(100 * RND(1) + 1) <= MD%(0, 10) THEN GOTO MISSED
    A = 2
    IF EA + AE = -1 THEN A = 1
    AE = AE + A
    MD%(0, 10) = MD%(0, 10) + A
MISSED:
    IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO GET.BACK
    MD%(DF, 3) = MD%(DF, 3) / 2
    FOR M = 1 TO NM
    IF MD%(M, 5) = Room AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
    NEXT
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
MON.GET.GUN:      ' MON.GET.GUN
'    -- MONSTER PICK-UP WEAPON
    IF MD%(OF, 10) = 0 THEN RETURN
    A = 0
    FOR X = 1 TO NA
    IF AD%(X, 4) = Room AND (AD%(X, 2) = 2 OR AD%(X, 2) = 3) THEN A = X: X = NA
    NEXT
    IF A = 0 THEN RETURN
    PGPRT 2, MN$(OF) + " picks up " + AN$(A) + "."
    AD%(A, 4) = 0
    MD%(OF, 9) = A
    MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5)
    MD%(OF, 4) = MD%(OF, 4) * 2
    RETURN
TAKE.A.SWING:
    HIT = 0
    IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
    IF DF = 0 AND IV THEN RETURN
    PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
    PRINT " --";
    RL = INT(100 * RND(1) + 1)
    HIT = 0
    IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = 1
    IF HIT THEN GOTO A.HIT
    IF RL < 97 THEN PGPRT 1, " A miss!": RETURN
    PGPRT 1, "A fumble!"
    FR = INT(100 * RND(1) + 1)
    IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PGPRT 1, "   fumble recovered.": RETURN
    IF FR < 76 THEN
	PGPRT 1, "  weapon dropped!"
	AD%(MD%(OF, 9), 4) = Room
	MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
	MD%(OF, 9) = -1
	MD%(OF, 4) = MD%(OF, 4) / 2
	RETURN
    END IF
    IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PGPRT 1, "Sparks fly from " + AN$(W) + "!": RETURN
    IF FR > 95 THEN GOTO SELF.OUCH
    PGPRT 1, "  weapon breaks!"
    AD%(MD%(OF, 9), 4) = 0
    MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
    MD%(OF, 9) = -1
    MD%(OF, 4) = MD%(OF, 4) / 2
    IF RND(1) > .5 THEN RETURN
    PGPRT 1, "  broken weapon hurts user!"
SELF.OUCH:
    IF FR = 100 THEN GOTO SELF.YEOW
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    DF = OF
    A = 1
    GOTO DO.DAMAGE
SELF.YEOW:
    D = MD%(OF, 11) * 2
    S = MD%(OF, 12)
    DF = OF
    A = 0
    GOTO DO.DAMAGE
A.HIT:
    INC = ABS(INT(100 * RND(1) + 1) > MD%(OF, 10))
    MD%(OF, 10) = MD%(OF, 10) + 2 * INC
    D = MD%(OF, 11)
    S = MD%(OF, 12)
    A = 1
    IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO DO.DAMAGE
    PGPRT 1, "A critical hit!"
    R2 = INT(100 * RND(1) + 1)
    IF R2 < 51 THEN A = 0: GOTO DO.DAMAGE
    IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
    IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
    IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
    GOTO IS.DEAD
DO.DAMAGE:      ' DO.DAMAGE
    D2 = 0
    FOR D3 = 1 TO D
    D2 = D2 + INT(S * RND(1) + 1)
    NEXT
    D2 = D2 - A * MD%(DF, 8)
    IF DF > 8 AND DF < 13 AND OF = 0 AND MD%(0, 9) = 6 THEN D2 = D2 + 2
    IF D2 < 1 THEN PGPRT 1, "   blow bounces off armour.": RETURN
APPLY.DAMAGE:      ' APPLY.DAMAGE
    MD%(DF, 13) = MD%(DF, 13) + D2
    IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO DEAD.RTN
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + D2
SHOW.CONDITION:
    A$ = MN$(DF)
    ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:      ' GOOD.SHAPE
    PGPRT 2, A$ + " is still in good shape."
    RETURN
HURTING:      ' HURTING
    PGPRT 2, A$ + " is hurting."
    RETURN
IN.PAIN:      ' IN.PAIN
    PGPRT 2, A$ + " is in pain."
    RETURN
BADLY.INJURED:      ' BADLY.INJURED
    PGPRT 2, A$ + " is very badly injured."
    RETURN
DEATHS.DOOR:      ' DEATHS.DOOR
    PGPRT 2, A$ + " is at death's door, knocking loudly."
    RETURN
DEAD.RTN:
    IF DF = 0 THEN PGPRT 2, "You are dead!": DIE = -1: GOTO Game.Over
IS.DEAD:      ' IS.DEAD
'    /// MONSTER DIES
    PGPRT 2, MN$(DF) + " is dead!"
    A = MD%(DF, 14)
    FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
    MD%(DF, 5) = 0
    IF DF = 17 THEN RETURN
    FOR AJ = 1 TO NA
    IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = Room
    NEXT
    IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = Room: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
GET.BODY:
    IF DF = 0 AND OF <> 8 THEN DIE = 1: GOTO Game.Over
    IF DF > 0 THEN GOTO SOMEONE.DIES
    PGPRT 2, "with your dying eyes you see      " + AN$(8) + " fading"
    PGPRT 1, "away, while your body shrinks and becomes a statue, waiting for the"
    PGPRT 1, "next sucker to come along."
    MD%(0, 9) = 26
    CLOSE
    GOSUB WRITE.MONSTER
    CLOSE
    DIE = -1
    GOTO Game.Over
SOMEONE.DIES:
    IF DF = 8 THEN PGPRT 2, "As he dies, " + MN$(8) + " once again becomes a statue.": AD%(43, 4) = 0: AD%(26, 4) = 0: AD%(12, 4) = Room: RETURN
    IF DF = 7 THEN PGPRT 2, "As he dies, the collar falls off from the neck of the Tiger.": AD%(3, 4) = Room
    A2 = DF + NZ - NM
    AD%(A2, 4) = Room
    RETURN
FLEE.RTN:
    IF NBTL = 0 THEN PGPRT 2, "There's nothing to flee from!": GOTO MAIN.LOOP
    IF NX = 0 THEN PGPRT 2, "There's no place to go!": GOTO MAIN.LOOP
    IF S$ <> "" THEN
	C = 0
	FOR D = 1 TO ND
	    IF S$ = LEFT$(UCASE$(C$(D)), LEN(S$)) THEN C = D: Exit For
	NEXT
	IF C > 0 THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
    END IF
    GOSUB FIND.EXIT
    GOTO MOVE.IT
FIND.EXIT:
    IF NX = 0 THEN R2 = Room: PGPRT 1, " ... but can't find an exit!": RETURN
    R2 = RD%(ND * RND(1) + 1)
    IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
    RETURN
' ---------------------------------------------------------------------------
GIVE.RTN:
    IF S$ = "" THEN GOSUB GET.SUBJ
    A = 0
    M = 0
    M$ = ""
    A$ = ""
    SEP = INSTR(S$, " TO ")
    IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
    END IF
    SEP = INSTR(S$, " ")
    IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF FOUND THEN
	      M$ = S$
	      A$ = MID$(SAVE.S$, SP)
	      GOTO READY.SEARCH.GIVE
	  END IF
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
	    A$ = MID$(S$, SEP + 1)
	    M$ = LEFT$(S$, SEP - 1)
	ELSE
	    GOSUB GIVE.WHO
	    GOSUB GIVE.WHAT
	END IF
    ELSE
	GOSUB ARTIFACT.SEARCH
	IF FOUND THEN
	    A$ = AN$(A)
	ELSE
	    GOSUB MONSTER.SEARCH
	    IF FOUND THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
	    END IF
	END IF
    END IF
READY.SEARCH.GIVE:
    GOSUB GIVE.WHO
    GOSUB GIVE.WHAT
    IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
    END IF
    IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
	    S$ = A$
	    GOSUB ARTIFACT.SEARCH
	END IF
    END IF
    IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
    IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
    PGPRT 2, "I don't know what you mean."
    GOTO MAIN.LOOP
RESOLVE.GIVE:      ' RESOLVE.GIVE
    PGPRT 2, "Okay."
    POP = 0
    GOSUB GIVE.ART.MON
    IF POP <> 0 THEN GOTO MAIN.LOOP
    IF A = MD%(0, 9) THEN MD%(0, 9) = -1
    AD%(A, 4) = -M - 1
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
    IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO CHK.WGHT
GIVE.ART.MON:
 ' PUT SPECIAL CODE HERE FOR GIVING ITEM (A) TO MONSTER (M)
 ' IF MONSTER REFUSES OR SOME SPECIAL ACTION WHERE ITEM DOESN'T CHANGE
 ' HANDS OCCURS, THEN SET POP = -1 AND RETURN FROM THIS ROUTINE.
    IF A = ArmPtr OR A = ShdPtr THEN GOSUB Drop.Armor
    RETURN
GIVE.GOLD:
    IF VAL(A$) > GOLD& THEN PGPRT 2, "You aren't carrying that much gold!": GOTO GET.BACK
    GOLD& = INT(GOLD& - VAL(A$))
    MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
    MD%(M, 14) = 0
    IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
    GOTO COMPLETE.GIVE
GIVE.WHO:
    IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
    RETURN
GIVE.WHAT:
    IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
    RETURN

' ---------------------------------------------------------------------------
INVENTORY.RTN:
    IF IV THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
    PGPRT 2, "You are carrying the following--"
    FOR A = 1 TO NA
    IF AD%(A, 4) = -1 THEN
	PRINT " " + AN$(A);
	IF A = MD%(0, 9) THEN PRINT " (Ready weapon)";
	IF A = ArmPtr THEN PRINT " (Wearing as armor)";
	IF A = ShdPtr THEN PRINT " (Your Shield)";
	PGPRT 1, A$
    END IF
    NEXT
    PGPRT 1, STR$(GOLD&) + " gold pieces."
    GOTO GET.BACK
' --------------------------------------------------------------------------
BLAST.SPELL:
    GOSUB GET.SUBJ
    GOSUB MONSTER.SEARCH
    IF FOUND = 0 THEN GOTO BLASTED.DOOR
    S = 1
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    PGPRT 2, "Direct Hit!"
    S = 5
    D = 2
    DF = M
    A = 0
    GOSUB DO.DAMAGE
    GOTO GET.BACK
BLASTED.DOOR:
'    /// BLAST DOOR/GATE OR CONTAINER?
    TA = 1
    GOTO ASSAULT.ARTIFACT
' ---------------------------------------------------------------------------
CAST.SPELL:
    SUC = 0
    IF SA%(S) THEN RL = INT(100 * RND(1) + 1): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN SUC = 0
    IF SUC = 0 THEN PGPRT 2, "Nothing happened.": RETURN
    RL = INT(100 * RND(1) + 1)
    IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
    S2%(S) = S2%(S) * .8
    RETURN
' ---------------------------------------------------------------------------
HEAL.SPELL:
    S = 2
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
HEAL.WOUNDS:
    M = 0
    IF S$ <> "" THEN GOSUB MONSTER.SEARCH
    IF M = 0 THEN S$ = "your" ELSE S$ = MN$(M) + "'s"
    IF MD%(M, 13) THEN
	PGPRT 2, "Some of " + S$ + " wounds seem to clear up."
	MD%(M, 13) = MD%(M, 13) - INT(10 * RND(1) + 1)
    END IF
    IF MD%(M, 13) < 0 THEN MD%(M, 13) = 0
    DF = M
    GOSUB SHOW.CONDITION
    GOTO GET.BACK
' --------------------------------------------------------------------------
POWER.SPELL:
    S = 4
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    RR = INT(RND(1) * 100 + 1)
    IF RR > 15 THEN GOTO POWER.3
REM   15% CHANCE OF TELEPORTING ALL MONSTERS TO ROOM
    IF Room > 30 THEN GOTO POWER.2
    FOR M = 1 TO NM
    IF MD%(M, 5) > 0 AND MD%(M, 5) < 31 AND MD%(M, 5) <> Room THEN MD%(M, 5) = Room: PRINT MN$(M); " just teleported in!"
    NEXT
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO MAIN.LOOP
POWER.2:
    FOR M = 1 TO NM
    IF MD%(M, 5) > 30 AND MD%(M, 5) <> Room THEN MD%(M, 5) = Room: PRINT MN$(M); " JUST TELEPORTED IN!"
    NEXT
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO MAIN.LOOP
POWER.3:
    IF RR > 30 THEN GOTO POWER.4
REM   15% OF ALL COURAGES GOING DOWN BY HALF
    FOR M = 1 TO NM
    MD%(M, 4) = MD%(M, 4) / 2 + .5
    IF MD%(M, 5) = Room AND RND(1) > .75 THEN PRINT MN$(M); " SEEMS FRIGHTENED."
    NEXT
    GOTO GET.BACK
POWER.4:
    IF RR > 45 THEN GOTO POWER.5
REM   15% OF HEAL SPELL
    GOTO HEAL.WOUNDS
POWER.5:
    IF RR > 65 THEN GOTO POWER.6
REM   20% OF RESTORING NON-POWER SPELL ABILITIES
    PGPRT 2, "All of your spell abilities (except for power) have just gone up to original    levels!"
    FOR S = 1 TO 3
    S2%(S) = SA%(S)
    NEXT
    GOTO GET.BACK
POWER.6:
    IF RR > 75 THEN GOTO POWER.7
REM   10% CHANCE OF INSTANT DEATH
    PGPRT 2, "You suddenly find yourself teleported to a spot in the air one mile over      the castle.  After the long fall, you   die."
    DIE = 1
    GOTO Game.Over
POWER.7:
    IF RR > 80 THEN PGPRT 2, "The loud sound of a sonic boom echoes through the corridors.": GOTO GET.BACK
REM   5% CHANCE OF FRIENDLINESS, 20% CHANCE OF SONIC BOOM
    FOR M = 1 TO NM
    IF MD%(M, 14) > 0 AND MD%(M, 14) < 3 THEN MD%(M, 14) = MD%(M, 14) + 1
    NEXT
    IF NBTL THEN PGPRT 2, "Suddenly, everybody stops fighting!": NBTL = 0
    GOTO GET.BACK
' --------------------------------------------------------------------------
SPEED.SPELL:
    S = 3
    GOSUB CAST.SPELL
    IF SUC = 0 THEN GOTO GET.BACK
    IF SPD <> 0 THEN PGPRT 2, "Nothing Happens.": GOTO MAIN.LOOP
    MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2)
    MD%(0, 2) = 2 * MD%(0, 2)
    SPD = SPD + INT(25 * RND(1) + 10)
    PGPRT 2, "You can feel the new agility flowing through you!"
    GOTO GET.BACK
' --------------------------------------------------------------------------
SMILE.RTN:
    IF IV THEN GOTO GET.BACK
    PGPRT 1, " "
    FOR M = 1 TO NM
      IF MD%(M, 5) = Room AND MD%(M, 15) <= 1 THEN
	  ON MD%(M, 14) GOSUB GROWLS, IGNORES, SMILES
      END IF
    NEXT
    PGPRT 1, " "
    GOTO GET.BACK
GROWLS:
    PGPRT 1, MN$(M) + " growls at you!"
    RETURN
IGNORES:
    PGPRT 1, MN$(M) + " ignores you."
    RETURN
SMILES:
    PGPRT 1, MN$(M) + " " + LCASE$(C$(C)) + "s back."
    RETURN
' --------------------------------------------------------------------------
SAY.SOMETHING:
    GOSUB GET.SUBJ
    IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
    IF S$ = "HEAL" THEN GOTO HEAL.SPELL
    IF S$ = "POWER" THEN GOTO POWER.SPELL
    IF S$ = "SPEED" THEN GOTO SPEED.SPELL
    PGPRT 2, "Okay, " + CHR$(34) + S$ + CHR$(34)
    IF IV THEN GOSUB RATTLE.MONSTER
    GOTO GET.BACK
' --------------------------------------------------------------------------
READY.WEAPON:
    GOSUB GET.SUBJ
    WH = -1
    HA = WH
    EMB = HA
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO MAIN.LOOP
    IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PGPRT 2, "That isn't a weapon!": GOTO MAIN.LOOP
CALCULATE.ODDS:
    MD%(0, 10) = (EA + AE) * ABS(-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
    MD%(0, 9) = A
    MD%(0, 11) = AD%(A, 7)
    MD%(0, 12) = AD%(A, 8)
    PGPRT 2, "Readied."
    GOTO GET.BACK
' --------------------------------------------------------------------------
OPEN.RTN:
    GOSUB GET.SUBJ
    IF S$ = "STOVE" AND Room = 20 THEN PGPRT 2, "It won't open.": GOTO GET.BACK
    IF (LEFT$(S$, 5) = "WOMAN" OR LEFT$(S$, 3) = "CHA") AND Room = 26 AND E1 = 0 THEN GOTO RELEASE.WOMAN
OPEN.WHICH:
    IF S$ = "CHEST" AND Room = 28 THEN PRINT : INPUT "Which chest (brown or blue)?"; A$: S$ = UCASE$(A$) + " " + S$: GOTO OPEN.WHICH
OPEN.CHEST:
    IF (RIGHT$(S$, 5) <> "CHEST" OR Room <> 28) AND (S$ <> "COFFIN" OR Room <> 44) THEN PGPRT 2, "I see no " + S$ + " here.": GOTO GET.BACK
    IF S$ = "COFFIN" THEN GOTO OPEN.COFFIN
    A$ = LEFT$(S$, 2)
    IF (A$ <> "BR" OR AD%(8, 4) <> Room) AND (A$ <> "BL") THEN S$ = S$ + " ": GOTO OPEN.CHEST
    IF A$ = "BL" AND AD%(10, 4) THEN PGPRT 2, "It's empty!": GOTO GET.BACK
    IF A$ = "BL" THEN PGPRT 2, "Something rolls out!": AD%(10, 4) = Room: GOTO GET.BACK
    PGPRT 2, "You never learn, do you?"
    PGPRT 2, "The chest attacks you!"
    AD%(8, 4) = 0
    MD%(12, 5) = Room
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
OPEN.COFFIN:
    PRINT
    IF MD%(24, 5) OR AD%(59, 4) THEN PGPRT 2, "It's empty!": GOTO GET.BACK
    PGPRT 2, "You blew it now, Charley!    You just woke  a vampire up!"
    MD%(24, 5) = Room
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
RELEASE.WOMAN:
    PGPRT 2, "Very well."
    E1 = 1
    MD%(9, 5) = Room
    AD%(7, 4) = Room
    GOSUB CHK.REACTIONS
    GOTO MAIN.LOOP
' --------------------------------------------------------------------------
ASSAULT.ARTIFACT:
    IF TA = 0 THEN PGPRT 2, "Attack who?": GOTO MAIN.LOOP
    PGPRT 2, "You can't blast " + LCASE$(S$) + "!"
    GOTO MAIN.LOOP
CHK.OPEN.SPECIAL:
    RETURN
' --------------------------------------------------------------------------
' ---------------------------------------------------------------------------
READ.RTN:
    IF LT = 0 THEN PGPRT 2, "You can't see.": GOTO MAIN.LOOP
    IF NBTL THEN PGPRT 2, "You can't do that right now!": GOTO MAIN.LOOP
    GOSUB GET.SUBJ
    WH = Room
    HA = -1
    EMB = Room + EMB.ADJ
    GOSUB LOCATE.ARTIFACT
    IF FOUND = 0 THEN PGPRT 2, "I see no " + S$ + " here.": GOTO GET.BACK
    IF S$ <> "BOOK" AND S$ <> "SCROLL" THEN PGPRT 2, "There are no more markings to read!": GOTO GET.BACK
    IF S$ = "SCROLL" THEN PGPRT 2, "The scroll crumbles to dust as you unroll it.": AD%(4, 4) = 0: GOTO GET.BACK
    PGPRT 2, "The book vanishes after you read it."
    R = 0
    AD%(2, 4) = 0
19050 ' LABEL.19050
    IF RND(1) > CH / 24 THEN CH = CH + 1: R = 1: GOTO 19050
    IF R THEN PRINT "   You feel your charisma growing!"
    PRINT
    GOTO GET.BACK
READ.NONART:
'   ...  NON-ART - INSERT HERE SPECIAL READING ...
'   ...  EXAMPLE: READING WALLS OR CEILING, DOORS, ETC ...
    GOTO DONT.UNDERSTAND
READ.ARTIFACT:
'    /// READING A READABLE ARTIF.
    R = AD%(A, 5) + AD%(A, 7) - 1
    GOSUB PRINT.EFFECT
    AD%(A, 7) = AD%(A, 7) + 1
    IF AD%(A, 7) > AD%(A, 6) THEN AD%(A, 7) = 1
    GOTO GET.BACK
' --------------------------------------------------------------------------
PRINT.EFFECT:
    GET #2, R + EFF.ADJ
    A$ = RTRIM$(Desc$)
    PGPRT 2, A$
    RETURN
' --------------------------------------------------------------------------
FREE.RTN:
    GOSUB GET.SUBJ
    IF LEFT$(S$, 5) = "WOMAN" AND Room = 26 AND E1 = 0 THEN GOTO RELEASE.WOMAN
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO DONT.UNDERSTAND
    IF AD%(A, 2) <> 10 THEN GOTO DONT.UNDERSTAND
    M = AD%(A, 5)
    K = AD%(A, 6)
    G = AD%(A, 7)
    IF AD%(A, 4) <> Room AND AD%(A, 4) <> Room + EMB.ADJ THEN PGPRT 2, "I don't know what you are talking about.": GOTO MAIN.LOOP
    IF MD%(G, 5) = Room THEN PGPRT 2, MN$(G) + " won't let you do that!": GOTO GET.BACK
    IF AD%(K, 4) <> -1 AND K <> 0 THEN PGPRT 2, "You don't have the key!": GOTO MAIN.LOOP
    PGPRT 2, "You have freed " + MN$(M) + "."
    MD%(M, 5) = Room
    AD%(A, 4) = 0
    R3 = Room
    GOSUB CHK.REACTIONS
    GOTO GET.BACK
' ---------------------------------------------------------------------------
EAT.RTN:
    GOSUB GET.SUBJ
    GOSUB ARTIFACT.SEARCH
    IF FOUND = 0 THEN GOTO NOT.HUNGRY
    IF A <> 6 THEN PGPRT 2, "You've got to be kidding!": GOTO GET.BACK
    IF AD%(6, 4) = -1 THEN WT = WT - 2
    PGPRT 2, "You find it delicious."
    AD%(6, 4) = 0
    GOTO GET.BACK
NOT.HUNGRY:
    PGPRT 2, "You've got to be kidding!"
    GOTO GET.BACK
' ---------------------------------------------------------------------------
DRINK.RTN:
    GOSUB GET.SUBJ
    IF S$ <> "WATER" AND LEFT$(S$, 4) <> "HOLY" THEN PGPRT 2, "Drink that? Are you nuts?": GOTO GET.BACK
    IF AD%(17, 4) <> Room AND AD%(17, 4) <> -1 AND AD%(19, 4) <> Room AND AD%(19, 4) <> -1 THEN PGPRT 2, "There's no " + S$ + " here!": GOTO GET.BACK
    PGPRT 2, "The gods punish you for your sacriledge by lowering your charisma by one."
    CH = CH - 1
    IF AD%(17, 4) = -1 OR AD%(19, 4) = -1 THEN WT = WT - 2
    AD%(19, 4) = 0
    IF AD%(17, 4) <> 0 THEN AD%(18, 4) = AD%(17, 4): AD%(17, 4) = 0
    IF AD%(A, 2) <> 6 THEN PGPRT 2, "You can't do that!": GOTO MAIN.LOOP
    IF AD%(A, 7) <= 0 THEN PGPRT 2, "There isn't any left.": GOTO GET.BACK
    IF AD%(A, 5) > FNR(100) THEN GOTO DRINK.HEAL
    PGPRT 2, "Nothing seems to happen."
    GOTO GET.BACK
DRINK.HEAL:
    AD%(A, 7) = AD%(A, 7) - 1
    MD%(0, 13) = MD%(0, 13) - AD%(A, 6)
    IF MD%(0, 13) < 0 THEN MD%(0, 13) = 0
    PGPRT 2, "Your wounds seem to " + MID$("openheal", ABS(AD%(A, 6) > 0) * 4 + 1, 4) + "!"
    GOTO GET.BACK
' ---------------------------------------------------------------------------
' ---------------------------------------------------------------------------
SAVE.GAME:
    INPUT "Do you want to save this game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO SAVE.IT
    GOTO MAIN.LOOP
SAVE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
    REM $INCLUDE: '\Eamon\COPY\SAVEGAME.BAS'
    PRINT "Game is saved. To restore it, use restore command."
    SAVED = -1
    CLOSE 1
    GOSUB OPEN.ROOMS
    GOTO MAIN.LOOP
RESTORE.GAME:
    INPUT "Do you want to Restore a game? (Y/N) ", SAVE.GM$
    IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO RESTORE.IT
    GOTO MAIN.LOOP
RESTORE.IT:
    GOSUB GET.GAME.ID
    CLOSE 1
    REM $INCLUDE: '\Eamon\COPY\RESTGAME.BAS'
    GOSUB OPEN.ROOMS
    GOTO MOVE.IT
GET.GAME.ID:
    PRINT
    INPUT "File Name: ", GAME.ID$
    IF LEN(GAME.ID$) > 8 THEN GOTO GET.GAME.ID
    GAME.ID$ = UCASE$(GAME.ID$)
    IF LEFT$(GAME.ID$, 1) < "A" OR LEFT$(GAME.ID$, 1) > "Z" THEN GOTO GET.GAME.ID
    GAME.ID$ = GAME.ID$ + ".GAM"
    RETURN
' ---------------------------------------------------------------------------
    REM $INCLUDE: '\Eamon\Copy\Chario.bas'
    REM $INCLUDE: '\EAMON\COPY\ADVENIO.OLD'
WRITE.MONSTER:
' ------------------ WRITE MONSTER --------------------
    OPEN "MONST.TXT" FOR RANDOM AS #3 LEN = MON.LEN
    FOR M2 = 1 TO MON.FLDS
    FIELD 3, MN.LEN AS MF.NAME$, (M2 - 1) * 2 AS X$, 2 AS MF.DATA$(M2)
    NEXT
    LSET MF.NAME$ = MN$(0)
    FOR A = 1 TO MON.FLDS
    RSET MF.DATA$(A) = MKI$(MD%(0, A))
    NEXT
    PUT #3, 8
    RETURN

SUB PGPRT (SP, LIT$)

    STATIC PG.CNT
    IF SP = 0 THEN PG.CNT = 0: EXIT SUB
    IF LIT$ = "" THEN PG.CNT = PG.CNT + SP: EXIT SUB
    IF PG.CNT > 18 THEN
	LOCATE 24, 1
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-");
	A$ = INPUT$(1)
	PG.CNT = 0
	LOCATE CSRLIN, 1
	PRINT SPC(79);
    END IF
    IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	PG.CNT = PG.CNT + 1
	NEXT
    END IF
    PRINT LIT$
    PG.CNT = PG.CNT + INT(LEN(LIT$) / 80) + 1
END SUB

