  '
  '                    Eamon Adventure #2
  '                -> Lair of the Minotaur <-
  '
  '                      By Donald Brown
  '
  '               converted to IBM-PC by John Nelson
  '
	' ͻ
	'                 National Eamon User's Club                    
	'                   Log of Program Changes                      
	'                                         
	'                                                               
	'    Date     Version      Description of Change                
	'  --------   -------     ------------------------------------- 
	'  06/22/88     2.00      New Base Program used, new give rtn   
	'  01/29/89     2.01      Path input commented out              
	'  12/03/90     2.02      Color Screens Allowed                 
	'   4/21/91     2.03      Hard Disk Support Installed           
	' ͼ
	DEFINT A-Z
	DECLARE SUB PGPRT (SP, LIT$)
REM $$INCL:'\EAMON\COPY\CHARDEF.BAS'
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
	'   Module:  CHARDEF.BAS
	'   Eamon Version:  Eamon-QB (or Eamon-PC)
	' ------------------------------------------------------------
	'  Character Definition for Eamon QB/PC
	'        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
	'                        or BASIC 7.0 PDS
	'       uses Field statements for record description
	'       This module will work for QBasic, but QBasic cannot
	'       support $INCLUDE: statements, so module must be copied
	'       into programs manually or merged using a utility
	' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	'
TYPE WeaponRec
	Nam             AS STRING * 20
	Wpntyp          AS INTEGER
	Odds            AS INTEGER
	Dice            AS INTEGER
	Sides           AS INTEGER
END TYPE

TYPE CharacterRecord
	Nam             AS STRING * 30
	Hd              AS INTEGER
	Ag              AS INTEGER
	Ch              AS INTEGER
	SA1             AS INTEGER
	SA2             AS INTEGER
	SA3             AS INTEGER
	SA4             AS INTEGER
	WA1             AS INTEGER
	WA2             AS INTEGER
	WA3             AS INTEGER
	WA4             AS INTEGER
	WA5             AS INTEGER
	Sex             AS STRING * 1
	Gold            AS LONG
	Bank            AS LONG
	AE              AS INTEGER
	ArmNam          AS STRING * 20
	ArmHit          AS INTEGER
	Armadj          AS INTEGER
	ShdNam          AS STRING * 20
	ShdHit          AS INTEGER
	ShdAdj          AS INTEGER
	Wpn1Nam         AS STRING * 20
	Wpn1typ         AS INTEGER
	Wpn1Wpntyp      AS INTEGER
	Wpn1odds        AS INTEGER
	Wpn1Dice        AS INTEGER
	Wpn1Sides       AS INTEGER
	Wpn2Nam         AS STRING * 20
	Wpn2typ         AS INTEGER
	Wpn2Wpntyp      AS INTEGER
	Wpn2odds        AS INTEGER
	Wpn2Dice        AS INTEGER
	Wpn2Sides       AS INTEGER
	Wpn3Nam         AS STRING * 20
	Wpn3typ         AS INTEGER
	Wpn3Wpntyp      AS INTEGER
	Wpn3odds        AS INTEGER
	Wpn3Dice        AS INTEGER
	Wpn3Sides       AS INTEGER
	Wpn4Nam         AS STRING * 20
	Wpn4typ         AS INTEGER
	Wpn4Wpntyp      AS INTEGER
	Wpn4odds        AS INTEGER
	Wpn4Dice        AS INTEGER
	Wpn4Sides       AS INTEGER
	Filler          AS STRING * 23
END TYPE
DIM Char AS CharacterRecord
TYPE CharControl
	NbrChar         AS INTEGER
	Filler          AS STRING * 254
END TYPE
DIM CharCtl AS CharControl

    '------- (end of include file) -------    
 ' 
	RANDOMIZE TIMER
REM $$INCL:'\EAMON\COPY\COLORRTN.BAS'
     ON ERROR GOTO NoColors
     OPEN "EAMCOLOR" FOR INPUT AS #1
     INPUT #1, fgc%
     INPUT #1, bgc%
     INPUT #1, hfg%
     INPUT #1, hbg%
     CLOSE
In.BW:
     ON ERROR GOTO 0
     COLOR fgc%, bgc%
     GOTO Colorset
NoColors:
      fgc% = 7
      bgc% = 0
      hfg% = 0
      hbg% = 7
      RESUME In.BW
Colorset:

    '------- (end of include file) -------    
 ' 
	CLS
REM $$INCL:'\EAMON\COPY\READCTL.BAS'
     CLOSE 1
     OPEN "DESC.R0" FOR INPUT AS #1
     INPUT #1, NR
     INPUT #1, NZ
     INPUT #1, NE
     INPUT #1, NM
     INPUT #1, ND
     INPUT #1, MAX.RM
     INPUT #1, MAX.ART
     INPUT #1, MAX.EFF
     INPUT #1, Max.Mon
     INPUT #1, Rm.Len
     INPUT #1, Rmn.Len
     INPUT #1, Mon.Len
     INPUT #1, Art.Len
     INPUT #1, Desc.Len
     INPUT #1, Mon.Flds
     INPUT #1, Art.Flds
     INPUT #1, RM.Flds
     INPUT #1, MN.Len
     INPUT #1, AN.Len
     CLOSE 1
     NA = NZ
     ART.ADJ = MAX.RM
     EFF.ADJ = MAX.RM + MAX.ART
     MON.ADJ = MAX.RM + MAX.ART + MAX.EFF
     EMB.ADJ = MAX.RM + MAX.ART
     INS.ADJ = MAX.RM
     HID.ADJ = MAX.RM * 2 + MAX.ART
     BURY.ADJ = MAX.RM * 3 + MAX.ART

    '------- (end of include file) -------    
 ' 
	DIM V%(NR), RD%(10), FD%(3), TD%(3), SA%(4), S2%(4), WA%(5), RF.DIR$(10)
	DIM FWN$(4), FWT$(4), FWC$(4), FWD$(4), FWS$(4), FWA$(5), FSA$(5)
	DIM AN$(NA + 6), AD%(NA + 6, 9)
	DIM MN$(NM), MD%(NM, 16)
	GOSUB READ.ARTIFACTS ' LOAD ARTIFACT TABLE
	GOSUB READ.MONSTERS ' LOAD MONSTER TABLE
	NW = NW + 6
	DIM WN$(NW), WR%(NW), WT%(NW), WC%(NW), WD%(NW), WP%(NW), WS%(NW)
	READ NC
	DIM C$(NC)
	FOR C = 1 TO NC
	READ C$(C)
	NEXT
	R2 = 1
REM $$INCL:'\EAMON\COPY\ARTTYP.BAS'
    CONST GOLD.ART = 0
    CONST TREASURE.ART = 1
    CONST WEAPON.ART = 2
    CONST MAG.WEAPON = 3
    CONST CONTAIN.ART = 4
    CONST LIGHT.ART = 5
    CONST HEAL.ART = 6
    CONST READ.ART = 7
    CONST DOOR.ART = 8
    CONST KEY.ART = 9
    CONST BOUND.MON.ART = 10
    CONST ARMOR.ART = 11	' Armor / Shield
    CONST FOOD.ART = 12
    CONST DRINK.ART = 13   ' DRINKABLE ARTIFACT --- PUT IN YOUR OWN EFFECTS
    CONST MONSTER.DIS = 14
    CONST A.TRAP = 15
    CONST EFFECT.ART = 16
    
    '------- (end of include file) -------    
 ' 
	GOTO INITIALIZE
DONT.UNDERSTAND:
	PGPRT 2, "I don't understand."
' ---------------------------------------------------------------------------
MAIN.LOOP:
'    = MAIN =
	IF SPD THEN
	SPD = SPD - 1
	IF SPD = 0 THEN
	MD%(0, 2) = MD%(0, 2) / 2
	MD%(0, 10) = MD%(0, 10) - 2 * MD%(0, 2)
	PGPRT 2, "Your Speed spell has just expired!"
	END IF
	END IF
SHOW.ROOM:      ' SHOW.ROOM
	IF Room < 89 AND (AD%(1, 4) <> Room AND AD%(1, 4) <> -1) THEN PGPRT 2, "It's too dark to see anything.": GOTO GET.COMMAND
	IF V%(Room) = 0 THEN
	GOSUB SPECIAL.ROOM.CHK
	ELSE
	GET #3, Room
	A$ = RTRIM$(RN$)
	PGPRT 2, "You are " + A$
	END IF
	IF Room = 16 THEN DIE = -1: GOTO Game.Over
	FOR M = 1 TO NM
	IF MD%(M, 5) = Room THEN
	IF MD%(M, 15) = 1 THEN PGPRT 2, MN$(M) + " is here."
	IF MD%(M, 15) = 2 THEN PGPRT 2, MN$(M) + " is lying here."
	IF MD%(M, 15) = 0 THEN
		GET #2, M + MON.ADJ
		A$ = RTRIM$(Desc$)
		PGPRT 2, A$
		MD%(M, 15) = 1
	END IF
	END IF
	NEXT
	FOR A = 1 TO NZ
	IF AD%(A, 4) = Room THEN
	IF AD%(A, 9) THEN
		PGPRT 2, "You see " + AN$(A) + "."
	ELSE
		GET #2, A + ART.ADJ
		A$ = RTRIM$(Desc$)
		PGPRT 2, A$
		AD%(A, 9) = 1
	END IF
	END IF
	NEXT
	IF Room = 52 AND RZ = 0 THEN PGPRT 2, E1$
	FOR A = A TO NA
	IF AD%(A, 4) = Room THEN
	PGPRT 2, "Your " + AN$(A) + " is here."
	END IF
	NEXT
	PRINT
GET.COMMAND:      ' GET.COMMAND
	PGPRT 0, ""
	PRINT
	COLOR hfg%, hbg%
	PRINT "  Your Command ";
	COLOR fgc%, bgc%
	LINE INPUT " ", A$
	A$ = LTRIM$(RTRIM$(UCASE$(A$)))
	IF A$ = "" THEN A$ = CZ$: LOCATE CSRLIN - 1, 17: PRINT A$
	IF A$ = "" THEN GOTO LIST.COMMANDS
	IF A$ = "EXIT NOW" THEN GOTO Game.Over
	CZ$ = A$
	A = INSTR(A$, " ")
	IF A = 0 THEN A = LEN(A$) + 1
	V$ = LEFT$(A$, A - 1)
	S$ = MID$(A$, A + 1)
	S$ = LTRIM$(S$)
	C = 0
	FOR A = 1 TO ND
	IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN C = A: A = ND
	NEXT
	IF C <> 0 THEN GOTO BRANCH.RTN
	F = 0
	FOR A = ND + 1 TO NC
	IF UCASE$(C$(A)) = V$ THEN C = A: A = NC
	IF LEFT$(UCASE$(C$(A)), LEN(V$)) = V$ THEN
		F = F + 1
		C = A
		IF F > 1 THEN C = 0: A = NC
	END IF
	NEXT
	IF C = 0 THEN GOTO LIST.COMMANDS
	GOTO BRANCH.RTN
LIST.COMMANDS:      ' LIST.COMMANDS
	PRINT
	PRINT "Huh? I only understand these commands ... "
	FOR C = 1 TO NC
	PRINT C$(C); SPC(20 - LEN(C$(C)));
	NEXT
	PRINT
	PRINT
	GOTO GET.COMMAND
	IF UCASE$(C$(C)) = S$ THEN S$ = V$: V$ = C$(C)
BRANCH.RTN:      ' BRANCH.RTN
	ON C GOTO MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN, MOVE.RTN
	ON C - 5 GOTO MOVE.RTN, GET.RTN, GET.RTN, DROP.RTN, LOOK.RTN
	ON C - 10 GOTO LOOK.RTN, ATTACK.RTN, FLEE.RTN, GIVE.RTN, INVENTORY.RTN
	ON C - 15 GOTO BLAST.SPELL, HEAL.SPELL, POWER.SPELL, SPEED.SPELL, SMILE.RTN
	ON C - 20 GOTO SMILE.RTN, SAY.SOMETHING, READ.RTN, READY.WEAPON, OPEN.RTN
	ON C - 25 GOTO ENTER.RTN, FREE.RTN, EAT.RTN, DRINK.RTN, WEAR.RTN
	ON C - 30 GOTO SAVE.GAME, RESTORE.GAME, QUIT.RTN
Get.Back:      ' GET.BACK
REM $$INCL:'\EAMON\COPY\NEWBATL.BAS'
    IF TT > 0 THEN TT = TT - 1: GOTO End.Battle
    IF NBTL = 0 THEN GOTO End.Battle
    FOR M = 1 TO NM
        IF MD%(M, 5) = ROOM AND TT = 0 THEN
            MR = FD%(MD%(M, 14)) / TD%(MD%(M, 14)) - FD%(4 - MD%(M, 14)) / TD%(4 - MD%(M, 14)) / 5 + INT(41 * RND(1) - 20)
            IF MD%(M, 4) < MR THEN
                GOSUB Find.Exit
                IF R2 > 0 THEN
                    PGPRT 2, MN$(M) + " flees!"
                    GOSUB MONSTER.LEAVES
                    EXIT FOR
                END IF
            END IF
            IF MD%(M, 14) = 3 THEN
                GOSUB GoodGuys.Attack
            ELSE
                GOSUB BadGuys.Attack
            END IF
        END IF
        NBTL = (FD%(1) < TD%(1))
        IF NBTL = 0 THEN EXIT FOR
    NEXT M
End.Battle:
    IF TT > 0 THEN TT = TT - 1
    GOTO End.Loop
BadGuys.Attack:
    OF = M
    IF TD%(1) = MD%(0, 1) THEN DF = 0: GOSUB Take.a.Swing: RETURN
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 3 AND RND(1) < .25 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    IF DF < 0 THEN DF = 0: GOSUB Take.a.Swing
    RETURN
GoodGuys.Attack:
    OF = M
    DF = -1
    FOR M2 = 1 TO NM
        IF MD%(M2, 5) = ROOM AND MD%(M2, 14) = 1 THEN
            DF = M2
            GOSUB Take.a.Swing
            EXIT FOR
        END IF
    NEXT M2
    RETURN
End.Loop:

    '------- (end of include file) -------    
 ' 
	GOTO MAIN.LOOP
REM $$INCL:'\EAMON\COPY\MONLEAVE.BAS'
MONSTER.LEAVES:
    MD%(M, 5) = R2
    M2 = MD%(M, 14)
    TD%(M2) = TD%(M2) - MD%(M, 1)
    FD%(M2) = FD%(M2) - MD%(M, 13)
    NBTL = (FD%(1) < TD%(1))
    RETURN

    '------- (end of include file) -------    
 ' 
' ---------------------------------------------------------------------------
INITIALIZE:
REM $$INCL:'\Eamon\COPY\READMEAT.BAS'
    OPEN "MEAT" FOR INPUT AS #2
    INPUT #2, Nbr.Party
    INPUT #2, REC
    INPUT #2, MN$(0)
    INPUT #2, MD%(0, 1)
    INPUT #2, MD%(0, 2)
    INPUT #2, MD%(0, 3)
    CH = MD%(0, 3)
    FOR X = 1 TO 4
    INPUT #2, SA%(X)
    S2%(X) = SA%(X)
    NEXT
    FOR X = 1 TO 5
    INPUT #2, WA%(X)
    NEXT
    INPUT #2, SEX$
    INPUT #2, GOLD&
    INPUT #2, BANK&
    INPUT #2, AE
    INPUT #2, ArmNam$
    INPUT #2, ArmHit
    INPUT #2, ArmAdj
    INPUT #2, ShdNam$
    INPUT #2, ShdHit
    INPUT #2, ShdAdj
    FOR X = 1 TO 4
      INPUT #2, A$
      IF RTRIM$(A$) = "" THEN A$ = "NONE"
      WN$(X) = A$
      INPUT #2, WT%(X)
      INPUT #2, WC%(X)
      INPUT #2, WD%(X)
      INPUT #2, WS%(X)
      IF A$ <> "NONE" THEN
          NA = NA + 1
          AN$(NA) = WN$(X)
          AD%(NA, 2) = 2
          AD%(NA, 3) = 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
      END IF
    NEXT
    IF ArmHit <> 0 THEN
          WN$(5) = ArmNam$ + " Armor"
          WT%(5) = 1
          WD%(5) = ArmHit
          WC%(5) = ArmAdj
          NA = NA + 1
          MD%(0, 8) = ArmHit
          Armptr = NA
          AN$(NA) = WN$(5)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    IF ShdHit <> 0 THEN
          WN$(6) = ShdNam$ + " Shield"
          WT%(6) = 2
          WD%(6) = ShdHit
          WC%(6) = ShdAdj
          NA = NA + 1
          MD%(0, 8) = MD%(0, 8) + ShdHit
          Shdptr = NA
          AN$(NA) = WN$(6)
          AD%(NA, 1) = ArmHit * 15
          AD%(NA, 2) = 11
          AD%(NA, 3) = ArmHit * 2
          AD%(NA, 4) = -1
          AD%(NA, 5) = WC%(X)
          AD%(NA, 6) = WT%(X)
          AD%(NA, 7) = WD%(X)
          AD%(NA, 8) = WS%(X)
    END IF
    INPUT #2, MastPath$
    CLOSE 2
    EA = -(ArmAdj + ShdAdj)
    MD%(0, 8) = ArmHit + ShdHit
    IF NA > NZ THEN
        MD%(0, 10) = MD%(0, 2) * 2 + WC%(1) + WA%(WT%(1)) + (EA + AE) * ABS(-EA > AE)
        MD%(0, 7) = 0
        MD%(0, 9) = NZ + 1
        MD%(0, 11) = WD%(1)
        MD%(0, 12) = WS%(1)
        MD%(0, 14) = 3
    END IF

    '------- (end of include file) -------    
 ' 
	IF SEX$ = "F" THEN MN$(9) = "Slippery Sven"
	E1$ = MN$(9) + " is chained to the Altar!"
'     KILL PATH$+"MEAT"
	GOSUB OPEN.DESC
	GOSUB OPEN.RMNAMES
	GOSUB OPEN.ROOMS
	Room = 1
	GOTO Move.it
	DATA 33
	DATA North,South,East,West,Up,Down
	DATA Get,Take,Drop,Look,Examine
	DATA Attack,Flee,Give,Inventory
	DATA Blast,Heal,Power,Speed,Smile
	DATA Wave,Say,Read,Ready,Open
	DATA Enter,Free,Eat,Drink,Wear
	DATA Save,Restore,Quit
' ---------------------------------------------------------------------------
Game.Over:      ' GAME.OVER
	PRINT
	PRINT "(Press any key to continue) ";
	A$ = INPUT$(1)
	PRINT
	CLOSE
	IF SPD THEN MD%(0, 2) = MD%(0, 2) / 2
	IF DIE <> 0 AND SAVED <> 0 THEN
	PRINT "Do you want to restart (Y/N)  ";
	YN$ = INPUT$(1)
	IF UCASE$(YN$) = "Y" THEN RUN
	END IF
	IF DIE <> 0 THEN GOTO GET.MASTER
	GOSUB CHK.SUCCESS
	FOR W = 1 TO 4
	WN$(W) = "NONE"
	NEXT
	W2 = 1
	FOR A = 1 TO NA
	IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 AND AD%(A, 4) = -1 THEN WN$(W2) = AN$(A): WP%(W2) = A: W2 = W2 + 1: AD%(A, 4) = 0
	NEXT A
	IF W2 < 6 THEN GOTO SELL.TREASURE
PLAYER.RETURNS:
	CLS
	LOCATE 5, 1
	PRINT "As you start to enter the main hall, Lord William Misslefire appears and"
	PRINT "tells you, 'You have too many weapons to keep them all--4 is the legal limit."
	PRINT
	PRINT "Your weapons are--"
	FOR W = 1 TO W2 - 1
	PRINT SPC(4); W; "--"; WN$(W)
	NEXT
	PRINT
	PRINT "Enter the number of the weapon to sell  (1-"; W2 - 1; ") "
SELL.WEAPON:
	LOCATE CSRLIN - 1, 53
	INPUT A$
	W5 = VAL(A$)
	IF W5 < 1 OR W5 > W2 - 1 OR W5 <> INT(W5) THEN GOTO SELL.WEAPON
	AD%(WP%(W5), 4) = -1
	WN$(W5) = WN$(W2 - 1)
	WP%(W5) = WP%(W2 - 1)
	W2 = W2 - 1
	IF W2 > 5 THEN GOTO PLAYER.RETURNS
SELL.TREASURE:
	IF MD%(0, 8) > AC THEN MD%(0, 8) = AC
	FOR W = 1 TO 4
	IF WP%(W) THEN WT%(W) = AD%(WP%(W), 6): WC%(W) = AD%(WP%(W), 5): WD%(W) = AD%(WP%(W), 7): WS%(W) = AD%(WP%(W), 8)
	NEXT W
	CLS
	LOCATE 5, 1
	PRINT "As you deliver your treasures to Sam Slicker, the local buyer for such"
	PRINT "things, he examines your goods and pays you ";
	TP = 0
	FOR A = 1 TO NA
	IF A = ArmPtr OR A = ShdPtr THEN GOTO NEXT.TREASURE 
	IF AD%(A, 4) <> -1 THEN GOTO NEXT.TREASURE
	IF AD%(A, 2) <> 0 THEN AD%(A, 1) = AD%(A, 1) * CH / 10
	TP = TP + AD%(A, 1)
NEXT.TREASURE:
	NEXT A
	PRINT TP; " gold pieces."
	PRINT
	GOLD& = GOLD& + TP
	IF GOLD& < 0 THEN GOLD& = 0
	PRINT
	PRINT "(Press any key to continue)  ";
	A$ = INPUT$(1)
	PRINT
GET.MASTER:
	CLS
	LOCATE 5, 1
  ' PRINT "  Insert Eamon Master Diskette, and press <RETURN>  OR     "
  ' PRINT
  ' PRINT "  Enter Path of Master ===> ";
  ' INPUT "", MastPath$
	IF INSTR(MastPath$, ":") = 2 THEN DR$ = LEFT$(MastPath$, 2): MastPath$ = MID$(MastPath$, 3): SHELL DR$
	IF MastPath$ <> "" THEN CHDIR MastPath$
	ON ERROR GOTO Invalid.Path
	IF A$ = "Q" THEN CLOSE : END
	IF DIE THEN
	CLOSE
	CLEAR
	OPEN "ADVENT" FOR OUTPUT AS #1
	CLOSE
	KILL "ADVENT"
	RUN "WORLD"
	END IF
	CLOSE
	GOSUB OPEN.CHARACTERS
	Nam$ = MN$(0)
	HD = MD%(0, 1)
	AG = MD%(0, 2)
	GOSUB WRITE.CHARACTER
	CLOSE
	OPEN "ADVENT" FOR OUTPUT AS #1
	PRINT #1, MN$(0)
	PRINT #1, REC
	CLOSE
	CLEAR
	RUN "HALL"
Invalid.Path:
	PRINT
	PRINT "Invalid Path, or Master Not Found. Please re-try ..."
	PRINT " (press any key to continue)";
	A$ = INPUT$(1)
	RESUME GET.MASTER
QUIT.RTN:
	PRINT "Do you want to Quit this game? (Y/N) ";
	A$ = INPUT$(1)
	IF UCASE$(A$) = "N" THEN GOTO GET.COMMAND
	CLOSE
	END
CHK.SUCCESS:
'    /// SUCCESSFUL?
	PRINT
	RETURN
' --------------------------------------------------------------------------
MOVE.RTN:
	IF IV = 0 THEN
	IF NBTL AND S$ <> "FLEE" THEN
		IF TT = 0 THEN
		PGPRT 2, "You can't do that with unfriendlies about!"
		GOTO MAIN.LOOP
		END IF
	END IF
	END IF
	D = C
	R2 = RD%(D)
	IF R2 > MAX.RM AND R2 < EFF.ADJ THEN GOTO PASSAGE.BLOCKED
CHK.SPECIAL.MOVES:      ' CHK.SPECIAL.MOVES
	IF R2 > 0 AND R2 <= NR THEN GOTO Move.it
'     /// SPECIAL MOVES
	IF R2 = -99 THEN PGPRT 2, "You successfully ride off into the sunset.": GOTO Game.Over
	IF R2 = 0 THEN GOTO CANT.GO
'    /// INSERT HERE SPECIAL ROOM MOVE CHECKING
	IF AD%(3, 4) = Room THEN R2 = -R2: GOTO Move.it
	IF Room = 54 AND AD%(17, 4) = 0 THEN R2 = -R2: GOTO Move.it
	GOTO CANT.GO
PASSAGE.BLOCKED:
	GT = R2 - MAX.RM
	IF AD%(GT, 4) <> Room THEN R2 = AD%(GT, 5): GOTO CHK.SPECIAL.MOVES
	PGPRT 2, "The " + AN$(GT) + " blocks the way!"
	GOTO MAIN.LOOP
CANT.GO:
	PGPRT 2, "You can't go that way!"
	V%(Room) = 0
	GOTO MAIN.LOOP
Move.it:
	R3 = Room
	Room = R2
	GOSUB CHK.REACTIONS
	GOSUB Read.Room
	IF (R2 > 8 AND R2 < 17) OR (R3 > 8 AND R3 < 17) THEN AD%(3, 4) = Room
	LT = -1
	GOTO END.LOOP
CHK.REACTIONS:
	TD%(1) = 0
	TD%(3) = MD%(0, 1)
	FD%(1) = 0
	FD%(3) = MD%(0, 13)
	FOR M = 1 TO NM
	IF MD%(M, 15) = 2 AND MD%(M, 5) = Room THEN GOTO MONSTER.NOT.HERE
	IF MD%(M, 5) = R3 THEN IF MD%(M, 14) = 3 OR (MD%(M, 14) = 1 AND 200 * RND(1) < MD%(M, 4)) THEN MD%(M, 5) = Room: GOTO ADD.SIDES
MONSTER.REACTS:      ' MONSTER.REACTS
	IF MD%(M, 5) <> Room THEN GOTO MONSTER.NOT.HERE
	IF MD%(M, 14) > 0 THEN GOTO ADD.SIDES
	FR = MD%(M, 3)
	IF FR > 0 AND FR <> 100 THEN FR = FR + INT((CH - 10) * 2)
	MD%(M, 14) = 1
	IF FR > (100 * RND(1)) THEN MD%(M, 14) = 2: IF FR > (100 * RND(1)) THEN MD%(M, 14) = 3
ADD.SIDES:      ' ADD.SIDES
	A = MD%(M, 14)
	FD%(A) = FD%(A) + MD%(M, 13)
	TD%(A) = TD%(A) + MD%(M, 1)
MONSTER.NOT.HERE:
	NEXT
	GOTO SET.NBTL
SET.NBTL:
	NBTL = (TD%(1) > 0)
	RETURN
BRING.IN.BEASTS:
	MD%(M, 5) = Room
	MD%(M, 13) = 0
	R3 = Room
	GOSUB CHK.REACTIONS
	RETURN
' --------------------------------------------------------------------------
GET.RTN:
	GOSUB GET.SUBJ
	IF LT = 0 THEN PGPRT 2, "You can't find anything.": GOTO MAIN.LOOP
	IF LEFT$(S$, 7) = "IN BOAT" THEN S$ = "BOAT": GOTO ENTER.RTN
	IF S$ = "ALL" THEN GOTO GET.ALL
	IF S$ = "TORCH" THEN PGPRT 2, "All torches are bolted to the wall and cannot be removed.": GOTO Get.Back
	IF S$ = "WATER" AND Room > 5 AND Room < 28 THEN AD%(5, 4) = Room
	EMB = Room + EMB.ADJ
	WH = Room
	HA = Room
	GOSUB LOCATE.ARTIFACT
	IF FOUND = 0 THEN PGPRT 2, "I see no " + LCASE$(S$) + " here!": GOTO MAIN.LOOP
	GOSUB GET.SURPRISE
	IF GT = 0 THEN GOTO MAIN.LOOP
	IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, "You can't budge it!": GOTO MAIN.LOOP
	PGPRT 2, "Got it."
	AD%(A, 4) = -1
	WT = WT + AD%(A, 3)
	IF (AD%(A, 2) = 2 OR AD%(A, 2) = 3) AND MD%(0, 9) = -1 THEN GOTO CALCULATE.ODDS
	GOTO Get.Back
GET.ALL:      ' GET.ALL
	FOR A = 1 TO NA
	IF AD%(A, 4) <> Room OR AD%(A, 2) = 10 THEN GOTO GET.NEXT
	GOSUB GET.SURPRISE
	IF GT = 0 THEN GOTO GET.NEXT
	IF WT + AD%(A, 3) > 10 * MD%(0, 1) THEN PGPRT 2, AN$(A) + " can't be moved.": GOTO GET.NEXT
	PGPRT 1, AN$(A) + " taken."
	AD%(A, 4) = -1
	WT = WT + AD%(A, 3)
GET.NEXT:      ' GET.NEXT
	NEXT
	GOTO Get.Back
GET.SURPRISE:      ' GET.SURPRISE
'    /// INSERT HERE SPECIAL EFFECTS OF PICKING SOMETHING UP
	IF AD%(A, 2) = 11 AND AD%(A, 6) = 1 AND ArmPtr = 0 THEN
		ArmPtr = A
		GOSUB Ready.Armor
	END IF
	IF AD%(A, 2) = 11 AND AD%(A, 6) = 2 AND ShdPtr = 0 THEN
		ShdPtr = A
		GOSUB Ready.Armor
	END IF
	GT = 1
	IF A = 10 THEN GOTO TOUCHED.JEWEL
	IF IV THEN GOSUB RATTLE.MONSTER
	RETURN
TOUCHED.JEWEL:
	 PGPRT 2, "As you touch the jewel, an electric shock runs up your arm. You hear"
	 PGPRT 1, "a voice chuckling as it says, 'I told you not to touch it!'"
	 PGPRT 1, " "
	 MD%(0, 13) = MD%(0, 13) + MD%(0, 1) / 2
	 DF = 0
	 GOTO APPLY.DAMAGE
RATTLE.MONSTER:      ' RATTLE.MONSTER
	FOR M = 1 TO NM
	IF MD%(M, 5) = Room THEN
	PGPRT 1, MN$(M) + " is slightly unnerved!"
	MD%(M, 4) = MD%(M, 4) - 10
	END IF
	NEXT
	RETURN
SPECIAL.ROOM.CHK:      ' SPECIAL.ROOM.CHK
'    /// SPECIAL ROOM?
	GET #2, Room
	A$ = RTRIM$(Desc$)
	PGPRT 2, A$
	V%(Room) = V%(Room) + 1
	RETURN
' ---------------------------------------------------------------------------
MONSTER.SEARCH:
	WH = Room
	HA = -1
	EMB = Room
	FOUND = 0
	SL = LEN(S$)
	FOR X = 1 TO NM
	IF (LEFT$(UCASE$(MN$(X)), SL) = S$ OR RIGHT$(UCASE$(MN$(X)), SL) = S$) AND (MD%(X, 5) = WH OR MD%(X, 5) = HA) THEN FOUND = FOUND + 1: M = X: IF S$ = MN$(X) THEN X = 9999
	NEXT
	RETURN
' ---------------------------------------------------------------------------
ARTIFACT.SEARCH:
	WH = Room
	HA = -1
	EMB = Room
LOCATE.ARTIFACT:
	FOUND = 0
	SL = LEN(S$)
	FOR X = 1 TO NA
	IF (LEFT$(UCASE$(AN$(X)), SL) = S$ OR RIGHT$(UCASE$(AN$(X)), SL) = S$) AND (AD%(X, 4) = WH OR AD%(X, 4) = HA OR AD%(X, 4) = EMB) THEN FOUND = FOUND + 1: A = X: IF S$ = AN$(X) THEN X = 9999
	NEXT
	RETURN
' --------------------------------------------------------------------------
GET.SUBJ:
	WHILE S$ = ""
	  PRINT
	  PRINT C$(C); " What";
	  INPUT S$
	  PGPRT 2, ""
	WEND
	S$ = UCASE$(S$)
	RETURN
' --------------------------------------------------------------------------
DROP.RTN:
	GOSUB GET.SUBJ
	IF S$ = "ALL" THEN GOTO DROP.ALL
	WH = -1
	HA = -1
	EMB = -1
	GOSUB LOCATE.ARTIFACT
	IF FOUND = 0 THEN PGPRT 2, "You aren't carrying a " + LCASE$(S$) + "!": GOTO MAIN.LOOP
	GOSUB DROP.IT
	GOTO CHK.WGHT
DROP.ALL:       ' DROP.ALL
	SR = Room
	FOR A = 1 TO NA
	IF AD%(A, 4) = -1 AND A <> ArmPtr THEN
	PGPRT 2, AN$(A) + " dropped."
	AD%(A, 4) = Room
	GOSUB DROP.IT
	END IF
	NEXT
CHK.WGHT:      ' CHK.WGHT
	IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
CHK.DROP.WEAPON:
	IF MD%(0, 9) > 0 THEN IF AD%(MD%(0, 9), 4) <> -1 THEN MD%(0, 9) = -1
	GOTO Get.Back
DROP.IT:
	IF IV THEN GOSUB RATTLE.MONSTER
	WT = WT - AD%(A, 3)
	AD%(A, 4) = Room
	PGPRT 2, AN$(A) + " dropped."
	IF A = ArmPtr OR A = ShdPtr THEN GOSUB Drop.Armor
	IF A = LS THEN LS = 0: LC = 0: LM = 0: LT = NL: PGPRT 2, "The " + AN$(A) + " goes out."
	IF WT > 10 * MD%(0, 1) THEN PGPRT 2, "You suddenly find you cannot carry all of the items you are carrying, and they all fall to the ground.": GOTO DROP.ALL
	RETURN
Drop.Armor:
	IF A = ArmPtr THEN ArmPtr = 0
	IF A = ShdPtr THEN ShdPtr = 0
	MD%(0, 8) = MD%(0, 8) - AD%(A, 7)
	EA = EA + AD%(A, 5)
	W = MD%(0, 9)
	MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
	RETURN
Ready.Armor:
	MD%(0, 8) = MD%(0, 8) + AD%(A, 7)
	EA = EA - AD%(A, 5)
	W = MD%(0, 9)
	MD%(0, 10) = MD%(0, 2) * 2 + WA%(AD%(W, 6)) + AD%(W, 5) - ((EA + AE) * ABS(-EA > AE))
	RETURN
' ---------------------------------------------------------------------------
LOOK.RTN:
	IF LT = 0 THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
	LK = 0
	IF S$ = "" THEN GOTO GENERAL.LOOK
	GOSUB EXAMINE.NONART
	IF LK THEN GOTO Get.Back
	WH = Room
	HA = -1
	EMB = Room + EMB.ADJ
	GOSUB LOCATE.ARTIFACT
	IF FOUND AND AD%(A, 4) = EMB THEN AD%(A, 4) = Room
	IF FOUND THEN GOSUB EXAMINE.ARTIFACT: GOTO Get.Back
	GOSUB MONSTER.SEARCH
	IF FOUND THEN GOSUB EXAMINE.MONSTER
GENERAL.LOOK:      ' GENERAL.LOOK
	IF S$ <> "" THEN GOTO NOTHIN.TA.SEE
	FOR A = 1 TO NA
	IF AD%(A, 4) = Room + HID.ADJ THEN LK = -1: GOSUB FIND.ARTIFACT
	NEXT
	IF LK THEN PGPRT 2, "You found something.": GOTO Get.Back
	FOR X = 1 TO ND
	IF RD%(X) < 0 AND RD%(X) >= -NR THEN GOSUB SECRET.PASSAGE
	NEXT
NOTHIN.TA.SEE:      ' NOTHIN.TA.SEE
	V%(Room) = 0
	GOTO Get.Back
EXAMINE.MONSTER:      ' EXAMINE.MONSTER
	R = M + MAX.RM
	GOSUB PRINT.EFFECT
	RETURN
EXAMINE.NONART:      ' EXAMINE.NONART (S$)
	RETURN
SECRET.PASSAGE:
	RD%(X) = ABS(RD%(X))
	V%(Room) = 2
	IF LK = 0 THEN PGPRT 2, "You found a secret passage " + C$(X) + "!": NX = NX + 1
	RETURN
EXAMINE.ARTIFACT:
'     === EXAM ART A
	IF A > NZ THEN PGPRT 2, "This is your " + AN$(A) + "."
	IF A > NZ - NM THEN PGPRT 2, "Yes, he's dead!": RETURN
	IF A = 3 OR A = 13 THEN PGPRT 2, "The bottle says, 'Healing Potion'": RETURN
	GET #2, A + ART.ADJ
	A$ = RTRIM$(Desc$)
	PGPRT 2, A$
	LK = -1
	AD%(A, 9) = 1
	RETURN
FIND.ARTIFACT:      ' FIND.ARTIFACT
'      == DISCOVER ARTIFACT A HIDDEN IN ROOM!
'    --- INSERT HERE ANY SPECIAL DISCOVERY MESSAGES ---
'        SUCH AS "YOU FOUND SOMETHING UNDER THE BED"
	LK = -1
	AD%(A, 4) = Room
	RETURN
' ---------------------------------------------------------------------------
ATTACK.RTN:
	GOSUB GET.SUBJ
	IF LT = 0 THEN PGPRT 2, "You swing wild --- nothing hit.": GOTO Get.Back
	GOSUB MONSTER.SEARCH
	IF FOUND THEN GOTO ATTACK.MON
	TA = 0
	GOTO ASSAULT.ARTIFACT
ATTACK.MON:
	IF MD%(0, 9) = -1 THEN PGPRT 2, "You have no weapon ready!": GOTO MAIN.LOOP
	OF = 0
	DF = M
	GOSUB TAKE.A.SWING
	IF HIT = 0 THEN GOTO MISSED
	IF INC THEN W2 = AD%(MD%(0, 9), 6): WA%(W2) = WA%(W2) + 2
	IF -EA <= AE THEN GOTO Get.Back
	IF INT(100 * RND(1) + 1) <= MD%(0, 10) THEN GOTO MISSED
	A = 2
	IF EA + AE = -1 THEN A = 1
	AE = AE + A
	MD%(0, 10) = MD%(0, 10) + A
MISSED:
	IF MD%(DF, 14) = 1 OR DF = 0 THEN GOTO Get.Back
	MD%(DF, 3) = MD%(DF, 3) / 2
	FOR M = 1 TO NM
	IF MD%(M, 5) = Room AND MD%(M, 14) > 1 THEN MD%(M, 14) = 0
	NEXT
	R3 = Room
	GOSUB CHK.REACTIONS
	GOTO Get.Back
MON.GET.GUN:      ' MON.GET.GUN
'    -- MONSTER PICK-UP WEAPON
	IF MD%(OF, 10) = 0 THEN RETURN
	A = 0
	FOR X = 1 TO NA
	IF AD%(X, 4) = Room AND (AD%(X, 2) = 2 OR AD%(X, 2) = 3) THEN A = X: X = NA
	NEXT
	IF A = 0 THEN RETURN
	PGPRT 2, MN$(OF) + " picks up " + AN$(A) + "."
	AD%(A, 4) = 0
	MD%(OF, 9) = A
	MD%(OF, 10) = MD%(OF, 10) + AD%(A, 5)
	MD%(OF, 4) = MD%(OF, 4) * 2
	RETURN
TAKE.A.SWING:
	HIT = 0
	IF MD%(OF, 9) = -1 THEN GOTO MON.GET.GUN
	IF DF = 0 AND IV THEN RETURN
	PGPRT 2, MN$(OF) + " attacks " + MN$(DF)
	PRINT " --";
	RL = INT(100 * RND(1) + 1)
	HIT = 0
	IF (RL < 5 OR RL < MD%(OF, 10) - MD%(DF, 7)) AND RL < 96 THEN HIT = 1
	IF HIT THEN GOTO A.HIT
	IF RL < 97 THEN PGPRT 1, " A miss!": RETURN
	PGPRT 1, "A fumble!"
	FR = INT(100 * RND(1) + 1)
	IF FR <= 35 + 40 * ABS(MD%(OF, 9) = 0) THEN PGPRT 1, "   fumble recovered.": RETURN
	IF FR < 76 THEN
	PGPRT 1, "  weapon dropped!"
	AD%(MD%(OF, 9), 4) = Room
	MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
	MD%(OF, 9) = -1
	MD%(OF, 4) = MD%(OF, 4) / 2
	RETURN
	END IF
	IF MD%(OF, 9) > 0 THEN W = MD%(OF, 9): IF AD%(W, 2) = 3 THEN PGPRT 1, "Sparks fly from " + AN$(W) + "!": RETURN
	IF FR > 95 THEN GOTO SELF.OUCH
	PGPRT 1, "  weapon breaks!"
	AD%(MD%(OF, 9), 4) = 0
	MD%(OF, 10) = MD%(OF, 10) - AD%(MD%(OF, 9), 5)
	MD%(OF, 9) = -1
	MD%(OF, 4) = MD%(OF, 4) / 2
	IF RND(1) > .5 THEN RETURN
	PGPRT 1, "  broken weapon hurts user!"
SELF.OUCH:
	IF FR = 100 THEN GOTO SELF.YEOW
	D = MD%(OF, 11)
	S = MD%(OF, 12)
	DF = OF
	A = 1
	GOTO DO.DAMAGE
SELF.YEOW:
	D = MD%(OF, 11) * 2
	S = MD%(OF, 12)
	DF = OF
	A = 0
	GOTO DO.DAMAGE
A.HIT:
	INC = ABS(INT(100 * RND(1) + 1) > MD%(OF, 10))
	MD%(OF, 10) = MD%(OF, 10) + 2 * INC
	D = MD%(OF, 11)
	S = MD%(OF, 12)
	A = 1
	IF RL > 5 THEN PGPRT 1, "a Hit!": GOTO DO.DAMAGE
	PGPRT 1, "A critical hit!"
	R2 = INT(100 * RND(1) + 1)
	IF R2 < 51 THEN A = 0: GOTO DO.DAMAGE
	IF R2 < 86 THEN S = 1.5 * S: GOTO DO.DAMAGE
	IF R2 < 96 THEN D = 2 * D: GOTO DO.DAMAGE
	IF R2 < 100 THEN D = 3 * D: GOTO DO.DAMAGE
	GOTO IS.DEAD
DO.DAMAGE:      ' DO.DAMAGE
	D2 = 0
	FOR D3 = 1 TO D
	D2 = D2 + INT(S * RND(1) + 1)
	NEXT
	D2 = D2 - A * MD%(DF, 8)
	IF DF > 8 AND DF < 13 AND OF = 0 AND MD%(0, 9) = 6 THEN D2 = D2 + 2
	IF D2 < 1 THEN PGPRT 1, "   blow bounces off armour.": RETURN
APPLY.DAMAGE:      ' APPLY.DAMAGE
	MD%(DF, 13) = MD%(DF, 13) + D2
	IF MD%(DF, 13) >= MD%(DF, 1) THEN GOTO DEAD.RTN
	A = MD%(DF, 14)
	FD%(A) = FD%(A) + D2
SHOW.CONDITION:
	A$ = MN$(DF)
	ON INT(MD%(DF, 13) * 5 / MD%(DF, 1) + 1) GOTO GOOD.SHAPE, HURTING, IN.PAIN, BADLY.INJURED, DEATHS.DOOR
GOOD.SHAPE:      ' GOOD.SHAPE
	PGPRT 2, A$ + " is still in good shape."
	RETURN
HURTING:      ' HURTING
	PGPRT 2, A$ + " is hurting."
	RETURN
IN.PAIN:      ' IN.PAIN
	PGPRT 2, A$ + " is in pain."
	RETURN
BADLY.INJURED:      ' BADLY.INJURED
	PGPRT 2, A$ + " is very badly injured."
	RETURN
DEATHS.DOOR:      ' DEATHS.DOOR
	PGPRT 2, A$ + " is at death's door, knocking loudly."
	RETURN
DEAD.RTN:
	IF DF = 0 THEN PGPRT 2, "You are dead!": DIE = -1: GOTO Game.Over
IS.DEAD:      ' IS.DEAD
'    /// MONSTER DIES
	PGPRT 2, MN$(DF) + " is dead!"
	A = MD%(DF, 14)
	FD%(A) = FD%(A) + MD%(DF, 1) - MD%(DF, 13) + D2
	MD%(DF, 5) = 0
	IF DF = 17 THEN RETURN
	IF (DF = 1 OR DF = 6) AND AD%(2, 4) = 0 THEN PGPRT 2, "A skeleton key drops from his clutches!": AD%(2, 4) = Room
	FOR AJ = 1 TO NA
	IF AD%(AJ, 4) = -DF - 1 THEN AD%(AJ, 4) = Room
	NEXT
	IF MD%(DF, 9) > 0 THEN AD%(MD%(DF, 9), 4) = Room: MD%(DF, 10) = MD%(DF, 10) - AD%(MD%(DF, 9), 5): MD%(DF, 9) = -1: MD%(DF, 4) = MD%(DF, 4) / 2
GET.BODY:
	IF DF = 0 THEN DIE = 1: GOTO Game.Over
	A2 = DF + NZ - NM
	AD%(A2, 4) = Room
	RETURN
FLEE.RTN:
	IF NBTL = 0 THEN PGPRT 2, "There's nothing to flee from!": GOTO MAIN.LOOP
	IF NX = 0 THEN PGPRT 2, "There's no place to go!": GOTO MAIN.LOOP
	IF S$ <> "" THEN
	C = 0
	FOR D = 1 TO ND
		IF S$ = LEFT$(UCASE$(C$(D)), LEN(S$)) THEN C = D: EXIT FOR
	NEXT
	IF C > 0 THEN V$ = S$: S$ = "FLEE": GOTO MOVE.RTN
	END IF
	GOSUB FIND.EXIT
	GOTO Move.it
FIND.EXIT:
	IF NX = 0 THEN R2 = Room: PGPRT 1, " ... but can't find an exit!": RETURN
	R2 = RD%(ND * RND(1) + 1)
	IF R2 < 1 OR R2 > NR THEN GOTO FIND.EXIT
	RETURN
' ---------------------------------------------------------------------------
GIVE.RTN:
	IF S$ = "" THEN GOSUB GET.SUBJ
	A = 0
	M = 0
	M$ = ""
	A$ = ""
	SEP = INSTR(S$, " TO ")
	IF SEP > 0 THEN
	A$ = LEFT$(S$, SEP - 1)
	M$ = MID$(S$, SEP + 4)
	GOTO READY.SEARCH.GIVE
	END IF
	SEP = INSTR(S$, " ")
	IF SEP > 0 THEN
	NBR.SP = 0
	SP = SEP + 1
	DO UNTIL SP = 0
	  SAVE.S$ = S$
	  S$ = LEFT$(S$, SP - 2)
	  GOSUB MONSTER.SEARCH
	  IF FOUND THEN
		  M$ = S$
		  A$ = MID$(SAVE.S$, SP)
		  GOTO READY.SEARCH.GIVE
	  END IF
	  NBR.SP = NBR.SP + 1
	  SP = INSTR(SP + 1, S$, " ")
	LOOP
	IF NBR.SP = 1 THEN
		A$ = MID$(S$, SEP + 1)
		M$ = LEFT$(S$, SEP - 1)
	ELSE
		GOSUB GIVE.WHO
		GOSUB GIVE.WHAT
	END IF
	ELSE
	GOSUB ARTIFACT.SEARCH
	IF FOUND THEN
		A$ = AN$(A)
	ELSE
		GOSUB MONSTER.SEARCH
		IF FOUND THEN
		M$ = MN$(M)
		GOSUB GIVE.WHAT
		END IF
	END IF
	END IF
READY.SEARCH.GIVE:
	GOSUB GIVE.WHO
	GOSUB GIVE.WHAT
	IF M = 0 THEN
	S$ = M$
	GOSUB MONSTER.SEARCH
	END IF
	IF A = 0 THEN
	IF A$ = MID$(STR$(VAL(A$)), 2) THEN GG = -1 ELSE GG = 0
	IF GG = 0 THEN
		S$ = A$
		GOSUB ARTIFACT.SEARCH
	END IF
	END IF
	IF M > 0 AND GG <> 0 THEN GOTO GIVE.GOLD
	IF M > 0 AND A > 0 THEN GOTO RESOLVE.GIVE
	PGPRT 2, "I don't know what you mean."
	GOTO MAIN.LOOP
RESOLVE.GIVE:      ' RESOLVE.GIVE
	PGPRT 2, "Okay."
	POP = 0
	GOSUB GIVE.ART.MON
	IF POP <> 0 THEN GOTO MAIN.LOOP
	IF A = MD%(0, 9) THEN MD%(0, 9) = -1
	AD%(A, 4) = -M - 1
	MD%(M, 14) = 0
	IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + AD%(A, 1) / 100)
	IF MD%(M, 10) <> 0 AND MD%(M, 9) = -1 THEN MD%(M, 9) = A: MD%(M, 10) = MD%(M, 9) + AD%(A, 5): MD%(M, 4) = 2 * MD%(M, 4)
COMPLETE.GIVE:
	R3 = Room
	GOSUB CHK.REACTIONS
	GOTO CHK.WGHT
GIVE.ART.MON:
 ' PUT SPECIAL CODE HERE FOR GIVING ITEM (A) TO MONSTER (M)
 ' IF MONSTER REFUSES OR SOME SPECIAL ACTION WHERE ITEM DOESN'T CHANGE
 ' HANDS OCCURS, THEN SET POP = -1 AND RETURN FROM THIS ROUTINE.
	IF A = ArmPtr OR A = ShdPtr THEN GOSUB Drop.Armor
	RETURN
GIVE.GOLD:
	IF VAL(A$) > GOLD& THEN PGPRT 2, "You aren't carrying that much gold!": GOTO Get.Back
	GOLD& = INT(GOLD& - VAL(A$))
	MD%(M, 0) = MD%(M, 0) + INT(VAL(A$))
	MD%(M, 14) = 0
	IF MD%(M, 3) < 100 THEN MD%(M, 3) = MD%(M, 3) * (1 + VAL(A$) / 100)
	GOTO COMPLETE.GIVE
GIVE.WHO:
	IF M$ = "" THEN INPUT "Who to give to? ", M$: M$ = UCASE$(M$): GOTO GIVE.WHO
	RETURN
GIVE.WHAT:
	IF A$ = "" THEN INPUT "What to give? ", A$: A$ = UCASE$(A$): GOTO GIVE.WHAT
	RETURN
' ---------------------------------------------------------------------------
INVENTORY.RTN:
	IF IV THEN PGPRT 2, "You see nothing.": GOTO MAIN.LOOP
	PGPRT 2, "You are carrying the following--"
	FOR A = 1 TO NA
	IF AD%(A, 4) = -1 THEN
	PRINT " " + AN$(A);
	IF MD%(0, 9) = A THEN PRINT " (Ready weapon)";
	IF A = ArmPtr THEN PRINT " (Worn Armour)";
	IF A = ShdPtr THEN PRINT " (Your Shield)";
	PGPRT 1, " "
	END IF
	NEXT
	PGPRT 1, STR$(GOLD&) + " gold pieces."
	GOTO Get.Back
' --------------------------------------------------------------------------
BLAST.SPELL:
	GOSUB GET.SUBJ
	GOSUB MONSTER.SEARCH
	IF FOUND = 0 THEN GOTO BLASTED.DOOR
	S = 1
	GOSUB CAST.SPELL
	IF SUC = 0 THEN GOTO Get.Back
	PGPRT 2, "Direct Hit!"
	S = 5
	D = 2
	DF = M
	A = 0
	GOSUB DO.DAMAGE
	GOTO Get.Back
BLASTED.DOOR:
'    /// BLAST DOOR/GATE OR CONTAINER?
	TA = 1
	GOTO ASSAULT.ARTIFACT
' ---------------------------------------------------------------------------
CAST.SPELL:
	SUC = 0
	IF SA%(S) THEN RL = INT(100 * RND(1) + 1): SUC = (((RL < S2%(S)) OR (RL < 5)) AND (RL < 95)): IF RL = 100 THEN SUC = 0
	IF SUC = 0 THEN PGPRT 2, "Nothing happened.": RETURN
	RL = INT(100 * RND(1) + 1)
	IF RL > S2%(S) THEN S2%(S) = S2%(S) + 2: SA%(S) = SA%(S) + 2
	S2%(S) = S2%(S) * .8
	RETURN
' ---------------------------------------------------------------------------
HEAL.SPELL:
	S = 2
	GOSUB CAST.SPELL
	IF SUC = 0 THEN GOTO Get.Back
HEAL.WOUNDS:
	M = 0
	IF S$ <> "" THEN GOSUB MONSTER.SEARCH
	IF M = 0 THEN S$ = "your" ELSE S$ = MN$(M) + "'s"
	IF MD%(M, 13) THEN
	PGPRT 2, "Some of " + S$ + " wounds seem to clear up."
	MD%(M, 13) = MD%(M, 13) - INT(10 * RND(1) + 1)
	END IF
	IF MD%(M, 13) < 0 THEN MD%(M, 13) = 0
	DF = M
	GOSUB SHOW.CONDITION
	GOTO Get.Back
' --------------------------------------------------------------------------
POWER.SPELL:
	S = 4
	GOSUB CAST.SPELL
	IF SUC = 0 THEN GOTO Get.Back
	RAISE = 0
	FOR M = 1 TO NM
	M2 = NZ - NM + M
	IF AD%(M2, 4) = Room OR AD%(M2, 4) = -1 THEN RAISE = 1: GOSUB RAISE.DEAD
	NEXT M
	IF RAISE THEN R3 = Room: GOSUB CHK.REACTIONS: GOTO Get.Back
	FOR A = 1 TO NA
	IF AD%(A, 4) = Room THEN RAISE = -1: PGPRT 2, AN$(A) + " vanishes!": AD%(A, 4) = 0
	NEXT A: IF RAISE THEN PGPRT 1, " ": GOTO Get.Back
	RR = INT(RND(1) * 100 + 1)
	IF RR < 11 THEN PGPRT 2, "The section of tunnel you are in collapses and you die.": DIE = 1: GOTO Game.Over
	IF RR < 86 THEN PGPRT 2, "You hear a very loud sonic boom that echoes through the tunnels.": GOTO Get.Back
	IF RR > 95 THEN PGPRT 2, "All of your wounds are healed.": MD%(0, 13) = 0: GOTO Get.Back
	GOTO DO.SPEED
RAISE.DEAD:
	PGPRT 2, MN$(M) + " comes alive!": AD%(M2, 4) = 0: MD%(M, 5) = Room: MD%(M, 13) = 0: IF AD%(M2, 4) = -1 THEN WT = WT - AD%(M2, 3)
	RETURN
' --------------------------------------------------------------------------
SPEED.SPELL:
	S = 3
	GOSUB CAST.SPELL
	IF SUC = 0 THEN GOTO Get.Back
DO.SPEED:
	IF SPD <> 0 THEN PGPRT 2, "Nothing Happens.": GOTO MAIN.LOOP
	MD%(0, 10) = MD%(0, 10) + 2 * MD%(0, 2)
	MD%(0, 2) = 2 * MD%(0, 2)
	SPD = SPD + INT(25 * RND(1) + 10)
	PGPRT 2, "You can feel the new agility flowing through you!"
	GOTO Get.Back
' --------------------------------------------------------------------------
SMILE.RTN:
	IF IV THEN GOTO Get.Back
	PGPRT 1, " "
	FOR M = 1 TO NM
	  IF MD%(M, 5) = Room AND MD%(M, 15) <= 1 THEN
	  ON MD%(M, 14) GOSUB GROWLS, IGNORES, SMILES
	  END IF
	NEXT
	PGPRT 1, " "
	GOTO Get.Back
GROWLS:
	PGPRT 1, MN$(M) + " growls at you!"
	RETURN
IGNORES:
	PGPRT 1, MN$(M) + " ignores you."
	RETURN
SMILES:
	PGPRT 1, MN$(M) + " " + LCASE$(C$(C)) + "s back."
	RETURN
' --------------------------------------------------------------------------
SAY.SOMETHING:
	GOSUB GET.SUBJ
	IF S$ = "BLAST" THEN V$ = S$: S$ = "": GOTO BLAST.SPELL
	IF S$ = "HEAL" THEN GOTO HEAL.SPELL
	IF S$ = "POWER" THEN GOTO POWER.SPELL
	IF S$ = "SPEED" THEN GOTO SPEED.SPELL
	IF S$ = "MAGIC" AND AD%(8, 4) = 0 AND Room = AD%(25, 4) THEN PGPRT 2, "As you say the word, there is a small eruption from the stone and an": PGPRT 1, "emerald pops from it!": AD%(8, 4) = Room: GOTO Get.Back
	IF LEFT$(S$, 5) = "ROOM " THEN
	PGPRT 2, "As you say this, your vision blurs and your head spins..."
	R2 = VAL(MID$(S$, 6))
	GOTO Move.it
	END IF
	IF LEFT$(S$, 10) = "WHERE AM I" THEN
	PGPRT 2, "As you say this, you hear a voice say " + CHR$(34) + "Room " + STR$(Room) + "!" + CHR$(34)
	GOTO Get.Back
	END IF
	PGPRT 2, "Okay, " + CHR$(34) + S$ + CHR$(34)
	IF IV THEN GOSUB RATTLE.MONSTER
	GOTO Get.Back
' --------------------------------------------------------------------------
READY.WEAPON:
	GOSUB GET.SUBJ
	WH = -1
	HA = WH
	EMB = HA
	GOSUB LOCATE.ARTIFACT
	IF FOUND = 0 THEN PGPRT 2, "You aren't carrying it!": GOTO MAIN.LOOP
	IF AD%(A, 2) < 2 OR AD%(A, 2) > 3 THEN PGPRT 2, "That isn't a weapon!": GOTO MAIN.LOOP
CALCULATE.ODDS:
	MD%(0, 10) = (EA + AE) * ABS(-EA > AE) + AD%(A, 5) + WA%(AD%(A, 6)) + 2 * MD%(0, 2)
	MD%(0, 9) = A
	MD%(0, 11) = AD%(A, 7)
	MD%(0, 12) = AD%(A, 8)
	PGPRT 2, "Readied."
	GOTO Get.Back
' --------------------------------------------------------------------------
OPEN.RTN:
	  IF NBTL THEN GOTO MOVE.RTN
	  GOSUB GET.SUBJ
	  WH = Room
	  HA = -1
	  EMB = Room + 200
	  GOSUB LOCATE.ARTIFACT
	  IF FOUND = 0 THEN GOTO HOWZAT
	  IF A = 17 AND AD%(2, 4) = -1 THEN PGPRT 2, "As you open the iron grate, it crumbles to dust.": AD%(17, 4) = 0: GOTO Get.Back
	  IF A = 16 AND E1 > 0 THEN PGPRT 2, "You can't open it.": GOTO Get.Back
	  IF A = 16 THEN PGPRT 2, "As you begin to open the lid, a skeleton jumps out and attacks you! The lid slams back shut!": E1 = 1: MD%(1, 5) = Room: R3 = Room: GOSUB CHK.REACTIONS: GOTO Get.Back
	  GOTO HOWZAT
HOWZAT:
	  PGPRT 2, "Mind telling me how?"
	  GOTO MAIN.LOOP
DRINK.RTN:
	  GOSUB GET.SUBJ
	  IF S$ = "WATER" AND AD%(5, 4) = -1 THEN PGPRT 2, "The water tastes salty, but does not appear to be poisonous.": GOTO Get.Back
	  WH = Room
	  HA = -1
	  EMB = Room + 200
	  GOSUB LOCATE.ARTIFACT
	  IF FOUND = 0 THEN GOTO HOWZAT
	  IF A = 4 THEN PGPRT 2, "The bottle is empty.": GOTO Get.Back
	  PGPRT 2, "You can't do that."
	  GOTO Get.Back
DIG.RTN:
	  IF NBTL THEN GOTO MOVE.RTN
	  IF AD%(9, 4) <> -1 THEN PGPRT 2, "The ground is too hard to dig with your fingers.": GOTO Get.Back
	  IF Room <> 27 OR AD%(6, 4) > 0 THEN PGPRT 2, "You find nothing.": GOTO Get.Back
	  PGPRT 2, "You find a bag of gold coins!"
	  AD%(6, 4) = Room
	  GOTO Get.Back
ENTER.RTN:
	  IF (S$ = "WATER" OR S$ = "SEA") AND Room = 26 THEN PGPRT 2, "I'm afraid to go into the water without my life preserver!": GOTO Get.Back
	  IF (S$ = "BOAT") AND AD%(3, 4) = Room THEN
	  PGPRT 2, "You climb into the boat."
	  GOTO Get.Back
	  END IF
	  PGPRT 2, "I'm not sure what you mean by that. Try giving a direction to move in."
	  GOTO MAIN.LOOP
ASSAULT.ARTIFACT:
	IF TA = 0 THEN PGPRT 2, "Attack who?": GOTO MAIN.LOOP
	PGPRT 2, "You can't blast " + LCASE$(S$) + "!"
	GOTO MAIN.LOOP
' --------------------------------------------------------------------------
READ.RTN:
	IF IC <> 0 AND DD = 0 THEN PGPRT 2, "You can't see.": GOTO MAIN.LOOP
	GOSUB GET.SUBJ
	WH = Room
	HA = -1
	EMB = Room + EMB.ADJ
	GOSUB LOCATE.ARTIFACT
	IF FOUND = 0 THEN GOTO READ.NONART
	IF AD%(A, 2) = 7 THEN GOTO READ.ARTIFACT
	PGPRT 2, "You can't read the " + AN$(A) + "."
	GOTO Get.Back
READ.NONART:
'   ...  NON-ART - INSERT HERE SPECIAL READING ...
'   ...  EXAMPLE: READING WALLS OR CEILING, DOORS, ETC ...
	GOTO DONT.UNDERSTAND
READ.ARTIFACT:
'    /// READING A READABLE ARTIF.
	R = AD%(A, 5) + AD%(A, 7) - 1
	GOSUB PRINT.EFFECT
	AD%(A, 7) = AD%(A, 7) + 1
	IF AD%(A, 7) > AD%(A, 6) THEN AD%(A, 7) = 1
	GOTO Get.Back
' --------------------------------------------------------------------------
PRINT.EFFECT:
	GET #2, R + EFF.ADJ
	A$ = RTRIM$(Desc$)
	PGPRT 2, A$
	RETURN
' --------------------------------------------------------------------------
FREE.RTN:
	GOSUB GET.SUBJ
	GOSUB ARTIFACT.SEARCH
	IF FOUND = 0 THEN GOTO MAYBE.FREE.LIL
	IF AD%(A, 2) <> 10 THEN GOTO DONT.UNDERSTAND
	M = AD%(A, 5)
	K = AD%(A, 6)
	G = AD%(A, 7)
	IF AD%(A, 4) <> Room THEN PGPRT 2, "I don't know what you are talking about.": GOTO MAIN.LOOP
	IF MD%(G, 5) = Room THEN PGPRT 2, MN$(G) + " won't let you do that!": GOTO Get.Back
	IF AD%(K, 4) <> -1 AND K <> 0 THEN PGPRT 2, "You don't have the key!": GOTO MAIN.LOOP
	PGPRT 2, "You have freed " + MN$(M) + "."
	MD%(M, 5) = Room
	AD%(A, 4) = 0
	R3 = Room
	GOSUB CHK.REACTIONS
	GOTO Get.Back
MAYBE.FREE.LIL:
	  IF LEFT$(UCASE$(MN$(9)), LEN(S$)) = S$ OR RIGHT$(UCASE$(MN$(9)), LEN(S$)) = S$ THEN M = 9 ELSE M = 0
	  IF M <> 9 THEN GOTO DONT.UNDERSTAND
	  FREED = 0
	  IF RZ <> 0 OR Room <> 52 THEN PGPRT 2, "Huh? How can I " + CZ$ + "!": GOTO MAIN.LOOP
	  IF AD%(2, 4) <> -1 THEN PGPRT 2, "The bonds are locked with a heavy lock and you don't have a key!": GOTO MAIN.LOOP
	  RZ = 1
	  PGPRT 2, "You have freed " + MN$(9) + "!"
	  MD%(9, 5) = Room
	  MD%(9, 14) = 3
	  GOTO Get.Back
' ---------------------------------------------------------------------------
EAT.RTN:
	GOSUB GET.SUBJ
	GOSUB ARTIFACT.SEARCH
	IF FOUND = 0 THEN GOTO NOT.HUNGRY
	IF AD%(A, 2) <> FOOD.ART THEN GOTO NOT.HUNGRY
	PGPRT 2, "Okay. You eat the " + LCASE$(AN$(A)) + "."
	AD%(A, 4) = 0
	GOTO Get.Back
NOT.HUNGRY:
	PGPRT 2, "You aren't THAT hungry!"
	GOTO Get.Back
' ---------------------------------------------------------------------------
WEAR.RTN:
	GOSUB GET.SUBJ
	GOSUB ARTIFACT.SEARCH
	IF FOUND = 0 THEN GOTO DONT.WEAR
	IF AD%(A, 2) = ARMOR.ART THEN GOTO WEAR.ARMOR
WEAR.SOMETHING:
 ' ..... INSERT HERE SPECIAL WORN ARTIFACTS ...
	GOTO DONT.WEAR
WEAR.ARMOR:
	EA = -AD%(A, 5)
	MD%(0, 8) = AD%(A, 7)
	PGPRT 2, "Okay. You have put on the " + AN$(A) + "."
	GOTO Get.Back
DONT.WEAR:
	PGPRT 2, "You can't wear that and stay respectable."
	GOTO MAIN.LOOP
' ---------------------------------------------------------------------------
SAVE.GAME:
	INPUT "Do you want to save this game? (Y/N) ", SAVE.GM$
	IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO SAVE.IT
	GOTO MAIN.LOOP
SAVE.IT:
	GOSUB GET.GAME.ID
	CLOSE 1
REM $$INCL:'\Eamon\copy\SAVEgame.bas'
'        Eamon Save Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR OUTPUT AS #1
        PRINT #1, LT
        PRINT #1, LM
        PRINT #1, LC
        PRINT #1, LS
        PRINT #1, ROOM
        PRINT #1, SPD
        PRINT #1, TT
        PRINT #1, ArmNam$
        PRINT #1, ArmHit
        PRINT #1, ArmAdj
        PRINT #1, ShdNam$
        PRINT #1, ShdHit
        PRINT #1, ShdAdj
        PRINT #1, AE
        FOR X = 1 TO 4
        PRINT #1, SA%(4)
        NEXT
        FOR X = 1 TO 4
        PRINT #1, S2%(4)
        NEXT
        FOR X = 1 TO 5
        PRINT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        PRINT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        PRINT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        PRINT #1, V%(V)
        NEXT V
        PRINT #1, GOLD&
        PRINT #1, BANK&

    '------- (end of include file) -------    
 ' 
	GOSUB OPEN.ROOMS
	GOTO MAIN.LOOP
RESTORE.GAME:
	INPUT "Do you want to Restore a game? (Y/N) ", SAVE.GM$
	IF UCASE$(LEFT$(SAVE.GM$, 1)) = "Y" THEN GOTO RESTORE.IT
	GOTO MAIN.LOOP
RESTORE.IT:
	GOSUB GET.GAME.ID
	CLOSE 1
REM $$INCL:'\Eamon\Copy\RESTGAME.BAS'
'        Eamon Restore Game Routine
'
'          by John Nelson
'
        OPEN GAME.ID$ FOR INPUT AS #1
        INPUT #1, LT
        INPUT #1, LM
        INPUT #1, LC
        INPUT #1, LS
        INPUT #1, ROOM
        INPUT #1, SPD
        INPUT #1, TT
        INPUT #1, ArmNam$
        INPUT #1, ArmHit
        INPUT #1, ArmAdj
        INPUT #1, ShdNam$
        INPUT #1, ShdHit
        INPUT #1, ShdAdj
        INPUT #1, AE
        FOR X = 1 TO 4
        INPUT #1, SA%(X)
        NEXT
        FOR X = 1 TO 4
        INPUT #1, S2%(X)
        NEXT
        FOR X = 1 TO 5
        INPUT #1, WA%(X)
        NEXT
        FOR M = 0 TO NM
        FOR D = 0 TO 15
        INPUT #1, MD%(M, D)
        NEXT D
        NEXT M
        FOR A = 0 TO NA
        FOR D = 0 TO 9
        INPUT #1, AD%(A, D)
        NEXT D
        NEXT A
        FOR V = 1 TO NR
        INPUT #1, V%(V)
        NEXT V
        INPUT #1, GOLD&
        INPUT #1, BANK&
    CLOSE 1

    '------- (end of include file) -------    
 ' 
	CLOSE 1
	GOSUB OPEN.ROOMS
	GOTO Move.it
GET.GAME.ID:
	PRINT
	INPUT "File Name: ", GAME.ID$
	IF LEN(GAME.ID$) > 8 THEN GOTO GET.GAME.ID
	GAME.ID$ = UCASE$(GAME.ID$)
	IF LEFT$(GAME.ID$, 1) < "A" OR LEFT$(GAME.ID$, 1) > "Z" THEN GOTO GET.GAME.ID
	GAME.ID$ = GAME.ID$ + ".GAM"
	RETURN
REM $$INCL:'\Eamon\Copy\Chario.bas'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  CHARIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Character File I/O Routines for Eamon QB/PC
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        or BASIC 7.0 PDS
        '       uses User defined types for record definition
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
OPEN.CHARACTERS:
      OPEN "CHARACT.DAT" FOR RANDOM AS #1 LEN = LEN(Char)
      RETURN
READ.NBR.CHARS:
      GET #1, 1, CharCtl
      NC = CharCtl.NbrChar
      IF NC > LOF(1) \ LEN(Char) THEN NC = LOF(1) \ LEN(Char) - 1
      RETURN
READ.CHARACTER:
      GET #1, REC, Char
      Nam$ = RTRIM$(Char.Nam$)
      HD = Char.Hd
      AG = Char.Ag
      CH = Char.Ch
      SA%(1) = Char.SA1
      SA%(2) = Char.SA2
      SA%(3) = Char.SA3
      SA%(4) = Char.SA4
      WA%(1) = Char.WA1
      WA%(2) = Char.WA2
      WA%(3) = Char.WA3
      WA%(4) = Char.WA4
      WA%(5) = Char.WA5
      SEX$ = Char.SEX
      GOLD& = Char.GOLD
      BANK& = Char.BANK
      AE = Char.AE
      ArmNam$ = RTRIM$(Char.ArmNam)
      ArmHit = Char.ArmHit
      ArmAdj = Char.ArmAdj
      ShdNam$ = RTRIM$(Char.ShdNam)
      ShdHit = Char.ShdHit
      ShdAdj = Char.ShdAdj
      WN$(1) = RTRIM$(Char.Wpn1Nam)
      WR%(1) = Char.Wpn1Typ
      WT%(1) = Char.Wpn1WpnTyp
      WC%(1) = Char.Wpn1Odds
      WD%(1) = Char.Wpn1Dice
      WS%(1) = Char.Wpn1Sides
      WN$(2) = RTRIM$(Char.Wpn2Nam)
      WR%(2) = Char.Wpn2Typ
      WT%(2) = Char.Wpn2WpnTyp
      WC%(2) = Char.Wpn2Odds
      WD%(2) = Char.Wpn2Dice
      WS%(2) = Char.Wpn2Sides
      WN$(3) = RTRIM$(Char.Wpn3Nam)
      WR%(3) = Char.Wpn3Typ
      WT%(3) = Char.Wpn3WpnTyp
      WC%(3) = Char.Wpn3Odds
      WD%(3) = Char.Wpn3Dice
      WS%(3) = Char.Wpn3Sides
      WN$(4) = RTRIM$(Char.Wpn4Nam)
      WR%(4) = Char.Wpn4Typ
      WT%(4) = Char.Wpn4WpnTyp
      WC%(4) = Char.Wpn4Odds
      WD%(4) = Char.Wpn4Dice
      WS%(4) = Char.Wpn4Sides
      RETURN
WRITE.CHARACTER:
      Char.Nam = Nam$
      Char.Hd = HD
      Char.Ag = AG
      Char.Ch = CH
      Char.SA1 = SA%(1)
      Char.SA2 = SA%(2)
      Char.SA3 = SA%(3)
      Char.SA4 = SA%(4)
      Char.WA1 = WA%(1)
      Char.WA2 = WA%(2)
      Char.WA3 = WA%(3)
      Char.WA4 = WA%(4)
      Char.WA5 = WA%(5)
      Char.SEX = SEX$
      Char.GOLD = GOLD&
      Char.BANK = BANK&
      Char.AE = AE
      Char.ArmNam = ArmNam$
      Char.ArmHit = ArmHit
      Char.ArmAdj = ArmAdj
      Char.ShdNam = ShdNam$
      Char.ShdHit = ShdHit
      Char.ShdAdj = ShdAdj
      Char.Wpn1Nam = WN$(1)
      Char.Wpn1Typ = WR%(1)
      Char.Wpn1WpnTyp = WT%(1)
      Char.Wpn1Odds = WC%(1)
      Char.Wpn1Dice = WD%(1)
      Char.Wpn1Sides = WS%(1)
      Char.Wpn2Nam = WN$(2)
      Char.Wpn2Typ = WR%(2)
      Char.Wpn2WpnTyp = WT%(2)
      Char.Wpn2Odds = WC%(2)
      Char.Wpn2Dice = WD%(2)
      Char.Wpn2Sides = WS%(2)
      Char.Wpn3Nam = WN$(3)
      Char.Wpn3Typ = WR%(3)
      Char.Wpn3WpnTyp = WT%(3)
      Char.Wpn3Odds = WC%(3)
      Char.Wpn3Dice = WD%(3)
      Char.Wpn3Sides = WS%(3)
      Char.Wpn4Nam = WN$(4)
      Char.Wpn4Typ = WR%(4)
      Char.Wpn4WpnTyp = WT%(4)
      Char.Wpn4Odds = WC%(4)
      Char.Wpn4Dice = WD%(4)
      Char.Wpn4Sides = WS%(4)
      PUT #1, REC, Char
      RETURN
WRITE.NBR.CHARS:
      CharCtl.NbrChar = NC
      PUT #1, 1, CharCtl
      RETURN

    '------- (end of include file) -------    
 ' 
REM $$INCL:'\EAMON\COPY\ADVENIO.OLD'
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
        '   Module:  ADVENIO.BAS
        '   Eamon Version:  Eamon-QB (or Eamon-PC)
        ' ------------------------------------------------------------
        '  Adventure I/O Routines for Eamon Base Adventure Program
        '        Basic version:  QuickBASIC 4.0, GW-BASIC, QBasic *
        '                        BASIC 7.0 PDS
        '       uses Field statements for record description
        '       This module will work for QBasic, but QBasic cannot
        '       support $INCLUDE: statements, so module must be built
        '       manually or merged using a utility
        ' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        '
READ.ARTIFACTS:    ' ----- READ ARTIFACTS ---------------------
       IF Art.Len = 0 THEN Art.Len = 128
       IF Art.Flds = 0 THEN Art.Flds = 8
       IF AN.Len = 0 THEN AN.Len = 20
       OPEN "ARTIF.TXT" FOR RANDOM AS #3 LEN = Art.Len
       FIELD 3, AN.Len AS AF.NAME$
       DIM AF.DATA$(Art.Flds)
       FOR A2 = 1 TO Art.Flds
       FIELD 3, AN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS AF.DATA$(A2)
       NEXT
       FOR A = 1 TO NA
           GET #3, A
           AN$(A) = RTRIM$(AF.NAME$)
           FOR A2 = 1 TO Art.Flds
               AD%(A, A2) = CVI(AF.DATA$(A2))
           NEXT A2
           IF AD%(A, 2) > 1 AND AD%(A, 2) < 4 THEN NW = NW + 1
       NEXT
       CLOSE 3
       RETURN
READ.MONSTERS:  ' ------------- READ MONSTERS    ---------------------
       IF MON.LEN = 0 THEN MON.LEN = 128
       IF Mon.Flds = 0 THEN Mon.Flds = 12
       IF MN.Len = 0 THEN MN.Len = 20
       OPEN "MONST.TXT" FOR RANDOM AS #3 LEN = MON.LEN
       FIELD 3, MN.Len AS MF.NAME$
       DIM MF.DATA$(Mon.Flds)
       FOR A2 = 1 TO Mon.Flds
           FIELD 3, MN.Len AS X$, (A2 - 1) * 2 AS X$, 2 AS MF.DATA$(A2)
       NEXT
       FOR A = 1 TO NM
           GET #3, A
           MN$(A) = RTRIM$(MF.NAME$)
           FOR A2 = 1 TO Mon.Flds
               MD%(A, A2) = CVI(MF.DATA$(A2))
           NEXT A2
           IF MD%(A, 3) < 0 THEN               ' Force nuetral if < 0
              MD%(A, 3) = ABS(MD%(A, 3)) - 1
              MD%(A, 14) = 2
           END IF
       NEXT
       CLOSE 3
       RETURN
OPEN.DESC:       ' ----------------- OPEN DESC FILE -------------------
       IF Desc.Len = 0 THEN Desc.Len = 256
       OPEN "DESC.TXT" FOR RANDOM AS #2 LEN = Desc.Len
       FIELD 2, Desc.Len - 1 AS Desc$
       RETURN
OPEN.RMNAMES:    ' ---------------- OPEN ROOM NAMES -------------------
       IF RMN.Len = 0 THEN RMN.Len = 64
       OPEN "RMNAMES.TXT" FOR RANDOM AS #3 LEN = RMN.Len
       FIELD 3, RMN.Len AS RN$
       RETURN
OPEN.ROOMS:      ' ---------------- OPEN ROOMS FILE -------------------
       IF RM.LEN = 0 THEN RM.LEN = 64
       OPEN "ROOMS.TXT" FOR RANDOM AS #1 LEN = RM.LEN
       FOR D = 1 TO 10
           FIELD 1, (D - 1) * 2 AS X$, 2 AS RF.DIR$(D)
       NEXT
       FIELD 1, 20 AS X$, 1 AS RF.LT$
       RETURN
Read.Room:
       GET #1, Room
       IF ND = 0 THEN ND = 6
       NX = 0
       FOR X = 1 TO ND
           RD%(X) = CVI(RF.DIR$(X))
           IF RD%(X) > 0 AND RD%(X) <= NR THEN NX = NX + 1
       NEXT
       NL = VAL(RF.LT$)
       GET #3, Room
       RETURN
    '------- (end of include file) -------

    '------- (end of include file) -------    
 ' 

SUB PGPRT (SP, LIT$)

STATIC PG.CNT
	IF SP = 0 THEN PG.CNT = 0: EXIT SUB
	IF LIT$ = "" THEN PG.CNT = PG.CNT + SP: EXIT SUB
	IF PG.CNT > 18 THEN
	LOCATE 24, 1
	PRINT STRING$(25, "-"); " Press Any Key to Continue "; STRING$(25, "-");
	A$ = INPUT$(1)
	PG.CNT = 0
	LOCATE CSRLIN, 1
	PRINT SPC(79);
	END IF
	IF SP > 1 THEN
	FOR X = 1 TO SP - 1
	PRINT
	PG.CNT = PG.CNT + 1
	NEXT
	END IF
	PRINT LIT$
	PG.CNT = PG.CNT + INT(LEN(LIT$) / 80) + 1
END SUB

