uses DigPak,MidPak,KeyBoard,DOSUtil,ZENTimer;

(*                  BEST GAME SDK FOR TURBO/BORLAND PASCAL                 *)
(*                ͻ         ͻ ͻ               *)
(*                ͼ    ͻ ͻ  ͻ   ͼ                  *)
(*                   ͼͼ  ͼ͹ ͼ  ͼ                  *)
(*                        ͻ   ͼ                                *)
(*                 :     ͹˻ ͻ  .Ĵ               *)
(*               | |  .    ͼ              *                   *)
(*               -+-    . ʼ       ʼ     ʼ   .  +                 *)
(*                |   .        version 2.0       .      :                 *)
(*                 Copyright (c) 1996-98 by Vadim Bodrov  |               *)

{$IFDEF WINDOWS}
 THIS PROGRAM CAN`T BE COMPILED FOR MS WINDOWS
{$ENDIF}

{****************************************************************************
    A  $500  per  product  license  fee  applies  to  all commercial software
 products  distributed  with  ANY DIGPAK and another $500 for MIDPAK drivers.
 That's  a  total  of  $1,000  if  your  product  uses BOTH DIGPAK and MIDPAK
 drivers.  If  you  distribute any commercial title with DIGPAK and/or MIDPAK
 drivers  resident  then  this  license fee applies. To pay a license, simply
 write  a  check for $500 for just DIGPAK $500 for just MIDPAK, or $1,000 for
 both  DIGPAK  and MIDPAK single product distribution license payable to: The
 Audio  Solution,  747  Napa  Lane, St. Charles, MO 63304 with a copy of your
 commerical  product.  You  will  receive a signed license agreement from The
 Audio  Solution shortly thereafter. This license fee applies specifically to
 the  inclusion  with  your distribution disk any of the DIGPAK and/or MIDPAK
 drivers.  These drivers are copyrighted works, created by me, to enhance the
 use  of  sound  and music in DOS based commercial software. The license fees
 collected  are  used  to  maintain  the  drivers  and  keep the BBS running.

 WARNING!!!!!!  You  would  be ill-advised to distribute a commercial product
 containing  either  DIGPAK  and/or  MIDPAK  drivers  without having paid the
 distribution  license  fee.  Since  your  product  would  contain unlicensed
 copyrighted software from The Audio Solution, your product could be required
 to be immediately removed from retail distribution. I doubt this is going to
 be  a  problem.  Clearly  if  your  product  is enhanced by the use of these
 drivers,  your  company can easily afford a nominal license fee of $1,000 in
 exchange  for  getting  the use of several man-years of software engineering
 resources.
*****************************************************************************}

 var snd1,snd2,snd3: TSndStruct;
     mid1,mid2,mid3: TMidiStruct;
     ver,cap:        Word;
     ch:             Char;

 procedure Error(Code: Byte);
 begin
  Write(' Error: ',Code,' - ');
  case Code of
     1: Writeln(' Can`t load MIDPAK');
     2: Writeln(' Can`t initialize MIDPAK');
     3: Writeln(' Can`t load DIGPAK');
     4: Writeln(' Can`t initialize DIGPAK');
     5: Writeln(' Can`t load XMI file');
     6: Writeln(' Can`t load SND file');
  end;
  if Code>1 then UnloadMIDPak;
  if Code>3 then UnloadDigPak;
  halt(0);
 end;

 procedure PlaySound(Num: Byte);
 begin
  StopSound;
  case Num of
   1: DigPlay2(snd1);
   2: DigPlay2(snd2);
   3: DigPlay2(snd3);
  end;
 end;

 function YesNo(Param: Word): String;
 begin
  if (cap and Param)=Param then YesNo:='Yes' else YesNo:='No ';
 end;

 procedure MemoryAvail;
 begin
  Writeln(' <Free Memory: ',MaxAvail,'>');
 end;

 procedure PlayXMidi(Num: Byte);
 begin
  case Num of
   1: RegisterXmidi(mid1);
   2: RegisterXmidi(mid2);
   3: RegisterXmidi(mid3);
  end;
  PlaySequence(0);
  SegueSequence(0,-1);
 end;

 begin
  Writeln;
  Writeln(' ----------------------------------------------');
  Writeln(' DIGPAK and MIDPAK drivers test');
  Writeln(' This program is a part of PLUS SYSTEM Pro v2.0');
  Writeln(' Copirights (c) 1996-98 by Vadim Bodrov');
  Writeln(' ----------------------------------------------');
  MemoryAvail;
  Write  (' Load and initialize MIDPAK music driver...');
  if not LoadMidPak('MidPak.com','MidPak.Adv','MidPak.Ad') then Error(1);
  if not InitMidPak then Error(2);
  Writeln('Ok');
  Write  (' Load and initialize DIGPAK digital sound driver...');
  if not LoadDigPak('soundrv.com') then Error(3);
  if not InitDigPak then Error(4);
  Writeln('Ok');
  ver:=ReportVersionNumber;
  Writeln(' DIGPAK digital sound driver version number is ',ver div 100,'.',ver mod 100);
  cap:=AudioCapabilities;
  Writeln;
  Write  (' Background playback - ',YesNo(PLAYBACK),'     ');
  Writeln(' Massage required    - ',YesNo(MASSAGE));
  Write  (' Fixed freq          - ',YesNo(FIXEDFREQ),'     ');
  Writeln(' Use timer           - ',YesNo(USESTIMER));
  Write  (' Share timer         - ',YesNo(SHARESTIMER),'     ');
  Writeln(' Support loopend     - ',YesNo(LOOPEND));
  Write  (' Stereo Pan          - ',YesNo(STEREOPAN),'     ');
  Writeln(' Stereo play         - ',YesNo(STEREOPLAY));
  Write  (' Recording           - ',YesNo(AUDIORECORD),'     ');
  Writeln(' DMA backfill        - ',YesNo(DMABACKFILL));
  Write  (' Support 16 bit PCM  - ',YesNo(PCM16),'     ');
  Writeln(' Support streo PCM   - ',YesNo(PCM16STEREO));
  Writeln;

  Write  (' Load MIDI and DIGITAL SOUND files...');
  if not MidiLoad('music1.xmi',mid1) then Error(5);
  if not MidiLoad('music2.xmi',mid2) then Error(5);
  if not MidiLoad('music3.xmi',mid3) then Error(5);
  if not SndLoad ('sound1.snd',snd1) then Error(6);
  if not SndLoad ('sound2.snd',snd2) then Error(6);
  if not SndLoad ('sound3.snd',snd3) then Error(6);
  Writeln('Ok');
  MemoryAvail;
  MassageAudio(snd1);
  MassageAudio(snd2);
  MassageAudio(snd3);
  PlayXMidi(2);
  PlaySound(1);
  Writeln;
  Writeln(' USAGE:  1,2,3 - Change MIDI music');
  Writeln('         4,5,6 - Play digital sound');
  Writeln('         7     - Stop MIDI music');
  Writeln('         Esc   - Exit');
  WaitSound;
  repeat
   ch:=xReadKey;
   if ch in ['1'..'3'] then PlayXMidi(StrToInt(ch));
   if ch in ['4'..'6'] then PlaySound(StrToInt(ch)-3);
   if ch = '7' then StopMIDI;
  until Byte(ch)=27;

  { LAST ACTION :-) }
  Writeln;
  Writeln(' Oops!!!');
  StopMIDI;
  PlaySound(2);
  LZDelay(200000);
  PlaySound(2);
  LZDelay(300000);
  PlaySound(2);
  LZDelay(900000);
  PlaySound(3);
  WaitSound;

  { UNINIT DRIVERS AND FREE MEMORY... }
  Writeln;
  Write  (' Unload drivers...');
  UnloadDigPak;
  UnloadMidPak;
  Writeln('Ok');
  MemoryAvail;
  Write  (' Unload MIDI and DIGITAL SOUND files...');
  MidiFree(mid1);
  MidiFree(mid2);
  MidiFree(mid3);
  SndFree (snd1);
  SndFree (snd2);
  SndFree (snd3);
  Writeln('Ok');
  MemoryAvail;
  LZDelay(1000000);
  FlushKeyboard;
 end.