'To do-list:
'* Create the missing tiles, complete maps with missing tiles
'* Create more enemy-files, that come with the maps
'* Pixel-perfect enemy-Link collision
'* Link kan schieten met zwaard als HP vol is!
'
DECLARE FUNCTION Collision2% (X2%, Y2%)
DECLARE SUB CheckHit ()
DECLARE SUB Status ()
DECLARE SUB ProcessKeys ()
DECLARE SUB RemoveEnemies ()
DECLARE SUB PutEnemies ()

'---[ SUBROUTINE DECLARATIONS ]---
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE FUNCTION LoadMIDI% (FileName$)
DECLARE SUB LoopMidi ()
DECLARE SUB PlayMidi (Handle%)
DECLARE SUB StopMidi ()
DECLARE SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
DECLARE SUB IntX (IntNum AS INTEGER, Regs AS ANY)
DECLARE SUB UnLoadMidi (Handle%)
DECLARE SUB CleanUpMidi ()

'
'ͻ
'Original Zelda was done in 1986 by Nintendo, on the NES             
'ZeldaClone by Future Software in 1999-2000                          
'͹
'Created in SVGA 320*200*256 using the Future.Library                
'Visit Future Software online at http://www.qb45.com                 
'͹
'Programmed by:                                                      
'Jorden Chamid <Webmaster@Qb45.com> (Future Software)                
'And                                                                 
'Frans Boerboom <Badjas_Productions@Hotmail.com> (Badjas Productions)
'And                                                                 
'Killian Darkwater <Killian_314@Hotmail.com> (Future Software)       
'͹
'Credits to:                                                         
'Michael Rye Sorensen                                                
'  He did the graphical routines, which we used...without him it     
'  would be less good than it is now!                                
'Jesse Dorland                                                       
'  The author of the wonderful QMIDI package we used to play the     
'  background music                                                  
'Nintendo                                                            
'  Ofcourse we also wanna credit the original programmers of Zelda,  
'  we had hours of fun playing it!                             THANX!
'ͼ

DECLARE SUB InventoryScreen ()
DECLARE FUNCTION EnemyCollision% (EX%, EY%)
DECLARE SUB UpDateCave ()
DECLARE SUB PaletteSet (nColor%)
DECLARE SUB PaletteGet (nColor%)
DECLARE SUB FadeOut ()
DECLARE SUB CaveLoop ()
DECLARE SUB LoadCave (CaveX%, CaveY%)
DECLARE SUB ScrollToNewMap ()
DECLARE SUB Intro ()
DECLARE SUB LoadEnemyInfo (File$)
DECLARE SUB Initialize ()
DECLARE SUB DoEnemies ()
DECLARE SUB DoSword ()
DECLARE SUB LoadNextMap ()
DECLARE FUNCTION Collision% ()
DECLARE SUB RemoveLink ()
DECLARE SUB DrawMapPiece (MapX%, MapY%)
DECLARE SUB MainLoop ()
DECLARE SUB LoadMap (Map$)
DECLARE SUB DrawMap ()
DECLARE SUB GetTiles ()
DECLARE SUB PutLink ()
DECLARE SUB SVGAGET (BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%, BYVAL Segment%, BYVAL Offset%)
DECLARE SUB SVGAPUT (BYVAL X%, BYVAL Y%, BYVAL Segment%, BYVAL Offset%)
	 
DEFINT A-Z
'$INCLUDE: 'future.bi'
'$DYNAMIC
CLEAR
TYPE Registers
	 AX    AS INTEGER
	 BX    AS INTEGER
	 CX    AS INTEGER
	 DX    AS INTEGER
	 BP    AS INTEGER
	 SI    AS INTEGER
	 DI    AS INTEGER
	 FLAGS AS INTEGER
	 DS    AS INTEGER
	 ES    AS INTEGER
END TYPE
IntXCodeData:
DATA  &H55, &H8B, &HEC, &H83, &HEC, &H08, &H56, &H57, &H1E, &H55, &H8B, &H5E
DATA  &H06, &H8B, &H47, &H10, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H10, &H8B, &H47, &H12, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H12, &H8B, &H47, &H08, &H89, &H46, &HF8, &H8B, &H07, &H8B, &H4F, &H04
DATA  &H8B, &H57, &H06, &H8B, &H77, &H0A, &H8B, &H7F, &H0C, &HFF, &H77, &H12
DATA  &H07, &HFF, &H77, &H02, &H1E, &H8F, &H46, &HFA, &HFF, &H77, &H10, &H1F
DATA  &H8B, &H6E, &HF8, &H5B, &HCD, &H21, &H55, &H8B, &HEC, &H8B, &H6E, &H02
DATA  &H89, &H5E, &HFC, &H8B, &H5E, &H06, &H1E, &H8F, &H46, &HFE, &HFF, &H76
DATA  &HFA, &H1F, &H89, &H07, &H8B, &H46, &HFC, &H89, &H47, &H02, &H89, &H4F
DATA  &H04, &H89, &H57, &H06, &H58, &H89, &H47, &H08, &H89, &H77, &H0A, &H89
DATA  &H7F, &H0C, &H9C, &H8F, &H47, &H0E, &H06, &H8F, &H47, &H12, &H8B, &H46
DATA  &HFE, &H89, &H47, &H10, &H5A, &H1F, &H5F, &H5E, &H8B, &HE5, &H5D, &HCA
DATA  &H02, &H00
DIM SHARED QMIDIRegs AS Registers, MEM.SEGMENT(0 TO 255) AS INTEGER
DIM SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER, PAUSED AS SINGLE
DIM SHARED SBMIDI.INTERRUPT AS INTEGER, MEM.ALLOCATED(0 TO 255) AS LONG
DIM SHARED SBSIM.INTERRUPT AS INTEGER, MIXER.CHIP AS INTEGER
DIM SHARED SB.BASEPORT AS INTEGER, SB.IRQ AS INTEGER
DIM SHARED SB.LODMA AS INTEGER, SB.HIDMA AS INTEGER, SB.CARDTYPE AS INTEGER
DIM SHARED SB.MPU401 AS INTEGER, BIT.STORAGE(0 TO 7) AS INTEGER
DIM SHARED SENSITIVE AS INTEGER, REVERSE.STEREO AS INTEGER
DIM SHARED Sound.DisAbled AS INTEGER, CURRENTHANDLE AS INTEGER

DriversLoaded SBMIDI.INTERRUPT, SBSIM.INTERRUPT
IF SBMIDI.INTERRUPT = 0 THEN SBMIDI.INTERRUPT = &H80
IF SBSIM.INTERRUPT = 0 THEN SBSIM.INTERRUPT = &H81

TYPE Player
	X AS INTEGER
	Y AS INTEGER
	AnimNum AS INTEGER    'Needed for animation
	Times AS INTEGER      'Needed to slow down animation
	Dir AS INTEGER        'Direction Link is facing
	Moving AS INTEGER     'Is Link moving or standing still?
	Thrust AS INTEGER     'Link uses his sword
	Sword AS INTEGER      'Does Link have a sword, if yes, which sword?
	InCave AS INTEGER     'Is Link in a cave?
	OldX AS INTEGER       'For when Link is entering the cave, I need to
	OldY AS INTEGER       'remember his old position
	InDungeon AS INTEGER  'Is Link in a level?
	DungeonXMap AS INTEGER  'Mapfile for dungeon
	DungeonYMap AS INTEGER
	OldX2 AS INTEGER
	OldY2 AS INTEGER
	RemoveSword AS INTEGER
	SwordX AS INTEGER
	SwordY AS INTEGER
	ThrustTimes AS INTEGER
	CanThrust AS INTEGER
	ThrustTimer AS SINGLE
	HP AS SINGLE          'Hitpoints
	MaxHP AS INTEGER
	JustHit AS INTEGER
 
	Keys AS INTEGER
	Bombs AS INTEGER
	Coins AS INTEGER
END TYPE
TYPE EnemyInfo
	X               AS INTEGER    'Position of enemy
	Y               AS INTEGER    '
	Dir             AS INTEGER    'Direction enemy is going to
	AnimNum         AS INTEGER    'Animation number
	EnemyType       AS INTEGER    'Type of enemy (spider,crawley etc)
	EDir            AS INTEGER    'Second dir-for easier animation
	Times           AS INTEGER    'Animation-slowing down
	HP              AS INTEGER    'Enemy Hitpoints
	Path            AS INTEGER    '16 times moved=check for different dir2move
	Remove          AS INTEGER    'When enemy is dead, a graphical trace
	Jumping         AS INTEGER    'For spider
	JumpDir1        AS INTEGER    '
	JumpDir2        AS INTEGER    '

	EnemySpec       AS INTEGER
	EnemyShot       AS INTEGER
END TYPE

'Shot Types:
'1 = Stone
'2 = Spear
'3 = Fireball

'Enemy Types:
'1 = Red Crawly
'2 = Blue Crawly
'3 = Red Moblin
'4 = Blue Moblin
'5 = Red Spider
'6 = Blue Spider
'7 = Red Zora
'8 = Black Zora
'9 = Armos Knight

'Enemy Specials
'0 = None
'1 = Jump
'2 = Appear from water

DIM SHARED LinkSprite(350, 14), LinkTemp(350), SwordTemp(350)
DIM SHARED Items(350, 5), LinkSword(140, 5), Rocks(160, 120)
DIM SHARED EnemyRemove(160, 3), Collide(110)
DIM SHARED Enemy(10) AS EnemyInfo, Map(2 TO 18, 2 TO 12)

DIM SHARED EnemyGFX(160, 60)

DIM SHARED EMSHandle%, MidiFile, Hearts(70, 2)

DIM SHARED Link AS Player, CollideNum, XMap, YMap
DIM SHARED TotalEnemies, CaveTimes, CaveText1$, CaveText2$
DIM SHARED Bar(11000), Coin(140, 2), CoinTimes, FileName$
TYPE PaletteType
				Red AS INTEGER
				Green AS INTEGER
				Blue AS INTEGER
END TYPE
DIM SHARED Pal AS PaletteType, pData(0 TO 255, 1 TO 3)  'Palette.fade in/out

Initialize
MidiFile = LoadMIDI("music\normal.mid")
PlayMidi MidiFile
MainLoop

REM $STATIC
SUB CaveLoop
CLOSE
OPEN "Link002.dat" FOR INPUT AS #1
DO
num = num + 1
INPUT #1, Collide(num)
LOOP UNTIL EOF(1)
CollideNum = num
MainLoop
END SUB

SUB CheckHit
'Checks for Link being hit by an enemy
IF Link.JustHit THEN
	'Change Link colors
	Link.JustHit = Link.JustHit - 1
	'SELECT CASE Link.JustHit
	'CASE 0: LoadPal "link.pal"
	'CASE 5: ChangePal 9, 248, 56, 0: ChangePal 11, 255, 255, 255: ChangePal 15, 255, 163, 71
	'CASE 10: ChangePal 9, 0, 0, 0: ChangePal 11, 248, 56, 0: ChangePal 15, 0, 139, 139
	'CASE 15: ChangePal 9, 0, 0, 191: ChangePal 11, 255, 255, 255: ChangePal 15, 107, 136, 255
	'CASE 20: ChangePal 9, 248, 56, 0: ChangePal 11, 255, 255, 255: ChangePal 15, 255, 163, 71
	'END SELECT
END IF
X1 = INT(Link.X / 16): Y1 = INT(Link.Y / 16)
FOR Which = 1 TO TotalEnemies
	IF Enemy(Which).HP > 0 THEN
	X2 = INT(Enemy(Which).X / 16): Y2 = INT(Enemy(Which).Y / 16)
	IF X1 = X2 AND Y1 = Y2 THEN
		IF Link.JustHit = 0 THEN
		Link.HP = Link.HP - .5
		Link.JustHit = 20
		IF Link.HP <= 0 THEN
			StopMidi
			UnLoadMidi MidiFile
			FadeOut
			Future.CLS 0
			ChangePal 255, 255, 255, 255
			Future.Print 128, 96, "GAME OVER", 255, 0
			UnLoadMidi MidiFile
			MidiFile = LoadMIDI("music\GameOver.mid")
			PlayMidi MidiFile

			DO: LOOP UNTIL INKEY$ <> ""
			FadeOut
			StopMidi
			UnLoadMidi MidiFile
			CleanUpMidi
			StopAndReset
			ResetScreen
			DeallExpMem EMSHandle%  'free up EMS memory
			END
		END IF
		DrawMapPiece X1, Y1
		DrawMapPiece X1 + 1, Y1
		DrawMapPiece X1 + 1, Y1 + 1
		DrawMapPiece X1, Y1 + 1
		DrawMapPiece X1 - 1, Y1
		DrawMapPiece X1 - 1, Y1 + 1
		DrawMapPiece X1 - 1, Y1 - 1
		DrawMapPiece X1 + 1, Y1 - 1
		DrawMapPiece X1, Y1 - 1
		DrawMapPiece X1 + 2, Y1
		DrawMapPiece X1 + 2, Y1 + 1
		SELECT CASE Enemy(Which).Dir
		CASE 1:
		FOR A = 0 TO 32 STEP 16
			Link.Y = Link.Y - A
			IF Collision2(Link.X / 16, Link.Y / 16) <> 0 THEN Link.Y = Link.Y + 16: GOTO EndCheck
			Link.Y = Link.Y + A
		NEXT
		CASE 2:
		FOR A = 0 TO 32 STEP 16
			Link.X = Link.X - A
			IF Collision2(Link.X / 16, Link.Y / 16) <> 0 THEN Link.X = Link.X + 16: GOTO EndCheck
			Link.X = Link.X + A
		NEXT
		CASE 3:
		FOR A = 0 TO 32 STEP 16
			Link.X = Link.X + A
			IF Collision2(Link.X / 16, Link.Y / 16) <> 0 THEN Link.X = Link.X - 16: GOTO EndCheck
			Link.X = Link.X - A
		NEXT
		CASE 4:
		FOR A = 0 TO 32 STEP 16
			Link.Y = Link.Y + A
			IF Collision2(Link.X / 16, Link.Y / 16) <> 0 THEN Link.Y = Link.Y - 16: GOTO EndCheck
			Link.Y = Link.Y - A
		NEXT
		END SELECT
EndCheck:
		PutLink
		Status
	END IF
	END IF
	END IF
NEXT
END SUB

DEFSNG A-Z
SUB CleanUpMidi
FOR I% = 0 TO 255
	IF MEM.SEGMENT(I%) THEN UnLoadMidi I%
NEXT I%
MIDI.ERROR = 0
END SUB

DEFINT A-Z
FUNCTION Collision
DIM Temp3(1000)
IF Link.InCave AND Link.Y <= 112 AND Link.Dir = 6 THEN Collision = 1: EXIT FUNCTION
Collision = 0
IF Link.InDungeon THEN
	IF Link.Y <= 41 THEN NextDungeon = 1
	IF Link.Y >= 175 THEN NextDungeon = 1
	IF Link.X <= 53 THEN NextDungeon = 1
	IF Link.X >= 255 THEN NextDungeon = 1
	IF NextDungeon THEN
		SELECT CASE Link.Dir
		CASE 6: Link.DungeonYMap = Link.DungeonYMap - 1: Link.Y = 200 - Link.Y - 16
		CASE 4: Link.DungeonXMap = Link.DungeonXMap + 1: Link.X = 320 - Link.X
		CASE 0: Link.DungeonYMap = Link.DungeonYMap + 1: Link.Y = 208 - Link.Y + 16
			IF Link.DungeonYMap = 1 AND Link.DungeonXMap = 0 THEN
				FadeOut
				'Link gets out of the dungeon
				Link.InDungeon = 0
				Link.X = Link.OldX: Link.Y = Link.OldY + 2
				CLOSE
				OPEN "LINK001.DAT" FOR INPUT AS #1
				DO
				num = num + 1
				INPUT #1, Collide(num)
				LOOP UNTIL EOF(1)
				CollideNum = num
				Future.CLS 0
				SetPage 2
				GetTiles
				MapName$ = "newmaps\" + LTRIM$(RTRIM$(STR$(XMap))) + "_" + LTRIM$(RTRIM$(STR$(YMap))) + ".map"
				LoadMap MapName$
				LoadEnemyInfo "ENEMIES\" + LTRIM$(RTRIM$(STR$(XMap))) + "_" + LTRIM$(RTRIM$(STR$(YMap))) + ".dat"
				SetPage 1: ViewPage 1
				DrawMap
				'Link walking UP stairs
				LoadWAV "sound\cave.wav"
				FOR Times = 0 TO 16
					SetPage 2
					Future.CLS 0
					Link.Times = Link.Times + 1
					IF Link.Times >= 3 THEN
					IF Link.AnimNum = 1 THEN Link.AnimNum = 0 ELSE Link.AnimNum = 1
						Link.Times = 0
					END IF
					SVGAPUT 0, 0, VARPTR(LinkSprite(0, Link.Dir + Link.AnimNum)), VARSEG(LinkSprite(0, Link.Dir + Link.AnimNum))
					Future.GET 0, 0, 16, Times, Temp3()
					SetPage 1
					WAIT &H3DA, 8, 8: WAIT &H3DA, 8
					WAIT &H3DA, 8, 8: WAIT &H3DA, 8
					WAIT &H3DA, 8, 8: WAIT &H3DA, 8
					WAIT &H3DA, 8, 8: WAIT &H3DA, 8
					CaveX = INT(Link.X / 16): CaveY = INT(Link.Y / 16)
					DrawMapPiece CaveX, CaveY: DrawMapPiece CaveX, CaveY + 1: DrawMapPiece CaveX, CaveY - 1
					DrawMapPiece CaveX + 1, CaveY: DrawMapPiece CaveX + 1, CaveY + 1: DrawMapPiece CaveX + 1, CaveY - 1
					Future.Put Link.X, Link.Y - Times + 5, Temp3()
				NEXT
				UnLoadMidi MidiFile
				MidiFile = LoadMIDI("music\normal.mid")
				PlayMidi MidiFile
				EXIT FUNCTION
			END IF
		CASE 2: Link.DungeonXMap = Link.DungeonXMap - 1: Link.X = 288 - Link.X
		END SELECT
		MapName$ = "newmaps\level1\" + LTRIM$(RTRIM$(STR$(Link.DungeonXMap))) + "_" + LTRIM$(RTRIM$(STR$(Link.DungeonYMap))) + ".map"
		LoadMap MapName$
		LoadEnemyInfo "ENEMIES\level1\" + LTRIM$(RTRIM$(STR$(Link.DungeonXMap))) + "_" + LTRIM$(RTRIM$(STR$(Link.DungeonYMap))) + ".dat"
		DrawMap
		PutLink
	END IF
ELSE
	IF Link.Y <= 25 THEN Collision = 0: LoadNextMap: EXIT FUNCTION
	IF Link.Y >= 175 THEN Collision = 0: LoadNextMap: EXIT FUNCTION
	IF Link.X <= 37 THEN Collision = 0: LoadNextMap: EXIT FUNCTION
	IF Link.X >= 271 THEN Collision = 0: LoadNextMap: EXIT FUNCTION
END IF

SELECT CASE Link.Dir
CASE 6: tx1 = 13: tx2 = 3: ty1 = 6: ty2 = 6
CASE 0: tx1 = 13: tx2 = 3: ty1 = 16: ty2 = 16
CASE 4: tx1 = 16: tx2 = 16: ty1 = 9: ty2 = 13
CASE 2: tx1 = -1: tx2 = -1: ty1 = 9: ty2 = 13
END SELECT

IF Link.InCave THEN
	IF Map((Link.X + tx2) \ 16, (Link.Y + ty2) \ 16) = 4 THEN
		Link.Sword = 1: LoadWAV "sound\getsw.wav"
		X1 = (Link.X + tx2) \ 16
		Y1 = (Link.Y + ty2) \ 16
		Map(X1, Y1) = 5
		DrawMapPiece X1, Y1
		RemoveLink
		SVGAPUT Link.X, Link.Y, VARPTR(LinkSprite(0, 12)), VARSEG(LinkSprite(0, 12))
		SVGAPUT Link.X - 5, Link.Y - 16, VARPTR(Rocks(0, 4)), VARSEG(Rocks(0, 4))
		SVGAPUT 163, 8, VARPTR(LinkSword(0, 5)), VARSEG(LinkSword(0, 5))
		Tim! = TIMER
		DO: LOOP UNTIL TIMER >= Tim! + 2
		DrawMapPiece X1, Y1
		DrawMapPiece X1, Y1 - 1
		DrawMapPiece X1 - 1, Y1 - 1
		DrawMapPiece X1 - 1, Y1
		DrawMapPiece X1 + 1, Y1 - 1
		DrawMapPiece X1 + 1, Y1

	END IF
ELSE
	IF Link.InDungeon = 0 THEN
		IF Map((Link.X + tx2) \ 16, (Link.Y + ty2) \ 16) = 16 THEN CALL LoadCave((Link.X + tx2) \ 16, (Link.Y + ty2) \ 16): EXIT FUNCTION
		IF Map((Link.X + tx1) \ 16, (Link.Y + ty1) \ 16) = 16 THEN CALL LoadCave((Link.X + tx1) \ 16, (Link.Y + ty1) \ 16): EXIT FUNCTION
	END IF
END IF
FOR J = 1 TO CollideNum - 1
IF Map((Link.X + tx1) \ 16, (Link.Y + ty1) \ 16) = Collide(J) THEN Collision = 1: EXIT FUNCTION
IF Map((Link.X + tx2) \ 16, (Link.Y + ty2) \ 16) = Collide(J) THEN Collision = 1: EXIT FUNCTION
NEXT J
Collision = 0
END FUNCTION

FUNCTION Collision2 (X2, Y2)
Collision2 = 0
IF Y2 < 2 OR X2 < 2 OR X2 > 17 OR Y2 > 11 THEN Collision2 = 1: EXIT FUNCTION
IF Map(X2, Y2) <> 0 THEN Collision2 = 1
FOR J = 1 TO CollideNum - 1
IF Map(X2, Y2) = Collide(J) THEN Collision2 = 1: EXIT FUNCTION
NEXT J

END FUNCTION

SUB DoEnemies
RANDOMIZE TIMER
FOR Which = 1 TO TotalEnemies

IF Enemy(Which).HP > 0 THEN
SELECT CASE Enemy(Which).EnemyType
CASE 1, 2, 7, 8:  'Blue or Red Crawley

X1 = INT(Enemy(Which).X / 16): Y1 = INT(Enemy(Which).Y / 16)

IF Enemy(Which).Path = 16 THEN
	Enemy(Which).Path = 0
2 : A = RND * 3 + 1

	SELECT CASE A
	CASE 1: X1 = INT(Enemy(Which).X / 16): Y1 = INT(Enemy(Which).Y / 16) - 1
		IF Enemy(Which).Dir = 4 THEN GOTO 2
		IF EnemyCollision(X1, Y1) THEN
			IF EnemyCollision(X1 + 1, Y1 + 1) = 0 THEN A = 3: GOTO 3
			IF EnemyCollision(X1 - 1, Y1 + 1) = 0 THEN A = 2: GOTO 3
			IF EnemyCollision(X1, Y1 + 2) = 0 THEN A = 4: GOTO 3
		END IF
	CASE 2: X1 = INT(Enemy(Which).X / 16) - 1: Y1 = INT(Enemy(Which).Y / 16)
		IF Enemy(Which).Dir = 3 THEN GOTO 2
		IF EnemyCollision(X1, Y1) THEN
			IF EnemyCollision(X1 + 1, Y1 + 1) = 0 THEN A = 4: GOTO 3
			IF EnemyCollision(X1 + 1, Y1 - 1) = 0 THEN A = 1: GOTO 3
			IF EnemyCollision(X1 + 2, Y1) = 0 THEN A = 3: GOTO 3
		END IF
	CASE 3: X1 = INT(Enemy(Which).X / 16) + 1: Y1 = INT(Enemy(Which).Y / 16)
		IF Enemy(Which).Dir = 2 THEN GOTO 2
		IF EnemyCollision(X1, Y1) THEN
			IF EnemyCollision(X1 - 1, Y1 - 1) = 0 THEN A = 1: GOTO 3
			IF EnemyCollision(X1 - 1, Y1 + 1) = 0 THEN A = 4: GOTO 3
			IF EnemyCollision(X1 - 2, Y1) = 0 THEN A = 2: GOTO 3
		END IF
	CASE 4: X1 = INT(Enemy(Which).X / 16): Y1 = INT(Enemy(Which).Y / 16) + 1
		IF Enemy(Which).Dir = 1 THEN GOTO 2
		IF EnemyCollision(X1, Y1) THEN
			IF EnemyCollision(X1 - 1, Y1 - 1) = 0 THEN A = 2: GOTO 3
			IF EnemyCollision(X1 + 1, Y1 - 1) = 0 THEN A = 3: GOTO 3
			IF EnemyCollision(X1 + 1, Y1 - 2) = 0 THEN A = 1: GOTO 3
		END IF
	END SELECT

3 : Enemy(Which).Dir = A
	SELECT CASE Enemy(Which).Dir
	CASE 1: Enemy(Which).EDir = 0
	CASE 2: Enemy(Which).EDir = 6
	CASE 3: Enemy(Which).EDir = 4
	CASE 4: Enemy(Which).EDir = 2
	END SELECT
END IF
	Enemy(Which).Path = Enemy(Which).Path + 1
	SELECT CASE Enemy(Which).Dir
	CASE 1: Enemy(Which).Y = Enemy(Which).Y - 1: Enemy(Which).EDir = 0
	CASE 2: Enemy(Which).X = Enemy(Which).X - 1: Enemy(Which).EDir = 6
	CASE 3: Enemy(Which).X = Enemy(Which).X + 1: Enemy(Which).EDir = 4
	CASE 4: Enemy(Which).Y = Enemy(Which).Y + 1: Enemy(Which).EDir = 2
	END SELECT

CASE 5, 6:
	IF Enemy(Which).Jumping THEN
		Enemy(Which).Jumping = Enemy(Which).Jumping + 1
		IF Enemy(Which).Jumping = 9 THEN Enemy(Which).Jumping = 0
		SELECT CASE Enemy(Which).JumpDir1
		CASE 1: Enemy(Which).X = Enemy(Which).X - 4
		CASE 2: Enemy(Which).X = Enemy(Which).X + 4
		END SELECT
		SELECT CASE Enemy(Which).JumpDir2
		CASE 1: Enemy(Which).Y = Enemy(Which).Y - 4
		CASE 2: Enemy(Which).Y = Enemy(Which).Y + 4
		END SELECT
	 
	ELSE
	JumpYESorNO = RND * 70
	IF JumpYESorNO = 0 THEN
		Enemy(Which).JumpDir1 = RND * 2 + 1
		Enemy(Which).JumpDir2 = RND * 2 + 1
		SELECT CASE Enemy(Which).JumpDir1
		CASE 1: X1 = INT((Enemy(Which).X - 32) / 16)
		CASE 2: X1 = INT((Enemy(Which).X + 32) / 16)
		CASE 3: X1 = INT((Enemy(Which).X) / 16)
		END SELECT
		SELECT CASE Enemy(Which).JumpDir2
		CASE 1: Y1 = INT((Enemy(Which).Y - 32) / 16)
		CASE 2: Y1 = INT((Enemy(Which).Y + 32) / 16)
		CASE 3: Y1 = INT((Enemy(Which).Y) / 16)
		END SELECT
		IF X1 <= 3 THEN Enemy(Which).JumpDir1 = 2
		IF Y1 <= 3 THEN Enemy(Which).JumpDir2 = 2
		IF X1 >= 16 THEN Enemy(Which).JumpDir1 = 1
		IF Y1 >= 10 THEN Enemy(Which).JumpDir2 = 1
		Enemy(Which).Jumping = 1
		END IF
	END IF
END SELECT

END IF
NEXT
END SUB

SUB DoSword
IF Link.Sword THEN
IF Link.Thrust THEN EXIT SUB
IF Link.Thrust = 0 THEN LoadWAV "sound\sword.wav"
Link.CanThrust = 0
Link.ThrustTimer = TIMER
RemoveLink
Link.Thrust = 1
SELECT CASE Link.Dir
CASE 0:
		 Link.SwordX = Link.X + 2: Link.SwordY = Link.Y + 16
		 Future.GET Link.SwordX, Link.SwordY, Link.SwordX + 15, Link.SwordY + 15, SwordTemp()
		 
		 SVGAPUT Link.X, Link.Y, VARPTR(LinkSprite(0, 8)), VARSEG(LinkSprite(0, 8))
		 SVGAPUT Link.X + 2, Link.Y + 16, VARPTR(LinkSword(0, 0)), VARSEG(LinkSword(0, 0))
CASE 6:
		 Link.SwordX = Link.X: Link.SwordY = Link.Y - 12
		 Future.GET Link.SwordX, Link.SwordY, Link.SwordX + 15, Link.SwordY + 15, SwordTemp()

		 SVGAPUT Link.X, Link.Y, VARPTR(LinkSprite(0, 9)), VARSEG(LinkSprite(0, 9))
		 SVGAPUT Link.X, Link.Y - 12, VARPTR(LinkSword(0, 1)), VARSEG(LinkSword(0, 1))
CASE 4:
		 Link.SwordX = Link.X + 15: Link.SwordY = Link.Y + 2
		 Future.GET Link.SwordX, Link.SwordY, Link.SwordX + 15, Link.SwordY + 15, SwordTemp()

		 SVGAPUT Link.X, Link.Y, VARPTR(LinkSprite(0, 11)), VARSEG(LinkSprite(0, 11))
		 SVGAPUT Link.X + 15, Link.Y + 2, VARPTR(LinkSword(0, 3)), VARSEG(LinkSword(0, 3))
CASE 2:
		 Link.SwordX = Link.X - 12: Link.SwordY = Link.Y + 2
		 Future.GET Link.SwordX, Link.SwordY, Link.SwordX + 15, Link.SwordY + 15, SwordTemp()

		 SVGAPUT Link.X, Link.Y, VARPTR(LinkSprite(0, 10)), VARSEG(LinkSprite(0, 10))
		 SVGAPUT Link.X - 12, Link.Y + 2, VARPTR(LinkSword(0, 2)), VARSEG(LinkSword(0, 2))
END SELECT

'Checking for collision with enemies
	SELECT CASE Link.Dir
	CASE 0: X1 = (Link.X + 2) / 16: Y1 = (Link.Y + 16) / 16
	CASE 6: X1 = Link.X / 16: Y1 = (Link.Y - 12) / 16
	CASE 4: X1 = (Link.X + 15) / 16: Y1 = (Link.Y + 2) / 16
	CASE 2: X1 = (Link.X - 12) / 16: Y1 = (Link.Y + 2) / 16
	END SELECT
FOR Which = 1 TO TotalEnemies
	X2 = INT(Enemy(Which).X / 16): Y2 = INT(Enemy(Which).Y / 16)
	IF X1 >= X2 AND X1 <= X2 + 1 THEN
		IF Y1 >= Y2 AND Y1 <= Y2 + 1 THEN
			IF Enemy(Which).HP > 0 THEN
				Enemy(Which).HP = Enemy(Which).HP - 1
				LoadWAV "sound\EHit.wav"
				IF Enemy(Which).HP = 0 THEN
					Enemy(Which).Remove = 6
				ELSE
					SELECT CASE Enemy(Which).Dir
					CASE 1:
						FOR A = 32 TO 0 STEP -16
						Enemy(Which).Y = Enemy(Which).Y + A
						IF EnemyCollision(Enemy(Which).X / 16, Enemy(Which).Y / 16) = 0 THEN GOTO EndECheck
						Enemy(Which).Y = Enemy(Which).Y - A
						NEXT
					CASE 2:
						FOR A = 32 TO 0 STEP -16
						Enemy(Which).X = Enemy(Which).X + A
						IF EnemyCollision(Enemy(Which).X / 16, Enemy(Which).Y / 16) = 0 THEN GOTO EndECheck
						Enemy(Which).X = Enemy(Which).X - A
						NEXT
					CASE 3:
						FOR A = 32 TO 0 STEP -16
						Enemy(Which).X = Enemy(Which).X - A
						IF EnemyCollision(Enemy(Which).X / 16, Enemy(Which).Y / 16) = 0 THEN GOTO EndECheck
						Enemy(Which).X = Enemy(Which).X + A
						NEXT
					CASE 4:
						FOR A = 32 TO 0 STEP -16
						Enemy(Which).Y = Enemy(Which).Y - A
						IF EnemyCollision(Enemy(Which).X / 16, Enemy(Which).Y / 16) = 0 THEN GOTO EndECheck
						Enemy(Which).Y = Enemy(Which).Y + A
						NEXT
					END SELECT
				END IF
EndECheck:

			END IF
		END IF
	END IF
NEXT
END IF
END SUB

SUB DrawMap
Future.FillBox 0, 32, 32, 200, 0
Future.FillBox 0, 0, 320, 32, 0
Future.FillBox 288, 32, 320, 200, 0
Future.FillBox 0, 190, 320, 200, 0
FOR MapY = 2 TO 11
	FOR MapX = 2 TO 18
	IF Link.InCave THEN
		IF Map(MapX, MapY) = 2 OR Map(MapX, MapY) = 3 THEN
			SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, 9)), VARSEG(Rocks(0, 9))
		ELSE
			IF Link.Sword AND Map(MapX, MapY) = 4 THEN Map(MapX, MapY) = 5
			DrawMapPiece MapX, MapY
		END IF
	ELSE
		DrawMapPiece MapX, MapY
	END IF
	NEXT MapX
NEXT MapY
Future.Put 32, 0, Bar()

ChangePal 254, 255, 255, 255
Future.Print 114, 1, "X0", 254, -1    'Number of coins
Future.Print 114, 17, "X0", 254, -1    'Number of coins
Future.Print 114, 25, "X0", 254, -1    'Number of coins
IF Link.Sword THEN SVGAPUT 163, 8, VARPTR(LinkSword(0, 5)), VARSEG(LinkSword(0, 5))
Future.EMSGet 32, 32, 288, 192, EMSHandle%
Status
END SUB

SUB DrawMapPiece (MapX, MapY)
IF MapX < 2 OR MapY < 2 OR MapX > 17 OR MapY > 11 THEN EXIT SUB
SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, Map(MapX, MapY))), VARSEG(Rocks(0, Map(MapX, MapY)))
END SUB

REM $DYNAMIC
DEFSNG A-Z
'DriversLoaded - Attempt to detect if sound drivers are loaded
SUB DriversLoaded (SBMIDI%, SBSIM%)
'Open the data file.
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
FileSize& = LOF(FF%)
NoExist% = 0
'If the file is empty, return an error.
IF FileSize& = 0 THEN
	CLOSE FF%
	KILL "DRIVERS.DAT"
	MIDI.ERROR = 1
	NoExist% = 1
'If the file is not exactly 1,024 bytes in size, return an error.
ELSEIF FileSize& <> 1024 THEN
	CLOSE FF%
	MIDI.ERROR = 9
	NoExist% = 1
END IF

'If DRIVERS.DAT exists, and is 1 kilobyte in size, read the driver
'data from it.
IF NoExist% = 0 THEN
REDIM DRIVERDATA$(1 TO 5)
FOR I% = 1 TO 4
	DRIVERDATA$(I%) = INPUT$(256, #FF%)
NEXT I%
END IF

'Close the data file.
CLOSE #FF%

'Check the interrupt handlers for int 80h-FFh, to see if they are occupied
'by either SBMIDI or SBSIM.
SBMIDI% = 0
SBSIM% = 0
FOR I% = &H80 TO &HFF
	'Get the address of the interrupt handler.
	InternalGetIntVector I%, Segment&, Offset&
	'If the segment returned is 0, that means that the current interrupt
	'is not in use.
	IF Segment& = 0 THEN GOTO Skip:

	'The following code checks for the drivers by looking for the text
	'"SBMIDI" and "SBSIM" at certain locations in the driver code.
	'If it doesn't work, a different method is used.
	IF SBMIDI% = 0 THEN
		DEF SEG = Segment& - 17
		Temp$ = ""
		FOR J% = 1 TO 6
		Temp$ = Temp$ + CHR$(PEEK(271 + J%))
		NEXT
		IF Temp$ = "SBMIDI" THEN SBMIDI% = I%
	END IF
	IF SBSIM% = 0 AND Segment& <> 0 THEN
		DEF SEG = Segment& - 1
		Temp$ = ""
		FOR J% = 1 TO 5
			Temp$ = Temp$ + CHR$(PEEK(274 + J%))
		NEXT
		IF Temp$ = "SBSIM" THEN SBSIM% = I%
	END IF
 
	'This is the second detection method.  It's more complex than the first
	'method, but not really any more accurate.
	IF NoExist% = 0 THEN
	'Point to the segment of the interrupt handler.
	DEF SEG = Segment&
	'Read 256 bytes of code from the interrupt handler.
	DRIVERDATA$(5) = ""
	FOR J% = 0 TO 255
		Byte% = PEEK(Offset& + J%)
		DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(Byte%)
	NEXT J%
	'Check to see if the code matches any of the data from DRIVERS.DAT.
	FOR J% = 1 TO 4
		MATCH% = 1
		FOR k% = 0 TO 255
			IF MID$(DRIVERDATA$(J%), k% + 1, 1) <> MID$(DRIVERDATA$(5), k% + 1, 1) THEN
				SELECT CASE k%
					CASE IS = 14, 15, 113, 114, 235, 236
					CASE ELSE
						MATCH% = 0
						EXIT FOR
				END SELECT
			END IF
		NEXT k%
		'If there was a match, find out which driver is using the interrupt.
		IF MATCH% THEN
			IF J% = 1 THEN SBSIM% = I%
			IF J% <> 1 THEN SBMIDI% = I%
		END IF
		'If both SBMIDI and SBSIM have been found, exit the loop.
		IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	NEXT J%
	 
	'If both SBMIDI and SBSIM have been found, exit the loop.
	IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	END IF
Skip:
NEXT I%
IF NoExist% = 0 THEN MIDI.ERROR = 0
END SUB

REM $STATIC
DEFINT A-Z
FUNCTION EnemyCollision (EX, EY)
EnemyCollision = 0
IF EY < 2 OR EX < 2 OR EX > 17 OR EY > 11 THEN EnemyCollision = 1: EXIT FUNCTION
IF Map(EX, EY) <> 0 THEN EnemyCollision = 1
END FUNCTION

SUB FadeOut
DIM tT(1 TO 3)
FOR I = 0 TO 255
	PaletteGet I: pData(I, 1) = Pal.Red
	pData(I, 2) = Pal.Green: pData(I, 3) = Pal.Blue
NEXT I
FOR I = 1 TO 64
WAIT &H3DA, 8, 8: WAIT &H3DA, 8
	FOR O = 0 TO 255
		PaletteGet O: tT(1) = Pal.Red: tT(2) = Pal.Green: tT(3) = Pal.Blue
		IF tT(1) > 0 THEN tT(1) = tT(1) - 1
		IF tT(2) > 0 THEN tT(2) = tT(2) - 1
		IF tT(3) > 0 THEN tT(3) = tT(3) - 1
		Pal.Red = tT(1): Pal.Green = tT(2): Pal.Blue = tT(3): PaletteSet O
	NEXT O
NEXT I
END SUB

SUB GetTiles
CLOSE
SetPage 1
ViewPage 0
Future.LoadGIF "link9.gif", 320, 200
FOR GetLink = 0 TO 128 STEP 16
SVGAGET GetLink, 0, GetLink + 15, 15, VARPTR(LinkSprite(0, TileNum)), VARSEG(LinkSprite(0, TileNum))
TileNum = TileNum + 1
NEXT GetLink

TileNum = 8
FOR GetLink = 140 TO 236 STEP 16
SVGAGET GetLink, 0, GetLink + 15, 15, VARPTR(LinkSprite(0, TileNum)), VARSEG(LinkSprite(0, TileNum))
TileNum = TileNum + 1
NEXT GetLink
SVGAGET 0, 16, 15, 31, VARPTR(LinkSword(0, 5)), VARSEG(LinkSword(0, 5))

ChangePal 255, 0, 0, 0
FOR X1 = 0 TO 288
	FOR Y1 = 32 TO 111
		IF Future.POINT(X1, Y1) = 0 THEN Future.Pset X1, Y1, 255
	NEXT
NEXT
FOR X1 = 0 TO 288
	FOR Y1 = 144 TO 288
		IF Future.POINT(X1, Y1) = 0 THEN Future.Pset X1, Y1, 255
	NEXT
NEXT

FOR GetLink = 0 TO 288 STEP 16
SVGAGET GetLink, 32, GetLink + 15, 47, VARPTR(Rocks(0, GetLink / 16)), VARSEG(Rocks(0, GetLink / 16))
NEXT GetLink

TileNum = 0
FOR GetSword = 240 TO 288 STEP 12
SVGAGET GetSword, 0, GetSword + 11, 11, VARPTR(LinkSword(0, TileNum)), VARSEG(LinkSword(0, TileNum))
TileNum = TileNum + 1
NEXT GetSword

FOR GetLink = 0 TO 15
SVGAGET GetLink * 16, 48, GetLink * 16 + 15, 63, VARPTR(Rocks(0, GetLink + 19)), VARSEG(Rocks(0, GetLink + 19))
NEXT

FOR GetLink = 0 TO 19
SVGAGET GetLink * 16, 64, GetLink * 16 + 15, 79, VARPTR(Rocks(0, GetLink + 35)), VARSEG(Rocks(0, GetLink + 35))
NEXT

FOR GetLink = 0 TO 15
SVGAGET GetLink * 16, 80, GetLink * 16 + 15, 95, VARPTR(Rocks(0, GetLink + 56)), VARSEG(Rocks(0, GetLink + 56))
NEXT
FOR GetLink = 0 TO 9
SVGAGET GetLink * 16, 96, GetLink * 16 + 15, 111, VARPTR(Rocks(0, GetLink + 72)), VARSEG(Rocks(0, GetLink + 72))
NEXT

SVGAGET 24, 150, 31, 157, VARPTR(Hearts(0, 0)), VARSEG(Hearts(0, 0))
SVGAGET 32, 150, 39, 157, VARPTR(Hearts(0, 1)), VARSEG(Hearts(0, 1))
SVGAGET 40, 150, 47, 157, VARPTR(Hearts(0, 2)), VARSEG(Hearts(0, 2))

Future.GET 81, 168, 319, 199, Bar()
Future.LoadGIF "enemies.gif", 320, 200

TileNum = 0
FOR GetLink = 0 TO 7
SVGAGET GetLink * 16, 0, GetLink * 16 + 15, 15, VARPTR(EnemyGFX(0, GetLink)), VARSEG(EnemyGFX(0, GetLink))
NEXT GetLink

FOR GetLink = 0 TO 19
SVGAGET GetLink * 16, 16, GetLink * 16 + 15, 31, VARPTR(EnemyGFX(0, GetLink + 8)), VARSEG(EnemyGFX(0, GetLink + 8))
NEXT GetLink

FOR GetLink = 0 TO 7
SVGAGET 192 + GetLink * 16, 32, 192 + GetLink * 16 + 15, 47, VARPTR(EnemyGFX(0, GetLink + 28)), VARSEG(EnemyGFX(0, GetLink + 28))
NEXT GetLink

FOR GetLink = 0 TO 2
SVGAGET 176 + GetLink * 16, 0, 176 + GetLink * 16 + 15, 15, VARPTR(EnemyRemove(0, GetLink)), VARSEG(EnemyRemove(0, GetLink))
NEXT



Future.FillBox 0, 0, 320, 200, 0
SetMaskColor 0
ViewPage 0
END SUB

SUB Initialize
CLS
DriversLoaded SBMIDI.INTERRUPT, SBSIM.INTERRUPT
IF SBMIDI.INTERRUPT = 0 THEN
	'PRINT "SBMIDI hasn't been loaded!": A = 1
	'PRINT "Please run the ZELDA.BAT file!"
	'PRINT "If you want to run without music, press SPACE to continue"
	'DO: A$ = INKEY$: LOOP UNTIL A$ <> ""
	'IF A$ = " " THEN Sound.DisAbled = 1 ELSE END
	Sound.DisAbled = 1
END IF

Set320x200
'IF Pages < 3 THEN
'  ResetScreen
'  PRINT "You don't have enough video memory. You need at least 3 pages of memory!"
'  DO: LOOP UNTIL INKEY$ <> ""
'  END
'END IF

SetPage 3
ViewPage 3
SetFont 0
T$ = "ZeldaClone Loading (demo 2)" + SPACE$(40 - LEN(T$))
Future.Print 0, 0, T$, 0, 16
Future.Print 0, 8, "Setting resolution...done", 15, 0
Future.Print 0, 16, LTRIM$(RTRIM$(STR$(Pages%))) + " pages available.", 15, 0
Future.Print 0, 24, "Initializing EMS...", 15, 0
EMSHandle% = AllExpMem(128000)'get 256000 of EMS memory
Future.Print 152, 24, "done.", 15, 0
Future.Print 0, 32, "Getting graphics...", 15, 0
SetPage 1: ViewPage 1
GetTiles
SetPage 3: ViewPage 3
Future.Print 152, 32, "done.", 15, 0
Future.Print 0, 40, "You're now ready to play!", 15, 0
Future.Print 0, 48, "Press any key to start.", 15, 0
SetPage 1
LoadMap "Newmaps\0_0.map"
LoadEnemyInfo "Enemies\0_0.dat"
DrawMap

OPEN "LINK001.DAT" FOR INPUT AS #1
DO
num = num + 1
INPUT #1, Collide(num)
LOOP UNTIL EOF(1)
CollideNum = num

Link.X = 160: Link.Y = 100: Link.Dir = 6
Link.MaxHP = 3: Link.HP = 3
PutLink
Intro
END SUB

REM $DYNAMIC
DEFSNG A-Z
SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
QMIDIRegs.AX = IntNum% + 13568
CALL IntX(&H21, QMIDIRegs)
Segment& = QMIDIRegs.ES
Offset& = QMIDIRegs.BX
END SUB

REM $STATIC
DEFINT A-Z
SUB Intro
SetPage 1: ViewPage 1
EXIT SUB
SetPage 2
ViewPage 2
Future.Put 32, 0, Bar()

'Pagina 1 heeft alle graphics op het scherm
'De speler krijgt pagina 2 te zien
DIM Temp(5000), Temp2(5000)
FOR X = 0 TO 8 * 16
	SetPage 1
	Future.GET 160 - X, 32, 159 - X, 200, Temp()
	Future.GET 160 + X, 32, 161 + X, 200, Temp2()
	SetPage 2
	Future.Put 159 - X, 32, Temp()
	Future.Put 160 + X, 32, Temp2()
	WAIT &H3DA, 8, 8: WAIT &H3DA, 8
	A$ = INKEY$
NEXT
SetPage 1: ViewPage 1
END SUB

DEFSNG A-Z
SUB IntX (IntNum AS INTEGER, Regs AS Registers) STATIC

STATIC filenum AS INTEGER, IntOffset AS INTEGER, Loaded AS INTEGER
			 
	' use fixed-length string to fix its position in memory
	' and so we don't mess up string pool before routine
	' gets its pointers from caller

DIM IntCode AS STRING * 200
IF NOT Loaded THEN                     ' loaded will be 0 first time
	RESTORE IntXCodeData:
	 
	FOR k% = 1 TO 145
		READ h%
		MID$(IntCode, k%, 1) = CHR$(h%)
	NEXT

	'  determine address of interrupt no. offset in IntCode
	
	IntOffset% = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1
	Loaded% = -1
END IF

SELECT CASE IntNum
	
	CASE &H25, &H26, IS > 255               ' ignore these interrupts
	
	CASE ELSE
		DEF SEG = VARSEG(IntCode)             ' poke interrupt number into
		POKE VARPTR(IntCode) * 1& + IntOffset - 1, IntNum     ' code block
		CALL ABSOLUTE(Regs, VARPTR(IntCode$))               ' call routine
END SELECT

END SUB

DEFINT A-Z
SUB InventoryScreen
SavePal "temp.pal"
FadeOut
SetPage 2
Future.CLS 0
CLOSE
Future.LoadGIF "screen.gif", 320, 200
ViewPage 2

DO: IF Sound.DisAbled = 0 THEN LoopMidi
LOOP UNTIL INKEY$ <> ""
FadeOut
LoadPal "temp.pal"
SetPage 1: ViewPage 1
END SUB

SUB LoadCave (CaveX, CaveY)
DIM Temp3(1000)
ViewPage 1
LoadWAV "sound\cave.wav"
FOR Times = 0 TO 16
SetPage 2
Future.CLS 0
Link.Times = Link.Times + 1
IF Link.Times >= 3 THEN
	IF Link.AnimNum = 1 THEN Link.AnimNum = 0 ELSE Link.AnimNum = 1
	Link.Times = 0
END IF
SVGAPUT 0, 0, VARPTR(LinkSprite(0, Link.Dir + Link.AnimNum)), VARSEG(LinkSprite(0, Link.Dir + Link.AnimNum))
Future.GET 0, 0, 16, 16 - Times, Temp3()
SetPage 1
WAIT &H3DA, 8, 8: WAIT &H3DA, 8
WAIT &H3DA, 8, 8: WAIT &H3DA, 8
WAIT &H3DA, 8, 8: WAIT &H3DA, 8
WAIT &H3DA, 8, 8: WAIT &H3DA, 8

DrawMapPiece CaveX, CaveY: DrawMapPiece CaveX, CaveY + 1: DrawMapPiece CaveX, CaveY - 1
DrawMapPiece CaveX + 1, CaveY: DrawMapPiece CaveX + 1, CaveY + 1: DrawMapPiece CaveX + 1, CaveY - 1
Future.Put Link.X, CaveY * 16 + Times - 1, Temp3()
NEXT
DrawMapPiece CaveX, CaveY: DrawMapPiece CaveX, CaveY + 1: DrawMapPiece CaveX, CaveY - 1
FadeOut
Future.CLS 0
StopMidi
UnLoadMidi MidiFile
SetPage 2
CLOSE
'Dungeon 1!
IF XMap = 0 AND YMap = -4 THEN
 
	Future.LoadGIF "level1.gif", 320, 240
	FOR GetLink = 0 TO 128 STEP 16
	SVGAGET GetLink, 0, GetLink + 15, 15, VARPTR(LinkSprite(0, TileNum)), VARSEG(LinkSprite(0, TileNum))
	TileNum = TileNum + 1
	NEXT GetLink

	TileNum = 8
	FOR GetLink = 140 TO 236 STEP 16
	SVGAGET GetLink, 0, GetLink + 15, 15, VARPTR(LinkSprite(0, TileNum)), VARSEG(LinkSprite(0, TileNum))
	TileNum = TileNum + 1
	NEXT GetLink
	SVGAGET 0, 16, 15, 31, VARPTR(LinkSword(0, 5)), VARSEG(LinkSword(0, 5))
	ChangePal 255, 0, 0, 0
	FOR X1 = 0 TO 320
		FOR Y1 = 16 TO 240
			IF Future.POINT(X1, Y1) = 0 THEN Future.Pset X1, Y1, 255
		NEXT
	NEXT
	FOR GetLink = 0 TO 19
	SVGAGET GetLink * 16, 32, GetLink * 16 + 15, 47, VARPTR(Rocks(0, GetLink)), VARSEG(Rocks(0, GetLink))
	SVGAGET GetLink * 16, 48, GetLink * 16 + 15, 63, VARPTR(Rocks(0, GetLink + 20)), VARSEG(Rocks(0, GetLink + 20))
	SVGAGET GetLink * 16, 64, GetLink * 16 + 15, 79, VARPTR(Rocks(0, GetLink + 40)), VARSEG(Rocks(0, GetLink + 40))
	SVGAGET GetLink * 16, 80, GetLink * 16 + 15, 95, VARPTR(Rocks(0, GetLink + 60)), VARSEG(Rocks(0, GetLink + 60))
	SVGAGET GetLink * 16, 96, GetLink * 16 + 15, 111, VARPTR(Rocks(0, GetLink + 80)), VARSEG(Rocks(0, GetLink + 80))
	SVGAGET GetLink * 16, 112, GetLink * 16 + 15, 127, VARPTR(Rocks(0, GetLink + 100)), VARSEG(Rocks(0, GetLink + 100))
	NEXT
	TileNum = 0
	FOR GetSword = 240 TO 288 STEP 12
	SVGAGET GetSword, 0, GetSword + 11, 11, VARPTR(LinkSword(0, TileNum)), VARSEG(LinkSword(0, TileNum))
	TileNum = TileNum + 1
	NEXT GetSword

	SVGAGET 24, 150, 31, 157, VARPTR(Hearts(0, 0)), VARSEG(Hearts(0, 0))
	SVGAGET 32, 150, 39, 157, VARPTR(Hearts(0, 1)), VARSEG(Hearts(0, 1))
	SVGAGET 40, 150, 47, 157, VARPTR(Hearts(0, 2)), VARSEG(Hearts(0, 2))
 
	Future.GET 81, 168, 319, 199, Bar()
	Future.FillBox 0, 0, 320, 200, 0

	LoadMap "newmaps\level1\0_0.map"
	Link.InCave = 0
	Link.OldX = Link.X: Link.OldY = Link.Y
	Link.X = 160: Link.Y = 160: Link.InDungeon = 1
	Future.Print 17, 8, "LEVEL-1", 17, -1
	UnLoadMidi MidiFile
	MidiFile = LoadMIDI("music\level.mid")
	PlayMidi MidiFile
	'Collision info
	CLOSE
	OPEN "Link003.dat" FOR INPUT AS #1
	DO
	num = num + 1
	INPUT #1, Collide(num)
	LOOP UNTIL EOF(1)
	CollideNum = num
	SetPage 1
	DrawMap
	PutLink
	ViewPage 1

	MainLoop
	EXIT SUB
END IF
'

Future.LoadGIF "Cave.gif", 320, 240
FOR GetLink = 0 TO 128 STEP 16
SVGAGET GetLink, 0, GetLink + 15, 15, VARPTR(LinkSprite(0, TileNum)), VARSEG(LinkSprite(0, TileNum))
TileNum = TileNum + 1
NEXT GetLink

FOR Item = 0 TO 5
	SVGAGET Item * 8, 32, (Item * 8) + 7, 47, VARPTR(Items(0, Item)), VARSEG(Items(0, Item))
NEXT

SVGAGET 0, 48, 7, 63, VARPTR(Coin(0, 0)), VARSEG(Coin(0, 0))
SVGAGET 8, 48, 15, 63, VARPTR(Coin(0, 1)), VARSEG(Coin(0, 1))

TileNum = 8
FOR GetLink = 140 TO 236 STEP 16
SVGAGET GetLink, 0, GetLink + 15, 15, VARPTR(LinkSprite(0, TileNum)), VARSEG(LinkSprite(0, TileNum))
TileNum = TileNum + 1
NEXT GetLink

TileNum = 0
FOR GetSword = 240 TO 288 STEP 12
SVGAGET GetSword, 0, GetSword + 11, 11, VARPTR(LinkSword(0, TileNum)), VARSEG(LinkSword(0, TileNum))
TileNum = TileNum + 1
NEXT GetSword
SVGAGET 64, 16, 79, 31, VARPTR(LinkSword(0, 5)), VARSEG(LinkSword(0, 5))

ChangePal 255, 0, 0, 0
FOR X1 = 0 TO 288
	FOR Y1 = 16 TO 111
		IF Future.POINT(X1, Y1) = 0 THEN Future.Pset X1, Y1, 255
	NEXT
NEXT
FOR X1 = 0 TO 288
	FOR Y1 = 126 TO 288
		IF Future.POINT(X1, Y1) = 0 THEN Future.Pset X1, Y1, 255
	NEXT
NEXT
FOR X1 = 4 * 16 TO 5 * 16 - 1
	FOR Y1 = 16 TO 31
		IF Future.POINT(X1, Y1) = 255 THEN Future.Pset X1, Y1, 0
	NEXT
NEXT

FOR GetLink = 0 TO 11
SVGAGET (GetLink * 16), 16, (GetLink * 16) + 15, 31, VARPTR(Rocks(0, GetLink)), VARSEG(Rocks(0, GetLink))
NEXT GetLink

SVGAGET 24, 150, 31, 157, VARPTR(Hearts(0, 0)), VARSEG(Hearts(0, 0))
SVGAGET 32, 150, 39, 157, VARPTR(Hearts(0, 1)), VARSEG(Hearts(0, 1))
SVGAGET 40, 150, 47, 157, VARPTR(Hearts(0, 2)), VARSEG(Hearts(0, 2))

Future.GET 81, 168, 319, 199, Bar()
SetPage 1
Future.FillBox 0, 0, 320, 200, 0
MapName$ = "newmaps\" + LTRIM$(STR$(XMap)) + "_" + LTRIM$(STR$(YMap)) + ".cav"

ChangePal 253, 255, 255, 255
Link.OldX = Link.X: Link.OldY = Link.Y
Link.X = 160: Link.Y = 160: Link.InCave = 1
LoadMap MapName$

DrawMap

'
FOR MapY = 2 TO 11
	FOR MapX = 2 TO 18
		IF Map(MapX, MapY) = 2 OR Map(MapX, MapY) = 3 OR Map(MapX, MapY) = 10 THEN
			WAIT &H3DA, 8, 8: WAIT &H3DA, 8
			WAIT &H3DA, 8, 8: WAIT &H3DA, 8
			WAIT &H3DA, 8, 8: WAIT &H3DA, 8
			SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, 5)), VARSEG(Rocks(0, 5))
			SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, 8)), VARSEG(Rocks(0, 8))
			WAIT &H3DA, 8, 8: WAIT &H3DA, 8
			WAIT &H3DA, 8, 8: WAIT &H3DA, 8
			WAIT &H3DA, 8, 8: WAIT &H3DA, 8
			SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, 5)), VARSEG(Rocks(0, 5))
			SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, 7)), VARSEG(Rocks(0, 7))
			WAIT &H3DA, 8, 8: WAIT &H3DA, 8
			WAIT &H3DA, 8, 8: WAIT &H3DA, 8
			WAIT &H3DA, 8, 8: WAIT &H3DA, 8
			SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, 5)), VARSEG(Rocks(0, 5))
			SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, Map(MapX, MapY))), VARSEG(Rocks(0, Map(MapX, MapY)))
		END IF
	NEXT MapX
NEXT MapY

'Display options/items (CAVE specific)
IF XMap = -1 AND YMap = -1 THEN
	SVGAPUT 120, 122, VARPTR(Items(0, 0)), VARSEG(Items(0, 0))
	SVGAPUT 152, 122, VARPTR(Items(0, 1)), VARSEG(Items(0, 1))
	SVGAPUT 184, 122, VARPTR(Items(0, 2)), VARSEG(Items(0, 2))
	SVGAPUT 84, 136, VARPTR(Coin(0, 0)), VARSEG(Coin(0, 0))
	Future.Print 96, 140, "X 160 100  60", 253, -1
END IF
IF XMap = -3 AND YMap = -3 THEN
	SVGAPUT 120, 122, VARPTR(Items(0, 0)), VARSEG(Items(0, 0))
	SVGAPUT 152, 122, VARPTR(Items(0, 3)), VARSEG(Items(0, 3))
	SVGAPUT 184, 122, VARPTR(Items(0, 4)), VARSEG(Items(0, 4))
	SVGAPUT 84, 136, VARPTR(Coin(0, 0)), VARSEG(Coin(0, 0))
	Future.Print 96, 140, "X 130  20  80", 253, -1
END IF

'

PutLink
IF XMap = 0 AND YMap = 0 AND Link.Sword THEN CaveLoop: EXIT SUB
C = LEN(CaveText1$)
FOR A = 1 TO C
	B$ = LEFT$(CaveText1$, 1): CaveText1$ = RIGHT$(CaveText1$, LEN(CaveText1$) - 1)
	Future.Print 64 + A * 8, 72, B$, 253, -1
	IF B$ <> " " THEN
		LoadWAV "sound\type.wav"
		Tim! = TIMER
		DO: LOOP UNTIL TIMER >= Tim! + .1
	END IF
NEXT
C = LEN(CaveText2$)
FOR A = 1 TO C
	B$ = LEFT$(CaveText2$, 1): CaveText2$ = RIGHT$(CaveText2$, LEN(CaveText2$) - 1)
	Future.Print 64 + A * 8, 81, B$, 253, -1
	IF B$ <> " " THEN
		LoadWAV "sound\type.wav"
		ClearKeyBuffer
		Tim! = TIMER
		DO: LOOP UNTIL TIMER >= Tim! + .1
	END IF
NEXT
CaveLoop
END SUB

SUB LoadEnemyInfo (File$)
FileName$ = File$
TotalEnemies = 0
CLOSE
OPEN File$ FOR INPUT AS #1
DO UNTIL EOF(1)
	TotalEnemies = TotalEnemies + 1
	INPUT #1, Enemy(TotalEnemies).EnemyType
	SELECT CASE Enemy(TotalEnemies).EnemyType
	CASE 1: Enemy(TotalEnemies).HP = 1    'Red Crawley
	CASE 2: Enemy(TotalEnemies).HP = 2    'Blue Crawley
	CASE 5, 6: Enemy(TotalEnemies).HP = 1 'Red/Blue Spider
	CASE 7, 8: Enemy(TotalEnemies).HP = 3 'Red/Black Zora
	END SELECT
LOOP
CLOSE
'Randomize X & Y of enemies
Enemy(1).X = 96: Enemy(1).Y = 96
Enemy(2).X = 128: Enemy(2).Y = 128
Enemy(3).X = 128: Enemy(3).Y = 160
Enemy(4).X = 96: Enemy(4).Y = 160
Enemy(5).X = 128: Enemy(5).Y = 128
Enemy(6).X = 128: Enemy(6).Y = 128
Enemy(7).X = 128: Enemy(7).Y = 128
Enemy(1).Path = 0: Enemy(2).Path = 0: Enemy(3).Path = 0: Enemy(4).Path = 0
Enemy(5).Path = 0: Enemy(6).Path = 0: Enemy(7).Path = 0

FOR Which = 1 TO TotalEnemies
	Enemy(Which).Times = 0: Enemy(Which).AnimNum = 0
NEXT
END SUB

SUB LoadMap (Map$)
CLOSE
OPEN Map$ FOR INPUT AS #1

FOR X = 2 TO 18
	FOR Y = 2 TO 12
		INPUT #1, C$
		Map(X, Y) = VAL(C$)
	NEXT Y
NEXT X
IF Link.InCave THEN
	LINE INPUT #1, CaveText1$
	LINE INPUT #1, CaveText2$
END IF
CLOSE
END SUB

REM $DYNAMIC
DEFSNG A-Z
'LoadMIDI - loads a MIDI file into memory
FUNCTION LoadMIDI% (FileName$)
LoadMIDI% = -1
'See if an extension was supplied, and if not, add one.
IF INSTR(FileName$, ".") = 0 THEN FileName$ = FileName$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL FileName$: MIDI.ERROR = 1: EXIT FUNCTION
'Make the filename an ASCIIZ string.
FileName$ = FileName$ + CHR$(0)

'Find an empty MIDI handle
NewHandle% = -1
FOR I% = 0 TO 255
	IF MEM.SEGMENT(I%) = 0 THEN NewHandle% = I%: EXIT FOR
NEXT I%
'If there are no empty handles, return an error.
IF NewHandle% = -1 THEN MIDI.ERROR = 12: EXIT FUNCTION
'Attempt to allocate a block of conventional memory.
QMIDIRegs.AX = &H4800
QMIDIRegs.BX = (FileLen& \ 16) + 1
CALL IntX(&H21, QMIDIRegs)
'If the block couldn't be allocated, it means there's not enough free
'memory.  To fix this, we need to ask BASIC to release some of the memory
'it's using:
IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
	'Find out how much memory is available, in kilobytes.
	LargestBlock& = QMIDIRegs.BX
	LargestBlock& = LargestBlock& * 16
	'Calculate the amount of memory that BASIC needs to release for us.
	MEM.ALLOCATED(NewHandle%) = (FileLen& + 2048) - LargestBlock&
	'Attempt to release the memory.
	A& = SETMEM(-MEM.ALLOCATED(NewHandle%))
	'Try again to allocate a block of memory
	QMIDIRegs.AX = &H4800
	QMIDIRegs.BX = (FileLen& \ 16) + 1
	CALL IntX(&H21, QMIDIRegs)
	'If the second attempt was unsuccessful, then there just isn't
	'enough memory, and an error needs to be returned.
	IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
		'Give any memory we took back to BASIC.
		A& = SETMEM(650000)
		'Return an error.
		MIDI.ERROR = 2
		MEM.SEGMENT(NewHandle%) = 0
		'Abort.
		EXIT FUNCTION
	END IF
END IF
'If the memory was allocated successfully, store the segment
'of the memory block.
MEM.SEGMENT(NewHandle%) = QMIDIRegs.AX
MIDISegment& = QMIDIRegs.AX

'Open the MIDI file using a DOS interrupt.
QMIDIRegs.AX = &H3D00
QMIDIRegs.DX = SADD(FileName$)
QMIDIRegs.DS = VARSEG(FileName$)
CALL IntX(&H21, QMIDIRegs)
'Store the file handle.
Handle% = QMIDIRegs.AX
'Read the data from the file in 16 kilobyte increments.
FOR I& = 1 TO FileLen& STEP 16384
	QMIDIRegs.AX = &H3F00
	QMIDIRegs.CX = 16384
	QMIDIRegs.DX = 0
	QMIDIRegs.DS = VAL("&H" + HEX$(MIDISegment&))
	QMIDIRegs.BX = Handle%
	CALL IntX(&H21, QMIDIRegs)
	MIDISegment& = MIDISegment& + 1024
NEXT I&

'Close the file
QMIDIRegs.AX = &H3E00
QMIDIRegs.BX = Handle%
CALL IntX(&H21, QMIDIRegs)

MIDI.ERROR = 0
LoadMIDI% = NewHandle%
END FUNCTION

REM $STATIC
DEFINT A-Z
SUB LoadNextMap
DIM Temp3(1000)
IF Link.InCave THEN
	Link.InCave = 0
	Link.X = Link.OldX: Link.Y = Link.OldY + 2
	CLOSE
	OPEN "LINK001.DAT" FOR INPUT AS #1
	DO
	num = num + 1
	INPUT #1, Collide(num)
	LOOP UNTIL EOF(1)
	CollideNum = num
	FadeOut
	Future.CLS 0
	SetPage 2
	GetTiles
	MapName$ = "newmaps\" + LTRIM$(RTRIM$(STR$(XMap))) + "_" + LTRIM$(RTRIM$(STR$(YMap))) + ".map"
	LoadMap MapName$
	LoadEnemyInfo "ENEMIES\" + LTRIM$(RTRIM$(STR$(XMap))) + "_" + LTRIM$(RTRIM$(STR$(YMap))) + ".dat"
	SetPage 1: ViewPage 1
	DrawMap
	'Link walking UP stairs
	LoadWAV "sound\cave.wav"
	FOR Times = 0 TO 16
		SetPage 2
		Future.CLS 0
		Link.Times = Link.Times + 1
		IF Link.Times >= 3 THEN
			IF Link.AnimNum = 1 THEN Link.AnimNum = 0 ELSE Link.AnimNum = 1
			Link.Times = 0
		END IF
		SVGAPUT 0, 0, VARPTR(LinkSprite(0, Link.Dir + Link.AnimNum)), VARSEG(LinkSprite(0, Link.Dir + Link.AnimNum))
		Future.GET 0, 0, 16, Times, Temp3()
		SetPage 1
		WAIT &H3DA, 8, 8: WAIT &H3DA, 8
		WAIT &H3DA, 8, 8: WAIT &H3DA, 8
		WAIT &H3DA, 8, 8: WAIT &H3DA, 8
		WAIT &H3DA, 8, 8: WAIT &H3DA, 8
		CaveX = INT(Link.X / 16): CaveY = INT(Link.Y / 16)
		DrawMapPiece CaveX, CaveY: DrawMapPiece CaveX, CaveY + 1: DrawMapPiece CaveX, CaveY - 1
		DrawMapPiece CaveX + 1, CaveY: DrawMapPiece CaveX + 1, CaveY + 1: DrawMapPiece CaveX + 1, CaveY - 1
		Future.Put Link.X, Link.Y - Times + 5, Temp3()
	NEXT
	MidiFile = LoadMIDI("music\normal.mid")
	PlayMidi MidiFile
 
ELSE
	SELECT CASE Link.Dir
	CASE 6: YMap = YMap - 1: Link.Y = 200 - Link.Y
	CASE 4: XMap = XMap + 1: Link.X = 320 - Link.X
	CASE 0: YMap = YMap + 1: Link.Y = 208 - Link.Y
	CASE 2: XMap = XMap - 1: Link.X = 288 - Link.X
	END SELECT
	MapName$ = "newmaps\" + LTRIM$(RTRIM$(STR$(XMap))) + "_" + LTRIM$(RTRIM$(STR$(YMap))) + ".map"
	LoadMap MapName$
	LoadEnemyInfo "ENEMIES\" + LTRIM$(RTRIM$(STR$(XMap))) + "_" + LTRIM$(RTRIM$(STR$(YMap))) + ".dat"
	'ScrollToNewMap
	DrawMap
END IF
END SUB

DEFSNG A-Z
SUB LoopMidi
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN PlayMidi CURRENTHANDLE
END SUB

DEFINT A-Z
SUB MainLoop
Link.Sword = 1'
Link.CanThrust = 1
IF Link.InCave = 0 THEN DrawMap
ClearKeyBuffer: A$ = INKEY$
DO: ProcessKeys
CheckHit
IF Sound.DisAbled = 0 AND Link.InCave = 0 THEN LoopMidi

WAIT &H3DA, 8, 8: WAIT &H3DA, 8
IF Link.InCave = 0 THEN
	SetMaskColor -1: Future.EMSPut 32, 32, EMSHandle%: SetMaskColor 0
END IF
IF Link.InCave THEN RemoveLink
IF Link.Thrust = 1 THEN
	IF TIMER >= Link.ThrustTimer + .5 THEN Link.Thrust = 0
	Link.RemoveSword = 1
END IF

IF Link.Thrust = 0 THEN PutLink
IF Link.InCave THEN UpDateCave ELSE DoEnemies: PutEnemies

IF Link.Thrust THEN
	SELECT CASE Link.Dir
	CASE 0: SVGAPUT Link.X, Link.Y, VARPTR(LinkSprite(0, 8)), VARSEG(LinkSprite(0, 8))
		 SVGAPUT Link.X + 2, Link.Y + 16, VARPTR(LinkSword(0, 0)), VARSEG(LinkSword(0, 0))
	CASE 6: SVGAPUT Link.X, Link.Y, VARPTR(LinkSprite(0, 9)), VARSEG(LinkSprite(0, 9))
		 SVGAPUT Link.X, Link.Y - 12, VARPTR(LinkSword(0, 1)), VARSEG(LinkSword(0, 1))
	CASE 4: SVGAPUT Link.X, Link.Y, VARPTR(LinkSprite(0, 11)), VARSEG(LinkSprite(0, 11))
		 SVGAPUT Link.X + 15, Link.Y + 2, VARPTR(LinkSword(0, 3)), VARSEG(LinkSword(0, 3))
	CASE 2: SVGAPUT Link.X, Link.Y, VARPTR(LinkSprite(0, 10)), VARSEG(LinkSprite(0, 10))
		 SVGAPUT Link.X - 12, Link.Y + 2, VARPTR(LinkSword(0, 2)), VARSEG(LinkSword(0, 2))
	END SELECT
END IF

LOOP
END SUB

SUB PaletteGet (nColor)
OUT &H3C6, &HFF: OUT &H3C7, nColor
Pal.Red = INP(&H3C9): Pal.Green = INP(&H3C9): Pal.Blue = INP(&H3C9)
END SUB

SUB PaletteSet (nColor)
OUT &H3C6, &HFF: OUT &H3C8, nColor: OUT &H3C9, Pal.Red
OUT &H3C9, Pal.Green: OUT &H3C9, Pal.Blue
END SUB

REM $DYNAMIC
DEFSNG A-Z
'PlayMidi - Begins playing a MIDI file in the background.
SUB PlayMidi (Handle%)
IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If sound is not disabled....
IF Sound.DisAbled = 0 THEN
	'Call the SBMIDI driver to begin playing the MIDI file.
	QMIDIRegs.BX = 4
	QMIDIRegs.DX = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	QMIDIRegs.BX = 5
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	'If the music could not be started, return an error.
	IF QMIDIRegs.AX <> 0 THEN MIDI.ERROR = 11: EXIT SUB
	'Start the MIDI timer.
	MIDI.PLAYTIME = TIMER
	'Set the current handle.
	CURRENTHANDLE = Handle%
END IF
MIDI.ERROR = 0
END SUB

REM $STATIC
DEFINT A-Z
SUB ProcessKeys
A$ = INKEY$: P = INP(&H60)    'Different than standard key handler
'CTRL = 29, ALT = 56, SPACE=57
SELECT CASE P
CASE 57: InventoryScreen
'S: Screenshot
CASE 31: Future.SnapShot "screen.bmp"
CASE 1: StopMidi: UnLoadMidi MidiFile: FadeOut: StopAndReset: ResetScreen: DeallExpMem EMSHandle%'free up EMS memory
				END                  'Escape
CASE 29: IF LinkThrust = 0 AND Link.CanThrust THEN DoSword    'CTRL
CASE 157: Link.RemoveSword = 1: Link.CanThrust = 1: Link.Thrust = 0
CASE 72:
	IF Link.Thrust = 0 THEN
		Link.Dir = 6: Link.Moving = 1
		IF Collision = 0 THEN
			IF Link.InCave THEN RemoveLink
			Link.Y = Link.Y - 2
			IF Link.InCave THEN PutLink
		END IF
	END IF
CASE 75:
	IF Link.Thrust = 0 THEN
		Link.Dir = 2: Link.Moving = 1
		IF Collision = 0 THEN
			IF Link.InCave THEN RemoveLink
			Link.X = Link.X - 2
			IF Link.InCave THEN PutLink
		END IF
	END IF
CASE 77:
	IF Link.Thrust = 0 THEN
		Link.Dir = 4: Link.Moving = 1
		IF Collision = 0 THEN
			IF Link.InCave THEN RemoveLink
			Link.X = Link.X + 2
			IF Link.InCave THEN PutLink
		END IF
	END IF
CASE 80:
	IF Link.Thrust = 0 THEN
		Link.Dir = 0: Link.Moving = 1
		IF Collision = 0 THEN
			IF Link.InCave THEN RemoveLink
			Link.Y = Link.Y + 2
			IF Link.InCave THEN PutLink
		END IF
	END IF
END SELECT

END SUB

SUB PutEnemies
FOR Which = 1 TO TotalEnemies
IF Enemy(Which).HP > 0 THEN

SELECT CASE Enemy(Which).EnemyType
CASE 1:
X1 = INT(Enemy(Which).X / 16): Y1 = INT(Enemy(Which).Y / 16)

	Enemy(Which).Times = Enemy(Which).Times + 1
	IF Enemy(Which).Times = 5 THEN
		IF Enemy(Which).AnimNum = 1 THEN Enemy(Which).AnimNum = 0 ELSE Enemy(Which).AnimNum = 1
		Enemy(Which).Times = 0
	END IF
	SVGAPUT Enemy(Which).X, Enemy(Which).Y, VARPTR(EnemyGFX(0, Enemy(Which).EDir + Enemy(Which).AnimNum)), VARSEG(EnemyGFX(0, Enemy(Which).EDir + Enemy(Which).AnimNum))
CASE 2:
X1 = INT(Enemy(Which).X / 16): Y1 = INT(Enemy(Which).Y / 16)

	Enemy(Which).Times = Enemy(Which).Times + 1
	IF Enemy(Which).Times = 5 THEN
		IF Enemy(Which).AnimNum = 1 THEN Enemy(Which).AnimNum = 0 ELSE Enemy(Which).AnimNum = 1
		Enemy(Which).Times = 0
	END IF
	SVGAPUT Enemy(Which).X, Enemy(Which).Y, VARPTR(EnemyGFX(0, Enemy(Which).EDir + Enemy(Which).AnimNum + 10)), VARSEG(EnemyGFX(0, Enemy(Which).EDir + Enemy(Which).AnimNum + 10))

CASE 5:
	Enemy(Which).Times = Enemy(Which).Times + 1
	IF Enemy(Which).Times = 15 THEN
		IF Enemy(Which).AnimNum = 1 THEN Enemy(Which).AnimNum = 0 ELSE Enemy(Which).AnimNum = 1
		Enemy(Which).Times = 0
	END IF
	IF Enemy(Which).Jumping THEN
		SVGAPUT Enemy(Which).X, Enemy(Which).Y, VARPTR(EnemyGFX(0, 8)), VARSEG(EnemyGFX(0, 8))
	ELSE
		SVGAPUT Enemy(Which).X, Enemy(Which).Y, VARPTR(EnemyGFX(0, Enemy(Which).AnimNum + 8)), VARSEG(EnemyGFX(0, Enemy(Which).AnimNum + 8))
	END IF
CASE 6:
	Enemy(Which).Times = Enemy(Which).Times + 1
	IF Enemy(Which).Times = 15 THEN
		IF Enemy(Which).AnimNum = 1 THEN Enemy(Which).AnimNum = 0 ELSE Enemy(Which).AnimNum = 1
		Enemy(Which).Times = 0
	END IF
	'IF Enemy(Which).Jumping THEN
		'SVGAPUT Enemy(Which).X, Enemy(Which).Y, VARPTR(EnemyGFX(0, 8)), VARSEG(EnemyGFX(0, 8))
	'ELSE
		SVGAPUT Enemy(Which).X, Enemy(Which).Y, VARPTR(EnemyGFX(0, Enemy(Which).AnimNum + 18)), VARSEG(EnemyGFX(0, Enemy(Which).AnimNum + 18))
	'END IF
CASE 7:
X1 = INT(Enemy(Which).X / 16): Y1 = INT(Enemy(Which).Y / 16)

	Enemy(Which).Times = Enemy(Which).Times + 1
	IF Enemy(Which).Times = 5 THEN
		IF Enemy(Which).AnimNum = 1 THEN Enemy(Which).AnimNum = 0 ELSE Enemy(Which).AnimNum = 1
		Enemy(Which).Times = 0
	END IF
	SVGAPUT Enemy(Which).X, Enemy(Which).Y, VARPTR(EnemyGFX(0, Enemy(Which).EDir + Enemy(Which).AnimNum + 20)), VARSEG(EnemyGFX(0, 20 + Enemy(Which).EDir + Enemy(Which).AnimNum))
CASE 8:
X1 = INT(Enemy(Which).X / 16): Y1 = INT(Enemy(Which).Y / 16)

	Enemy(Which).Times = Enemy(Which).Times + 1
	IF Enemy(Which).Times = 5 THEN
		IF Enemy(Which).AnimNum = 1 THEN Enemy(Which).AnimNum = 0 ELSE Enemy(Which).AnimNum = 1
		Enemy(Which).Times = 0
	END IF
	SVGAPUT Enemy(Which).X, Enemy(Which).Y, VARPTR(EnemyGFX(0, Enemy(Which).EDir + Enemy(Which).AnimNum + 28)), VARSEG(EnemyGFX(0, Enemy(Which).EDir + Enemy(Which).AnimNum + 28))
 
END SELECT
ELSE
'When enemy has died
IF Enemy(Which).Remove THEN
	Enemy(Which).Remove = Enemy(Which).Remove - 1
	SVGAPUT Enemy(Which).X, Enemy(Which).Y, VARPTR(EnemyRemove(0, Enemy(Which).Remove / 2)), VARSEG(EnemyRemove(0, Enemy(Which).Remove / 2))
	'DO: LOOP UNTIL INKEY$ <> ""
END IF
END IF
NEXT
END SUB

SUB PutLink
IF Link.Moving THEN
	Link.Times = Link.Times + 1
	IF Link.Times >= 5 THEN
		IF Link.AnimNum = 1 THEN Link.AnimNum = 0 ELSE Link.AnimNum = 1
		Link.Times = 0
	END IF
	Link.Moving = 0
END IF
SVGAPUT Link.X, Link.Y, VARPTR(LinkSprite(0, Link.Dir + Link.AnimNum)), VARSEG(LinkSprite(0, Link.Dir + Link.AnimNum))
END SUB

SUB RemoveLink
IF Link.RemoveSword AND Link.InCave THEN
	Link.RemoveSword = 0
	Future.Put Link.SwordX, Link.SwordY, SwordTemp()
END IF

	X1 = INT(Link.X / 16): Y1 = INT(Link.Y / 16)
	DrawMapPiece X1, Y1
	DrawMapPiece X1 + 1, Y1
	DrawMapPiece X1 + 1, Y1 + 1
	DrawMapPiece X1, Y1 + 1
	DrawMapPiece X1 - 1, Y1
	DrawMapPiece X1 - 1, Y1 + 1
	DrawMapPiece X1 - 1, Y1 - 1
	DrawMapPiece X1 + 1, Y1 - 1
	DrawMapPiece X1, Y1 - 1
	DrawMapPiece X1 + 2, Y1
	DrawMapPiece X1 + 2, Y1 + 1
END SUB

SUB ScrollToNewMap
SetPage 2
Future.CLS 0
FOR MapX = 2 TO 17
	FOR MapY = 11 TO 2 STEP -1
		DrawMapPiece MapX, MapY
	NEXT MapY
NEXT MapX


'Pagina 2 heeft het nieuwe level op het scherm
'De speler krijgt pagina 1 te zien
DIM Temp(10000), Temp2(1000)
SetPage 1
ViewPage 1
SELECT CASE Link.Dir
CASE 6:   'Omhoog
		FOR Y1 = 1 TO 160
			Future.GET 32, 33, 288, 191, Temp()
			SetPage 2
			Future.GET 32, 191 - Y1, 288, 192 - Y1, Temp2()
			SetPage 1
			Future.Put 32, 34, Temp()
			Future.Put 32, 32, Temp2()
		NEXT
CASE 4:   'rechts
		Future.GET 33, 32, 288, 192, Temp()
		SetPage 2
		Future.GET X1 + 32, 32, X1 + 33, 192, Temp2()
		SetPage 1
		Future.Put 32, 32, Temp()
		Future.Put 287, 32, Temp2()

	FOR X1 = 1 TO 256
		Future.GET 33, 32, 288, 192, Temp()
		SetPage 2
		Future.GET X1 + 32, 32, X1 + 33, 192, Temp2()
		SetPage 1
		Future.Put 32, 32, Temp()
		Future.Put 288, 32, Temp2()
	NEXT
CASE ELSE:
SetPage 1
ViewPage 1
DrawMap
END SELECT
SetPage 1
END SUB

SUB Status
'Display status of Link (hitpoints)
FOR A = 1 TO Link.MaxHP
	IF Link.HP >= A THEN
		SVGAPUT 184 + A * 8, 24, VARPTR(Hearts(0, 0)), VARSEG(Hearts(0, 0))
	ELSE
		SVGAPUT 184 + A * 8, 24, VARPTR(Hearts(0, 2)), VARSEG(Hearts(0, 2))
	END IF
	B = B + 1
NEXT
A$ = RIGHT$(STR$(Link.HP), 2)
IF A$ = ".5" THEN SVGAPUT 184 + (INT(Link.HP + 1)) * 8, 24, VARPTR(Hearts(0, 1)), VARSEG(Hearts(0, 1))
END SUB

REM $DYNAMIC
DEFSNG A-Z
'StopMIDI - Stops playing MIDI file
SUB StopMidi
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Call the SBMIDI driver to stop the music.
IF MIDI.PLAYTIME THEN
	QMIDIRegs.BX = 4
	QMIDIRegs.DX = MEM.SEGMENT(CURRENTHANDLE)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	MIDI.ERROR = 0
ELSE
	MIDI.ERROR = 3
END IF
MIDI.PLAYTIME = 0
END SUB

REM $STATIC
SUB UnLoadMidi (Handle%)
IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
'If a block of memory was allocated to hold the MIDI file....
IF MEM.SEGMENT(Handle%) THEN
	'Release the block of memory.
	QMIDIRegs.ES = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = &H4900
	CALL IntX(&H21, QMIDIRegs)
	'Give back all the memory we took from BASIC.
	A& = SETMEM(650000)
END IF
MEM.SEGMENT(Handle%) = 0
MEM.ALLOCATED(Handle%) = 0
MIDI.ERROR = 0
END SUB

DEFINT A-Z
SUB UpDateCave
CaveTimes = CaveTimes + 1
IF CaveTimes = 5 THEN
'Fire
FOR MapY = 2 TO 11
	FOR MapX = 2 TO 18
		CaveTimes = 0
		IF Map(MapX, MapY) = 2 THEN
			SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, 5)), VARSEG(Rocks(0, 5))
			SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, 6)), VARSEG(Rocks(0, 6))
			Map(MapX, MapY) = 6
		ELSE
			IF Map(MapX, MapY) = 6 THEN
				SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, 5)), VARSEG(Rocks(0, 5))
				SVGAPUT MapX * 16, MapY * 16, VARPTR(Rocks(0, 2)), VARSEG(Rocks(0, 2))
				Map(MapX, MapY) = 2
			END IF
		END IF
	NEXT MapX
NEXT MapY
'Coins
IF XMap = -1 AND YMap = -1 THEN
	IF CoinTimes = 1 THEN CoinTimes = 0 ELSE CoinTimes = 1
	SVGAPUT 84, 136, VARPTR(Coin(0, CoinTimes)), VARSEG(Coin(0, CoinTimes))
END IF
IF XMap = -3 AND YMap = -3 THEN
	IF CoinTimes = 1 THEN CoinTimes = 0 ELSE CoinTimes = 1
	SVGAPUT 84, 136, VARPTR(Coin(0, CoinTimes)), VARSEG(Coin(0, CoinTimes))
END IF

END IF
IF XMap = -1 AND YMap = -1 THEN
	SVGAPUT 120, 122, VARPTR(Items(0, 0)), VARSEG(Items(0, 0))
	SVGAPUT 152, 122, VARPTR(Items(0, 1)), VARSEG(Items(0, 1))
	SVGAPUT 184, 122, VARPTR(Items(0, 2)), VARSEG(Items(0, 2))
	'SVGAPUT 84, 136, VARPTR(Coin(0, 0)), VARSEG(Coin(0, 0))
	Future.Print 96, 140, "X 160 100  60", 253, -1
END IF
IF XMap = -3 AND YMap = -3 THEN
	SVGAPUT 120, 122, VARPTR(Items(0, 0)), VARSEG(Items(0, 0))
	SVGAPUT 152, 122, VARPTR(Items(0, 3)), VARSEG(Items(0, 3))
	SVGAPUT 184, 122, VARPTR(Items(0, 4)), VARSEG(Items(0, 4))
	'SVGAPUT 84, 136, VARPTR(Coin(0, 0)), VARSEG(Coin(0, 0))
	Future.Print 96, 140, "X 130  20  80", 253, -1
END IF

END SUB

