'SETUP
'This is my setup program
'I'm not using the SETUP proggy that comes with BWSB
'cause I wanted to make my own
DEFINT A-Z
DECLARE FUNCTION OverLoad% (FileName$, FileHandle%)
DECLARE SUB Delay (seconds!)
DECLARE SUB LoadNewMusicAndPlayIt (ModFile$)
DECLARE SUB Bevel (x1%, y1%, x2%, y2%, SetType%, BevelSize%, BgColour%)
DECLARE SUB DisplayLED (ledx%, ledy%, number%)
DECLARE SUB SetupScreen ()
DECLARE SUB checkvu ()
DECLARE SUB checkprogression ()
DECLARE SUB NewSettings ()
DECLARE SUB ShowSettings ()
DECLARE SUB FadeVolumeOut ()
DECLARE SUB killpal ()
DECLARE SUB BuildLEDs ()

'$INCLUDE: 'BWSB.BI'
'$INCLUDE: 'GDMTYPE.BI'
'$INCLUDE: 'chantype.bi'

COMMON SHARED OverRate&, MusicChannels, offset, vuoffset, boffset, boffset2

TYPE MSEConfigFile
  SoundCard     AS INTEGER
  BaseIO        AS INTEGER
  IRQ           AS INTEGER
  DMA           AS INTEGER
  SoundQuality  AS INTEGER
END TYPE

TYPE OVRLOAD
  FileName      AS STRING * 12
  Location      AS LONG
  Length        AS LONG
END TYPE

TYPE OVREND
  ID            AS STRING * 10
  Entries       AS STRING * 1
  Location      AS LONG
END TYPE

DIM SHARED ModHead         AS GDMHeader       'Module Header
DIM SHARED SndDevMSE(6)    AS STRING          'Array of MSE file names
DIM SHARED MSEConfig       AS MSEConfigFile   'Structure of MSE configuration file
DIM SHARED pal(768), digits(1000), VUMeter(1400), currentvu(32), buttons(132), buttons2(172)

Freemem& = FRE(-1) - 80000             'Basic Heap - EXE Memory (80000)
A& = SETMEM(-Freemem&)                 'This is the memory freed for module
                                       'and MSE usage.
PRINT "Far Heap memory available"

'Table of MSE file names
SndDevMSE(1) = "DRIVERS\GUS"                   'Gravis Ultrasound
SndDevMSE(2) = "DRIVERS\SB1X"                  'Sound Blaster 1.xx
SndDevMSE(3) = "DRIVERS\SB2X"                  'Sound Blaster 2.xx
SndDevMSE(4) = "DRIVERS\SBPRO"                 'Sound Blaster Pro
SndDevMSE(5) = "DRIVERS\SB16"                  'Sound Blaster 16
SndDevMSE(6) = "DRIVERS\PAS"                   'Pro AudioSpectrum 16

offset = 60
vuoffset = 20
boffset = 66
RESTORE
FOR A = 0 TO 131
READ buttons(A)
NEXT A

OPEN "MSE.CFG" FOR BINARY AS 1
IF LOF(1) = 0 THEN
        CLOSE 1
        KILL "MSE.CFG"
        FileHandle = FREEFILE
        OPEN "MSE.CFG" FOR BINARY AS FileHandle
        PUT FileHandle, 1, MSEConfig
        CLOSE FileHandle
        OPEN "MSE.CFG" FOR BINARY AS 1
END IF
GET 1, , MSEConfig
CLOSE 1

arg69:
CLS
PRINT "THE WRATH OF SONA CONFIGURATION PROGRAM"
PRINT "(1) SELECT SOUNDCARD"
PRINT "(2) SET SOUNDCARD SETTINGS"
PRINT "(3) SELECT SOUND QUALITY"
PRINT "(4) TEST SOUNDCARD"
PRINT "(5) EXIT AND SAVE"
PRINT
PRINT "Enter your choice"
arg1:
DO
A$ = INKEY$
LOOP WHILE A$ = ""
IF A$ = CHR$(27) THEN CLS : PRINT "Program aborted.": END
A = VAL(A$)
ON A GOTO selectsoundcard, setsoundcardsettings, selectsoundquality, testsoundcard, exitandsave

selectsoundcard:
CLS
PRINT "SELECT SOUND CARD"
PRINT "Currently selected sound card - ";
SELECT CASE MSEConfig.SoundCard
        CASE 0
                PRINT "None"
        CASE 1
                PRINT "Gravis UltraSound"
        CASE 2
                PRINT "SoundBlaster 1X"
        CASE 3
                PRINT "SoundBlaster 2X"
        CASE 4
                PRINT "SoundBlaster Pro"
        CASE 5
                PRINT "SoundBlaster 16"
        CASE 6
                PRINT "Pro Audio Spectrum"
END SELECT
PRINT "(0) No soundcard or silence"
PRINT "(1) Gravis UltraSound"
PRINT "(2) SoundBlaster 1X"
PRINT "(3) SoundBlaster 2X"
PRINT "(4) SoundBlaster Pro"
PRINT "(5) SoundBlaster 16"
PRINT "(6) Pro Audio Spectrum"
PRINT
PRINT "Enter your choice or press ESC to exit."
arg454:
A$ = INKEY$: IF A$ = "" THEN GOTO arg454
IF A$ = CHR$(27) THEN GOTO arg69
A = VAL(A$): IF A > 6 THEN GOTO arg454
MSEConfig.SoundCard = A
GOTO arg69

setsoundcardsettings:
'MSEConfig.BaseIO = &HFFFF
'MSEConfig.IRQ = &HFF
'MSEConfig.DMA = &HFF
ddd:
CLS
PRINT "SOUNDCARD SETTINGS"
PRINT "(1) Current Base IO - "; HEX$(MSEConfig.BaseIO)
PRINT "(2) Current IRQ -"; MSEConfig.IRQ
PRINT "(3) Current DMA -"; MSEConfig.DMA
PRINT
PRINT "Enter your choice or ESC to exit."
arg54:
A$ = INKEY$: IF A$ = "" THEN GOTO arg54
IF A$ = CHR$(27) THEN GOTO arg69
A = VAL(A$): IF A > 3 OR A < 1 THEN GOTO ddd
ON A GOTO baseiosettings, irqsettings, dmasettings

baseiosettings:
CLS
PRINT "BASE IO SETTINGS"
PRINT "Current Base IO - "; HEX$(MSEConfig.BaseIO)
PRINT "Enter new setting or ESC to exit."
PRINT "(0) Autodetect"
PRINT "(1) 210h"
PRINT "(2) 220h"
PRINT "(3) 230h"
PRINT "(4) 240h"
PRINT "(5) 250h"
PRINT "(6) 260h"
PRINT "(7) 270h"
PRINT "(8) 280h"
arg31:
A$ = INKEY$: IF A$ = "" THEN GOTO arg31
IF A$ = CHR$(27) THEN GOTO ddd
A = VAL(A$): IF A > 8 THEN GOTO arg31
SELECT CASE A
        CASE 0
                MSEConfig.BaseIO = &HFFFF
        CASE ELSE
                MSEConfig.BaseIO = &H200 + A * &H10
END SELECT
GOTO ddd

irqsettings:
CLS
PRINT "IRQ SETTINGS"
PRINT "Current IRQ setting -"; MSEConfig.IRQ
PRINT "Enter new setting or ESC to exit."
PRINT "(0) Autodetect"
PRINT "(1) IRQ 2"
PRINT "(2) IRQ 5"
PRINT "(3) IRQ 7"
PRINT "(4) IRQ 10"
PRINT "(5) IRQ 11"
PRINT "(6) IRQ 12"
PRINT "(7) IRQ 15"
arg14:
A$ = INKEY$: IF A$ = "" THEN GOTO arg14
IF A$ = CHR$(27) THEN GOTO ddd
A = VAL(A$): IF A > 7 OR A < 0 THEN GOTO arg14
SELECT CASE A
    CASE 0: MSEConfig.IRQ = &HFF
    CASE 1: MSEConfig.IRQ = 2
    CASE 2: MSEConfig.IRQ = 5
    CASE 3: MSEConfig.IRQ = 7
    CASE 4: MSEConfig.IRQ = 10
    CASE 5: MSEConfig.IRQ = 11
    CASE 6: MSEConfig.IRQ = 12
    CASE 7: MSEConfig.IRQ = 15
    END SELECT
GOTO ddd

dmasettings:
CLS
PRINT "DMA SETTINGS"
PRINT "Current DMA setting -"; MSEConfig.DMA
PRINT "Enter new setting or ESC to exit."
PRINT "(0) Autodetect"
PRINT "(1) DMA 0"
PRINT "(2) DMA 1"
PRINT "(3) DMA 3"
PRINT "(4) DMA 5"
PRINT "(5) DMA 6"
PRINT "(6) DMA 7"
arg83:
A$ = INKEY$: IF A$ = "" THEN GOTO arg83
IF A$ = CHR$(27) THEN GOTO ddd
A = VAL(A$): IF A > 6 THEN GOTO arg83
SELECT CASE A
    CASE 0: MSEConfig.DMA = &HFF
    CASE 1: MSEConfig.DMA = 0
    CASE 2: MSEConfig.DMA = 1
    CASE 3: MSEConfig.DMA = 3
    CASE 4: MSEConfig.DMA = 5
    CASE 5: MSEConfig.DMA = 6
    CASE 6: MSEConfig.DMA = 7
    END SELECT
GOTO ddd

selectsoundquality:
CLS
PRINT "SELECT SOUND QUALITY"
PRINT "Current sound quality is ";
SELECT CASE MSEConfig.SoundQuality
        CASE 0
                PRINT "Medium"
        CASE 1
                PRINT "High"
        CASE 2
                PRINT "Super-high"
        CASE 3
                PRINT "Low"
END SELECT
PRINT "Enter setting or ESC to exit."
PRINT "(0) Medium quality"
PRINT "(1) High quality"
PRINT "(2) Super-high quality"
PRINT "(3) Low quality"
arg98:
A$ = INKEY$: IF A$ = "" THEN GOTO arg98
IF A$ = CHR$(27) THEN GOTO arg69
A = VAL(A$): IF A > 3 THEN GOTO arg98
MSEConfig.SoundQuality = A
GOTO arg69
'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
'the next segment here is a derivative of KPLAY 2.0
'/////////////////////////////////////////////////////////////////////////////
testsoundcard:
ModFile$ = "MUSIC\WOS-TEST.GDM"
CLS
IF MSEConfig.SoundCard = 0 THEN
        PRINT "No soundcard specified."
        SLEEP 1
        GOTO arg69
END IF

MSE$ = SndDevMSE(MSEConfig.SoundCard) + ".MSE"

SELECT CASE MSEConfig.SoundQuality
CASE 0: Ov = 16
CASE 1: Ov = 22
CASE 2: Ov = 45
CASE 3: Ov = 8
END SELECT

ErrorFlag = LoadMSE(MSE$, 0, Ov, 4096, MSEConfig.BaseIO, MSEConfig.IRQ, MSEConfig.DMA)

SELECT CASE ErrorFlag
CASE 0
CASE 1: PRINT "Base I/O address autodetection failure": END
CASE 2: PRINT "IRQ level autodetection failure": END
CASE 3: PRINT "DMA channel autodetection failure": END
CASE 4: PRINT "DMA channel not supported": END
CASE 6: PRINT "Sound device does not respond": END
CASE 7: PRINT "Memory control blocks destroyed": END
CASE 8: PRINT "Insufficient memory for mixing buffers": END
CASE 9: PRINT "Insufficient memory for MSE file": END
CASE 10: PRINT "MSE has invalid identification string (corrupt/non-existant)": END
CASE 11: PRINT "MSE disk read failure": END
CASE 12: PRINT "MVSOUND.SYS not loaded (required for PAS use)": END
CASE ELSE: PRINT "Unknown error on MSE startup" + STR$(ErrorFlag): END
END SELECT

SCREEN 13
BuildLEDs
SetupScreen
ShowSettings
PALETTE

COLOR 15
LOCATE 19, 2
PRINT "Loading "; ModFile$

LoadNewMusicAndPlayIt ModFile$
NewSettings
LOCATE 19, 2
PRINT ModHead.SongTitle
arg:
checkprogression
checkvu
A$ = INKEY$: IF A$ = "" THEN GOTO arg
IF A$ = CHR$(27) THEN GOTO endprogram
GOTO arg

endprogram:
FadeVolumeOut
StopMusic
StopOutput
UnloadModule
FreeMSE
CLOSE
SCREEN 0: WIDTH 80
GOTO arg69

exitandsave:
FileHandle = FREEFILE
OPEN "MSE.CFG" FOR BINARY AS FileHandle
PUT FileHandle, 1, MSEConfig
CLOSE FileHandle
CLS
PRINT "New configuration saved."
PRINT
PRINT "Type WRATH to begin the game!"
END

DATA 128,8,5909,6681,5912,5911,6167,5911,6169,5640,6408,1818,6683,6425,7195,6663,6683,6682,6423,6168
DATA 6682,5911,7431,6940,6682,6663,6680,2072,6167,6167,1799,6426,6425,5913,6680,5912,5896,6680,6427,5911
DATA 6424,2073,6168,6169,6423,6425,5913,6168,6424,6170,5653,2072,6408,6168,5655,6424,6682,6427,4881,5141
DATA 5652,5397,5142,5652,6167,5912,128,8,-30840,6047,-30816,-30841,-24441,-30841,-24417,-30584,-24696,6167,5912,-24673
DATA 6424,5912,5912,5911,-24697,-24416,5911,-30841,6680,6169,5911,5912,6048,-30560,-24441,-24441,6168,-24809,-24673,-30817
DATA 6048,-30816,-30840,6048,-24808,-30841,-24672,-30561,-24416,-24417,-24697,-24673,-30817,-24416,-24672,-24553,-30584,-30560,-24696,-24416
DATA -30585,-24672,5911,-24808,-12105,-12408,-30513,-30584,-12408,-30513,-24441,-30816

SUB Bevel (x1, y1, x2, y2, SetType, BevelSize, BgColour)
' This is the only important sub here. You would normally start ripping my
' code by selecting SUB bevel, and everything below, then pasting it into
' your program where you won't use it or give me credit anyway, and somehow
' manage to change the variable names and modify the code so you don't look
' so pathetic as to steal something so simple like this and make your
' programming skills look pathetic.
'
' Oh, I'm sorry was I rambling again?

' Parameters / Description
' 
'        x1 - This is your upper left corner column number. (pixels)
'        y1 - You upper left corner row number. (pixels)
'        x2 - The lower right corner column number. (pixels)
'        y2 - The lower right corner row number. (pixels)
'   SetType - The type of bevel. 1 = Outset, 2 = Inset.
' BevelSize - The size of your bevel (play around with this number).
'  BgColour - Set to -1 for default, or tell it your own colour.

SELECT CASE SetType
 CASE 1
  LINE (x1, y1)-(x2, y1), 29
  LINE (x1, y1)-(x1, y2), 29
  LINE (x2, y1)-(x2, y2), 25
  LINE (x1, y2)-(x2, y2), 25
 CASE 2
  LINE (x1, y1)-(x2, y1), 25
  LINE (x1, y1)-(x1, y2), 25
  LINE (x2, y1)-(x2, y2), 29
  LINE (x1, y2)-(x2, y2), 29
END SELECT

IF BevelSize <> 0 THEN CALL Bevel(x1 + 1, y1 + 1, x2 - 1, y2 - 1, SetType, BevelSize - 1, BgColour)
IF BevelSize = 0 THEN IF BgColour = -1 THEN LINE (x1 + 1, y1 + 1)-(x2 - 1, y2 - 1), 27, BF ELSE LINE (x1 + 1, y1 + 1)-(x2 - 1, y2 - 1), BgColour, BF

END SUB

SUB BuildLEDs
killpal
DIM redside(10), redup(10), grayside(10), grayup(10)
LINE (0, 0)-(0, 4), 4: GET (0, 0)-(0, 4), redside
LINE (0, 0)-(0, 4), 17: GET (0, 0)-(0, 4), grayside
LINE (0, 0)-(4, 0), 4: GET (0, 0)-(4, 0), redup
LINE (0, 0)-(4, 0), 17: GET (0, 0)-(4, 0), grayup
CLS
'zero
PUT (0, 1), redside, PSET'lefttopside
PUT (0, 7), redside, PSET'leftbottomside
PUT (6, 1), redside, PSET'righttopside
PUT (6, 7), redside, PSET'rightbottomside
PUT (1, 0), redup, PSET'topside
PUT (1, 12), redup, PSET'bottomside
PUT (1, 6), grayup, PSET'middle
GET (0, 0)-(6, 12), digits
'one
PUT (0, 1), grayside, PSET'lefttopside
PUT (0, 7), grayside, PSET'leftbottomside
PUT (6, 1), redside, PSET'righttopside
PUT (6, 7), redside, PSET'rightbottomside
PUT (1, 0), grayup, PSET'topside
PUT (1, 12), grayup, PSET'bottomside
PUT (1, 6), grayup, PSET'middle
GET (0, 0)-(6, 12), digits(1 * offset)
'two
PUT (0, 1), grayside, PSET'lefttopside
PUT (0, 7), redside, PSET'leftbottomside
PUT (6, 1), redside, PSET'righttopside
PUT (6, 7), grayside, PSET'rightbottomside
PUT (1, 0), redup, PSET'topside
PUT (1, 12), redup, PSET'bottomside
PUT (1, 6), redup, PSET'middle
GET (0, 0)-(6, 12), digits(2 * offset)
'three
PUT (0, 1), grayside, PSET'lefttopside
PUT (0, 7), grayside, PSET'leftbottomside
PUT (6, 1), redside, PSET'righttopside
PUT (6, 7), redside, PSET'rightbottomside
PUT (1, 0), redup, PSET'topside
PUT (1, 12), redup, PSET'bottomside
PUT (1, 6), redup, PSET'middle
GET (0, 0)-(6, 12), digits(3 * offset)
'four
PUT (0, 1), redside, PSET'lefttopside
PUT (0, 7), grayside, PSET'leftbottomside
PUT (6, 1), redside, PSET'righttopside
PUT (6, 7), redside, PSET'rightbottomside
PUT (1, 0), grayup, PSET'topside
PUT (1, 12), grayup, PSET'bottomside
PUT (1, 6), redup, PSET'middle
GET (0, 0)-(6, 12), digits(4 * offset)
'five
PUT (0, 1), redside, PSET'lefttopside
PUT (0, 7), grayside, PSET'leftbottomside
PUT (6, 1), grayside, PSET'righttopside
PUT (6, 7), redside, PSET'rightbottomside
PUT (1, 0), redup, PSET'topside
PUT (1, 12), redup, PSET'bottomside
PUT (1, 6), redup, PSET'middle
GET (0, 0)-(6, 12), digits(5 * offset)
'six
PUT (0, 1), redside, PSET'lefttopside
PUT (0, 7), redside, PSET'leftbottomside
PUT (6, 1), grayside, PSET'righttopside
PUT (6, 7), redside, PSET'rightbottomside
PUT (1, 0), redup, PSET'topside
PUT (1, 12), redup, PSET'bottomside
PUT (1, 6), redup, PSET'middle
GET (0, 0)-(6, 12), digits(6 * offset)
'seven
PUT (0, 1), grayside, PSET'lefttopside
PUT (0, 7), grayside, PSET'leftbottomside
PUT (6, 1), redside, PSET'righttopside
PUT (6, 7), redside, PSET'rightbottomside
PUT (1, 0), redup, PSET'topside
PUT (1, 12), grayup, PSET'bottomside
PUT (1, 6), grayup, PSET'middle
GET (0, 0)-(6, 12), digits(7 * offset)
'eight
PUT (0, 1), redside, PSET'lefttopside
PUT (0, 7), redside, PSET'leftbottomside
PUT (6, 1), redside, PSET'righttopside
PUT (6, 7), redside, PSET'rightbottomside
PUT (1, 0), redup, PSET'topside
PUT (1, 12), redup, PSET'bottomside
PUT (1, 6), redup, PSET'middle
GET (0, 0)-(6, 12), digits(8 * offset)
'nine
PUT (0, 1), redside, PSET'lefttopside
PUT (0, 7), grayside, PSET'leftbottomside
PUT (6, 1), redside, PSET'righttopside
PUT (6, 7), redside, PSET'rightbottomside
PUT (1, 0), redup, PSET'topside
PUT (1, 12), redup, PSET'bottomside
PUT (1, 6), redup, PSET'middle
GET (0, 0)-(6, 12), digits(9 * offset)
CLS
FOR gg = 0 TO 32
IF gg = 0 THEN GOTO argit
LINE (0, 32)-(0, (32 - gg)), 4
argit:
GET (0, 0)-(0, 32), VUMeter(vuoffset * gg)
NEXT
END SUB

SUB checkprogression
parameter$ = STR$(MusicOrder(&HFF))
parameter$ = LTRIM$(RTRIM$(parameter$))
IF LEN(parameter$) = 1 THEN parameter$ = "00" + parameter$
IF LEN(parameter$) = 2 THEN parameter$ = "0" + parameter$
DisplayLED 206, 37, VAL(LEFT$(parameter$, 1))
DisplayLED 214, 37, VAL(MID$(parameter$, 2, 1))
DisplayLED 222, 37, VAL(RIGHT$(parameter$, 1))
'PRINT "Pattern:"; MusicPattern(&HFF)
parameter$ = STR$(MusicPattern(&HFF))
parameter$ = LTRIM$(RTRIM$(parameter$))
IF LEN(parameter$) = 1 THEN parameter$ = "0" + parameter$
DisplayLED 214, 53, VAL(LEFT$(parameter$, 1))
DisplayLED 222, 53, VAL(RIGHT$(parameter$, 1))
'PRINT "Row:"; MusicRow; "           "
parameter$ = STR$(MusicRow)
parameter$ = LTRIM$(RTRIM$(parameter$))
IF LEN(parameter$) = 1 THEN parameter$ = "0" + parameter$
DisplayLED 214, 69, VAL(LEFT$(parameter$, 1))
DisplayLED 222, 69, VAL(RIGHT$(parameter$, 1))

END SUB

SUB checkvu
FOR bb = 1 TO MusicChannels
'VU =  \ 2
PUT (7 + bb, 159), VUMeter(vuoffset * ChannelVU(bb, ChannelVU(bb, &HFF) - 1)), PSET
NEXT bb

END SUB

SUB Delay (seconds!)
   DEF SEG = 0
   d& = FIX(seconds! * 18.20444444#)
   FOR T& = 0 TO d&
     d% = PEEK(&H46C) AND 255
     DO WHILE d% = (PEEK(&H46C) AND 255)
     LOOP
   NEXT T&

END SUB

SUB DisplayLED (ledx, ledy, number)
PUT (ledx, ledy), digits(offset * number), PSET
END SUB

SUB FadeVolumeOut
aaa = MusicVolume(&HFF)
FOR bbb = aaa TO 0 STEP -2
ccc = MusicVolume(bbb)
Delay .01
NEXT

END SUB

SUB killpal
 
  DEF SEG = &HA000
  OUT &H3C7, 0: OUT &H3C8, 0
    FOR i = 1 TO 768
      OUT &H3C9, 0
    NEXT i
  DEF SEG
 
END SUB

SUB LoadNewMusicAndPlayIt (ModFile$)
TestMOD:
IF LEN(ModFile$) = 0 THEN END
IF INSTR(ModFile$, ".") = 0 THEN ModFile$ = ModFile$ + ".GDM"

IF EmsExist THEN ErrorFlag = 1 ELSE ErrorFlag = 0
'overloading a MODule
'File = FREEFILE
'OPEN "SETUP.EXE" FOR BINARY AS File
'A = OverLoad("WOS-TEST.GDM", File)
''Load our module
'LoadGDM FILEATTR(File, 2), SEEK(File) - 1, ErFl, VARSEG(ModHead), VARPTR(ModHead)
'CLOSE File

file = FREEFILE
OPEN ModFile$ FOR BINARY AS file
LoadGDM FILEATTR(file, 2), 0, ErrorFlag, VARSEG(ModHead), VARPTR(ModHead)
CLOSE file
SELECT CASE ErFl
CASE 0
CASE 1: PRINT "Module is corrupt": END
CASE 2: PRINT "Could not autodetect module type": END
CASE 3: PRINT "Bad format ID": END
CASE 4: PRINT "Out of memory": END
CASE 5: PRINT "Cannot unpack samples": END
CASE 6: PRINT "AdLib samples not supported": END
CASE ELSE: PRINT "Unknown Load Error:" + STR$(ErrorFlag): END
END SELECT

MusicChannels = 0
FOR J = 1 TO 32
  IF ASC(MID$(ModHead.PanMap, J, 1)) <> &HFF THEN
    MusicChannels = MusicChannels + 1
  END IF
NEXT

PRINT
'PRINT "Channels:"; MusicChannels; " Song: "; ModHead.SongTitle
OverRate& = StartOutput(MusicChannels, 0)
StartMusic

END SUB

SUB NewPal
  DEF SEG = &HA000
  OUT &H3C7, 0: OUT &H3C8, 0
    FOR i = 1 TO 768
      OUT &H3C9, pal(i)
    NEXT i
  DEF SEG

END SUB

SUB NewSettings
'      [QB/PDS] DECLARE SUB GetMainScope (Left%, Right%)
'      [QB/PDS] DECLARE FUNCTION MusicStatus% ()
'      [QB/PDS] DECLARE FUNCTION MusicTempo% (NewTempo%)
parameter$ = STR$(MusicVolume(&HFF))
parameter$ = LTRIM$(RTRIM$(parameter$))
IF LEN(parameter$) = 1 THEN parameter$ = "0" + parameter$
DisplayLED 215, 101, VAL(LEFT$(parameter$, 1))
DisplayLED 223, 101, VAL(RIGHT$(parameter$, 1))
parameter$ = STR$(MusicChannels)
parameter$ = LTRIM$(RTRIM$(parameter$))
IF LEN(parameter$) = 1 THEN parameter$ = "0" + parameter$
DisplayLED 215, 85, VAL(LEFT$(parameter$, 1))
DisplayLED 223, 85, VAL(RIGHT$(parameter$, 1))
parameter$ = STR$(OverRate&)
parameter$ = LTRIM$(RTRIM$(parameter$))
IF LEN(parameter$) = 4 THEN parameter$ = "0" + parameter$
DisplayLED 270, 178, VAL(LEFT$(parameter$, 1))
DisplayLED 278, 178, VAL(MID$(parameter$, 2, 1))
DisplayLED 286, 178, VAL(MID$(parameter$, 3, 1))
DisplayLED 294, 178, VAL(MID$(parameter$, 4, 1))
DisplayLED 302, 178, VAL(MID$(parameter$, 5, 1))
abc = EmsExist
IF abc = 1 THEN
        PUT (42, 88), buttons(0 * boffset), PSET
ELSE PUT (42, 88), buttons(1 * boffset), PSET
END IF
'      [QB/PDS] DECLARE FUNCTION MusicLoop% (LoopEnable%)
abc = MusicLoop(&HFF)
IF abc = 1 THEN
        PUT (42, 104), buttons(0 * boffset), PSET
ELSE PUT (42, 104), buttons(1 * boffset), PSET
END IF

END SUB

FUNCTION OverLoad (FileName$, FileHandle)
DIM OverEnd AS OVREND, OverEntry AS OVRLOAD
GET FileHandle, LOF(FileHandle) - 14, OverEnd
IF OverEnd.ID <> "OverLoader" THEN
  PRINT "OverLoader: Couldn't find OverLoader ID."
  DO: LOOP UNTIL LEN(INKEY$)
  END
END IF
SEEK FileHandle, OverEnd.Location
FOR J = 1 TO ASC(OverEnd.Entries)
GET FileHandle, , OverEntry
IF UCASE$(RTRIM$(OverEntry.FileName)) = UCASE$(LEFT$(FileName$, INSTR(FileName$, CHR$(0)))) THEN GOTO Done
NEXT

Done:
SEEK FileHandle, OverEntry.Location
OverLoad = OverEntry.Length MOD &H80FF
END FUNCTION

SUB SetupScreen
Bevel 0, 0, 319, 199, 1, 4, 0
Bevel 4, 4, 315, 195, 2, 3, 0
LOCATE 2, 2
COLOR 15
PRINT "  KPLAY GENERAL DIGITAL MUSIC PLAYER"
LOCATE 3, 2
PRINT "            WOS SOUND TEST          "
LINE (8, 24)-(311, 24), 21
LINE (8, 25)-(311, 25), 22
LINE (8, 26)-(311, 26), 23
LINE (8, 27)-(311, 28), 24, B
LINE (8, 29)-(311, 29), 23
LINE (8, 30)-(311, 30), 22
LINE (8, 31)-(311, 31), 21
LOCATE 6, 2
PRINT "Addr"
LOCATE 8, 2
PRINT "IRQ:"
LOCATE 10, 2
PRINT "DMA:"
LOCATE 12, 2
PRINT "EMS:"
LOCATE 14, 2
PRINT "Loop"
LOCATE 6, 30
PRINT "Order"
LOCATE 8, 30
PRINT "Pattern"
LOCATE 10, 30
PRINT "Row"
LOCATE 12, 30
PRINT "Channels"
LOCATE 14, 30
PRINT "Volume"
LOCATE 22, 32
PRINT "Mix Rate"
LOCATE 20, 2
PRINT "VU Meter"

END SUB

SUB setupsoundsystem

END SUB

SUB ShowSettings
parameter$ = HEX$(MSEConfig.BaseIO)
DisplayLED 42, 38, VAL(LEFT$(parameter$, 1))
DisplayLED 50, 38, VAL(MID$(parameter$, 2, 1))
DisplayLED 58, 38, VAL(RIGHT$(parameter$, 1))
parameter$ = STR$(MSEConfig.IRQ)
parameter$ = LTRIM$(RTRIM$(parameter$))
IF LEN(parameter$) = 1 THEN parameter$ = "0" + parameter$
DisplayLED 42, 54, VAL(LEFT$(parameter$, 1))
DisplayLED 50, 54, VAL(RIGHT$(parameter$, 1))
parameter$ = STR$(MSEConfig.DMA)
parameter$ = LTRIM$(RTRIM$(parameter$))
IF LEN(parameter$) = 1 THEN parameter$ = "0" + parameter$
DisplayLED 42, 70, VAL(LEFT$(parameter$, 1))
DisplayLED 50, 70, VAL(RIGHT$(parameter$, 1))


END SUB

