'BAT-MOD3.BAS
'The graphic engine driver module
DEFINT A-Z
'$INCLUDE: 'dash.bi'
'$INCLUDE: 'bwsb.bi'
'$INCLUDE: 'gdmtype.bi'
'$INCLUDE: 'gslib.bi'
'$DYNAMIC

'---DECLARATIONS---

DECLARE SUB waitforit ()
DECLARE SUB setvm (answer%)
DECLARE SUB TextBox ()
DECLARE SUB FadeVolumeOut ()
DECLARE SUB buggeredout (errornumber%)
DECLARE SUB LoadGIF (theimage$)
DECLARE SUB PlaceMonsters (monchar%, monatk%)
DECLARE SUB UpdateScreen ()

'---GLOBALS---

COMMON SHARED actions() AS INTEGER, against() AS INTEGER, usinga() AS INTEGER, initiative() AS INTEGER
COMMON SHARED MODfile AS STRING, BackgroundImage AS STRING
COMMON SHARED monster AS INTEGER, monsterfile AS STRING, setevent AS INTEGER
COMMON SHARED monsteroffset AS INTEGER, MusicChannels AS INTEGER
COMMON SHARED bubble AS INTEGER, dubble AS INTEGER, dubble2 AS INTEGER
COMMON SHARED iconoffset AS INTEGER, optionoffset AS INTEGER
COMMON SHARED moolah AS LONG, pmx AS INTEGER, pmy AS INTEGER
COMMON SHARED map AS STRING, nstat() AS INTEGER, nbig() AS LONG
COMMON SHARED nst() AS STRING, spl() AS INTEGER, evnt() AS INTEGER
COMMON SHARED monstersprite() AS STRING, monstery AS INTEGER, monsterx() AS INTEGER
COMMON SHARED monsterstat() AS INTEGER
COMMON SHARED attackoptions()     AS INTEGER
COMMON SHARED attackicons()     AS INTEGER
COMMON SHARED monstergfx()     AS INTEGER
COMMON SHARED playergfx()      AS INTEGER
COMMON SHARED equipment() AS INTEGER
COMMON SHARED detectedsound AS INTEGER
COMMON SHARED buffer1() AS INTEGER, buffer2() AS INTEGER
COMMON SHARED paldata AS STRING * 768

REM $STATIC
SUB Buffer1toBuffer2
gspcopy VARSEG(buffer1(0)), VARPTR(buffer1(0)), VARSEG(buffer2(0)), VARPTR(buffer2(0))
END SUB

SUB Buffer2toBuffer1
gspcopy VARSEG(buffer2(0)), VARPTR(buffer2(0)), VARSEG(buffer1(0)), VARPTR(buffer1(0))
END SUB

REM $DYNAMIC
SUB LoadBackground
LoadGIF BackgroundImage$
gspcopy &HA000, 0, VARSEG(buffer1(0)), VARPTR(buffer1(0))
gspcopy &HA000, 0, VARSEG(buffer2(0)), VARPTR(buffer2(0))

END SUB

REM $STATIC
SUB LoadGIF (theimage$)
'Prefix() and Suffix() hold the LZW phrase dictionary.
'OutStack() is used as a decoding stack.
'ShiftOut() as a power of two table used to quickly retrieve the LZW
'multibit codes.
DIM Prefix(4095), Suffix(4095), OutStack(4095), ShiftOut(8)

'The following line is for the QB environment(slow).
'DIM YBase AS LONG, Powersof2(11) AS LONG, WorkCode AS LONG
'For a little more speed, unremark the next line and remark the one
'above, before you compile... You'll get an overflow error if the
'following line is used in the QB environment, so change it back.
DIM YBase AS INTEGER, Powersof2(11) AS INTEGER, WorkCode AS INTEGER

'Precalculate power of two tables for fast shifts.
FOR a = 0 TO 8: ShiftOut(8 - a) = 2 ^ a: NEXT
FOR a = 0 TO 11: Powersof2(a) = 2 ^ a: NEXT

'Open file and use detection for existance...kill if nonexistant.
duhimage = FREEFILE
OPEN theimage$ FOR BINARY AS #duhimage
IF LOF(duhimage) = 0 THEN
        CLOSE duhimage
        KILL theimage$
        buggeredout 21
END IF
'Check to see if GIF file. Ignore GIF version number.
theimage$ = "      ": GET #duhimage, , theimage$
IF LEFT$(theimage$, 3) <> "GIF" THEN buggeredout 19

'Get logical screen's X and Y resolution.
GET #duhimage, , TotalX: GET #duhimage, , TotalY: GOSUB GetByte
'Calculate number of colors and find out if a global palette exists.
NumColors = 2 ^ ((a AND 7) + 1): NoPalette = (a AND 128) = 0
'Retrieve background color.
GOSUB GetByte: Background = a

'Get aspect ratio and ignore it.
GOSUB GetByte

'Retrieve global palette if it exists.
IF NoPalette = 0 THEN P$ = SPACE$(NumColors * 3): GET #duhimage, , P$

DO 'Image decode loop

'Skip by any GIF extensions.
'(With a few modifications this code could also fetch comments.)
DO
    'Skip by any zeros at end of image (why must I do this? the
    'GIF spec never mentioned it)
    DO
        IF EOF(1) THEN GOTO AllDone 'if at end of file, exit
        GOSUB GetByte
    LOOP WHILE a = 0           'loop while byte fetched is zero

    SELECT CASE a
    CASE 44  'We've found an image descriptor!
        EXIT DO
    CASE 59  'GIF trailer, stop decoding.
        GOTO AllDone
    CASE IS <> 33
        buggeredout 20
    CASE ELSE
    END SELECT
    'Skip by blocked extension data.
    GOSUB GetByte
    DO: GOSUB GetByte: theimage$ = SPACE$(a): GET #duhimage, , theimage$: LOOP UNTIL a = 0
LOOP
'Get image's start coordinates and size.
GET #duhimage, , XStart: GET #duhimage, , YStart: GET #duhimage, , XLength: GET #duhimage, , YLength
XEnd = XStart + XLength: YEnd = YStart + YLength

'Check for local colormap, and fetch it if it exists.
GOSUB GetByte
IF (a AND 128) THEN
    NoPalette = 0
    NumColors = 2 ^ ((a AND 7) + 1)
    P$ = SPACE$(NumColors * 3): GET #duhimage, , P$
END IF

'Check for interlaced image.
Interlaced = (a AND 64) > 0: PassNumber = 0: PassStep = 8

'Get LZW starting code size.
GOSUB GetByte

'Calculate clear code, end of stream code, and first free LZW code.
ClearCode = 2 ^ a
EOSCode = ClearCode + 1
FirstCode = ClearCode + 2: NextCode = FirstCode
StartCodeSize = a + 1: CodeSize = StartCodeSize

'Find maximum code for the current code size.
StartMaxCode = 2 ^ (a + 1) - 1: MaxCode = StartMaxCode

BitsIn = 0: BlockSize = 0: BlockPointer = 1

x = XStart: y = YStart: YBase = y * 320&

DEF SEG = &HA000

'Set palette, if there was one.
IF NoPalette = 0 THEN
    'Use OUTs for speed.
    OUT &H3C8, 0
    FOR a = 1 TO NumColors * 3: OUT &H3C9, ASC(MID$(P$, a, 1)) \ 4: NEXT
    'Save palette of image to disk.
    'OPEN "pal." FOR BINARY AS #2: PUT #2, , P$: CLOSE #2
END IF

'IF FirstTime = 0 THEN
'  'Clear entire screen to background color. This isn't
'  'done until the image's palette is set, to avoid flicker
'  'on some GIFs.
'    LINE (0, 0)-(319, 199), Background, BF
'    FirstTime = -1
'END IF

'Decode LZW data stream to screen.
DO
    'Retrieve one LZW code.
    GOSUB GetCode
    'Is it an end of stream code?
    IF Code <> EOSCode THEN
        'Is it a clear code? (The clear code resets the sliding
        'dictionary - it *should* be the first LZW code present in
        'the data stream.)
        IF Code = ClearCode THEN
            NextCode = FirstCode
            CodeSize = StartCodeSize
            MaxCode = StartMaxCode
            DO: GOSUB GetCode: LOOP WHILE Code = ClearCode
            IF Code = EOSCode THEN GOTO ImageDone
            LastCode = Code: LastPixel = Code
            IF x < 320 AND y < 200 THEN POKE x + YBase, LastPixel
            x = x + 1: IF x = XEnd THEN GOSUB NextScanLine
        ELSE
            CurCode = Code: StackPointer = 0

            'Have we entered this code into the dictionary yet?
            IF Code >= NextCode THEN
                IF Code > NextCode THEN GOTO AllDone 'Bad GIF if this happens.
               'mimick last code if we haven't entered the requested
               'code into the dictionary yet
                CurCode = LastCode
                OutStack(StackPointer) = LastPixel
                StackPointer = StackPointer + 1
            END IF

            'Recursively get each character of the string.
            'Since we get the characters in reverse, "push" them
            'onto a stack so we can "pop" them off later.
            'Hint: There is another, much faster way to accomplish
            'this that doesn't involve a decoding stack at all...
            DO WHILE CurCode >= FirstCode
                OutStack(StackPointer) = Suffix(CurCode)
                StackPointer = StackPointer + 1
                CurCode = Prefix(CurCode)
            LOOP

            LastPixel = CurCode
            IF x < 320 AND y < 200 THEN POKE x + YBase, LastPixel
            x = x + 1: IF x = XEnd THEN GOSUB NextScanLine

            '"Pop" each character onto the display.
            FOR a = StackPointer - 1 TO 0 STEP -1
                IF x < 320 AND y < 200 THEN POKE x + YBase, OutStack(a)
                x = x + 1: IF x = XEnd THEN GOSUB NextScanLine
            NEXT

            'Can we put this new string into our dictionary? (Some GIF
            'encoders will wait a bit when the dictionary is full
            'before sending a clear code- this increases compression
            'because the dictionary's contents are thrown away less
            'often.)
            IF NextCode < 4096 THEN
                'Store new string in the dictionary for later use.
                Prefix(NextCode) = LastCode
                Suffix(NextCode) = LastPixel
                NextCode = NextCode + 1
                'Time to increase the LZW code size?
                IF (NextCode > MaxCode) AND (CodeSize < 12) THEN
                    CodeSize = CodeSize + 1
                    MaxCode = MaxCode * 2 + 1
                END IF
            END IF
            LastCode = Code
        END IF
    END IF
LOOP UNTIL Code = EOSCode
ImageDone:

LOOP

AllDone:
GOTO fergetit

'Slowly reads one byte from the GIF file...
GetByte: theimage$ = " ": GET #duhimage, , theimage$: a = ASC(theimage$): RETURN

'Moves down one scanline. If the GIF is interlaced, then the number
'of scanlines skipped is based on the current pass.
NextScanLine:
    IF Interlaced THEN
        y = y + PassStep
        IF y >= YEnd THEN
            PassNumber = PassNumber + 1
            SELECT CASE PassNumber
            CASE 1: y = 4: PassStep = 8
            CASE 2: y = 2: PassStep = 4
            CASE 3: y = 1: PassStep = 2
            CASE ELSE
            END SELECT
        END IF
    ELSE
        y = y + 1
    END IF
    x = XStart: YBase = y * 320&
RETURN

'Reads a multibit code from the data stream.
GetCode:
    WorkCode = LastChar \ ShiftOut(BitsIn)
  'Loop while more bits are needed.
    DO WHILE CodeSize > BitsIn
'Reads a byte from the LZW data stream. Since the data stream is
'blocked, a check is performed for the end of the current block
'before each byte is fetched.
        IF BlockPointer > BlockSize THEN
          'Retrieve block's length
            GOSUB GetByte: BlockSize = a
            theimage$ = SPACE$(BlockSize): GET #duhimage, , theimage$
            BlockPointer = 1
        END IF
      'Yuck, ASC() and MID$() aren't that fast.
        LastChar = ASC(MID$(theimage$, BlockPointer, 1))
        BlockPointer = BlockPointer + 1
      'Append 8 more bits to the input buffer
        WorkCode = WorkCode OR LastChar * Powersof2(BitsIn)
        BitsIn = BitsIn + 8
    LOOP
  'Take away x number of bits.
    BitsIn = BitsIn - CodeSize
  'Return code to caller.
    Code = WorkCode AND MaxCode
RETURN
fergetit:
'I added this part to free up some space...heheh :)
ERASE Prefix, Suffix, OutStack, ShiftOut, Powersof2
CLOSE

END SUB

SUB partydied
PlaceMonsters 0, 0
UpdateScreen
TextBox
LOCATE 11, 1
PRINT "Valiant to the end..."
IF detectedsound = 1 THEN
        FadeVolumeOut
        StopMusic
        StopOutput
        UnloadModule
        FreeMSE
END IF
waitforit
VSFadeBlack 64
CLS
setvm 0
RUN "WRATH.EXE"

END SUB

REM $DYNAMIC
SUB PlaceMonsters (monchar, monatk)
gspcopy VARSEG(buffer2(0)), VARPTR(buffer2(0)), VARSEG(buffer1(0)), VARPTR(buffer1(0))
IF monsterstat(1, 1) > 0 THEN
        DEF SEG = VARSEG(monstergfx(0)): BLOAD monstersprite(1), VARPTR(monstergfx(0)): DEF SEG
        IF monchar = 1 THEN
        VSSprite VARSEG(monstergfx(monatk * monsteroffset)), VARPTR(monstergfx(monatk * monsteroffset)), monsterx(1), monstery, VARSEG(buffer1(0)), VARPTR(buffer1(0))
        ELSE
        VSSprite VARSEG(monstergfx(0)), VARPTR(monstergfx(0)), monsterx(1), monstery, VARSEG(buffer1(0)), VARPTR(buffer1(0))
        END IF
END IF
IF monsterstat(2, 1) > 0 AND monster > 1 THEN
        DEF SEG = VARSEG(monstergfx(0)): BLOAD monstersprite(2), VARPTR(monstergfx(0)): DEF SEG
        IF monchar = 2 THEN
        VSSprite VARSEG(monstergfx(monatk * monsteroffset)), VARPTR(monstergfx(monatk * monsteroffset)), monsterx(2), monstery, VARSEG(buffer1(0)), VARPTR(buffer1(0))
        ELSE
        VSSprite VARSEG(monstergfx(0)), VARPTR(monstergfx(0)), monsterx(2), monstery, VARSEG(buffer1(0)), VARPTR(buffer1(0))
        END IF
END IF
IF monsterstat(3, 1) > 0 AND monster > 2 THEN
        DEF SEG = VARSEG(monstergfx(0)): BLOAD monstersprite(3), VARPTR(monstergfx(0)): DEF SEG
        IF monchar = 3 THEN
        VSSprite VARSEG(monstergfx(monatk * monsteroffset)), VARPTR(monstergfx(monatk * monsteroffset)), monsterx(3), monstery, VARSEG(buffer1(0)), VARPTR(buffer1(0))
        ELSE
        VSSprite VARSEG(monstergfx(0)), VARPTR(monstergfx(0)), monsterx(3), monstery, VARSEG(buffer1(0)), VARPTR(buffer1(0))
        END IF
END IF
IF monsterstat(4, 1) > 0 AND monster > 3 THEN
        DEF SEG = VARSEG(monstergfx(0)): BLOAD monstersprite(4), VARPTR(monstergfx(0)): DEF SEG
        IF monchar = 4 THEN
        VSSprite VARSEG(monstergfx(monatk * monsteroffset)), VARPTR(monstergfx(monatk * monsteroffset)), monsterx(4), monstery, VARSEG(buffer1(0)), VARPTR(buffer1(0))
        ELSE
        VSSprite VARSEG(monstergfx(0)), VARPTR(monstergfx(0)), monsterx(4), monstery, VARSEG(buffer1(0)), VARPTR(buffer1(0))
        END IF
END IF

END SUB

REM $STATIC
SUB RestoreBackground
DEF SEG = VARSEG(buffer2(0))
BLOAD "DATA\BACKING.TMP", VARPTR(buffer2(0))
DEF SEG
KILL "DATA\BACKING.TMP"

END SUB

SUB StoreBackground
DEF SEG = VARSEG(buffer2(0))
BSAVE "DATA\BACKING.TMP", VARPTR(buffer2(0)), 64000
DEF SEG

END SUB

REM $DYNAMIC
SUB UpdateScreen
gspcopy VARSEG(buffer1(0)), VARPTR(buffer1(0)), &HA000, 0
END SUB

