	page	59,130
;COPYLINE.ASM	JUL-20-95
;External assembly language procedure for PUZZLE.XPL.

cseg	segment dword public 'code'
	assume cs:cseg

;----------------------------------------------------------------------
;Copy a horizontal scan line from Raster to screen. This assumes video
; mode $12: 640x480x16.
; CopyLine(Src, Dst, Raster, Depth);
; offsets: 10   8    6       4
;  Src = Line from Raster
;  Dst = Line on screen
;  Raster = Segment array (4*38400 = 4*640/8*480 bytes)
;  Depth = Number of bit planes [0..4]
;
	public	CopyLine
CopyLine:
	mov	bp,sp		;get pointer to arguments

;if Dst < 0 then Dst:= 0;	(Copy it anyway to keep timing the same)
	mov	ax,[bp]+8
	test	ax,ax
	jns	dl10
	sub	ax,ax
dl10:

;Dst:= Dst *80;   Src:= Src *80;   \Convert line to address offset
	mov	dx,80		;There are 80 bytes per scan line
	mul	dx
	mov	di,ax

	mov	ax,[bp]+10
	mov	dx,80
	mul	dx
	mov	si,ax

	cld			;set up for rep movsw instruction below
	push	es
	mov	ax,0a000h	;point es to graphic screen
	mov	es,ax

;for D:= 0, DEPTH-1 do
	mov	dx,3c4h		;address of sequencer registers
	sub	cl,cl		;D:= 0
	mov	ch,[bp]+4	;Depth

;Register usage:
; cl = depth counter
; ch = depth limit+1
; dx = output port address
; si = offset to image source (in Raster)
; di = offset to image destination (on screen)
; bp = arguments

	push	ds		;save register
	mov	ax,[bp]+6	;Raster
	inc	ax		;skip header
	mov	ds,ax

;POUT($100<<D!2, $3C4, 1);	\Enable appropriate bit plane
dl20:	mov	ah,08h		;bit plane order: 3, 2, 1, 0
	shr	ah,cl
	mov	al,02h
	out	dx,ax		;sequencer map mask register

	push	cx		;save regs
	push	si
	push	di

	mov	cx,40		;40 words per scan line
	rep movsw		;es:di++ <-- ds:si++  cx--

	pop	di		;restore registers
	pop	si
	pop	cx

	mov	ax,ds		;next bit plane data
	add	ax,2400		;2400 = 640/8*480/16
	mov	ds,ax

	inc	cl		;next bit plane
	cmp	cl,ch		;loop for Depth planes
	jl	dl20

	pop	ds		;restore regs
	pop	es
	retf	8		;drop 4 arguments

cseg	ends
	end
