
' ͻ
'  QUINES V1.1 - QBasic Minesweeper   (c) 1999 Kaswoj Software
' ͼ
'
' Programmed by Dominik Kaspar
'               Ahornweg 15
'               5615 Fahrwangen
'               Switzerland         e-mail: pedok@pop.agri.ch
'                                       or: kaswoj@gmx.net
'
' Visit Kaswoj Software at:
'       http://www.geocities.com/CapeCanaveral/Cockpit/3406/
'
' Thanks to the unknown authors of the WAV-player and the mouse routines!
'
' Note: The sounds may not work when the program is run from QuickBasic or
'       QBasic. You might have to play the executable version of this game.

DECLARE SUB Button (x!, y!, xx!, yy!, c)
DECLARE SUB ButtonPressed (x!, y!, xx!, yy!, c!)
DECLARE SUB CheckGameOver ()
DECLARE SUB CheckHighScore ()
DECLARE SUB ClearZeros ()
DECLARE SUB CountMines (x, y)
DECLARE SUB Delay (tdelay!)
DECLARE SUB DetectWorkingDir ()
DECLARE SUB DrawField ()
DECLARE SUB DrawMenu ()
DECLARE SUB FontPrint (XPos!, YPos!, Text$, Colour!)
DECLARE SUB GameDone (Text1$, Text2$)
DECLARE SUB GetMouse ()
DECLARE SUB Help ()
DECLARE SUB HighScores ()
DECLARE SUB Intro ()
DECLARE SUB LoadFont ()
DECLARE SUB Logo (XPos!, YPos!, size!, Text$, Colour!)
DECLARE SUB MainMenu ()
DECLARE SUB Mouse (OnOff%)
DECLARE SUB MouseInit ()
DECLARE SUB MouseSet (x%, y%)
DECLARE SUB MouseXLim (x1%, x2%)
DECLARE SUB MouseYLim (y1%, y2%)
DECLARE SUB NewHighScore ()
DECLARE SUB Pause (t!)
DECLARE SUB PlayGame ()
DECLARE SUB PlayBack (buffer$, size%, freq&, BytesPerSec&, chans%, num%)
DECLARE SUB PlayWav (wavefile$)
DECLARE SUB PromptMines ()
DECLARE SUB PromptName ()
DECLARE SUB ReadData ()
DECLARE SUB SelectButtons (x!, y!)
DECLARE SUB ValidWavHeader (FILE$, LenHeader%, dataLen&, nChannels%, nSamplesPerSec&, nAvgBytesPerSec&, ok%)
DECLARE SUB WaitKeyUp ()
DECLARE SUB WaitMove ()
DECLARE SUB WriteToDSP (v%)
DECLARE FUNCTION GetBlasterAddr% ()
DECLARE FUNCTION Interr% (num%, AX%, BX%, CX%, DX%)
DECLARE FUNCTION SBreset% ()

COMMON SHARED BlasterAddr%, dma%, repeats%

TYPE HighScoreType
    NumMines AS INTEGER
    Player   AS STRING * 15
    Time     AS LONG
END TYPE
DIM SHARED HighScore AS HighScoreType

DIM SHARED MS%(45)
DIM SHARED MouseX, MouseY, MouseK

DIM SHARED Font AS STRING * 30
DIM SHARED FontChar(0 TO 127, 1 TO 5, 1 TO 6) AS INTEGER
DIM SHARED CurDir$

DIM SHARED Grid(0 TO 31, 0 TO 19) AS INTEGER
DIM SHARED Mines(0 TO 31, 0 TO 19) AS INTEGER
DIM SHARED Menu(1 TO 6)
DIM SHARED Count AS INTEGER
DIM SHARED ClearedZeros AS INTEGER
DIM SHARED PlayTime
DIM SHARED IntroNow
DIM SHARED GameOver AS INTEGER
           GameOver = 1
DIM SHARED AnzMines AS INTEGER
           AnzMines = 80
DIM SHARED DrawnField AS INTEGER
           DrawnField = 0
DIM SHARED SoundFlag AS INTEGER
           SoundFlag = 1

CLS
RANDOMIZE TIMER

COLOR 14, 1
PRINT
PRINT "ͻ"
PRINT " QUINES - QBasic Minesweeper "
PRINT "          by Dominik Kaspar  "
PRINT "ͼ"
PRINT

COLOR 7, 0
PRINT " Mouse Initialization...";
ReadData
MouseInit
MouseXLim 0, 319
MouseYLim 0, 200
PRINT "[OK]"

DetectWorkingDir
'CurDir$ = "C:\QB45\QUINES\"
LoadFont

COLOR 14, 1
PRINT
PRINT "ͻ"
PRINT " [1] Play Quines with Sound Effects!   "
PRINT " [2] They don't work on my computer... "
PRINT "ͼ"
COLOR 14, 4
PRINT
PRINT "ͻ"
PRINT " ";
COLOR 30, 4
PRINT "Please make your selection.";
COLOR 14, 4
PRINT " "
PRINT "ͼ"
COLOR 7, 0

Key$ = INKEY$
DO
  Key$ = INKEY$
LOOP UNTIL Key$ = "1" OR Key$ = "2" OR Key$ = CHR$(13)
IF Key$ = "2" THEN SoundFlag = 0 ELSE SoundFlag = 1

Intro

SCREEN 7

DO
 MainMenu
Skip:
 DrawField
 PlayGame
 IF GameOver = 2 THEN GOTO Skip
LOOP

Mouse 0
END
MS.Data:
DATA 55,8b,ec,56,57
DATA 8b,76,0c,8b,04
DATA 8b,76,0a,8b,1c
DATA 8b,76,08,8b,0c
DATA 8b,76,06,8b,14
DATA cd,21
DATA 8b,76,0c,89,04
DATA 8b,76,0a,89,1c
DATA 8b,76,08,89,0c
DATA 8b,76,06,89,14
DATA 5f,5e,5d
DATA ca,08,00
DATA #

SUB Button (x, y, xx, yy, c)

LINE (x, y)-(xx, yy), 0, B
LINE (x, y)-(xx - 1, yy - 1), 7, B
LINE (x + 1, y + 1)-(xx - 1, yy - 1), 8, B
LINE (x + 1, y + 1)-(xx - 2, yy - 2), 15, B
LINE (x + 2, y + 2)-(xx - 2, yy - 2), 7, B
LINE (x + 2, y + 2)-(xx - 3, yy - 3), c, BF

END SUB

SUB ButtonPressed (x, y, xx, yy, c)

LINE (x, y)-(xx, yy), 0, B
LINE (x, y)-(xx - 1, yy - 1), 8, B
LINE (x + 1, y + 1)-(xx - 1, yy - 1), 7, B
LINE (x + 1, y + 1)-(xx - 2, yy - 2), 7, B
LINE (x + 2, y + 2)-(xx - 2, yy - 2), 15, B
LINE (x + 2, y + 2)-(xx - 3, yy - 3), c, BF

END SUB

SUB CheckGameOver
    i = 0
    FOR x = 1 TO 30
        FOR y = 1 TO 18
            IF Mines(x, y) = 9 OR Mines(x, y) = 10 AND Grid(x, y) = 1 THEN i = i + 1
        NEXT y
    NEXT x
    IF i = AnzMines THEN
       GameOver = 1
    END IF
END SUB

SUB CheckHighScore
  NewHighScore
  OPEN CurDir$ + "quines.hsc" FOR RANDOM AS #1 LEN = LEN(HighScore)
       rec = AnzMines / 5
       GET #1, rec, HighScore
       IF HighScore.Time = 0 OR (HighScore.Time <> 0 AND PlayTime < HighScore.Time) THEN
          PromptName
          HighScore.NumMines = AnzMines
          HighScore.Time = CINT(PlayTime)
          PUT #1, rec, HighScore
       END IF
  CLOSE #1
END SUB

SUB ClearZeros
    FOR x = 1 TO 30
        FOR y = 1 TO 18
            IF Mines(x, y) = 0 THEN
               FOR i = (x - 1) TO (x + 1)
                   FOR j = (y - 1) TO (y + 1)
                       IF Mines(i, j) = 9 THEN
                          IF i <> 0 AND j <> 0 AND i <> 31 AND j <> 19 THEN
                             LINE (i * 10, j * 10)-(i * 10 + 9, j * 10 + 9), 0, BF
                             CountMines i, j
                             Mines(i, j) = Count
                             ClearedZeros = ClearedZeros + 1
                             FontPrint i * 10 + 2, j * 10 + 2, LTRIM$(STR$(Count)), Count + 0
                          END IF
                       END IF
                   NEXT j
               NEXT i
            END IF
        NEXT y
    NEXT x
END SUB

SUB CountMines (x, y)
    Count = 0
    FOR i = (x - 1) TO (x + 1)
        FOR j = (y - 1) TO (y + 1)
            IF Grid(i, j) = 1 THEN Count = Count + 1
        NEXT j
    NEXT i
END SUB

DEFINT A-Z
'------------------------------------------------------------------------------
SUB Delay (tdelay!)
time1! = TIMER
DO
LOOP WHILE (TIMER - time1! < tdelay!) OR (time1! > TIMER)
END SUB

DEFSNG A-Z
SUB DetectWorkingDir
 CurDir$ = ""
 PRINT " Detecting working directory...";

 OPEN "QUINES.FNT" FOR RANDOM AS #1 LEN = LEN(Font)
      IF LOF(1) > 0 THEN
         CLOSE #1
         PRINT "[OK]"
         EXIT SUB
      END IF
 CLOSE #1
 KILL "QUINES.FNT"

 SHELL "CD\"
 SHELL "DIR QUINES.FNT /S /B > QUINES.TMP"

 OPEN "QUINES.TMP" FOR INPUT AS #1

 IF LOF(1) = 0 THEN
    PRINT : PRINT
    PRINT " ERROR: Could not detect working directory."
    PRINT "        There is a file missing (QUINES.FNT)"
    PRINT
    SYSTEM
 END IF

 LINE INPUT #1, CurDir$
 CurDir$ = RTRIM$(LTRIM$(UCASE$(CurDir$)))

 FOR i = 1 TO LEN(CurDir$)
     IF MID$(CurDir$, i, 11) = "QUINES.FNT" THEN
        CurDir$ = UCASE$(LEFT$(CurDir$, i - 1))
        EXIT FOR
     END IF
 NEXT i
 IF RIGHT$(CurDir$, 1) <> "\" THEN CurDir$ = CurDir$ + "\"

 CLOSE #1
 KILL "QUINES.TMP"

 PRINT "[OK]"

END SUB

SUB DrawField
  ERASE Mines, Grid
  GameOver = 0

  IF DrawnField = 1 THEN
     PCOPY 2, 0
  ELSE
     Button 0, 0, 319, 199, 0
     FOR x = 10 TO 300 STEP 10
         FOR y = 10 TO 180 STEP 10
             Button x, y, x + 9, y + 9, 7
         NEXT y
     NEXT x
     DrawnField = 1
     PCOPY 0, 2
  END IF
  
  FOR x = 0 TO 31
      FOR y = 0 TO 19
          Mines(x, y) = 9
      NEXT y
  NEXT x
  
  i = 0
  DO
   x = INT(RND * 30) + 1
   y = INT(RND * 18) + 1
   IF Grid(x, y) = 0 THEN
      Grid(x, y) = 1
      i = i + 1
   END IF
  LOOP UNTIL i = AnzMines
END SUB

SUB DrawMenu
  LINE (60, 30)-(259, 169), 0, BF
  Button 60, 30, 259, 169, 0
  FOR i = 70 TO 196 STEP 63
      FOR j = 42 TO 105 STEP 63
          Button i, j, i + 53, j + 53, 7
      NEXT j
  NEXT i

  FontPrint 80, 60, "NEW", 0
  FontPrint 80, 70, "GAME", 0
  FontPrint 80, 128, "HELP", 0
  FontPrint 143, 60, "HIGH-", 0
  FontPrint 143, 70, "SCORES", 0
  FontPrint 143, 128, "QUIT", 0
  IF GameOver = 1 THEN c = 7 ELSE c = 1
  FontPrint 206, 55, "BACK", c
  FontPrint 206, 65, "TO", c
  FontPrint 206, 75, "GAME", c
  FontPrint 206, 123, "SOUND", 0
  IF SoundFlag = 1 THEN
     FontPrint 206, 133, "OFF", 0
  ELSE
     FontPrint 206, 133, "ON", 0
  END IF
END SUB

SUB FontPrint (XPos, YPos, Text$, Colour!)
 FOR TextPos = 1 TO LEN(Text$)
     FOR x = 1 TO 5
         FOR y = 1 TO 6
             SELECT CASE FontChar(ASC(MID$(Text$, TextPos, 1)), x, y)
               CASE 0: 'PSET (XPos + x + TextPos * 6 - 7, YPos + y - 1), 1
               CASE 1: PSET (XPos + x + TextPos * 6 - 7, YPos + y - 1), Colour
             END SELECT
         NEXT y
     NEXT x
 NEXT TextPos
END SUB

SUB GameDone (Text1$, Text2$)
    WaitKeyUp
    GameOver = 1
    IF PlayTime > TIMER THEN
       PlayTime = 86400 - PlayTime + TIMER
    ELSE
       PlayTime = TIMER - PlayTime
    END IF
    LINE (80, 80)-(239, 119), 0, BF
    Button 80, 80, 240, 120, 0
    Button 180, 90, 230, 110, 7
    FontPrint 200, 97, "OK", 0
    FontPrint 90, 90, Text1$, 7
    FontPrint 90, 105, Text2$, 9
    Mouse 1
    DO: WaitMove
        x = MouseX * 4 - 4
        y = MouseY * 8 - 8
        IF MouseK = 1 THEN
           IF x > 180 AND x < 230 AND y > 90 AND y < 110 THEN
              PlayWav CurDir$ + "click.qfx"
              Mouse 0
              ButtonPressed 180, 90, 230, 110, 7
              FontPrint 200, 97, "OK", 0
              Pause .5
              EXIT DO
           END IF
        END IF
    LOOP
END SUB

DEFINT A-Z
'------------------------------------------------------------------------------
FUNCTION GetBlasterAddr%
'Get Blaster Address and DMA channel from Environment Variable
tmp% = 0  'No Environment Variable Set...default
blast$ = UCASE$(ENVIRON$("BLASTER"))
IF LEN(blast$) THEN
   tmp% = INSTR(blast$, "A")
   tmp1$ = MID$(blast$, tmp% + 1, 3)
   tmp% = VAL("&H" + tmp1$)
   IF tmp% = 203 THEN tmp% = -1    'If there is no value assigned
   IF tmp% > 0 THEN
      tmp2% = INSTR(blast$, "D")
      dma% = VAL(MID$(blast$, tmp2% + 1))        'dma% is a global variable
      IF dma% < 0 OR dma% > 7 THEN tmp% = -2
   END IF
END IF
GetBlasterAddr% = tmp%
END FUNCTION

DEFSNG A-Z
SUB GetMouse
R% = Interr%(&H33, 3, BX%, CX%, DX%)
MouseK = BX%
MouseX = CX% / 8 + 1
MouseY = DX% / 8 + 1
END SUB

SUB Help
  Button 0, 0, 319, 199, 0
 
  Button 260, 160, 300, 180, 7
  FontPrint 274, 167, "OK", 0

  FontPrint 19, 19, "HELP / GAME DESCRIPTION:", 1
  FontPrint 20, 20, "HELP / GAME DESCRIPTION:", 9
 
  i = 25
  OPEN CurDir$ + "QUINES.DSC" FOR INPUT AS #1
    DO
      i = i + 10
      LINE INPUT #1, Text$
      FontPrint 20, i, Text$, 7
    LOOP UNTIL EOF(1)
  CLOSE #1

  Mouse 1
  DO: WaitMove
      x = MouseX * 4 - 4
      y = MouseY * 8 - 8
    IF MouseK = 1 THEN
       IF x > 260 AND x < 300 AND y > 160 AND y < 180 THEN
          PlayWav CurDir$ + "click.qfx"
          Mouse 0
          ButtonPressed 260, 160, 300, 180, 7
          FontPrint 274, 167, "OK", 0
          Pause .5
          ButtonPressed 260, 160, 300, 180, 7
          FontPrint 274, 167, "OK", 0
          WaitKeyUp
          EXIT SUB
       END IF
    END IF
  LOOP
END SUB

SUB HighScores
  Button 0, 0, 319, 199, 0
  FontPrint 19, 19, "QUINES HIGH SCORES:", 1
  FontPrint 20, 20, "QUINES HIGH SCORES:", 9
  Button 260, 160, 300, 180, 7
  FontPrint 274, 167, "OK", 0
  FontPrint 20, 40, "Mines:", 15
  FontPrint 80, 40, "Winner:", 15
  FontPrint 200, 40, "Time:", 15
  NewHighScore
  i = 0
  OPEN CurDir$ + "quines.hsc" FOR RANDOM AS #1 LEN = LEN(HighScore)
    FOR rec = 300 TO 5 STEP -5
        GET #1, CINT(rec / 5), HighScore
        IF HighScore.Time THEN
           i = i + 1
           FontPrint 20, 45 + 10 * i, LTRIM$(STR$(HighScore.NumMines)), 15
           FontPrint 80, 45 + 10 * i, HighScore.Player, 7
           min$ = LTRIM$(STR$(INT(HighScore.Time / 60)))
           IF LEN(min$) = 1 THEN min$ = "0" + min$
           sec$ = LTRIM$(STR$(HighScore.Time - VAL(min$) * 60))
           IF LEN(sec$) = 1 THEN sec$ = "0" + sec$
           FontPrint 200, 45 + 10 * i, min$ + ":" + sec$, 7
           IF i MOD 12 = 0 THEN EXIT FOR
        END IF
    NEXT rec
  CLOSE #1
  IF sec$ = "" THEN FontPrint 20, 55, "[There is no list yet]", 7
  Mouse 1
  DO: WaitMove
      x = MouseX * 4 - 4
      y = MouseY * 8 - 8
    IF MouseK = 1 THEN
       IF x > 260 AND x < 300 AND y > 160 AND y < 180 THEN
          PlayWav CurDir$ + "click.qfx"
          Mouse 0
          ButtonPressed 260, 160, 300, 180, 7
          FontPrint 274, 167, "OK", 0
          Pause .5
          ButtonPressed 260, 160, 300, 180, 7
          FontPrint 274, 167, "OK", 0
          WaitKeyUp
          EXIT SUB
       END IF
    END IF
  LOOP
END SUB

FUNCTION Interr% (num%, AX%, BX%, CX%, DX%)
IF MS%(0) = 0 THEN
PRINT " ERROR: Could not load mouse!"
END
END IF
DEF SEG = VARSEG(MS%(0))
POKE VARPTR(MS%(0)) + 26, num%
CALL ABSOLUTE(AX%, BX%, CX%, DX%, VARPTR(MS%(0)))
Interr% = AX%
END FUNCTION

SUB Intro
  IntroNow = 1
 
  DIM Square(65)
  DIM Memory(1 TO 70, 1 TO 2) AS INTEGER
 
  SCREEN 7, 0, 1, 0
  DrawMenu
  SCREEN 7, 0, 0, 0
 
  Button 0, 0, 319, 199, 0
  Button 60, 30, 259, 75, 0
  Button 60, 80, 259, 169, 0
  Button 210, 142, 250, 162, 7
  FontPrint 224, 149, "OK", 0
  Logo 71, 38, 5, "QUINES", 7
  FontPrint 71, 92, "QBasic Minesweeper", 7
  FontPrint 71, 112, "Programmed by Dominik Kaspar", 7
  FontPrint 71, 128, "This game is freeware. So you", 7
  FontPrint 71, 138, "can do whatever you", 7
  FontPrint 71, 148, "want with it!", 7
  Mouse 1
  DO: WaitMove
    x = MouseX * 4 - 4
    y = MouseY * 8 - 8
    IF MouseK = 1 THEN
       IF x > 210 AND x < 250 AND y > 142 AND y < 162 THEN
          PlayWav CurDir$ + "click.qfx"
          Mouse 0
          ButtonPressed 210, 142, 250, 162, 7
          FontPrint 224, 149, "OK", 0
          Pause .5
          Button 210, 142, 250, 162, 7
          FontPrint 224, 149, "OK", 0
          WaitKeyUp
          EXIT DO
       END IF
    END IF
  LOOP
 
  FOR y = 30 TO 150 STEP 20
      FOR x = 60 TO 240 STEP 20
          DO
            i = INT(RND * 70) + 1
          LOOP UNTIL Memory(i, 1) = 0
          Memory(i, 1) = x
          Memory(i, 2) = y
      NEXT x
  NEXT y
  FOR i = 1 TO 69 STEP 2
      FOR j = 0 TO 1
          x = Memory(i + j, 1)
          y = Memory(i + j, 2)
          SCREEN 7, 0, 1, 0
          GET (x, y)-(x + 20, y + 20), Square
          SCREEN 7, 0, 0, 0
          PUT (x, y), Square, PSET
      NEXT j
      PlayWav CurDir$ + "reveal.qfx"
  NEXT i

END SUB

SUB LoadFont

 OPEN CurDir$ + "QUINES.FNT" FOR RANDOM AS #1 LEN = LEN(Font)

 IF LOF(1) = 0 THEN
    PRINT " Fatal Error: Couldn't find file QUINES.FNT"
    DO: LOOP UNTIL LEN(INKEY$)
    CLOSE #1
    KILL "QUINES.FNT"
    END
 END IF

 PRINT " Loading Font...";

 FOR rec = 1 TO 127
     GET #1, rec, Font
     x = 0
     y = 1
     FOR CodePos = 1 TO 30
         IF x = 5 THEN x = 0: y = y + 1
         x = x + 1
         FontChar(rec, x, y) = VAL(MID$(Font, CodePos, 1))
     NEXT CodePos
 NEXT rec

 CLOSE #1

 PRINT "[OK]"
 Pause .5

END SUB

SUB Logo (XPos!, YPos!, size!, Text$, Colour)
 FOR TextPos = 1 TO LEN(Text$)
     FOR x = 1 TO 5
         FOR y = 1 TO 6
             SELECT CASE FontChar(ASC(MID$(Text$, TextPos, 1)), x, y)
               CASE 1: x1 = XPos + x * size + TextPos * 6 * size - 7 * size
                       y1 = YPos + y * size - 1 * size
                       x2 = XPos + x * size + TextPos * 6 * size - 7 * size + size
                       y2 = YPos + y * size - 1 * size + size
                       Button x1, y1, x2, y2, Colour
             END SELECT
         NEXT y
     NEXT x
 NEXT TextPos
END SUB

SUB MainMenu
  IF IntroNow = 0 THEN DrawMenu ELSE IntroNow = 0

  WaitKeyUp
  Mouse 1
  DO: WaitMove
      x = MouseX * 4 - 4
      y = MouseY * 8 - 8
      SelectButtons x, y
      IF MouseK = 1 THEN
         IF x > 70 AND x < 123 AND y > 42 AND y < 95 THEN     'new game
            PlayWav CurDir$ + "click.qfx"
            GameOver = 2
            Mouse 0
            ButtonPressed 70, 42, 123, 95, 7
            FontPrint 80, 60, "NEW", 0
            FontPrint 80, 70, "GAME", 0
            Pause .5
            PromptMines
            EXIT SUB
         END IF
  
         IF x > 70 AND x < 123 AND y > 105 AND y < 158 THEN   'help
            PlayWav CurDir$ + "click.qfx"
            WaitKeyUp
            Mouse 0
            PCOPY 0, 1
            Help
            PCOPY 1, 0
            Mouse 1
         END IF

         IF x > 133 AND x < 186 AND y > 42 AND y < 95 THEN    'highscores
            PlayWav CurDir$ + "click.qfx"
            WaitKeyUp
            Mouse 0
            PCOPY 0, 1
            HighScores
            PCOPY 1, 0
            Mouse 1
         END IF

         IF x > 133 AND x < 186 AND y > 105 AND y < 158 THEN  'quit
            PlayWav CurDir$ + "click.qfx"
            Mouse 0
            ButtonPressed 133, 105, 186, 158, 7
            FontPrint 143, 128, "QUIT", 0
            Pause .5
            SYSTEM
         END IF

         IF x > 196 AND x < 249 AND y > 42 AND y < 95 THEN    'back to game
            IF GameOver = 0 THEN
               PlayWav CurDir$ + "click.qfx"
               Mouse 0
               ButtonPressed 196, 42, 249, 95, 7
               IF GameOver = 1 THEN c = 7 ELSE c = 1
               FontPrint 206, 55, "BACK", c
               FontPrint 206, 65, "TO", c
               FontPrint 206, 75, "GAME", c
               Pause .5
               EXIT SUB
            END IF
         END IF

         IF x > 196 AND x < 249 AND y > 105 AND y < 158 THEN  'empty
            PlayWav CurDir$ + "click.qfx"
            Mouse 0
            ButtonPressed 196, 105, 249, 158, 7
            FontPrint 206, 123, "SOUND", 0
            IF SoundFlag = 1 THEN
               FontPrint 206, 133, "OFF", 0
            ELSE
               FontPrint 206, 133, "ON", 0
            END IF
            IF SoundFlag = 0 THEN SoundFlag = 1 ELSE SoundFlag = 0
            Pause .5
            Button 196, 105, 249, 158, 7
            FontPrint 206, 123, "SOUND", 0
            IF SoundFlag = 1 THEN
               FontPrint 206, 133, "OFF", 0
            ELSE
               FontPrint 206, 133, "ON", 0
            END IF
            WaitKeyUp
            Mouse 1
         END IF
         WaitKeyUp
      END IF
  LOOP
END SUB

SUB Mouse (OnOff%)
IF OnOff% = 0 THEN OnOff% = 2 ELSE OnOff% = 1
R% = Interr%(&H33, OnOff%, BX%, CX%, DX%)
END SUB

SUB MouseInit
R% = Interr%(&H33, 0, BX%, CX%, DX%)
R% = Interr%(&H33, 10, 0, &HFFFF, &HFF00)
END SUB

SUB MouseSet (x%, y%)
R% = Interr%(&H33, 4, BX%, x% * 8 - 8, y% * 8 - 8)
END SUB

SUB MouseTempo (Speed%)
R% = Interr%(&H33, 15, BX%, Speed%, Speed% * 2)
END SUB

SUB MouseXLim (x1%, x2%)
R% = Interr%(&H33, 7, 0, x1% * 2 - 2, x2% * 2 - 2)
END SUB

SUB MouseYLim (y1%, y2%)
R% = Interr%(&H33, 8, BX%, y1% - 2, y2% - 2)
END SUB

SUB NewHighScore
  OPEN CurDir$ + "quines.hsc" FOR RANDOM AS #1 LEN = LEN(HighScore)
    IF LOF(1) = 0 THEN
       FOR i = 5 TO 300 STEP 5
           HighScore.NumMines = i
           HighScore.Player = ""
           HighScore.Time = 0
           PUT #1, CINT(i / 5), HighScore
       NEXT i
    END IF
  CLOSE #1
END SUB

SUB Pause (t)
    ti = TIMER: DO: LOOP UNTIL TIMER > ti + t
END SUB

DEFINT A-Z
'------------------------------------------------------------------------------
SUB PlayBack (buffer$, size%, freq&, BytesPerSec&, chans%, num%)
size% = size% - 1
segment& = VARSEG(buffer$)
offset& = SADD(buffer$)
IF segment& < 0 THEN segment& = segment& + 65536
IF offset& < 0 THEN offset& = offset& + 65536
baseaddr& = segment& * 16 + offset&
look1% = VARPTR(baseaddr&)
look2% = VARPTR(size%)
SELECT CASE dma%
   CASE 0
      dmapage% = &H87   '135 decimal
      dmaaddr% = 0
      dmalen% = 1
   CASE 1
      dmapage% = &H83   '131 decimal
      dmaaddr% = 2
      dmalen% = 3
   CASE 2
      dmapage% = &H81
      dmaaddr% = 4
      dmalen% = 5
   CASE 3
      dmapage% = &H82
      dmaaddr% = 6
      dmalen% = 7
   CASE 4
      dmapage% = &H8F
      dmaaddr% = &HC0
      dmalen% = &HC2
   CASE 5
      dmapage% = &H8B
      dmaaddr% = &HC4
      dmalen% = &HC6
   CASE 6
      dmapage% = &H89
      dmaaddr% = &HC8
      dmalen% = &HCA
   CASE 7
      dmapage% = &H8A
      dmaaddr% = &HCC
      dmalen% = &HCE
END SELECT
SELECT CASE dma%
   CASE 0 TO 3
      dmamask% = &HA
      dmamode% = &HB
      dmaclear% = &HC
      dmastatus% = &H8
   CASE 4 TO 7
      dmamask% = &HD4
      dmamode% = &HD6
      dmaclear% = &HD8
      dmastatus% = &HD0
END SELECT
SELECT CASE dma%
   CASE 0, 4
      dmaterminal% = 1   'bit 0 of status register (&H08 or &HD0)
   CASE 1, 5
      dmaterminal% = 2   'bit 1
   CASE 2, 6
      dmaterminal% = 4   'bit 2
   CASE 3, 7
      dmaterminal% = 8   'bit 3
END SELECT

OUT dmamask%, dma% + 4   'mask the dma channel
OUT dmaclear%, &H0       '(clear the internal DMA flip/flop)
OUT dmamode%, 72 + dma%  '  72=010010XX where XX=dmachannel%
OUT dmaaddr%, PEEK(look1%)      'bits 0-7 of  the 20bit address
OUT dmaaddr%, PEEK(look1% + 1)  'bits 8-15 of the 20bit address
OUT dmapage%, PEEK(look1% + 2)  'bits 16-19 of the 20 bit address
OUT dmalen%, PEEK(look2%)       'bits 0-7 of size%
OUT dmalen%, PEEK(look2% + 1)   'bits 8-15  of size%
OUT dmamask%, dma%              'enable channel

IF num% = 1 THEN  'only need to Write out time constant once
   timeconst% = 256 - 1000000 / (freq& * chans%)
   CALL WriteToDSP(&H40)
   CALL WriteToDSP(timeconst%)
   'Reset Mixer    DSPmixeraddress = Blasteraddr% + &H4
   OUT BlasterAddr% + &H4, &H0
   OUT BlasterAddr% + &H4 + 1, 0
   'Set Volume to Maximum...255
   OUT BlasterAddr% + &H4, &H22
   OUT BlasterAddr% + &H4 + 1, 255
   IF chans% = 2 THEN
      'Set mixer to Stereo Output
      OUT BlasterAddr% + &H4, &HE
      OUT BlasterAddr% + &H4 + 1, 34      '34=2^5+2^1
   END IF
END IF
IF BytesPerSec& > 22000 THEN
   CALL WriteToDSP(&H48)   'Set Block Size
ELSE
   CALL WriteToDSP(&H14)   'DMA Mode 8-bit DAC
END IF
CALL WriteToDSP(PEEK(look2%))      'Lo byte of address
CALL WriteToDSP(PEEK(look2% + 1))  'High byte of address
IF BytesPerSec& > 22000 THEN CALL WriteToDSP(&H91)  'High Speed DMA mode 8-bit
dummy% = INP(dmastatus%)    'Read status byte once to make sure DMA is going.
WAIT dmastatus%, dmaterminal%   'Loop until terminal count bit set in DMA status register
'DMA Transfer is Now Complete
'Acknowledge the DSP interrupt by reading the DATA AVAILABLE port once
dummy% = INP(BlasterAddr% + &HE)    'DSP Available address
END SUB

DEFSNG A-Z
SUB PlayGame

Mouse 1

PlayTime = TIMER

DO: WaitMove
 MouseX = MouseX * 4 - 4
 MouseY = MouseY * 8 - 8
 x = INT(MouseX / 10) * 10: y = INT(MouseY / 10) * 10
 SELECT CASE MouseK
   CASE 1: Mouse 0
           IF x >= 10 AND x < 310 AND y >= 10 AND y < 190 THEN
              LINE (x, y)-(x + 9, y + 9), 0, BF
              SELECT CASE Grid(x / 10, y / 10)
                CASE 0: PlayWav CurDir$ + "reveal.qfx"
                        CountMines x / 10, y / 10
                        FontPrint x + 2, y + 2, LTRIM$(STR$(Count)), Count + 0
                        Mines(x / 10, y / 10) = Count
                        IF Count = 0 THEN
                           DO
                             ClearedZeros = 0
                             ClearZeros
                           LOOP UNTIL ClearedZeros = 0
                        END IF
                CASE 1: FontPrint x + 2, y + 2, "X", 12
                        PlayWav CurDir$ + "you_lost.qfx"
                        GameDone "Game Over!", "You lost."
                        EXIT SUB
              END SELECT
           ELSE
              PCOPY 0, 1
              MainMenu
              IF GameOver >= 1 THEN EXIT SUB
              PCOPY 1, 0
           END IF
           WaitKeyUp
           CheckGameOver
           IF GameOver = 1 THEN
              PlayWav CurDir$ + "you_won.qfx"
              GameDone "Congrats!", "You Won."
              CheckHighScore
              EXIT SUB
           END IF
           Mouse 1
   CASE 2: PlayWav CurDir$ + "reveal.qfx"
           Mouse 0
           IF Mines(x / 10, y / 10) = 9 THEN
              Mines(x / 10, y / 10) = 10
              PSET (x + 5, y + 7), 0
              DRAW "c0rllru4c4ulldr"
           ELSEIF Mines(x / 10, y / 10) = 10 THEN
              Mines(x / 10, y / 10) = 9
              Button x, y, x + 9, y + 9, 7
           END IF
           WaitKeyUp
           Mouse 1
 END SELECT
LOOP

END SUB

SUB PlayWav (wavefile$)

IF SoundFlag = 0 THEN EXIT SUB

repeats% = 1
BlasterAddr% = GetBlasterAddr%
SELECT CASE BlasterAddr%
   CASE -2
      PRINT " Bad DMA Channel specified!"
      END
   CASE -1
      PRINT " No Port Base Address Given!"
      END
   CASE 0
      PRINT " No BLASTER Environment Variable Set!"
      END
   CASE ELSE
      'Assume a valid Address Exists
'      PRINT " Blaster Address = "; HEX$(BlasterAddr%)
END SELECT
IF NOT SBreset% THEN
   PRINT " SoundBlaster Card Would Not Reset!"
   END
END IF

sp% = INSTR(Spec$, " ")
IF sp% THEN
   wavefile$ = LEFT$(Spec$, sp% - 1)
   repeats% = VAL(RIGHT$(Spec$, LEN(Spec$) - sp%))
   IF repeats% = 0 THEN repeats% = 1
ELSE
   IF LEN(Spec$) THEN
      wavefile$ = Spec$
      repeats% = 1
   END IF
END IF

IF LEN(wavefile$) = 0 THEN
END IF

CALL ValidWavHeader(wavefile$, LenHeader%, WavLen&, Channels%, Sampling&, bytes&, ok%)

IF NOT ok% THEN
   PRINT " Bad Wave File Format"
   END
END IF

MaxBuffer% = 7053

CALL WriteToDSP(&HD1)  'Speaker ON
FOR repeat% = 1 TO repeats%    'This can loop to play the file ii% times]
filenum% = FREEFILE
   OPEN wavefile$ FOR BINARY AS filenum%
      num% = 0
      SEEK filenum%, LenHeader% + 1
      Remaining& = WavLen&
      DO
         num% = num% + 1
         IF Remaining& > MaxBuffer% THEN
            BufferLen% = MaxBuffer%
         ELSE
            BufferLen% = Remaining&
         END IF
         Remaining& = Remaining& - BufferLen%
         buffer$ = SPACE$(BufferLen%)
         GET filenum%, , buffer$
         CALL PlayBack(buffer$, BufferLen%, Sampling&, bytes&, Channels%, num%)
      LOOP WHILE Remaining& > 0
      OUT &H20, &H20   'Reset Normal Interrupt Service
   CLOSE filenum%
NEXT repeat%
CALL WriteToDSP(&HD3)  'Speaker OFF

END SUB

SUB PromptMines
  LINE (62, 32)-(256, 166), 0, BF
                                               
  FontPrint 80, 50, "Please enter the amount of", 7
  FontPrint 80, 65, "mines that should be spread", 7
  FontPrint 80, 80, "throughout the field:", 7

  Button 80, 110, 130, 130, 0
  Button 131, 110, 150, 130, 7
  Button 151, 110, 170, 130, 7
  Button 200, 132, 240, 152, 7

  FontPrint 100, 117, STR$(AnzMines), 9
  FontPrint 138, 117, CHR$(24), 0
  FontPrint 158, 117, CHR$(25), 0
  FontPrint 214, 139, "OK", 0

  Mouse 1

  DO: WaitMove
    x = MouseX * 4 - 4
    y = MouseY * 8 - 8
    IF MouseK = 1 THEN
       IF x > 131 AND x < 150 AND y > 110 AND y < 130 THEN
          AnzMines = AnzMines + 5
          IF AnzMines > 300 THEN AnzMines = 300
          Mouse 0
          ButtonPressed 131, 110, 150, 130, 7
          FontPrint 138, 117, CHR$(24), 0
          LINE (82, 112)-(127, 127), 0, BF
          FontPrint 100, 117, STR$(AnzMines), 9
          PlayWav CurDir$ + "letter.qfx"
          Button 131, 110, 150, 130, 7
          FontPrint 138, 117, CHR$(24), 0
          Mouse 1
       ELSEIF x > 151 AND x < 170 AND y > 110 AND y < 130 THEN
          AnzMines = AnzMines - 5
          IF AnzMines < 5 THEN AnzMines = 5
          Mouse 0
          ButtonPressed 151, 110, 170, 130, 7
          FontPrint 158, 117, CHR$(25), 0
          LINE (82, 112)-(127, 127), 0, BF
          FontPrint 100, 117, STR$(AnzMines), 9
          PlayWav CurDir$ + "letter.qfx"
          Button 151, 110, 170, 130, 7
          FontPrint 158, 117, CHR$(25), 0
          Mouse 1
       ELSEIF x > 200 AND x < 240 AND y > 132 AND y < 152 THEN
          PlayWav CurDir$ + "click.qfx"
          Mouse 0
          ButtonPressed 200, 132, 240, 152, 7
          FontPrint 214, 139, "OK", 0
          Pause .5
          EXIT SUB
       END IF
       WaitKeyUp
    END IF
  LOOP

END SUB

SUB PromptName

  WaitKeyUp

  LINE (60, 30)-(259, 169), 0, BF
  Button 60, 30, 259, 169, 0
                                               
  FontPrint 80, 50, "You have achieved a high", 7
  FontPrint 80, 62, "score! Enter your name:", 7
  i = 0
  FOR y = 80 TO 92 STEP 12
      FOR x = 80 TO 224 STEP 12
          i = i + 1
          Button x, y, x + 11, y + 11, 7
          FontPrint x + 3, y + 3, CHR$(64 + i), 0
      NEXT x
  NEXT y
  Button 80, 104, 91, 115, 7
  Button 92, 104, 103, 115, 7
  FontPrint 95, 107, CHR$(27), 0

  Button 80, 132, 184, 152, 0
  Button 196, 132, 236, 152, 7
  FontPrint 210, 139, "OK", 0

  PlayerName$ = ""
 
  Mouse 1

  DO: WaitMove
    x = MouseX * 4 - 4
    y = MouseY * 8 - 8
    IF MouseK = 1 THEN
       IF x > 80 AND x < 235 AND y > 80 AND y < 103 THEN
         IF LEN(PlayerName$) < 15 THEN
          PlayWav CurDir$ + "letter.qfx"
          xx = INT((x - 80) / 12)
          IF y >= 92 THEN
             yy = 2: char = 78 + xx
          ELSE
             yy = 1: char = 65 + xx
          END IF
          PlayerName$ = PlayerName$ + CHR$(char)
          Mouse 0
          i = 80 + xx * 12
          j = 80 + yy * 12 - 12
          ButtonPressed i, j, i + 11, j + 11, 7
          FontPrint 80 + xx * 12 + 3, 80 + yy * 12 - 9, CHR$(char), 0
          FontPrint 87, 139, PlayerName$, 9
          Pause .2
          Button i, j, i + 11, j + 11, 7
          FontPrint 80 + xx * 12 + 3, 80 + yy * 12 - 9, CHR$(char), 0
          Mouse 1
         END IF
       ELSEIF x > 80 AND x < 91 AND y > 104 AND y < 115 THEN
         IF LEN(PlayerName$) < 15 THEN
          PlayWav CurDir$ + "letter.qfx"
          PlayerName$ = PlayerName$ + " "
          Mouse 0
          ButtonPressed 80, 104, 91, 115, 7
          Pause .2
          Button 80, 104, 91, 115, 7
          Mouse 1
         END IF
       ELSEIF x > 92 AND x < 103 AND y > 104 AND y < 115 THEN
         IF LEN(PlayerName$) >= 1 THEN
          PlayWav CurDir$ + "letter.qfx"
          PlayerName$ = LEFT$(PlayerName$, LEN(PlayerName$) - 1)
          Mouse 0
          LINE (82, 134)-(181, 149), 0, BF
          FontPrint 87, 139, PlayerName$, 9
          ButtonPressed 92, 104, 103, 115, 7
          FontPrint 95, 107, CHR$(27), 0
          Pause .2
          Button 92, 104, 103, 115, 7
          FontPrint 95, 107, CHR$(27), 0
          Mouse 1
         END IF
       ELSEIF x > 200 AND x < 240 AND y > 132 AND y < 152 THEN
          PlayWav CurDir$ + "click.qfx"
          IF LEN(PlayerName$) = 0 THEN PlayerName$ = "Nameless Person"
          HighScore.Player = PlayerName$
          Mouse 0
          ButtonPressed 196, 132, 236, 152, 7
          FontPrint 210, 139, "OK", 0
          Pause .5
          EXIT SUB
       END IF
    END IF
    WaitKeyUp
  LOOP

END SUB

SUB ReadData
RESTORE MS.Data
DEF SEG = VARSEG(MS%(0))
FOR i% = 0 TO 99
READ Byte$
IF Byte$ = "#" THEN EXIT FOR
POKE VARPTR(MS%(0)) + i%, VAL("&H" + Byte$)
NEXT i%
END SUB

DEFINT A-Z
'------------------------------------------------------------------------------
FUNCTION SBreset%
'DSPreset% = address% + &H6
'DSPread% = address% + &HA
'DSPwrite% = address% + &HC
'DSPavail% = address% + &HE
'DSPmixer% = address% + &H4
OUT BlasterAddr% + &H6, 1   'Reset address
Delay .1
OUT BlasterAddr% + &H6, 0
time1! = TIMER: noreset% = 0
DO
   'Read Data Available port until bit 7 is set
   'This should take about 100 micro seconds...give it 1 full second
   IF TIMER - time1! > 1! THEN noreset% = -1
LOOP UNTIL ((INP(BlasterAddr% + &HE) AND 128) = 128) OR noreset%
IF NOT noreset% THEN
   IF INP(BlasterAddr% + &HA) = &HAA THEN
      SBreset% = -1
   ELSE
      SBreset% = 0
   END IF
ELSE
   SBreset% = 0
END IF
END FUNCTION

DEFSNG A-Z
SUB SelectButtons (x, y)
    IF x > 70 AND x < 123 AND y > 42 AND y < 95 THEN
       IF Menu(1) <> 1 THEN
          Mouse 0
          LINE (69, 41)-(123, 95), 9, B
          LINE (68, 40)-(124, 96), 1, B
          Mouse 1
       END IF
       Menu(1) = 1
    ELSE
       IF Menu(1) = 1 THEN
          Mouse 0
          LINE (69, 41)-(123, 95), 0, B
          LINE (68, 40)-(124, 96), 0, B
          Mouse 1
       END IF
       Menu(1) = 0
    END IF
   
    IF x > 70 AND x < 123 AND y > 105 AND y < 158 THEN
       IF Menu(2) <> 1 THEN
          Mouse 0
          LINE (69, 104)-(123, 158), 9, B
          LINE (68, 103)-(124, 159), 1, B
          Mouse 1
       END IF
       Menu(2) = 1
    ELSE
       IF Menu(2) = 1 THEN
          Mouse 0
          LINE (69, 104)-(123, 158), 0, B
          LINE (68, 103)-(124, 159), 0, B
          Mouse 1
       END IF
       Menu(2) = 0
    END IF

    IF x > 133 AND x < 186 AND y > 42 AND y < 95 THEN
       IF Menu(3) <> 1 THEN
          Mouse 0
          LINE (132, 41)-(186, 95), 9, B
          LINE (131, 40)-(187, 96), 1, B
          Mouse 1
       END IF
       Menu(3) = 1
    ELSE
       IF Menu(3) = 1 THEN
          Mouse 0
          LINE (132, 41)-(186, 95), 0, B
          LINE (131, 40)-(187, 96), 0, B
          Mouse 1
       END IF
       Menu(3) = 0
    END IF

    IF x > 133 AND x < 186 AND y > 105 AND y < 158 THEN
       IF Menu(4) <> 1 THEN
          Mouse 0
          LINE (132, 104)-(186, 158), 9, B
          LINE (131, 103)-(187, 159), 1, B
          Mouse 1
       END IF
       Menu(4) = 1
    ELSE
       IF Menu(4) = 1 THEN
          Mouse 0
          LINE (132, 104)-(186, 158), 0, B
          LINE (131, 103)-(187, 159), 0, B
          Mouse 1
       END IF
       Menu(4) = 0
    END IF

    IF x > 196 AND x < 249 AND y > 42 AND y < 95 THEN
       IF Menu(5) <> 1 THEN
          Mouse 0
          LINE (195, 41)-(249, 95), 9, B
          LINE (194, 40)-(250, 96), 1, B
          Mouse 1
       END IF
       Menu(5) = 1
    ELSE
       IF Menu(5) = 1 THEN
          Mouse 0
          LINE (195, 41)-(249, 95), 0, B
          LINE (194, 40)-(250, 96), 0, B
          Mouse 1
       END IF
       Menu(5) = 0
    END IF

    IF x > 196 AND x < 249 AND y > 105 AND y < 158 THEN
       IF Menu(6) <> 1 THEN
          Mouse 0
          LINE (195, 104)-(249, 158), 9, B
          LINE (194, 103)-(250, 159), 1, B
          Mouse 1
       END IF
       Menu(6) = 1
    ELSE
       IF Menu(6) = 1 THEN
          Mouse 0
          LINE (195, 104)-(249, 158), 0, B
          LINE (194, 103)-(250, 159), 0, B
          Mouse 1
       END IF
       Menu(6) = 0
    END IF
END SUB

DEFINT A-Z
'------------------------------------------------------------------------------
SUB ValidWavHeader (FILE$, LenHeader%, dataLen&, nChannels%, nSamplesPerSec&, nAvgBytesPerSec&, ok%)
rID$ = SPACE$(4)
wID$ = SPACE$(4)
fID$ = SPACE$(4)
dat$ = SPACE$(4)
dummy$ = SPACE$(1)

filenum% = FREEFILE
OPEN FILE$ FOR BINARY AS filenum%
  GET filenum%, , rID$
  GET filenum%, , rLen&
  GET filenum%, , wID$
  GET filenum%, , fID$
  GET filenum%, , fLen&
  GET filenum%, , wFormatTag%       '2 bytes
  GET filenum%, , nChannels%        '2 bytes
  GET filenum%, , nSamplesPerSec&   '4 bytes
  GET filenum%, , nAvgBytesPerSec&  '4 bytes
  GET filenum%, , nBlockAlign%      '2 bytes
  GET filenum%, , FormatSpecific%   '2 bytes
  'Read bytes until have read fLen& total bytes.
  'I have no idea what these next bytes are used for (if they even exist).
  FOR i% = 1 TO fLen& - 16          '16 bytes is what we have read in so far
     GET filenum%, , dummy$         'read in 1 byte at a time
  NEXT i%
  GET filenum%, , dat$
  IF UCASE$(dat$) = "FACT" THEN
     'funny format...
     GET filenum%, , dummy&
     GET filenum%, , dummy&
     GET filenum%, , dat$
  END IF
  GET filenum%, , dataLen&
  LenHeader% = LOC(1)
CLOSE filenum%
'  PRINT rID$;
'  PRINT rLen&;
'  PRINT wID$;
'  PRINT fID$;
'  PRINT fLen&;
'  PRINT wFormatTag%;       '2 bytes
'  PRINT nChannels%;        '2 bytes
'  PRINT nSamplesPerSec&;   '4 bytes
'  PRINT nAvgBytesPerSec&;  '4 bytes
'  PRINT nBlockAlign%;      '2 bytes
'  PRINT FormatSpecific%;   '2 bytes
'  PRINT dat$;
'  PRINT dataLen&;
'  PRINT LenHeader%
IF UCASE$(rID$) = "RIFF" THEN
   IF UCASE$(wID$) = "WAVE" THEN
      IF UCASE$(dat$) = "DATA" THEN
         IF UCASE$(fID$) = "FMT " THEN
           IF FormatSpecific% = 8 THEN ok% = -1
         END IF
      END IF
   END IF
END IF
END SUB

DEFSNG A-Z
SUB WaitKeyUp
WHILE MouseK: GetMouse: WEND
END SUB

SUB WaitMove
GetMouse
x% = MouseX: y% = MouseY: k% = MouseK
DO: GetMouse
LOOP UNTIL x% <> MouseX OR y% <> MouseY OR k% <> MouseK
END SUB

DEFINT A-Z
'------------------------------------------------------------------------------
SUB WriteToDSP (v%)
DO
LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, v%
END SUB

