'
DEFINT A-Z
DECLARE SUB Drawball (Xcor%, Ycor%, Xquad%, Yquad%, Xdir%, Ydir%, sco!, speed%, count%, level%)
DECLARE SUB Paddle (Pad%, move%, Length%)
DECLARE SUB Intro (speed%, igs%, Length%)
DECLARE SUB Maplevel (level%, count%)
DECLARE SUB Bounce (Xdir%, Ydir%)
DECLARE SUB Eval (sco!)
DECLARE SUB Fade ()
DIM back&(4900)

level% = 1  'to begin in other levels, type the number of that level minus one.
sco! = 0
speed% = 0
RANDOMIZE TIMER

CLS
CALL Intro(speed%, igs%, Length%)
el% = 1
IF Length% < 90 THEN el% = 2   'incentive to play with short Paddle
IF Length% < 60 THEN el% = 3
IF Length% < 30 THEN el% = 4
SCREEN 8
PRINT ""
PRINT "  Timing System ..."
Tim1# = TIMER
FOR t# = 1 TO 50000
NEXT t#
Tim2# = TIMER
t = 900 / (Tim2# - Tim1#)  'length of delay loop
4   'start new level

level% = level% + 1
IF sco! > 0 THEN CALL Fade
CLS
5   'refresh
LINE (74, 0)-(84, 200), 1, BF     'draws frame
LINE (566, 0)-(576, 200), 1, BF
LINE (74, 0)-(576, 5), 1, BF
Xcor% = 325
Ycor% = 182                       'sets initial positions
Xquad% = -1
Yquad% = -1
Xdir% = 4
Ydir% = 2
Pad% = 305 - Length% / 2
move% = 1
CALL Paddle(Pad%, move%, Length%)
CALL Drawball(Xcor%, Ycor%, Xquad%, Yquad%, Xdir%, Ydir%, sco!, speed%, count%, level%)
COLOR 6
LINE (0, 0)-(60, 32), , B                'writes various status boxes
LOCATE 2, 2
PRINT "Bounce"
LOCATE 3, 2
PRINT "ball"
LINE (0, 38)-(60, 60), , B
LOCATE 6, 2
PRINT "level"
LOCATE 7, 2
PRINT level%
LINE (0, 66)-(60, 92), , B
LOCATE 10, 2
PRINT "Score"
LINE (0, 98)-(60, 124), , B
LOCATE 14, 2
PRINT "Blocks"
LINE (0, 130)-(60, 156), , B
LOCATE 18, 2
PRINT "Speed"
LOCATE 19, 2
PRINT speed%
LINE (0, 160)-(60, 186), , B
LOCATE 22, 2
PRINT "Length"
LOCATE 23, 2
PRINT Length% / 20
LINE (590, 0)-(635, 32), , B
LOCATE 2, 76
PRINT "Ball"
LOCATE 3, 76
PRINT el%
IF R = 0 THEN
 LINE (150, 50)-(500, 120), , B
 LINE (152, 52)-(498, 118), , B
 COLOR 14
 IF sco! > 1 THEN     'did not just begin
  LOCATE 9, 33
  PRINT "Congratulations!"
  LOCATE 11, 31
  PRINT "You Completed Level"; (level% - 1)
  LOCATE 11, 52 + INT((LOG(level% - 1) / LOG(10)))   'no space between number and punctuation mark
  PRINT "."
 END IF
 LOCATE 13, 32
 PRINT "Welcome to Level"; level%
 LOCATE 13, 50 + INT((LOG(level%) / LOG(10)))
 PRINT "!"
 WHILE INKEY$ = ""
 WEND
 LINE (100, 50)-(500, 120), 0, BF
 CALL Maplevel(level%, count%)
 IF igs% < 6 THEN speed% = speed% + igs% ELSE speed% = speed% + RND * 6
 IF speed% > 100 THEN speed% = 95    'it will switch 95 <=> 100 in the end
END IF
R = 0
COLOR 6
LOCATE 11, 1
PRINT INT(sco!)
LINE (0, 70)-(0, 90)
LINE (0, 98)-(60, 124), , B
LOCATE 14, 2           'update
PRINT "Blocks"
LOCATE 15, 2
PRINT count%
WHILE INKEY$ = ""
WEND
'main control loop
100
KEY$ = INKEY$
IF KEY$ = "q" THEN GOTO 999
IF KEY$ = CHR$(0) + "K" THEN move% = -1
IF KEY$ = CHR$(0) + "M" THEN move% = 1
IF KEY$ = "p" THEN
  LOCATE 2, 2
  PRINT "Paused"
  WHILE INKEY$ = ""
  WEND
  LOCATE 2, 2
  PRINT "Bounce"
END IF
IF move% <> 0 THEN CALL Paddle(Pad%, move%, Length%)
IF Ycor% > 200 THEN GOTO 200       'off screen
CALL Drawball(Xcor%, Ycor%, Xquad%, Yquad%, Xdir%, Ydir%, sco!, speed%, count%, level%)
IF count% < 11 THEN GOTO 4
FOR G = 1 TO (100 - speed%)
 FOR h = 1 TO t
 NEXT h
NEXT G
GOTO 100
200
'lost a ball
LINE (Pad%, 188)-(Pad% + Length%, 193), 1, BF
el% = el% - 1
IF el% > 0 THEN                    'go back if lives left
 ''''''''''''''''''''''''''' GET (85, 6)-(565, 120), back&
  LINE (Pad%, 188)-(Pad% + Length%, 193), 0, BF
  Pad% = 305 - Length% / 2
  move% = 1
  CALL Paddle(Pad%, move%, Length%)
  CIRCLE (Xcor%, Ycor%), 6, 0
  CIRCLE (Xcor%, Ycor%), 5, 0
''''''''''''''''''''''''''''  CALL Fade
  LINE (150, 120)-(500, 140), 0, BF
  LINE (150, 120)-(500, 142), 6, B
  LINE (152, 122)-(498, 140), 6, B
  COLOR 14
  LOCATE 17, 32
  PRINT "You lost a ball."
  R = 1
  WHILE INKEY$ = ""
  WEND
''''''''''''''''''''''''''  PUT (85, 6), back&, PSET
  LINE (86, 106)-(565, 200), 0, BF
  GOTO 5
END IF
999          'end of game
LINE (85, 120)-(565, 200), 0, BF
Pad% = 305 - Length% / 2
move% = 1
CALL Paddle(Pad%, move%, Length%)
CALL Fade
CALL Eval(sco!)

SUB Bounce (Xdir%, Ydir%)
'changes bounce angle, with increased likelihood to preserve the angle the
'ball had and to go around 45 degrees
G = INT(RND * 8) + 1
IF G = 1 THEN Xdir% = 4: Ydir% = 2
IF G = 2 THEN Xdir% = 6: Ydir% = 1
IF G = 3 THEN Xdir% = 6: Ydir% = 2
IF G = 4 THEN Xdir% = 2: Ydir% = 3
IF G = 5 THEN Xdir% = 4: Ydir% = 3
IF G = 6 THEN Xdir% = 4: Ydir% = 2
IF G = 7 THEN Xdir% = 4: Ydir% = 3
END SUB

DEFSNG A-Z
SUB Drawball (Xcor%, Ycor%, Xquad%, Yquad%, Xdir%, Ydir%, sco!, speed%, count%, level%)
CIRCLE (Xcor%, Ycor%), 6, 0                     'deletes old ball
CIRCLE (Xcor%, Ycor%), 5, 0
LINE (Xcor% - 4, Ycor% - 1)-(Xcor% + 4, Ycor% + 1), 0, BF
PpX% = Xcor% + Xquad% * (Xdir% + 6)             'border-to-be
PpY% = Ycor% + Yquad% * (Ydir% + 3)
IF POINT(PpX%, Ycor% - 1) > 0 OR POINT(Xcor% - 2, PpY%) > 0 OR POINT(PpX%, Ycor% + 1) > 0 OR POINT(Xcor% + 2, PpY%) > 0 OR POINT(PpX%, PpY%) > 0 THEN
  VirX! = INT((Xcor% + 13) / 20) * 20 - 5   'center of nearest matrix location
  VirY! = INT((Ycor% + 4) / 10) * 10 + 1.5
  A = 0                                    'resets blocks
  B = 0
  C = 0
  'checks left, up, and corner collision combinations
  A = POINT(VirX! + Xquad% * 16, VirY! + .5)
  C = POINT(VirX! + Xquad% * 16, VirY! + Yquad% * 8)
  B = POINT(VirX!, VirY! + Yquad% * 8)
  IF A > 0 AND B > 0 THEN 'waits if there's room for more predictable bounce
    IF POINT(PpX%, Ycor% - 1) = 0 AND POINT(PpX%, Ycor% + 1) = 0 THEN A = 0
    IF POINT(Xcor% - 2, PpY%) = 0 AND POINT(Xcor% + 2, PpY%) = 0 THEN B = 0
    C = 0
  END IF
  'deletes blocks a,b,c if they are in the block field
  ''''''IF VirY! > 180 THEN GOTO 20
  IF A = 2 THEN
    LINE (VirX! + Xquad% * 28, VirY! - 3.5)-(VirX! + Xquad% * 12, VirY! + 3.5), 0, BF
    Scr! = Scr! + speed% / 10
    count% = count% - 1
  END IF
  IF B = 2 THEN
    LINE (VirX! - 8, VirY! + Yquad% * 13.5)-(VirX! + 8, VirY! + Yquad% * 6.5), 0, BF
    Scr! = Scr! + speed% / 10
    count% = count% - 1
  END IF
  IF C = 2 THEN
    LINE (VirX! + Xquad% * 28, VirY! + Yquad% * 13.5)-(VirX! + Xquad% * 12, VirY! + Yquad% * 6.5), 0, BF
    Scr! = Scr! + speed% / 10
    count% = count% - 1
  END IF
20
  IF A > 0 OR C > 0 THEN Xquad% = -Xquad%            'deflections
  IF B > 0 OR C > 0 THEN Yquad% = -Yquad%
  IF A > 0 AND C > 0 THEN Yquad% = -Yquad%
  IF B > 0 AND C > 0 THEN Xquad% = -Xquad%
  IF B = 3 OR C = 3 THEN CALL Bounce(Xdir%, Ydir%)   'new angle
END IF
Xcor% = Xcor% + Xquad% * Xdir%                       'ball moves
Ycor% = Ycor% + Yquad% * Ydir%
CIRCLE (Xcor%, Ycor%), 6, 14                         'draws new ball
CIRCLE (Xcor%, Ycor%), 5, 14
LINE (Xcor% - 4, Ycor% - 1)-(Xcor% + 4, Ycor% + 1), 14, BF  'updates score when it changed to avoid blinking on slow machines
IF Scr! > 0 THEN sco! = sco! + Scr!: Scr! = 0: COLOR 6: LOCATE 11, 1: PRINT INT(sco!): LINE (0, 70)-(0, 90): LOCATE 15, 2: PRINT count%
END SUB

DEFINT A-Z
SUB Eval (sco!)
RANDOMIZE TIMER
LINE (144, 44)-(506, 126), 0, BF
LINE (150, 50)-(500, 120), , B
LINE (152, 52)-(498, 118), , B
LOCATE 9, 25
sco! = INT(sco!)
IF sco! < 200 THEN R = 10
IF sco! > 199 AND sco! < 500 THEN R = 20
IF sco! > 499 AND sco! < 1000 THEN R = 30
IF sco! > 999 AND sco! < 2000 THEN R = 40
IF sco! > 1999 AND sco! < 5000 THEN R = 50
IF sco! > 4999 THEN R = 60
IF sco! < 200 THEN R = R + INT(RND * 5) ELSE R = R + INT(RND * 3)
''''''
COLOR 14
SELECT CASE R
 CASE IS = 10
   PRINT "     You have a long way to go!"
 CASE IS = 11
   PRINT "Move your paddle with the arrow keys."
 CASE IS = 12
   PRINT "Suggestion:  Play with a speed of 2."
 CASE IS = 13
   PRINT "   Try to keep the ball in bounds."
 CASE IS = 14
   PRINT "My dog can play better than that!"
 CASE IS = 20
   PRINT "       That's not so bad!"
 CASE IS = 21
   PRINT "  You must have been practicing!"
 CASE IS = 22
   PRINT "           Good Job!"
 CASE IS = 30
   PRINT "        I am impressed!"
 CASE IS = 31
   PRINT "          Excellent!"
 CASE IS = 32
   PRINT "That was better than my dog, at least."
 CASE IS = 40
   PRINT "        Congratulations!"
 CASE IS = 41
   PRINT "         Fantastoramic!"
 CASE IS = 42
   PRINT "You must've been eating your vitamins!"
 CASE IS = 50
   PRINT "          Superb play!"
 CASE IS = 51
   PRINT "           Atta boy!"
 CASE IS = 52
   PRINT "       You must be a pro!"
 CASE IS = 60
   PRINT "       Are you on steroids?"
 CASE IS = 61
   PRINT " You have the heart of a champion!"
 CASE IS >= 62
   PRINT "Holy maccarel!  You must have played for": LOCATE 10, 22: PRINT "hours!"
END SELECT

LOCATE 11, 30
PRINT "You scored "; sco!; "points."
LOCATE 13, 32
PRINT "Sorry, game over."
WHILE INKEY$ = ""
WEND
COLOR 15
END SUB

SUB Fade
RANDOMIZE TIMER
Scr% = INT(RND * 3)
IF Scr% = 0 THEN GOTO 102
IF Scr% = 1 THEN GOTO 103
101
FOR x = 1 TO 200
FOR Y = 1 TO 100
A = RND * 476 + 87
B = RND * 110 + 7
LINE (A - 2, B - 1)-(A + 2, B + 1), 0, BF
NEXT Y
IF INKEY$ = "q" THEN GOTO 40
NEXT x
GOTO 40

102
FOR x = 1 TO 200
FOR Y = 1 TO 100
A = RND * 476 + 87
B = RND * 110 + 7
CIRCLE (A, B), 2, 0
NEXT Y
IF INKEY$ = "q" THEN GOTO 40
NEXT x
GOTO 40

103                    
LINE (85, 7)-(565, 106), 0, BF
X1 = 89
X2 = 557
Y1 = 9
Y2 = 109
FOR A = 1 TO 13
  LINE (X1, Y1)-(X2 + 3, Y1 - 1), 2, B
Y1 = Y1 + 4
  LINE (X2, Y1 - 4)-(X2 + 3, Y2), 2, BF
X2 = X2 - 8
  LINE (X1, Y2)-(X2 + 7, Y2 - 1), 2, B
IF A = 13 THEN GOTO 105
Y2 = Y2 - 4
  LINE (X1, Y1 - 1)-(X1 + 3, Y2 + 2), 2, BF
LINE (X1 + 4, Y1)-(X1 + 7, Y1 - 1), 2, B
X1 = X1 + 8
NEXT A
105
X1 = 89
X2 = 557
Y1 = 9
Y2 = 109
FOR A = 1 TO 13
  FOR B = X1 TO X2 STEP 4
  LINE (B, Y1)-(B + 3, Y1 - 1), 0, B
    FOR d = 1 TO 999
    NEXT d
  NEXT B
Y1 = Y1 + 4
IF INKEY$ = "q" THEN GOTO 40
  FOR C = Y1 - 2 TO Y2 STEP 2
  LINE (X2, C)-(X2 + 3, C - 1), 0, B
    FOR d = 1 TO 999
    NEXT d
  NEXT C
X2 = X2 - 8
IF INKEY$ = "q" THEN GOTO 40
  FOR B = X2 + 4 TO X1 STEP -4
  LINE (B, Y2)-(B + 3, Y2 - 1), 0, B
    FOR d = 1 TO 999
    NEXT d
  NEXT B
Y2 = Y2 - 4
IF INKEY$ = "q" THEN GOTO 40
  FOR C = Y2 + 2 TO Y1 STEP -2
  LINE (X1, C)-(X1 + 3, C - 1), 0, B
    FOR d = 1 TO 999
    NEXT d
  NEXT C
IF A < 13 THEN LINE (X1 + 4, Y1)-(X1 + 7, Y1 - 1), 0, B
IF INKEY$ = "q" THEN GOTO 40
X1 = X1 + 8
NEXT A
40
END SUB

DEFSNG A-Z
SUB Intro (speed%, igs%, Length%)
SCREEN 8
A = 0
LOCATE 6, 67
COLOR 9
PRINT "BOUNCEBALL!"
COLOR 15
PRINT ""
PRINT "  Try to keep the ball in play until only ten blocks remain.  The ball bounces  off walls, your paddle, and blocks, which are deleted.  Move your paddle with   the right and left arrow keys.  Pause the game with p and end with q.  The scoreis proportional to the speed you select, but you must keep track of your own    high scores.  Press q at any time to end a procedure.  Enter 101 as your speed  for additional help."
PRINT "                                           Programmed by Patrick Petri."
PRINT "                                           This is freeware."
FOR x = 0 TO 85
 FOR Y = 0 TO 6
  LINE (7 * x + 18, 7 * Y + 1)-(7 * x + 24, 7 * Y + 7), POINT(528 + x, 40 + Y), BF
  IF INKEY$ = "q" THEN GOTO 10
 NEXT Y
NEXT x                        'rounds corners
FOR x = 18 TO 613 STEP 7
 FOR Y = 1 TO 43 STEP 7
  IF POINT(x - 1, Y) = 0 AND POINT(x, Y - 1) = 0 THEN CIRCLE (x, Y), 1, 0
  IF POINT(x - 1, Y + 6) = 0 AND POINT(x, Y + 7) = 0 THEN CIRCLE (x, Y + 6), 1, 0
  IF POINT(x + 6, Y - 1) = 0 AND POINT(x + 7, Y) = 0 THEN CIRCLE (x + 6, Y), 1, 0
  IF POINT(x + 6, Y + 7) = 0 AND POINT(x + 7, Y + 6) = 0 THEN CIRCLE (x + 6, Y + 6), 1, 0
  IF INKEY$ = "q" THEN GOTO 10
 NEXT Y
NEXT x
10
PRINT ""
PRINT "Paddle Size:                              ( "; CHR$(17); ", "; CHR$(16); ", any key to select)"
LINE (106, 126)-(234, 136), , B
Length% = 80
65                               'H=UP K=LEFT M=RIGHT   P=DOWN
KEY$ = INKEY$
IF KEY$ = CHR$(0) + "K" AND Length% - 4 > 19 THEN Length% = Length% - 4
IF KEY$ = CHR$(0) + "M" AND Length% + 4 < 121 THEN Length% = Length% + 4
LINE (110, 128)-(110 + Length%, 134), 3, BF
LINE (111 + Length%, 128)-(232, 134), 0, BF
IF KEY$ = "" OR KEY$ = CHR$(0) + "K" OR KEY$ = CHR$(0) + "M" THEN GOTO 65
66
PRINT ""
PRINT ""
WHILE speed! < 1 OR speed! > 100
LOCATE CSRLIN - 1, 38
PRINT "                                           "
LOCATE CSRLIN - 1, 1
INPUT "How fast? (1 to 100, 100 is fastest) ", speed!
IF speed! = 0 THEN speed! = 50: LOCATE CSRLIN - 1, 38: PRINT "50"                      '''''
IF speed! = 101 THEN A = 1
WEND
speed% = speed!
IF A = 1 THEN PRINT "  If your capsule responds sluggishly, try changing your keyboard's repeat rate in the windows control panel.  ...............  It is possible that a blank level is created after level 10, in which case case it is regenerated."
INPUT "Increase game speed during play? ((S)lowly, (Q)uickly, (R)andomly, or ()not)"; igs$
igs% = 0
IF igs$ = "s" OR igs$ = "S" THEN igs% = 1
IF igs$ = "q" OR igs$ = "Q" THEN igs% = 5
IF igs$ = "r" OR igs$ = "R" THEN igs% = 9
END SUB

DEFINT A-Z
SUB Maplevel (level%, count%)
LINE (595, 100)-(628, 115), 1, B
LINE (596, 101)-(627, 114), 0, BF
'level field (600, 103)-(623, 112); locate 14, 76
COLOR 2
LOCATE 14, 76
count% = 0
IF level% = 1 THEN LINE (603, 106)-(620, 112), 1, BF
IF level% = 2 THEN LINE (600, 103)-(623, 112), , B: LINE (603, 106)-(620, 109), , B
IF level% = 3 THEN PRINT "PAP"
IF level% = 4 THEN
  FOR x = 600 TO 622 STEP 4
    LINE (x, 103)-(x + 1, 112), , B
  NEXT x
END IF
IF level% = 5 THEN PRINT CHR$(201); CHR$(186); CHR$(187)
IF level% = 6 THEN
 FOR x = 600 TO 622 STEP 2
  LINE (x, 103)-(x, 112)
 NEXT x
END IF
IF level% = 7 THEN PRINT CHR$(213); CHR$(209); CHR$(184)
IF level% = 8 THEN
 FOR Y = 104 TO 112 STEP 4
  LINE (600, Y)-(623, Y + 1), , B
 NEXT Y
END IF
IF level% = 9 THEN CIRCLE (612.5, 107.5), 10.75, , , , .4

IF level% > 9 THEN PRINT CHR$(INT(RND * 254) + 1); CHR$(INT(RND * 254) + 1); CHR$(INT(RND * 254) + 1)
IF level% > 9 AND level% / 2 = INT(level% / 2) THEN    '65 to 90 are a - z
  LOCATE 14, 76
  PRINT CHR$(INT(RND * 26) + 65); CHR$(INT(RND * 26) + 65); CHR$(INT(RND * 26) + 65)
END IF

'maps from small field
FOR x = 0 TO 23
 FOR Y = 0 TO 9
  IF POINT(x + 600, Y + 103) > 0 THEN LINE (x * 20 + 87, Y * 10 + 8)-(x * 20 + 103, Y * 10 + 15), 2, BF: count% = count% + 1
 NEXT Y
NEXT x
COLOR 15
END SUB

DEFSNG A-Z
SUB Paddle (Pad%, move%, Length%)
IF Pad% + 20 * move% < 85 THEN Pad% = 85 - 20 * move%          'sets Paddle flush with wall
IF Pad% + 20 * move% > 565 - Length% THEN Pad% = 565 - 20 * move% - Length%
  LINE (Pad%, 188)-(Pad% + Length%, 193), 0, BF
  Pad% = Pad% + 20 * move%
  LINE (Pad%, 188)-(Pad% + Length%, 193), 3, BF
move% = 0
END SUB

