DECLARE SUB loadpalette (file$)
DECLARE SUB pal (colour%, r%, g%, b%)
'$DYNAMIC
DECLARE SUB clrkbuffer ()
DECLARE SUB dobullets ()
DECLARE SUB doenemies ()
DECLARE SUB doexplosions ()
DECLARE SUB endbullet (bulletnum%)
DECLARE SUB endexplo (explonum%)
DECLARE SUB inkey ()
DECLARE SUB loadmap (filename$)
DECLARE SUB showbottomwall ()
DECLARE SUB showchar ()
DECLARE SUB showmidwall ()
DECLARE SUB showtopwall ()
DECLARE SUB showwalls ()
'$INCLUDE: 'buffer.bi'

TYPE rgb
	r AS INTEGER
	g AS INTEGER
	b AS INTEGER
END TYPE

TYPE bullet
	x AS INTEGER
	y AS INTEGER
	dir AS INTEGER
END TYPE

TYPE enemy
	x AS INTEGER
	y AS INTEGER
	dir AS INTEGER
	hp AS INTEGER
END TYPE

TYPE explosion
	x AS INTEGER
	y AS INTEGER
	frame AS INTEGER
END TYPE


SCREEN 13


DIM SHARED map(0, 0) AS INTEGER
DIM SHARED colors(255) AS rgb
DIM SHARED bullets(0, 0) AS INTEGER
DIM SHARED exps(0, 0) AS INTEGER
DIM SHARED bullet(0) AS bullet
DIM SHARED enemies(0) AS enemy
DIM SHARED explosions(0) AS explosion
DIM SHARED xpos AS INTEGER
DIM SHARED ypos AS INTEGER
DIM SHARED xmap AS INTEGER
DIM SHARED ymap AS INTEGER
DIM SHARED size AS INTEGER
DIM SHARED mxsize AS INTEGER
DIM SHARED mysize AS INTEGER
DIM SHARED rgbval AS STRING * 1
DIM SHARED stepnum AS INTEGER
DIM SHARED dir AS INTEGER
DIM SHARED stepsize AS INTEGER
DIM SHARED maxshots AS INTEGER
DIM SHARED shots AS INTEGER
DIM SHARED bstep AS INTEGER
DIM SHARED numenemies AS INTEGER
DIM SHARED numexplosions AS INTEGER
DIM SHARED expsize AS INTEGER
DIM SHARED frames AS INTEGER

RANDOMIZE TIMER

xpos = 10
ypos = 10

loadmap "2dgame.map"

binit 320, 200
PUT (0, 0), buffer%, PSET

READ maxshots, bstep
REDIM bullet(maxshots) AS bullet

REDIM bullets(42, 7) AS INTEGER
DEF SEG = VARSEG(bullets(0, 0))
BLOAD "bullet.put", 0
DEF SEG

expsize = 4
REDIM exps(42, 5) AS INTEGER
DEF SEG = VARSEG(exps(0, 0))
BLOAD "explo.put", 0
DEF SEG

READ numenemies
REDIM enemies(1 TO numenemies) AS enemy
FOR n% = 1 TO numenemies
	DO
		x% = INT(RND * 10) + 1
		y% = INT(RND * 10) + 1
	LOOP WHILE map(y%, x%) = 1
	enemies(n%).x = x% * 10
	enemies(n%).y = y% * 10
	enemies(n%).hp = 16
NEXT n%

READ maxexplosions
REDIM explosions(maxexplosions) AS explosion

loadpalette "2dgame.pal"

stepnum = 0
dir = 2

DEF SEG = VARSEG(buffer%(2))
offset = VARPTR(buffer%(2))
bclear
time1& = INT(TIMER)
time2# = TIMER * 1# - time1& * 1#
DO
	showwalls
	a = INP(&H60)
	IF a = 1 THEN
		END
	ELSEIF a = 72 THEN
		dir = 0
		IF map(ypos / 10 + 1 - 1, xpos / 10 + 1) = 0 THEN
			FOR m% = 1 TO 10
				IF m% MOD 2 THEN stepnum = stepnum + 1
				clrkbuffer
				ypos = ypos - 1
				showwalls
			NEXT m%
		END IF
	ELSEIF a = 80 THEN
		dir = 2
		IF map(ypos / 10 + 1 + 1, xpos / 10 + 1) = 0 THEN
			FOR m% = 1 TO 10
				IF m% MOD 2 THEN stepnum = stepnum + 1
				clrkbuffer
				ypos = ypos + 1
				showwalls
			NEXT m%
		END IF
	ELSEIF a = 75 THEN
		dir = 3
		IF map(ypos / 10 + 1, xpos / 10 + 1 - 1) = 0 THEN
			FOR m% = 1 TO 10
				IF m% MOD 2 THEN stepnum = stepnum + 1
				clrkbuffer
				xpos = xpos - 1
				showwalls
			NEXT m%
		END IF
	ELSEIF a = 77 THEN
		dir = 1
		IF map(ypos / 10 + 1, xpos / 10 + 1 + 1) = 0 THEN
			FOR m% = 1 TO 10
				IF m% MOD 2 THEN stepnum = stepnum + 1
				clrkbuffer
				xpos = xpos + 1
				showwalls
			NEXT m%
		END IF
	ELSEIF a = 57 THEN
		IF shots < maxshots THEN
			shots = shots + 1
			bullet(shots).dir = dir
			SELECT CASE dir
				CASE 0
					bullet(shots).x = xpos + 10
					bullet(shots).y = ypos + bstep + 10
				CASE 1
					bullet(shots).x = xpos - bstep + 10
					bullet(shots).y = ypos + 10
				CASE 2
					bullet(shots).x = xpos + 10
					bullet(shots).y = ypos - bstep + 10
				CASE 3
					bullet(shots).x = xpos + bstep + 10
					bullet(shots).y = ypos + 10
			END SELECT
		END IF
	ELSEIF a = 44 THEN
		LOCATE 1, 1: PRINT frames / (TIMER - time1& - time2#)
		showwalls
	ELSE
		showwalls
	END IF
	clrkbuffer
LOOP


DATA 100,2

DATA 5,100

REM $STATIC
DEFINT A-Z
SUB clrkbuffer

DEF SEG = &H40
POKE &H1A, PEEK(&H1C)

END SUB

SUB dobullets

IF shots = 0 THEN EXIT SUB
FOR b% = shots TO 1 STEP -1
	x% = bullet(b%).x
	y% = bullet(b%).y
	bdir% = bullet(b%).dir
	btile% = bdir%
	SELECT CASE bdir%
		CASE 0: y% = y% - bstep
		CASE 1: x% = x% + bstep
		CASE 2: y% = y% + bstep
		CASE 3: x% = x% - bstep
	END SELECT
	bullet(b%).x = x%
	bullet(b%).y = y%
	bput x% - xpos + 160 - 14, y% - ypos + 100 - 14, VARSEG(bullets(0, btile%)), VARPTR(bullets(0, btile%)), 0
	IF y% MOD 10 = 0 AND x% MOD 10 = 0 THEN
		SELECT CASE bdir%
			CASE 0: mtest% = map(y% / 10 - 1, x% / 10)
			CASE 1: mtest% = map(y% / 10, x% / 10 + 1)
			CASE 2: mtest% = map(y% / 10 + 1, x% / 10)
			CASE 3: mtest% = map(y% / 10, x% / 10 - 1)
		END SELECT
		IF mtest% = 1 THEN
			endbullet b%
		END IF
	ELSE
		SELECT CASE bdir%
			CASE 0
				xtest1% = x%
				ytest1% = y%
				xtest2% = x% + 7
				ytest2% = y%
			CASE 1
				xtest1% = x% + 7
				ytest1% = y%
				xtest2% = x% + 7
				ytest2% = y% + 7
			CASE 2
				xtest1% = x%
				ytest1% = y% + 7
				xtest2% = x% + 7
				ytest2% = y% + 7
			CASE 3
				xtest1% = x%
				ytest1% = y%
				xtest2% = x%
				ytest2% = y% + 7
		END SELECT
		FOR n% = 1 TO numenemies
			x2% = enemies(n%).x
			y2% = enemies(n%).y
			x3% = x2% + 6
			y3% = y2% + 6
			IF xtest1% <= x3% AND ytest1% <= y3% AND xtest2% >= x2% AND ytest2% >= y2% THEN
				enemies(n%).hp = enemies(n%).hp - 1
				numexplosions = numexplosions + 1
				explosions(numexplosions).x = x2%
				explosions(numexplosions).y = y2%
				explosions(numexplosions).frame = 0
				endbullet b%
				EXIT FOR
			END IF
		NEXT n%
	END IF
NEXT b%

END SUB

DEFSNG A-Z
SUB doenemies

FOR n% = 1 TO numenemies
	IF enemies(n%).hp < 0 THEN
		enemies(n%).hp = 16
		DO
			x% = INT(RND * 10) + 1
			y% = INT(RND * 10) + 1
		LOOP WHILE map(y%, x%) = 1
		enemies(n%).x = x% * 10
		enemies(n%).y = y% * 10
	END IF
	x% = enemies(n%).x
	y% = enemies(n%).y
	edir% = enemies(n%).dir
	SELECT CASE edir%
		CASE 1: y% = y% - 1
		CASE 2: x% = x% + 1
		CASE 3: y% = y% + 1
		CASE 4: x% = x% - 1
	END SELECT
	IF x% MOD 10 = 0 AND y% MOD 10 = 0 THEN
		DO
			x2% = x% / 10
			y2% = y% / 10
			edir% = INT(RND * 4) + 1
			SELECT CASE edir%
				CASE 1: y2% = y2% - 1
				CASE 2: x2% = x2% + 1
				CASE 3: y2% = y2% + 1
				CASE 4: x2% = x2% - 1
			END SELECT
		LOOP UNTIL map(y2%, x2%) = 0
	END IF
	IF ABS(x% - xpos) < 75 AND ABS(y% - ypos) < 75 THEN
		x1% = x% - xpos + 160 - 13
		y1% = y% - ypos + 100 - 13
		blineb x1%, y1%, x1% + 6, y1% + 6, 111 + enemies(n%).hp
	END IF
	enemies(n%).x = x%
	enemies(n%).y = y%
	enemies(n%).dir = edir%
NEXT n%

END SUB

SUB doexplosions

FOR e% = numexplosions TO 1 STEP -1
	x% = explosions(numexplosions).x
	y% = explosions(numexplosions).y
	frame% = explosions(numexplosions).frame
	bput x% - xpos + 160 - 10 - expsize, y% - ypos + 100 - 10 - expsize, VARSEG(exps(0, frame%)), VARPTR(exps(0, frame%)), 0
	IF frame% = 5 THEN
		endexplo e%
	ELSE
		explosions(numexplosions).frame = frame% + 1
	END IF
NEXT e%

END SUB

SUB endbullet (bulletnum%)

shots = shots - 1
FOR b% = bulletnum% TO shots
	bullet(b%).x = bullet(b% + 1).x
	bullet(b%).y = bullet(b% + 1).y
	bullet(b%).dir = bullet(b% + 1).dir
NEXT

END SUB

SUB endexplo (explonum%)

numexplosions = numexplosions - 1
FOR e% = explonum% TO numexplosions
	explosions(e%).x = explosions(e% + 1).x
	explosions(e%).y = explosions(e% + 1).y
	explosions(e%).frame = explosions(e% + 1).frame
NEXT

END SUB

DEFINT A-Z
'Waits for a keypress
'
SUB inkey

DO
LOOP UNTIL INKEY$ <> ""

END SUB

SUB loadmap (filename$)

OPEN filename$ FOR INPUT AS 1
INPUT #1, mxsize, mysize
REDIM map(1 TO mysize, 1 TO mxsize) AS INTEGER
FOR y% = 1 TO mysize
	FOR x% = 1 TO mxsize
		INPUT #1, map(y%, x%)
	NEXT x%
NEXT y%
CLOSE 1

END SUB

SUB loadpalette (file$)

OPEN file$ FOR BINARY AS #1
FOR colour% = 0 TO 255
		GET #1, , rgbval
		colors(colour%).r = ASC(rgbval)
		GET #1, , rgbval
		colors(colour%).g = ASC(rgbval)
		GET #1, , rgbval
		colors(colour%).b = ASC(rgbval)
		pal colour%, colors(colour%).r, colors(colour%).g, colors(colour%).b
  NEXT
CLOSE #1

END SUB

SUB pal (colour%, r%, g%, b%)

OUT &H3C8, colour%
OUT &H3C9, r%
OUT &H3C9, g%
OUT &H3C9, b%

END SUB

DEFSNG A-Z
SUB showbottomwall

FOR y% = INT(ypos / 10) + 1 - 5 TO INT(ypos / 10) + 1 + 5
	IF y% > 1 AND y% < mysize THEN
		FOR x% = INT(xpos / 10) + 1 - 5 TO INT(xpos / 10) + 1 + 5
			IF x% > 1 AND x% < mxsize THEN
				IF map(y%, x%) = 0 THEN
					m1% = map(y% - 1, x% - 1)
					m2% = map(y% - 1, x%)
					m3% = map(y% - 1, x% + 1)
					m4% = map(y%, x% - 1)
					m6% = map(y%, x% + 1)
					m7% = map(y% + 1, x% - 1)
					m8% = map(y% + 1, x%)
					m9% = map(y% + 1, x% + 1)
					x11% = 10 * x% - xpos + 160 - 15
					y11% = 10 * y% - ypos + 100 - 15
					x12% = x11% + 10
					y12% = y11% + 10
					IF m4% = 1 THEN bvline y11%, y12%, x11%, 23
					IF m2% = 1 THEN bhline x11%, x12%, y11%, 23
					IF m8% = 1 THEN bhline x11%, x12%, y12%, 23
					IF m6% = 1 THEN bvline y11%, y12%, x12%, 23
				END IF
			END IF
		NEXT x%
	END IF
NEXT y%

END SUB

SUB showchar

blineb 160 - 3, 100 - 3, 160 + 3, 100 + 3, 9

END SUB

SUB showmidwall

FOR y% = INT(ypos / 10) + 1 - 5 TO INT(ypos / 10) + 1 + 5
	IF y% > 1 AND y% < mysize THEN
		FOR x% = INT(xpos / 10) + 1 - 5 TO INT(xpos / 10) + 1 + 5
			IF x% > 1 AND x% < mxsize THEN
				IF map(y%, x%) = 0 THEN
					m1% = map(y% - 1, x% - 1)
					m2% = map(y% - 1, x%)
					m3% = map(y% - 1, x% + 1)
					m4% = map(y%, x% - 1)
					m6% = map(y%, x% + 1)
					m7% = map(y% + 1, x% - 1)
					m8% = map(y% + 1, x%)
					m9% = map(y% + 1, x% + 1)
					x11% = 10 * x% - xpos + 160 - 15
					y11% = 10 * y% - ypos + 100 - 15
					x12% = x11% + 10
					y12% = y11% + 10
					x21% = 14 * x% - (xpos + 15) * 1.4 + 160
					y21% = 14 * y% - (ypos + 15) * 1.4 + 100
					x22% = x21% + 14
					y22% = y21% + 14
					IF m2% = m4% THEN
						IF m2% = 1 OR (m1% = 1 AND m2% = 0) THEN bline x11%, y11%, x21%, y21%, 27
					END IF
					IF m2% = m6% THEN
						IF m2% = 1 OR (m3% = 1 AND m2% = 0) THEN bline x12%, y11%, x22%, y21%, 27
					END IF
					IF m4% = m8% THEN
						IF m4% = 1 OR (m7% = 1 AND m4% = 0) THEN bline x11%, y12%, x21%, y22%, 27
					END IF
					IF m6% = m8% THEN
						IF m6% = 1 OR (m9% = 1 AND m6% = 0) THEN bline x12%, y12%, x22%, y22%, 27
					END IF
				END IF
			END IF
		NEXT x%
	END IF
NEXT y%

END SUB

SUB showtopwall

FOR y% = INT(ypos / 10) + 1 - 5 TO INT(ypos / 10) + 1 + 5
	IF y% > 1 AND y% < mysize THEN
		FOR x% = INT(xpos / 10) + 1 - 5 TO INT(xpos / 10) + 1 + 5
			IF x% > 1 AND x% < mxsize THEN
				IF map(y%, x%) = 0 THEN
					m1% = map(y% - 1, x% - 1)
					m2% = map(y% - 1, x%)
					m3% = map(y% - 1, x% + 1)
					m4% = map(y%, x% - 1)
					m6% = map(y%, x% + 1)
					m7% = map(y% + 1, x% - 1)
					m8% = map(y% + 1, x%)
					m9% = map(y% + 1, x% + 1)
					x21% = 14 * x% - (xpos + 15) * 1.4 + 160
					y21% = 14 * y% - (ypos + 15) * 1.4 + 100
					x22% = x21% + 14
					y22% = y21% + 14
					IF m4% = 1 THEN bvline y21%, y22%, x21%, 31
					IF m2% = 1 THEN bhline x21%, x22%, y21%, 31
					IF m8% = 1 THEN bhline x21%, x22%, y22%, 31
					IF m6% = 1 THEN bvline y21%, y22%, x22%, 31
				END IF
			END IF
		NEXT x%
	END IF
NEXT y%

END SUB

DEFINT A-Z
SUB showwalls

frames = frames + 1
bclear

showbottomwall
dobullets
doenemies
doexplosions
showchar
showmidwall
showtopwall

PUT (0, 0), buffer%, PSET

END SUB

