'$STATIC
DEFINT A-Z

DECLARE FUNCTION Adlib% ()
DECLARE FUNCTION LoadFX% (FileName$)
DECLARE SUB PlayFX (Num%)
DECLARE SUB StarField ()
DECLARE FUNCTION PlayGame% ()
DECLARE FUNCTION MouseInit% ()
DECLARE SUB MouseStatus (PosX%, PosY%, Buttons%)
 
DIM SHARED WinDistance, MaxDistance&, WinDestroy, MaxDestroy
DIM SHARED ShieldC, Hunter, SndAvail, Score

DIM SHARED Ship(4517) AS INTEGER
DIM SHARED SMsk(4517) AS INTEGER
DIM SHARED Enemy(377) AS INTEGER

DIM SHARED StarsX(49) AS INTEGER
DIM SHARED StarsY(49) AS INTEGER
DIM SHARED StarsC(49) AS INTEGER

DIM SHARED WeaponX(9) AS INTEGER
DIM SHARED WeaponY(9) AS INTEGER
DIM SHARED WeaponF(9) AS INTEGER

DIM SHARED EnemyX(9) AS INTEGER
DIM SHARED EnemyY(9) AS INTEGER
DIM SHARED EnemyA(9) AS INTEGER

DIM SHARED ExploX(9) AS INTEGER
DIM SHARED ExploY(9) AS INTEGER
DIM SHARED ExploA(9) AS INTEGER

DIM SHARED EFireX(9) AS INTEGER
DIM SHARED EFireY(9) AS INTEGER
DIM SHARED EFireF(9) AS INTEGER

DIM SHARED Snd(1 TO 4) AS STRING * 30

DIM MessageTxt AS STRING * 40

CLS

COLOR 15, 4
PRINT "   YAS (Yet Another Shooter) v1.0 - Leandro Pardini 1998 - lpardini@cefex.com   "

COLOR 14, 0
PRINT "Initializing mouse...";
IF MouseInit = 0 THEN
   PRINT "Failed!"
   COLOR 7, 0
   SYSTEM
END IF
PRINT "Done"
PRINT "Initializing sound card...";
IF Adlib THEN
   PRINT "Done"
   PRINT "Loading sounds...";
   SndAvail = -1
   Init = LoadFX("YAS.SND")
   IF Init THEN
      PRINT "Done"
   ELSE
      PRINT "Failed!"
   END IF
ELSE
   PRINT "Failed!"
END IF
PRINT "Loading images...";
OPEN "YAS.IMG" FOR BINARY ACCESS READ AS #1
FOR Init = 0 TO 4517
   GET #1, , Ship(Init)
NEXT Init
FOR Init = 0 TO 4517
   GET #1, , SMsk(Init)
NEXT Init
FOR Init = 0 TO 377
   GET #1, , Enemy(Init)
NEXT Init
CLOSE #1
FOR Init = 0 TO 49
   StarsX(Init) = RND * 320
   StarsY(Init) = RND * 200
   StarsC(Init) = RND * 3 + 1
NEXT Init
PRINT "Done"

MenuOpt = 1

SCREEN 7, , 1, 0
DO
   LINE (0, 0)-(319, 199), 0, BF
   LOCATE 1, 1
   COLOR 11
   PRINT "Shields: 100.00%";
   LOCATE 1, 31
   PRINT USING "Score: ###"; Score;
   LOCATE 6, 11
   COLOR 13
   PRINT "YET ANOTHER SHOOTER";
   LOCATE 18, 1
   PRINT MessageTxt
   SELECT CASE INKEY$
      CASE CHR$(0) + "H"
         IF SndAvail THEN PlayFX 1
         MenuOpt = MenuOpt - 1
         IF MenuOpt = 0 THEN MenuOpt = 5
      CASE CHR$(0) + "P"
         IF SndAvail THEN PlayFX 1
         MenuOpt = MenuOpt + 1
         IF MenuOpt = 6 THEN MenuOpt = 1
      CASE CHR$(13)
      SELECT CASE MenuOpt
      CASE 1
         WinDistance = -1
         MaxDistance& = 10000
         WinDestroy = -1
         MaxDestroy = 250
         ShieldC = 5
         Hunter = 0
         IF PlayGame THEN
            MessageTxt = "      YOU WIN... THE *EASY* GAME      "
         ELSE
            MessageTxt = " YOU LOST?! EVEN A BABY CAN WIN THIS! "
         END IF
      CASE 2
         WinDistance = -1
         MaxDistance& = 20000
         WinDestroy = -1
         MaxDestroy = 500
         ShieldC = 2
         Hunter = 1
         IF PlayGame THEN
            MessageTxt = "      YOU WIN! TRY THE HARD GAME!     "
         ELSE
            MessageTxt = " YOU LOST.. BETTER PLAY THE EASY GAME "
         END IF
      CASE 3
         WinDistance = 0
         MaxDistance& = 0
         WinDestroy = -1
         MaxDestroy = 1000
         ShieldC = 1
         Hunter = 3
         IF PlayGame THEN
            MessageTxt = "    WOW!! YOU WIN THE HARD GAME!!!    "
         ELSE
            MessageTxt = "YOU LOST!! BETTER PLAY THE NORMAL GAME"
         END IF
      CASE 4
         WinDistance = 0
         MaxDistance& = 0
         WinDestroy = -1
         MaxDestroy = 2000
         ShieldC = 0
         Hunter = 5
         IF PlayGame THEN
            MessageTxt = "   I CAN'T BELIEVE IT!!! YOU WIN!!!   "
         ELSE
            MessageTxt = "        YOU LOST... OBVIOUSLY.        "
         END IF
      CASE 5
         IF SndAvail THEN PlayFX 3
         EXIT DO
      END SELECT
   END SELECT
   LOCATE 10, 13
   IF MenuOpt = 1 THEN COLOR 14 ELSE COLOR 6
   PRINT "START EASY GAME"
   LOCATE 11, 12
   IF MenuOpt = 2 THEN COLOR 14 ELSE COLOR 6
   PRINT "START NORMAL GAME"
   LOCATE 12, 13
   IF MenuOpt = 3 THEN COLOR 14 ELSE COLOR 6
   PRINT "START HARD GAME"
   LOCATE 13, 10
   IF MenuOpt = 4 THEN COLOR 14 ELSE COLOR 6
   PRINT "START IMPOSSIBLE GAME"
   LOCATE 14, 18
   IF MenuOpt = 5 THEN COLOR 14 ELSE COLOR 6
   PRINT "QUIT"
   StarField
   MouseStatus ShipX, ShipY, ShipB
   IF ShipX < 0 THEN ShipX = 0
   IF ShipX > 244 THEN ShipX = 244
   IF ShipY < 0 THEN ShipY = 0
   IF ShipY > 174 THEN ShipY = 174
   PUT (ShipX, ShipY), Ship, XOR
   PUT (ShipX, ShipY), SMsk, AND
   PUT (ShipX, ShipY), Ship, XOR
   PCOPY 1, 0
LOOP
SCREEN 0
WIDTH 80
CLS
COLOR 15, 4
PRINT "   YAS (Yet Another Shooter) v1.0 - Leandro Pardini 1998 - lpardini@cefex.com   "
COLOR 7, 0
SYSTEM

FUNCTION Adlib%
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H60: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H80: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
Astat1 = INP(&H388)
OUT &H388, &H2: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &HFF: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H21: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
Astat2 = INP(&H388)
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H60: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
OUT &H388, &H4: FOR A7 = 1 TO 6: A11 = INP(&H388): NEXT
OUT &H389, &H80: FOR A7 = 1 TO 35: A11 = INP(&H388): NEXT
Ares1 = Astat1 AND &HE0: Ares2 = Astat2 AND &HE0
Adlib% = 0: IF Ares1 = 0 AND Ares2 = 192 THEN Adlib% = -1
END FUNCTION

FUNCTION LoadFX (FileName$)
'
' This routine loads specified sound file.
'
OPEN FileName$ FOR BINARY AS #1
IF LOF(1) = 0 THEN LoadFX = 0: CLOSE #1: EXIT FUNCTION
DIM id AS STRING * 4
GET #1, , id
IF MID$(id, 1, 2) <> "SL" THEN LoadFX = 1: CLOSE #1: EXIT FUNCTION
IF MID$(id, 3, 2) <> "10" THEN LoadFX = 2: CLOSE #1: EXIT FUNCTION
GET #1, , NumSound
FOR i = 1 TO NumSound
  GET #1, , Snd(i)
  temp$ = SPACE$(20)
  GET #1, , temp$
NEXT i
CLOSE #1
LoadFX = -1

END FUNCTION

FUNCTION MouseInit%
   DIM Asm AS STRING * 14
   MID$(Asm, 1, 3) = CHR$(184) + CHR$(0) + CHR$(0)
   MID$(Asm, 4, 2) = CHR$(205) + CHR$(51)
   MID$(Asm, 6, 3) = CHR$(104) + MKI$(VARSEG(MouseInit%))
   MID$(Asm, 9, 2) = CHR$(31) + CHR$(62)
   MID$(Asm, 11, 3) = CHR$(163) + MKI$(VARPTR(MouseInit%))
   MID$(Asm, 14, 1) = CHR$(203)
   DEF SEG = VARSEG(Asm): CALL ABSOLUTE(VARPTR(Asm)): DEF SEG
END FUNCTION

SUB MouseStatus (PosX%, PosY%, Buttons%)
   DIM Asm AS STRING * 33
   MID$(Asm, 1, 3) = CHR$(184) + CHR$(3) + CHR$(0)
   MID$(Asm, 4, 2) = CHR$(205) + CHR$(51)
   MID$(Asm, 6, 3) = CHR$(104) + MKI$(VARSEG(Buttons%))
   MID$(Asm, 9, 2) = CHR$(31) + CHR$(62)
   MID$(Asm, 11, 4) = CHR$(137) + CHR$(30) + MKI$(VARPTR(Buttons%))
   MID$(Asm, 15, 3) = CHR$(104) + MKI$(VARSEG(PosY%))
   MID$(Asm, 18, 2) = CHR$(31) + CHR$(62)
   MID$(Asm, 20, 4) = CHR$(137) + CHR$(22) + MKI$(VARPTR(PosY%))
   MID$(Asm, 24, 3) = CHR$(104) + MKI$(VARSEG(PosX%))
   MID$(Asm, 27, 2) = CHR$(31) + CHR$(62)
   MID$(Asm, 29, 4) = CHR$(137) + CHR$(14) + MKI$(VARPTR(PosX%))
   MID$(Asm, 33, 1) = CHR$(203)
   DEF SEG = VARSEG(Asm): CALL ABSOLUTE(VARPTR(Asm)): DEF SEG
END SUB

SUB PlayFX (Num)
'
' Plays specified FX num.
'
FOR i = 1 TO 15
  OUT &H388, ASC(MID$(Snd(Num), (i * 2) - 1, 1))
  FOR ii = 1 TO 6: temp = INP(&H388): NEXT ii
  OUT &H389, ASC(MID$(Snd(Num), (i * 2)))
  FOR ii = 1 TO 35: temp = INP(&H388): NEXT ii
NEXT i

END SUB

FUNCTION PlayGame
Alive = -1
CanR = -1
EnemyC = 10
Shields = 10000
Distance& = 1

FOR Init = 0 TO 9
   EnemyX(Init) = (RND * 100) + 209
   EnemyY(Init) = (RND * 160) + 20
   EnemyA(Init) = -1
NEXT Init

DO
   LINE (0, 0)-(319, 199), 0, BF
   LOCATE 1, 1
   IF Shields > 7500 THEN
      COLOR 11
   ELSEIF Shields > 2500 THEN
      COLOR 14
   ELSE
      COLOR 12
   END IF
   PRINT USING "Shields: ###.##%"; Shields / 100;
   Score = (Destroy / Distance&) * 1000
   LOCATE 1, 31
   PRINT USING "Score: ###"; Score;
   StarField
   IF Alive THEN MouseStatus ShipX, ShipY, ShipB
   IF ShipX < 0 THEN ShipX = 0
   IF ShipX > 244 THEN ShipX = 244
   IF ShipY < 0 THEN ShipY = 0
   IF ShipY > 174 THEN ShipY = 174
   IF Alive THEN
   IF ShipB = 1 THEN
      IF Charge = 5 THEN
      FOR SeekW = 0 TO 9
         IF WeaponF(SeekW) = 0 THEN
            IF SndAvail THEN PlayFX 1
            WeaponF(SeekW) = -1
            WeaponX(SeekW) = ShipX + 39
            WeaponY(SeekW) = ShipY + 22
            Charge = 0
            EXIT FOR
         END IF
      NEXT SeekW
      END IF
   ELSE
      IF Alive THEN
         IF Shields < 10000 THEN Shields = Shields + ShieldC
         IF Shields > 10000 THEN Shields = 10000
      ELSE
         Shields = 0
      END IF
   END IF
   END IF
   IF Charge < 5 THEN Charge = Charge + 1
   FOR Move = 0 TO 9
      IF WeaponF(Move) THEN
         PSET (WeaponX(Move) - 1, WeaponY(Move)), 12
         PSET (WeaponX(Move) + 1, WeaponY(Move)), 12
         PSET (WeaponX(Move), WeaponY(Move) - 1), 12
         PSET (WeaponX(Move), WeaponY(Move) + 1), 12
         PSET (WeaponX(Move), WeaponY(Move)), 14
         WeaponX(Move) = WeaponX(Move) + 5
         IF WeaponX(Move) > 319 THEN WeaponF(Move) = 0
         FOR Init = 0 TO 9
            IF EnemyA(Init) THEN
            IF WeaponX(Move) > EnemyX(Init) THEN
               IF WeaponX(Move) < EnemyX(Init) + 10 THEN
                  IF WeaponY(Move) > EnemyY(Init) THEN
                     IF WeaponY(Move) < EnemyY(Init) + 10 THEN
                        ExploX(Move) = EnemyX(Init)
                        ExploY(Move) = EnemyY(Init)
                        ExploA(Move) = 1
                        IF CanR THEN
                           EnemyX(Init) = 309
                           EnemyY(Init) = (RND * 160) + 20
                        ELSE
                           EnemyA(Init) = 0
                           EnemyC = EnemyC - 1
                        END IF
                        WeaponF(Move) = 0
                        IF SndAvail THEN PlayFX 4
                        Destroy = Destroy + 1
                     END IF
                  END IF
               END IF
            END IF
            END IF
         NEXT Init
      END IF
   NEXT Move
   FOR Move = 0 TO 9
      IF EnemyA(Move) THEN
      EnemyX(Move) = EnemyX(Move) - 2
      IF EnemyX(Move) < 0 THEN
         IF CanR THEN
            EnemyX(Move) = 309
            EnemyY(Move) = (RND * 160) + 20
         ELSE
            EnemyA(Move) = 0
            EnemyC = EnemyC - 1
         END IF
      END IF
      IF ExploA(Move) > 0 THEN
         PUT (ExploX(Move), ExploY(Move)), Enemy(ExploA(Move) * 42), PSET
         ExploA(Move) = ExploA(Move) + 1
         IF ExploA(Move) = 9 THEN ExploA(Move) = 0
         ExploX(Move) = ExploX(Move) - 2
         IF ExploX(Move) < 0 THEN ExploA(Move) = 0
      END IF
      IF Alive THEN
      IF EnemyY(Move) + 10 > ShipY THEN
         IF EnemyY(Move) < ShipY + 25 THEN
            IF EnemyX(Move) + 10 > ShipX THEN
               IF EnemyX(Move) < ShipX + 75 THEN
                  Shields = Shields - 500
                  ShieldA = -1
                  ExploX(Move) = EnemyX(Move)
                  ExploY(Move) = EnemyY(Move)
                  ExploA(Move) = 1
                  IF CanR THEN
                     EnemyX(Move) = 309
                     EnemyY(Move) = (RND * 160) + 20
                  ELSE
                     EnemyA(Move) = 0
                     EnemyC = EnemyC - 1
                  END IF
                  IF SndAvail THEN PlayFX 4
                  Destroy = Destroy + 1
               ELSE
                  IF EFireF(Move) = 0 THEN
                     IF SndAvail THEN PlayFX 2
                     EFireF(Move) = -1
                     EFireX(Move) = EnemyX(Move)
                     EFireY(Move) = EnemyY(Move) + 5
                  END IF
               END IF
            END IF
         END IF
      END IF
      END IF
      IF EFireX(Move) > ShipX THEN
         IF EFireX(Move) < ShipX + 75 THEN
            IF EFireY(Move) > ShipY THEN
               IF EFireY(Move) < ShipY + 25 THEN
                  Shields = Shields - 10
                  ShieldA = -1
               END IF
            END IF
         END IF
      END IF
      END IF
      IF EnemyA(Move) THEN PUT (EnemyX(Move), EnemyY(Move)), Enemy, PSET
   NEXT Move
   FOR Init = 0 TO 9
      IF EFireF(Init) = -1 THEN
         EFireX(Init) = EFireX(Init) - 20
         IF Hunter > 0 AND Alive THEN
            IF EFireY(Init) < ShipY + 12 THEN EFireY(Init) = EFireY(Init) + Hunter
            IF EFireY(Init) > ShipY + 12 THEN EFireY(Init) = EFireY(Init) - Hunter
         END IF
         IF EFireX(Init) < 0 THEN EFireF(Init) = 0
         LINE (EFireX(Init), EFireY(Init) - 1)-(EFireX(Init) + 20, EFireY(Init) - 1), 6
         LINE (EFireX(Init), EFireY(Init))-(EFireX(Init) + 20, EFireY(Init)), 14
         LINE (EFireX(Init), EFireY(Init) + 1)-(EFireX(Init) + 20, EFireY(Init) + 1), 6
      END IF
   NEXT Init
   Distance& = Distance& + 1
   IF WinDistance THEN
      IF Distance& = MaxDistance& THEN CanR = 0
   END IF
   IF WinDestroy THEN
      IF Destroy = MaxDestroy THEN CanR = 0
   END IF
   IF EnemyC = 0 THEN
      IF Alive THEN
         PlayGame = -1
         EXIT DO
      ELSE
         IF CanQuit THEN
            PlayGame = 0
            EXIT DO
         END IF
      END IF
   END IF
   IF Shields < 0 THEN
      IF SndAvail THEN PlayFX 3
      SExplo = 1
      Alive = 0
      CanR = 0
      Shields = 0
   END IF
   IF ShieldA THEN
      ShieldA = 0
      IF Shields > 7500 THEN
         CIRCLE (ShipX + 30, ShipY + 12), 50, 11, , , .35
      ELSEIF Shields > 2500 THEN
         CIRCLE (ShipX + 30, ShipY + 12), 50, 14, , , .35
      ELSE
         CIRCLE (ShipX + 30, ShipY + 12), 50, 12, , , .35
      END IF
   END IF
   IF Alive THEN
      PUT (ShipX, ShipY), Ship, XOR
      PUT (ShipX, ShipY), SMsk, AND
      PUT (ShipX, ShipY), Ship, XOR
   END IF
   IF SExplo > 0 THEN
      PUT (ShipX, ShipY), Ship(SExplo * 502), XOR
      PUT (ShipX, ShipY), SMsk(SExplo * 502), AND
      PUT (ShipX, ShipY), Ship(SExplo * 502), XOR
      IF Change THEN SExplo = SExplo + 1
      Change = NOT Change
      IF SExplo = 9 THEN SExplo = 0: CanQuit = -1
   END IF
   PCOPY 1, 0
LOOP
END FUNCTION

SUB StarField
   FOR Stars = 0 TO 49
      StarsX(Stars) = StarsX(Stars) - StarsC(Stars)
      IF StarsX(Stars) < 0 THEN
         StarsX(Stars) = 319
         StarsY(Stars) = RND * 200
         StarsC(Stars) = RND * 3 + 1
      END IF
      SELECT CASE StarsC(Stars)
         CASE 1
            PSET (StarsX(Stars), StarsY(Stars)), 8
         CASE 2
            PSET (StarsX(Stars), StarsY(Stars)), 7
            PSET (StarsX(Stars) + 1, StarsY(Stars)), 8
         CASE 3
            PSET (StarsX(Stars), StarsY(Stars)), 15
            PSET (StarsX(Stars) + 1, StarsY(Stars)), 7
            PSET (StarsX(Stars) + 2, StarsY(Stars)), 8
      END SELECT
   NEXT Stars
END SUB

