{**************************************************************************}
{              㠫쭠 ॠ쭮. ⥬⨪                          }
{                CopyRight (c) 1997 by AVK_SOFT                            }
{**************************************************************************}


{--------------------------------------------------------------------------}
{                               㭪樨                                    }
{--------------------------------------------------------------------------}
{    8 }
function Add7(a,b:byte):byte;
var
 r:byte;
begin
 r:=a+b;
 if r>7 then r:=r-7;
 Add7:=r;
end;

{᫥ ⭮ }
function LongSqrt(v:longint):longint;
var
 i:integer;
 result,tmp:longint;
 low,high:longint;
begin
 if (v<=1) then
  begin
   LongSqrt:=abs(v);
   exit;
  end;
 low:=v;
 high:=0;
 result:=0;
 for i:=0 to 15 do
  begin
   result:=result+result;
   high:=(high shl 2) or ((low shr 30) and $3);
   low:=low shl 2;
   tmp:=result+result+1;
   if (high >= tmp) then
    begin
     inc(result);
     high:=high-tmp;
    end;
  end;
 if (v-(result*result)>=(result - 1)) then inc(result);
 LongSqrt:=result;
end;

{  ﭨ   窠 }
function LongDist(x1,y1,x2,y2:longint):longint;
begin
 LongDist:=LongSqrt(Sqr(x2-x1)+Sqr(y2-y1));
end;

{  }
function Tan(x:real):real;
begin
 Tan:=sin(x)/cos(x);
end;

{ ।  ᫠ }
function Sign(x:real):integer;
begin
 if x>0 then Sign:=1 else
  if x=0 then Sign:=0 else Sign:=-1;
end;

{--------------------------------------------------------------------------}
{                                                                   }
{--------------------------------------------------------------------------}
{ ⠭ 㣫 }
const
 ANGLE_0=0;
 ANGLE_1=5;
 ANGLE_2=10;
 ANGLE_4=20;
 ANGLE_5=25;
 ANGLE_6=30;
 ANGLE_15=80;
 ANGLE_30=160;
 ANGLE_45=240;
 ANGLE_60=320;
 ANGLE_90=480;
 ANGLE_135=720;
 ANGLE_180=960;
 ANGLE_225=1200;
 ANGLE_270=1440;
 ANGLE_315=1680;
 ANGLE_360=1920;
 STEP_LENGTH=3;

{ ⠡ 樥   ﭨ  ⠡ }
const
 DistScaleK=13000;

type
 TTable=array[0..ANGLE_360]  of real;
 PTable=^TTable;
 TLongTable=array[0..ANGLE_360] of longint;
 PLongTable=^TLongTable;
 TCosDist_Table=array[0..320] of word;
 PCosDist_Table=^TCosDist_Table;

var
 CosDist_Table:PCosDist_Table;
 x_step,y_step,tan_table,inv_tan_table,inv_cos_table,inv_sin_table:PTable;
 cos_table,sin_table:PLongTable;


{  ⠡ }
procedure Build_Tables;
var
 ang:integer;
 rad_angle:real;
 x:real;
 i,j:integer;
begin
 for ang:=ANGLE_0 to ANGLE_360 do
  begin
   rad_angle:=ang*2*Pi/ANGLE_360;
   sin_table^[ang]:=trunc(1024*sin(rad_angle));
   cos_table^[ang]:=trunc(1024*cos(rad_angle));
   rad_angle:=(3.272e-4)+ang*2*Pi/ANGLE_360;
   tan_table^[ang]:=tan(rad_angle);
   inv_tan_table^[ang]:=1/tan_table^[ang];
   if (ang>=ANGLE_0) and (ang<ANGLE_180) then
       y_step^[ang]:=abs(tan_table^[ang]*64)
    else y_step^[ang]:=-abs(tan_table^[ang]*64);
   if (ang>=ANGLE_90) and (ang<ANGLE_270) then
       x_step^[ang]:=-abs(inv_tan_table^[ang]*64)
    else x_step^[ang]:=abs(inv_tan_table^[ang]*64);
    inv_cos_table^[ang]:=1/cos(rad_angle);
    inv_sin_table^[ang]:=1/sin(rad_angle);
  end;
 for i:=0 to 320 do
  begin
   ang:=i-ANGLE_30;
   rad_angle:=(3.272e-4)+ang*2*Pi/ANGLE_360;
   CosDist_Table^[i]:=trunc(DistScaleK/cos(rad_angle));
  end;
end;

{  ⠡ }
procedure InitTables;
begin
 New(tan_table);
 New(sin_table);
 New(cos_table);
 New(inv_tan_table);
 New(y_step);
 New(x_step);
 New(CosDist_Table);
 New(inv_cos_table);
 New(inv_sin_table);
 Build_Tables;
end;

{ ⮦ ⠡ }
procedure DoneTables;
begin
 Dispose(tan_table);
 Dispose(sin_table);
 Dispose(cos_table);
 Dispose(inv_tan_table);
 Dispose(y_step);
 Dispose(x_step);
 Dispose(CosDist_Table);
 Dispose(inv_cos_table);
 Dispose(inv_sin_table);
end;

