//---------------------------------------------------------------------------
// PROGRAMA: SETUP DE SONIDO
// AUTOR:    DANIEL NAVARRO
// FECHA:    23/03/97
//---------------------------------------------------------------------------

SETUP_PROGRAM div_sound_setup;

CONST
    max_botones=18;

GLOBAL
    STRUCT botones[max_botones] // Estructura general para cada botn
        x,y,                // Coordenadas en pantalla
        graph,              // Grfico que utiliza al pulsarlo
        inc,                // Incremento que realiza el botn
        max,                // Valor mximo permitido con su incremento
        valor;              // Valor actual del botn
    END=302,2,12,0,0,0,                  // Botn de escape
        159,58,10,-1,0,&setup.card,      // Botn + de seleccin de tarjeta
        177,58,11,1,7,&setup.card,       // Botn - de seleccin de tarjeta
        60,98,10,-1,0,&setup.port,       // Botn + de seleccin de puerto
        78,98,11,1,5,&setup.port,        // Botn - de seleccin de puerto
        159,98,10,-1,0,&setup.irq,       // Botn + de seleccin de irq
        177,98,11,1,9,&setup.irq,        // Botn - de seleccin de irq
        60,138,10,-1,0,&setup.dma,       // Botn + de seleccin de dma
        78,138,11,1,10,&setup.dma,       // Botn - de seleccin de dma
        159,138,10,-1,0,&setup.dma2,     // Botn + de seleccin de dma2
        177,138,11,1,10,&setup.dma2,     // Botn - de seleccin de dma2
        279,58,10,-1,0,&setup.master,    // Botn + de volumen maestro
        297,58,11,1,15,&setup.master,    // Botn - de volumen maestro
        279,98,10,-1,0,&setup.sound_fx,  // Botn + de volumen canal de efectos
        297,98,11,1,15,&setup.sound_fx,  // Botn - de volumen canal de efectos
        279,138,10,-1,0,&setup.cd_audio, // Botn + de volumen CD audio
        297,138,11,1,15,&setup.cd_audio, // Botn - de volumen CD audio
        2,221,13,0,0,0,
        100,221,14,0,0,0;

    // Textos que denominan los tipos de tarjeta de sonido
    tarjeta_sonido[]="No Sound","Sound Blaster 1.5","Sound Blaster 2.0","Sound Blaster Pro",
           "Sound Blaster 16","Sound Blaster AWE","Gravis Ultra Sound","Gravis Ultra Sound MAX";

    // Textos que denominan los puertos posibles
    puerto[]="0x210","0x220","0x230","0x240","0x250","0x260";

    // Textos que denominan las irq posibles
    irq[]="2","3","5","7","10","11","12","13","14","15";

    // Texto que denomiman los canales de dma posibles
    dma[]="0","1","2","3","4","5","6","7","8","9","10";

    id_sonido;  // Identificador del sonido usado

BEGIN
    // Selecciona el modo de video y la velocidad de impresin
    set_mode(m320x240);
    set_fps(100,0);

    fade_on();                      // Enciende la pantalla
    load_fpg("setup\setup.fpg");    // Carga el fichero de grficos
    put_screen(0,1);                // Pone la pantalla de fondo

    FRAME;                          // Imprime todo

    dump_type=partial_dump;         // Hace que no se restaure la pantalla
    restore_type=partial_restore;   // para asi ganar velocidad

    mouse.graph=100;                // Selecciona el grfico del ratn
    sombra_ratn(101,4);            // Y crea una sombra del mismo debajo

    // Crea todos los botones necesarios
    FROM x=0 TO max_botones;
        botn(x);
    END

    // Crea los tres volumenes necesarios
    volumen(1,210,60);
    volumen(2,210,100);
    volumen(3,210,140);

    // Muestra los valores de todos los parametros
    muestra_valores();

    // Repite indefinidamente
    LOOP

        // Si se pulsa la tecla [ESCAPE] sale del programa
        IF (key(_esc)) exit("",0); END
        FRAME;
    END
END

//---------------------------------------------------------------------------
// Proceso sombra_ratn
// Pone el grfico de la sombra del ratn
// Entradas: graph = nmero de grafico
//           flags = bandera de espejado y transparencia
//---------------------------------------------------------------------------

PROCESS sombra_ratn(graph,flags)

BEGIN
    z=mouse.z+1;    // Hace que se imprima un plano por debajo del ratn
    LOOP
        // Sus coordenadas estan ms a la derecha y ms abajo que el ratn
        x=mouse.x+4;
        y=mouse.y+2;
        FRAME;
    END
END

//---------------------------------------------------------------------------
// Proceso botn
// Maneja los todos los botones del programa
// Entradas: nmero = nmero de botn que tiene que manejar
//---------------------------------------------------------------------------

PROCESS botn(nmero)

PRIVATE
    ancho; // Ancho en pixels del botn

BEGIN
    // Coge las coordenadas de la tabla de botones
    x=botones[nmero].x;
    y=botones[nmero].y;
    // Si el botn es de los dos ltimos es ms ancho
    IF (nmero>16) ancho=96; ELSE ancho=16; END
    // Repite indefinidamente
    LOOP
        // Comprueba si se hace click con el ratn encima del botn
        IF (mouse.x>x and mouse.x<x+ancho and
            mouse.y>y and mouse.y<y+16 and mouse.left)
            // Cambia el grfico por el del botn pulsado
            graph=botones[nmero].graph;
        ELSE
            // Si la ltima vez se pulso el botn
            IF (graph<>0)
                // Quita el grfico del botn pulsado
                graph=0;
                FRAME;
                // Comprueba que botn es el pulsado
                switch(nmero)
                    // Sale del programa
                    case 0:
                        exit("",0);
                    END
                    // Graba la configuracin y sale del programa
                    case 17:
                        save("sound.cfg",&setup,sizeof(setup));
                        exit("",0);
                    END
                    // Hace un test de sonido
                    case 18:
                        unload_pcm(id_sonido);  // Descarga el sonido si lo hubiera
                        reset_sound();          // Actualiza los valores de configuracin
                        // Carga el sonido de prueba
                        id_sonido=load_pcm("setup\setup.pcm",0);
                        // Si no esta tocando una cancin el CD
                        IF (not is_playing_cd())
                            // Hace que suene el CD
                            play_cd(2,0);
                        END
                        // Ejecuta el sonido
                        sound(id_sonido,256,256);
                    END
                    // Para los dems botones
                    default:
                        // Si el incremento a realizar es positivo
                        IF (botones[nmero].inc>0)
                            // Y si no se sobrepasa el limite
                            IF ([botones[nmero].valor]<botones[nmero].max)
                                // Realiza el incremento
                                [botones[nmero].valor]+=botones[nmero].inc;
                            END
                        ELSE    // Si no, es negativo
                            // Y si tampoco se sobrepasa el limite
                            IF ([botones[nmero].valor]>botones[nmero].max)
                                // Realiza el decremento
                                [botones[nmero].valor]+=botones[nmero].inc;
                            END
                        END
                    END
                END
                // Muestra los valores actualizados
                muestra_valores();
            END
        END
        FRAME;
    END
END

//---------------------------------------------------------------------------
// Proceso muestra_valores
// Muestra los valores actualizados
//---------------------------------------------------------------------------

PROCESS muestra_valores()

BEGIN
    // Borra cualquier texto que hubiera impreso
    delete_text(all_text);
    // Escribe los nuevos textos actualizados
    write(0,12,61,0,tarjeta_sonido[setup.card]);
    write(0,12,101,0,puerto[setup.port]);
    write(0,111,101,0,irq[setup.irq]);
    write(0,12,141,0,dma[setup.dma]);
    write(0,111,141,0,dma[setup.dma2]);
    // Define tres regiones para los tres volumenes configurables
    // con un tamao proporcional a sus valores
    define_region(1,210,60,4+(4*setup.master),11);
    define_region(2,210,100,4+(4*setup.sound_fx),11);
    define_region(3,210,140,4+(4*setup.cd_audio),11);
END

//---------------------------------------------------------------------------
// Proceso volumen
// Maneja los grficos de los volumenes
// Entradas: region = Nmero de regin del volumn
//           x,y    = Coordenadas en pantalla
//---------------------------------------------------------------------------

PROCESS volumen(region,x,y)

BEGIN
    // Selecciona el grfico
    graph=50;
    // Repite indefinidamente
    LOOP
        FRAME;
    END
END
