DECLARE SUB LoadGame ()
DECLARE SUB SaveGame ()
DECLARE SUB Pause ()
DECLARE SUB LoadConfig ()
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE SUB NextMidi ()
DECLARE SUB LoadMIDI (FileName$, MIDISegment%, MIDIOffset%)
DECLARE SUB HighScores ()
DECLARE SUB PalGet (Col%, R%, G%, B%)
DECLARE SUB PalSet (Col%, R%, G%, B%)
DECLARE SUB FadePal ()
DECLARE SUB DrawScreen ()
DECLARE SUB PlayMIDI (MIDISegment%, MIDIOffset%)
DECLARE SUB NextBlock ()
DECLARE SUB PlayGame ()
DECLARE SUB Again ()
DECLARE SUB CheckHighScore ()
DECLARE FUNCTION BytesRequired& (FileName$)
DECLARE SUB InputName ()
DECLARE SUB SaveHighScores ()
DECLARE SUB CheckRows ()
DECLARE SUB Ending ()
DECLARE SUB DisplayNextBlock ()
DECLARE SUB DrawBlock (C%, X1%, Y1%)
DECLARE SUB InternalGetIntVector (IntNum%, segment%, offset%)
DECLARE SUB StopMidi ()
DECLARE FUNCTION InternalBitRead% (Variable%, BitNum%)
DECLARE FUNCTION InternalReadMixer% (Index%)
DECLARE FUNCTION MIDIError$ ()
DECLARE SUB MoveBlock (XMove%, YMove%)
DECLARE SUB RemoveBlock ()
DECLARE SUB PutBlock ()
DECLARE SUB PauseMidi ()
DECLARE SUB Rotate ()
DECLARE SUB ResumeMidi ()
DECLARE FUNCTION TimeMidi! ()

'$DYNAMIC
'$INCLUDE: 'future.bi'
DEFINT A-Z
DIM SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR
DIM SHARED MIDI.Loaded, SBMIDI.INTERRUPT
DIM SHARED SBSIM.INTERRUPT, PAUSED AS SINGLE
DIM SHARED SENSITIVE, Sound.Disabled
DIM SHARED BIT.STORAGE(0 TO 7)

DIM SHARED Block, X, Y, Tim AS SINGLE, Delay AS SINGLE, OldDelay AS SINGLE
DIM SHARED Score, Rows, Blocks, BlockNext, Name$
DIM SHARED Scores(3), Names$(3), Song, SongName$, SongTime AS SINGLE
DIM SHARED BasePort, LenPort, Channel
DIM SHARED Level, StartAgain, FX, Sounds

CLS
LoadConfig
Level = 1
a$ = "Starting Tetris version 2.0 (1 player version)"
B$ = "By Future Software"
a$ = a$ + SPACE$(80 - LEN(a$) - LEN(B$)) + B$
COLOR 15, 4: PRINT a$: COLOR 7, 0
PRINT "Loading game..."
IF Sounds = 1 THEN
	PRINT "Checking midi drivers...";
	DriversLoaded SBMIDI, SBSIM
	IF SBMIDI = 0 THEN PRINT "Not found! Please be sure to run SBMIDI.EXE from DOS first!": END
	IF SBSIM = 0 THEN PRINT "Not found! Please be sure to run SBSIM.COM from DOS first!": END
	IF SBMIDI.INTERRUPT = 0 THEN SBMIDI.INTERRUPT = &H80
	IF SBSIM.INTERRUPT = 0 THEN SBSIM.INTERRUPT = &H81
	PRINT "Available!"
	PRINT "Loading midi file...";
		NextMidi
		DIM MIDI%(BytesRequired&(SongName$) \ 2)
		LoadMIDI SongName$, VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
	PRINT "Done!"
END IF
PRINT "Loading high score table...";
HighScores
NewHighScores:
PRINT "Done!"
Tim = TIMER: DO: LOOP UNTIL TIMER >= Tim + 1

StartGame:
FOR i = 0 TO 63
	WAIT &H3DA, 8, 8: WAIT &H3DA, 8
	FOR ii = 0 TO 63
		PalGet ii, R, G, B
		IF R > 0 THEN R = R - 1
		IF G > 0 THEN G = G - 1
		IF B > 0 THEN B = B - 1
		PalSet ii, R, G, B
	NEXT ii
NEXT i

ON ERROR GOTO FileNotFound
SCREEN 13: FadePal
Palette.FadeOut
DrawScreen
IF Sounds = 1 THEN PlayMIDI VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
IF FX = 1 THEN LoadWAV "fs.wav", 11025
Tim2! = TIMER: DO: LOOP UNTIL TIMER >= Tim2! + 1.5
IF FX = 1 THEN LoadWAV "bp.wav", 11025

NextBlock
Tim = TIMER: Delay = 1.5
IF INSTR(LCASE$(COMMAND$), "loadgame") THEN LoadGame

Palette.FadeIn

PlayGame

NoSave:
PlayGame
RESUME

NoHighScores:
FOR a = 1 TO 3
Names$(a) = "Nobody": Scores(a) = 2000 - a * 500
NEXT
GOTO NewHighScores
RESUME

FileNotFound:
CLS : PALETTE: SCREEN 0: COLOR 15: LOCATE 1, 1: PRINT "An error has happened. Press any key to end..."
DO: LOOP WHILE INKEY$ = ""
END

REM $STATIC
SUB Again
CheckHighScore
X1 = 105: X2 = 242: Y1 = 105: Y2 = 135
LINE (X1 - 9, Y1 - 9)-(X2 + 9, Y2 + 9), 56, B
LINE (X1 - 8, Y1 - 8)-(X2 + 8, Y2 + 8), 55, B
LINE (X1 - 7, Y1 - 7)-(X2 + 7, Y2 + 7), 54, B
LINE (X1 - 6, Y1 - 6)-(X2 + 6, Y2 + 6), 53, B
LINE (X1 - 5, Y1 - 5)-(X2 + 5, Y2 + 5), 52, B
LINE (X1 - 4, Y1 - 4)-(X2 + 4, Y2 + 4), 51, B
LINE (X1 - 3, Y1 - 3)-(X2 + 3, Y2 + 3), 50, B
LINE (X1 - 2, Y1 - 2)-(X2 + 2, Y2 + 2), 49, B
LINE (X1 - 1, Y1 - 1)-(X2 + 1, Y2 + 1), 48, B
LINE (X1, Y1)-(X2, Y2), 47, B
LINE (X1, Y1)-(X2, Y2), 0, BF
LOCATE 15, 15: COLOR 200: PRINT "  Play again?   "
LOCATE 16, 15: PRINT "      (Y/N)     "
ClearKeyBuffer
DO
Key$ = INKEY$
IF Key$ <> "" THEN
	IF LCASE$(Key$) = "y" THEN StopMidi: EXIT DO ELSE Palette.FadeOut: CLS : SCREEN 0: WIDTH 80, 25: StopMidi: END
END IF
LOOP
Score = 0: Level = 1: Rows = 0
CLS : SCREEN 13: FadePal
Palette.FadeOut
DrawScreen
IF Sounds = 1 THEN
	NextMidi
	DIM MIDI%(BytesRequired&(SongName$) \ 2)
	LoadMIDI SongName$, VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
	PlayMIDI VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
END IF
NotFirstTime = 0
NextBlock
NotFirstTime = 1
Palette.FadeIn
Tim = TIMER: Delay = 1.5
PlayGame
END SUB

FUNCTION BytesRequired& (FileName$)
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
	FileLen& = LOF(FF%)
CLOSE FF%
IF FileLen& = 0 THEN KILL FileName$: MIDI.ERROR = 1: EXIT FUNCTION
BytesRequired& = FileLen&
MIDI.ERROR = 0
END FUNCTION

SUB CheckHighScore
IF Score > Scores(3) THEN InputName
SELECT CASE Score
CASE IS > Scores(1): Scores(3) = Scores(2): Names$(3) = Names$(2)
	Scores(2) = Scores(1): Names$(2) = Names$(1)
	Scores(1) = Score: Names$(1) = Name$
CASE IS = Scores(1): Scores(3) = Scores(2): Scores(2) = Score
	Names$(3) = Names$(2): Names$(2) = Name$
CASE IS > Scores(2): Scores(3) = Scores(2): Scores(2) = Score
	Names$(3) = Names$(2): Names$(2) = Name$
CASE IS = Scores(2): Scores(3) = Score: Names$(3) = Name$
CASE IS > Scores(3): Scores(3) = Score: Names$(3) = Name$
END SELECT
EndHigh:
SaveHighScores
END SUB

SUB CheckRows
DIM MoveRow(751)
FOR Y1 = 185 TO 15 STEP -10
CheckAgain:
	FOR X1 = 15 TO 155 STEP 10
		a = POINT(X1, Y1)
		IF a = 0 THEN GOTO NoRows
	NEXT X1
	LINE (10, Y1 - 5)-(159, Y1 + 4), 0, BF
	WAIT &H3DA, 8, 8: WAIT &H3DA, 8
	FOR a = Y1 TO 10 STEP -10
		GET (10, a - 5)-(159, a + 4), MoveRow
		LINE (10, a - 5)-(159, a + 4), 0, BF
		PUT (10, a + 5), MoveRow
	NEXT
	RowType = RowType + 1: Rows = Rows + 1
	GOTO CheckAgain
NoRows:
NEXT Y1
LOCATE 11, 31: COLOR 200
SELECT CASE RowType
CASE 1: PRINT "Single": Score = Score + 5: IF FX = 1 THEN LoadWAV "single.wav", 11025
CASE 2: PRINT "Double": Score = Score + 15: IF FX = 1 THEN LoadWAV "double.wav", 11025
CASE 3: PRINT "Triple": Score = Score + 30: IF FX = 1 THEN LoadWAV "triple.wav", 11025
CASE 4: PRINT "Tetris": Score = Score + 60: IF FX = 1 THEN LoadWAV "tetriss.wav", 11025
END SELECT
IF Rows >= 15 THEN
	Level = Level + 1
	Rows = 0
	COLOR 200: LOCATE 8, 35: PRINT Level
	SELECT CASE Level
	CASE 1: Delay = 1.5
	CASE 2: Delay = 1.4
	CASE 3: Delay = 1.3
	CASE 4: Delay = 1.2
	CASE 5: Delay = 1.1
	CASE 6: Delay = 1
	CASE 7: Delay = .9
	CASE 8: Delay = .8
	CASE 9: Delay = .7
	CASE 10: Delay = .6
	CASE 11: Delay = .5
	CASE 12: Delay = .4
	CASE 13: Delay = .3
	CASE 14: Delay = .2
	CASE 15: Delay = .1
	CASE 16: Delay = 0
	END SELECT
END IF
END SUB

SUB DisplayNextBlock
LINE (241, 121)-(299, 179), 11, BF
X1 = 250: Y1 = 130
SELECT CASE BlockNext
CASE 1: DrawBlock 55, X1, Y1: DrawBlock 55, X1 + 10, Y1
	DrawBlock 55, X1, Y1 + 10: DrawBlock 55, X1 + 10, Y1 + 10
CASE 2: DrawBlock 40, X1 + 10, Y1: DrawBlock 40, X1, Y1 + 10
	DrawBlock 40, X1 + 10, Y1 + 10: DrawBlock 40, X1 + 20, Y1 + 10
CASE 3: DrawBlock 40, X1 + 10, Y1: DrawBlock 40, X1 + 10, Y1 + 10
	DrawBlock 40, X1, Y1 + 10: DrawBlock 40, X1 + 10, Y1 + 20
CASE 4: DrawBlock 40, X1, Y1 + 10: DrawBlock 40, X1 + 10, Y1 + 10
	DrawBlock 40, X1 + 20, Y1 + 10: DrawBlock 40, X1 + 10, Y1 + 20
CASE 5: DrawBlock 40, X1 + 10, Y1: DrawBlock 40, X1 + 10, Y1 + 10
	DrawBlock 40, X1 + 20, Y1 + 10: DrawBlock 40, X1 + 10, Y1 + 20
CASE 6: DrawBlock 25, X1, Y1 + 10: DrawBlock 25, X1 + 10, Y1 + 10
	DrawBlock 25, X1 + 20, Y1 + 10: DrawBlock 25, X1 + 30, Y1 + 10
CASE 7: DrawBlock 25, X1 + 10, Y1: DrawBlock 25, X1 + 10, Y1 + 10
	DrawBlock 25, X1 + 10, Y1 + 20: DrawBlock 25, X1 + 10, Y1 + 30
CASE 8: DrawBlock 10, X1 + 10, Y1: DrawBlock 10, X1, Y1 + 10
	DrawBlock 10, X1 + 10, Y1 + 10: DrawBlock 10, X1, Y1 + 20
CASE 9: DrawBlock 10, X1, Y1: DrawBlock 10, X1 + 10, Y1
	DrawBlock 10, X1 + 10, Y1 + 10: DrawBlock 10, X1 + 20, Y1 + 10
CASE 10: DrawBlock 100, X1, Y1: DrawBlock 100, X1, Y1 + 10
	DrawBlock 100, X1 + 10, Y1 + 10: DrawBlock 100, X1 + 10, Y1 + 20
CASE 11: DrawBlock 100, X1 + 10, Y1: DrawBlock 100, X1 + 20, Y1
	DrawBlock 100, X1 + 10, Y1 + 10: DrawBlock 100, X1, Y1 + 10
CASE 12: DrawBlock 70, X1, Y1: DrawBlock 70, X1 + 10, Y1
	DrawBlock 70, X1 + 20, Y1: DrawBlock 70, X1, Y1 + 10
CASE 13: DrawBlock 70, X1, Y1: DrawBlock 70, X1, Y1 + 10
	DrawBlock 70, X1, Y1 + 20: DrawBlock 70, X1 + 10, Y1 + 20
CASE 14: DrawBlock 70, X1 + 20, Y1 + 10: DrawBlock 70, X1 + 20, Y1 + 20
	DrawBlock 70, X1 + 10, Y1 + 20: DrawBlock 70, X1, Y1 + 20
CASE 15: DrawBlock 70, X1 + 10, Y1: DrawBlock 70, X1 + 20, Y1
	DrawBlock 70, X1 + 20, Y1 + 10: DrawBlock 70, X1 + 20, Y1 + 20
CASE 16: DrawBlock 85, X1 + 10, Y1: DrawBlock 85, X1 + 10, Y1 + 10
	DrawBlock 85, X1 + 10, Y1 + 20: DrawBlock 85, X1, Y1 + 20
CASE 17: DrawBlock 85, X1, Y1 + 10: DrawBlock 85, X1 + 10, Y1 + 10
	DrawBlock 85, X1 + 20, Y1 + 10: DrawBlock 85, X1 + 20, Y1 + 20
CASE 18: DrawBlock 85, X1, Y1: DrawBlock 85, X1 + 10, Y1
	DrawBlock 85, X1, Y1 + 10: DrawBlock 85, X1, Y1 + 20
CASE 19: DrawBlock 85, X1, Y1 + 10: DrawBlock 85, X1, Y1 + 20
	DrawBlock 85, X1 + 10, Y1 + 20: DrawBlock 85, X1 + 20, Y1 + 20
END SELECT
END SUB

SUB DrawBlock (C, X1, Y1)
LINE (X1, Y1)-(X1 + 9, Y1 + 9), C, BF: LINE (X1 + 1, Y1)-(X1 + 1, Y1 + 8), C - 9
LINE (X1 + 2, Y1)-(X1 + 2, Y1 + 8), C - 8: LINE (X1 + 3, Y1)-(X1 + 3, Y1 + 8), C - 6
LINE (X1 + 4, Y1)-(X1 + 4, Y1 + 8), C - 5: LINE (X1 + 5, Y1)-(X1 + 5, Y1 + 8), C - 4
LINE (X1 + 6, Y1)-(X1 + 6, Y1 + 8), C - 3: LINE (X1 + 7, Y1)-(X1 + 7, Y1 + 8), C - 2
LINE (X1 + 8, Y1)-(X1 + 8, Y1 + 8), C - 1: LINE (X1 + 9, Y1)-(X1 + 9, Y1 + 8), C
LINE (X1, Y1)-(X1, Y1 + 9), C + 2: LINE (X1, Y1)-(X1 + 9, Y1), C + 2
END SUB

SUB DrawScreen
PAINT (0, 0), 56: LINE (10, 10)-(159, 189), 0, BF: LINE (230, 10)-(310, 190), 0, BF

X1 = 10: X2 = 159: Y1 = 11: Y2 = 189
LINE (X1 - 9, Y1 - 9)-(X2 + 9, Y2 + 9), 56, B
LINE (X1 - 8, Y1 - 8)-(X2 + 8, Y2 + 8), 55, B
LINE (X1 - 7, Y1 - 7)-(X2 + 7, Y2 + 7), 54, B
LINE (X1 - 6, Y1 - 6)-(X2 + 6, Y2 + 6), 53, B
LINE (X1 - 5, Y1 - 5)-(X2 + 5, Y2 + 5), 52, B
LINE (X1 - 4, Y1 - 4)-(X2 + 4, Y2 + 4), 51, B
LINE (X1 - 3, Y1 - 3)-(X2 + 3, Y2 + 3), 50, B
LINE (X1 - 2, Y1 - 2)-(X2 + 2, Y2 + 2), 49, B
LINE (X1 - 1, Y1 - 1)-(X2 + 1, Y2 + 1), 48, B
LINE (X1, Y1)-(X2, Y2), 47, B

X1 = 230: X2 = 310: Y1 = 10: Y2 = 190
LINE (X1 - 9, Y1 - 9)-(X2 + 9, Y2 + 9), 56, B
LINE (X1 - 8, Y1 - 8)-(X2 + 8, Y2 + 8), 55, B
LINE (X1 - 7, Y1 - 7)-(X2 + 7, Y2 + 7), 54, B
LINE (X1 - 6, Y1 - 6)-(X2 + 6, Y2 + 6), 53, B
LINE (X1 - 5, Y1 - 5)-(X2 + 5, Y2 + 5), 52, B
LINE (X1 - 4, Y1 - 4)-(X2 + 4, Y2 + 4), 51, B
LINE (X1 - 3, Y1 - 3)-(X2 + 3, Y2 + 3), 50, B
LINE (X1 - 2, Y1 - 2)-(X2 + 2, Y2 + 2), 49, B
LINE (X1 - 1, Y1 - 1)-(X2 + 1, Y2 + 1), 48, B
LINE (X1, Y1)-(X2, Y2), 47, B

X1 = 240: X2 = 300: Y1 = 120: Y2 = 180
LINE (X1, Y1)-(X2, Y2), 11, BF
LINE (X1 - 9, Y1 - 9)-(X2 + 9, Y2 + 9), 2, B
LINE (X1 - 8, Y1 - 8)-(X2 + 8, Y2 + 8), 3, B
LINE (X1 - 7, Y1 - 7)-(X2 + 7, Y2 + 7), 4, B
LINE (X1 - 6, Y1 - 6)-(X2 + 6, Y2 + 6), 5, B
LINE (X1 - 5, Y1 - 5)-(X2 + 5, Y2 + 5), 6, B
LINE (X1 - 4, Y1 - 4)-(X2 + 4, Y2 + 4), 7, B
LINE (X1 - 3, Y1 - 3)-(X2 + 3, Y2 + 3), 8, B
LINE (X1 - 2, Y1 - 2)-(X2 + 2, Y2 + 2), 9, B
LINE (X1 - 1, Y1 - 1)-(X2 + 1, Y2 + 1), 10, B
LINE (X1, Y1)-(X2, Y2), 11, B


COLOR 200: LOCATE 3, 30: PRINT "Tetris 2.0"
LINE (230, 27)-(310, 27), 200
LOCATE 5, 30: PRINT "Score:"
LOCATE 7, 30: PRINT "Level:";
LOCATE 9, 30: PRINT "HighScore"
LOCATE 13, 30: PRINT "Next:"
FOR a = 230 TO 310
	FOR B = 15 TO 280
		IF POINT(a, B) = 200 THEN PSET (a, B), 56 - C
	NEXT
	C = a - 230
	C = C / 9
NEXT
LOCATE 8, 35: PRINT "1"
'LOCATE 10, 30: PRINT Scores(1)
LOCATE 10, 30: PRINT Scores(1)
END SUB

SUB DriversLoaded (SBMIDI%, SBSIM%) STATIC
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
	FileSize& = LOF(FF%)
	IF FileSize& = 0 THEN
		CLOSE FF%: KILL "DRIVERS.DAT": MIDI.ERROR = 1: EXIT SUB
	ELSEIF FileSize& <> 1024 THEN
		CLOSE FF%: MIDI.ERROR = 9: EXIT SUB
	END IF
	REDIM DRIVERDATA$(1 TO 5)
	FOR i% = 1 TO 4
		DRIVERDATA$(i%) = INPUT$(256, #FF%)
	NEXT i%
CLOSE #FF%

SBMIDI% = 0: SBSIM% = 0
FOR i% = &H80 TO &HE1
	InternalGetIntVector i%, segment%, offset%
	IF segment% = 0 AND offset% = 0 THEN GOTO Skip:
	IF SBMIDI% = 0 THEN
		NewSegment% = CVI(MKI$(CVL(MKI$(segment%) + CHR$(0) + CHR$(0)) - &H11&))
		DEF SEG = NewSegment%
		Temp$ = ""
		FOR J% = 1 TO 6
			Temp$ = Temp$ + CHR$(PEEK(271 + J%))
		NEXT
		IF Temp$ = "SBMIDI" THEN SBMIDI% = i%
	END IF
	IF SBSIM% = 0 THEN
		NewSegment% = CVI(MKI$(CVL(MKI$(segment%) + CHR$(0) + CHR$(0)) - &H1&))
		DEF SEG = NewSegment%
		Temp$ = ""
		FOR J% = 1 TO 5
			Temp$ = Temp$ + CHR$(PEEK(274 + J%))
		NEXT
		IF Temp$ = "SBSIM" THEN SBSIM% = i%
	END IF
   
	DEF SEG = segment%
	DRIVERDATA$(5) = ""
	FOR J% = 0 TO 255
		byte% = PEEK(offset% + J%)
		DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(byte%)
	NEXT J%
	FOR J% = 1 TO 4
		MATCH% = 1
		FOR K% = 0 TO 255
			IF MID$(DRIVERDATA$(J%), K% + 1, 1) <> MID$(DRIVERDATA$(5), K% + 1, 1) THEN
			SELECT CASE K%
			CASE IS = 14, 15, 113, 114, 235, 236:
			CASE ELSE: MATCH% = 0: EXIT FOR
			END SELECT
			END IF
		NEXT K%
		IF MATCH% THEN
			IF J% = 1 THEN SBSIM% = i%
			IF J% <> 1 THEN SBMIDI% = i%
		END IF
		IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	NEXT J%
	IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
Skip:
NEXT i%
MIDI.ERROR = 0
END SUB

SUB Ending
CheckHighScore
Palette.FadeOut
CLS : SCREEN 0: WIDTH 80, 25: StopMidi
END SUB

SUB FadePal
FOR i = 5 TO 75 STEP 5: m = m + 1: PalSet m, i, i, i: NEXT
FOR i = 5 TO 75 STEP 5: m = m + 1: PalSet m, i, 0, 0: NEXT
FOR i = 5 TO 75 STEP 5: m = m + 1: PalSet m, 0, i, 0: NEXT
FOR i = 5 TO 75 STEP 5: m = m + 1: PalSet m, 0, 0, i: NEXT
FOR i = 5 TO 75 STEP 5: m = m + 1: PalSet m, i, i, 0: NEXT
FOR i = 5 TO 75 STEP 5: m = m + 1: PalSet m, 0, i, i: NEXT
FOR i = 5 TO 75 STEP 5: m = m + 1: PalSet m, i, 0, i: NEXT
PalSet 200, 60, 60, 60
END SUB

SUB HighScores
ON ERROR GOTO NoHighScores
Sco2 = FREEFILE
OPEN "tetris.sco" FOR INPUT AS Sco2
FOR a = 1 TO 3
INPUT #Sco2, Names$(a): INPUT #Sco2, Scores(a)
NEXT
CLOSE
END SUB

SUB InputName
DIM Temp2(10000)
GET (95, 132)-(115, 145), Temp2
IF FX = 1 THEN LoadWAV "enternam.wav", 11025
X1 = 105: X2 = 242: Y1 = 105: Y2 = 135
LINE (X1 - 9, Y1 - 9)-(X2 + 9, Y2 + 9), 56, B
LINE (X1 - 8, Y1 - 8)-(X2 + 8, Y2 + 8), 55, B
LINE (X1 - 7, Y1 - 7)-(X2 + 7, Y2 + 7), 54, B
LINE (X1 - 6, Y1 - 6)-(X2 + 6, Y2 + 6), 53, B
LINE (X1 - 5, Y1 - 5)-(X2 + 5, Y2 + 5), 52, B
LINE (X1 - 4, Y1 - 4)-(X2 + 4, Y2 + 4), 51, B
LINE (X1 - 3, Y1 - 3)-(X2 + 3, Y2 + 3), 50, B
LINE (X1 - 2, Y1 - 2)-(X2 + 2, Y2 + 2), 49, B
LINE (X1 - 1, Y1 - 1)-(X2 + 1, Y2 + 1), 48, B
LINE (X1, Y1)-(X2, Y2), 47, B
LINE (X1, Y1)-(X2, Y2), 0, BF
LOCATE 15, 15: COLOR 56: PRINT "Enter your name:"
COLOR 200

WHILE i$ <> CHR$(13)
	LOCATE 16, 15 + current: PRINT "_"
	i$ = ""
	WHILE i$ = "": i$ = INKEY$
	WEND
	IF ASC(i$) > 31 AND ASC(i$) < 127 AND current <> 8 THEN
		LOCATE 16, 15 + current: PRINT i$
		Name$ = Name$ + i$: current = current + 1
	END IF
	IF ASC(i$) = 8 AND current > 0 THEN
		current = current - 1: Name$ = LEFT$(Name$, LEN(Name$) - 1)
		LOCATE 16, 15 + current + 1: PRINT " "
	END IF
WEND
LOCATE 16, 15 + current: PRINT " "
IF FX = 1 THEN LoadWAV "highscor.wav", 11025
PUT (95, 132), Temp2, PSET
END SUB

FUNCTION InternalBitRead% (Variable%, BitNum%)
VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
InternalBitRead% = -((PEEK(offset% + BitNum% \ 8) AND 2 ^ (BitNum% MOD 8)) > 0)
DEF SEG
END FUNCTION

SUB InternalBitSet (Variable%, BitNum%, OnOff%)
VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
IF OnOff% THEN
    POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) OR 2 ^ (BitNum% MOD 8)
ELSE
    POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) AND 255 - 2 ^ (BitNum% MOD 8)
END IF
DEF SEG
END SUB

SUB InternalBitToggle (Variable%, BitNum%)
VarSegment% = VARSEG(Variable%)
offset% = VARPTR(Variable%)
DEF SEG = VarSegment%
POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) XOR 2 ^ (BitNum% MOD 8)
DEF SEG
END SUB

SUB InternalGetIntVector (IntNum%, segment%, offset%) STATIC
IF GetIntVCodeLoaded% = 0 THEN
    asm$ = asm$ + CHR$(&H55)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
    asm$ = asm$ + CHR$(&H8A) + CHR$(&H7)
    asm$ = asm$ + CHR$(&HB4) + CHR$(&H35)
    asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
    asm$ = asm$ + CHR$(&H8C) + CHR$(&HC1)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HDA)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HF)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
    asm$ = asm$ + CHR$(&H89) + CHR$(&H17)
    asm$ = asm$ + CHR$(&H5D)
    asm$ = asm$ + CHR$(&HCB)
    asm$ = asm$ + CHR$(&H34) + CHR$(&H0)
    asm$ = asm$ + CHR$(&H60)
    asm$ = asm$ + CHR$(&H23) + CHR$(&H0)
    GetIntVCodeLoaded% = 1
END IF
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(IntNum%, segment%, offset%, SADD(asm$))
END SUB

FUNCTION InternalReadMixer% (Index%)
OUT SB.BASEPORT + 4, Index%
InternalReadMixer% = INP(SB.BASEPORT + 5)
END FUNCTION

SUB InternalWriteMixer (Index%, Value%)
OUT SB.BASEPORT + 4, Index%
OUT SB.BASEPORT + 5, Value%
END SUB

SUB LoadConfig
OPEN "tetris.ini" FOR INPUT AS #1
INPUT #1, Sounds
INPUT #1, FX
CLOSE
END SUB

SUB LoadGame
ON ERROR GOTO NoSave
CLOSE
OPEN "save1.dat" FOR INPUT AS #1
INPUT #1, Score
INPUT #1, Level
INPUT #1, X
INPUT #1, Y
INPUT #1, Block
INPUT #1, BlockNext
INPUT #1, Delay
INPUT #1, Rows
CLOSE
LoadScreen "save1.scr"
ON ERROR GOTO FileNotFound
LOCATE 10, 30: PRINT Scores(1)
END SUB

SUB LoadMIDI (FileName$, MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
IF INSTR(FileName$, ".") = 0 THEN FileName$ = FileName$ + ".MID"
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
IF FileLen& = 0 THEN KILL FileName$: MIDI.ERROR = 1: EXIT SUB
IF FileLen& > 65536 THEN MIDI.ERROR = 2: EXIT SUB
FileName$ = FileName$ + CHR$(0)
IF ask$ = "" THEN
	asm$ = asm$ + CHR$(&H1E)
	asm$ = asm$ + CHR$(&H55)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
	asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
	asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HC6)
	asm$ = asm$ + CHR$(&HB4) + CHR$(&H3F)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&HF)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
	asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HF3)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
	asm$ = asm$ + CHR$(&HB4) + CHR$(&H3E)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
	asm$ = asm$ + CHR$(&H5D)
	asm$ = asm$ + CHR$(&H1F)
	asm$ = asm$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
END IF
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(VARSEG(FileName$), SADD(FileName$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm$))
MIDI.ERROR = 0
END SUB

FUNCTION MIDIError$
SELECT CASE MIDI.ERROR
	CASE 0: MIDIError$ = "No error"
	CASE 1: MIDIError$ = "File contains no data"
	CASE 2: MIDIError$ = "File is too large"
	CASE 3: MIDIError$ = "No midi file playing"
	CASE 4: MIDIError$ = "Invalid SBMIDI interrupt"
	CASE 5: MIDIError$ = "Invalid SBSIM interrupt"
	CASE 6: MIDIError$ = "No mixer chip"
	CASE 7: MIDIError$ = "Could not detect sound card"
	CASE 8: MIDIError$ = "Feature unavailable"
	CASE 9: MIDIError$ = "File is corrupt"
	CASE 10: MIDIError$ = "Invalid sound card type"
	CASE ELSE: MIDIError$ = "Unknown error"
END SELECT
END FUNCTION

SUB MoveBlock (XMove, YMove)
'check first!
IF XMove = -1 THEN
	'Left
	SELECT CASE Block
	CASE 1: IF POINT(X - 5, Y + 5) <> 0 THEN EXIT SUB
		IF POINT(X - 5, Y + 15) THEN EXIT SUB
	CASE 2: IF POINT(X + 5, Y + 5) THEN EXIT SUB
		IF POINT(X - 5, Y + 15) THEN EXIT SUB
	CASE 3: IF POINT(X + 5, Y + 5) THEN EXIT SUB
		IF POINT(X - 5, Y + 15) THEN EXIT SUB
		IF POINT(X + 5, Y + 25) THEN EXIT SUB
	CASE 4: IF POINT(X - 5, Y + 15) THEN EXIT SUB
		IF POINT(X + 5, Y + 25) THEN EXIT SUB
	CASE 5: IF POINT(X + 5, Y + 5) THEN EXIT SUB
		IF POINT(X + 5, Y + 15) THEN EXIT SUB
		IF POINT(X + 5, Y + 25) THEN EXIT SUB
	CASE 6: IF POINT(X - 5, Y + 15) THEN EXIT SUB
	CASE 7: IF POINT(X + 5, Y + 5) THEN EXIT SUB
		IF POINT(X + 5, Y + 15) THEN EXIT SUB
		IF POINT(X + 5, Y + 25) THEN EXIT SUB
		IF POINT(X + 5, Y + 25) THEN EXIT SUB
	CASE 8: IF POINT(X + 5, Y + 5) THEN EXIT SUB
		IF POINT(X - 5, Y + 15) THEN EXIT SUB
		IF POINT(X - 5, Y + 25) THEN EXIT SUB
	CASE 9: IF POINT(X - 5, Y + 5) THEN EXIT SUB
		IF POINT(X + 5, Y + 15) THEN EXIT SUB
	CASE 10: IF POINT(X - 5, Y + 5) THEN EXIT SUB
		IF POINT(X - 5, Y + 15) THEN EXIT SUB
		IF POINT(X + 5, Y + 25) THEN EXIT SUB
	CASE 11: IF POINT(X + 5, Y + 5) THEN EXIT SUB
		IF POINT(X - 5, Y + 15) THEN EXIT SUB
	CASE 12: IF POINT(X - 5, Y + 5) THEN EXIT SUB
		IF POINT(X - 5, Y + 15) THEN EXIT SUB
	CASE 13: IF POINT(X - 5, Y + 5) THEN EXIT SUB
		IF POINT(X - 5, Y + 15) THEN EXIT SUB
		IF POINT(X - 5, Y + 25) THEN EXIT SUB
	CASE 14: IF POINT(X + 15, Y + 15) THEN EXIT SUB
		IF POINT(X - 5, Y + 25) THEN EXIT SUB
	CASE 15: IF POINT(X + 5, Y + 5) THEN EXIT SUB
		IF POINT(X + 15, Y + 15) THEN EXIT SUB
		IF POINT(X + 15, Y + 25) THEN EXIT SUB
	CASE 16: IF POINT(X + 5, Y + 5) THEN EXIT SUB
		IF POINT(X + 5, Y + 15) THEN EXIT SUB
		IF POINT(X - 5, Y + 25) THEN EXIT SUB
	CASE 17: IF POINT(X - 5, Y + 15) THEN EXIT SUB
		IF POINT(X + 15, Y + 25) THEN EXIT SUB
	CASE 18: IF POINT(X - 5, Y + 5) THEN EXIT SUB
		IF POINT(X - 5, Y + 15) THEN EXIT SUB
		IF POINT(X - 5, Y + 25) THEN EXIT SUB
	CASE 19: IF POINT(X - 5, Y + 15) THEN EXIT SUB
		IF POINT(X - 5, Y + 25) THEN EXIT SUB
	END SELECT
	RemoveBlock
	X = X - 10
	PutBlock
	EXIT SUB
END IF
IF XMove = 1 THEN
	'Right
	SELECT CASE Block
	CASE 1: IF POINT(X + 25, Y + 5) <> 0 THEN EXIT SUB
		IF POINT(X + 25, Y + 15) THEN EXIT SUB
	CASE 2: IF POINT(X + 25, Y + 5) THEN EXIT SUB
		IF POINT(X + 35, Y + 15) THEN EXIT SUB
	CASE 3: IF POINT(X + 25, Y + 5) THEN EXIT SUB
		IF POINT(X + 25, Y + 15) THEN EXIT SUB
		IF POINT(X + 25, Y + 25) THEN EXIT SUB
	CASE 4: IF POINT(X + 35, Y + 15) THEN EXIT SUB
		IF POINT(X + 25, Y + 25) THEN EXIT SUB
	CASE 5: IF POINT(X + 25, Y + 5) THEN EXIT SUB
		IF POINT(X + 35, Y + 15) THEN EXIT SUB
		IF POINT(X + 25, Y + 25) THEN EXIT SUB
	CASE 6: IF POINT(X + 45, Y + 15) THEN EXIT SUB
	CASE 7: IF POINT(X + 25, Y + 5) THEN EXIT SUB
		IF POINT(X + 25, Y + 15) THEN EXIT SUB
		IF POINT(X + 25, Y + 25) THEN EXIT SUB
		IF POINT(X + 25, Y + 35) THEN EXIT SUB
	CASE 8: IF POINT(X + 25, Y + 5) THEN EXIT SUB
		IF POINT(X + 25, Y + 15) THEN EXIT SUB
		IF POINT(X + 15, Y + 25) THEN EXIT SUB
	CASE 9: IF POINT(X + 25, Y + 5) THEN EXIT SUB
		IF POINT(X + 35, Y + 15) THEN EXIT SUB
	CASE 10: IF POINT(X + 15, Y + 5) THEN EXIT SUB
		IF POINT(X + 25, Y + 15) THEN EXIT SUB
		IF POINT(X + 25, Y + 25) THEN EXIT SUB
	CASE 11: IF POINT(X + 35, Y + 5) THEN EXIT SUB
		IF POINT(X + 25, Y + 15) THEN EXIT SUB
	CASE 12: IF POINT(X + 35, Y + 5) THEN EXIT SUB
		IF POINT(X + 15, Y + 15) THEN EXIT SUB
	CASE 13: IF POINT(X + 15, Y + 5) THEN EXIT SUB
		IF POINT(X + 15, Y + 15) THEN EXIT SUB
		IF POINT(X + 25, Y + 25) THEN EXIT SUB
	CASE 14: IF POINT(X + 35, Y + 15) THEN EXIT SUB
		IF POINT(X + 35, Y + 25) THEN EXIT SUB
	CASE 15: IF POINT(X + 35, Y + 5) THEN EXIT SUB
		IF POINT(X + 35, Y + 15) THEN EXIT SUB
		IF POINT(X + 35, Y + 25) THEN EXIT SUB
	CASE 16: IF POINT(X + 25, Y + 5) THEN EXIT SUB
		IF POINT(X + 25, Y + 15) THEN EXIT SUB
		IF POINT(X + 25, Y + 25) THEN EXIT SUB
	CASE 17: IF POINT(X + 35, Y + 15) THEN EXIT SUB
		IF POINT(X + 35, Y + 25) THEN EXIT SUB
	CASE 18: IF POINT(X + 25, Y + 5) THEN EXIT SUB
		IF POINT(X + 15, Y + 15) THEN EXIT SUB
		IF POINT(X + 15, Y + 25) THEN EXIT SUB
	CASE 19: IF POINT(X + 15, Y + 15) THEN EXIT SUB
		IF POINT(X + 35, Y + 25) THEN EXIT SUB
	END SELECT
	RemoveBlock
	X = X + 10
	PutBlock
	EXIT SUB
END IF
CheckDown:
IF YMove = 1 THEN
	'Down
	SELECT CASE Block
	CASE 1: IF POINT(X + 5, Y + 25) <> 0 THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 25) THEN NextBlock: EXIT SUB
	CASE 2: IF POINT(X + 5, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 25, Y + 25) THEN NextBlock: EXIT SUB
	CASE 3: IF POINT(X + 5, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 35) THEN NextBlock: EXIT SUB
	CASE 4: IF POINT(X + 5, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 35) THEN NextBlock: EXIT SUB
		IF POINT(X + 25, Y + 25) THEN NextBlock: EXIT SUB
	CASE 5: IF POINT(X + 15, Y + 35) THEN NextBlock: EXIT SUB
		IF POINT(X + 25, Y + 25) THEN NextBlock: EXIT SUB
	CASE 6: IF POINT(X + 5, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 25, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 35, Y + 25) THEN NextBlock: EXIT SUB
	CASE 7: IF POINT(X + 15, Y + 45) THEN NextBlock: EXIT SUB
	CASE 8: IF POINT(X + 5, Y + 35) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 25) THEN NextBlock: EXIT SUB
	CASE 9: IF POINT(X + 5, Y + 15) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 25, Y + 25) THEN NextBlock: EXIT SUB
	CASE 10: IF POINT(X + 5, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 35) THEN NextBlock: EXIT SUB
	CASE 11: IF POINT(X + 5, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 25, Y + 15) THEN NextBlock: EXIT SUB
	CASE 12: IF POINT(X + 5, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 15) THEN NextBlock: EXIT SUB
		IF POINT(X + 25, Y + 15) THEN NextBlock: EXIT SUB
	CASE 13: IF POINT(X + 5, Y + 35) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 35) THEN NextBlock: EXIT SUB
	CASE 14: IF POINT(X + 5, Y + 35) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 35) THEN NextBlock: EXIT SUB
		IF POINT(X + 25, Y + 35) THEN NextBlock: EXIT SUB
	CASE 15: IF POINT(X + 15, Y + 15) THEN NextBlock: EXIT SUB
		IF POINT(X + 25, Y + 35) THEN NextBlock: EXIT SUB
	CASE 16: IF POINT(X + 5, Y + 35) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 35) THEN NextBlock: EXIT SUB
	CASE 17: IF POINT(X + 5, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 25) THEN NextBlock: EXIT SUB
		IF POINT(X + 25, Y + 35) THEN NextBlock: EXIT SUB
	CASE 18: IF POINT(X + 5, Y + 35) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 15) THEN NextBlock: EXIT SUB
	CASE 19: IF POINT(X + 5, Y + 35) THEN NextBlock: EXIT SUB
		IF POINT(X + 15, Y + 35) THEN NextBlock: EXIT SUB
		IF POINT(X + 25, Y + 35) THEN NextBlock: EXIT SUB
	END SELECT
	RemoveBlock
	Y = Y + 10
	PutBlock
	Tim = TIMER
	EXIT SUB
END IF
END SUB

SUB NextBlock
IF BlockNext <> 0 THEN
	Block = BlockNext
	IF FX = 1 THEN LoadWAV "drop.wav", 11025
ELSE
	RANDOMIZE TIMER
	Block = RND * 6 + 1
	SELECT CASE Block
	CASE 2: Block = RND * 3 + 2
	CASE 3: Block = RND * 1 + 6
	CASE 4: Block = RND * 1 + 8
	CASE 5: Block = RND * 1 + 10
	CASE 6: Block = RND * 3 + 12
	CASE 7: Block = RND * 3 + 16
	END SELECT
END IF
LOCATE 11, 31: COLOR 200: PRINT "      "
Blocks = Blocks + 1
CheckRows
Score = Score + 1
COLOR 200: LOCATE 6, 30: PRINT Score
FOR X1 = 85 TO 115: IF POINT(X1, 15) THEN Ending: END
NEXT
X = 80: Y = 10
RANDOMIZE TIMER
BlockNext = RND * 6 + 1
SELECT CASE BlockNext
CASE 2: BlockNext = RND * 3 + 2
CASE 3: BlockNext = RND * 1 + 6
CASE 4: BlockNext = RND * 1 + 8
CASE 5: BlockNext = RND * 1 + 10
CASE 6: BlockNext = RND * 3 + 12
CASE 7: BlockNext = RND * 3 + 16
END SELECT
PutBlock
IF Delay = .001 THEN Delay = OldDelay
Tim = TIMER
DisplayNextBlock
END SUB

SUB NextMidi
IF Song = 0 THEN RANDOMIZE TIMER: Song = RND * 7 + 1
Song = Song + 1: IF Song = 9 THEN Song = 1
SELECT CASE Song
CASE 1: SongTime = TIMER + 139
CASE 2: SongTime = TIMER + 128
CASE 3: SongTime = TIMER + 130
CASE 4: SongTime = TIMER + 141
CASE 5: SongTime = TIMER + 149
CASE 6: SongTime = TIMER + 145
CASE 7: SongTime = TIMER + 123
CASE 8: SongTime = TIMER + 149
END SELECT
SongName$ = LTRIM$(STR$(Song) + ".mid")
END SUB

SUB PalGet (Col, R, G, B)
OUT &H3C7, Col: R = INP(&H3C9): G = INP(&H3C9): B = INP(&H3C9)
END SUB

SUB PalSet (Col, R, G, B)
OUT &H3C8, Col: OUT &H3C9, R: OUT &H3C9, G: OUT &H3C9, B
END SUB

SUB Pause
DIM Temp(1500)
Tim2! = TIMER - Tim
IF Sounds = 1 THEN PauseMidi
GET (130, 85)-(190, 115), Temp
LINE (131, 86)-(189, 114), 0, BF

X1 = 140: X2 = 180: Y1 = 95: Y2 = 105
LINE (X1 - 9, Y1 - 9)-(X2 + 9, Y2 + 9), 56, B
LINE (X1 - 8, Y1 - 8)-(X2 + 8, Y2 + 8), 55, B
LINE (X1 - 7, Y1 - 7)-(X2 + 7, Y2 + 7), 54, B
LINE (X1 - 6, Y1 - 6)-(X2 + 6, Y2 + 6), 53, B
LINE (X1 - 5, Y1 - 5)-(X2 + 5, Y2 + 5), 52, B
LINE (X1 - 4, Y1 - 4)-(X2 + 4, Y2 + 4), 51, B
LINE (X1 - 3, Y1 - 3)-(X2 + 3, Y2 + 3), 50, B
LINE (X1 - 2, Y1 - 2)-(X2 + 2, Y2 + 2), 49, B
LINE (X1 - 1, Y1 - 1)-(X2 + 1, Y2 + 1), 48, B
LINE (X1, Y1)-(X2, Y2), 47, B

Font 140, 96, "Pause", 10
DO: LOOP UNTIL INKEY$ <> ""
PUT (130, 85), Temp, PSET
Tim = TIMER - Tim2!
IF Sounds = 1 THEN ResumeMidi
END SUB

SUB PauseMidi STATIC
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
IF MIDI.PLAYTIME = 0 THEN
    MIDI.ERROR = 3
    EXIT SUB
END IF
IF asm$ = "" THEN
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H3) + CHR$(&H5)
	asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
	asm$ = asm$ + CHR$(&HCB)
END IF
DEF SEG = VARSEG(asm$)
offset% = SADD(asm$)
CALL ABSOLUTE(offset%)
PAUSED = TimeMidi!
IF PAUSED = 0! THEN PAUSED = .00001
MIDI.PLAYTIME = 0
MIDI.ERROR = 0
END SUB

SUB PlayGame
DIM Temp(1500)
Start:
DO
	IF TIMER >= Tim + Delay THEN MoveBlock 0, 1: Tim = TIMER
	a$ = INKEY$: IF a$ <> "" THEN K = ASC(RIGHT$(a$, 1))
	SELECT CASE K
	CASE 27: Again: END
	CASE 32: IF Delay = .001 THEN GOTO Start
		OldDelay = Delay: Delay = .001
	CASE 59: SaveGame
	CASE 72: Rotate
	CASE 75: MoveBlock -1, 0
	CASE 77: MoveBlock 1, 0
	CASE 80: MoveBlock 0, 1
	CASE 112: Pause
	END SELECT
	K = 0
	IF TIMER >= SongTime AND NoSound = 0 THEN
		NextMidi
		REDIM MIDI%(BytesRequired&(SongName$) \ 2)
		LoadMIDI SongName$, VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
		PlayMIDI VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
	END IF
	IF MIDI.ERROR <> 0 THEN
		a$ = MIDIError$
		CLS : SCREEN 0: WIDTH 80, 25: PALETTE
		LOCATE 1, 1: PRINT "An error has happened: "; a$
		PRINT : PRINT "Press any key to continue..."
		DO: LOOP WHILE INKEY$ = ""
		END
	END IF
LOOP
END SUB

DEFSNG A-Z
'PlayMIDI - Begins playing a MIDI file in the background.
SUB PlayMIDI (MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Check to see if the MIDI playing code has previously been loaded.
'If not, load it now.
IF asm$ = "" THEN
	'Load the machine codes into a string.
	asm$ = asm$ + CHR$(&H55)
	asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
	asm$ = asm$ + CHR$(&H8B) + CHR$(&H7)
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
	asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
	asm$ = asm$ + CHR$(&H5D)
	asm$ = asm$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
END IF
IF Sound.Disabled = 0 THEN
    'Call the machine language routine to play the music.
    DEF SEG = VARSEG(asm$)
    offset% = SADD(asm$)
    CALL ABSOLUTE(MIDISegment%, MIDIOffset%, offset%)
    'Start the MIDI timer.
    MIDI.PLAYTIME = TIMER
END IF
END SUB

DEFINT A-Z
SUB PutBlock
SELECT CASE Block
CASE 1: DrawBlock 55, X, Y: DrawBlock 55, X + 10, Y
	DrawBlock 55, X, Y + 10: DrawBlock 55, X + 10, Y + 10
CASE 2: DrawBlock 40, X + 10, Y: DrawBlock 40, X, Y + 10
	DrawBlock 40, X + 10, Y + 10: DrawBlock 40, X + 20, Y + 10
CASE 3: DrawBlock 40, X + 10, Y: DrawBlock 40, X + 10, Y + 10
	DrawBlock 40, X, Y + 10: DrawBlock 40, X + 10, Y + 20
CASE 4: DrawBlock 40, X, Y + 10: DrawBlock 40, X + 10, Y + 10
	DrawBlock 40, X + 20, Y + 10: DrawBlock 40, X + 10, Y + 20
CASE 5: DrawBlock 40, X + 10, Y: DrawBlock 40, X + 10, Y + 10
	DrawBlock 40, X + 20, Y + 10: DrawBlock 40, X + 10, Y + 20
CASE 6: DrawBlock 25, X, Y + 10: DrawBlock 25, X + 10, Y + 10
	DrawBlock 25, X + 20, Y + 10: DrawBlock 25, X + 30, Y + 10
CASE 7: DrawBlock 25, X + 10, Y: DrawBlock 25, X + 10, Y + 10
	DrawBlock 25, X + 10, Y + 20: DrawBlock 25, X + 10, Y + 30
CASE 8: DrawBlock 10, X + 10, Y: DrawBlock 10, X, Y + 10
	DrawBlock 10, X + 10, Y + 10: DrawBlock 10, X, Y + 20
CASE 9: DrawBlock 10, X, Y: DrawBlock 10, X + 10, Y
	DrawBlock 10, X + 10, Y + 10: DrawBlock 10, X + 20, Y + 10
CASE 10: DrawBlock 100, X, Y: DrawBlock 100, X, Y + 10
	DrawBlock 100, X + 10, Y + 10: DrawBlock 100, X + 10, Y + 20
CASE 11: DrawBlock 100, X + 10, Y: DrawBlock 100, X + 20, Y
	DrawBlock 100, X + 10, Y + 10: DrawBlock 100, X, Y + 10
CASE 12: DrawBlock 70, X, Y: DrawBlock 70, X + 10, Y
	DrawBlock 70, X + 20, Y: DrawBlock 70, X, Y + 10
CASE 13: DrawBlock 70, X, Y: DrawBlock 70, X, Y + 10
	DrawBlock 70, X, Y + 20: DrawBlock 70, X + 10, Y + 20
CASE 14: DrawBlock 70, X + 20, Y + 10: DrawBlock 70, X + 20, Y + 20
	DrawBlock 70, X + 10, Y + 20: DrawBlock 70, X, Y + 20
CASE 15: DrawBlock 70, X + 10, Y: DrawBlock 70, X + 20, Y
	DrawBlock 70, X + 20, Y + 10: DrawBlock 70, X + 20, Y + 20
CASE 16: DrawBlock 85, X + 10, Y: DrawBlock 85, X + 10, Y + 10
	DrawBlock 85, X + 10, Y + 20: DrawBlock 85, X, Y + 20
CASE 17: DrawBlock 85, X, Y + 10: DrawBlock 85, X + 10, Y + 10
	DrawBlock 85, X + 20, Y + 10: DrawBlock 85, X + 20, Y + 20
CASE 18: DrawBlock 85, X, Y: DrawBlock 85, X + 10, Y
	DrawBlock 85, X, Y + 10: DrawBlock 85, X, Y + 20
CASE 19: DrawBlock 85, X, Y + 10: DrawBlock 85, X, Y + 20
	DrawBlock 85, X + 10, Y + 20: DrawBlock 85, X + 20, Y + 20
END SELECT
END SUB

SUB RemoveBlock
SELECT CASE Block
CASE 1: LINE (X, Y)-(X + 19, Y + 19), 0, BF
CASE 2: LINE (X, Y + 10)-(X + 29, Y + 19), 0, BF
	LINE (X + 10, Y)-(X + 19, Y + 9), 0, BF
CASE 3: LINE (X + 10, Y)-(X + 19, Y + 29), 0, BF
	LINE (X, Y + 10)-(X + 9, Y + 19), 0, BF
CASE 4: LINE (X, Y + 10)-(X + 29, Y + 19), 0, BF
	LINE (X + 10, Y + 20)-(X + 19, Y + 29), 0, BF
CASE 5: LINE (X + 10, Y)-(X + 19, Y + 29), 0, BF
	LINE (X + 20, Y + 10)-(X + 29, Y + 19), 0, BF
CASE 6: LINE (X, Y + 10)-(X + 39, Y + 19), 0, BF
CASE 7: LINE (X + 10, Y)-(X + 19, Y + 39), 0, BF
CASE 8: LINE (X, Y + 10)-(X + 9, Y + 29), 0, BF
	LINE (X + 10, Y)-(X + 19, Y + 19), 0, BF
CASE 9: LINE (X, Y)-(X + 19, Y + 9), 0, BF
	LINE (X + 10, Y + 10)-(X + 29, Y + 19), 0, BF
CASE 10: LINE (X, Y)-(X + 9, Y + 19), 0, BF
	LINE (X + 10, Y + 10)-(X + 19, Y + 29), 0, BF
CASE 11: LINE (X, Y + 10)-(X + 19, Y + 19), 0, BF
	LINE (X + 10, Y)-(X + 29, Y + 9), 0, BF
CASE 12: LINE (X, Y)-(X + 29, Y + 9), 0, BF
	LINE (X, Y + 10)-(X + 9, Y + 19), 0, BF
CASE 13: LINE (X, Y)-(X + 9, Y + 29), 0, BF
	LINE (X + 10, Y + 20)-(X + 19, Y + 29), 0, BF
CASE 14: LINE (X, Y + 20)-(X + 29, Y + 29), 0, BF
	LINE (X + 20, Y + 10)-(X + 29, Y + 19), 0, BF
CASE 15: LINE (X + 10, Y)-(X + 19, Y + 9), 0, BF
	LINE (X + 20, Y)-(X + 29, Y + 29), 0, BF
CASE 16: LINE (X + 10, Y)-(X + 19, Y + 29), 0, BF
	LINE (X, Y + 20)-(X + 9, Y + 29), 0, BF
CASE 17: LINE (X, Y + 10)-(X + 29, Y + 19), 0, BF
	LINE (X + 20, Y + 20)-(X + 29, Y + 29), 0, BF
CASE 18: LINE (X, Y)-(X + 9, Y + 29), 0, BF
	LINE (X + 10, Y)-(X + 19, Y + 9), 0, BF
CASE 19: LINE (X, Y + 10)-(X + 9, Y + 19), 0, BF
	LINE (X, Y + 20)-(X + 29, Y + 29), 0, BF
END SELECT
WAIT &H3DA, 8, 8: WAIT &H3DA, 8
END SUB

SUB ResumeMidi
IF SBSIM.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 5: EXIT SUB
IF PAUSED = 0! THEN EXIT SUB
IF asm$ = "" THEN
	asm$ = ""
	asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H5)
	asm$ = asm$ + CHR$(&HCD) + CHR$(SBSIM.INTERRUPT)
	asm$ = asm$ + CHR$(&HCB)
END IF
DEF SEG = VARSEG(asm$)
offset% = SADD(asm$)
CALL ABSOLUTE(offset%)
MIDI.PLAYTIME = TIMER - PAUSED
PAUSED = 0!
MIDI.ERROR = 0
END SUB

SUB Rotate
SELECT CASE Block
CASE 1: EXIT SUB
CASE 2: IF POINT(X + 15, Y + 25) THEN EXIT SUB
	RemoveBlock
	Block = 3: PutBlock
CASE 3: IF POINT(X + 25, Y + 15) THEN EXIT SUB
	RemoveBlock
	Block = 4: PutBlock
CASE 4: IF POINT(X + 15, Y + 5) THEN EXIT SUB
	RemoveBlock
	Block = 5: PutBlock
CASE 5: IF POINT(X + 5, Y + 15) THEN EXIT SUB
	RemoveBlock
	Block = 2: PutBlock
CASE 6: IF POINT(X + 15, Y + 5) THEN EXIT SUB
	IF POINT(X + 15, Y + 25) THEN EXIT SUB
	RemoveBlock
	Block = 7: PutBlock
CASE 7: IF POINT(X + 5, Y + 15) THEN EXIT SUB
	IF POINT(X + 25, Y + 15) THEN EXIT SUB
	IF POINT(X + 35, Y + 15) THEN EXIT SUB
	RemoveBlock
	Block = 6: PutBlock
CASE 8: IF POINT(X + 5, Y + 5) THEN EXIT SUB
	IF POINT(X + 25, Y + 15) THEN EXIT SUB
	RemoveBlock
	Block = 9: PutBlock
CASE 9: IF POINT(X + 5, Y + 15) THEN EXIT SUB
	IF POINT(X + 5, Y + 25) THEN EXIT SUB
	RemoveBlock
	Block = 8: PutBlock
CASE 10: IF POINT(X + 15, Y + 5) THEN EXIT SUB
	IF POINT(X + 25, Y + 5) THEN EXIT SUB
	RemoveBlock
	Block = 11: PutBlock
CASE 11: IF POINT(X + 5, Y + 5) THEN EXIT SUB
	IF POINT(X + 15, Y + 25) THEN EXIT SUB
	RemoveBlock
	Block = 10: PutBlock
CASE 12: IF POINT(X + 5, Y + 25) THEN EXIT SUB
	IF POINT(X + 15, Y + 25) THEN EXIT SUB
	RemoveBlock
	Block = 13: PutBlock
CASE 13: IF POINT(X + 25, Y + 15) THEN EXIT SUB
	IF POINT(X + 25, Y + 25) THEN EXIT SUB
	RemoveBlock
	Block = 14: PutBlock
CASE 14: IF POINT(X + 15, Y + 5) THEN EXIT SUB
	IF POINT(X + 15, Y + 15) THEN EXIT SUB
	IF POINT(X + 25, Y + 5) THEN EXIT SUB
	RemoveBlock
	Block = 15: PutBlock
CASE 15: IF POINT(X + 5, Y + 5) THEN EXIT SUB
	IF POINT(X + 5, Y + 15) THEN EXIT SUB
	RemoveBlock
	Block = 12: PutBlock
CASE 16: IF POINT(X + 5, Y + 15) THEN EXIT SUB
	IF POINT(X + 25, Y + 15) THEN EXIT SUB
	IF POINT(X + 25, Y + 25) THEN EXIT SUB
	RemoveBlock
	Block = 17: PutBlock
CASE 17: IF POINT(X + 5, Y + 5) THEN EXIT SUB
	IF POINT(X + 15, Y + 5) THEN EXIT SUB
	IF POINT(X + 5, Y + 25) THEN EXIT SUB
	RemoveBlock
	Block = 18: PutBlock
CASE 18: IF POINT(X + 15, Y + 25) THEN EXIT SUB
	IF POINT(X + 25, Y + 25) THEN EXIT SUB
	RemoveBlock
	Block = 19: PutBlock
CASE 19: IF POINT(X + 15, Y + 5) THEN EXIT SUB
	IF POINT(X + 15, Y + 15) THEN EXIT SUB
	RemoveBlock
	Block = 16: PutBlock
END SELECT
END SUB

SUB SaveGame
CLOSE
OPEN "save1.dat" FOR OUTPUT AS #1
PRINT #1, Score
PRINT #1, Level
PRINT #1, X
PRINT #1, Y
PRINT #1, Block
PRINT #1, BlockNext
PRINT #1, Delay
PRINT #1, Rows
CLOSE
SaveScreen "save1.scr"
IF FX = 1 THEN LoadWAV "saved.wav", 11025
LOCATE 11, 31: COLOR 200: PRINT "Saved!"
END SUB

SUB SaveHighScores
CLOSE
Sco = FREEFILE
OPEN "tetris.sco" FOR OUTPUT AS Sco
FOR a = 1 TO 3
PRINT #Sco, Names$(a)
PRINT #Sco, Scores(a)
NEXT
CLOSE
END SUB

SUB StopMidi STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Stop the music!!
IF asm$ = "" THEN
    asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
    asm$ = asm$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
    asm$ = asm$ + CHR$(&HCB)
END IF
IF MIDI.PLAYTIME THEN
    DEF SEG = VARSEG(asm$)
    offset% = SADD(asm$)
    CALL ABSOLUTE(offset%)
    MIDI.ERROR = 0
ELSE
    MIDI.ERROR = 3
END IF
'No MIDI file is playing, so reset the timer
MIDI.PLAYTIME = 0
END SUB

FUNCTION TimeMidi!
IF PAUSED > 0! THEN
    TimeMidi! = PAUSED
    MIDI.ERROR = 0
ELSEIF MIDI.PLAYTIME THEN
    CurrentTime! = TIMER
    IF CurrentTime! - MIDI.PLAYTIME < 0 THEN CurrentTime! = 86400 + CurrentTime!
    TimeMidi! = CurrentTime! - MIDI.PLAYTIME
    MIDI.ERROR = 0
ELSE
    MIDI.ERROR = 3
END IF
END FUNCTION

