{ Classic Game "Connect 4", Copyright 1997 by George M. Tzoumas
  Version 3.0 }

{ This program is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
Use this software AT YOUR OWN RISK. }

{$S-,D+,L+,R-,N+,E+}
program Score4;

uses Crt, Basic, StrHan, Fade, Graph, AdvOpl, SBAudio, XSound, Mouse;

type
  ByteSet = Set of Byte;
  TPlayer = record Color, HiColor: Byte end;
  TRect = record A, B: PointType end;
  TTable = record
             Data: Array[1..7, 1..6] of Byte;
             Filled : Array[1..7] of Byte;
           end;

  SoundDevice = (PCSpeaker, SoundCard);

  Byte4 = array[1..4] of Byte;

  TLine = record
    Val: Real;
    Kind, x, y, Rank, Owner{, Fill}: Byte;
    Dead: Boolean;
  end;

  TPos = record
    ml: Byte; { max lines }
    Lin, Pos: array[1..13] of Byte;
  end;

const
  CSize  = 24;
  CSpace = 6;

  No4        = 0;
  Horiz4     = 1;
  Vert4      = 2;
  DiagRight4 = 3;
  DiagLeft4  = 4;

  Players : array[1..2] of TPlayer =
    ((Color: Yellow; HiColor: Yellow),
     (Color: Red; HiColor: LightRed));

  PlayerType : array[0..1,0..1] of String[11] =
  (('HUMAN', 'COMPUTER'),
   ('', ''));

  AlgorStr : array[0..1] of String[14] =
  ('Algorithm : ', '樠  : ');

  PlayerStr : array[0..1,1..2] of String[14] =
  (('PLAYER 1  : ', 'PLAYER 2  : '),
   ('1  : ', '2  : '));

  DrawStr: array[0..1] of String[8] = ('DRAW', '');
  ThinkStr: array[0..1] of String[13] = ('THINKING ...', ' ...');

  NameStr: array[0..1] of String[19] = ('George M. Tzoumas', '騚 . 磘');
  PrgStr: array[0..1] of String[15] = ('programmer', '');
  VerStr: array[0..1] of String[7] = ('Version', '');

  Values : array[1..8] of LongInt =
  (1000000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10);

  Vals: array[0..4] of Real = (0, 1, 20, 40000, 800000);

  LevelStr: array[0..1,1..6] of String =
  (('Line Scan', 'Line Scan and Search (6)', 'Line Scan and Search (8)',
    'Search (4)', 'Search (6)', 'Search (8)'),
   ('室 ', '室   㫞 (6)', '室   㫞 (8)',
    '㫞 (4)', '㫞 (6)', '㫞 (8)'));

  DLevelMap: array[1..6] of Byte = (0, 6, 8, 4, 6 ,8);

var
   Table: TTable;
   Lines : array[1..69] of TLine;
   VTable: array[1..7, 1..6] of TPos;

   TablePos: Array[1..7, 1..6] of PointType;
   gd, gm, sx, sy: Integer;    { sx, sy = origin of rect }
   DiffRect, PlayerRect, TurnRect, TableRect: TRect;
   Won, Player{, incd} : Byte;
   LastMove : String;
   WantToExit : Boolean;
{   SysTimer : Longint absolute $40:$6C;
   cx: Longint;}
   MoveNo : Byte;   { Current move number }
   Depth  : Byte;   { Depth of forward move analysis ! }
   DLevel : Byte;   { Difficulty Level }
   Demo   : Array[1..2] of Boolean;
   GSound, GMusic : SoundDevice;
   SoundOn, MusicOn, FPCSpk, NoFade, Analysis: Boolean;
   Greek: Byte;

procedure Toggle(var b: Boolean);
inline ($5F/          { pop di }
        $07/          { pop es }
        $80/$35/$01); { xor es: byte ptr [di], 1 }
{  b := not b;}

procedure AssignRect(var R: TRect; x1, y1, x2, y2: Integer);
begin
  R.A.X := x1; R.A.Y := y1;
  R.B.X := x2; R.B.Y := y2;
end;

function InRect(R: TRect; x, y: Integer): Boolean;
begin
  InRect := (x >= R.A.X) and (x <= R.B.X) and (y >= R.A.Y) and (y <= R.B.Y);
end;

procedure Warn;
begin
  if not SoundOn then Exit;
  if GSound = PCSpeaker then
  begin
    Sound(300); Delay(10); Nosound;
  end else DACSample(9);
end;

procedure Beep;
begin
  if not SoundOn then Exit;
  if GSound = PCSpeaker then
  begin
    Sound(800); Delay(10); Nosound;
  end else DACSample(8);
end;

procedure InitSound;
var
  F: File;
  i: Byte;
begin
  SoundOn := True;
  MusicOn := True;
  if FPCSpk then IOBase := 0;
  if IOBase = 0 then GSound := PCSpeaker else GSound := SoundCard;
  if IOBase = 0 then GMusic := PCSpeaker else GMusic := SoundCard;
  if GMusic <> SoundCard then MusicOn := False;
  if GSound <> SoundCard then Exit;
  Assign(F, 'SCORE4.SND');
{  Assign(F, ParamStr(0));}
  Reset(F, 1);
{  Seek(F, FileSize(F) - 41210);}
  LoadSample(F, 1,  5589);
  LoadSample(F, 2,  3989);
  LoadSample(F, 3,  2885);
  LoadSample(F, 4,  2238);
  LoadSample(F, 5,  1819);
  LoadSample(F, 6,   830);
  LoadSample(F, 7, 21616);
  LoadSample(F, 8,   702);
  LoadSample(F, 9,  1542);
  Close(F);
  for i := 1 to 9 do SetRate(i, 22050);
  for i := 1 to 9 do SignSample(i);
end;

procedure InitVars;
var i, j, k: Byte;
begin
  FillChar(VTable, SizeOf(VTable), 0);
  FillChar(Lines, SizeOf(Lines), 0);
  for i := 1 to 6 do for j := 1 to 4 do { Horizontal }
  begin
    for k := j to j + 3 do
    begin
      Inc(VTable[k,i].ml);
      VTable[k,i].Lin[VTable[k,i].ml] := (i-1)*4 + j;
      VTable[k,i].Pos[VTable[k,i].ml] := k - j + 1;
    end;
    with Lines[(i-1)*4 + j] do
    begin
      Kind := Horiz4;
      x := j;
      y := i;
    end;
  end;

  for i := 1 to 7 do for j := 1 to 3 do { Vertical }
  begin
    for k := j to j + 3 do
    begin
      Inc(VTable[i,k].ml);
      VTable[i,k].Lin[VTable[i,k].ml] := 24 + (i-1)*3 + j;
      VTable[i,k].Pos[VTable[i,k].ml] := k - j + 1;
    end;
    with Lines[24 + (i-1)*3 + j] do
    begin
      Kind := Vert4;
      x := i;
      y := j;
    end;
  end;
  for i := 1 to 4 do for j := 1 to 3 do { Diag up Right }
  begin
    for k := 0 to 3 do
    begin
      Inc(VTable[i+k,j+k].ml);
      VTable[i+k,j+k].Lin[VTable[i+k,j+k].ml] := 45 + (i-1)*3 + j;
      VTable[i+k,j+k].Pos[VTable[i+k,j+k].ml] := k+1;
    end;
    with Lines[45 + (i-1)*3 + j] do
    begin
      Kind := DiagRight4;
      x := i;
      y := j;
    end;
  end;

  for i := 7 downto 4 do for j := 1 to 3 do { Diag up Left }
  begin
    for k := 0 to 3 do
    begin
      Inc(VTable[i-k,j+k].ml);
      VTable[i-k,j+k].Lin[VTable[i-k,j+k].ml] := 57 + (7-i)*3 + j;
      VTable[i-k,j+k].Pos[VTable[i-k,j+k].ml] := k+1;
    end;
    with Lines[57 + (7-i)*3 + j] do
    begin
      Kind := DiagLeft4;
      x := i;
      y := j;
    end;
  end;
end;


procedure UpdateLine(n, {p,} who: Byte);
begin
  if Lines[n].Dead then Exit;
  with Lines[n] do
  begin
    If Rank = 0 then Owner := who else if who <> Owner then
    begin
      Val := 0;
      Dead := True;
      Exit;
    end;
    begin
      Inc(Rank);
      Val := Vals[Rank];
{      Fill := Fill or 1 shl (p-1);}
    end;
  end;
end;

procedure DeUpdateLine(n{, p, who}: Byte);
begin
  with Lines[n] do
  begin
    if Dead then
    begin
      Val := Vals[Rank];
      Dead := False;
      Exit;
    end else
    if Rank = 0 then Exit else
    begin
      Dec(Rank);
      Val := Vals[Rank];
      if Rank = 0 then Owner := 0;
{      Fill := Fill or 1 shl (p-1);}
    end;
  end;
end;

procedure UpdatePos(x, y, who: Byte);
var i: Byte;
begin
  for i := 1 to VTable[x,y].ml do
    UpdateLine(VTable[x,y].Lin[i], {VTable[x,y].Pos[i],} who);
end;

procedure DeUpdatePos(x, y, who: Byte);
var i: Byte;
begin
  for i := 1 to VTable[x,y].ml do
    DeUpdateLine(VTable[x,y].Lin[i]{, VTable[x,y].Pos[i], who});
end;

procedure InitGraphics;
var i, j: Byte;
begin
  gd := VGA;
  gm := VGAHi;
  InitGraph(gd, gm, 'c:\bp\bgi');
  DirectVideo := False;
  sx := (640 - (CSpace + CSize) * 12) shr 1;
  sy := (480 - (CSpace + CSize) * 10) shr 1;
  for j:=0 to 5 do for i:=0 to 6 do
  begin
    TablePos[i+1,6-j].X := sx+i*(CSpace + CSize) shl 1;
    TablePos[i+1,6-j].Y := sy+j*(CSpace + CSize) shl 1;
  end;
{  AssignRect(DiffRect, 0, 24, 340, 32);}
  AssignRect(TableRect, sx - CSpace - CSize, sy - CSpace - CSize,
            sx + 6 * (CSpace + CSize) shl 1 + CSpace + CSize,
            sy + 5 * (CSpace + CSize) shl 1 + CSpace + CSize);
  AssignRect(PlayerRect, 0, 0, 200, 20);
  AssignRect(TurnRect, 0, 463, 160, 471);
  M_Reset;
end;

procedure Stars;
var i, x, y: Integer;
begin
  for i := 1 to 200 do
  begin
    repeat
      x := Random(640);
      y := Random(480);
    until GetPixel(x, y) = 0;
    PutPixel(x, y, Random(14) + 1);
  end;
end;

procedure DrawTable;
var j, i: Byte;
begin
  SetColor(White);
  for j:=0 to 5 do for i:=0 to 6 do
    Circle(TablePos[i+1,6-j].X, TablePos[i+1,6-j].Y, CSize);
  with TableRect do Rectangle(A.X, A.Y, B.X, B.Y);
  SetFillStyle(SolidFill, Blue);
  FloodFill(sx - CSpace - CSize + 1, sy - CSpace - CSize + 1, 15);
  for i:=1 to 7 do
    OutTextXY(TablePos[i,1].X - 4, sy + 5 * (CSpace + CSize) shl 1 + CSpace shl 1 + CSize,
      Chr(48+i));
end;

procedure RefreshTable;
var i, j: Integer;
begin
  M_Hide;
  for i := 1 to 7 do for j := 1 to Table.Filled[i] do
  begin
    SetFillStyle(SolidFill, Table.Data[i,j]);
    FloodFill(TablePos[i, j].X, TablePos[i, j].Y, 15);
  end;
  M_Show;
end;

procedure RefreshTableAbs;
var i, j: Integer;
begin
  M_Hide;
  for i := 1 to 7 do for j := 1 to 6 do
  begin
    SetFillStyle(SolidFill, Table.Data[i,j]);
    FloodFill(TablePos[i, j].X, TablePos[i, j].Y, 15);
  end;
  M_Show;
end;

function M_Column: Byte;
var
  i, f: Byte;
  x, y, Delta: Integer;
begin
  Delta := 640;
  x := M_XPos;
  y := M_YPos;
  for i := 1 to 7 do if Abs(x - TablePos[i, 1].X) < Delta then
  begin
    Delta := Abs(x - TablePos[i, 1].X);
    f := i;
  end;
  if (y > sy - CSpace - CSize) and
     (y < sy + 5 * (CSpace + CSize) shl 1 + CSpace + CSize + 24) and
     (x > sx - CSpace - CSize) and
     (x < sx + 6 * (CSpace + CSize) shl 1 + CSpace + CSize) then
     M_Column := f else M_Column := 0;
end;

procedure Message(s: String; Color, Where: Word);
begin
{  Exit;}
  M_Hide;
  SetFillStyle(SolidFill, Black);
  Bar(0,Where,400,Where+8);
  SetColor(Color);
  OutTextXY(0,Where, s);
  M_Show;
end;

procedure BarMessage(s: String; Color: Word);
begin
  Message(s, Color, 463);
end;

procedure ShowPlayerType;
begin
  Message(PlayerStr[Greek][1] + PlayerType[Greek, Byte(Demo[1])], Players[1].HiColor, 0);
  Message(PlayerStr[Greek][2] + PlayerType[Greek, Byte(Demo[2])], Players[2].HiColor, 12);
end;

procedure ShowDiff;
var sd: String;
begin
  sd := AlgorStr[Greek] + LevelStr[Greek, DLevel];
  Message(sd, LightMagenta, 24);
  AssignRect(DiffRect, 0, 24, TextWidth(sd), 32);
end;

procedure DrawPawn(Col, Row, Player: Byte; Winning: Boolean);
var c: Byte;
begin
  M_Hide;
  if Player > 0 then c := Players[Player].Color else c := 0;
  if not Winning then SetFillStyle(SolidFill, c)
    else SetFillStyle(InterleaveFill, c);
  FloodFill(TablePos[Col, Row].X, TablePos[Col, Row].Y, 15);
  M_Show;
end;

procedure ThrowInTable(Col, Player: Byte; var ATable: TTable; Draw: Boolean);
begin
  if ATable.Filled[Col] = 6 then Exit;
  Inc(ATable.Filled[Col]);
  ATable.Data[Col, ATable.Filled[Col]] := Players[Player].Color;
  if Draw then
  begin
    DrawPawn(Col, ATable.Filled[Col], Player, False);
    UpdatePos(Col, ATable.Filled[Col], Player);
  end;
end;

procedure TakeBack(Col, ForWhom: Byte; var ATable: TTable; Draw: Boolean);
begin
  if ATable.Filled[Col] = 0 then Exit;
  ATable.Data[Col, ATable.Filled[Col]] := 0;
  if Draw then
  begin
    DrawPawn(Col, ATable.Filled[Col], 0, False);
    DeUpdatePos(Col, ATable.Filled[Col], ForWhom);
  end;
  Dec(ATable.Filled[Col]);
end;

procedure BlinkWinnerHoriz(Col, Row, Player: Byte);
var m: Byte;
begin
  for m := Col to Col + 3 do DrawPawn(m, Row, Player, True);
end;

procedure BlinkWinnerVert(Col, Row, Player: Byte);
var m: Byte;
begin
  for m := Row to Row + 3 do DrawPawn(Col, m, Player, True);
end;

procedure BlinkWinnerDiagRight(Col, Row, Player: Byte);
var m: Byte;
begin
  for m := 0 to 3 do DrawPawn(Col + m, Row + m, Player ,True);
end;

procedure BlinkWinnerDiagLeft(Col, Row, Player: Byte);
var m: Byte;
begin
  for m := 0 to 3 do DrawPawn(Col - m, Row + m, Player ,True);
end;

{function BFind4(var ATable: TTable; Player: Byte): Boolean;
var
  i,j,c: Byte;
  v: Boolean;
begin
  v := False;
  for i := 1 to 7 do
  begin
    c := ATable.Filled[i];
    if c = 0 then Continue;
    for j := 1 to VTable[i,c].ml do if not v then
      if (Lines[VTable[i,c].Lin[j]].Dead = False) and
      (Lines[VTable[i,c].Lin[j]].Owner = Player) and
        (Lines[VTable[i,c].Lin[j]].Rank = 3) then v := True;
    if v then Break;
  end;
  BFind4 := v;
end;}

function Find4(var ATable: TTable; Player: Byte; var x, y: Byte): Byte;

  procedure FindHoriz(var Col, Row: Byte);
  var i, j, k, v: Byte;
  begin
    for j := 1 to 6 do for i := 1 to 4 do
    begin
      v := 0;
      for k := i to i + 3 do if (ATable.Data[k, j] = Players[Player].Color) then Inc(v) else Break;
      if v = 4 then begin Col := i; Row := j; Exit; end;
{      i := k;
      if i >= 4 then Break;}
    end;
    Col := 0; Row := 0;
  end;

  procedure FindVert(var Col, Row: Byte);
  var i, j, k, v: Byte;
  begin
    for j := 1 to 7 do for i := 1 to 3 do
    begin
      v := 0;
      for k := i to i + 3 do if (ATable.Data[j, k] = Players[Player].Color) then Inc(v) else Break;
      if v = 4 then begin Col := j; Row := i; Exit; end;
{      i := k;
      if i >= 3 then Break;}
    end;
    Col := 0; Row := 0;
  end;

  procedure FindDiagRight(var Col, Row: Byte);
  var i, j, k, v: Byte;
  begin
    for i := 1 to 4 do for j := 1 to 3 do
    begin
      v := 0;
      for k := 0 to 3 do if (ATable.Data[i + k, j + k] = Players[Player].Color) then Inc(v) else Break;
      if v = 4 then begin Col := i; Row := j; Exit; end;
{      if k > 1 then Inc(j, k - 1);
      if j >= 3 then Break;}
    end;
    Col := 0; Row := 0;
  end;

  procedure FindDiagLeft(var Col, Row: Byte);
  var i, j, k, v: Byte;
  begin
    for i := 7 downto 4 do for j := 1 to 3 do
    begin
      v := 0;
      for k := 0 to 3 do if (ATable.Data[i - k, j + k] = Players[Player].Color) then Inc(v) else Break;
      if v = 4 then begin Col := i; Row := j; Exit; end;
{      if k > 1 then Inc(j, k - 1);
      if j >= 3 then Break;}
    end;
    Col := 0; Row := 0;
  end;

begin
  FindHoriz(x, y);
  if (x <> 0) and (y <> 0) then begin Find4 := Horiz4; Exit end;
  FindVert(x, y);
  if (x <> 0) and (y <> 0) then begin Find4 := Vert4; Exit end;
  FindDiagRight(x, y);
  if (x <> 0) and (y <> 0) then begin Find4 := DiagRight4; Exit end;
  FindDiagLeft(x, y);
  if (x <> 0) and (y <> 0) then begin Find4 := DiagLeft4; Exit end;
  Find4 := No4;
end;

procedure CheckWinner;
var ScoreType, x, y : Byte;
begin
  ScoreType := Find4(Table, Player, x, y);
  if ScoreType = No4 then Exit;
  case ScoreType of
    Horiz4     : BlinkWinnerHoriz(x, y, Player);
    Vert4      : BlinkWinnerVert(x, y, Player);
    DiagRight4 : BlinkWinnerDiagRight(x, y, Player);
    DiagLeft4  : BlinkWinnerDiagLeft(x, y, Player);
  end;
  Won := Player;
  if Greek = 0 then
    BarMessage('PLAYER '+Chr(48+Won)+' WINS', Players[Won].HiColor)
  else
    BarMessage('  '+Chr(48+Won)+' ', Players[Won].HiColor)
end;

procedure CheckDraw;
begin
  if (MoveNo < 42) or (Won <> 0) then Exit;
  BarMessage(DrawStr[Greek], White);
  Won := 3;
end;

function NextPlayer(Who: Byte): Byte;
inline ($58/      { pop ax }
        $34/$03); { xor al, 3 }
{ Who := Who xor 3 }

function ValidMove(Where: Byte; var ATable: TTable): Boolean;
inline ($5F/                 { pop di }
        $07/                 { pop es }
        $58/                 { pop ax }
        $30/$E4/             { xor ah, ah }
        $01/$C7/             { add di, ax }
        $26/$80/$7D/$29/$06/ { cmp es: byte ptr [di+$29], 06 }
        $B0/$00/             { mov al, 00 }
        $74/$01/             { jne +1 }
        $40);                { inc ax }
{ ValidMove := ATable.Filled[Where] <> 6 }

procedure GetValidMoves(var s: ByteSet; var ATable: TTable);
var i: Byte;
begin
  s := [];
  for i := 1 to 7 do if ValidMove(i, ATable) then s := s + [i];
end;

{function BigSet(s: ByteSet): Boolean;
var i, v: Byte;
begin
  i := 0;
  v := 0;
  repeat
    Inc(i);
    if i in s then Inc(v);
  until (i = 7) or (v > 1);
  BigSet := v > 1;
end;}

function PosVal(x, y, who: Byte): Real;
var
  v: Real;
  i: Byte;
begin
  v := 0;
  for i := 1 to VTable[x,y].ml do
  if not Lines[VTable[x,y].Lin[i]].Dead then
    if Lines[VTable[x,y].Lin[i]].Owner = who then
      v := v + Lines[VTable[x,y].Lin[i]].Val;
  PosVal := v;
end;

function ColVal(Col, who: Byte): Real;
var
  v, v2, c: Real;
  r: Byte;
begin
  r := Table.Filled[Col] + 1;
  if not ValidMove(Col, Table) then v := -10000000 else
  begin
    v := PosVal(Col, r, who)*3/2 + PosVal(Col, r, NextPlayer(who));
    if r < 6 then v := v - PosVal(Col, r+1, NextPlayer(who))*2/3;
{    begin
      v2 := PosVal(Col, r+1, NextPlayer(who))*2/3;
      if v2 > v then v := v - v2;
    end;}
  end;
  ColVal := v;
end;

function FindMove(ForWhom: Byte; an: Boolean): Byte;
var
  i: Byte;
  m: Real;
  s: String;
  mv: array[1..7] of Real;
begin
  m := -1000000;
  s := '';
  for i := 1 to 7 do mv[i] := ColVal(i, ForWhom);
  for i := 1 to 7 do if mv[i] > m then m := mv[i];
  for i := 1 to 7 do if mv[i] = m then s := s + Char(i);
  if an then for i := 1 to 7 do begin Gotoxy(67,i); Write(mv[i]:13:3); end;
  FindMove := Byte(s[Random(Length(s))+1]);
end;

function FindMove2(ForWhom: Byte): Byte;
var x, y, i, d2, o, dd: Byte;
    mv: array[1..7] of Longint;
    r: Longint;
    s: string;
    BreakMove, first: Boolean;
{    wsf: Longint;}

  procedure WhereMakes4(var s, b: ByteSet; who: Byte; var ATable: TTable; Extend: Boolean);
  var
    i,nwho: Byte;
  begin
    nwho := NextPlayer(who);
    s := [];
    if Extend then b := [];
    for i := 1 to 7 do if ValidMove(i, ATable) then
    begin
      ThrowInTable(i, who, ATable, False);
      if Find4(ATable, who, x, y) <> No4 then s := s + [i];
{      if BFind4(ATable, who) then s := s + [i];}
      if Extend and (ValidMove(i, ATable)) then
      begin
        ThrowInTable(i, nwho, ATable, False);
        if Find4(ATable, nwho, x, y) <> No4 then b := b + [i];
{        if BFind4(ATable, nwho) then b := b + [i];}
        TakeBack(i, nwho, ATable, False);
      end;
      TakeBack(i, who, ATable, False);
    end;
  end;

(*  procedure scanmoves(who: Byte; d: Byte; var ATable: TTable);
  var
    i, f: Byte;
    w, m, p, b : ByteSet;
    forced: Boolean;
  begin
    if KeyPressed then if UpCase(ReadKey) = 'V' then BreakMove := True;
    if M_ButtonPressed <> 0 then if InRect(TurnRect, M_XPos, M_YPos) then
    begin
      Delay(150);
      BreakMove := True;
    end;
    if BreakMove then Exit;
    WhereMakes4(m, b, who, ATable, True);
    WhereMakes4(p, b, NextPlayer(who), ATable, False);
    w := m;
    if (w = []) and (d > 1) then w := p;
    if w = [] then GetValidMoves(w, ATable);
    if (m = []) and (p <> []) and (s = '') then
    begin
      for i := 1 to 7 do if ValidMove(i, ATable) and not (i in p) then Dec(mv[i], Values[1]);
      Exit;
    end;
    if (m = []) and (b <> []) and (s='') then
    begin
      for i := 1 to 7 do if ValidMove(i, ATable) and (i in b) then Dec(mv[i], Values[1]);
    end;
    if w - b <> [] then w := w - b;
    forced := (w - [i] = []) and (Length(s) < d2);
    for i := 1 to 7 do
    begin
{      if mv[i] < wsf then Exit;}
      if not (i in w) then Continue;
      s := s + Char(i);
      f := Byte(i in m);
      if f <> No4 then
      begin
        if who = ForWhom then Inc(mv[Byte(s[1])], Values[d])
        else Dec(mv[Byte(s[1])], Values[d]);
        if Analysis then for i := 1 to 7 do begin Gotoxy(67,i); Write(mv[i]:13); end;
      end;
      if (d < o) and (f = No4) and ((d < Depth) and (not forced) or forced) then
      begin
        ThrowInTable(i, who, ATable, False);
        scanmoves(NextPlayer(who), d+Byte(not forced), ATable);
        TakeBack(i, who, ATable, False);
      end;
{      if (d = 1) then if mv[i] < wsf then wsf := mv[i];}
      Dec(s[0]);
    end;
  end;*)
  procedure scanmoves(who: Byte; d: Byte; var ATable: TTable);
  var m, b, p, w: ByteSet;
      i: Byte;
  begin
    if KeyPressed then if UpCase(ReadKey) = 'V' then BreakMove := True;
    if M_ButtonPressed <> 0 then if InRect(TurnRect, M_XPos, M_YPos) then
    begin
      Delay(150);
      BreakMove := True;
    end;
    if BreakMove then Exit;
    if (d > Depth) or (Length(s) > d) then Exit;
    WhereMakes4(m, p, who, ATable, True);
    WhereMakes4(b, p, NextPlayer(who), ATable, False);
    GetValidMoves(w, ATable);
    if (p <> []) and (m = []) then if d = 1 then for i := 1 to 7 do if i in p then mv[i] := mv[i] - Values[d];
    if w - p <> [] then w := w - p;
    if m <> [] then
    begin
      for i := 1 to 7 do if i in m then
      begin
        if s[0] = #0 then
          if Who = ForWhom then mv[i] := mv[i] + Values[d] else mv[i] := mv[i] - Values[d]
        else
          if Who = ForWhom then mv[Byte(s[1])] := mv[Byte(s[1])] + Values[d]
            else mv[Byte(s[1])] := mv[Byte(s[1])] - Values[d];
        if Analysis then for i := 1 to 7 do begin Gotoxy(67,i); Write(mv[i]:13); end;
      end;
      Exit;
    end;
    if b <> [] then
    begin
      if s[0] = #0 then for i := 1 to 7 do if (i in w) and not (i in b) then mv[i] := mv[i] - Values[d] else
      else
      for i := 1 to 7 do if i in b then
      begin
        s := s + Char(i);
        ThrowInTable(i, Who, ATable, False);
        if (Who = ForWhom) and not first and (d>2) then Dec(d);
        first := True;
        ScanMoves(Who xor 3, d, ATable);
        TakeBack(i, Who, ATable, False);
        Dec(s[0]);
      end;
      Exit;
    end;
    for i := 1 to 7 do if i in w then
    begin
      s := s + Char(i);
      ThrowInTable(i, Who, ATable, False);
      first := False;
      ScanMoves(Who xor 3, d+1, ATable);
      TakeBack(i, Who, ATable, False);
      Dec(s[0]);
    end;
  end;


begin
  d2 := Depth * 3 div 2;
  mv[4] := 2;
  mv[3] := 2;
  mv[5] := 2;
  mv[2] := 1;
  mv[6] := 1;
  mv[1] := 0;
  mv[7] := 0;
  for i := 1 to 7 do if not ValidMove(i, Table) then mv[i] := -2000000000;
  if Analysis then for i := 1 to 7 do begin Gotoxy(67,i); Write(mv[i]:13); end;
  s := '';
  BreakMove := False;
  o := d2;
{  wsf := -2000000000;}
  first := True;
  if MoveNo > 1 then ScanMoves(ForWhom, 1, Table);
  s := '';
  r := -2000000000;
  for i := 1 to 7 do if mv[i] > r then r := mv[i];
  for i := 1 to 7 do if mv[i] = r then s := s + Char(i);
  if BreakMove then if Demo[ForWhom] then
  begin
    Demo[NextPlayer(ForWhom)] := False;
    ShowPlayerType;
  end;
  dd := $FF;
  if (DLevel in [2,3]) or BreakMove then dd := FindMove(ForWhom, False);
  if Pos(Char(dd), s) <> 0 then FindMove2 := dd else
    FindMove2 := Byte(s[Random(Length(s))+1]);
end;

procedure ThrowInSound(ACol : Byte);
begin
  if not SoundOn then Exit;
  if (GSound = PCSpeaker) then Beep else
  if (GSound = SoundCard) and (SoundOn) then DACSample(Table.Filled[ACol]+1);
end;

procedure NewGameSound;
begin
  if (GSound = PCSpeaker) then Beep else
  if (GSound = SoundCard) and (SoundOn) then DACSample(7);
end;

procedure ShowTurn;
begin
  if Greek = 0 then
    BarMessage('PLAYER '+Chr(48+Player)+' TO PLAY', Players[Player].HiColor)
  else
    BarMessage('  '+Chr(48+Player)+' ', Players[Player].HiColor)
end;

procedure ChangeTurn;
begin
  if (Won = 0) and (MoveNo < 42) then Player := NextPlayer(Player);
  ShowTurn;
end;

procedure PlayerMakeMove(Who: Byte; p: Byte);
var w : Byte;
begin
  if p = 0 then Exit;
  if not ValidMove(p, Table) then begin Warn; Exit; end;
  ThrowInSound(p);
  ThrowInTable(p, Who, Table, true);
  LastMove := LastMove + Char(p);
  Inc(MoveNo);
  CheckWinner;
  if Won <> 0 then Exit;
  ChangeTurn;
  if M_ButtonPressed = 0 then if Demo[Player] then Delay(150);
end;

procedure ComputerMakeMove(Who: Byte);
var f: Byte;
begin
{  cx := SysTimer;}
  BarMessage(ThinkStr[Greek], Players[Player].HiColor);
  case DLevel of
    1: f := FindMove(Who, Analysis);
    2,3: if MoveNo < 21 then f := FindMove(Who, Analysis) else f := FindMove2(Who);
    4..6: f := FindMove2(Who);
  end;
  ThrowInSound(f);
  ThrowInTable(f, Who, Table, true);
  LastMove := LastMove + Char(f);
  Inc(MoveNo);
  CheckWinner;
  if Won <> 0 then Exit;
  ChangeTurn;
  if Demo[Player] then Delay(150);
{  if Demo[Player] and (MoveNo <> 42) then if SysTimer - cx < 18 then
    Delay(1000 - (SysTimer - cx) * 1000 div 18);}
end;

procedure ChangeLevel(Upwards: Boolean);
begin
  if Upwards then if DLevel < 6 then Inc(DLevel) else DLevel := 1;
  if not Upwards then if DLevel > 1 then Dec(DLevel) else DLevel := 6;
  Depth := DLevelMap[DLevel];
  ShowDiff;
end;

procedure NewGame;
begin
  M_Hide;
  ClearDevice;
  NewGameSound;
  DrawTable;
  Stars;
  Player := 1;
  FillChar(Table, SizeOf(Table), 0);
  InitVars;
  Won := 0;
  WantToExit := False;
  MoveNo := 0;
  FillChar(LastMove, SizeOf(LastMove), $FF);
  Lastmove[0]:=#0;
  if Demo[1] and Demo[2] then
  begin
    Demo[1]:=False;
    Demo[2]:=True;
  end;
  ShowPlayerType;
  ShowDiff;
  ShowTurn;
  M_Show;
end;

function DemoPlay: Boolean;
begin
  DemoPlay := Demo[1] and Demo[2];
end;

function Playing: Boolean;
begin
  Playing := (Won = 0) and (MoveNo <> 42);
end;

procedure ShowHint;
var {d,} f: Byte;
begin
  if not Playing then Exit;
  if Demo[Player] then Exit;
{  d := Depth;
  Depth := 4;}
  f := FindMove(Player, Analysis);
{  Depth := d;}
  if MouseYes then M_PutAt(TablePos[f, Table.Filled[f] + 1].X, TablePos[f, Table.Filled[f] + 1].Y)
  else begin
    SetColor(White);
    OutTextXY(623, 472, Char(48+f));
    Delay(100);
    SetColor(Black);
    OutTextXY(623, 472, Char(48+f));
  end;
end;

procedure TakeBackMove;
begin
  if DemoPlay then Exit;
  if LastMove = '' then begin Warn; Exit end;
  TakeBack(Byte(LastMove[Byte(LastMove[0])]), Player, Table, True);
  Beep;
  Dec(LastMove[0]);
  Dec(MoveNo);
  if Won in [1, 2] then RefreshTable;
  ChangeTurn;
  if Demo[Player] then
  begin
    Demo[Player] := False;
    Demo[NextPlayer(Player)] := True;
    ShowPlayerType;
  end;
  Won := 0;
end;

procedure Compute;
begin
  if DemoPlay then Exit;
  if not Playing then Exit;
  Demo[Player] := True;
  Demo[NextPlayer(Player)] := False;
  ShowPlayerType;
  ComputerMakeMove(Player);
end;

procedure TwoPlayer;
begin
  Demo[1] := False;
  Demo[2] := False;
  ShowPlayerType;
end;

procedure StartDemoPlay;
begin
  if not Playing then Exit;
  Demo[1] := True;
  Demo[2] := True;
  ShowPlayerType;
  ComputerMakeMove(Player);
end;

procedure SaveGame;
var f: File;
begin
  Assign(f, 'SCORE4.SAV');
  {$I-}
  Rewrite(f, 1);
  {$I+}
  if IOResult <> 0 then
  begin
    Warn;
    Exit;
  end;
  BlockWrite(f, Table, SizeOf(Table));
  BlockWrite(f, Lines, SizeOf(Lines));
  BlockWrite(f, MoveNo, SizeOf(MoveNo));
  BlockWrite(f, Player, SizeOf(Player));
  BlockWrite(f, Demo, SizeOf(Demo));
  BlockWrite(f, LastMove, SizeOf(LastMove));
  Close(f);
end;

procedure LoadGame;
var f: File;
begin
  Assign(f, 'SCORE4.SAV');
  {$I-}
  Reset(f, 1);
  {$I+}
  if IOResult <> 0 then
  begin
    Warn;
    Exit;
  end;
  BlockRead(f, Table, SizeOf(Table));
  BlockRead(f, Lines, SizeOf(Lines));
  BlockRead(f, MoveNo, SizeOf(MoveNo));
  BlockRead(f, Player, SizeOf(Player));
  BlockRead(f, Demo, SizeOf(Demo));
  BlockRead(f, LastMove, SizeOf(LastMove));
  Close(f);
  ShowPlayerType;
  RefreshTableAbs;
  Won := 0;
  CheckWinner;
  if Won = 0 then ShowTurn;
end;

procedure HandleMouse;
var
  x, y: Integer;
  b: Byte;
begin
  b := M_ButtonPressed;
  if b = 0 then Exit;
  x := M_XPos;
  y := M_YPos;
  if InRect(DiffRect, x, y) then ChangeLevel(Boolean(b - 1)) else
  if InRect(PlayerRect, x, y) then
  begin
    Toggle(Demo[y div 10 + 1]);
    ShowPlayerType;
  end else
  if InRect(TurnRect, x, y) then if Playing then
  begin ChangeTurn; LastMove := '' end else NewGame else
  if b = 1 then if Playing and (not Demo[Player]) then PlayerMakeMove(Player, M_Column)
  else else ShowHint;
  Delay(150);
end;

procedure Intro;
var ch : Char;
begin
  HideCursor;
  M_Reset;
  if not NoFade then FadeOut;
  Clrscr;
  TextAttr := LightMagenta;
  Frame(1, 1, 80, 24, 2);
  TextAttr := Green;
  Center(3, PrgStr[Greek]);
  TextAttr := Yellow;
  Center(4, NameStr[Greek]);
  TextAttr := LightBlue;
  Center(12, '    Score 4    ');
  TextAttr := Blue;
  Center(17, VerStr[Greek] + ' 3.1');
  TextAttr := Green;
  Center(22, 'Copyright 1997,98');
  TextAttr := 7;
  if not NoFade then FadeIn;
  ch := #255;
  repeat
    if Keypressed then ch := ReadKey;
  until (ch in [#13, #32, #27]) or (M_ButtonPressed <> 0);
  if ch = #27 then begin ClrScr; ShowCursor; Halt; end;
  if not NoFade then FadeOut;
end;

function IsVGA : Boolean; assembler;
asm
	mov	ax,$1A00
	int	$10
	cmp	al,$1A
	je	@ok
	mov	ax,FALSE
	jmp	@done
@ok:
	mov	ax,TRUE
@done:
end;

procedure GetParams;
var
  i: Byte;
  ps: String;
begin
  NoFade := False;
  FPCSpk := False;
  Greek := 1;
  for i := 1 to ParamCount do
  begin
    ps := UpStr(ParamStr(i));
    if ps = '/ENGLISH' then Greek := 0;
    if ps = '/PCSPEAKER' then FPCSpk := True;
    if ps = '/NOFADE' then NoFade := True;
  end;
  if FPCSpk then
  begin
    if Greek = 0 then Writeln('Forced use of the PC Speaker.')
    else Writeln('夜 㩞  PC Speaker.');
    Delay(1500);
  end;
end;

var ch, cf: Char;
begin
  GetParams;
  if not IsVGA then
  begin
    if Greek = 0 then Writeln('This program requires a VGA display.')
    else Writeln('  暨  ᨫ  VGA.');
    Halt(2);
  end;
  InitXSound(Greek);
  Delay(600);
  InitSound;
  GrabPal;
  Intro;
  Randomize;
  if GMusic = SoundCard then LoadSong('SCORE4.MT'+Chr(49+Random(4)));
  if (GMusic = SoundCard) and MusicOn then PlaySong;
  InitGraphics;
  Player := 1;
{  incd := 0;}
  DLevel := 3;
  Depth := DLevelMap[Dlevel];  { Depth of forward move analysis ! }
  Analysis := False;
  FillChar(Demo, SizeOf(Demo), True);
  NewGame;
  repeat       { Main Loop }
  { Computer Play }
    if Playing and (Demo[Player]) then ComputerMakeMove(Player);
    CheckDraw;
    HandleMouse;
    ch := #255;
    if KeyPressed then ch := ReadKey;
    ch := UpCase(ch);
    case ch of
      'C': Compute;
      'D': StartDemoPlay;
      '1'..'7': if Playing and (not Demo[Player]) then PlayerMakeMove(Player, Byte(ch) - 48);
      '`': if won = 0 then begin ChangeTurn; LastMove := '' end;
      #27: WantToExit := True;
      '$': NewGame;
      '@': TwoPlayer;
      'H': ShowHint;
      'T': TakeBackMove;
      'L': ChangeLevel(True);
      'S': begin Toggle(SoundOn); Beep; end;
      'A': begin Toggle(Analysis); Beep; end;
      'M': begin
             Toggle(MusicOn); Beep;
             if GMusic = SoundCard then if MusicOn then PlaySong else
               StopSong;
           end;
      #12: ChangeLevel(False);
      #00: begin
             cf := Readkey;
             case cf of
             '<': SaveGame;
             '=': LoadGame;
             end;
           end;
    end;
  until WantToExit;
  if (GMusic = SoundCard) and MusicOn then FadeSong;
  M_Hide;
  CloseGraph;
{  if not NoFade then BlackOut;
  if not NoFade then FadeIn;}
  if (GMusic = SoundCard) and MusicOn then StopSong;
  if GMusic = SoundCard then ClearMem;
end.