'-- 
' *** Red Baron ***                         3D Flight Simulator
'
' Programmed by SkurK/b.                    Requires mouse driver.
' E-mail: skurk@multinet.no
'-- 

DECLARE SUB Grid ()
DECLARE SUB GameOverSub ()
DECLARE SUB StarField ()
DECLARE SUB InitStars ()
DECLARE SUB InitMouse ()
DECLARE SUB InitVector ()
DECLARE SUB Vector ()


DECLARE SUB MouseDriver (AX%, bx%, CX%, DX%)
DECLARE SUB mousestatus (Lb%, Rb%, XMouse%, YMouse%)

COMMON SHARED Lb%, Rb%, XMouse%, YMouse%, NumPoints, NumConn, Distance, Ground, Grid1, Grid2
NumPoints = 17: NumConn = 15: Ground = 100

DIM SHARED mouse$
DIM SHARED Xp!(32), Yp!(32)
DIM SHARED Points(NumPoints, 3), Rotated(NumPoints, 2), Connect(NumConn, 2)
       
        InitStars
        InitMouse
        InitVector

        DO WHILE INKEY$ = ""
                PCOPY 3, 2: SCREEN , , 2, 0                     ' double buffer
       
                WAIT &H3DA, 8                                   ' sync
                WAIT &H3DA, 8, 8
       
                StarField
                Grid
                Vector
              
                PCOPY 2, 0: SCREEN , , 2, 0                     ' double buffer
        LOOP
        
        SCREEN 0: WIDTH 80: END

        REM mouse data inline
        DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
        DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
        DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
        DATA 8B,5E,06,89,17,5D,CA,08,00

        REM  points table
        REM  x , y , z

        DATA 0,-50,0
        DATA 5,-40,0
        DATA 5,40,0
        DATA -5,40,0
        DATA -5,-40,0
       
        DATA 0,-25,5
        DATA 0,40,5

        DATA 5,-20,0
        DATA 50,25,0
        DATA 5,20,0
        DATA -5,-20,0
        DATA -50,25,0
        DATA -5,20,0

        DATA 20,5,-2
        DATA 20,-20,-2
        DATA -20,5,-2
        DATA -20,-20,-2


'---
        REM  connect table
        REM  from,to, from,to, ..
        DATA 1,2, 2,3, 3,4, 4,5, 5,1
        DATA 1,6, 6,7, 7,3, 7,4
        DATA 8,9, 9,10, 11,12, 12,13
        DATA 14,15, 16,17
        DATA 18,19, 20,21

SUB GameOverSub
        END
END SUB

SUB Grid
DEFINT D, X-Y
        LINE (0, Ground)-(319, 199), 2, BF
       
        GridPtr = GridPtr + 1

        VX = 320 - XMouse%

        Grid1 = Grid1 + ((282 - XMouse%) / 50)
            
        U = 4.65 + (Grid1 AND 15) / 100
        FOR X = 0 TO 19
        U = U + .15
        LINE (160, Ground)-(INT(SIN(U) * 850) + 150, INT(COS(U) * 190) + Ground), 8
        NEXT X

        'the horizontal grid is a fake.
        'i didn't bother to code it correctly.
        
        Grid2 = (Grid2 + 1) AND 7
        A = Ground
        D = (Grid2 AND 7)
       
        FOR Y = 1 TO 20
        LINE (0, A)-(319, A), 8
        A = A + D
        D = D + 1.4 + ((D / 40) * Grid2)
        NEXT Y

END SUB

DEFSNG D, X-Y
SUB InitMouse
        mouse$ = SPACE$(57)
        FOR I% = 1 TO 57
                READ A$
                H$ = CHR$(VAL("&H" + A$))
                MID$(mouse$, I%, 1) = H$
        NEXT I%
END SUB

SUB InitStars
        FOR N! = 1 TO 32
            Xp!(N!) = INT(RND(1) * 320)
            Yp!(N!) = INT(RND(1) * 199)
        NEXT N!
END SUB

SUB InitVector
        FOR N = 1 TO NumPoints
                READ X, Y, Z
                Points(N, 1) = X
                Points(N, 2) = Y
                Points(N, 3) = Z
        NEXT N

        FOR N = 1 TO NumConn
                READ A, B
                Connect(N, 1) = A
                Connect(N, 2) = B
        NEXT N

        Distance = 99

        SCREEN 7
        COLOR 15, 1
        LINE (0, 190)-(319, 199), 1, BF
END SUB

SUB LoadGFX
     
        FOR N = 1 TO 796
        READ A
   
        IF A = 15 THEN
                READ Col
                READ Num
                FOR T = 1 TO Num
                        X = X + 1: IF X > 32 THEN X = 1: Y = Y + 1
                        PSET (X, Y), Col
                NEXT T
        ELSE
                X = X + 1: IF X > 32 THEN X = 1: Y = Y + 1
                PSET (X, Y), A
        END IF
        NEXT N

END SUB

SUB MouseDriver (AX%, bx%, CX%, DX%)
  DEF SEG = VARSEG(mouse$)
  mouse% = SADD(mouse$)
  CALL Absolute(AX%, bx%, CX%, DX%, mouse%)
END SUB

SUB mousestatus (Lb%, Rb%, XMouse%, YMouse%)
  AX% = 3
  MouseDriver AX%, bx%, CX%, DX%
  Lb% = ((bx% AND 1) <> 0)
  Rb% = ((bx% AND 2) <> 0)
  XMouse% = CX%
  YMouse% = DX%
END SUB

SUB StarField
        FOR N = 1 TO 32
            'PSET (Xp!(N), Yp!(N)), 0
            IF Xp!(N) < 1 OR Xp!(N) > 319 OR Yp!(N) < 1 OR Yp!(N) > (Ground - 15) THEN 'outside bounds?
               Xp(N) = INT(RND(1) * 320)
               Yp(N) = INT(RND(1) * (Ground - 15))
            END IF
            Xp(N) = Xp(N) - (160 - Xp(N)) / 25 + ((320 - XMouse%) / 20)
            Yp(N) = Yp(N) - (100 - Yp(N)) / 25 + ((80 - YMouse%) / 10)
            PSET (Xp!(N), Yp!(N)), 7
        NEXT N
END SUB

SUB Vector
        mousestatus Lb%, Rb%, XMouse%, YMouse%

        Ground = Ground + ((70 - YMouse%) / 50)
        IF Ground > 190 THEN Ground = 190
        IF Ground < 1 THEN GameOverSub

        vy = ((XMouse% + 100) / 800) + 2.67
        VX = (YMouse% / 400) + 4.5
        VZ = (320 - XMouse% / 800) + .8

        LOCATE 1, 1: PRINT "Alt";
        PRINT USING "###.#"; Ground / 10;
        PRINT " ft ";
        IF (Ground / 10) < 5 THEN PRINT "LOW" ELSE PRINT "   ";
        

        FOR N = 1 TO NumPoints
                X = Points(N, 1)
                Y = Points(N, 2)
                Z = Points(N, 3)
                GOSUB Calc
                Rotated(N, 1) = Nx
                Rotated(N, 2) = Ny
        NEXT N

        FOR N = 1 TO NumConn
            LINE (Rotated(Connect(N, 1), 1), Rotated(Connect(N, 1), 2))-(Rotated(Connect(N, 2), 1), Rotated(Connect(N, 2), 2)), 15
        NEXT N
   


        EXIT SUB

Calc:   Ty = ((Y * COS(VX)) - (Z * SIN(VX)))
        Tz = ((Y * SIN(VX)) + (Z * COS(VX)))
        Tx = ((X * COS(vy)) - (Tz * SIN(vy)))
        Tz = ((X * SIN(vy)) + (Tz * COS(vy)))
        Ox = Tx
        Tx = ((Tx * COS(VZ)) - (Ty * SIN(VZ)))         ' no need for z rotation
        Ty = ((Ox * SIN(VZ)) + (Ty * COS(VZ)))         ' --"--
        Nx = INT(128 * (Tx) / (Distance - (Tz))) + 160
        Ny = INT(100 - (128 * Ty) / (Distance - (Tz)))
        RETURN
END SUB

