' Oozes
' by Rgis Locas
'
' You're just a wizard hanging around in some creepy dungeons filled with
' mean slimes. The object of the game is to get to the door to go to the next
' level. To do so, fire the 'switch' (a cyan block with red circles) to give
' you access to the key. When you have the key, bump into the door.
'
' Controls: Left arrow - moves you left
'           Right arrow - moves you right
'           Up arrow - makes you fly
'           Space bar - fires an energy bolt               
'
' The slimes take one hit. Each time you fire, you lose a great deal of spell
' points. When you fly, you lose a little. You can regain them by not using
' magic for a while. Use CTRL-BREAK to quit.
'
' If the game runs too fast, mess with the speed variable down there. I use
' 15000 on my 486DX50.
' For the graphics, I like low-rez better.
'
' Enjoy!
'
ON ERROR GOTO oops
DEFINT A-Z
RANDOMIZE TIMER
CLS
LOCATE 11, 29: PRINT "1 - High resolution"
LOCATE 12, 29: PRINT "2 - Medium resolution"
LOCATE 13, 29: PRINT "3 - Low resolution"
DO
  a$ = INKEY$
LOOP UNTIL a$ = "1" OR a$ = "2" OR a$ = "3"
IF a$ = "1" THEN
  SCREEN 9
  WINDOW SCREEN (0, 0)-(319, 199)
END IF
IF a$ = "2" THEN
  SCREEN 8
  WINDOW SCREEN (0, 0)-(319, 199)
END IF
IF a$ = "3" THEN
  SCREEN 7
END IF
CLS
FOR I% = 1 TO 15
  PALETTE I%, 0
NEXT I%
DIM map%(19, 38)
DIM wizard1R%(170)
DIM wizard2R%(170)
DIM wizard1L%(170)
DIM wizard2L%(170)
DIM slimeR%(170)
DIM slimeL%(170)
DIM brick%(170)
DIM door%(170)
DIM kee%(170)
DIM switch%(170)
DIM slimeX(10): DIM slimeY(10): DIM slimeDir(10): DIM dripX(5): DIM dripY(5)
LINE (0, 0)-(7, 7), 0, BF
PSET (2, 0), 7: PSET (3, 0), 15
PSET (1, 1), 7: PSET (2, 1), 15: PSET (3, 1), 15: PSET (6, 1), 6
PSET (1, 2), 15: PSET (2, 2), 7: PSET (3, 2), 7: PSET (6, 2), 6
PSET (1, 3), 7: PSET (2, 3), 15: PSET (3, 3), 15: PSET (6, 3), 6
PSET (1, 4), 15: PSET (2, 4), 15: PSET (3, 4), 15: PSET (4, 4), 15: PSET (5, 4), 14
PSET (1, 5), 15: PSET (2, 5), 15: PSET (3, 5), 15: PSET (5, 5), 6
PSET (1, 6), 15: PSET (2, 6), 15: PSET (3, 6), 15: PSET (5, 6), 6
PSET (1, 7), 15: PSET (2, 7), 15: PSET (3, 7), 7: PSET (5, 7), 6
IF a$ = "1" OR a$ = "2" THEN GOSUB pixelSmooth
GET (0, 0)-(7, 7), wizard1R%
LINE (0, 0)-(7, 7), 0, BF
PSET (2, 0), 7: PSET (3, 0), 15
PSET (1, 1), 7: PSET (2, 1), 15: PSET (3, 1), 15: PSET (6, 1), 6
PSET (1, 2), 15: PSET (2, 2), 7: PSET (3, 2), 7: PSET (6, 2), 6
PSET (1, 3), 7: PSET (2, 3), 15: PSET (3, 3), 15: PSET (6, 3), 6
PSET (1, 4), 15: PSET (2, 4), 15: PSET (3, 4), 15: PSET (4, 4), 15: PSET (5, 4), 14
PSET (1, 5), 15: PSET (2, 5), 15: PSET (3, 5), 15: PSET (5, 5), 6
PSET (1, 6), 15: PSET (2, 6), 15: PSET (3, 6), 15: PSET (5, 6), 6
PSET (1, 7), 15: PSET (2, 7), 15: PSET (3, 7), 7: PSET (5, 7), 6
GOSUB FlipH
IF a$ = "1" OR a$ = "2" THEN GOSUB pixelSmooth
GET (0, 0)-(7, 7), wizard1L%
LINE (0, 0)-(7, 7), 0, BF
PSET (2, 0), 7: PSET (3, 0), 15
PSET (1, 1), 7: PSET (2, 1), 15: PSET (3, 1), 15: PSET (5, 1), 6
PSET (1, 2), 15: PSET (2, 2), 7: PSET (3, 2), 7: PSET (5, 2), 6
PSET (1, 3), 7: PSET (2, 3), 15: PSET (3, 3), 15: PSET (5, 3), 6
PSET (1, 4), 15: PSET (2, 4), 15: PSET (3, 4), 15: PSET (4, 4), 15: PSET (5, 4), 14
PSET (0, 5), 7: PSET (1, 5), 15: PSET (2, 5), 15: PSET (3, 5), 15: PSET (6, 5), 6
PSET (0, 6), 15: PSET (1, 6), 15: PSET (2, 6), 15: PSET (3, 6), 15: PSET (6, 6), 6
PSET (0, 7), 15: PSET (1, 7), 15: PSET (2, 7), 15: PSET (3, 7), 7: PSET (6, 7), 6
IF a$ = "1" OR a$ = "2" THEN GOSUB pixelSmooth
GET (0, 0)-(7, 7), wizard2R%
LINE (0, 0)-(7, 7), 0, BF
PSET (2, 0), 7: PSET (3, 0), 15
PSET (1, 1), 7: PSET (2, 1), 15: PSET (3, 1), 15: PSET (5, 1), 6
PSET (1, 2), 15: PSET (2, 2), 7: PSET (3, 2), 7: PSET (5, 2), 6
PSET (1, 3), 7: PSET (2, 3), 15: PSET (3, 3), 15: PSET (5, 3), 6
PSET (1, 4), 15: PSET (2, 4), 15: PSET (3, 4), 15: PSET (4, 4), 15: PSET (5, 4), 14
PSET (0, 5), 7: PSET (1, 5), 15: PSET (2, 5), 15: PSET (3, 5), 15: PSET (6, 5), 6
PSET (0, 6), 15: PSET (1, 6), 15: PSET (2, 6), 15: PSET (3, 6), 15: PSET (6, 6), 6
PSET (0, 7), 15: PSET (1, 7), 15: PSET (2, 7), 15: PSET (3, 7), 7: PSET (6, 7), 6
GOSUB FlipH
IF a$ = "1" OR a$ = "2" THEN GOSUB pixelSmooth
GET (0, 0)-(7, 7), wizard2L%
LINE (0, 0)-(7, 7), 0, BF
LINE (0, 0)-(6, 2), 9, BF
LINE (0, 4)-(3, 6), 9, BF
LINE (5, 4)-(7, 6), 9, BF
IF a$ = "1" OR a$ = "2" THEN GOSUB pixelSmooth
GET (0, 0)-(7, 7), brick%
LINE (0, 0)-(7, 7), 0, BF
LINE (1, 0)-(6, 0), 6
LINE (0, 1)-(7, 7), 6, BF
PSET (1, 4), 7: PSET (2, 4), 8: PSET (1, 5), 8: PSET (2, 5), 0
IF a$ = "1" OR a$ = "2" THEN GOSUB pixelSmooth
GET (0, 0)-(7, 7), door%
LINE (0, 0)-(7, 7), 0, BF
CIRCLE (3, 1), 1, 12
LINE (3, 2)-(3, 7), 12
PSET (2, 7), 12: PSET (2, 5), 12
IF a$ = "1" OR a$ = "2" THEN GOSUB pixelSmooth
GET (0, 0)-(7, 7), kee%
LINE (0, 0)-(7, 7), 11, BF
CIRCLE (3, 3), 2, 12
CIRCLE (3, 3), 1, 12
CIRCLE (4, 4), 2, 12
CIRCLE (4, 4), 1, 12
IF a$ = "1" OR a$ = "2" THEN GOSUB pixelSmooth
GET (0, 0)-(7, 7), switch%
LINE (0, 0)-(7, 7), 0, BF
PSET (0, 6), 10: PSET (0, 7), 10
PSET (1, 5), 10: PSET (1, 6), 10: PSET (1, 7), 10
PSET (2, 4), 10: PSET (2, 5), 10: PSET (2, 6), 10: PSET (2, 7), 10
PSET (3, 4), 10: PSET (3, 5), 10: PSET (3, 6), 10: PSET (3, 7), 10
PSET (4, 4), 10: PSET (4, 5), 10: PSET (4, 6), 10: PSET (4, 7), 10
PSET (5, 5), 10: PSET (5, 6), 10: PSET (5, 7), 10
PSET (6, 6), 10: PSET (6, 7), 10
PSET (7, 7), 10
IF a$ = "1" OR a$ = "2" THEN GOSUB pixelSmooth
GET (0, 0)-(7, 7), slimeL%
LINE (0, 0)-(7, 7), 0, BF
PSET (0, 6), 10: PSET (0, 7), 10
PSET (1, 5), 10: PSET (1, 6), 10: PSET (1, 7), 10
PSET (2, 4), 10: PSET (2, 5), 10: PSET (2, 6), 10: PSET (2, 7), 10
PSET (3, 4), 10: PSET (3, 5), 10: PSET (3, 6), 10: PSET (3, 7), 10
PSET (4, 4), 10: PSET (4, 5), 10: PSET (4, 6), 10: PSET (4, 7), 10
PSET (5, 5), 10: PSET (5, 6), 10: PSET (5, 7), 10
PSET (6, 6), 10: PSET (6, 7), 10
PSET (7, 7), 10
GOSUB FlipH
IF a$ = "1" OR a$ = "2" THEN GOSUB pixelSmooth
GET (0, 0)-(7, 7), slimeR%
LINE (0, 0)-(7, 7), 0, BF
PALETTE
VIEW PRINT 1 TO 25
level = -1
res$ = a$
nextLevel:
LINE (0, 176)-(320, 200), 9, BF
LINE (0, 176)-(319, 199), 11, B
LINE (7, 183)-(312, 192), 1, B
LINE (8, 184)-(311, 191), 0, BF
IF res$ = "3" THEN
  LOCATE 24, 2
  PRINT "LIFE:        SPELL:        KEY:       "
END IF
IF res$ = "2" THEN
  LOCATE 24, 3
  PRINT "LIFE:                      SPELL:                      KEY:                 "
END IF
IF res$ = "1" THEN
  LOCATE 24, 3
  PRINT "LIFE:                      SPELL:                      KEY:                 "
END IF
level = level + 1
GOSUB loadLevel
speed = 10000
kee = 0
oldMP = 0
move = 1
pDir = 1
MP = 40
HP = 50
LINE (50, 184)-(100, 191), 12, BF
LINE (50, 184)-(50 + HP, 191), 10, BF
playGame:
a$ = INKEY$
IF a$ <> "" THEN
  IF a$ = "+" THEN
    IF speed < 2000 THEN speed = speed + 200 ELSE BEEP
  END IF
  IF a$ = "-" THEN
    IF speed > 0 THEN speed = speed - 200 ELSE BEEP
  END IF
  IF a$ = CHR$(0) + CHR$(77) THEN
    GOSUB eraseWizard
    IF POINT(pY + 8, pX) = 0 AND POINT(pY + 8, pX + 1) = 0 AND POINT(pY + 8, pX + 2) = 0 AND POINT(pY + 8, pX + 3) = 0 AND POINT(pY + 8, pX + 4) = 0 AND POINT(pY + 8, pX + 5) = 0 AND POINT(pY + 8, pX + 6) = 0 AND POINT(pY + 8, pX + 7) = 0 THEN
      pY = pY + 1
    ELSEIF POINT(pY + 8, pX) = 12 OR POINT(pY + 8, pX + 1) = 12 OR POINT(pY + 8, pX + 2) = 12 OR POINT(pY + 8, pX + 3) = 12 OR POINT(pY + 8, pX + 4) = 12 OR POINT(pY + 8, pX + 5) = 12 OR POINT(pY + 8, pX + 6) = 12 OR POINT(pY + 8, pX + 7) = 12 THEN
      SOUND 10000, .5
      SOUND 15000, .5
      SOUND 20000, .5
      kee = 1
      LINE (ky * 8, kx * 8)-(ky * 8 + 7, kx * 8 + 7), 0, BF
      PUT (255, 184), kee%
    END IF
    pDir = 1
    IF POINT(pY + 8, pX) = 6 OR POINT(pY + 8, pX + 1) = 6 OR POINT(pY + 8, pX + 2) = 6 OR POINT(pY + 8, pX + 3) = 6 OR POINT(pY + 8, pX + 4) = 6 OR POINT(pY + 8, pX + 5) = 6 OR POINT(pY + 8, pX + 6) = 6 OR POINT(pY + 8, pX + 7) = 6 THEN
      IF kee = 1 THEN
        PLAY "MB O1 c20 d20 e8 d20 e20 f4"
        LINE (0, 0)-(320, 175), 0, BF
        GOTO nextLevel
      END IF
    END IF
    GOSUB drawWizard
  END IF
  IF a$ = CHR$(0) + CHR$(75) THEN
    GOSUB eraseWizard
    IF POINT(pY - 1, pX) = 0 AND POINT(pY - 1, pX + 1) = 0 AND POINT(pY - 1, pX + 2) = 0 AND POINT(pY - 1, pX + 3) = 0 AND POINT(pY - 1, pX + 4) = 0 AND POINT(pY - 1, pX + 5) = 0 AND POINT(pY - 1, pX + 6) = 0 AND POINT(pY - 1, pX + 7) = 0 THEN
      pY = pY - 1
    ELSEIF POINT(pY - 1, pX) = 12 OR POINT(pY - 1, pX + 1) = 12 OR POINT(pY - 1, pX + 2) = 12 OR POINT(pY - 1, pX + 3) = 12 OR POINT(pY - 1, pX + 4) = 12 OR POINT(pY - 1, pX + 5) = 12 OR POINT(pY - 1, pX + 6) = 12 OR POINT(pY - 1, pX + 7) = 12 THEN
      SOUND 10000, .5
      SOUND 15000, .5
      SOUND 20000, .5
      kee = 1
      LINE (ky * 8, kx * 8)-(ky * 8 + 7, kx * 8 + 7), 0, BF
      PUT (255, 184), kee%
    END IF
    pDir = 2
    IF POINT(pY - 1, pX) = 6 OR POINT(pY - 1, pX + 1) = 6 OR POINT(pY - 1, pX + 2) = 6 OR POINT(pY - 1, pX + 3) = 6 OR POINT(pY - 1, pX + 4) = 6 OR POINT(pY - 1, pX + 5) = 6 OR POINT(pY - 1, pX + 6) = 6 OR POINT(pY - 1, pX + 7) = 6 THEN
      IF kee = 1 THEN
        PLAY "MB O1 c20 d20 e8 d20 e20 f4"
        LINE (0, 0)-(320, 175), 0, BF
        GOTO nextLevel
      END IF
    END IF
    GOSUB drawWizard
  END IF
  IF a$ = CHR$(0) + CHR$(72) THEN
    GOSUB eraseWizard
    IF MP > 0 THEN MP = MP - 1
    LINE (170, 184)-(210, 191), 12, BF
    LINE (170, 184)-(170 + MP, 191), 11, BF
    IF POINT(pY, pX - 1) = 0 AND POINT(pY + 1, pX - 1) = 0 AND POINT(pY + 2, pX - 1) = 0 AND POINT(pY + 3, pX - 1) = 0 AND POINT(pY + 4, pX - 1) = 0 AND POINT(pY + 5, pX - 1) = 0 AND POINT(pY + 6, pX - 1) = 0 AND POINT(pY + 7, pX - 1) = 0 THEN
      pX = pX - 1
      fly = 6
    END IF
    GOSUB drawWizard
    SOUND 47, .1
  END IF
  IF a$ = " " AND MP > 14 THEN
    GOSUB eraseWizard
    GOSUB drawWizard
    MP = MP - 15
    LINE (170, 184)-(210, 191), 12, BF
    LINE (170, 184)-(170 + MP, 191), 11, BF
    SOUND 1000, .5
    SOUND 700, .5
    SOUND 500, .5
    IF shotDir <> 0 THEN PSET (shotY, shotX), 0
    shotDir = pDir
    shotX = pX + 4
    IF shotDir = 1 THEN
      shotY = pY + 7
    ELSEIF shotDir = 2 THEN
      shotY = pY
    END IF
  END IF
END IF
IF POINT(pY, pX + 8) = 0 AND POINT(pY + 1, pX + 8) = 0 AND POINT(pY + 2, pX + 8) = 0 AND POINT(pY + 3, pX + 8) = 0 AND POINT(pY + 4, pX + 8) = 0 AND POINT(pY + 5, pX + 8) = 0 AND POINT(pY + 6, pX + 8) = 0 AND POINT(pY + 7, pX + 8) = 0 THEN
  IF fly = 0 THEN
    GOSUB eraseWizard
    pX = pX + 1
    GOSUB drawWizard
  END IF
END IF
IF fly > 0 THEN fly = fly - 1
IF POINT(pY, pX + 8) = 10 OR POINT(pY + 1, pX + 8) = 10 OR POINT(pY + 2, pX + 8) = 10 OR POINT(pY + 3, pX + 8) = 10 OR POINT(pY + 4, pX + 8) = 10 OR POINT(pY + 5, pX + 8) = 10 OR POINT(pY + 6, pX + 8) = 10 OR POINT(pY + 7, pX + 8) = 10 THEN
  HP = HP - (INT(RND * 5) + 1)
  SOUND 200, .3
  SOUND 100, .5
  LINE (50, 184)-(100, 191), 12, BF
  LINE (50, 184)-(50 + HP, 191), 10, BF
  IF HP < 1 THEN
    FOR I% = 1 TO 100
      CIRCLE (pY + 3, pX + 3), I%, 12
      CIRCLE (pY + 3, pX + 3), 200 - I%, 12
    NEXT I%
    CLS : RUN
  END IF
END IF
IF shotDir <> 0 THEN
  IF shotDir = 1 THEN
    IF POINT(shotY + 1, shotX) = 11 THEN
      LINE (ty * 8, tx * 8)-(ty * 8 + 7, tx * 8 + 7), 0, BF
    END IF
  ELSEIF shotDir = 2 THEN
    IF POINT(shotY - 1, shotX) = 11 THEN
      LINE (ty * 8, tx * 8)-(ty * 8 + 7, tx * 8 + 7), 0, BF
    END IF
  END IF
  IF shotDir = 1 THEN
    PSET (shotY, shotX), 0
    IF POINT(shotY + 1, shotX) <> 0 THEN
      shotDir = 0
      SOUND 40, 1
    ELSE
      shotY = shotY + 1
      PSET (shotY, shotX), 11
    END IF
  ELSEIF shotDir = 2 THEN
    PSET (shotY, shotX), 0
    IF POINT(shotY - 1, shotX) <> 0 THEN
      shotDir = 0
      SOUND 40, 1
    ELSE
      shotY = shotY - 1
      PSET (shotY, shotX), 11
    END IF
  END IF
  FOR I% = 1 TO 10
    IF slimeDir(I%) <> 0 THEN
      IF shotX > slimeX(I%) + 3 AND shotX < slimeX(I%) + 8 AND shotY >= slimeY(I%) - 1 AND shotY < slimeY(I%) + 9 THEN
        IF slimeDir(I%) = 1 THEN
          PUT (slimeY(I%), slimeX(I%)), slimeR%
        ELSE
          PUT (slimeY(I%), slimeX(I%)), slimeL%
        END IF
        slimeDir(I%) = 0
        SOUND 100, 1
        SOUND 70, 1
        SOUND 50, 1
        FOR d% = 1 TO 5
          dripX(d%) = slimeX(I%) + INT(RND * 3) + 4
          dripY(d%) = slimeY(I%) + INT(RND * 7)
        NEXT d%
      END IF
    END IF
  NEXT I%
END IF
I% = INT(RND * 10) + 1
    x1 = POINT(slimeY(I%) + 8, slimeX(I%) + 4)
    x2 = POINT(slimeY(I%) + 8, slimeX(I%) + 5)
    x3 = POINT(slimeY(I%) + 8, slimeX(I%) + 6)
    x4 = POINT(slimeY(I%) + 8, slimeX(I%) + 7)
IF slimeDir(I%) <> 0 THEN
  IF slimeY(I%) < pY THEN
    IF x1 = 0 AND x2 = 0 AND x3 = 0 AND x4 = 0 THEN
      IF slimeDir(I%) = 1 THEN
        PUT (slimeY(I%), slimeX(I%)), slimeR%
      ELSE
        PUT (slimeY(I%), slimeX(I%)), slimeL%
      END IF
      slimeY(I%) = slimeY(I%) + 1
      slimeDir(I%) = 1
      IF slimeDir(I%) = 1 THEN
        PUT (slimeY(I%), slimeX(I%)), slimeR%
      ELSE
        PUT (slimeY(I%), slimeX(I%)), slimeL%
      END IF
    END IF
  ELSE
    IF POINT(slimeY(I%) - 1, slimeX(I%) + 4) = 0 AND POINT(slimeY(I%) - 1, slimeX(I%) + 5) = 0 AND POINT(slimeY(I%) - 1, slimeX(I%) + 6) = 0 AND POINT(slimeY(I%) - 1, slimeX(I%) + 7) = 0 THEN
      IF slimeDir(I%) = 1 THEN
        PUT (slimeY(I%), slimeX(I%)), slimeR%
      ELSE
        PUT (slimeY(I%), slimeX(I%)), slimeL%
      END IF
      slimeY(I%) = slimeY(I%) - 1
      slimeDir(I%) = 2
      IF slimeDir(I%) = 1 THEN
        PUT (slimeY(I%), slimeX(I%)), slimeR%
      ELSE
        PUT (slimeY(I%), slimeX(I%)), slimeL%
      END IF
    END IF
  END IF
  IF POINT(slimeY(I%), slimeX(I%) + 8) = 0 AND POINT(slimeY(I%) + 1, slimeX(I%) + 8) = 0 AND POINT(slimeY(I%) + 2, slimeX(I%) + 8) = 0 AND POINT(slimeY(I%) + 3, slimeX(I%) + 8) = 0 AND POINT(slimeY(I%) + 4, slimeX(I%) + 8) = 0 AND POINT(slimeY(I%) + _
 5, slimeX(I%) + 8) = 0 AND POINT(slimeY(I%) + 6, slimeX(I%) + 8) = 0 AND POINT(slimeY(I%) + 7, slimeX(I%) + 8) = 0 THEN
    IF slimeDir(I%) = 1 THEN
      PUT (slimeY(I%), slimeX(I%)), slimeR%
    ELSE
      PUT (slimeY(I%), slimeX(I%)), slimeL%
    END IF
    slimeX(I%) = slimeX(I%) + 1
    IF slimeDir(I%) = 1 THEN
      PUT (slimeY(I%), slimeX(I%)), slimeR%
    ELSE
      PUT (slimeY(I%), slimeX(I%)), slimeL%
    END IF
  END IF
  IF POINT(slimeY(I%), slimeX(I%) + 8) = 15 OR POINT(slimeY(I%) + 1, slimeX(I%) + 8) = 15 OR POINT(slimeY(I%) + 2, slimeX(I%) + 8) = 15 OR POINT(slimeY(I%) + 3, slimeX(I%) + 8) = 15 OR POINT(slimeY(I%) + 4, slimeX(I%) + 8) = 15 OR POINT(slimeY(I%) + _
 5, slimeX(I%) + 8) = 15 OR POINT(slimeY(I%) + 6, slimeX(I%) + 8) = 15 OR POINT(slimeY(I%) + 7, slimeX(I%) + 8) = 15 THEN
    HP = HP - (INT(RND * 5) + 1)
    SOUND 200, .3
    SOUND 100, .5
    LINE (50, 184)-(100, 191), 12, BF
    LINE (50, 184)-(50 + HP, 191), 10, BF
    IF HP < 1 THEN
      FOR I% = 1 TO 100
        CIRCLE (pY + 3, pX + 3), I%, 12
        CIRCLE (pY + 3, pX + 3), 200 - I%, 12
      NEXT I%
      CLS : RUN
    END IF
  END IF
  IF POINT(slimeY(I%) - 2, slimeX(I%) + 4) = 15 OR POINT(slimeY(I%) - 2, slimeX(I%) + 5) = 15 OR POINT(slimeY(I%) - 2, slimeX(I%) + 6) = 15 OR POINT(slimeY(I%) - 2, slimeX(I%) + 7) = 15 THEN
    HP = HP - (INT(RND * 10) + 1)
    SOUND 200, .3
    SOUND 100, .5
    LINE (50, 184)-(100, 191), 12, BF
    LINE (50, 184)-(50 + HP, 191), 10, BF
    IF HP < 1 THEN
      FOR I% = 1 TO 100
        CIRCLE (pY + 3, pX + 3), I%, 12
        CIRCLE (pY + 3, pX + 3), 200 - I%, 12
      NEXT I%
      CLS : RUN
    END IF
  END IF
  IF POINT(slimeY(I%) + 9, slimeX(I%) + 4) = 15 OR POINT(slimeY(I%) + 9, slimeX(I%) + 5) = 15 OR POINT(slimeY(I%) + 9, slimeX(I%) + 6) = 15 OR POINT(slimeY(I%) + 9, slimeX(I%) + 7) = 15 THEN
    HP = HP - (INT(RND * 10) + 1)
    SOUND 200, .3
    SOUND 100, .5
    LINE (50, 184)-(100, 191), 12, BF
    LINE (50, 184)-(50 + HP, 191), 10, BF
    IF HP < 1 THEN
      FOR I% = 1 TO 100
        CIRCLE (pY + 3, pX + 3), I%, 12
        CIRCLE (pY + 3, pX + 3), 200 - I%, 12
      NEXT I%
      CLS : RUN
    END IF
  END IF
END IF
FOR I% = 1 TO 5

  IF dripX(I%) <> 0 AND (POINT(dripY(I%), dripX(I%) + 2) = 0 OR POINT(dripY(I%), dripX(I%) + 2) = 9 OR POINT(dripY(I%), dripX(I%) + 2) = 2) THEN
    PRESET (dripY(I%), dripX(I%))
    dripX(I%) = dripX(I%) + 1
    PSET (dripY(I%), dripX(I%)), 10
    IF POINT(dripY(I%), dripX(I%) + 1) = 9 THEN
      SOUND 5000, .5
      PRESET (dripY(I%), dripX(I%))
      PSET (dripY(I%), dripX(I%) + 1), 2
      dripX(I%) = 0
    END IF
  END IF
NEXT I%
IF MP < 40 AND fly = 0 THEN MP = MP + 1
IF MP <> oldMP THEN
  LINE (170, 184)-(210, 191), 12, BF
  LINE (170, 184)-(170 + MP, 191), 11, BF
  oldMP = MP
END IF
FOR I% = 0 TO speed: NEXT I%
GOTO playGame
END

loadLevel:
  FOR I% = 1 TO 19
    FOR ii% = 1 TO 38
      map%(I%, ii%) = 1
    NEXT ii%
  NEXT I%
  pX = INT(RND * 19) + 1
  pY = INT(RND * 38) + 1
  x = pX
  y = pY
  map%(pX, pY) = 0
  FOR I% = 1 TO 2000
    IF INT(RND * 5) = 1 THEN
      x = x + (INT(RND * 3) - 1)
    ELSE
      y = y + (INT(RND * 3) - 1)
    END IF
    IF x < 1 THEN x = 1
    IF x > 19 THEN x = 19
    IF y < 1 THEN y = 1
    IF y > 38 THEN y = 38
    map%(x, y) = 0
  NEXT I%
  pX = pX * 8
  pY = pY * 8
  FOR I% = 1 TO INT(RND * 7) + 4
redoSl:
    slx = INT(RND * 19) + 1
    sly = INT(RND * 38) + 1
    IF map%(slx, sly) = 0 THEN
      slimeX(I%) = slx * 8
      slimeY(I%) = sly * 8
      slimeDir(I%) = 1
      map%(slx, sly) = 2
    ELSE
      GOTO redoSl
    END IF
  NEXT I%
  done = 0
  DO
    dx = INT(RND * 17) + 2
    dy = INT(RND * 36) + 2
    IF map%(dx + 1, dy) = 1 AND (map%(dx, dy + 1) = 0 OR map%(dx, dy - 1) = 0) THEN
      map%(dx, dy) = 4
      done = 1
    END IF
  LOOP UNTIL done = 1
  done = 0
  DO
    swx = INT(RND * 17) + 2
    swy = INT(RND * 36) + 2
    IF map%(swx, swy) = 1 THEN
      IF map%(swx, swy + 1) = 0 OR map%(swx, swy - 1) = 0 THEN
        map%(swx, swy) = 5
        done = 1
      END IF
    END IF
  LOOP UNTIL done = 1
  done = 0
  DO
    kex = INT(RND * 17) + 2
    keey = INT(RND * 34) + 3
    IF map%(kex, keey + 1) = 1 AND map%(kex, keey - 1) = 1 AND map%(kex + 1, keey) = 1 AND map%(kex - 1, keey) = 1 THEN
      IF map%(kex, keey - 2) = 0 THEN
        tx = kex: ty = keey - 1
        map%(kex, keey) = 3
        kx = kex
        ky = keey
        done = 1
      ELSEIF map%(kex, keey + 2) = 0 THEN
        tx = kex: ty = keey + 1
        map%(kex, keey) = 3
        kx = kex
        ky = keey
        done = 1
      END IF
    END IF
  LOOP UNTIL done = 1
  GOSUB redoMap
RETURN

redoMap:
  FOR I% = 0 TO 39
    FOR ii% = 0 TO 21
      IF I% = 0 OR I% = 39 THEN
        PUT (I% * 8, ii% * 8), brick%
      ELSE
        IF ii% = 0 OR ii% = 20 OR ii% = 21 THEN
          PUT (I% * 8, ii% * 8), brick%
        END IF
      END IF
    NEXT ii%
  NEXT I%
  FOR I% = 1 TO 19
    FOR ii% = 1 TO 38
      IF map%(I%, ii%) = 1 THEN PUT (ii% * 8, I% * 8), brick%
      IF map%(I%, ii%) = 2 THEN PUT (ii% * 8, I% * 8), slimeR%
      IF map%(I%, ii%) = 3 THEN PUT (ii% * 8, I% * 8), kee%
      IF map%(I%, ii%) = 4 THEN PUT (ii% * 8, I% * 8), door%
      IF map%(I%, ii%) = 5 THEN PUT (ii% * 8, I% * 8), switch%
    NEXT ii%
  NEXT I%
  PUT (pY, pX), wizard1R%
RETURN

FlipH:
  FOR x = 0 TO 3
    FOR y = 0 TO 7
      a = POINT(x, y)
      B = POINT(7 - x, y)
      PSET (7 - x, y), a
      PSET (x, y), B
    NEXT y
  NEXT x
RETURN

oops:
  PRINT ERR
RESUME NEXT

eraseWizard:
  IF pDir = 1 THEN
    IF move = 1 THEN
      PUT (pY, pX), wizard1R%
      move = 2
    ELSE
      PUT (pY, pX), wizard2R%
      move = 1
    END IF
  ELSE
    IF move = 1 THEN
      PUT (pY, pX), wizard1L%
      move = 2
    ELSE
      PUT (pY, pX), wizard2L%
      move = 1
    END IF
  END IF
RETURN

drawWizard:
  IF pDir = 1 THEN
    IF move = 1 THEN
      PUT (pY, pX), wizard1R%
    ELSE
      PUT (pY, pX), wizard2R%
    END IF
  ELSE
    IF move = 1 THEN
      PUT (pY, pX), wizard1L%
    ELSE
      PUT (pY, pX), wizard2L%
    END IF
  END IF
RETURN

pixelSmooth:
  FOR x% = 0 TO 8
    FOR y% = 0 TO 8
      pc = POINT(x%, y%)
      IF pc <> 0 THEN
        IF POINT(x% - 1, y%) = pc THEN
          LINE (x%, y%)-(x% - 1, y%), pc
        ELSEIF POINT(x% - 1, y%) <> 0 THEN
          pcc = POINT(x% - 1, y%)
          LINE (x%, y%)-(x% - 1, y%), pc
          PSET (x% - 1, y%), pcc
        END IF
        IF POINT(x% + 1, y%) = pc THEN
          LINE (x%, y%)-(x% + 1, y%), pc
        ELSEIF POINT(x% + 1, y%) <> 0 THEN
          pcc = POINT(x% + 1, y%)
          LINE (x%, y%)-(x% + 1, y%), pc
          PSET (x% + 1, y%), pcc
        END IF
        IF POINT(x%, y% - 1) = pc THEN
          LINE (x%, y%)-(x%, y% - 1), pc
        ELSEIF POINT(x%, y% - 1) <> 0 THEN
          pcc = POINT(x%, y% - 1)
          LINE (x%, y%)-(x%, y% - 1), pc
          PSET (x%, y% - 1), pcc
        END IF
        IF POINT(x%, y% + 1) = pc THEN
          LINE (x%, y%)-(x%, y% + 1), pc
        ELSEIF POINT(x, y% + 1) <> 0 THEN
          pcc = POINT(x%, y% + 1)
          LINE (x%, y%)-(x%, y% + 1), pc
          PSET (x%, y% + 1), pcc
        END IF
        IF POINT(x% - 1, y% - 1) = pc THEN
          LINE (x%, y%)-(x% - 1, y% - 1), pc
        ELSEIF POINT(x% - 1, y% - 1) <> 0 THEN
          pcc = POINT(x% - 1, y% - 1)
          LINE (x%, y%)-(x% - 1, y% - 1), pc
          PSET (x% - 1, y% - 1), pcc
        END IF
        IF POINT(x% + 1, y% - 1) = pc THEN
          LINE (x%, y%)-(x% + 1, y% - 1), pc
        ELSEIF POINT(x% + 1, y% - 1) <> 0 THEN
          pcc = POINT(x% + 1, y% - 1)
          LINE (x%, y%)-(x% + 1, y% - 1), pc
          PSET (x% + 1, y% - 1), pcc
        END IF
        IF POINT(x% - 1, y% + 1) = pc THEN
          LINE (x%, y%)-(x% - 1, y% + 1), pc
        ELSEIF POINT(x% - 1, y% + 1) <> 0 THEN
          pcc = POINT(x% - 1, y% + 1)
          LINE (x%, y%)-(x% - 1, y% + 1), pc
          PSET (x% - 1, y% + 1), pcc
        END IF
        IF POINT(x% + 1, y% + 1) = pc THEN
          LINE (x%, y%)-(x% + 1, y% + 1), pc
        ELSEIF POINT(x% + 1, y% + 1) <> 0 THEN
          pcc = POINT(x% + 1, y% + 1)
          LINE (x%, y%)-(x% + 1, y% + 1), pc
          PSET (x% + 1, y% + 1), pcc
        END IF
      END IF
    NEXT y%
  NEXT x%
RETURN




