' One-Check Solitaire   Version 3.0e
'
' The purpose of the game is to have the least amount of checkers left.
' You remove them by jumping one diagonally over another.
'
' Address: Daniel Fletcher
'          XYZZY Productions
'          P.O. Box 208
'          Taberg, NY  13471-0208
'
' E-Mail: danielfletcher@cyberdude.com   {E-Mail me for updates to
'         xyzzyproductions@hotmail.com    automatically be sent to you.}
'
' Web site: http://www.geocities.com/SiliconValley/Vista/3048/
'
' Birthday: 7-15-1981

DECLARE SUB Board.Draw ()
DECLARE SUB Board.Update ()
DECLARE SUB Buttons.Check ()
DECLARE SUB Desktop.Draw ()
DECLARE SUB Desktop.Update ()
DECLARE SUB Load.Graphics ()
DECLARE SUB Load.Locations ()
DECLARE SUB Load.Positions ()
DECLARE SUB Mouse.Driver (AX%, bx%, CX%, DX%)
DECLARE SUB Mouse.Hide ()
DECLARE SUB Mouse.Load ()
DECLARE SUB Mouse.Put (X!, Y!)
DECLARE SUB Mouse.Show ()
DECLARE SUB Mouse.Status (LeftButton%, RightButton%, XMouse%, YMouse%)
DECLARE SUB Piece.CheckMove ()
DECLARE SUB Piece.GetNumber ()
DECLARE SUB Piece.Highlight ()
DECLARE SUB Piece.Remove ()
DECLARE SUB Place.Icon (X!, Y!, FileName$)
DECLARE SUB Program.About ()
DECLARE SUB Program.Help ()
DECLARE SUB Screen.Fade (cl!)
DECLARE SUB Screen.PalLoad (PalFile$)
DECLARE SUB Sound.Delay (Sound.TimeDelayer!)
DECLARE SUB Sound.PlayBack (buffer$, size%, freq&, BytesPerSec&, chans%, num%)
DECLARE SUB Sound.PlayWAV (wavefile$)
DECLARE SUB Sound.ValidHeader (FILE$, LenHeader%, dataLen&, nChannels%, nSamplesPerSec&, nAvgBytesPerSec&, ok%)
DECLARE SUB Sound.WriteToDSP (v%)
DECLARE SUB System.Close ()
DECLARE FUNCTION Buttons.CheckXY! (TX!, TY!, LX!, LY!)
DECLARE FUNCTION Mouse.Initialize% ()
DECLARE FUNCTION Sound.GetSBAddress% ()
DECLARE FUNCTION Sound.SBReset% ()

COMMON SHARED Mouse$, PieceNumberX, PieceNumberY, Valid
COMMON SHARED XMouse%, YMouse%, FromX, FromY, ToX, ToY
COMMON SHARED Sound.SBAddress%, Sound.DMA%, Sound.Repeats%

TYPE PalType
 r AS INTEGER
 g AS INTEGER
 B AS INTEGER
END TYPE

DIM SHARED DimSize AS INTEGER
DIM SHARED pall(256) AS PalType
DIM SHARED pal(768)

DIM SHARED Position(8, 8), LocationX(8, 8), LocationY(8, 8)

DIM SHARED Pieces.GFX(1 TO 400)
DIM SHARED Pieces.HGFX1(1 TO 400)
DIM SHARED Pieces.HGFX2(1 TO 400)
DIM SHARED Tiles.GFX(1 TO 400)
DIM SHARED Tiles.HGFX(1 TO 400)

DIM SHARED Button.Button(10400)

COMMON SHARED AUDIO
COMMON SHARED Button.Pressed AS STRING

Initialize:
Load.Locations
Load.Graphics
Mouse.Load
SCREEN 13
Screen.PalLoad "title_mn"
DEF SEG = &HA000: BLOAD "title_mn.gfx", 0: DEF SEG
DO
    Mouse.Status LeftButton%, RightButton%, XMouse%, YMouse%
LOOP UNTIL LeftButton% = 0
DO
    Mouse.Status LeftButton%, RightButton%, XMouse%, YMouse%
LOOP UNTIL LeftButton% <> 0

Start:
Load.Positions
Desktop.Draw
SCREEN 12
Board.Draw

FromPiece:
Board.Update
DO
    Mouse.Show
    Mouse.Status LeftButton%, RightButton%, XMouse%, YMouse%
LOOP UNTIL LeftButton% <> 0
Buttons.Check
SELECT CASE Button.Pressed
CASE "Quit"
    System.Close
    SYSTEM
CASE "Restart"
    Screen.Fade 15
    Load.Positions
    Desktop.Draw
    Board.Draw
    GOTO FromPiece
CASE "About"
    Program.About
    Board.Draw
    GOTO FromPiece
CASE "Audio"
    IF AUDIO = 0 THEN AUDIO = 1 ELSE AUDIO = 0
    Desktop.Update
    GOTO FromPiece
CASE "Help"
    Program.Help
    GOTO FromPiece
END SELECT
Piece.GetNumber
FromX = PieceNumberX: FromY = PieceNumberY
IF Position(FromX, FromY) = 0 AND AUDIO = 0 THEN
    GOTO FromPiece
ELSEIF Position(FromX, FromY) = 0 AND AUDIO = 1 THEN
    'Sound.PlayWAV "sound_01.wav"
    SOUND 50, 3
    GOTO FromPiece
END IF

ToPiece:
DO
    Mouse.Status LeftButton%, RightButton%, XMouse%, YMouse%
    Piece.GetNumber
    ToX = PieceNumberX: ToY = PieceNumberY
    Piece.Highlight
LOOP UNTIL LeftButton% = 0
Piece.GetNumber
ToX = PieceNumberX: ToY = PieceNumberY
IF Position(ToX, ToY) = 1 THEN GOTO FromPiece
Piece.CheckMove
IF Valid THEN Piece.Remove
GOTO FromPiece

Positions:
DATA 1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1
DATA 1,1,1,0,0,1,1,1
DATA 1,1,1,0,0,1,1,1
DATA 1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1

'Do NOT Change The Rest Of The Data
'Things will get messed up...
MouseData:
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

SUB Board.Draw

Mouse.Hide

'Draw Board Frame
LINE (114, 34)-(526, 446), 0, BF
LINE (116, 36)-(524, 444), 15, BF
LINE (117, 37)-(523, 443), 7, BF
LINE (118, 38)-(522, 442), 8, BF
LINE (524, 36)-(524, 444), 8
LINE (116, 444)-(523, 444), 8

Mouse.Show

END SUB

SUB Board.Update
Mouse.Hide

FOR X = 1 TO 8
    FOR Y = 1 TO 8
        IF Position(X, Y) = 1 THEN
            PUT (LocationX(X, Y), LocationY(X, Y)), Pieces.GFX, PSET
        ELSE
            PUT (LocationX(X, Y), LocationY(X, Y)), Tiles.GFX, PSET
        END IF
    NEXT Y
NEXT X

Mouse.Show
END SUB

SUB Buttons.Check

Button.Pressed = ""

IF Buttons.CheckXY(623, 3, 636, 13) = 1 THEN
    Button.Pressed = "Quit"
ELSEIF Buttons.CheckXY(606, 3, 619, 13) = 1 THEN
    Button.Pressed = "Help"
ELSEIF Buttons.CheckXY(11, 425, 84, 447) = 1 THEN
    Button.Pressed = "Restart"
ELSEIF Buttons.CheckXY(11, 395, 84, 417) = 1 THEN
    Button.Pressed = "Audio"
ELSEIF Buttons.CheckXY(554, 425, 627, 447) = 1 THEN
    Button.Pressed = "About"
END IF

END SUB

FUNCTION Buttons.CheckXY (TX, TY, LX, LY)

IF XMouse% >= TX AND XMouse% <= LX AND YMouse% >= TY AND YMouse% <= LY THEN
    Buttons.CheckXY = 1
END IF

END FUNCTION

SUB Desktop.Draw

Mouse.Hide

SCREEN 12

'Draw Background
LINE (0, 0)-(649, 479), 8, BF
DEF SEG = VARSEG(Button.Button(0))
    BLOAD "backgrnd.gfx", VARPTR(Button.Button(0))
DEF SEG

FOR X = 0 TO 629 STEP 32
    FOR Y = 0 TO 479 STEP 32
        PUT (X, Y), Button.Button, PSET
    NEXT Y
NEXT X

'Draw Title Bar
LINE (0, 0)-(639, 17), 15, B
LINE (1, 1)-(638, 16), 1, BF
Place.Icon 2, 1, "title_01"

'Draw Button's
Place.Icon 607, 3, "title_02"
Place.Icon 11, 425, "rstrt_bt"
Place.Icon 554, 425, "about_bt"

IF AUDIO = 0 THEN
    Place.Icon 11, 395, "sound_00"
ELSE
    Place.Icon 11, 395, "sound_01"
END IF

Mouse.Show
END SUB

SUB Desktop.Update
Mouse.Hide

IF AUDIO = 0 THEN
    Place.Icon 11, 395, "sound_00"
ELSE
    Place.Icon 11, 395, "sound_01"
END IF

Mouse.Show
END SUB

SUB Load.Graphics

'DEF SEG = &HA000: BSAVE FileName$, 0, 64000: DEF SEG
'DEF SEG = &HA000: BLOAD FileName$, 0: DEF SEG

SCREEN 12

'Load Checker Piece
LINE (0, 0)-(49, 49), 0, BF
LINE (2, 2)-(48, 48), 8, BF
LINE (4, 4)-(46, 46), 7, BF
LINE (6, 6)-(44, 44), 15, BF
CIRCLE (25, 25), 15, 0
PAINT (25, 25), 4, 0
CIRCLE (25, 25), 10, 0
PAINT (25, 25), 12, 0
GET (0, 0)-(49, 49), Pieces.GFX

'Load Highlighted Checker Piece1
LINE (0, 0)-(49, 49), 0, BF
LINE (2, 2)-(48, 48), 7, BF
LINE (4, 4)-(46, 46), 8, BF
LINE (6, 6)-(44, 44), 15, BF
CIRCLE (25, 25), 15, 0
PAINT (25, 25), 4, 0
CIRCLE (25, 25), 10, 0
PAINT (25, 25), 12, 0
GET (0, 0)-(49, 49), Pieces.HGFX1

'Load Highlighted Checker Piece2
LINE (0, 0)-(49, 49), 0, BF
LINE (2, 2)-(48, 48), 7, BF
LINE (4, 4)-(46, 46), 8, BF
LINE (6, 6)-(44, 44), 15, BF
CIRCLE (25, 25), 15, 0
PAINT (25, 25), 12, 0
CIRCLE (25, 25), 10, 0
PAINT (25, 25), 4, 0
GET (0, 0)-(49, 49), Pieces.HGFX2

'Load Tile
LINE (0, 0)-(49, 49), 0, BF
LINE (2, 2)-(48, 48), 8, BF
LINE (4, 4)-(46, 46), 7, BF
LINE (6, 6)-(44, 44), 15, BF
GET (0, 0)-(49, 49), Tiles.GFX

'Load Highlighted Tile
LINE (0, 0)-(49, 49), 0, BF
LINE (2, 2)-(48, 48), 7, BF
LINE (4, 4)-(46, 46), 8, BF
LINE (6, 6)-(44, 44), 15, BF
GET (0, 0)-(49, 49), Tiles.HGFX


END SUB

SUB Load.Locations

FOR Y = 1 TO 8
    Temp = 120
    FOR X = 1 TO 8
        LocationX(X, Y) = Temp
        Temp = Temp + 50
    NEXT X
NEXT Y

FOR X = 1 TO 8
    Temp = 40
    FOR Y = 1 TO 8
        LocationY(X, Y) = Temp
        Temp = Temp + 50
    NEXT Y
NEXT X

END SUB

SUB Load.Positions

RESTORE Positions

FOR Y = 1 TO 8
    FOR X = 1 TO 8
        READ Position(X, Y)
    NEXT X
NEXT Y

END SUB

SUB Mouse.Driver (AX%, bx%, CX%, DX%)
    DEF SEG = VARSEG(Mouse$)
    Mouse% = SADD(Mouse$)
    CALL Absolute(AX%, bx%, CX%, DX%, Mouse%)
END SUB

SUB Mouse.Hide
    AX% = 2
    Mouse.Driver AX%, 0, 0, 0
END SUB

FUNCTION Mouse.Initialize%
    AX% = 0
    Mouse.Driver AX%, 0, 0, 0
    Mouse.Initialize% = AX%
END FUNCTION

SUB Mouse.Load

RESTORE MouseData
Mouse$ = SPACE$(57)
FOR i% = 1 TO 57
    READ a$
    H$ = CHR$(VAL("&H" + a$))
    MID$(Mouse$, i%, 1) = H$
NEXT i%

Mouse.Put 0, 0
Mouse.Show

END SUB

SUB Mouse.Put (X, Y)
    AX% = 4
    CX% = X
    DX% = Y
    Mouse.Driver AX%, 0, CX%, DX%
END SUB

SUB Mouse.Show
  AX% = 1
  Mouse.Driver AX%, 0, 0, 0
END SUB

SUB Mouse.Status (LeftButton%, RightButton%, XMouse%, YMouse%)
    AX% = 3
    Mouse.Driver AX%, bx%, CX%, DX%
    LeftButton% = ((bx% AND 1) <> 0)
    RightButton% = ((bx% AND 2) <> 0)
    XMouse% = CX%
    YMouse% = DX%
END SUB

SUB Piece.CheckMove

IF ABS(FromX - ToX) <> 2 OR ABS(FromY - ToY) <> 2 THEN
    Valid = 0
ELSEIF Position((FromX + ToX) / 2, (FromY + ToY) / 2) <> 1 THEN
    Valid = 0
ELSEIF ToX = 0 OR ToY = 0 THEN
    Valid = 0
ELSE
    Valid = 1
END IF

END SUB

SUB Piece.GetNumber

PieceNumberX = 0: PieceNumberY = 0

FOR X = 1 TO 8
    FOR Y = 1 TO 8
        IF XMouse% >= LocationX(X, Y) + 6 AND XMouse% <= LocationX(X, Y) + 44 AND YMouse% >= LocationY(X, Y) + 6 AND YMouse% <= LocationY(X, Y) + 44 THEN PieceNumberX = X: PieceNumberY = Y
        IF PieceNumberX = X THEN EXIT FOR
    NEXT Y
    IF PieceNumberX = X THEN EXIT FOR
NEXT X

END SUB

SUB Piece.Highlight
       
Piece.CheckMove
IF Valid = 1 THEN
    PUT (LocationX(FromX, FromY), LocationY(FromX, FromY)), Pieces.HGFX2, PSET
ELSE
    PUT (LocationX(FromX, FromY), LocationY(FromX, FromY)), Pieces.HGFX1, PSET
END IF

END SUB

SUB Piece.Remove
    Position(FromX, FromY) = 0
    Position((FromX + ToX) / 2, (FromY + ToY) / 2) = 0
    Position(ToX, ToY) = 1
END SUB

SUB Place.Icon (X, Y, FileName$)

DEF SEG = VARSEG(Button.Button(0))
    BLOAD FileName$ + ".gfx", VARPTR(Button.Button(0))
DEF SEG

PUT (X, Y), Button.Button, PSET

END SUB

SUB Program.About
Mouse.Hide

LINE (200, 100)-(440, 400), 7, BF
LINE (200, 100)-(440, 400), 15, B
LINE (200, 400)-(440, 400), 0
LINE (440, 100)-(440, 400), 0
LINE (201, 399)-(439, 399), 8
LINE (439, 101)-(439, 399), 8

Place.Icon 205, 105, "logo_1"
Place.Icon 315, 135, "logo_2"

Place.Icon 233, 225, "about_01"
Place.Icon 320, 225, "about_02"
Place.Icon 233, 320, "about_03"
Place.Icon 320, 320, "about_04"

Mouse.Show

DO
    Mouse.Status LeftButton%, RightButton%, XMouse%, YMouse%
LOOP UNTIL LeftButton% = 0

DO
    Mouse.Status LeftButton%, RightButton%, XMouse%, YMouse%
LOOP UNTIL LeftButton% <> 0

END SUB

SUB Program.Help
Mouse.Hide

Place.Icon 121, 105, "help_01"
Place.Icon 219, 105, "help_02"
Place.Icon 319, 105, "help_03"
Place.Icon 419, 105, "help_04"

Place.Icon 121, 205, "help_05"
Place.Icon 220, 205, "help_06"
Place.Icon 320, 205, "help_07"
Place.Icon 420, 205, "help_08"


Mouse.Show

DO
    Mouse.Status LeftButton%, RightButton%, XMouse%, YMouse%
LOOP UNTIL LeftButton% = 0

DO
    Mouse.Status LeftButton%, RightButton%, XMouse%, YMouse%
LOOP UNTIL LeftButton% <> 0

'Draw Tiles.GFX
Mouse.Hide
FOR X = 120 TO 470 STEP 50
    FOR Y = 40 TO 390 STEP 50
        PUT (X, Y), Tiles.GFX, PSET
    NEXT Y
NEXT X

Mouse.Show
END SUB

SUB Screen.Fade (cl)

Mouse.Hide
FOR FD = 0 TO 63
    FOR F = 0 TO cl
        OUT &H3C7, F
        r = INP(&H3C9) - 1: IF r = -1 THEN r = 0
        g = INP(&H3C9) - 1: IF g = -1 THEN g = 0
        B = INP(&H3C9) - 1: IF B = -1 THEN B = 0
        OUT &H3C8, F
        OUT &H3C9, r
        OUT &H3C9, g
        OUT &H3C9, B
    NEXT F
NEXT FD

SCREEN 9
SCREEN 12
CLS
Mouse.Show
END SUB

REM $DYNAMIC
SUB Screen.PalLoad (PalFile$)
 filenumber = FREEFILE
 OPEN PalFile$ + ".PAL" FOR BINARY AS #FREEFILE
   IF LOF(1) = 0 THEN
          CLOSE #filenumber
          KILL PalFile$ + ".PAL"
          EXIT SUB
   END IF
  CLOSE #1
 OPEN PalFile$ + ".PAL" FOR INPUT AS #1
  FOR i = 1 TO 768
   INPUT #1, pal(i)
  NEXT i
 CLOSE #1
 num = 1
 an = 1
  DO
   pall(an).r = pal(num)
   num = num + 1
   pall(an).g = pal(num)
   num = num + 1
   pall(an).B = pal(num)
   num = num + 1
   an = an + 1
  LOOP UNTIL num > 768
 OUT &H3C7, 0: OUT &H3C8, 0
 FOR a% = 1 TO 256 * 3:
  OUT &H3C9, pal(a%)
 NEXT a%
END SUB

REM $STATIC
DEFINT A-Z
SUB Sound.Delay (Sound.TimeDelayer!)

Sound.TimeDelayed! = TIMER
DO
LOOP WHILE (TIMER - Sound.TimeDelayed! < Sound.TimeDelayer!) OR (Sound.TimeDelayed! > TIMER)

END SUB

FUNCTION Sound.GetSBAddress%
tmp% = 0
blast$ = UCASE$(ENVIRON$("BLASTER"))
IF LEN(blast$) THEN
   tmp% = INSTR(blast$, "A")
   tmp1$ = MID$(blast$, tmp% + 1, 3)
   tmp% = VAL("&H" + tmp1$)
   IF tmp% = 203 THEN tmp% = -1    'If there is no value assigned
   IF tmp% > 0 THEN
      tmp2% = INSTR(blast$, "D")
      Sound.DMA% = VAL(MID$(blast$, tmp2% + 1))        'Sound.DMA% is a global variable
      IF Sound.DMA% < 0 OR Sound.DMA% > 7 THEN tmp% = -2
   END IF
END IF
Sound.GetSBAddress% = tmp%
END FUNCTION

SUB Sound.PlayBack (buffer$, size%, freq&, BytesPerSec&, chans%, num%)
size% = size% - 1
segment& = VARSEG(buffer$)
offset& = SADD(buffer$)
IF segment& < 0 THEN segment& = segment& + 65536
IF offset& < 0 THEN offset& = offset& + 65536
baseaddr& = segment& * 16 + offset&
look1% = VARPTR(baseaddr&)
look2% = VARPTR(size%)
SELECT CASE Sound.DMA%
   CASE 0
      Sound.DMApage% = &H87   '135 decimal
      Sound.DMAaddr% = 0
      Sound.DMAlen% = 1
   CASE 1
      Sound.DMApage% = &H83   '131 decimal
      Sound.DMAaddr% = 2
      Sound.DMAlen% = 3
   CASE 2
      Sound.DMApage% = &H81
      Sound.DMAaddr% = 4
      Sound.DMAlen% = 5
   CASE 3
      Sound.DMApage% = &H82
      Sound.DMAaddr% = 6
      Sound.DMAlen% = 7
   CASE 4
      Sound.DMApage% = &H8F
      Sound.DMAaddr% = &HC0
      Sound.DMAlen% = &HC2
   CASE 5
      Sound.DMApage% = &H8B
      Sound.DMAaddr% = &HC4
      Sound.DMAlen% = &HC6
   CASE 6
      Sound.DMApage% = &H89
      Sound.DMAaddr% = &HC8
      Sound.DMAlen% = &HCA
   CASE 7
      Sound.DMApage% = &H8A
      Sound.DMAaddr% = &HCC
      Sound.DMAlen% = &HCE
END SELECT
SELECT CASE Sound.DMA%
   CASE 0 TO 3
      Sound.DMAmask% = &HA
      Sound.DMAmode% = &HB
      Sound.DMAclear% = &HC
      Sound.DMAstatus% = &H8
   CASE 4 TO 7
      Sound.DMAmask% = &HD4
      Sound.DMAmode% = &HD6
      Sound.DMAclear% = &HD8
      Sound.DMAstatus% = &HD0
END SELECT
SELECT CASE Sound.DMA%
   CASE 0, 4
      Sound.DMAterminal% = 1   'bit 0 of status register (&H08 or &HD0)
   CASE 1, 5
      Sound.DMAterminal% = 2   'bit 1
   CASE 2, 6
      Sound.DMAterminal% = 4   'bit 2
   CASE 3, 7
      Sound.DMAterminal% = 8   'bit 3
END SELECT

OUT Sound.DMAmask%, Sound.DMA% + 4   'mask the Sound.DMA channel
OUT Sound.DMAclear%, &H0       '(clear the internal Sound.DMA flip/flop)
OUT Sound.DMAmode%, 72 + Sound.DMA%  '  72=010010XX where XX=Sound.DMAchannel%
OUT Sound.DMAaddr%, PEEK(look1%)      'bits 0-7 of  the 20bit address
OUT Sound.DMAaddr%, PEEK(look1% + 1)  'bits 8-15 of the 20bit address
OUT Sound.DMApage%, PEEK(look1% + 2)  'bits 16-19 of the 20 bit address
OUT Sound.DMAlen%, PEEK(look2%)       'bits 0-7 of size%
OUT Sound.DMAlen%, PEEK(look2% + 1)   'bits 8-15  of size%
OUT Sound.DMAmask%, Sound.DMA%              'enable channel

IF num% = 1 THEN  'only need to Write out time constant once
   timeconst% = 256 - 1000000 / (freq& * chans%)
   CALL Sound.WriteToDSP(&H40)
   CALL Sound.WriteToDSP(timeconst%)
   'Reset Mixer    DSPmixeraddress = Sound.SBAddress% + &H4
   OUT Sound.SBAddress% + &H4, &H0
   OUT Sound.SBAddress% + &H4 + 1, 0
   'Set Volume to Maximum...255
   OUT Sound.SBAddress% + &H4, &H22
   OUT Sound.SBAddress% + &H4 + 1, 255
   IF chans% = 2 THEN
      'Set mixer to Stereo Output
      OUT Sound.SBAddress% + &H4, &HE
      OUT Sound.SBAddress% + &H4 + 1, 34      '34=2^5+2^1
   END IF
END IF
IF BytesPerSec& > 22000 THEN
   CALL Sound.WriteToDSP(&H48)   'Set Block Size
ELSE
   CALL Sound.WriteToDSP(&H14)   'Sound.DMA Mode 8-bit DAC
END IF
CALL Sound.WriteToDSP(PEEK(look2%))      'Lo byte of address
CALL Sound.WriteToDSP(PEEK(look2% + 1))  'High byte of address
IF BytesPerSec& > 22000 THEN CALL Sound.WriteToDSP(&H91)  'High Speed Sound.DMA mode 8-bit
dummy% = INP(Sound.DMAstatus%)    'Read status byte once to make sure Sound.DMA is going.
WAIT Sound.DMAstatus%, Sound.DMAterminal%   'Loop until terminal count bit set in Sound.DMA status register
'Sound.DMA Transfer is Now Complete
'Acknowledge the DSP interrupt by reading the DATA AVAILABLE port once
dummy% = INP(Sound.SBAddress% + &HE)    'DSP Available address
END SUB

DEFSNG A-Z
SUB Sound.PlayWAV (wavefile$)

Sound.Repeats% = 1
Sound.SBAddress% = Sound.GetSBAddress%
SELECT CASE Sound.SBAddress%
   CASE -2
      PRINT "Bad Sound.DMA Channel specified!"
      END
   CASE -1
      PRINT "No Port Base Address Given!"
      END
   CASE 0
      PRINT "No BLASTER Environment Variable Set!"
      END
   CASE ELSE
      'Assume a valid Address Exists
'      PRINT "Blaster Address = "; HEX$(Sound.SBAddress%)
END SELECT
IF NOT Sound.SBReset% THEN
   PRINT "SoundBlaster Card Would Not Reset!"
   END
END IF

sp% = INSTR(Spec$, " ")
IF sp% THEN
   wavefile$ = LEFT$(Spec$, sp% - 1)
   Sound.Repeats% = VAL(RIGHT$(Spec$, LEN(Spec$) - sp%))
   IF Sound.Repeats% = 0 THEN Sound.Repeats% = 1
ELSE
   IF LEN(Spec$) THEN
      wavefile$ = Spec$
      Sound.Repeats% = 1
   END IF
END IF

IF LEN(wavefile$) = 0 THEN
END IF

CALL Sound.ValidHeader(wavefile$, LenHeader%, WavLen&, Channels%, Sampling&, bytes&, ok%)

IF NOT ok% THEN
   PRINT "Bad Wave File Format"
   END
END IF

MaxBuffer% = 7053

CALL Sound.WriteToDSP(&HD1)  'Speaker ON
FOR repeat% = 1 TO Sound.Repeats%    'This can loop to play the file ii% times]
filenum% = FREEFILE
   OPEN wavefile$ FOR BINARY AS filenum%
      num% = 0
      SEEK filenum%, LenHeader% + 1
      Remaining& = WavLen&
      DO
         num% = num% + 1
         IF Remaining& > MaxBuffer% THEN
            BufferLen% = MaxBuffer%
         ELSE
            BufferLen% = Remaining&
         END IF
         Remaining& = Remaining& - BufferLen%
         buffer$ = SPACE$(BufferLen%)
         GET filenum%, , buffer$
         CALL Sound.PlayBack(buffer$, BufferLen%, Sampling&, bytes&, Channels%, num%)
      LOOP WHILE Remaining& > 0
      OUT &H20, &H20   'Reset Normal Interrupt Service
   CLOSE filenum%
NEXT repeat%
CALL Sound.WriteToDSP(&HD3)  'Speaker OFF

END SUB

DEFINT A-Z
FUNCTION Sound.SBReset%
OUT Sound.SBAddress% + &H6, 1
Sound.Delay .1
OUT Sound.SBAddress% + &H6, 0
Sound.TimeDelayed! = TIMER: noreset% = 0
DO
    IF TIMER - Sound.TimeDelayed! > 1! THEN noreset% = -1
LOOP UNTIL ((INP(Sound.SBAddress% + &HE) AND 128) = 128) OR noreset%
IF NOT noreset% THEN
   IF INP(Sound.SBAddress% + &HA) = &HAA THEN
      Sound.SBReset% = -1
   ELSE
      Sound.SBReset% = 0
   END IF
ELSE
   Sound.SBReset% = 0
END IF
END FUNCTION

SUB Sound.ValidHeader (FILE$, LenHeader%, dataLen&, nChannels%, nSamplesPerSec&, nAvgBytesPerSec&, ok%)
rID$ = SPACE$(4)
wID$ = SPACE$(4)
fID$ = SPACE$(4)
dat$ = SPACE$(4)
dummy$ = SPACE$(1)

filenum% = FREEFILE
OPEN FILE$ FOR BINARY AS filenum%
  GET filenum%, , rID$
  GET filenum%, , rLen&
  GET filenum%, , wID$
  GET filenum%, , fID$
  GET filenum%, , fLen&
  GET filenum%, , wFormatTag%       '2 bytes
  GET filenum%, , nChannels%        '2 bytes
  GET filenum%, , nSamplesPerSec&   '4 bytes
  GET filenum%, , nAvgBytesPerSec&  '4 bytes
  GET filenum%, , nBlockAlign%      '2 bytes
  GET filenum%, , FormatSpecific%   '2 bytes
  'Read bytes until have read fLen& total bytes.
  'I have no idea what these next bytes are used for (if they even exist).
  FOR i% = 1 TO fLen& - 16          '16 bytes is what we have read in so far
     GET filenum%, , dummy$         'read in 1 byte at a time
  NEXT i%
  GET filenum%, , dat$
  IF UCASE$(dat$) = "FACT" THEN
     'funny format...
     GET filenum%, , dummy&
     GET filenum%, , dummy&
     GET filenum%, , dat$
  END IF
  GET filenum%, , dataLen&
  LenHeader% = LOC(1)
CLOSE filenum%
IF UCASE$(rID$) = "RIFF" THEN
   IF UCASE$(wID$) = "WAVE" THEN
      IF UCASE$(dat$) = "DATA" THEN
         IF UCASE$(fID$) = "FMT " THEN
           IF FormatSpecific% = 8 THEN ok% = -1
         END IF
      END IF
   END IF
END IF
END SUB

SUB Sound.WriteToDSP (v%)
DO
LOOP UNTIL (INP(Sound.SBAddress% + &HC) AND 128) = 0
OUT Sound.SBAddress% + &HC, v%
END SUB

DEFSNG A-Z
SUB System.Close

Screen.Fade 50
Mouse.Hide
SCREEN 0: WIDTH 80: CLS

PRINT "                         One-Check Solitaire   Version 3.0e"
PRINT
PRINT " Address: Daniel Fletcher"
PRINT "          XYZZY Productions"
PRINT "          P.O. Box 208"
PRINT "          Taberg, NY  13471-0208"
PRINT
PRINT " E-Mail: danielfletcher@cyberdude.com   {E-Mail me for updates to"
PRINT "         xyzzyproductions@hotmail.com    automatically be sent to you."
PRINT "                                         Or just e-mail to tell me where"
PRINT "                                         you got this copy from."
PRINT
PRINT " Web site: http://www.geocities.com/SiliconValley/Vista/3048/"

END SUB

