DECLARE SUB setcard (cardtype%)
'$INCLUDE: 'dash.bi'
DECLARE FUNCTION BytesRequired& (Filename$)
DECLARE SUB DetectSettings (BasePort%, IRQ%, LoDMA%, HiDMA%, cardtype%)
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE SUB LoadandPlayMIDI (Filename$, MIDISegment%, MIDIOffset%)
DECLARE FUNCTION MIDIError$ ()
DECLARE FUNCTION MixerChip$ ()
DECLARE SUB SetMidi (LeftChannel%, RightChannel%)
DECLARE FUNCTION SoundCard$ (cardtype%)
DECLARE SUB StopMidi ()
DECLARE FUNCTION InternalBitRead% (Variable%, BitNum%)
DECLARE SUB InternalBitSet (Variable%, BitNum%, OnOff%)
DECLARE SUB InternalBitToggle (Variable%, BitNum%)
DECLARE SUB InternalGetIntVector (intnum%, segment%, offset%)
DECLARE SUB InternalGetVol (LeftChannel%, RightChannel%, Index%)
DECLARE SUB InternalSetVol (LeftChannel%, RightChannel%, Index%)
DECLARE SUB InternalWriteMixer (Index%, Value%)
DECLARE FUNCTION InternalReadMixer% (Index%)
DECLARE SUB drawmap ()
DECLARE SUB villagename ()
DECLARE SUB treasuresub ()
DECLARE SUB sleepsub ()
DECLARE SUB textbox ()
DECLARE SUB talk (num%)
DECLARE SUB npcmove ()
DECLARE SUB timesub ()
DECLARE SUB drawchar (x%)
DECLARE SUB getpress ()
DECLARE SUB mapsub ()
DECLARE SUB load ()
DECLARE SUB ini ()
DIM SHARED tileimages(4223) AS LONG, cloudx%, cloudy%
DIM SHARED t AS SINGLE, t2 AS INTEGER, ot2 AS INTEGER, tt2 AS INTEGER
DIM SHARED npc(4223) AS LONG, npcloc(9, 2) AS INTEGER
DIM SHARED npcquote(9) AS STRING, npcdir(9) AS INTEGER, linkit AS STRING * 12
DIM SHARED kp AS INTEGER, mapx AS INTEGER, mapy AS INTEGER
DIM SHARED keypress AS INTEGER, a AS INTEGER, B AS INTEGER, village$, start%
DIM SHARED okp AS INTEGER, map(4097) AS INTEGER, linkit2 AS STRING * 4
DIM SHARED charGP%, charbg%, chartext%, charshadow%, GameDist%
DIM SHARED buffer&(15999), scrx%, scry%, timevar, village2$, notext%
DIM SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER
DIM SHARED MIDI.LOADED AS INTEGER, SBMIDI.INTERRUPT AS INTEGER
DIM SHARED SBSIM.INTERRUPT AS INTEGER, PAUSED AS SINGLE
DIM SHARED MIXER.CHIP AS INTEGER, SB.BASEPORT AS INTEGER, SB.IRQ AS INTEGER
DIM SHARED SB.LODMA AS INTEGER, SB.HIDMA AS INTEGER, SB.CARDTYPE AS INTEGER
DIM SHARED BIT.STORAGE(0 TO 7) AS INTEGER, SENSITIVE AS INTEGER
DIM SHARED REVERSE.STEREO AS INTEGER, SOUND.DISABLED AS INTEGER
DIM Music%(19999)
DIM SHARED forex%, forey%

DriversLoaded SBMIDI.INTERRUPT, SBSIM.INTERRUPT
IF SBMIDI.INTERRUPT = 0 THEN SBMIDI.INTERRUPT = &H80
IF SBSIM.INTERRUPT = 0 THEN SBSIM.INTERRUPT = &H81
DetectSettings SB.BASEPORT, SB.IRQ, SB.LODMA, SB.HIDMA, SB.CARDTYPE
IF SB.CARDTYPE = 0 THEN setcard 2
IF SB.BASEPORT = 0 THEN SB.BASEPORT = &H220
IF SB.IRQ = 0 THEN SB.IRQ = 5
IF SB.LODMA = 0 THEN SB.LODMA = 1
IF SB.HIDMA = 0 AND SB.CARDTYPE = 6 THEN SB.HIDMA = 5
	
RANDOMIZE TIMER
SCREEN 13
VSPalette ""
VSClearKB

SetMidi 0, 0
IF MID$(COMMAND$, 1, 8) = "ROAMA   " THEN
	LoadandPlayMIDI "music\roama.MID", VARSEG(Music%(0)), VARPTR(Music%(0))
ELSEIF MID$(COMMAND$, 1, 8) = "TANDEN  " THEN
	LoadandPlayMIDI "music\tanden.MID", VARSEG(Music%(0)), VARPTR(Music%(0))
ELSEIF MID$(COMMAND$, 1, 8) = "TANDENCA" THEN
	LoadandPlayMIDI "music\tandenca.MID", VARSEG(Music%(0)), VARPTR(Music%(0))
END IF
FOR a% = 0 TO 15
	SetMidi a%, a%
	VSDelay 7
NEXT

load
ini
villagename
t = TIMER
kp = 1: keypress = 77
start% = 1
timevar = TIMER
DO
	mapsub
	IF linkit2 = "done" THEN REDIM SHARED buffer&(15999): linkit2 = ""
	keypress = INP(&H60)
	IF kp <> 0 THEN okp = kp
	kp = 0
	timesub
	IF ot2 <> t2 THEN npcmove
	getpress
LOOP

REM $DYNAMIC
SUB DetectSettings (BasePort%, IRQ%, LoDMA%, HiDMA%, cardtype%)

BasePort% = 0
IRQ% = 0
LoDMA% = 0
HiDMA% = 0
cardtype% = 0

Settings$ = ENVIRON$("BLASTER")

FOR I% = 1 TO LEN(Settings$) - 1
	 SELECT CASE UCASE$(MID$(Settings$, I%, 1))
		  CASE "T"
				cardtype% = VAL(MID$(Settings$, I% + 1, 1))
		  CASE "A"
				BasePort% = VAL("&H" + LTRIM$(STR$(VAL(MID$(Settings$, I% + 1, 3)))))
		  CASE "I"
				IRQ% = VAL(MID$(Settings$, I% + 1, 2))
		  CASE "D"
				LoDMA% = VAL(MID$(Settings$, I% + 1, 1))
		  CASE "H"
				HiDMA% = VAL(MID$(Settings$, I% + 1, 1))
	 END SELECT
NEXT I%

IF cardtype% = 0 THEN
	 SELECT CASE LoDMA%
		  'If the DMA is 210h or 230h, the card is an SB1.0/1.5.
		  CASE &H210, &H230
				cardtype% = 1
		  'If the DMA is 250h or 260h, the card is either an SB2CD or a
		  'Sound Blaster 16.  It could also be a Sound Blaster 1.0/1.5,
		  'but it probably isn't.  Actually, it's also unlikely that the card
		  'is an SB16, but I check for it anyway, because there's an easy way
		  'to tell if it is - the High DMA channel will be greater than 0.
		  '
		  'On the other hand, there's no way that I know of to
		  'distinguish an SB 1.0 from an SB 2.0, except by looking at the
		  'BLASTER environment variable.  And since this code is executing
		  'that method obviously failed.
		  CASE &H250, &H260
				'Examining the High DMA channel will narrow it down.
				'If the High DMA is greater than 0, the card is an SB16.
				IF HiDMA% THEN
					 cardtype% = 6
				'Otherwise, define the card as a Sound Blaster 2.0.
				ELSE
					 cardtype% = 3
				END IF
		  'If the DMA channel is any other value....
		  CASE ELSE
				'Check the High DMA channel.  If it's a non-zero value,
				'we've got an SB16.
				IF HiDMA% THEN
					 cardtype% = 6
				'Otherwise....
				ELSE
					 'If sensitive error checking is on, define the card as
					 'a Sound Blaster 1.0/1.5.
					 IF SENSITIVE THEN
						  cardtype% = 1
					 'Otherwise, assume it's a Sound Blaster Pro.
					 ELSE
						  cardtype% = 4
					 END IF
				END IF
	 END SELECT
END IF

'Determine the sound card's mixer chip
SELECT CASE cardtype%
	 'If the card could not be detected....
	 CASE 0
		  MIDI.ERROR = 7
		  'If sensitive error checking is on, disable mixer operations
		  IF SENSITIVE THEN
				MIXER.CHIP = 0
		  'Otherwise, assume the default mixer chip.
		  ELSE
				MIXER.CHIP = 2
		  END IF
	 'If the card is a Sound Blaster 1.0/1.5 or equivalent....
	 CASE 1
		  'Return an error.
		  MIDI.ERROR = 6
		  'If sensitive error checking is on, disable mixer operations and
		  'exit.
		  IF SENSITIVE THEN
				MIXER.CHIP = 0
				EXIT SUB
		  'Otherwise, set the earliest mixer chip and continue.
		  ELSE
				MIXER.CHIP = 1
		  END IF
	 'If the card is a Sound Blaster 2.0/2.5 or equivalent....
	 CASE 3
		  'There are two different kinds of SB 2.0 cards: the regular SB2,
		  'and the SB2CD.  The SB2CD has a mixer chip (the CT1335), whereas
		  'the SB 2.0 does not.  The way to tell them apart is that the
		  'Sound Blaster 2.0 uses Base Ports 220h and 240h, and the SB2CD
		  'uses ports 250h and 260h.
		  '
		  'Assume the sound card is an SB2CD for now...
		  MIXER.CHIP = 1
		  'If the card is defined as an SB 2.0, not an SB 2.0 CD, and
		  'sensitive error checking is on, disable mixer operations.
		  IF (BasePort% = &H220 OR BasePort% = &H240) AND SENSITIVE <> 0 THEN
				MIXER.CHIP = 0
		  END IF
		  MIDI.ERROR = 0
	 'If the card is a Sound Blaster Pro, assume chip CT1345
	 CASE 2, 4, 5
		  MIXER.CHIP = 2
		  MIDI.ERROR = 0
	 'If the card is a Sound Blaster 16 or later, assume chip CT1745
	 CASE IS >= 6
		  MIXER.CHIP = 3
		  MIDI.ERROR = 0
END SELECT
END SUB

SUB drawchar (x%)
IF scrx% <> 0 OR scry% <> 0 THEN anim% = 0 ELSE anim% = 1
IF x% = 0 THEN x% = 1
VSSprite VARSEG(tileimages(0)), VARPTR(tileimages(x% * 66)) + 1056 * anim%, 152, 88, VARSEG(buffer&(0)), VARPTR(buffer&(0))
END SUB

SUB drawmap
DIM d1 AS INTEGER, d2 AS INTEGER
	VSClearKB
	timesub
	IF ot2 <> t2 THEN npcmove
	FOR a = -5 TO 17
		FOR B = -2 TO 12
			d1 = mapx - 6 + a: d2 = mapy - 5 + B
				IF d2 >= 0 AND d2 < 64 THEN
					VSSprite VARSEG(tileimages(0)), VARPTR(tileimages(66 * map((d1 + 64) MOD 64 + 64 * d2))), 16 * a + 56 + scrx%, 16 * B + 12 + scry%, VARSEG(buffer&(0)), VARPTR(buffer&(0))
				ELSEIF d2 < 0 THEN
					VSSprite VARSEG(tileimages(0)), VARPTR(tileimages(66 * map((d1 + 64) MOD 64))), 16 * a + 56 + scrx%, 16 * B + 12 + scry%, VARSEG(buffer&(0)), VARPTR(buffer&(0))
				ELSE
					VSSprite VARSEG(tileimages(0)), VARPTR(tileimages(66 * map((d1 + 64) MOD 64 + 4032))), 16 * a + 56 + scrx%, 16 * B + 12 + scry%, VARSEG(buffer&(0)), VARPTR(buffer&(0))
				END IF
				FOR TEMP% = 0 TO 9
					IF npcloc(TEMP%, 0) = d1 AND npcloc(TEMP%, 1) = d2 AND npcloc(npcnum%, 1) > 0 AND npcloc(npcnum%, 2) > 0 THEN
							VSSprite VARSEG(npc(0)), VARPTR(npc(0)) + 4 * 528 * npcloc(TEMP%, 2) + 66 * 4 * npcdir(TEMP%), 56 + 16 * a + scrx%, 4 + 16 * B + scry%, VARSEG(buffer&(0)), VARPTR(buffer&(0))
					END IF
				NEXT
		NEXT
	NEXT
	IF kp > 0 THEN drawchar kp ELSE drawchar okp
	FOR a = -5 TO 17
		FOR B = 4 TO 6
			d1 = mapx - 6 + a: d2 = mapy - 5 + B
				IF d2 >= 0 AND d2 < 64 THEN
					IF map((d1 + 64) MOD 64 + 64 * d2) > 54 THEN
						VSSprite VARSEG(tileimages(0)), VARPTR(tileimages(66 * map((d1 + 64) MOD 64 + 64 * d2))), 16 * a + 56 + scrx%, 16 * B + 12 + scry%, VARSEG(buffer&(0)), VARPTR(buffer&(0))
						TEMP% = map((d1 + 64) MOD 64 + 64 * d2 - 64)
						IF d2 >= 1 AND TEMP% < 31 OR TEMP% > 54 THEN
							VSSprite VARSEG(tileimages(0)), VARPTR(tileimages(66 * TEMP%)), 16 * a + 56 + scrx%, 16 * B - 4 + scry%, VARSEG(buffer&(0)), VARPTR(buffer&(0))
						END IF
					END IF
				END IF
		NEXT
	NEXT
	IF village2$ = "Tanden  " AND GameDist% = 1 THEN
		FOR a = -3 TO 21
			FOR B = -3 TO 14
				VSSpriteT VARSEG(tileimages(0)), VARPTR(tileimages(4158)), 16 * a + scrx% * 2 + cloudx% + 8, 16 * B + scry% * 2 + cloudy% + 8, VARSEG(buffer&(0)), VARPTR(buffer&(0))
			NEXT
		NEXT
	END IF
	IF timevar + 10 > TIMER AND notext% = 0 THEN VSFont VARSEG(buffer&(0)), VARPTR(buffer&(0)), 159 - 4 * LEN(village2$), 190, village2$, chartext% * 32 + 31, chartext% * 32 + 16
	VSPCopy VARSEG(buffer&(0)), VARPTR(buffer&(0)), &HA000, 0
END SUB

SUB DriversLoaded (SBMIDI%, SBSIM%) STATIC
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
FileSize& = LOF(FF%)
IF FileSize& = 0 THEN
	 CLOSE FF%
	 KILL "DRIVERS.DAT"
	 MIDI.ERROR = 1
	 EXIT SUB
ELSEIF FileSize& <> 1024 THEN
	 CLOSE FF%
	 MIDI.ERROR = 9
	 EXIT SUB
END IF
REDIM DRIVERDATA$(1 TO 5)
FOR I% = 1 TO 4
	 DRIVERDATA$(I%) = INPUT$(256, #FF%)
NEXT I%
CLOSE #FF%

SBMIDI% = 0
SBSIM% = 0
FOR I% = &H80 TO &HE1
	 InternalGetIntVector I%, segment%, offset%
	 'If the address is null, then the interrupt is not in use, and can be
	 'skipped.
	 IF segment% = 0 AND offset% = 0 THEN GOTO Skip:
	 'The following code checks for the drivers by looking for the text
	 '"SBMIDI" and "SBSIM" at certain locations in the driver code.  It
	 'sounds simplistic, but it's very accurate.  If it doesn't work,
	 'a different method is used.
	 IF SBMIDI% = 0 THEN
		  NewSegment% = CVI(MKI$(CVL(MKI$(segment%) + CHR$(0) + CHR$(0)) - &H11&))
		  DEF SEG = NewSegment%
		  TEMP$ = ""
		  FOR J% = 1 TO 6
				TEMP$ = TEMP$ + CHR$(PEEK(271 + J%))
		  NEXT
		  IF TEMP$ = "SBMIDI" THEN SBMIDI% = I%
	 END IF
	 IF SBSIM% = 0 THEN
		  NewSegment% = CVI(MKI$(CVL(MKI$(segment%) + CHR$(0) + CHR$(0)) - &H1&))
		  DEF SEG = NewSegment%
		  TEMP$ = ""
		  FOR J% = 1 TO 5
				TEMP$ = TEMP$ + CHR$(PEEK(274 + J%))
		  NEXT
		  IF TEMP$ = "SBSIM" THEN SBSIM% = I%
	 END IF
  
	 'This is the second detection method.  It's more complex than the first
	 'method, but not really any more accurate.  In fact, it's probably
	 'less accurate.  It's kind of a last ditch effort in case the first
	 'method fails.

	 'Point to the segment of the interrupt handler.
	 DEF SEG = segment%
	 'Read 256 bytes of the driver code.
	 DRIVERDATA$(5) = ""
	 FOR J% = 0 TO 255
		  Byte% = PEEK(offset% + J%)
		  DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(Byte%)
	 NEXT J%
	 'Check to see if the code matches any of the previously saved data.
	 FOR J% = 1 TO 4
		  MATCH% = 1
		  FOR K% = 0 TO 255
				IF MID$(DRIVERDATA$(J%), K% + 1, 1) <> MID$(DRIVERDATA$(5), K% + 1, 1) THEN
					 SELECT CASE K%
						  CASE IS = 14, 15, 113, 114, 235, 236
						  CASE ELSE
								MATCH% = 0
								EXIT FOR
					 END SELECT
				END IF
		  NEXT K%
		  IF MATCH% THEN
				IF J% = 1 THEN SBSIM% = I%
				IF J% <> 1 THEN SBMIDI% = I%
		  END IF
		  IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	 NEXT J%
	 IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
Skip:
NEXT I%
MIDI.ERROR = 0
END SUB

SUB getpress
	IF keypress = 77 AND mapx <= 62 THEN
		IF map(mapx + 1 + 64 * mapy) > 30 THEN
			mapx = mapx + 1
			kp = 1
		END IF
	END IF
	IF keypress = 75 AND mapx >= 1 THEN
		IF map(mapx - 1 + 64 * mapy) > 30 THEN
			mapx = mapx - 1
			kp = 2
		END IF
	END IF
	IF keypress = 72 AND mapy >= 1 THEN
		IF map(mapx + 64 * (mapy - 1)) > 30 THEN
			mapy = mapy - 1
			kp = 3
		END IF
	END IF
	IF keypress = 80 AND mapy <= 62 THEN
		IF map(mapx + 64 * (mapy + 1)) > 30 THEN
			mapy = mapy + 1
			kp = 4
		END IF
	END IF
END SUB

SUB ini
VSFill &HA000, 0
OPEN "saves\p1.nfo" FOR INPUT AS #1
	FOR a% = 0 TO 12: LINE INPUT #1, TEMP$: NEXT a%
	LINE INPUT #1, gp$
	LINE INPUT #1, bgr$
	LINE INPUT #1, text$
	LINE INPUT #1, shadow$
	LINE INPUT #1, gamedst$
	LINE INPUT #1, Mapxt$
	LINE INPUT #1, Mapyt$
CLOSE
charGP% = VAL(MID$(gp$, 8, 5))
charbg% = VAL(MID$(bgr$, 8, 1))
chartext% = VAL(MID$(text$, 10, 1))
charshadow% = VAL(MID$(shadow$, 12, 1))
GameDist% = VAL(MID$(gamedst$, 14, 2))
END SUB

REM $STATIC
FUNCTION InternalBitRead% (Variable%, BitNum%)
DEF SEG = VARSEG(Variable%)
InternalBitRead% = -((PEEK(VARPTR(Variable%) + BitNum% \ 8) AND 2 ^ (BitNum% MOD 8)) > 0)
END FUNCTION

SUB InternalBitSet (Variable%, BitNum%, OnOff%)
offset% = VARPTR(Variable%)
DEF SEG = VARSEG(Variable%)
IF OnOff% THEN
	 POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) OR 2 ^ (BitNum% MOD 8)
ELSE
	 POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) AND 255 - 2 ^ (BitNum% MOD 8)
END IF
END SUB

SUB InternalBitToggle (Variable%, BitNum%)
offset% = VARPTR(Variable%)
DEF SEG = VARSEG(Variable%)
POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) XOR 2 ^ (BitNum% MOD 8)
END SUB

SUB InternalGetIntVector (intnum%, segment%, offset%) STATIC
'If the code hasn't been loaded already, do it now.
IF GetIntVCodeLoaded% = 0 THEN
	 asm$ = CHR$(&H55) + CHR$(&H89) + CHR$(&HE5) + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
	 asm$ = asm$ + CHR$(&H8A) + CHR$(&H7) + CHR$(&HB4) + CHR$(&H35)
	 asm$ = asm$ + CHR$(&HCD) + CHR$(&H21) + CHR$(&H8C) + CHR$(&HC1) + CHR$(&H89) + CHR$(&HDA)
	 asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) + CHR$(&H89) + CHR$(&HF)
	 asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6) + CHR$(&H89) + CHR$(&H17) + CHR$(&H5D) + CHR$(&HCB)
	 asm$ = asm$ + CHR$(&H34) + CHR$(&H0) + CHR$(&H60) + CHR$(&H23) + CHR$(&H0)
	 GetIntVCodeLoaded% = 1
END IF
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(intnum%, segment%, offset%, SADD(asm$))
END SUB

FUNCTION InternalReadMixer% (Index%)
OUT SB.BASEPORT + 4, Index%
InternalReadMixer% = INP(SB.BASEPORT + 5)
END FUNCTION

SUB InternalSetVol (LeftChannel%, RightChannel%, Index%)
SELECT CASE MIXER.CHIP
	 CASE 0: EXIT SUB
	 CASE 1
		  IF LeftChannel% > -1 AND LeftChannel% < 32 THEN
				LeftChannel% = LeftChannel% \ 4
				IF LeftChannel% > 7 THEN LeftChannel% = 7
				Volume% = InternalReadMixer%(2)
				FOR I% = 0 TO 2
					 BIT.STORAGE(I%) = InternalBitRead%(LeftChannel%, I%)
					 IF BIT.STORAGE(I%) THEN
						  InternalBitSet Volume%, I% + 1, 1
					 END IF
				NEXT I%
				InternalWriteMixer Index%, Volume%
		  END IF
	 CASE 2
		  Volume% = InternalReadMixer%(Index%)
		  LeftChannel% = LeftChannel% \ 4
		  IF LeftChannel% > 7 THEN LeftChannel% = 7
		  RightChannel% = RightChannel% \ 4
		  IF RightChannel% > 7 THEN RightChannel% = 7
		  IF REVERSE.STEREO THEN SWAP LeftChannel%, RightChannel%
		  FOR I% = 0 TO 2
				BIT.STORAGE(I%) = InternalBitRead%(RightChannel%, I%)
				IF RightChannel% > -1 AND RightChannel% < 32 THEN
					 IF BIT.STORAGE(I%) THEN BitVal% = 1 ELSE BitVal% = 0
					 InternalBitSet Volume%, I% + 1, BitVal%
				END IF
				BIT.STORAGE(I%) = InternalBitRead%(LeftChannel%, I%)
				IF LeftChannel% > -1 AND LeftChannel% < 32 THEN
					 IF BIT.STORAGE(I%) THEN BitVal% = 1 ELSE BitVal% = 0
					 InternalBitSet Volume%, I% + 5, BitVal%
				END IF
		  NEXT I%
		  InternalWriteMixer Index%, Volume%
	 CASE 3
		  LVolume% = InternalReadMixer%(Index%)
		  RVolume% = InternalReadMixer%(Index% + 1)
		  IF REVERSE.STEREO THEN SWAP LeftChannel%, RightChannel%
		  FOR I% = 0 TO 4
				BIT.STORAGE(I%) = InternalBitRead%(RightChannel%, I%)
				IF RightChannel% > -1 AND RightChannel% < 32 THEN
					 IF BIT.STORAGE(I%) THEN BitVal% = 1 ELSE BitVal% = 0
					 InternalBitSet RVolume%, I% + 3, BitVal%
				END IF
				BIT.STORAGE(I%) = InternalBitRead%(LeftChannel%, I%)
				IF LeftChannel% > -1 AND LeftChannel% < 32 THEN
					 IF BIT.STORAGE(I%) THEN BitVal% = 1 ELSE BitVal% = 0
					 InternalBitSet LVolume%, I% + 3, BitVal%
				END IF
		  NEXT I%
		  InternalWriteMixer Index%, LVolume%
		  InternalWriteMixer Index% + 1, RVolume%
END SELECT

END SUB

SUB InternalWriteMixer (Index%, Value%)
OUT SB.BASEPORT + 4, Index%
OUT SB.BASEPORT + 5, Value%
END SUB

SUB load
village$ = COMMAND$
DEF SEG = VARSEG(map(0)): BLOAD "villages\" + MID$(village$, 1, 8) + ".map", VARPTR(map(0))
DEF SEG = VARSEG(tileimages(0)): BLOAD "villages\" + MID$(village$, 1, 8) + ".pmp", VARPTR(tileimages(0))
DEF SEG = VARSEG(npc(0)): BLOAD "villages\npc.pmp", VARPTR(npc(0))
DEF SEG = VARSEG(npcloc(0, 0)): BLOAD "villages\" + MID$(village$, 1, 8) + ".npc", VARPTR(npcloc(0, 0))
OPEN "villages\" + MID$(village$, 1, 8) + ".tlk" FOR INPUT AS #1
	FOR TEMP% = 0 TO 9
	LINE INPUT #1, npcquote(TEMP%)
	NEXT
CLOSE
mapx = VAL(MID$(village$, 9, 2))
mapy = VAL(MID$(village$, 11, 2))
END SUB

SUB LoadandPlayMIDI (Filename$, MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
IF FileLen& = 0 THEN MIDI.ERROR = 1: EXIT SUB
Filename$ = Filename$ + CHR$(0)
		  asm1$ = CHR$(&H1E) + CHR$(&H55) + CHR$(&H89) + CHR$(&HE5) + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
		  asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE) + CHR$(&H8B) + CHR$(&H17)
		  asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10) + CHR$(&H8E) + CHR$(&H1F) + CHR$(&HCD) + CHR$(&H21)
		  asm1$ = asm1$ + CHR$(&H89) + CHR$(&HC6) + CHR$(&HB4) + CHR$(&H3F)
		  asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) + CHR$(&H8B) + CHR$(&HF)
		  asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) + CHR$(&H8B) + CHR$(&H17)
		  asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC) + CHR$(&H8E) + CHR$(&H1F) + CHR$(&H89) + CHR$(&HF3)
		  asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21) + CHR$(&HB4) + CHR$(&H3E)
		  asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21) + CHR$(&H5D) + CHR$(&H1F) + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
DEF SEG = VARSEG(asm1$)
CALL ABSOLUTE(VARSEG(Filename$), SADD(Filename$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm1$))
		  asm2$ = CHR$(&H55) + CHR$(&H89) + CHR$(&HE5) + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
		  asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H17) + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
		  asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H7) + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
		  asm2$ = asm2$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT) + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
		  asm2$ = asm2$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT) + CHR$(&H5D) + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
IF SOUND.DISABLED = 0 THEN
	 DEF SEG = VARSEG(asm2$)
	 CALL ABSOLUTE(MIDISegment%, MIDIOffset%, SADD(asm2$))
	 MIDI.PLAYTIME = TIMER
END IF
MIDI.ERROR = 0
END SUB

REM $DYNAMIC
SUB mapsub
DIM d1 AS INTEGER, d2 AS INTEGER

IF keypress = 57 THEN
	IF map(mapx + 64 * mapy - 64) = 29 THEN treasuresub
	IF UCASE$(MID$(village$, 5, 3)) <> "CAV" AND UCASE$(MID$(village$, 6, 2)) <> "CA" THEN
		IF map(mapx + 64 * mapy - 64) = 52 THEN map(mapx + 64 * mapy - 64) = 54
		IF map(mapx + 64 * mapy + 64) = 52 THEN map(mapx + 64 * mapy + 64) = 53
	END IF
END IF

scrx% = 0: scry% = 0
IF kp = 1 THEN
	FOR scrx% = 16 TO 0 STEP -4: drawmap: NEXT
ELSEIF kp = 2 THEN
	FOR scrx% = -16 TO 0 STEP 4: drawmap: NEXT
ELSEIF kp = 3 THEN
	FOR scry% = -16 TO 0 STEP 4: drawmap: NEXT
ELSEIF kp = 4 THEN
	FOR scry% = 16 TO 0 STEP -4: drawmap: NEXT
ELSEIF ot2 <> t2 THEN
	drawmap
END IF
IF start% = 1 THEN VSUnFadeBlack "palettes\rpg": start% = 0

OPEN "villages\" + MID$(COMMAND$, 1, 8) + ".lnk" FOR BINARY AS #1
		GET #1, (mapx + 64 * mapy) * 12& + 8, linkit
CLOSE

IF GameDist% < 2 AND UCASE$(MID$(linkit, 1, 8)) = "ROAMACAV" THEN
	textbox
	TEMP$ = "I'm not going inthere alone.    What are you... CRAZY!?"
	FOR a% = 0 TO 100 STEP 16
		VSFont &HA000, 0, 96, 115 + a% \ 2, MID$(TEMP$, 1 + a%, 16), 32 * chartext% + 31, 32 * chartext% + 16
	NEXT
	linkit = ""
	keypress = 80
	SLEEP
END IF
IF GameDist% = 1 AND UCASE$(MID$(linkit, 1, 12)) = "TANDEN2 1732" THEN
	VSFadeBlack 100
	VSFill &HA000, 0
	ERASE buffer&
	SHELL "cinema 8"
	VSPalette ""
	linkit2 = "done"
	linkit = ""
	mapy = mapy + 1
	keypress = 80
	start% = 1
END IF

IF ASC(MID$(linkit, 9, 1)) > 32 THEN
	FOR a% = 15 TO 0 STEP -1
		SetMidi a%, a%
		FOR B% = 0 TO 6
			VSDelay 1
			VSFadeBlack 1
		NEXT
	NEXT
	OPEN "temp.loc" FOR OUTPUT AS #1
		PRINT #1, linkit
	CLOSE #1
	VSFill &HA000, 0
	StopMidi
	SYSTEM
END IF
IF map(mapx + 64 * mapy) = 52 THEN map(mapx + 64 * mapy) = 53
IF map(mapx + 64 * mapy - 64) = 51 AND charGP% >= 50 THEN
	map(mapx + 64 * mapy - 64) = 35
	sleepsub
END IF
IF keypress = 57 THEN
	FOR TEMP% = 0 TO 9
		IF npcloc(TEMP%, 0) = mapx AND npcloc(TEMP%, 1) = mapy THEN talk TEMP%
	NEXT
END IF
END SUB

REM $STATIC
FUNCTION MIDIError$
SELECT CASE MIDI.ERROR
		  CASE 0: MIDIError$ = "NO ERROR"
		  CASE 1: MIDIError$ = "FILE CONTAINS NO DATA"
		  CASE 2: MIDIError$ = "FILE IS TOO LARGE"
		  CASE 3: MIDIError$ = "NO MIDI FILE PLAYING"
		  CASE 4: MIDIError$ = "INVALID SBMIDI INTERRUPT"
		  CASE 5: MIDIError$ = "INVALID SBSIM INTERRUPT"
		  CASE 6: MIDIError$ = "NO MIXER CHIP"
		  CASE 7: MIDIError$ = "COULD NOT DETECT SOUND CARD"
		  CASE 8: MIDIError$ = "FEATURE UNAVAILABLE"
		  CASE 9: MIDIError$ = "FILE IS CORRUPT"
		  CASE 10: MIDIError$ = "INVALID SOUND CARD TYPE"
		  CASE ELSE: MIDIError$ = "UNKNOWN ERROR"
END SELECT
END FUNCTION

FUNCTION MixerChip$
SELECT CASE MIXER.CHIP
	 CASE 0: MixerChip$ = "No Mixer Chip Detected"
	 CASE 1: MixerChip$ = "CT1335"
	 CASE 2: MixerChip$ = "CT1345"
	 CASE 3: MixerChip$ = "CT1745"
	 CASE ELSE: MixerChip$ = "Unknown"
END SELECT
END FUNCTION

REM $DYNAMIC
SUB npcmove
FOR TEMP% = 0 TO 9
	move% = RND * 3
	IF move% = 0 AND npcloc(TEMP%, 0) <= 62 THEN
		IF map(npcloc(TEMP%, 0) + 1 + 64 * npcloc(TEMP%, 1)) > 30 AND map(npcloc(TEMP%, 0) + 1 + 64 * npcloc(TEMP%, 1)) < 52 THEN
			npcloc(TEMP%, 0) = npcloc(TEMP%, 0) + 1
			npcdir(TEMP%) = 2
		END IF
	END IF
	IF move% = 1 AND npcloc(TEMP%, 0) >= 1 THEN
		IF map(npcloc(TEMP%, 0) - 1 + 64 * npcloc(TEMP%, 1)) > 30 AND map(npcloc(TEMP%, 0) - 1 + 64 * npcloc(TEMP%, 1)) < 52 THEN
			npcloc(TEMP%, 0) = npcloc(TEMP%, 0) - 1
			npcdir(TEMP%) = 1
		END IF
	END IF
	IF move% = 2 AND npcloc(TEMP%, 1) >= 1 THEN
		IF map(npcloc(TEMP%, 0) + 64 * (npcloc(TEMP%, 1) - 1)) > 30 AND map(npcloc(TEMP%, 0) + 64 * (npcloc(TEMP%, 1) - 1)) < 52 THEN
			npcloc(TEMP%, 1) = npcloc(TEMP%, 1) - 1
			npcdir(TEMP%) = 4
		END IF
	END IF
	IF move% = 3 AND npcloc(TEMP%, 1) <= 62 THEN
		IF map(npcloc(TEMP%, 0) + 64 * (npcloc(TEMP%, 1) + 1)) > 30 AND map(npcloc(TEMP%, 0) + 64 * (npcloc(TEMP%, 1) + 1)) < 52 THEN
			npcloc(TEMP%, 1) = npcloc(TEMP%, 1) + 1
			npcdir(TEMP%) = 3
		END IF
	END IF
NEXT
END SUB

REM $STATIC
SUB setcard (cardtype%)
IF cardtype% < 1 OR cardtype% > 8 THEN
	 MIDI.ERROR = 10
	 EXIT SUB
END IF
SB.CARDTYPE = cardtype%
SELECT CASE cardtype%
	 CASE 1
		  MIDI.ERROR = 6
		  IF SENSITIVE THEN
				MIXER.CHIP = 0
				EXIT SUB
		  ELSE
				MIXER.CHIP = 1
		  END IF
	 CASE 3
		  'There are two different kinds of SB 2.0 cards: the regular SB2,
		  'and the SB2CD.  The SB2CD has a mixer chip (the CT1335), whereas
		  'the SB 2.0 does not.  The way to tell them apart is that the
		  'Sound Blaster 2.0 uses Base Ports 220h and 240h, and the SB2CD
		  'uses ports 250h and 260h.
		  '
		  'Assume the sound card is an SB2CD for now...
		  MIXER.CHIP = 1
		  'If the card is defined as an SB 2.0, not an SB 2.0 CD, and
		  'sensitive error checking is on, disable mixer operations.
		  IF (BasePort% = &H220 OR BasePort% = &H240) AND SENSITIVE <> 0 THEN
				MIXER.CHIP = 0
		  END IF
		  MIDI.ERROR = 0
	 CASE 2, 4, 5
		  MIXER.CHIP = 2
		  MIDI.ERROR = 0
	 CASE ELSE
		  MIXER.CHIP = 3
		  MIDI.ERROR = 0
END SELECT
END SUB

SUB SetMidi (LeftChannel%, RightChannel%)
SELECT CASE MIXER.CHIP
	 CASE 0: MIDI.ERROR = 6: EXIT SUB
	 CASE 1
		  LC% = LeftChannel%: RC% = RightChannel%
		  InternalSetVol LC%, RC%, 6
		  MIDI.ERROR = 0
	 CASE 2
		  LC% = LeftChannel%: RC% = RightChannel%
		  InternalSetVol LC%, RC%, &H26
		  MIDI.ERROR = 0
	 CASE 3
		  LC% = LeftChannel%: RC% = RightChannel%
		  InternalSetVol LC%, RC%, &H34
		  MIDI.ERROR = 0
END SELECT
END SUB

REM $DYNAMIC
SUB sleepsub
VSBlendPalettes "palettes\rpg", "palettes\night"
VSDelay 120
OPEN "saves\p1.nfo" FOR INPUT AS #1
	LINE INPUT #1, name$
	LINE INPUT #1, level$
	LINE INPUT #1, HP$
	LINE INPUT #1, HPmax$
	LINE INPUT #1, MP$
	LINE INPUT #1, MPmax$
	LINE INPUT #1, Evade$
	LINE INPUT #1, Speed$
	LINE INPUT #1, Power$
	LINE INPUT #1, MagicPower$
	LINE INPUT #1, Block$
	LINE INPUT #1, Dodge$
	LINE INPUT #1, Exp$
	LINE INPUT #1, gp$
	LINE INPUT #1, bgr$
	LINE INPUT #1, text$
	LINE INPUT #1, shadow$
	LINE INPUT #1, gamedst$
	LINE INPUT #1, Mapxt$
	LINE INPUT #1, Mapyt$
CLOSE
charHP% = VAL(MID$(HPmax$, 11, 4))
charMP% = VAL(MID$(MPmax$, 11, 3))
charGP% = VAL(MID$(gp$, 8, 5)) - 50
OPEN "saves\p1.nfo" FOR OUTPUT AS #1
	PRINT #1, name$
	PRINT #1, level$
	PRINT #1, "  HP =" + STR$(charHP%)
	PRINT #1, HPmax$
	PRINT #1, "  MP =" + STR$(charMP%)
	PRINT #1, MPmax$
	PRINT #1, Evade$
	PRINT #1, Speed$
	PRINT #1, Power$
	PRINT #1, MagicPower$
	PRINT #1, Block$
	PRINT #1, Dodge$
	PRINT #1, Exp$
	PRINT #1, "  GP =" + STR$(charGP%)
	PRINT #1, bgr$
	PRINT #1, text$
	PRINT #1, shadow$
	PRINT #1, gamedst$
	PRINT #1, Mapxt$
	PRINT #1, Mapyt$
CLOSE
VSBlendPalettes "palettes\night", "palettes\rpg"

END SUB

REM $STATIC
FUNCTION SoundCard$ (cardtype%)
SELECT CASE cardtype%
	 CASE 1: SoundCard$ = "Sound Blaster 1.0/1.5"
	 CASE 2: SoundCard$ = "Sound Blaster Pro"
	 CASE 3: SoundCard$ = "Sound Blaster 2.0/2.0CD"
	 CASE 4: SoundCard$ = "Sound Blaster Pro 2"
	 CASE 5: SoundCard$ = "Sound Blaster Pro 2 (Microchannel Version)"
	 CASE 6: SoundCard$ = "Sound Blaster 16/16 ASP/AWE 32"
	 CASE 7, 8: SoundCard$ = "Unknown (Probably SB32/AWE64)"
	 CASE ELSE: SoundCard$ = "Unknown"
END SELECT
END FUNCTION

SUB StopMidi STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
IF asm$ = "" THEN
	 asm$ = CHR$(&HBB) + CHR$(&H4) + CHR$(&H0) + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT) + CHR$(&HCB)
END IF
IF MIDI.PLAYTIME THEN
	 DEF SEG = VARSEG(asm$)
	 CALL ABSOLUTE(SADD(asm$))
	 MIDI.ERROR = 0
ELSE
	 MIDI.ERROR = 3
END IF
MIDI.PLAYTIME = 0
END SUB

REM $DYNAMIC
SUB talk (num%)
textbox
FOR a% = 0 TO 100 STEP 16
		VSFont &HA000, 0, 96, 115 + a% \ 2, MID$(npcquote(num%), 1 + a%, 16), 32 * chartext% + 31, 32 * chartext% + 16
NEXT
SLEEP
END SUB

REM $STATIC
SUB textbox
FOR a% = 0 TO 31
	LINE (94, 2 * a% + 112)-(223, 2 * a% + 113), 31 - a% + 32 * charbg%, B
NEXT
VSBorder &HA000, 0, 91, 109, 226, 178, 31, 21, 11
END SUB

REM $DYNAMIC
SUB timesub
ot2 = t2
IF t < TIMER - 1 THEN
	t = TIMER
	t2 = (t2 + 1) MOD 2
END IF
END SUB

SUB treasuresub
		textbox
		VSFont &HA000, 0, 96, 119, "Treasure chests", 31 + 32 * chartext%, 16 + 32 * chartext%
		VSFont &HA000, 0, 96, 127, "don't have any", 31 + 32 * chartext%, 16 + 32 * chartext%
		VSFont &HA000, 0, 96, 135, "items in them in", 31 + 32 * chartext%, 16 + 32 * chartext%
		VSFont &HA000, 0, 96, 143, "this demo.", 31 + 32 * chartext%, 16 + 32 * chartext%
		SLEEP 5
		map(mapx + 64 * mapy - 64) = 30
END SUB

SUB villagename
IF UCASE$(MID$(village$, 7, 2)) = "CA" THEN
	village2$ = UCASE$(MID$(village$, 1, 1)) + LCASE$(MID$(village$, 2, 5)) + " Cave"
ELSEIF UCASE$(MID$(village$, 6, 3)) = "CAV" THEN
	village2$ = UCASE$(MID$(village$, 1, 1)) + LCASE$(MID$(village$, 2, 4)) + " Cave"
ELSEIF UCASE$(MID$(village$, 6, 3)) = "CAS" THEN
	village2$ = UCASE$(MID$(village$, 1, 1)) + LCASE$(MID$(village$, 2, 4)) + " Castle"
ELSE
	IF MID$(village$, 8, 1) <= " " THEN village2$ = UCASE$(MID$(village$, 1, 1)) + LCASE$(MID$(village$, 2, 7))
END IF
IF UCASE$(MID$(village$, 1, 8)) = "CENTRCAV" THEN village2$ = "Central Cave"
FOR a% = 1 TO 8
	IF VAL(MID$(village$, a%, 1)) > 0 THEN notext% = 1
NEXT
END SUB

