DECLARE SUB fillbg ()
'DECLARE SUB perseas ()
DECLARE SUB pyrobreath ()
DECLARE SUB charbackward ()
DECLARE SUB endmagic ()
'$INCLUDE: 'dash.bi'
DECLARE SUB clrtxt ()
DECLARE SUB dispdamage ()
DECLARE SUB initmagic ()
DECLARE FUNCTION BytesRequired& (Filename$)
DECLARE SUB DetectSettings (BasePort%, IRQ%, LoDMA%, HiDMA%, CardType%)
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE SUB LoadandPlayMIDI (Filename$, MIDISegment%, MIDIOffset%)
DECLARE FUNCTION MIDIError$ ()
DECLARE FUNCTION MixerChip$ ()
DECLARE SUB SetCard (CardType%)
DECLARE SUB SetMidi (LeftChannel%, RightChannel%)
DECLARE FUNCTION SoundCard$ (CardType%)
DECLARE SUB StopMidi ()
DECLARE FUNCTION InternalBitRead% (Variable%, BitNum%)
DECLARE SUB InternalBitSet (Variable%, BitNum%, OnOff%)
DECLARE SUB InternalBitToggle (Variable%, BitNum%)
DECLARE SUB InternalGetIntVector (IntNum%, segment%, offset%)
DECLARE SUB InternalGetVol (LeftChannel%, RightChannel%, Index%)
DECLARE SUB InternalSetVol (LeftChannel%, RightChannel%, Index%)
DECLARE SUB InternalWriteMixer (Index%, Value%)
DECLARE FUNCTION InternalReadMixer% (Index%)
DECLARE SUB charpunch ()
DECLARE SUB charback ()
DECLARE SUB charforward ()
DECLARE SUB enemy1fight ()
DECLARE SUB chardead ()
DECLARE SUB char1fight ()
DECLARE SUB enemydead ()
DECLARE SUB info ()
DECLARE SUB resetscrn ()
DECLARE SUB drawchar ()
DECLARE SUB tsunami ()
DECLARE SUB drawmenuleft ()
DECLARE SUB drawmenuright ()
DECLARE SUB epicenter ()
DECLARE SUB inferno ()
DECLARE SUB menuleft ()
DECLARE SUB menuright ()
DECLARE SUB loadenemy ()
DECLARE SUB ini ()
DIM SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER
DIM SHARED MIDI.LOADED AS INTEGER, SBMIDI.INTERRUPT AS INTEGER
DIM SHARED SBSIM.INTERRUPT AS INTEGER, PAUSED AS SINGLE
DIM SHARED MIXER.CHIP AS INTEGER, SB.BASEPORT AS INTEGER, SB.IRQ AS INTEGER
DIM SHARED SB.LODMA AS INTEGER, SB.HIDMA AS INTEGER, SB.CARDTYPE AS INTEGER
DIM SHARED BIT.STORAGE(0 TO 7) AS INTEGER, SENSITIVE AS INTEGER
DIM SHARED REVERSE.STEREO AS INTEGER, SOUND.DISABLED AS INTEGER

DriversLoaded SBMIDI.INTERRUPT, SBSIM.INTERRUPT
IF SBMIDI.INTERRUPT = 0 THEN SBMIDI.INTERRUPT = &H80
IF SBSIM.INTERRUPT = 0 THEN SBSIM.INTERRUPT = &H81
DetectSettings SB.BASEPORT, SB.IRQ, SB.LODMA, SB.HIDMA, SB.CARDTYPE
IF SB.CARDTYPE = 0 THEN SetCard 2
IF SB.BASEPORT = 0 THEN SB.BASEPORT = &H220
IF SB.IRQ = 0 THEN SB.IRQ = 5
IF SB.LODMA = 0 THEN SB.LODMA = 1
IF SB.HIDMA = 0 AND SB.CARDTYPE = 6 THEN SB.HIDMA = 5
DIM SHARED name$, level$, HP$, HPmax$, MP$, MPmax$, Evade$, Speed$, Power$
DIM SHARED MagicPower$, Block$, Dodge$, exp$, gp$, incexp AS INTEGER
DIM SHARED badname$, Badlevel$, BadHP$, BadMP$, gamedist$
DIM SHARED BadEvade$, BadSpeed$, BadPower$, BadMagicBlock$
DIM SHARED BadMagicPower$, BadBlock$, BadDodge$, Mapx$, Mapy$
DIM SHARED charHP AS INTEGER, charHPmax AS INTEGER, charMP AS INTEGER
DIM SHARED charMPmax AS INTEGER, charEvade AS INTEGER, charLevel AS INTEGER
DIM SHARED charspeed AS INTEGER, charPower AS INTEGER, charMagicPower AS INTEGER
DIM SHARED charBlock AS INTEGER, charDodge AS INTEGER, charExp AS INTEGER
DIM SHARED enemyHP AS INTEGER, enemyMP AS INTEGER, enemyDodge AS INTEGER
DIM SHARED enemyHPmax AS INTEGER, enemyMPmax AS INTEGER, hits%
DIM SHARED enemyEvade AS INTEGER, enemyspeed AS INTEGER, enemyPower AS INTEGER
DIM SHARED enemyMagicPower AS INTEGER, enemyBlock AS INTEGER, chargp AS INTEGER
DIM SHARED bg AS STRING, choicel AS INTEGER, choicer AS INTEGER
DIM SHARED npc(4223) AS LONG, baddy%, file$, Block%, time%
DIM SHARED bgr$, text$, shadow$, charbg%, chartext%, charshadow%
DIM SHARED temppic(8000) AS INTEGER, buffer%(31999)
DIM Music%(19999)
SetMidi 0, 0
LoadandPlayMIDI "music\fight1.MID", VARSEG(Music%(0)), VARPTR(Music%(0))
FOR a% = 0 TO 15
   SetMidi a%, a%
   VSDelay 6
NEXT

SCREEN 13
VSPalette ""
VSClearKB
bg = COMMAND$
fillbg
VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0

VSUnFadeBlack "palettes\rpg"
RANDOMIZE TIMER
baddy% = RND * 6
ini
loadenemy
DEF SEG = VARSEG(npc(0))
BLOAD "villages\npc.pmp", VARPTR(npc(0))
resetscrn
time% = RND * 99

DO
   Block% = 1
   VSDelay 5
   time% = (time% + 1) MOD 1000
   IF time% \ (100 - charspeed) = time% / (100 - charspeed) THEN char1fight
   IF enemyHP <= 0 THEN enemydead
   IF time% \ (100 - enemyspeed) = time% / (100 - enemyspeed) THEN enemy1fight
   IF charHP <= 0 THEN chardead
LOOP

REM $DYNAMIC
SUB char1fight
DO
   a$ = ""
   drawmenuright
   info
   drawmenuleft
   menuleft
   IF choicel = 1 OR choicel = 2 THEN
         drawmenuright
         menuright
      IF choicer = -1 THEN a$ = "E"
   END IF
   resetscrn
   IF choicel = 0 THEN
      charpunch
   ELSEIF choicel = 1 THEN
      a$ = "E"
   ELSEIF choicel = 2 THEN
      IF choicer = 0 AND charMP > 5 THEN
         pyrobreath
      'ELSEIF choicer = 1 AND charMP > 5 THEN
      '   perseas
      ELSEIF choicer = 1 AND charMP > 3 THEN
         inferno
      ELSEIF choicer = 2 AND charMP > 2 THEN
         tsunami
      ELSEIF choicer = 3 AND charMP > 2 THEN
         epicenter
      ELSE
         a$ = "E"
      END IF
   ELSEIF choicel = 3 THEN
      Block% = 2
      resetscrn
   ELSEIF choicel = 4 THEN
      a% = RND * 100
      IF a% > 100 - charEvade THEN
         VSFont &HA000, 0, 127, 0, "You ran.", 191, 182
         SLEEP 1
         FOR a% = 15 TO 0 STEP -1
            SetMidi a%, a%
            FOR B% = 0 TO 6
               VSDelay 1
               VSFadeBlack 1
            NEXT
         NEXT
         VSFill &HA000, 0
         StopMidi
         SYSTEM
      ELSE
         VSFont &HA000, 0, 103, 0, "Unable to run.", 191, 182
         SLEEP 1
         clrtxt
         resetscrn
      END IF
   END IF
LOOP UNTIL a$ <> "E"
END SUB

SUB charbackward
FOR x% = 224 TO 284 STEP 8
   fillbg
   VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
   VSSpriteS VARSEG(npc(0)), VARPTR(npc(66)), x%, 172, 100, 100, VARSEG(buffer%(0)), VARPTR(buffer%(0))
   WAIT &H3DA, 8
   VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
NEXT
END SUB

SUB chardead
      VSBlendPalettes "palettes\rpg", "palettes\fire"
      VSFont &HA000, 0, 112, 0, "Annihilated.", 63, 48
      SLEEP
         FOR a% = 15 TO 0 STEP -1
            SetMidi a%, a%
            FOR B% = 0 TO 6
               VSDelay 1
               VSFadeBlack 1
            NEXT
         NEXT
         VSFill &HA000, 0
         StopMidi
      OPEN "temp.loc" FOR OUTPUT AS #1
         PRINT #1, "Quit"
      CLOSE
      SYSTEM
END SUB

SUB charforward
FOR x% = 284 TO 184 STEP -10
   fillbg
   VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
   VSSpriteS VARSEG(npc(0)), VARPTR(npc(66)), x%, 147 + ABS(234 - x%) \ 2, 100, 100, VARSEG(buffer%(0)), VARPTR(buffer%(0))
   WAIT &H3DA, 8
   VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
NEXT
END SUB

SUB charpunch
charforward
hits% = ((charPower - 10) * 6 + RND * charPower) * 6 \ enemyPower

fillbg

VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 72 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
VSSpriteS VARSEG(npc(0)), VARPTR(npc(66)), 184, 172, 100, 100, VARSEG(buffer%(0)), VARPTR(buffer%(0))
VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
VSFont &HA000, 0, 64, 112, STR$(hits%), 63, 53

SLEEP 2
charbackward
enemyHP = enemyHP - hits%
END SUB

REM $STATIC
SUB clrtxt
LINE (0, 0)-(319, 7), 0, BF
END SUB

SUB DetectSettings (BasePort%, IRQ%, LoDMA%, HiDMA%, CardType%)

BasePort% = 0
IRQ% = 0
LoDMA% = 0
HiDMA% = 0
CardType% = 0

Settings$ = ENVIRON$("BLASTER")

FOR I% = 1 TO LEN(Settings$) - 1
    SELECT CASE UCASE$(MID$(Settings$, I%, 1))
        CASE "T"
            CardType% = VAL(MID$(Settings$, I% + 1, 1))
        CASE "A"
            BasePort% = VAL("&H" + LTRIM$(STR$(VAL(MID$(Settings$, I% + 1, 3)))))
        CASE "I"
            IRQ% = VAL(MID$(Settings$, I% + 1, 2))
        CASE "D"
            LoDMA% = VAL(MID$(Settings$, I% + 1, 1))
        CASE "H"
            HiDMA% = VAL(MID$(Settings$, I% + 1, 1))
    END SELECT
NEXT I%

IF CardType% = 0 THEN
    SELECT CASE LoDMA%
        'If the DMA is 210h or 230h, the card is an SB1.0/1.5.
        CASE &H210, &H230
            CardType% = 1
        'If the DMA is 250h or 260h, the card is either an SB2CD or a
        'Sound Blaster 16.  It could also be a Sound Blaster 1.0/1.5,
        'but it probably isn't.  Actually, it's also unlikely that the card
        'is an SB16, but I check for it anyway, because there's an easy way
        'to tell if it is - the High DMA channel will be greater than 0.
        '
        'On the other hand, there's no way that I know of to
        'distinguish an SB 1.0 from an SB 2.0, except by looking at the
        'BLASTER environment variable.  And since this code is executing
        'that method obviously failed.
        CASE &H250, &H260
            'Examining the High DMA channel will narrow it down.
            'If the High DMA is greater than 0, the card is an SB16.
            IF HiDMA% THEN
                CardType% = 6
            'Otherwise, define the card as a Sound Blaster 2.0.
            ELSE
                CardType% = 3
            END IF
        'If the DMA channel is any other value....
        CASE ELSE
            'Check the High DMA channel.  If it's a non-zero value,
            'we've got an SB16.
            IF HiDMA% THEN
                CardType% = 6
            'Otherwise....
            ELSE
                'If sensitive error checking is on, define the card as
                'a Sound Blaster 1.0/1.5.
                IF SENSITIVE THEN
                    CardType% = 1
                'Otherwise, assume it's a Sound Blaster Pro.
                ELSE
                    CardType% = 4
                END IF
            END IF
    END SELECT
END IF

'Determine the sound card's mixer chip
SELECT CASE CardType%
    'If the card could not be detected....
    CASE 0
        MIDI.ERROR = 7
        'If sensitive error checking is on, disable mixer operations
        IF SENSITIVE THEN
            MIXER.CHIP = 0
        'Otherwise, assume the default mixer chip.
        ELSE
            MIXER.CHIP = 2
        END IF
    'If the card is a Sound Blaster 1.0/1.5 or equivalent....
    CASE 1
        'Return an error.
        MIDI.ERROR = 6
        'If sensitive error checking is on, disable mixer operations and
        'exit.
        IF SENSITIVE THEN
            MIXER.CHIP = 0
            EXIT SUB
        'Otherwise, set the earliest mixer chip and continue.
        ELSE
            MIXER.CHIP = 1
        END IF
    'If the card is a Sound Blaster 2.0/2.5 or equivalent....
    CASE 3
        'There are two different kinds of SB 2.0 cards: the regular SB2,
        'and the SB2CD.  The SB2CD has a mixer chip (the CT1335), whereas
        'the SB 2.0 does not.  The way to tell them apart is that the
        'Sound Blaster 2.0 uses Base Ports 220h and 240h, and the SB2CD
        'uses ports 250h and 260h.
        '
        'Assume the sound card is an SB2CD for now...
        MIXER.CHIP = 1
        'If the card is defined as an SB 2.0, not an SB 2.0 CD, and
        'sensitive error checking is on, disable mixer operations.
        IF (BasePort% = &H220 OR BasePort% = &H240) AND SENSITIVE <> 0 THEN
            MIXER.CHIP = 0
        END IF
        MIDI.ERROR = 0
    'If the card is a Sound Blaster Pro, assume chip CT1345
    CASE 2, 4, 5
        MIXER.CHIP = 2
        MIDI.ERROR = 0
    'If the card is a Sound Blaster 16 or later, assume chip CT1745
    CASE IS >= 6
        MIXER.CHIP = 3
        MIDI.ERROR = 0
END SELECT
END SUB

SUB dispdamage
VSFont &HA000, 0, 64, 112, STR$(hits%), 63, 53
SLEEP 1
enemyHP = enemyHP - hits%
END SUB

SUB drawmenuleft
FOR a% = 0 TO 31
   VSXLine &HA000, 0, 10, 99, 2 * a% + 130, 31 - a% + 32 * charbg%
   VSXLine &HA000, 0, 10, 99, 2 * a% + 131, 31 - a% + 32 * charbg%
NEXT
VSBorder &HA000, 0, 7, 127, 102, 196, 31, 21, 11
END SUB

SUB drawmenuright
FOR a% = 0 TO 31
   VSXLine &HA000, 0, 110, 309, 2 * a% + 130, 31 - a% + 32 * charbg%
   VSXLine &HA000, 0, 110, 309, 2 * a% + 131, 31 - a% + 32 * charbg%
NEXT
VSBorder &HA000, 0, 107, 127, 311, 196, 31, 21, 11
END SUB

REM $DYNAMIC
SUB DriversLoaded (SBMIDI%, SBSIM%) STATIC
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
FileSize& = LOF(FF%)
IF FileSize& = 0 THEN
    CLOSE FF%
    KILL "DRIVERS.DAT"
    MIDI.ERROR = 1
    EXIT SUB
ELSEIF FileSize& <> 1024 THEN
    CLOSE FF%
    MIDI.ERROR = 9
    EXIT SUB
END IF
REDIM DRIVERDATA$(1 TO 5)
FOR I% = 1 TO 4
    DRIVERDATA$(I%) = INPUT$(256, #FF%)
NEXT I%
CLOSE #FF%

SBMIDI% = 0
SBSIM% = 0
FOR I% = &H80 TO &HE1
    InternalGetIntVector I%, segment%, offset%
    'If the address is null, then the interrupt is not in use, and can be
    'skipped.
    IF segment% = 0 AND offset% = 0 THEN GOTO Skip:
    'The following code checks for the drivers by looking for the text
    '"SBMIDI" and "SBSIM" at certain locations in the driver code.  It
    'sounds simplistic, but it's very accurate.  If it doesn't work,
    'a different method is used.
    IF SBMIDI% = 0 THEN
        NewSegment% = CVI(MKI$(CVL(MKI$(segment%) + CHR$(0) + CHR$(0)) - &H11&))
        DEF SEG = NewSegment%
        TEMP$ = ""
        FOR J% = 1 TO 6
            TEMP$ = TEMP$ + CHR$(PEEK(271 + J%))
        NEXT
        IF TEMP$ = "SBMIDI" THEN SBMIDI% = I%
    END IF
    IF SBSIM% = 0 THEN
        NewSegment% = CVI(MKI$(CVL(MKI$(segment%) + CHR$(0) + CHR$(0)) - &H1&))
        DEF SEG = NewSegment%
        TEMP$ = ""
        FOR J% = 1 TO 5
            TEMP$ = TEMP$ + CHR$(PEEK(274 + J%))
        NEXT
        IF TEMP$ = "SBSIM" THEN SBSIM% = I%
    END IF
  
    'This is the second detection method.  It's more complex than the first
    'method, but not really any more accurate.  In fact, it's probably
    'less accurate.  It's kind of a last ditch effort in case the first
    'method fails.

    'Point to the segment of the interrupt handler.
    DEF SEG = segment%
    'Read 256 bytes of the driver code.
    DRIVERDATA$(5) = ""
    FOR J% = 0 TO 255
        Byte% = PEEK(offset% + J%)
        DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(Byte%)
    NEXT J%
    'Check to see if the code matches any of the previously saved data.
    FOR J% = 1 TO 4
        MATCH% = 1
        FOR K% = 0 TO 255
            IF MID$(DRIVERDATA$(J%), K% + 1, 1) <> MID$(DRIVERDATA$(5), K% + 1, 1) THEN
                SELECT CASE K%
                    CASE IS = 14, 15, 113, 114, 235, 236
                    CASE ELSE
                        MATCH% = 0
                        EXIT FOR
                END SELECT
            END IF
        NEXT K%
        IF MATCH% THEN
            IF J% = 1 THEN SBSIM% = I%
            IF J% <> 1 THEN SBMIDI% = I%
        END IF
        IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
    NEXT J%
    IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
Skip:
NEXT I%
MIDI.ERROR = 0
END SUB

REM $STATIC
SUB endmagic
FOR x% = 248 TO 284 STEP 4
   fillbg

   VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
   VSSpriteS VARSEG(npc(0)), VARPTR(npc(66 + 66 * (x% MOD 8))), x%, 172, 100, 100, VARSEG(buffer%(0)), VARPTR(buffer%(0))
   WAIT &H3DA, 8
   VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
NEXT
END SUB

SUB enemy1fight
   hits% = (enemyPower * 20 + RND * enemyPower) \ charPower \ Block%
   FOR x% = 80 - temppic(0) \ 16 TO 120 - temppic(0) \ 16 STEP 4
      fillbg
      VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), x%, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
      VSSpriteS VARSEG(npc(0)), VARPTR(npc(66)), 284, 172, 100, 100, VARSEG(buffer%(0)), VARPTR(buffer%(0))
      VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
   NEXT
   fillbg
  
   VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), x%, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
   VSSpriteS VARSEG(npc(0)), VARPTR(npc(66)), 292, 172, 100, 100, VARSEG(buffer%(0)), VARPTR(buffer%(0))
   VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
   VSFont &HA000, 0, 288, 160, STR$(hits%), 63, 53
   SLEEP 2
   FOR x% = 120 - temppic(0) \ 16 TO 80 - temppic(0) \ 16 STEP -4
      fillbg
     
      VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), x%, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
      VSSpriteS VARSEG(npc(0)), VARPTR(npc(66)), 284, 172, 100, 100, VARSEG(buffer%(0)), VARPTR(buffer%(0))
      VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
   NEXT
   charHP = charHP - hits%
END SUB

SUB enemydead
      FOR x% = 64 TO 0 STEP -2
         fillbg
        
         VSSpriteS VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - (temppic(0) \ 16) * x% \ 64, 200 - (temppic(1)) * x% \ 64, x%, x%, VARSEG(buffer%(0)), VARPTR(buffer%(0))
         VSSpriteS VARSEG(npc(0)), VARPTR(npc(66)), 284, 172, 100, 100, VARSEG(buffer%(0)), VARPTR(buffer%(0))
         VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
         WAIT &H3DA, 8
      NEXT
      VSFont &HA000, 0, 83, 0, "Enemy was defeated.", 63, 48
      SLEEP 2
      clrtxt
      incexp = (enemyHPmax + enemyMPmax + enemyPower + enemyspeed + enemyMagicPower) \ 5
      TEMP$ = "Gained" + STR$(incexp) + " exp."
      VSFont &HA000, 0, 103, 0, TEMP$, 63, 48
      charexp2% = charExp + incexp
      tempchar% = 10 * charLevel ^ 2
      IF charexp2% \ tempchar% > charExp \ tempchar% AND charLevel < 99 THEN
         SLEEP 2
         clrtxt
         VSFont &HA000, 0, 123, 0, "Level up!", 63, 48
         charLevel = charLevel + 1
         charHPmax = charHPmax * 11 \ 10: IF charHPmax >= 10000 THEN charHPmax = 9999
         charMPmax = charMPmax * 12 \ 11: IF charMPmax >= 1000 THEN charMPmax = 999
         charEvade = charEvade + CINT(RND * 1): IF charEvade >= 100 THEN charEvade = 99
         charspeed = charspeed + CINT(RND * 1): IF charspeed >= 100 THEN charspeed = 99
         charPower = charPower + CINT(RND * 2): IF charPower >= 256 THEN charPower = 255
         charMagicPower = charMagicPower + CINT(RND * 1): IF charMagicPower >= 256 THEN charMagicPower = 255
         charBlock = charBlock + CINT(RND * 1): IF charBlock > 50 THEN charBlock = 50
         charDodge = charDodge + CINT(RND * 1): IF charDodge > 50 THEN charDodge = 50
      END IF
      charExp = charexp2%
      SLEEP 2
      clrtxt
      TEMP$ = "Found" + STR$(enemyHPmax) + " GP."
      VSFont &HA000, 0, 103, 0, TEMP$, 63, 48
      chargp = chargp + enemyHPmax
      SLEEP 2
      VSFadeBlack 100

OPEN "saves\p1.nfo" FOR OUTPUT AS #1
   PRINT #1, name$
   PRINT #1, "  Level =" + STR$(charLevel)
   PRINT #1, "  HP =" + STR$(charHP)
   PRINT #1, "  HPmax =" + STR$(charHPmax)
   PRINT #1, "  MP =" + STR$(charMP)
   PRINT #1, "  MPmax =" + STR$(charMPmax)
   PRINT #1, "  Evade =" + STR$(charEvade)
   PRINT #1, "  Speed =" + STR$(charspeed)
   PRINT #1, "  Power =" + STR$(charPower)
   PRINT #1, "  MagicPower =" + STR$(charMagicPower)
   PRINT #1, "  Block =" + STR$(charBlock)
   PRINT #1, "  Dodge =" + STR$(charDodge)
   PRINT #1, "  Exp =" + STR$(charExp)
   PRINT #1, "  GP =" + STR$(chargp)
   PRINT #1, bgr$
   PRINT #1, text$
   PRINT #1, shadow$
   PRINT #1, gamedist$
   PRINT #1, Mapx$
   PRINT #1, Mapy$
CLOSE
         FOR a% = 15 TO 0 STEP -1
            SetMidi a%, a%
            FOR B% = 0 TO 6
               VSDelay 1
               VSFadeBlack 1
            NEXT
         NEXT
         VSFill &HA000, 0
         StopMidi
      OPEN "temp.loc" FOR OUTPUT AS #1
         PRINT #1, "Win"
      CLOSE
      SYSTEM
END SUB

SUB epicenter
         initmagic
   FOR a% = 0 TO 23
         VSPCopy &HA000, 0, VARSEG(buffer%(0)), VARPTR(buffer%(0))
         VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 321
         VSPCopy &HA000, 321, VARSEG(buffer%(0)), VARPTR(buffer%(0))
         VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
         VSPCopy &HA000, 0, VARSEG(buffer%(0)), VARPTR(buffer%(0))
         VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 319
         VSPCopy &HA000, 319, VARSEG(buffer%(0)), VARPTR(buffer%(0))
         VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
   NEXT
      fillbg
        
         VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
         VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
         charMP = charMP - 3
         hits% = (charPower + 6 * (charMagicPower - 5) + RND * (charPower + charMagicPower)) * 6 \ (enemyPower + enemyPower)
         endmagic
         dispdamage
END SUB

SUB fillbg
   VSFill VARSEG(buffer%(0)), VARPTR(buffer%(0))
   DEF SEG = VARSEG(buffer%(0))
   BLOAD COMMAND$ + ".bg", VARPTR(buffer%(1278))
END SUB

SUB inferno
DIM wavesl(318) AS LONG, wavesr(2) AS LONG
         initmagic
         VSBlendPalettes "palettes\rpg", "palettes\fire"
         charMP = charMP - 4
DIM a AS INTEGER, B AS INTEGER, c AS INTEGER
   FOR a = 1 TO 200 STEP 2
      FOR B = 1 TO 200 STEP 20
         c = (a + B) MOD 197
         GET (0, c)-(317, c + 3), wavesl
         GET (318, c)-(319, c + 3), wavesr
         PUT (0, c), wavesr, PSET
         PUT (2, c), wavesl, PSET
      
         c = (a + B + 10) MOD 197
         GET (2, c)-(319, c + 3), wavesl
         GET (0, c)-(1, c + 3), wavesr
         PUT (318, c), wavesr, PSET
         PUT (0, c), wavesl, PSET
         WAIT &H3DA, 8
      NEXT B
   NEXT a
      fillbg
        
         VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
         VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
         VSBlendPalettes "palettes\fire", "palettes\rpg"
         hits% = (charPower + 6 * (charMagicPower - 5) + RND * (charPower + charMagicPower) * 6 \ 5) * 6 \ (enemyPower + enemyPower)
         endmagic
         dispdamage
END SUB

SUB info
TEMP$ = "HP:" + STR$(charHP) + " /" + STR$(charHPmax)
VSShadowFont 200, 130, TEMP$, chartext% * 32 + 31, chartext% * 32 + 16, charshadow% * 32 + 15, charshadow% * 32
TEMP$ = "MP: " + STR$(charMP) + " /" + STR$(charMPmax)
VSShadowFont 200, 140, TEMP$, chartext% * 32 + 31, chartext% * 32 + 16, charshadow% * 32 + 15, charshadow% * 32
END SUB

SUB ini
OPEN "saves\p1.nfo" FOR INPUT AS #1
   LINE INPUT #1, name$
   LINE INPUT #1, level$
   LINE INPUT #1, HP$
   LINE INPUT #1, HPmax$
   LINE INPUT #1, MP$
   LINE INPUT #1, MPmax$
   LINE INPUT #1, Evade$
   LINE INPUT #1, Speed$
   LINE INPUT #1, Power$
   LINE INPUT #1, MagicPower$
   LINE INPUT #1, Block$
   LINE INPUT #1, Dodge$
   LINE INPUT #1, exp$
   LINE INPUT #1, gp$
   LINE INPUT #1, bgr$
   LINE INPUT #1, text$
   LINE INPUT #1, shadow$
   LINE INPUT #1, gamedist$
   LINE INPUT #1, Mapx$
   LINE INPUT #1, Mapy$
CLOSE
OPEN "fight\baddy.nfo" FOR INPUT AS #1
   FOR TEMP% = 0 TO baddy% * 12
      LINE INPUT #1, badname$
   NEXT
   LINE INPUT #1, Badlevel$
   LINE INPUT #1, BadHP$
   LINE INPUT #1, BadMP$
   LINE INPUT #1, BadEvade$
   LINE INPUT #1, BadSpeed$
   LINE INPUT #1, BadPower$
   LINE INPUT #1, BadMagicPower$
   LINE INPUT #1, BadBlock$
   LINE INPUT #1, BadMagicBlock$
   LINE INPUT #1, BadDodge$
CLOSE

enemyHP = VAL(MID$(BadHP$, 8, 4)): charHP = VAL(MID$(HP$, 8, 4))
charHPmax = VAL(MID$(HPmax$, 11, 4))

enemyMP = VAL(MID$(BadMP$, 8, 3)): charMP = VAL(MID$(MP$, 8, 3))
charMPmax = VAL(MID$(MPmax$, 11, 3))

enemyHPmax = VAL(MID$(BadHP$, 8, 4)): enemyMPmax = VAL(MID$(BadMP$, 8, 3))

enemyEvade = VAL(MID$(BadEvade$, 11, 2)): charEvade = VAL(MID$(Evade$, 11, 2))
enemyspeed = VAL(MID$(BadSpeed$, 11, 2)): charspeed = VAL(MID$(Speed$, 11, 2))
enemyPower = VAL(MID$(BadPower$, 11, 2)): charPower = VAL(MID$(Power$, 11, 2))
enemyMagicPower = VAL(MID$(BadMagicPower$, 16, 2)): charMagicPower = VAL(MID$(MagicPower$, 16, 2))
enemyBlock = VAL(MID$(BadBlock$, 11, 2)): charBlock = VAL(MID$(Block$, 11, 2))
enemyDodge = VAL(MID$(BadDodge$, 11, 2)): charDodge = VAL(MID$(Dodge$, 11, 2))

charLevel = VAL(MID$(level$, 11, 5))
charExp = VAL(MID$(exp$, 9, 5))
chargp = VAL(MID$(gp$, 8, 5))

charbg% = VAL(MID$(bgr$, 8, 1))
chartext% = VAL(MID$(text$, 10, 1))
charshadow% = VAL(MID$(shadow$, 12, 1))
END SUB

SUB initmagic
IF choicer = 0 THEN VSFont &HA000, 0, 118, 0, "PyroBreath", 63, 48
'IF choicer = 1 THEN VSFont &HA000, 0, 131, 0, "Perseas", 63, 48
IF choicer = 1 THEN VSFont &HA000, 0, 131, 0, "Inferno", 63, 48
IF choicer = 2 THEN VSFont &HA000, 0, 131, 0, "Tsunami", 191, 176
IF choicer = 3 THEN VSFont &HA000, 0, 123, 0, "Epicenter", 95, 80
SLEEP 1
FOR x% = 284 TO 248 STEP -4
   fillbg
  
   VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
   VSSpriteS VARSEG(npc(0)), VARPTR(npc(66 + 66 * (x% MOD 8))), x%, 172, 100, 100, VARSEG(buffer%(0)), VARPTR(buffer%(0))
   WAIT &H3DA, 8
   VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
NEXT
SLEEP 1
fillbg

VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
END SUB

FUNCTION InternalBitRead% (Variable%, BitNum%)
DEF SEG = VARSEG(Variable%)
InternalBitRead% = -((PEEK(VARPTR(Variable%) + BitNum% \ 8) AND 2 ^ (BitNum% MOD 8)) > 0)
END FUNCTION

SUB InternalBitSet (Variable%, BitNum%, OnOff%)
offset% = VARPTR(Variable%)
DEF SEG = VARSEG(Variable%)
IF OnOff% THEN
    POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) OR 2 ^ (BitNum% MOD 8)
ELSE
    POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) AND 255 - 2 ^ (BitNum% MOD 8)
END IF
END SUB

SUB InternalBitToggle (Variable%, BitNum%)
offset% = VARPTR(Variable%)
DEF SEG = VARSEG(Variable%)
POKE offset% + BitNum% \ 8, PEEK(offset% + BitNum% \ 8) XOR 2 ^ (BitNum% MOD 8)
END SUB

SUB InternalGetIntVector (IntNum%, segment%, offset%) STATIC
'If the code hasn't been loaded already, do it now.
IF GetIntVCodeLoaded% = 0 THEN
    asm$ = CHR$(&H55) + CHR$(&H89) + CHR$(&HE5) + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
    asm$ = asm$ + CHR$(&H8A) + CHR$(&H7) + CHR$(&HB4) + CHR$(&H35)
    asm$ = asm$ + CHR$(&HCD) + CHR$(&H21) + CHR$(&H8C) + CHR$(&HC1) + CHR$(&H89) + CHR$(&HDA)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) + CHR$(&H89) + CHR$(&HF)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
    asm$ = asm$ + CHR$(&H89) + CHR$(&H17) + CHR$(&H5D) + CHR$(&HCB)
    asm$ = asm$ + CHR$(&H34) + CHR$(&H0) + CHR$(&H60) + CHR$(&H23) + CHR$(&H0)
    GetIntVCodeLoaded% = 1
END IF
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(IntNum%, segment%, offset%, SADD(asm$))
END SUB

FUNCTION InternalReadMixer% (Index%)
OUT SB.BASEPORT + 4, Index%
InternalReadMixer% = INP(SB.BASEPORT + 5)
END FUNCTION

SUB InternalSetVol (LeftChannel%, RightChannel%, Index%)
SELECT CASE MIXER.CHIP
    CASE 0: EXIT SUB
    CASE 1
        IF LeftChannel% > -1 AND LeftChannel% < 32 THEN
            LeftChannel% = LeftChannel% \ 4
            IF LeftChannel% > 7 THEN LeftChannel% = 7
            Volume% = InternalReadMixer%(2)
            FOR I% = 0 TO 2
                BIT.STORAGE(I%) = InternalBitRead%(LeftChannel%, I%)
                IF BIT.STORAGE(I%) THEN
                    InternalBitSet Volume%, I% + 1, 1
                END IF
            NEXT I%
            InternalWriteMixer Index%, Volume%
        END IF
    CASE 2
        Volume% = InternalReadMixer%(Index%)
        LeftChannel% = LeftChannel% \ 4
        IF LeftChannel% > 7 THEN LeftChannel% = 7
        RightChannel% = RightChannel% \ 4
        IF RightChannel% > 7 THEN RightChannel% = 7
        IF REVERSE.STEREO THEN SWAP LeftChannel%, RightChannel%
        FOR I% = 0 TO 2
            BIT.STORAGE(I%) = InternalBitRead%(RightChannel%, I%)
            IF RightChannel% > -1 AND RightChannel% < 32 THEN
                IF BIT.STORAGE(I%) THEN BitVal% = 1 ELSE BitVal% = 0
                InternalBitSet Volume%, I% + 1, BitVal%
            END IF
            BIT.STORAGE(I%) = InternalBitRead%(LeftChannel%, I%)
            IF LeftChannel% > -1 AND LeftChannel% < 32 THEN
                IF BIT.STORAGE(I%) THEN BitVal% = 1 ELSE BitVal% = 0
                InternalBitSet Volume%, I% + 5, BitVal%
            END IF
        NEXT I%
        InternalWriteMixer Index%, Volume%
    CASE 3
        LVolume% = InternalReadMixer%(Index%)
        RVolume% = InternalReadMixer%(Index% + 1)
        IF REVERSE.STEREO THEN SWAP LeftChannel%, RightChannel%
        FOR I% = 0 TO 4
            BIT.STORAGE(I%) = InternalBitRead%(RightChannel%, I%)
            IF RightChannel% > -1 AND RightChannel% < 32 THEN
                IF BIT.STORAGE(I%) THEN BitVal% = 1 ELSE BitVal% = 0
                InternalBitSet RVolume%, I% + 3, BitVal%
            END IF
            BIT.STORAGE(I%) = InternalBitRead%(LeftChannel%, I%)
            IF LeftChannel% > -1 AND LeftChannel% < 32 THEN
                IF BIT.STORAGE(I%) THEN BitVal% = 1 ELSE BitVal% = 0
                InternalBitSet LVolume%, I% + 3, BitVal%
            END IF
        NEXT I%
        InternalWriteMixer Index%, LVolume%
        InternalWriteMixer Index% + 1, RVolume%
END SELECT

END SUB

SUB InternalWriteMixer (Index%, Value%)
OUT SB.BASEPORT + 4, Index%
OUT SB.BASEPORT + 5, Value%
END SUB

SUB LoadandPlayMIDI (Filename$, MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
FF% = FREEFILE
OPEN Filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
IF FileLen& = 0 THEN KILL Filename$: MIDI.ERROR = 1: EXIT SUB
IF FileLen& > 65536 THEN MIDI.ERROR = 2: EXIT SUB
Filename$ = Filename$ + CHR$(0)
IF asm1$ = "" THEN
        asm1$ = CHR$(&H1E) + CHR$(&H55) + CHR$(&H89) + CHR$(&HE5)
        asm1$ = asm1$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE) + CHR$(&H8B) + CHR$(&H17)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
        asm1$ = asm1$ + CHR$(&H8E) + CHR$(&H1F) + CHR$(&HCD) + CHR$(&H21)
        asm1$ = asm1$ + CHR$(&H89) + CHR$(&HC6) + CHR$(&HB4) + CHR$(&H3F)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8) + CHR$(&H8B) + CHR$(&HF)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA) + CHR$(&H8B) + CHR$(&H17)
        asm1$ = asm1$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
        asm1$ = asm1$ + CHR$(&H8E) + CHR$(&H1F) + CHR$(&H89) + CHR$(&HF3)
        asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21) + CHR$(&HB4) + CHR$(&H3E)
        asm1$ = asm1$ + CHR$(&HCD) + CHR$(&H21) + CHR$(&H5D) + CHR$(&H1F)
        asm1$ = asm1$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
END IF
DEF SEG = VARSEG(asm1$)
CALL ABSOLUTE(VARSEG(Filename$), SADD(Filename$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm1$))
IF asm2$ = "" THEN
        asm2$ = CHR$(&H55) + CHR$(&H89) + CHR$(&HE5) + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H17) + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
        asm2$ = asm2$ + CHR$(&H8B) + CHR$(&H7) + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
        asm2$ = asm2$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT) + CHR$(&HBB)
        asm2$ = asm2$ + CHR$(&H5) + CHR$(&H0) + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
        asm2$ = asm2$ + CHR$(&H5D) + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
END IF
IF SOUND.DISABLED = 0 THEN
    DEF SEG = VARSEG(asm2$)
    CALL ABSOLUTE(MIDISegment%, MIDIOffset%, SADD(asm2$))
    MIDI.PLAYTIME = TIMER
END IF
MIDI.ERROR = 0
END SUB

SUB loadenemy
   DEF SEG = VARSEG(temppic(0))
   BLOAD "fight\" + MID$(badname$, 1, 8) + ".pic", VARPTR(temppic(0))
   FOR x% = -temppic(0) \ 8 TO 80 - temppic(0) \ 16 STEP 4
      fillbg
     
      VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), x%, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
      VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
   NEXT
END SUB

SUB menuleft
VSFont &HA000, 0, 36, 136, "FIGHT", charshadow% * 32 + 15, charshadow% * 32
VSFont &HA000, 0, 40, 148, "ITEM", charshadow% * 32 + 15, charshadow% * 32
VSFont &HA000, 0, 36, 160, "MAGIC", charshadow% * 32 + 15, charshadow% * 32
VSFont &HA000, 0, 36, 172, "BLOCK", charshadow% * 32 + 15, charshadow% * 32
VSFont &HA000, 0, 44, 184, "RUN", charshadow% * 32 + 15, charshadow% * 32
choicel = 0
ochoicel = -1
VSClearKB
DO UNTIL a$ = CHR$(13)

   IF ochoicel <> choicel THEN
      VSFont &HA000, 0, 35, 135, "FIGHT", chartext% * 32 + 31, chartext% * 32 + 16
      VSFont &HA000, 0, 39, 147, "ITEM", chartext% * 32 + 31, chartext% * 32 + 16
      VSFont &HA000, 0, 35, 159, "MAGIC", chartext% * 32 + 31, chartext% * 32 + 16
      VSFont &HA000, 0, 35, 171, "BLOCK", chartext% * 32 + 31, chartext% * 32 + 16
      VSFont &HA000, 0, 43, 183, "RUN", chartext% * 32 + 31, chartext% * 32 + 16
   END IF
   IF choicel = 0 THEN VSFont &HA000, 0, 35, 135, "FIGHT", 63, 48
   IF choicel = 1 THEN VSFont &HA000, 0, 39, 147, "ITEM", 63, 48
   IF choicel = 2 THEN VSFont &HA000, 0, 35, 159, "MAGIC", 63, 48
   IF choicel = 3 THEN VSFont &HA000, 0, 35, 171, "BLOCK", 63, 48
   IF choicel = 4 THEN VSFont &HA000, 0, 43, 183, "RUN", 63, 48
   ochoicel = choicel
   a$ = INKEY$
   IF a$ = CHR$(0) + "H" THEN choicel = (choicel + 4) MOD 5
   IF a$ = CHR$(0) + "P" THEN choicel = (choicel + 1) MOD 5
LOOP
END SUB

SUB menuright
IF choicel = 2 THEN
   choicer = 0
   ochoicer = -1
DO UNTIL a$ = CHR$(13)
   IF ochoicer <> choicer THEN
      IF charMP > 5 THEN
         VSFont &HA000, 0, 113, 135, "PyroBreath 6", chartext% * 32 + 31, chartext% * 32 + 16
         VSFont &HA000, 0, 113, 145, "Perseas 6", charshadow% * 32 + 15, charshadow% * 32
      END IF
      IF charMP > 3 THEN VSFont &HA000, 0, 113, 155, "Inferno 4", chartext% * 32 + 31, chartext% * 32 + 16
      IF charMP > 2 THEN
         VSFont &HA000, 0, 113, 165, "Tsunami 3", chartext% * 32 + 31, chartext% * 32 + 16
         VSFont &HA000, 0, 113, 175, "Epicenter 3", chartext% * 32 + 31, chartext% * 32 + 16
      END IF
   END IF

   IF choicer = 0 THEN VSFont &HA000, 0, 113, 135, "PyroBreath 6", 63, 48
   'IF choicer = 1 THEN VSFont &HA000, 0, 113, 145, "Perseas 6", 63, 48
   IF choicer = 1 THEN VSFont &HA000, 0, 113, 155, "Inferno 4", 63, 48
   IF choicer = 2 THEN VSFont &HA000, 0, 113, 165, "Tsunami 3", 63, 48
   IF choicer = 3 THEN VSFont &HA000, 0, 113, 175, "Epicenter 3", 63, 48
   ochoicer = choicer
   a$ = INKEY$
   IF a$ = CHR$(0) + "H" THEN choicer = (choicer + 3) MOD 4
   IF a$ = CHR$(0) + "P" THEN choicer = (choicer + 1) MOD 4
   IF charMP < 6 AND choicer < 2 THEN choicer = (choicer + 1) MOD 4
   IF charMP < 4 AND choicer < 3 THEN choicer = (choicer + 1) MOD 4
   IF a$ = CHR$(27) OR charMP < 3 THEN choicer = -1: EXIT SUB
   
LOOP
END IF
END SUB

FUNCTION MIDIError$
SELECT CASE MIDI.ERROR
        CASE 0: MIDIError$ = "NO ERROR"
        CASE 1: MIDIError$ = "FILE CONTAINS NO DATA"
        CASE 2: MIDIError$ = "FILE IS TOO LARGE"
        CASE 3: MIDIError$ = "NO MIDI FILE PLAYING"
        CASE 4: MIDIError$ = "INVALID SBMIDI INTERRUPT"
        CASE 5: MIDIError$ = "INVALID SBSIM INTERRUPT"
        CASE 6: MIDIError$ = "NO MIXER CHIP"
        CASE 7: MIDIError$ = "COULD NOT DETECT SOUND CARD"
        CASE 8: MIDIError$ = "FEATURE UNAVAILABLE"
        CASE 9: MIDIError$ = "FILE IS CORRUPT"
        CASE 10: MIDIError$ = "INVALID SOUND CARD TYPE"
        CASE ELSE: MIDIError$ = "UNKNOWN ERROR"
END SELECT
END FUNCTION

FUNCTION MixerChip$
SELECT CASE MIXER.CHIP
    CASE 0: MixerChip$ = "No Mixer Chip Detected"
    CASE 1: MixerChip$ = "CT1335"
    CASE 2: MixerChip$ = "CT1345"
    CASE 3: MixerChip$ = "CT1745"
    CASE ELSE: MixerChip$ = "Unknown"
END SELECT
END FUNCTION

SUB perseas
'DIM wavesl(318) AS LONG, wavesr(2) AS LONG
'         initmagic
'         VSBlendPalettes "palettes\rpg", "palettes\fire"
'         charMP = charMP - 4
'DIM a AS INTEGER, B AS INTEGER, c AS INTEGER
'   FOR a = 1 TO 200 STEP 2
'      FOR B = 1 TO 200 STEP 20
'         c = (a + B) MOD 197
'         GET (0, c)-(317, c + 3), wavesl
'         GET (318, c)-(319, c + 3), wavesr
'         PUT (0, c), wavesr, PSET
'         PUT (2, c), wavesl, PSET
'
'         c = (a + B + 10) MOD 197
'         GET (2, c)-(319, c + 3), wavesl
'         GET (0, c)-(1, c + 3), wavesr
'         PUT (318, c), wavesr, PSET
'         PUT (0, c), wavesl, PSET
'         WAIT &H3DA, 8
'      NEXT B
'   NEXT a
'         fillbg
'   
'         VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
'         VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
'         VSBlendPalettes "palettes\fire", "palettes\rpg"
'         hits% = (charPower + 6 * (charMagicPower - 5) + RND * (charPower + charMagicPower) * 6 \ 5) * 6 \ (enemyPower + enemyPower)
'         endmagic
'         dispdamage
END SUB

SUB pyrobreath
DIM wavesl(318) AS LONG, wavesr(2) AS LONG, dragon%(12501), fireball%(1251)
DEF SEG = VARSEG(dragon%(0))
BLOAD "graphics\dragon.pic", VARPTR(dragon%(0))
DEF SEG = VARSEG(fireball%(0))
BLOAD "graphics\fireball.pic", VARPTR(fireball%(0))
         initmagic
         charMP = charMP - 6
         fillbg
        
         VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
         VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
        
         FOR x% = 320 TO 120 STEP -5
            fillbg
           
            VSSprite VARSEG(dragon%(0)), VARPTR(dragon%(0)), x%, 25, VARSEG(buffer%(0)), VARPTR(buffer%(0))
            VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
            VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
         NEXT
         VSBlendPalettes "palettes\rpg", "palettes\fire"
         FOR z% = 0 TO 2
            FOR y% = -10 TO 10 STEP 10
               FOR x% = 110 TO 50 STEP -4
                  fillbg
                 
                  VSSprite VARSEG(dragon%(0)), VARPTR(dragon%(0)), 120, 25, VARSEG(buffer%(0)), VARPTR(buffer%(0))
                  VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
                  VSSprite VARSEG(fireball%(0)), VARPTR(fireball%(0)), x% + y%, 200 - x% + y%, VARSEG(buffer%(0)), VARPTR(buffer%(0))
                  VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
                  WAIT &H3DA, 8
               NEXT
               fillbg
              
               VSSprite VARSEG(dragon%(0)), VARPTR(dragon%(0)), 120, 25, VARSEG(buffer%(0)), VARPTR(buffer%(0))
               VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 75 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
               VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
            NEXT
         NEXT
         FOR x% = 120 TO 320 STEP 5
            fillbg
           
            VSSprite VARSEG(dragon%(0)), VARPTR(dragon%(0)), x%, 25, VARSEG(buffer%(0)), VARPTR(buffer%(0))
            VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
            VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
         NEXT
         VSBlendPalettes "palettes\fire", "palettes\rpg"
         hits% = (charPower + 8 * (charMagicPower - 5) + RND * (charPower + charMagicPower) * 6 \ 5) * 6 \ (enemyPower + enemyPower)
         endmagic
         dispdamage
END SUB

SUB resetscrn
fillbg

VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
VSSpriteS VARSEG(npc(0)), VARPTR(npc(66)), 284, 172, 100, 100, VARSEG(buffer%(0)), VARPTR(buffer%(0))
VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
END SUB

SUB SetCard (CardType%)
IF CardType% < 1 OR CardType% > 8 THEN
    MIDI.ERROR = 10
    EXIT SUB
END IF
SB.CARDTYPE = CardType%
SELECT CASE CardType%
    CASE 1
        MIDI.ERROR = 6
        IF SENSITIVE THEN
            MIXER.CHIP = 0
            EXIT SUB
        ELSE
            MIXER.CHIP = 1
        END IF
    CASE 3
        'There are two different kinds of SB 2.0 cards: the regular SB2,
        'and the SB2CD.  The SB2CD has a mixer chip (the CT1335), whereas
        'the SB 2.0 does not.  The way to tell them apart is that the
        'Sound Blaster 2.0 uses Base Ports 220h and 240h, and the SB2CD
        'uses ports 250h and 260h.
        '
        'Assume the sound card is an SB2CD for now...
        MIXER.CHIP = 1
        'If the card is defined as an SB 2.0, not an SB 2.0 CD, and
        'sensitive error checking is on, disable mixer operations.
        IF (BasePort% = &H220 OR BasePort% = &H240) AND SENSITIVE <> 0 THEN
            MIXER.CHIP = 0
        END IF
        MIDI.ERROR = 0
    CASE 2, 4, 5
        MIXER.CHIP = 2
        MIDI.ERROR = 0
    CASE ELSE
        MIXER.CHIP = 3
        MIDI.ERROR = 0
END SELECT
END SUB

SUB SetMidi (LeftChannel%, RightChannel%)
SELECT CASE MIXER.CHIP
    CASE 0: MIDI.ERROR = 6: EXIT SUB
    CASE 1
        LC% = LeftChannel%: RC% = RightChannel%
        InternalSetVol LC%, RC%, 6
        MIDI.ERROR = 0
    CASE 2
        LC% = LeftChannel%: RC% = RightChannel%
        InternalSetVol LC%, RC%, &H26
        MIDI.ERROR = 0
    CASE 3
        LC% = LeftChannel%: RC% = RightChannel%
        InternalSetVol LC%, RC%, &H34
        MIDI.ERROR = 0
END SELECT
END SUB

FUNCTION SoundCard$ (CardType%)
SELECT CASE CardType%
    CASE 1: SoundCard$ = "Sound Blaster 1.0/1.5"
    CASE 2: SoundCard$ = "Sound Blaster Pro"
    CASE 3: SoundCard$ = "Sound Blaster 2.0/2.0CD"
    CASE 4: SoundCard$ = "Sound Blaster Pro 2"
    CASE 5: SoundCard$ = "Sound Blaster Pro 2 (Microchannel Version)"
    CASE 6: SoundCard$ = "Sound Blaster 16/16 ASP/AWE 32"
    CASE 7, 8: SoundCard$ = "Unknown (Probably SB32/AWE64)"
    CASE ELSE: SoundCard$ = "Unknown"
END SELECT
END FUNCTION

SUB StopMidi STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
IF asm$ = "" THEN
    asm$ = CHR$(&HBB) + CHR$(&H4) + CHR$(&H0) + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT) + CHR$(&HCB)
END IF
IF MIDI.PLAYTIME THEN
    DEF SEG = VARSEG(asm$)
    CALL ABSOLUTE(SADD(asm$))
    MIDI.ERROR = 0
ELSE
    MIDI.ERROR = 3
END IF
MIDI.PLAYTIME = 0
END SUB

SUB tsunami
DIM wavesl(318) AS LONG, wavesr(2) AS LONG
         initmagic
         VSBlendPalettes "palettes\rpg", "palettes\water"
         charMP = charMP - 3
   FOR a = 0 TO 96 STEP 2
      FOR B = 1 TO 200 STEP 15
         c = (a + B) MOD 197
         GET (0, c)-(317, c + 3), wavesl
         GET (318, c)-(319, c + 3), wavesr
         PUT (0, c), wavesr, PSET
         PUT (2, c), wavesl, PSET
   
         c = (a + B + 10) MOD 197
         GET (2, c)-(319, c + 3), wavesl
         GET (0, c)-(1, c + 3), wavesr
         PUT (318, c), wavesr, PSET
         PUT (0, c), wavesl, PSET
         WAIT &H3DA, 8
      NEXT B
   NEXT a
         fillbg
        
         VSSprite VARSEG(temppic(0)), VARPTR(temppic(0)), 80 - temppic(0) \ 16, 200 - temppic(1), VARSEG(buffer%(0)), VARPTR(buffer%(0))
         VSPCopy VARSEG(buffer%(0)), VARPTR(buffer%(0)), &HA000, 0
         VSBlendPalettes "palettes\water", "palettes\rpg"
         hits% = (charPower + 6 * (charMagicPower - 5) + RND * (charPower + charMagicPower)) * 6 \ (enemyPower + enemyPower)
         endmagic
         dispdamage
END SUB

