DECLARE SUB startMidi ()
DECLARE SUB getmain ()
DECLARE SUB drawDice (x, y, die, type$)
DECLARE SUB fopen (FILE$, FILE%)
DECLARE SUB fprint (text$, textx%, texty%, colour%, FILE%)
DECLARE SUB drawTable ()
DECLARE SUB roll ()
DECLARE SUB placeBets ()
DECLARE SUB payBets ()
DECLARE SUB returnLines ()
DECLARE SUB moveCursor ()
DECLARE SUB nextCursor ()
DECLARE SUB addCursor ()
DECLARE SUB convert (value)
DECLARE SUB detectDice ()
DECLARE SUB makePoint (num, section$)
DECLARE SUB payPoint ()
DECLARE SUB returnTable ()
DECLARE SUB showProfit (num)
DECLARE SUB initialise ()
DECLARE SUB refresh ()
DECLARE SUB playwav (wavefile$)
DECLARE SUB ValidWavHeader (FILE$, LenHeader%, dataLen&, nChannels%, nSamplesPerSec&, nAvgBytesPerSec&, ok%)
DECLARE SUB WriteToDSP (v%)
DECLARE SUB PlayBack (buffer$, size%, freq&, BytesPerSec&, chans%, num%)
DECLARE FUNCTION GetBlasterAddr% ()
DECLARE FUNCTION SBreset% ()
COMMON SHARED BlasterAddr%, dma%, repeats%
DECLARE FUNCTION BytesRequired& (filename$)
DECLARE SUB DetectSettings (BasePort%, IRQ%, LoDMA%, HiDMA%, CardType%)
DECLARE SUB playM (filename$)
DECLARE SUB LoadMIDI (filename$, MIDISegment%, MIDIOffset%)
DECLARE SUB PlayMIDI (MIDISegment%, MIDIOffset%)
DECLARE SUB stopMidi ()
DECLARE SUB InternalGetIntVector (IntNum%, Segment%, Offset%)

DIM SHARED SB.BASEPORT AS INTEGER, SB.IRQ AS INTEGER
DIM SHARED SB.LODMA AS INTEGER, SB.HIDMA AS INTEGER, SB.CARDTYPE AS INTEGER

SCREEN 12
DIM SHARED dice1, dice2, dice1$, dice2$, diceTot, diceTot$, cursor$, value$, bet$, betTot, dontCome$, pnt, pbet, Pprofit, mode$, delay, profit
DIM SHARED passBet, dontPassBet, big8Bet, big6Bet, comeBet, dontComeBet, fldBet, double3Bet, double5Bet, double4Bet, double2Bet, oneAndTwoBet, double1Bet, double6Bet, sixAndFiveLeftBet, sixAndFiveRightBet, snd$
DIM SHARED one(500), two(500), three(500), four(500), five(500), six(500)

ON KEY(10) GOSUB quitGame
KEY(10) ON

getmain
IF snd$ = "on" THEN startMidi

fopen "fonts\arial24.qbf", 1
fopen "fonts\script.qbf", 2
mode$ = "normal"
delay = 15000

initialise
drawTable

DO
placeBets
roll
detectDice
payBets
refresh
LOOP

quitGame:
CHAIN "main.bas"

SUB addCursor

IF cursor$ = "pass" THEN GOSUB Apass: GOTO addBot
IF cursor$ = "dontPass" THEN GOSUB ADontPass: GOTO addBot
IF cursor$ = "big8" THEN GOSUB Abig8: GOTO addBot
IF cursor$ = "big6" THEN GOSUB Abig6: GOTO addBot
IF cursor$ = "come" THEN GOSUB Acome: GOTO addBot
IF cursor$ = "dontCome" THEN GOSUB AdontCome: GOTO addBot
IF cursor$ = "fld" THEN GOSUB Afld: GOTO addBot
IF cursor$ = "double3" THEN GOSUB Adouble3: GOTO addBot
IF cursor$ = "double5" THEN GOSUB Adouble5: GOTO addBot
IF cursor$ = "double4" THEN GOSUB Adouble4: GOTO addBot
IF cursor$ = "double2" THEN GOSUB Adouble2: GOTO addBot
IF cursor$ = "oneAndTwo" THEN GOSUB AoneAndTwo: GOTO addBot
IF cursor$ = "double1" THEN GOSUB Adouble1: GOTO addBot
IF cursor$ = "double6" THEN GOSUB Adouble6: GOTO addBot
IF cursor$ = "sixAndFiveLeft" THEN GOSUB AsixAndFiveLeft: GOTO addBot
IF cursor$ = "sixAndFiveRight" THEN GOSUB AsixAndFiveRight: GOTO addBot
GOTO addBot

Apass:
IF passBet < 200 THEN passBet = passBet + 10
convert passBet
LINE (240, 320)-(300, 340), 1, BF
fprint "$" + value$, 245, 320, 15, 1
RETURN

ADontPass:
IF dontPassBet < 200 THEN dontPassBet = dontPassBet + 10
convert dontPassBet
LINE (336, 280)-(378, 300), 1, BF
fprint "$" + value$, 340, 281, 15, 1
RETURN

Abig6:
IF big6Bet < 200 THEN big6Bet = big6Bet + 10
convert big6Bet
LINE (163, 289)-(203, 304), 1, BF
fprint "$" + value$, 165, 287, 15, 1
RETURN

Abig8:
IF big8Bet < 200 THEN big8Bet = big8Bet + 10
convert big8Bet
LINE (88, 198)-(128, 218), 1, BF
fprint "$" + value$, 90, 200, 15, 1
RETURN

AdontCome:
IF dontComeBet < 200 THEN dontComeBet = dontComeBet + 10
convert dontComeBet
LINE (122, 85)-(160, 105), 1, BF
fprint "$" + value$, 124, 88, 15, 1
RETURN

Afld:
IF fldBet < 200 THEN fldBet = fldBet + 10
convert fldBet
LINE (258, 248)-(296, 266), 1, BF
fprint "$" + value$, 260, 249, 15, 1
RETURN

Acome:
IF comeBet < 200 THEN comeBet = comeBet + 10
convert comeBet
LINE (225, 160)-(275, 180), 1, BF
fprint "$" + value$, 230, 160, 15, 1
RETURN

Adouble3:
IF double3Bet < 200 THEN double3Bet = double3Bet + 10
convert double3Bet
LINE (410, 190)-(480, 215), 1, BF
fprint "$" + value$, 428, 195, 15, 1
RETURN

Adouble5:
IF double5Bet < 200 THEN double5Bet = double5Bet + 10
convert double5Bet
LINE (498, 190)-(568, 215), 1, BF
fprint "$" + value$, 516, 195, 15, 1
RETURN

Adouble4:
IF double4Bet < 200 THEN double4Bet = double4Bet + 10
convert double4Bet
LINE (410, 231)-(480, 256), 1, BF
fprint "$" + value$, 428, 236, 15, 1
RETURN

Adouble2:
IF double2Bet < 200 THEN double2Bet = double2Bet + 10
convert double2Bet
LINE (498, 231)-(568, 256), 1, BF
fprint "$" + value$, 516, 236, 15, 1
RETURN

AoneAndTwo:
IF oneAndTwoBet < 200 THEN oneAndTwoBet = oneAndTwoBet + 10
convert oneAndTwoBet
LINE (402, 275)-(458, 295), 1, BF
fprint "$" + value$, 412, 277, 15, 1
RETURN

Adouble1:
IF double1Bet < 200 THEN double1Bet = double1Bet + 10
convert double1Bet
LINE (462, 275)-(518, 295), 1, BF
fprint "$" + value$, 472, 277, 15, 1
RETURN

Adouble6:
IF double6Bet < 200 THEN double6Bet = double6Bet + 10
convert double6Bet
LINE (521, 275)-(579, 295), 1, BF
fprint "$" + value$, 530, 277, 15, 1
RETURN

AsixAndFiveLeft:
IF sixAndFiveLeftBet < 200 THEN sixAndFiveLeftBet = sixAndFiveLeftBet + 10
convert sixAndFiveLeftBet
LINE (410, 313)-(480, 338), 1, BF
fprint "$" + value$, 428, 318, 15, 1
RETURN

AsixAndFiveRight:
IF sixAndFiveRightBet < 200 THEN sixAndFiveRightBet = sixAndFiveRightBet + 10
convert sixAndFiveRightBet
LINE (498, 313)-(568, 338), 1, BF
fprint "$" + value$, 516, 318, 15, 1
RETURN

addBot:
END SUB

REM $DYNAMIC
'BytesRequired - Returns the amount of memory needed to store a file.
FUNCTION BytesRequired& (filename$)
'Open the file.
FF% = FREEFILE
OPEN filename$ FOR BINARY AS #FF%
'Store the length of the file.
FileLen& = LOF(FF%)
'Close the file.
CLOSE FF%
'If the length of the file is 0, assume it does not exist and delete it.
IF FileLen& = 0 THEN
    KILL filename$
    MIDI.ERROR = 1
    EXIT FUNCTION
END IF
'Return the length of the file as the number of bytes required.
BytesRequired& = FileLen&
MIDI.ERROR = 0
END FUNCTION

REM $STATIC
SUB convert (value)

IF value = 2 THEN value$ = "2"
IF value = 3 THEN value$ = "3"
IF value = 4 THEN value$ = "4"
IF value = 5 THEN value$ = "5"
IF value = 6 THEN value$ = "6"
IF value = 7 THEN value$ = "7"
IF value = 8 THEN value$ = "8"
IF value = 9 THEN value$ = "9"
IF value = 11 THEN value$ = "11"
IF value = 12 THEN value$ = "12"
IF value = 10 THEN value$ = "10"
IF value = 20 THEN value$ = "20"
IF value = 30 THEN value$ = "30"
IF value = 40 THEN value$ = "40"
IF value = 50 THEN value$ = "50"
IF value = 60 THEN value$ = "60"
IF value = 70 THEN value$ = "70"
IF value = 80 THEN value$ = "80"
IF value = 90 THEN value$ = "90"
IF value = 100 THEN value$ = "100"
IF value = 110 THEN value$ = "110"
IF value = 120 THEN value$ = "120"
IF value = 130 THEN value$ = "130"
IF value = 140 THEN value$ = "140"
IF value = 150 THEN value$ = "150"
IF value = 160 THEN value$ = "160"
IF value = 170 THEN value$ = "170"
IF value = 180 THEN value$ = "180"
IF value = 190 THEN value$ = "190"
IF value = 200 THEN value$ = "200"

END SUB

SUB detectDice

betTot = passBet + dontPassBet + big8Bet + big6Bet + comeBet + dontComeBet + fldBet + double3Bet + double5Bet + double4Bet + double2Bet + oneAndTwoBet + double1Bet + double6Bet + sixAndFiveLeftBet + sixAndFiveRightBet
IF dice1 = 1 AND dice2 = 1 THEN diceTot = 2: diceTot$ = "double1": GOTO detectBot
IF dice1 = 2 AND dice2 = 2 THEN diceTot = 4: diceTot$ = "double2": GOTO detectBot
IF dice1 = 3 AND dice2 = 3 THEN diceTot = 6: diceTot$ = "double3": GOTO detectBot
IF dice1 = 4 AND dice2 = 4 THEN diceTot = 8: diceTot$ = "double4": GOTO detectBot
IF dice1 = 5 AND dice2 = 5 THEN diceTot = 10: diceTot$ = "double5": GOTO detectBot
IF dice1 = 6 AND dice2 = 6 THEN diceTot = 12: diceTot$ = "double6": GOTO detectBot
diceTot = dice1 + dice2
convert diceTot
diceTot$ = value$

detectBot:
END SUB

REM $DYNAMIC
'DetectSettings - Attempt to detect Sound Blaster settings
SUB DetectSettings (BasePort%, IRQ%, LoDMA%, HiDMA%, CardType%)

BasePort% = 0
IRQ% = 0
LoDMA% = 0
HiDMA% = 0
CardType% = 0

'Read the BLASTER environment variable
Settings$ = ENVIRON$("BLASTER")

'Attempt to extract the base port, High DMA, Low DMA, IRQ, and card type
'from the BLASTER enironment variable.
FOR I% = 1 TO LEN(Settings$) - 1
    'If the type of sound card was found, get it and exit the loop.
    SELECT CASE UCASE$(MID$(Settings$, I%, 1))
        'If the card type was found...
        CASE "T"
            CardType% = VAL(MID$(Settings$, I% + 1, 1))
            'If the base port address was found...
        CASE "A"
            BasePort% = VAL("&H" + LTRIM$(STR$(VAL(MID$(Settings$, I% + 1, 3)))))
        'If the IRQ was found...
        CASE "I"
            IRQ% = VAL(MID$(Settings$, I% + 1, 2))
        'If the low DMA channel was found...
        CASE "D"
            LoDMA% = VAL(MID$(Settings$, I% + 1, 1))
        'If the high DMA channel was found...
        CASE "H"
            HiDMA% = VAL(MID$(Settings$, I% + 1, 1))
    END SELECT
NEXT I%

'If the card type wasn't found in the BLASTER variable, try to figure
'out the type using another method.

IF CardType% = 0 THEN
    'Examine the card's DMA channel.
    SELECT CASE LoDMA%
        'If the DMA is 210h or 230h, the card is an SB1.0/1.5.
        CASE &H210, &H230
            CardType% = 1
        'If the DMA is 250h or 260h, the card is either an SB2CD or a
        'Sound Blaster 16.  It could also be a Sound Blaster 1.0/1.5,
        'but it probably isn't.  Actually, it's also unlikely that the card
        'is an SB16, but I check for it anyway, because there's an easy way
        'to tell if it is - the High DMA channel will be greater than
        '0.
        '
        'On the other hand, there's no way that I know of to
        'distinguish an SB 1.0 from an SB 2.0, except by looking at the
        'BLASTER environment variable.  And since this code is executing
        'that method obviously failed.
        CASE &H250, &H260
            'Examining the High DMA channel will narrow it down.
            'If the High DMA is greater than 0, the card is an SB16.
            IF HiDMA% THEN
                CardType% = 6
            'Otherwise, define the card as a Sound Blaster 2.0.
            ELSE
                CardType% = 3
            END IF
        'If the DMA channel is any other value....
        CASE ELSE
            'Check the High DMA channel.  If it's a non-zero value,
            'we've got an SB16.
            IF HiDMA% THEN
                CardType% = 6
            'Otherwise....
            ELSE
                'If sensitive error checking is on, define the card as
                'a Sound Blaster 1.0/1.5.
                IF SENSITIVE THEN
                    CardType% = 1
                'Otherwise, assume it's a Sound Blaster Pro.
                ELSE
                    CardType% = 4
                END IF
            END IF
    END SELECT
END IF

'Determine the sound card's mixer chip
SELECT CASE CardType%
    'If the card could not be detected....
    CASE 0
        MIDI.ERROR = 7
        'If sensitive error checking is on, disable mixer operations
        IF SENSITIVE THEN
            MIXER.CHIP = 0
        'Otherwise, assume the default mixer chip.
        ELSE
            MIXER.CHIP = 2
        END IF
    'If the card is a Sound Blaster 1.0/1.5 or equivalent....
    CASE 1
        'Return an error.
        MIDI.ERROR = 6
        'If sensitive error checking is on, disable mixer operations and
        'exit.
        IF SENSITIVE THEN
            MIXER.CHIP = 0
            EXIT SUB
        'Otherwise, set the earliest mixer chip and continue.
        ELSE
            MIXER.CHIP = 1
        END IF
    'If the card is a Sound Blaster 2.0/2.5 or equivalent....
    CASE 3
        'There are two different kinds of SB 2.0 cards: the regular SB2,
        'and the SB2CD.  The SB2CD has a mixer chip (the CT1335), whereas
        'the SB 2.0 does not.  The way to tell them apart is that the
        'Sound Blaster 2.0 uses Base Ports 220h and 240h, and the SB2CD
        'uses ports 250h and 260h.
        '
        'Assume the sound card is an SB2CD for now...
        MIXER.CHIP = 1
        'If the card is defined as an SB 2.0, not an SB 2.0 CD, and
        'sensitive error checking is on, disable mixer operations.
        IF (BasePort% = &H220 OR BasePort% = &H240) AND SENSITIVE <> 0 THEN
            MIXER.CHIP = 0
        END IF
        MIDI.ERROR = 0
    'If the card is a Sound Blaster Pro, assume chip CT1345
    CASE 2, 4, 5
        MIXER.CHIP = 2
        MIDI.ERROR = 0
    'If the card is a Sound Blaster 16 or later, assume chip CT1745
    CASE IS >= 6
        MIXER.CHIP = 3
        MIDI.ERROR = 0
END SELECT
END SUB

REM $STATIC
SUB drawDice (x, y, die, type$)

IF type$ = "stay" THEN GOTO permanent ELSE GOTO temporary

temporary:
IF die = 1 THEN PUT (x, y), one
IF die = 2 THEN PUT (x, y), two
IF die = 3 THEN PUT (x, y), three
IF die = 4 THEN PUT (x, y), four
IF die = 5 THEN PUT (x, y), five
IF die = 6 THEN PUT (x, y), six
GOTO drawBot
                              
permanent:
IF die = 1 THEN PUT (x, y), one, PSET
IF die = 2 THEN PUT (x, y), two, PSET
IF die = 3 THEN PUT (x, y), three, PSET
IF die = 4 THEN PUT (x, y), four, PSET
IF die = 5 THEN PUT (x, y), five, PSET
IF die = 6 THEN PUT (x, y), six, PSET
GOTO drawBot

drawBot:
END SUB

SUB drawTable
OUT &H3C8, 6: OUT &H3C9, 20: OUT &H3C9, 0: OUT &H3C9, 0
PAINT (1, 1), 1
CIRCLE (50, 50), 30, 6
CIRCLE (50, 430), 30, 6
CIRCLE (590, 50), 30, 6
CIRCLE (590, 430), 30, 6
LINE (50, 0)-(100, 480), 1, BF
LINE (0, 50)-(640, 100), 1, BF
LINE (0, 100)-(640, 430), 1, BF
LINE (100, 0)-(590, 480), 1, BF
LINE (50, 20)-(590, 20), 6
LINE (620, 50)-(620, 430), 6
LINE (590, 460)-(50, 460), 6
LINE (20, 430)-(20, 50), 6
PAINT (1, 1), 6
LINE (40, 40)-(600, 350), 15, B
LINE (40, 40)-(380, 350), 15, B
DRAW "c15 bm40,40 r40 d250 bm80,311 nu100 r300 bm380,40 d145 l300 r40 f86 nd40 r173 bm120,40 d145 u72"
DRAW "r43 nu72 r43 nu72 r43 nu72 r43 nu72 r43 nu72 r45 r43 nu72 bm120,185 f43 g82"
LINE (163, 40)-(423, 65), 15, B
fprint "10", 394, 79, 14, 1
fprint "9", 354, 79, 14, 1
fprint "8", 309, 79, 14, 1
fprint "6", 266, 79, 14, 1
fprint "5", 224, 79, 14, 1
fprint "4", 181, 79, 14, 1
fprint "COME", 226, 140, 12, 1
fprint "6", 107, 227, 12, 1
fprint "8", 152, 272, 12, 1
fprint "FIELD", 260, 230, 14, 1
fprint "2 3 4 9 10 11 12", 190, 207, 14, 1
fprint "Don't pass", 250, 281, 0, 1
fprint "PASS", 190, 320, 15, 1
fprint "DC", 132, 67, 0, 1
fprint "D", 95, 50, 0, 1
fprint "o", 96, 63, 0, 1
fprint "n", 96, 76, 0, 1
fprint "t", 97, 92, 0, 1
fprint "p", 96, 113, 0, 1
fprint "a", 96, 129, 0, 1
fprint "s", 96, 142, 0, 1
fprint "s", 96, 155, 0, 1
fprint "P", 57, 150, 15, 1
fprint "A", 55, 170, 15, 1
fprint "S", 55, 190, 15, 1
fprint "S", 55, 210, 15, 1
fprint "2 3 4 9 10 11 12", 190, 207, 14, 1
CIRCLE (194, 217), 10, 14
CIRCLE (356, 217), 10, 14
CIRCLE (356, 217), 13, 14
LINE (415, 160)-(565, 185), 15, B
LINE (400, 185)-(580, 350), 15, B
fprint "SEVEN", 422, 163, 12, 1
fprint "4 to 1", 493, 163, 15, 1
DRAW "bm400,185 d41 r90 nu41 r90 d41 l90 nu41 l90 d41 r60 nu41 r60 nu41 r60 d42 l90 nu42"
fprint "3 + 3", 417, 195, 14, 1
fprint "5 + 5", 507, 195, 14, 1
fprint "4 + 4", 417, 236, 14, 1
fprint "2 + 2", 507, 236, 14, 1
fprint "1 + 2", 403, 277, 14, 1
fprint "1 + 1", 463, 277, 14, 1
fprint "6 + 6", 521, 277, 14, 1
fprint "6 + 5", 417, 318, 14, 1
fprint "6 + 5", 507, 318, 14, 1
fprint "Craps", 100, 400, 14, 2
fprint "Craps", 480, 400, 14, 2

END SUB

SUB fopen (FILE$, FILE%)
  OPEN FILE$ FOR RANDOM AS FILE% LEN = 2
END SUB

'                  !!!WINDOWS FONTS FOR QBASIC!!!
'                  ------------------------------
'   Written by Bobby K (Krusty) of Insanity Dreams and Digiwerx
'
'
'
SUB fprint (text$, textx%, texty%, colour%, FILE%)
  'lpi: lines per integer
  'fws: font word spacing
  'fls: font letter spacing
  'p% : pointer
  GET FILE%, 1, lpi%
  GET FILE%, 2, fws%
  GET FILE%, 3, fls%
  FOR count% = 1 TO LEN(text$)
    m% = ASC(MID$(text$, count%, 1)) - 29
    IF m% > 3 THEN
      GET FILE%, m%, a1%
      GET FILE%, m% + 1, a2%
      FOR N% = a1% TO a2% - 1 STEP lpi%
        FOR z% = 0 TO lpi% - 1
          GET FILE%, N% + z%, l%
          LINE (p% + textx%, (16 * z%) + texty%)-(p% + textx%, (16 * z%) + 15 + texty%), colour%, , l%
        NEXT z%
        p% = p% + 1
      NEXT N%
      p% = p% + fls%
    ELSE
      p% = p% + fws%
    END IF
  NEXT count%
END SUB

FUNCTION GetBlasterAddr%
'Get Blaster Address and DMA channel from Environment Variable
tmp% = 0  'No Environment Variable Set...default
blast$ = UCASE$(ENVIRON$("BLASTER"))
IF LEN(blast$) THEN
   tmp% = INSTR(blast$, "A")
   tmp1$ = MID$(blast$, tmp% + 1, 3)
   tmp% = VAL("&H" + tmp1$)
   IF tmp% = 203 THEN tmp% = -1    'If there is no value assigned
   IF tmp% > 0 THEN
      tmp2% = INSTR(blast$, "D")
      dma% = VAL(MID$(blast$, tmp2% + 1))        'dma% is a global variable
      IF dma% < 0 OR dma% > 7 THEN tmp% = -2
   END IF
END IF
GetBlasterAddr% = tmp%
END FUNCTION

SUB getmain

CLOSE
OPEN "config.cfg" FOR INPUT AS #1
INPUT #1, snd$
INPUT #1, delay
INPUT #1, path$
INPUT #1, cardPattern
CLOSE #1

END SUB

SUB initialise

DRAW "c4 r30 d30 l30 u30"
PAINT (321, 241), 4
PSET (335, 255), 15
GET (320, 240)-(350, 270), one
CLS
DRAW "c4 r30 d30 l30 u30"
PAINT (321, 241), 4
PSET (330, 250), 15
PSET (340, 260), 15
GET (320, 240)-(350, 270), two
CLS
DRAW "c4 r30 d30 l30 u30"
PAINT (321, 241), 4
PSET (330, 250), 15
PSET (340, 260), 15
PSET (335, 255), 15
GET (320, 240)-(350, 270), three
CLS
DRAW "c4 r30 d30 l30 u30"
PAINT (321, 241), 4
PSET (330, 250), 15
PSET (340, 260), 15
PSET (330, 260), 15
PSET (340, 250), 15
GET (320, 240)-(350, 270), four
CLS
DRAW "c4 r30 d30 l30 u30"
PAINT (321, 241), 4
PSET (330, 250), 15
PSET (340, 260), 15
PSET (330, 260), 15
PSET (340, 250), 15
PSET (335, 255), 15
GET (320, 240)-(350, 270), five
CLS
DRAW "c4 r30 d30 l30 u30"
PAINT (321, 241), 4
PSET (330, 250), 15
PSET (340, 260), 15
PSET (330, 260), 15
PSET (340, 250), 15
PSET (330, 255), 15
PSET (340, 255), 15
GET (320, 240)-(350, 270), six
CLS

END SUB

REM $DYNAMIC
SUB InternalGetIntVector (IntNum%, Segment%, Offset%) STATIC
'If the code hasn't been loaded already, do it now.
IF GetIntVCodeLoaded% = 0 THEN
    asm$ = asm$ + CHR$(&H55)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
    asm$ = asm$ + CHR$(&H8A) + CHR$(&H7)
    asm$ = asm$ + CHR$(&HB4) + CHR$(&H35)
    asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
    asm$ = asm$ + CHR$(&H8C) + CHR$(&HC1)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HDA)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
    asm$ = asm$ + CHR$(&H89) + CHR$(&HF)
    asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
    asm$ = asm$ + CHR$(&H89) + CHR$(&H17)
    asm$ = asm$ + CHR$(&H5D)
    asm$ = asm$ + CHR$(&HCB)
    asm$ = asm$ + CHR$(&H34) + CHR$(&H0)
    asm$ = asm$ + CHR$(&H60)
    asm$ = asm$ + CHR$(&H23) + CHR$(&H0)
    GetIntVCodeLoaded% = 1
END IF
'Execute the code
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(IntNum%, Segment%, Offset%, SADD(asm$))
END SUB

'LoadMIDI - loads a MIDI file into memory
SUB LoadMIDI (filename$, MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'See if an extension was supplied, and if not, add one.
IF INSTR(filename$, ".") = 0 THEN filename$ = filename$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN filename$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL filename$: MIDI.ERROR = 1: EXIT SUB
'If the file is too large, exit now.
IF FileLen& > 65536 THEN MIDI.ERROR = 2: EXIT SUB
'Make the filename an ASCIIZ string.
filename$ = filename$ + CHR$(0)
'Check if the assembly language code has already been loaded;
'if not, do it now.
IF ask$ = "" THEN
        asm$ = asm$ + CHR$(&H1E)
        asm$ = asm$ + CHR$(&H55)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
        asm$ = asm$ + CHR$(&HB8) + CHR$(&H0) + CHR$(&H3D)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HE)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H10)
        asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HC6)
        asm$ = asm$ + CHR$(&HB4) + CHR$(&H3F)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&HF)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HA)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&HC)
        asm$ = asm$ + CHR$(&H8E) + CHR$(&H1F)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HF3)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&HB4) + CHR$(&H3E)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H21)
        asm$ = asm$ + CHR$(&H5D)
        asm$ = asm$ + CHR$(&H1F)
        asm$ = asm$ + CHR$(&HCA) + CHR$(&HA) + CHR$(&H0)
END IF
'Call the assembly language routine.
DEF SEG = VARSEG(asm$)
CALL ABSOLUTE(VARSEG(filename$), SADD(filename$), MIDISegment%, MIDIOffset%, &HFFFF, SADD(asm$))
MIDI.ERROR = 0
END SUB

REM $STATIC
SUB makePoint (num, section$)

mode$ = "point"
pnt = num
IF num = 4 THEN x% = 167
IF num = 5 THEN x% = 210
IF num = 6 THEN x% = 253
IF num = 8 THEN x% = 296
IF num = 9 THEN x% = 340
IF num = 10 THEN x% = 384
IF section$ = "pass" THEN LINE (240, 320)-(300, 340), 1, BF: pbet = passBet: convert passBet: fprint "$" + value$, x%, 88, 15, 1: passBet = 0
IF section$ = "dontPass" THEN LINE (336, 280)-(378, 300), 1, BF: pbet = dontPassBet: convert dontPassBet: fprint "$" + value$, x%, 88, 15, 1: dontPassBet = 0
IF section$ = "come" THEN LINE (225, 160)-(275, 180), 1, BF: pbet = comeBet: convert comeBet: fprint "$" + value$, x%, 88, 15, 1: comeBet = 0

dontCome$ = "available"
bet$ = "yes"
cursor$ = "pass"
pointGo$ = "not over"

diceTot = 0
pointGo$ = "not over"
DO
SLEEP
LINE (90, 352)-(160, 450), 1, BF
fprint "Craps", 100, 400, 14, 2
IF pointGo$ = "not over" AND diceTot <> 7 AND diceTot <> pnt THEN roll
detectDice
IF diceTot = pnt THEN profit = profit + (2 * pbet): pointGo$ = "over": GOTO outsideLoop
IF diceTot = 7 THEN profit = profit - pbet: pointGo$ = "over": GOTO outsideLoop
LOOP UNTIL pointGo$ = "over" OR diceTot = 7 OR diceTot = pnt
outsideLoop:
dontCome$ = "unavailable"
mode$ = "normal"

END SUB

SUB moveCursor
nextCursor
DRAW "c12"
IF cursor$ = "pass" THEN GOSUB pass: GOTO moveBot
IF cursor$ = "dontPass" THEN GOSUB dontPass: GOTO moveBot
IF cursor$ = "big8" THEN GOSUB big8: GOTO moveBot
IF cursor$ = "big6" THEN GOSUB big6: GOTO moveBot
IF cursor$ = "dontCome" THEN GOSUB dontCome: GOTO moveBot
IF cursor$ = "fld" THEN GOSUB fld: GOTO moveBot
IF cursor$ = "come" THEN GOSUB come: GOTO moveBot
IF cursor$ = "double3" THEN GOSUB double3: GOTO moveBot
IF cursor$ = "double5" THEN GOSUB double5: GOTO moveBot
IF cursor$ = "double4" THEN GOSUB double4: GOTO moveBot
IF cursor$ = "double2" THEN GOSUB double2: GOTO moveBot
IF cursor$ = "oneAndTwo" THEN GOSUB oneAndTwo: GOTO moveBot
IF cursor$ = "double1" THEN GOSUB double1: GOTO moveBot
IF cursor$ = "double6" THEN GOSUB double6: GOTO moveBot
IF cursor$ = "sixAndFiveLeft" THEN GOSUB sixAndFiveLeft: GOTO moveBot
IF cursor$ = "sixAndFiveRight" THEN GOSUB sixAndFiveRight: GOTO moveBot
GOTO moveBot
pass:
DRAW "bm40,40 d310 r340 u39 l300 u271 l40"
cursor$ = "pass"
RETURN
dontPass:
DRAW "bm206,271 r174 d40 l174 u40"
cursor$ = "dontPass"
RETURN
big8:
DRAW "bm80,185 d126 e83 h43 l40"
cursor$ = "big8"
RETURN
big6:
DRAW "bm80,311 e83 f43 d40 l126"
cursor$ = "big6"
RETURN
dontCome:
DRAW "bm120,40 r43 d73 l43 u73"
cursor$ = "dontCome"
RETURN
fld:
DRAW "bm80,311 be83 nf43 h43 r260 d86 l173"
cursor$ = "fld"
RETURN
come:
DRAW "bm120,113 r260 d72 l260 u72"
cursor$ = "come"
RETURN
double3:
DRAW "bm400,185 d41 r90 u41 l90"
cursor$ = "double3"
RETURN
double5:
DRAW "bm490,185 d41 r90 u41 l90"
cursor$ = "double5"
RETURN
double4:
DRAW "bm400,226 d41 r90 u41 l90"
cursor$ = "double4"
RETURN
double2:
DRAW "bm490,226 d41 r90 u41 l90"
cursor$ = "double2"
RETURN
oneAndTwo:
DRAW "bm400,267 d41 r60 u41 l60"
cursor$ = "oneAndTwo"
RETURN
double1:
DRAW "bm460,267 d41 r60 u41 l60"
cursor$ = "double1"
RETURN
double6:
DRAW "bm520,267 d41 r60 u41 l60"
cursor$ = "double6"
RETURN
sixAndFiveLeft:
DRAW "bm400,308 d42 r90 u42 l90"
cursor$ = "sixAndFiveLeft"
RETURN
sixAndFiveRight:
DRAW "bm490,308 d42 r90 u42 l90"
cursor$ = "sixAndFiveRight"
RETURN

moveBot:
END SUB

SUB nextCursor
IF cursor$ = "pass" THEN cursor$ = "dontPass": GOTO nextBot
IF cursor$ = "dontPass" THEN cursor$ = "big8": GOTO nextBot
IF cursor$ = "big8" THEN cursor$ = "big6": GOTO nextBot
IF cursor$ = "big6" AND dontCome$ = "available" THEN cursor$ = "dontCome": GOTO nextBot ELSE IF cursor$ = "big6" THEN cursor$ = "fld": GOTO nextBot
IF cursor$ = "dontCome" THEN cursor$ = "fld": GOTO nextBot
IF cursor$ = "fld" THEN cursor$ = "come": GOTO nextBot
IF cursor$ = "come" THEN cursor$ = "double3": GOTO nextBot
IF cursor$ = "double3" THEN cursor$ = "double5": GOTO nextBot
IF cursor$ = "double5" THEN cursor$ = "double4": GOTO nextBot
IF cursor$ = "double4" THEN cursor$ = "double2": GOTO nextBot
IF cursor$ = "double2" THEN cursor$ = "oneAndTwo": GOTO nextBot
IF cursor$ = "oneAndTwo" THEN cursor$ = "double1": GOTO nextBot
IF cursor$ = "double1" THEN cursor$ = "double6": GOTO nextBot
IF cursor$ = "double6" THEN cursor$ = "sixAndFiveLeft": GOTO nextBot
IF cursor$ = "sixAndFiveLeft" THEN cursor$ = "sixAndFiveRight": GOTO nextBot
IF cursor$ = "sixAndFiveRight" THEN cursor$ = "pass": GOTO nextBot

nextBot:
END SUB

SUB payBets
           
newPoint = 0
IF passBet > 0 THEN GOSUB Ppass
IF dontPassBet > 0 THEN GOSUB PdontPass
IF big6Bet > 0 THEN GOSUB Pbig6
IF big8Bet > 0 THEN GOSUB Pbig8
IF dontCome$ = "available" THEN GOSUB PdontCome
IF fldBet > 0 THEN GOSUB Pfld
IF comeBet > 0 THEN GOSUB Pcome
IF double3Bet > 0 THEN GOSUB Pdouble3
IF double5Bet > 0 THEN GOSUB Pdouble5
IF double4Bet > 0 THEN GOSUB Pdouble4
IF double2Bet > 0 THEN GOSUB Pdouble2
IF oneAndTwoBet > 0 THEN GOSUB PoneAndTwo
IF double1Bet > 0 THEN GOSUB Pdouble1
IF double6Bet > 0 THEN GOSUB Pdouble6
IF sixAndFiveLeftBet > 0 THEN GOSUB PsixAndFiveLeft
IF sixAndFiveRightBet > 0 THEN GOSUB PsixAndFiveRight
IF newPoint > 0 AND mode$ = "point" THEN makePoint newPoint, betPlace$
profit = profit + Pprofit
money = money + profit
showProfit profit
GOTO payBot

Ppass:
IF diceTot = 2 OR diceTot = 3 OR diceTot = 12 THEN profit = profit - passBet: RETURN
IF diceTot = 7 OR diceTot = 11 THEN profit = profit + passBet ELSE newPoint = diceTot: betPlace$ = "pass": mode$ = "point"
RETURN

PdontPass:
IF diceTot = 7 OR diceTot = 11 THEN profit = profit - dontPassBet: RETURN
IF diceTot = 2 OR diceTot = 3 THEN profit = profit + dontPassBet: RETURN
IF diceTot = 12 THEN profit = profit + dontPassBet: RETURN ELSE newPoint = diceTot: betPlace$ = "dontPass": mode$ = "point"
RETURN

Pbig8:
IF diceTot = 8 THEN profit = profit + big8Bet: RETURN
IF diceTot = 7 THEN profit = profit - big8Bet ELSE RETURN
RETURN

Pbig6:
IF diceTot = 6 THEN profit = profit + big8Bet: RETURN
IF diceTot = 7 THEN profit = profit - big8Bet ELSE RETURN
RETURN

PdontCome:
IF diceTot = 7 OR diceTot = 11 THEN profit = profit - dontPassBet: RETURN
IF diceTot = 2 OR diceTot = 3 THEN profit = profit + dontPassBet: RETURN
IF diceTot = 12 THEN profit = profit + dontPassBet ELSE newPoint = diceTot: betPlace$ = "come": mode$ = "point"
RETURN

Pfld:
IF diceTot = 3 OR diceTot = 4 OR diceTot = 9 OR diceTot = 10 OR diceTot = 11 THEN profit = profit + fldBet: RETURN
IF diceTot = 2 THEN profit = profit + (fldBet * 2): RETURN
IF diceTot = 12 THEN profit = profit + (fldBet * 3) ELSE profit = profit - fldBet
RETURN

Pcome:
IF diceTot = 7 OR diceTot = 11 THEN profit = profit + comeBet: RETURN
IF diceTot = 2 OR diceTot = 3 OR diceTot = 12 THEN profit = profit - comeBet ELSE newPoint = diceTot: betPlace$ = "come": mode$ = "point"
RETURN

Pdouble3:
IF diceTot$ = "double3" THEN profit = profit + (double3Bet * 9): RETURN
IF diceTot = 6 OR diceTot = 7 THEN profit = profit - double3Bet ELSE RETURN
RETURN

Pdouble5:
IF diceTot$ = "double5" THEN profit = profit + (double3Bet * 7): RETURN
IF diceTot = 10 OR diceTot = 7 THEN profit = profit - double5Bet ELSE RETURN
RETURN

Pdouble4:
IF diceTot$ = "double4" THEN profit = profit + (double4Bet * 9): RETURN
IF diceTot = 8 OR diceTot = 7 THEN profit = profit - double4Bet ELSE RETURN
RETURN

Pdouble2:
IF diceTot$ = "double2" THEN profit = profit + (double2Bet * 7): RETURN
IF diceTot = 4 OR diceTot = 7 THEN profit = profit - double2Bet ELSE RETURN
RETURN

PoneAndTwo:
IF diceTot = 3 THEN profit = profit + (oneAndTwoBet * 14) ELSE profit = profit - oneAndTwoBet
RETURN

Pdouble1:
IF diceTot$ = "double1" THEN profit = profit + (double1Bet * 29) ELSE profit = profit - double1Bet
RETURN

Pdouble6:
IF diceTot$ = "double6" THEN profit = profit + (double6Bet * 29) ELSE profit = profit - double6Bet
RETURN

PsixAndFiveLeft:
IF diceTot = 11 THEN profit = profit + (sixAndFiveLeftBet * 14) ELSE profit = profit - sixAndFiveLeftBet
RETURN

PsixAndFiveRight:
IF diceTot = 11 THEN profit = profit + (sixAndFiveRightBet * 14) ELSE profit = profit - sixAndFiveRightBet
RETURN

payBot:
IF mode$ = "normal" THEN returnTable
END SUB

SUB placeBets

a$ = ""
cursor$ = "pass"
moveCursor
done$ = "no"
DO
a$ = INKEY$
SELECT CASE a$

CASE IS = " "
returnLines
moveCursor

CASE IS = "b"
addCursor
bet$ = "yes"

CASE IS = "e"
done$ = "yes"

END SELECT
LOOP UNTIL done$ = "yes" AND bet$ = "yes"

placeBot:
returnLines
END SUB

SUB PlayBack (buffer$, size%, freq&, BytesPerSec&, chans%, num%)
size% = size% - 1
Segment& = VARSEG(buffer$)
Offset& = SADD(buffer$)
IF Segment& < 0 THEN Segment& = Segment& + 65536
IF Offset& < 0 THEN Offset& = Offset& + 65536
baseaddr& = Segment& * 16 + Offset&
look1% = VARPTR(baseaddr&)
look2% = VARPTR(size%)
SELECT CASE dma%
   CASE 0
      dmapage% = &H87   '135 decimal
      dmaaddr% = 0
      dmalen% = 1
   CASE 1
      dmapage% = &H83   '131 decimal
      dmaaddr% = 2
      dmalen% = 3
   CASE 2
      dmapage% = &H81
      dmaaddr% = 4
      dmalen% = 5
   CASE 3
      dmapage% = &H82
      dmaaddr% = 6
      dmalen% = 7
   CASE 4
      dmapage% = &H8F
      dmaaddr% = &HC0
      dmalen% = &HC2
   CASE 5
      dmapage% = &H8B
      dmaaddr% = &HC4
      dmalen% = &HC6
   CASE 6
      dmapage% = &H89
      dmaaddr% = &HC8
      dmalen% = &HCA
   CASE 7
      dmapage% = &H8A
      dmaaddr% = &HCC
      dmalen% = &HCE
END SELECT
SELECT CASE dma%
   CASE 0 TO 3
      dmamask% = &HA
      dmamode% = &HB
      dmaclear% = &HC
      dmastatus% = &H8
   CASE 4 TO 7
      dmamask% = &HD4
      dmamode% = &HD6
      dmaclear% = &HD8
      dmastatus% = &HD0
END SELECT
SELECT CASE dma%
   CASE 0, 4
      dmaterminal% = 1   'bit 0 of status register (&H08 or &HD0)
   CASE 1, 5
      dmaterminal% = 2   'bit 1
   CASE 2, 6
      dmaterminal% = 4   'bit 2
   CASE 3, 7
      dmaterminal% = 8   'bit 3
END SELECT

OUT dmamask%, dma% + 4   'mask the dma channel
OUT dmaclear%, &H0       '(clear the internal DMA flip/flop)
OUT dmamode%, 72 + dma%  '  72=010010XX where XX=dmachannel%
OUT dmaaddr%, PEEK(look1%)      'bits 0-7 of  the 20bit address
OUT dmaaddr%, PEEK(look1% + 1)  'bits 8-15 of the 20bit address
OUT dmapage%, PEEK(look1% + 2)  'bits 16-19 of the 20 bit address
OUT dmalen%, PEEK(look2%)       'bits 0-7 of size%
OUT dmalen%, PEEK(look2% + 1)   'bits 8-15  of size%
OUT dmamask%, dma%              'enable channel

IF num% = 1 THEN  'only need to Write out time constant once
   timeconst% = 256 - 1000000 / (freq& * chans%)
   CALL WriteToDSP(&H40)
   CALL WriteToDSP(timeconst%)
   'Reset Mixer    DSPmixeraddress = Blasteraddr% + &H4
   OUT BlasterAddr% + &H4, &H0
   OUT BlasterAddr% + &H4 + 1, 0
   'Set Volume to Maximum...255
   OUT BlasterAddr% + &H4, &H22
   OUT BlasterAddr% + &H4 + 1, 255
   IF chans% = 2 THEN
      'Set mixer to Stereo Output
      OUT BlasterAddr% + &H4, &HE
      OUT BlasterAddr% + &H4 + 1, 34      '34=2^5+2^1
   END IF
END IF
IF BytesPerSec& > 22000 THEN
   CALL WriteToDSP(&H48)   'Set Block Size
ELSE
   CALL WriteToDSP(&H14)   'DMA Mode 8-bit DAC
END IF
CALL WriteToDSP(PEEK(look2%))      'Lo byte of address
CALL WriteToDSP(PEEK(look2% + 1))  'High byte of address
IF BytesPerSec& > 22000 THEN CALL WriteToDSP(&H91)  'High Speed DMA mode 8-bit
dummy% = INP(dmastatus%)    'Read status byte once to make sure DMA is going.
WAIT dmastatus%, dmaterminal%   'Loop until terminal count bit set in DMA status register
'DMA Transfer is Now Complete
'Acknowledge the DSP interrupt by reading the DATA AVAILABLE port once
dummy% = INP(BlasterAddr% + &HE)    'DSP Available address
END SUB

SUB playM (filename$)

DetectSettings SB.BASEPORT, SB.IRQ, SB.LODMA, SB.HIDMA, SB.CARDTYPE
DIM MIDI%(BytesRequired&(filename$) \ 2)
LoadMIDI filename$, VARSEG(MIDI%(0)), VARPTR(MIDI%(0))
PlayMIDI VARSEG(MIDI%(0)), VARPTR(MIDI%(0))

END SUB

REM $DYNAMIC
'PlayMIDI - Begins playing a MIDI file in the background.
SUB PlayMIDI (MIDISegment%, MIDIOffset%) STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Check to see if the MIDI playing code has previously been loaded.
'If not, load it now.
IF asm$ = "" THEN
        'Load the machine codes into a string.
        asm$ = asm$ + CHR$(&H55)
        asm$ = asm$ + CHR$(&H89) + CHR$(&HE5)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H8)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H17)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H5E) + CHR$(&H6)
        asm$ = asm$ + CHR$(&H8B) + CHR$(&H7)
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
        asm$ = asm$ + CHR$(&HBB) + CHR$(&H5) + CHR$(&H0)
        asm$ = asm$ + CHR$(&HCD) + CHR$(&H80)
        asm$ = asm$ + CHR$(&H5D)
        asm$ = asm$ + CHR$(&HCA) + CHR$(&H4) + CHR$(&H0)
END IF
IF SOUND.DISABLED = 0 THEN
    'Call the machine language routine to play the music.
    DEF SEG = VARSEG(asm$)
    Offset% = SADD(asm$)
    CALL ABSOLUTE(MIDISegment%, MIDIOffset%, Offset%)
    'Start the MIDI timer.
    MIDI.PLAYTIME = TIMER
END IF
MIDI.ERROR = 0
END SUB

REM $STATIC
SUB playwav (wavefile$)


repeats% = 1
BlasterAddr% = GetBlasterAddr%
SELECT CASE BlasterAddr%
   CASE -2
      PRINT "Bad DMA Channel specified!"
      END
   CASE -1
      PRINT "No Port Base Address Given!"
      END
   CASE 0
      PRINT "No BLASTER Environment Variable Set!"
      END
   CASE ELSE
      'Assume a valid Address Exists
'      PRINT "Blaster Address = "; HEX$(BlasterAddr%)
END SELECT
IF NOT SBreset% THEN
   PRINT "SoundBlaster Card Would Not Reset!"
   END
END IF

sp% = INSTR(Spec$, " ")
IF sp% THEN
   wavefile$ = LEFT$(Spec$, sp% - 1)
   repeats% = VAL(RIGHT$(Spec$, LEN(Spec$) - sp%))
   IF repeats% = 0 THEN repeats% = 1
ELSE
   IF LEN(Spec$) THEN
      wavefile$ = Spec$
      repeats% = 1
   END IF
END IF

IF LEN(wavefile$) = 0 THEN
END IF
'wavefile$ = "C:\QBASIC\THEME.WAV"
CALL ValidWavHeader(wavefile$, LenHeader%, WavLen&, Channels%, Sampling&, bytes&, ok%)

IF NOT ok% THEN
   PRINT "Bad Wave File Format"
   END
END IF

MaxBuffer% = 7053

CALL WriteToDSP(&HD1)  'Speaker ON
FOR repeat% = 1 TO repeats%    'This can loop to play the file ii% times]
filenum% = FREEFILE
   OPEN wavefile$ FOR BINARY AS filenum%
      num% = 0
      SEEK filenum%, LenHeader% + 1
      Remaining& = WavLen&
      DO
         num% = num% + 1
         IF Remaining& > MaxBuffer% THEN
            BufferLen% = MaxBuffer%
         ELSE
            BufferLen% = Remaining&
         END IF
         Remaining& = Remaining& - BufferLen%
         buffer$ = SPACE$(BufferLen%)
         GET filenum%, , buffer$
         CALL PlayBack(buffer$, BufferLen%, Sampling&, bytes&, Channels%, num%)
      LOOP WHILE Remaining& > 0
      OUT &H20, &H20   'Reset Normal Interrupt Service
   CLOSE filenum%
NEXT repeat%
CALL WriteToDSP(&HD3)  'Speaker OFF

END SUB

SUB refresh
                                          
passBet = 0
dontPassBet = 0
big6Bet = 0
big8Bet = 0
dontComeBet = 0
fldBet = 0
comeBet = 0
double3Bet = 0
double5Bet = 0
double4Bet = 0
double2Bet = 0
oneAndTwoBet = 0
double1Bet = 0
double6Bet = 0
sixAndFiveLeftBet = 0
sixAndFiveRightBet = 0
mode$ = "normal"
diceTot = 0
bet$ = "no"

END SUB

SUB returnLines
LINE (40, 40)-(600, 350), 15, B
LINE (40, 40)-(380, 350), 15, B
DRAW "c15 bm40,40 r40 d250 bm80,311 nu100 r300 bm380,40 d145 l300 r40 f86 nd40 r173 bm120,40 d145 u72"
DRAW "r43 nu72 r43 nu72 r43 nu72 r43 nu72 r43 nu72 r45 r43 nu72 bm120,185 f43 g82"
LINE (163, 40)-(423, 65), 15, B
LINE (415, 160)-(565, 185), 15, B
LINE (400, 185)-(580, 350), 15, B
DRAW "bm400,185 d41 r90 nu41 r90 d41 l90 nu41 l90 d41 r60 nu41 r60 nu41 r60 d42 l90 nu42"
END SUB

SUB returnTable

LINE (90, 352)-(160, 450), 1, BF
LINE (40, 40)-(600, 350), 15, B
LINE (40, 40)-(380, 350), 15, B
DRAW "c15 bm40,40 r40 d250 bm80,311 nu100 r300 bm380,40 d145 l300 r40 f86 nd40 r173 bm120,40 d145 u72"
DRAW "r43 nu72 r43 nu72 r43 nu72 r43 nu72 r43 nu72 r45 r43 nu72 bm120,185 f43 g82"
LINE (163, 40)-(423, 65), 15, B
LINE (240, 320)-(300, 340), 1, BF
LINE (336, 280)-(378, 300), 1, BF
LINE (163, 289)-(203, 304), 1, BF
LINE (88, 198)-(128, 218), 1, BF
LINE (122, 85)-(160, 105), 1, BF
LINE (258, 248)-(296, 266), 1, BF
LINE (225, 160)-(275, 180), 1, BF
LINE (410, 190)-(480, 215), 1, BF
LINE (498, 190)-(568, 215), 1, BF
LINE (410, 231)-(480, 256), 1, BF
LINE (498, 231)-(568, 256), 1, BF
LINE (402, 275)-(458, 295), 1, BF
LINE (462, 275)-(518, 295), 1, BF
LINE (521, 275)-(579, 295), 1, BF
LINE (410, 313)-(480, 338), 1, BF
LINE (498, 313)-(568, 338), 1, BF
LINE (164, 75)-(205, 111), 1, BF
LINE (207, 75)-(248, 111), 1, BF
LINE (250, 75)-(291, 111), 1, BF
LINE (293, 75)-(334, 111), 1, BF
LINE (336, 75)-(379, 111), 1, BF
LINE (381, 75)-(422, 111), 1, BF
fprint "Craps", 100, 400, 14, 2
fprint "10", 394, 79, 14, 1
fprint "9", 354, 79, 14, 1
fprint "8", 309, 79, 14, 1
fprint "6", 266, 79, 14, 1
fprint "5", 224, 79, 14, 1
fprint "4", 181, 79, 14, 1
fprint "6", 107, 227, 12, 1
fprint "8", 152, 272, 12, 1
fprint "3 + 3", 417, 195, 14, 1
fprint "5 + 5", 507, 195, 14, 1
fprint "4 + 4", 417, 236, 14, 1
fprint "2 + 2", 507, 236, 14, 1
fprint "1 + 2", 403, 277, 14, 1
fprint "1 + 1", 463, 277, 14, 1
fprint "6 + 6", 521, 277, 14, 1
fprint "6 + 5", 417, 318, 14, 1
fprint "6 + 5", 507, 318, 14, 1
refresh

END SUB

SUB roll

RANDOMIZE TIMER
dice1 = INT(RND * 6) + 1
dice2 = INT(RND * 6) + 1

x = 550
DO
RANDOMIZE TIMER
face1 = INT(RND * 6) + 1
face2 = INT(RND * 6) + 1
drawDice x, 365, face1, ""
drawDice x, 415, face2, ""
FOR dly = 1 TO delay
NEXT dly
drawDice x, 365, face1, ""
drawDice x, 415, face2, ""
x = x - 30

LOOP UNTIL x = 100

drawDice x, 365, dice1, "stay"
drawDice x, 415, dice2, "stay"

END SUB

FUNCTION SBreset%
'DSPreset% = address% + &H6
'DSPread% = address% + &HA
'DSPwrite% = address% + &HC
'DSPavail% = address% + &HE
'DSPmixer% = address% + &H4
OUT BlasterAddr% + &H6, 1   'Reset address
OUT BlasterAddr% + &H6, 0
time1! = TIMER: noreset% = 0
DO
   'Read Data Available port until bit 7 is set
   'This should take about 100 micro seconds...give it 1 full second
   IF TIMER - time1! > 1! THEN noreset% = -1
LOOP UNTIL ((INP(BlasterAddr% + &HE) AND 128) = 128) OR noreset%
IF NOT noreset% THEN
   IF INP(BlasterAddr% + &HA) = &HAA THEN
      SBreset% = -1
   ELSE
      SBreset% = 0
   END IF
ELSE
   SBreset% = 0
END IF
END FUNCTION

SUB showProfit (num)

FOR dly = 1 TO delay * 30
NEXT dly
IF num = 0 THEN fprint "PUSH", 300, 400, 15, 1
IF num > 0 THEN fprint "GAIN", 300, 400, 15, 1: playwav "sfx\cashreg.wav"
IF num < 0 THEN fprint "LOSS", 300, 400, 15, 1: playwav "sfx\bad2.wav"
FOR dly = 1 TO delay * 30
NEXT dly
LINE (290, 390)-(350, 420), 1, BF

END SUB

SUB startMidi

stopMidi
RANDOMIZE TIMER
song = INT(RND * 4)
IF song = 0 THEN playM "sfx\song1.mid"
IF song = 1 THEN playM "sfx\song2.mid"
IF song = 2 THEN playM "sfx\song3.mid"
IF song = 3 THEN playM "sfx\song4.mid"

END SUB

REM $DYNAMIC
'StopMIDI - Stops playing MIDI file
SUB stopMidi STATIC
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Stop the music!!
IF asm$ = "" THEN
    asm$ = asm$ + CHR$(&HBB) + CHR$(&H4) + CHR$(&H0)
    asm$ = asm$ + CHR$(&HCD) + CHR$(SBMIDI.INTERRUPT)
    asm$ = asm$ + CHR$(&HCB)
END IF
IF MIDI.PLAYTIME THEN
    DEF SEG = VARSEG(asm$)
    Offset% = SADD(asm$)
    CALL ABSOLUTE(Offset%)
    MIDI.ERROR = 0
ELSE
    MIDI.ERROR = 3
END IF
'No MIDI file is playing, so reset the timer
MIDI.PLAYTIME = 0
END SUB

REM $STATIC
SUB ValidWavHeader (FILE$, LenHeader%, dataLen&, nChannels%, nSamplesPerSec&, nAvgBytesPerSec&, ok%)
rID$ = SPACE$(4)
wID$ = SPACE$(4)
fID$ = SPACE$(4)
dat$ = SPACE$(4)
dummy$ = SPACE$(1)

filenum% = FREEFILE
OPEN FILE$ FOR BINARY AS filenum%
  GET filenum%, , rID$
  GET filenum%, , rLen&
  GET filenum%, , wID$
  GET filenum%, , fID$
  GET filenum%, , fLen&
  GET filenum%, , wFormatTag%       '2 bytes
  GET filenum%, , nChannels%        '2 bytes
  GET filenum%, , nSamplesPerSec&   '4 bytes
  GET filenum%, , nAvgBytesPerSec&  '4 bytes
  GET filenum%, , nBlockAlign%      '2 bytes
  GET filenum%, , FormatSpecific%   '2 bytes
  'Read bytes until have read fLen& total bytes.
  'I have no idea what these next bytes are used for (if they even exist).
  FOR I% = 1 TO fLen& - 16          '16 bytes is what we have read in so far
     GET filenum%, , dummy$         'read in 1 byte at a time
  NEXT I%
  GET filenum%, , dat$
  IF UCASE$(dat$) = "FACT" THEN
     'funny format...
     GET filenum%, , dummy&
     GET filenum%, , dummy&
     GET filenum%, , dat$
  END IF
  GET filenum%, , dataLen&
  LenHeader% = LOC(1)
CLOSE filenum%
'  PRINT rID$;
'  PRINT rLen&;
'  PRINT wID$;
'  PRINT fID$;
'  PRINT fLen&;
'  PRINT wFormatTag%;       '2 bytes
'  PRINT nChannels%;        '2 bytes
'  PRINT nSamplesPerSec&;   '4 bytes
'  PRINT nAvgBytesPerSec&;  '4 bytes
'  PRINT nBlockAlign%;      '2 bytes
'  PRINT FormatSpecific%;   '2 bytes
'  PRINT dat$;
'  PRINT dataLen&;
'  PRINT LenHeader%
IF UCASE$(rID$) = "RIFF" THEN
   IF UCASE$(wID$) = "WAVE" THEN
      IF UCASE$(dat$) = "DATA" THEN
         IF UCASE$(fID$) = "FMT " THEN
           IF FormatSpecific% = 8 THEN ok% = -1
         END IF
      END IF
   END IF
END IF
END SUB

SUB WriteToDSP (v%)
DO
LOOP UNTIL (INP(BlasterAddr% + &HC) AND 128) = 0
OUT BlasterAddr% + &HC, v%
END SUB

