'       Coo Race!
'
'       (c) 1998 MICOOSOFT
'
'       Controls:
'
'       Use left and right to steer you car.  Up to speed up, down to
'       slow down.
'
'       Player 2: Use "A", "D" to steer your car.  "W" to speed up, "S"
'       to slow down.
'
'
'       The Cooey Classics!
'
'       This is the second game in the Cooey Classics! series.  It will run
'       under Qbasic or QuickBasic.
'

DEFINT A-Z
'$DYNAMIC

DECLARE SUB MoveCar2 ()
DECLARE SUB CheckForHit2 ()
DECLARE SUB ReverseCar2 ()
DECLARE SUB TitleScreen ()
DECLARE SUB CheckForRecord ()
DECLARE SUB LapTime ()
DECLARE SUB LoadPics ()
DECLARE SUB ShowLevel ()
DECLARE SUB LoadLevel ()
DECLARE SUB ReverseCar ()
DECLARE SUB MoveCar ()
DECLARE SUB CheckForHit ()
DECLARE SUB ShowCar ()


DIM SHARED Title(16001) AS INTEGER
DIM SHARED RoadT(201) AS INTEGER
DIM SHARED RoadTL(201) AS INTEGER
DIM SHARED RoadL(201) AS INTEGER
DIM SHARED RoadBL(201) AS INTEGER
DIM SHARED RoadB(201) AS INTEGER
DIM SHARED RoadBR(201) AS INTEGER
DIM SHARED RoadR(201) AS INTEGER
DIM SHARED RoadTR(201) AS INTEGER
DIM SHARED RoadM(201) AS INTEGER
DIM SHARED GrassT(201) AS INTEGER
DIM SHARED GrassM(201) AS INTEGER
DIM SHARED GrassB(201) AS INTEGER

DIM SHARED RedCar1(201) AS INTEGER
DIM SHARED RedCar2(201) AS INTEGER
DIM SHARED RedCar3(201) AS INTEGER
DIM SHARED RedCar4(201) AS INTEGER
DIM SHARED RedCar5(201) AS INTEGER
DIM SHARED RedCar6(201) AS INTEGER
DIM SHARED RedCar7(201) AS INTEGER
DIM SHARED RedCar8(201) AS INTEGER
DIM SHARED PurpleCar1(201) AS INTEGER
DIM SHARED PurpleCar2(201) AS INTEGER
DIM SHARED PurpleCar3(201) AS INTEGER
DIM SHARED PurpleCar4(201) AS INTEGER
DIM SHARED PurpleCar5(201) AS INTEGER
DIM SHARED PurpleCar6(201) AS INTEGER
DIM SHARED PurpleCar7(201) AS INTEGER
DIM SHARED PurpleCar8(201) AS INTEGER

DIM SHARED RedCar1M(201) AS INTEGER
DIM SHARED RedCar2M(201) AS INTEGER
DIM SHARED RedCar3M(201) AS INTEGER
DIM SHARED RedCar4M(201) AS INTEGER
DIM SHARED RedCar5M(201) AS INTEGER
DIM SHARED RedCar6M(201) AS INTEGER
DIM SHARED RedCar7M(201) AS INTEGER
DIM SHARED RedCar8M(201) AS INTEGER

DIM SHARED RedCarBack(251) AS INTEGER
DIM SHARED PurpleCarBack(251) AS INTEGER

DIM SHARED Level(0 TO 15, 1 TO 9) AS INTEGER
DIM SHARED Speed AS INTEGER, Dir AS INTEGER
DIM SHARED Speed2 AS INTEGER, Dir2 AS INTEGER
DIM SHARED CarX AS INTEGER, CarY AS INTEGER
DIM SHARED CarX2 AS INTEGER, CarY2 AS INTEGER
DIM SHARED LapStart!, FastestLap!, Lap AS INTEGER
DIM SHARED Reverse AS INTEGER, RaceType AS INTEGER
DIM SHARED Reverse2 AS INTEGER, Lap2 AS INTEGER
DIM SHARED LapStart2!, Laps AS INTEGER
DIM SHARED Top!(3), Name$(3)

CONST True = -1, False = 0
CONST MinX = 0, MinY = 20, MaxX = 299, MaxY = 179

CALL LoadPics
CALL LoadLevel
Speed = 0: Dir = 2
Speed2 = 0: Dir2 = 2
CarX = 161: CarY = 21
CarX2 = 161: CarY2 = 41
FastestLap! = 20

SCREEN 7, , 0, 1

CALL TitleScreen

CLS
LOCATE 10, 16
PRINT "Select Game"
LOCATE 12, 10
PRINT "1. One player race"
LOCATE 14, 10
PRINT "2. Two player race"
LOCATE 16, 10
PRINT "3. Quit"
PCOPY 0, 1
Choice$ = LCASE$(INPUT$(1))

IF Choice$ = "1" THEN
        RaceType = 1
    ELSEIF Choice$ = "2" THEN
        RaceType = 2
        CLS
        LOCATE 10, 16
        PRINT "Select Laps"
        LOCATE 12, 10
        PRINT "1. Five Laps"
        LOCATE 14, 10
        PRINT "2. Ten Laps"
        PCOPY 0, 1
        Choice$ = LCASE$(INPUT$(1))
        IF Choice$ = "1" THEN Laps = 5 ELSE Laps = 10
    ELSE
        Quit = True
END IF

IF Quit THEN SYSTEM

CALL ShowLevel
LINE (0, 10)-(319, 19), 2, BF
LINE (160, 21)-(160, 79), 15
GET (CarX, CarY)-(CarX + 20, CarY + 20), RedCarBack
GET (CarX2, CarY2)-(CarX2 + 20, CarY2 + 20), PurpleCarBack

DO

    SELECT CASE INKEY$
    CASE CHR$(0) + CHR$(80)
        Speed = Speed - 1
        IF Speed = -1 THEN Speed = 0
    CASE CHR$(0) + CHR$(72)
        Speed = Speed + 1
        IF Speed = 11 THEN Speed = 10
    CASE CHR$(0) + CHR$(75)
        Dir = Dir + 1
        IF Dir = 9 THEN Dir = 1
    CASE CHR$(0) + CHR$(77)
        Dir = Dir - 1
        IF Dir = 0 THEN Dir = 8
    CASE IS = "W", "w"
        Speed2 = Speed2 + 1
        IF Speed2 = 11 THEN Speed2 = 10
    CASE IS = "S", "s"
        Speed2 = Speed2 - 1
        IF Speed2 = -1 THEN Speed2 = 0
    CASE IS = "A", "a"
        Dir2 = Dir2 + 1
        IF Dir2 = 9 THEN Dir2 = 1
    CASE IS = "D", "d"
        Dir2 = Dir2 - 1
        IF Dir2 = 0 THEN Dir2 = 8
    CASE CHR$(27)
        Quit = True
    END SELECT

    IF Reverse = 0 THEN
            CALL MoveCar
            CALL CheckForHit
        ELSE
            CALL ReverseCar
    END IF
    IF RaceType = 2 THEN
        IF Reverse2 = 0 THEN
                CALL MoveCar2
                CALL CheckForHit2
            ELSE
                CALL ReverseCar2
        END IF
    END IF
    CALL LapTime

    CALL ShowCar
    LOCATE 1: PRINT SPACE$(40)
    IF RaceType = 1 THEN
            LOCATE 1
            PRINT "Lap Time:"; USING "##.##"; (TIMER - LapStart!)
            LOCATE 1, 24
            PRINT "Fastest Lap:"; USING "##.##"; (FastestLap!)
            PCOPY 0, 1
        ELSEIF RaceType = 2 THEN
            LOCATE 1
            PRINT "P1 Lap:"; Lap
            LOCATE 1, 30
            PRINT "P2 Lap:"; Lap2
            PCOPY 0, 1
    END IF

LOOP UNTIL Quit

IF RaceType = 1 THEN CALL CheckForRecord
SYSTEM

DATA 2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,8
DATA 3,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7
DATA 3,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7
DATA 3,9,9,7,10,10,10,10,10,10,10,10,3,9,9,7
DATA 3,9,9,7,11,11,11,11,11,11,11,11,3,9,9,7
DATA 3,9,9,7,12,12,12,12,12,12,12,12,3,9,9,7
DATA 3,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7
DATA 3,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7
DATA 4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6

REM $STATIC
SUB CheckForHit

    FOR Y = 0 TO 19
        FOR X = 0 TO 19
            IF POINT(CarX + X, CarY + Y) = 3 THEN Hit = True
        NEXT X
    NEXT Y

    IF Hit THEN
        Reverse = INT(Speed / 2) + 1
        Speed = Speed - 1
        IF Speed = -1 THEN Speed = 0
    END IF

END SUB

SUB CheckForHit2

    FOR Y = 0 TO 19
        FOR X = 0 TO 19
            IF POINT(CarX2 + X, CarY2 + Y) = 3 THEN Hit = True
        NEXT X
    NEXT Y

    IF Hit THEN
        Reverse2 = INT(Speed2 / 2) + 1
        Speed2 = Speed2 - 1
        IF Speed2 = -1 THEN Speed2 = 0
    END IF

END SUB

SUB CheckForRecord

    SCREEN 7, , 0, 0
    OPEN "records.dat" FOR INPUT AS #1
    INPUT #1, Top!(1), Top!(2), Top!(3)
    INPUT #1, Name$(1), Name$(2), Name$(3)
    IF FastestLap! < Top!(1) THEN
            Top!(3) = Top!(2)
            Name$(3) = Name$(2)
            Top!(2) = Top!(1)
            Name$(2) = Name$(1)
            LOCATE 1: PRINT SPACE$(40)
            LOCATE 1
            INPUT "Fastest lap! Enter name: ", Name$
            Name$(1) = Name$: Top!(1) = FastestLap!
        ELSEIF FastestLap! < Top!(2) THEN
            Top!(3) = Top!(2)
            Name$(3) = Name$(2)
            LOCATE 1: PRINT SPACE$(40)
            LOCATE 1
            INPUT "Faster lap! Enter name: ", Name$
            Name$(2) = Name$: Top!(2) = FastestLap!
        ELSEIF FastestLap! < Top!(3) THEN
            LOCATE 1: PRINT SPACE$(40)
            LOCATE 1
            INPUT "Fast lap! Enter name: ", Name$
            Name$(3) = Name$: Top!(3) = FastestLap!
    END IF
    CLOSE #1
    OPEN "records.dat" FOR OUTPUT AS #1
    WRITE #1, Top!(1), Top!(2), Top!(3)
    WRITE #1, Name$(1), Name$(2), Name$(3)
    CLOSE #1

END SUB

SUB LapTime

    IF RaceType = 1 THEN
            IF CarX < 161 AND CarX > 152 AND CarY < 80 THEN
                IF TIMER - LapStart! < FastestLap! AND INT(TIMER - LapStart!) > 0 THEN
                    FastestLap! = TIMER - LapStart!
                END IF
                LapStart! = TIMER
            END IF
        ELSEIF RaceType = 2 THEN
            IF CarX < 161 AND CarX > 152 AND CarY < 80 THEN
                IF TIMER - LapStart! > 1 THEN
                    Lap = Lap + 1
                END IF
                LapStart! = TIMER
            END IF
            IF CarX2 < 161 AND CarX2 > 152 AND CarY2 < 80 THEN
                IF TIMER - LapStart2! > 1 THEN
                    Lap2 = Lap2 + 1
                END IF
                LapStart2! = TIMER
            END IF
    END IF

    IF RaceType = 2 THEN
        IF Lap2 = Laps THEN
                SCREEN 7, , 0, 0
                LOCATE 1: PRINT SPACE$(40)
                COLOR 12
                LOCATE 1: PRINT "Player two wins! Congrats!"
                FOR pause = 1 TO 10000: NEXT pause
                WHILE INKEY$ = "": WEND
                SYSTEM
            ELSEIF Lap = Laps THEN
                SCREEN 7, , 0, 0
                LOCATE 1: PRINT SPACE$(40)
                COLOR 13
                LOCATE 1: PRINT "Player one wins! Congrats!"
                FOR pause = 1 TO 10000: NEXT pause
                WHILE INKEY$ = "": WEND
                SYSTEM
        END IF
    END IF

END SUB

SUB LoadLevel

    FOR Y = 1 TO 9
        FOR X = 0 TO 15
            READ Level(X, Y)
        NEXT X
    NEXT Y

END SUB

SUB LoadPics

    DEF SEG = VARSEG(Title(0)): BLOAD "title.pic", VARPTR(Title(0))
    DEF SEG = VARSEG(RedCar1(0)): BLOAD "car1.spr", VARPTR(RedCar1(0))
    DEF SEG = VARSEG(RedCar2(0)): BLOAD "car2.spr", VARPTR(RedCar2(0))
    DEF SEG = VARSEG(RedCar3(0)): BLOAD "car3.spr", VARPTR(RedCar3(0))
    DEF SEG = VARSEG(RedCar4(0)): BLOAD "car4.spr", VARPTR(RedCar4(0))
    DEF SEG = VARSEG(RedCar5(0)): BLOAD "car5.spr", VARPTR(RedCar5(0))
    DEF SEG = VARSEG(RedCar6(0)): BLOAD "car6.spr", VARPTR(RedCar6(0))
    DEF SEG = VARSEG(RedCar7(0)): BLOAD "car7.spr", VARPTR(RedCar7(0))
    DEF SEG = VARSEG(RedCar8(0)): BLOAD "car8.spr", VARPTR(RedCar8(0))
    DEF SEG = VARSEG(PurpleCar1(0)): BLOAD "p2_car1.spr", VARPTR(PurpleCar1(0))
    DEF SEG = VARSEG(PurpleCar2(0)): BLOAD "p2_car2.spr", VARPTR(PurpleCar2(0))
    DEF SEG = VARSEG(PurpleCar3(0)): BLOAD "p2_car3.spr", VARPTR(PurpleCar3(0))
    DEF SEG = VARSEG(PurpleCar4(0)): BLOAD "p2_car4.spr", VARPTR(PurpleCar4(0))
    DEF SEG = VARSEG(PurpleCar5(0)): BLOAD "p2_car5.spr", VARPTR(PurpleCar5(0))
    DEF SEG = VARSEG(PurpleCar6(0)): BLOAD "p2_car6.spr", VARPTR(PurpleCar6(0))
    DEF SEG = VARSEG(PurpleCar7(0)): BLOAD "p2_car7.spr", VARPTR(PurpleCar7(0))
    DEF SEG = VARSEG(PurpleCar8(0)): BLOAD "p2_car8.spr", VARPTR(PurpleCar8(0))
   
    DEF SEG = VARSEG(RedCar1M(0)): BLOAD "car1.msk", VARPTR(RedCar1M(0))
    DEF SEG = VARSEG(RedCar2M(0)): BLOAD "car2.msk", VARPTR(RedCar2M(0))
    DEF SEG = VARSEG(RedCar3M(0)): BLOAD "car3.msk", VARPTR(RedCar3M(0))
    DEF SEG = VARSEG(RedCar4M(0)): BLOAD "car4.msk", VARPTR(RedCar4M(0))
    DEF SEG = VARSEG(RedCar5M(0)): BLOAD "car5.msk", VARPTR(RedCar5M(0))
    DEF SEG = VARSEG(RedCar6M(0)): BLOAD "car6.msk", VARPTR(RedCar6M(0))
    DEF SEG = VARSEG(RedCar7M(0)): BLOAD "car7.msk", VARPTR(RedCar7M(0))
    DEF SEG = VARSEG(RedCar8M(0)): BLOAD "car8.msk", VARPTR(RedCar8M(0))

    DEF SEG = VARSEG(RoadT(0)): BLOAD "top_mid.til", VARPTR(RoadT(0))
    DEF SEG = VARSEG(RoadTL(0)): BLOAD "top_lft.til", VARPTR(RoadTL(0))
    DEF SEG = VARSEG(RoadL(0)): BLOAD "mid_lft.til", VARPTR(RoadL(0))
    DEF SEG = VARSEG(RoadBL(0)): BLOAD "bot_lft.til", VARPTR(RoadBL(0))
    DEF SEG = VARSEG(RoadB(0)): BLOAD "bot_mid.til", VARPTR(RoadB(0))
    DEF SEG = VARSEG(RoadBR(0)): BLOAD "bot_rht.til", VARPTR(RoadBR(0))
    DEF SEG = VARSEG(RoadR(0)): BLOAD "mid_rht.til", VARPTR(RoadR(0))
    DEF SEG = VARSEG(RoadTR(0)): BLOAD "top_rht.til", VARPTR(RoadTR(0))
    DEF SEG = VARSEG(RoadM(0)): BLOAD "mid_mid.til", VARPTR(RoadM(0))
    DEF SEG = VARSEG(GrassT(0)): BLOAD "grass_t.til", VARPTR(GrassT(0))
    DEF SEG = VARSEG(GrassM(0)): BLOAD "grass_m.til", VARPTR(GrassM(0))
    DEF SEG = VARSEG(GrassB(0)): BLOAD "grass_b.til", VARPTR(GrassB(0))

END SUB

SUB MoveCar

    PUT (CarX, CarY), RedCarBack, PSET
    IF Dir = 1 THEN
            CarX = CarX - Speed: CarY = CarY - Speed
        ELSEIF Dir = 2 THEN
            CarX = CarX - Speed
        ELSEIF Dir = 3 THEN
            CarX = CarX - Speed: CarY = CarY + Speed
        ELSEIF Dir = 4 THEN
            CarY = CarY + Speed
        ELSEIF Dir = 5 THEN
            CarX = CarX + Speed: CarY = CarY + Speed
        ELSEIF Dir = 6 THEN
            CarX = CarX + Speed
        ELSEIF Dir = 7 THEN
            CarX = CarX + Speed: CarY = CarY - Speed
        ELSEIF Dir = 8 THEN
            CarY = CarY - Speed
    END IF

END SUB

SUB MoveCar2

    PUT (CarX2, CarY2), PurpleCarBack, PSET
    IF Dir2 = 1 THEN
            CarX2 = CarX2 - Speed2: CarY2 = CarY2 - Speed2
        ELSEIF Dir2 = 2 THEN
            CarX2 = CarX2 - Speed2
        ELSEIF Dir2 = 3 THEN
            CarX2 = CarX2 - Speed2: CarY2 = CarY2 + Speed2
        ELSEIF Dir2 = 4 THEN
            CarY2 = CarY2 + Speed2
        ELSEIF Dir2 = 5 THEN
            CarX2 = CarX2 + Speed2: CarY2 = CarY2 + Speed2
        ELSEIF Dir2 = 6 THEN
            CarX2 = CarX2 + Speed2
        ELSEIF Dir2 = 7 THEN
            CarX2 = CarX2 + Speed2: CarY2 = CarY2 - Speed2
        ELSEIF Dir2 = 8 THEN
            CarY2 = CarY2 - Speed2
    END IF

END SUB

SUB ReverseCar

    Reverse = Reverse - 1
    PUT (CarX, CarY), RedCarBack, PSET
    IF Dir = 1 THEN
            CarX = CarX + Speed: CarY = CarY + Speed
        ELSEIF Dir = 2 THEN
            CarX = CarX + Speed
        ELSEIF Dir = 3 THEN
            CarX = CarX + Speed: CarY = CarY - Speed
        ELSEIF Dir = 4 THEN
            CarY = CarY - Speed
        ELSEIF Dir = 5 THEN
            CarX = CarX - Speed: CarY = CarY - Speed
        ELSEIF Dir = 6 THEN
            CarX = CarX - Speed
        ELSEIF Dir = 7 THEN
            CarX = CarX - Speed: CarY = CarY + Speed
        ELSEIF Dir = 8 THEN
            CarY = CarY + Speed
    END IF

END SUB

SUB ReverseCar2

    Reverse2 = Reverse2 - 1
    PUT (CarX2, CarY2), PurpleCarBack, PSET
    IF Dir2 = 1 THEN
            CarX2 = CarX2 + Speed2: CarY2 = CarY2 + Speed2
        ELSEIF Dir2 = 2 THEN
            CarX2 = CarX2 + Speed2
        ELSEIF Dir2 = 3 THEN
            CarX2 = CarX2 + Speed2: CarY2 = CarY2 - Speed2
        ELSEIF Dir2 = 4 THEN
            CarY2 = CarY2 - Speed2
        ELSEIF Dir2 = 5 THEN
            CarX2 = CarX2 - Speed2: CarY2 = CarY2 - Speed2
        ELSEIF Dir2 = 6 THEN
            CarX2 = CarX2 - Speed2
        ELSEIF Dir2 = 7 THEN
            CarX2 = CarX2 - Speed2: CarY2 = CarY2 + Speed2
        ELSEIF Dir2 = 8 THEN
            CarY2 = CarY2 + Speed2
    END IF

END SUB

SUB ShowCar

    IF CarX > MaxX THEN CarX = MaxX
    IF CarX < MinX THEN CarX = MinX
    IF CarY > MaxY THEN CarY = MaxY
    IF CarY < MinY THEN CarY = MinY
    GET (CarX, CarY)-(CarX + 20, CarY + 20), RedCarBack
    IF Dir = 1 THEN
            PUT (CarX, CarY), RedCar1M, AND
            PUT (CarX, CarY), RedCar1, XOR
        ELSEIF Dir = 2 THEN
            PUT (CarX, CarY), RedCar2M, AND
            PUT (CarX, CarY), RedCar2, XOR
        ELSEIF Dir = 3 THEN
            PUT (CarX, CarY), RedCar3M, AND
            PUT (CarX, CarY), RedCar3, XOR
        ELSEIF Dir = 4 THEN
            PUT (CarX, CarY), RedCar4M, AND
            PUT (CarX, CarY), RedCar4, XOR
        ELSEIF Dir = 5 THEN
            PUT (CarX, CarY), RedCar5M, AND
            PUT (CarX, CarY), RedCar5, XOR
        ELSEIF Dir = 6 THEN
            PUT (CarX, CarY), RedCar6M, AND
            PUT (CarX, CarY), RedCar6, XOR
        ELSEIF Dir = 7 THEN
            PUT (CarX, CarY), RedCar7M, AND
            PUT (CarX, CarY), RedCar7, XOR
        ELSEIF Dir = 8 THEN
            PUT (CarX, CarY), RedCar8M, AND
            PUT (CarX, CarY), RedCar8, XOR
    END IF
    IF RaceType = 2 THEN
        IF CarX2 > MaxX THEN CarX2 = MaxX
        IF CarX2 < MinX THEN CarX2 = MinX
        IF CarY2 > MaxY THEN CarY2 = MaxY
        IF CarY2 < MinY THEN CarY2 = MinY
        PCOPY 0, 1
        PUT (CarX, CarY), RedCarBack, PSET
        GET (CarX2, CarY2)-(CarX2 + 20, CarY2 + 20), PurpleCarBack
        IF Dir2 = 1 THEN
                PUT (CarX2, CarY2), RedCar1M, AND
                PUT (CarX2, CarY2), PurpleCar1, XOR
            ELSEIF Dir2 = 2 THEN
                PUT (CarX2, CarY2), RedCar2M, AND
                PUT (CarX2, CarY2), PurpleCar2, XOR
            ELSEIF Dir2 = 3 THEN
                PUT (CarX2, CarY2), RedCar3M, AND
                PUT (CarX2, CarY2), PurpleCar3, XOR
            ELSEIF Dir2 = 4 THEN
                PUT (CarX2, CarY2), RedCar4M, AND
                PUT (CarX2, CarY2), PurpleCar4, XOR
            ELSEIF Dir2 = 5 THEN
                PUT (CarX2, CarY2), RedCar5M, AND
                PUT (CarX2, CarY2), PurpleCar5, XOR
            ELSEIF Dir2 = 6 THEN
                PUT (CarX2, CarY2), RedCar6M, AND
                PUT (CarX2, CarY2), PurpleCar6, XOR
            ELSEIF Dir2 = 7 THEN
                PUT (CarX2, CarY2), RedCar7M, AND
                PUT (CarX2, CarY2), PurpleCar7, XOR
            ELSEIF Dir2 = 8 THEN
                PUT (CarX2, CarY2), RedCar8M, AND
                PUT (CarX2, CarY2), PurpleCar8, XOR
        END IF
    END IF

END SUB

SUB ShowLevel

    FOR Y = 1 TO 9
        FOR X = 0 TO 15
            IF Level(X, Y) = 1 THEN
                    PUT (X * 20, Y * 20), RoadT, PSET
                ELSEIF Level(X, Y) = 2 THEN
                    PUT (X * 20, Y * 20), RoadTL, PSET
                ELSEIF Level(X, Y) = 3 THEN
                    PUT (X * 20, Y * 20), RoadL, PSET
                ELSEIF Level(X, Y) = 4 THEN
                    PUT (X * 20, Y * 20), RoadBL, PSET
                ELSEIF Level(X, Y) = 5 THEN
                    PUT (X * 20, Y * 20), RoadB, PSET
                ELSEIF Level(X, Y) = 6 THEN
                    PUT (X * 20, Y * 20), RoadBR, PSET
                ELSEIF Level(X, Y) = 7 THEN
                    PUT (X * 20, Y * 20), RoadR, PSET
                ELSEIF Level(X, Y) = 8 THEN
                    PUT (X * 20, Y * 20), RoadTR, PSET
                ELSEIF Level(X, Y) = 9 THEN
                    PUT (X * 20, Y * 20), RoadM, PSET
                ELSEIF Level(X, Y) = 10 THEN
                    PUT (X * 20, Y * 20), GrassT, PSET
                ELSEIF Level(X, Y) = 11 THEN
                    PUT (X * 20, Y * 20), GrassM, PSET
                ELSEIF Level(X, Y) = 12 THEN
                    PUT (X * 20, Y * 20), GrassB, PSET
            END IF
        NEXT X
    NEXT Y

END SUB

SUB TitleScreen

    PUT (0, 0), Title, PSET

    OPEN "records.dat" FOR INPUT AS #1
    INPUT #1, Top!(1), Top!(2), Top!(3)
    INPUT #1, Name$(1), Name$(2), Name$(3)
    CLOSE #1

    LOCATE 14, 16
    PRINT "Best laps"
    LOCATE 16, 6: PRINT "1 "; Name$(1)
    LOCATE 16, 30: PRINT USING "##.##"; Top!(1)
    LOCATE 17, 6: PRINT "2 "; Name$(2)
    LOCATE 17, 30: PRINT USING "##.##"; Top!(2)
    LOCATE 18, 6: PRINT "3 "; Name$(3)
    LOCATE 18, 30: PRINT USING "##.##"; Top!(3)

    PCOPY 0, 1
    WHILE INKEY$ = "": WEND

END SUB

