#ifndef dialogs__
#define dialogs__
#include "coty.h"
#include "seznam.h"
#include "grafika.h"
#define delka_dlgtxt 256
#define bdtext BLACK
#define bdpozadi WHITE
#define bstext YELLOW
#define bspozadi LIGHTGRAY
#define bram BLACK
#define bdram DARKGRAY
#define bhram WHITE
class tdobject{
 public:
  virtual void show(void) {};
  virtual void hide(void) {};
 };
class tdvobject: public tdobject{
 public:
  void *p;
  int x1,x2,y1,y2;
  bool visible;
  tdvobject(int nx1,int ny1,int nx2,int ny2);
  virtual void show(void);
  virtual void hide(void);
  ~tdvobject(void);
 };
class tdialog:public tdvobject{
 public:
   char text[delka_dlgtxt];
   tdialog(int nx1,int ny1,int nx2,int ny2,const char *ntext);
   void rename(char *ntext);
   virtual void show(void);
};
class tokdialog:public tdialog{
private:
   virtual void show(void);
public:
  tokdialog(int nx1,int ny1,int nx2,int ny2,const char *ntext)
   :tdialog(nx1,ny1,nx2,ny2,ntext){};
  virtual void run(void);
 };
class tanonedialog:public tdialog{
public:
   bool ano;
   char text2[delka_dlgtxt];
   tanonedialog(int nx1,int ny1,int nx2,int ny2,char *ntext,char *ntext2);
   void showbuttons(void);
   void rename(char *ntext,char *ntext2);
   virtual void show(void);
   virtual bool run(void);
 };
 class taboutdialog:public tokdialog{
 public:
   taboutdialog(void);
   virtual void show(void);
  };
class tpromenadialog:public tdialog{
 public:
   bool bily;
   tpromenadialog(bool nbily);
   void kursor(shortint x,byte barva);
   virtual void show(void);
   virtual shortint run(void);
  };
class tedline:public tdvobject{
public:
    byte pos,lt,lst,xz;
// pos je pozice kurzoru v etzci
// lt je nejvt mon dlka textu
// lst je dlka zobraziteln sti textu (spot se sama)
// xz slo prvnho zobrazenho znaku (bn 0)
    char text[delka_dlgtxt];
    bool aktiv;
    tedline (int nx1,int ny1,int nx2,byte nlt,char *ntext);
    virtual void show(void);
    virtual void run(char *str);
private:
  void hc(void);
  void sc(void);
  void del(void);
  };
class tedldialog:public tdialog{
 public:
    tedline *edline;
    tedldialog(char *nadpis,char *edltxt);
    virtual void show(void);
    void run(char *s);
    ~tedldialog(void);
 };
class tsavedialog:public tdialog{
 public:
    tedline *edline;
    tsavedialog(void);
    tsavedialog(int i);//protoe C++ je debiln; jen kvli potomku topendialog
    virtual void show(void);
    void run(tpozice *pos,tpartie *part);
    ~tsavedialog(void);
 };
class  topendialog:public tsavedialog{
public:
   topendialog(void);
   bool run(tpozice *pos,tpartie **part);
 };
 void button(int x1,int y1,int x2,int y2);
 void savedlg(tpozice *pos,tpartie *part);
 void edldlg(char *nadpis, char *edlstr);
 bool opendlg(tpozice *pos,tpartie **part);
 void matpatdlg(char *s);
 shortint prdlg(bool bily);
 void aboutdlg(void);
 bool hrajebilydlg(void);
 bool anonedlg(char *s1,char *s2);
 #endif
