/*
 * Barney Mutilator
 * By Jeremy Penner
 */


#include <stdlib.h>
#include <stdio.h>

#include <allegro.h>
#include "barney.h"

DATAFILE *barneydat;

   /* int arrays for holding x and y values of sprites--use constants in
      BARNEY.H for initializing them */

   int spritex[19];
   int spritey[19];

void intro(void)
{
int cnt, index,sitthere;
int armturn=220;
int inc=4;
BITMAP *buffer;

play_sample(barneydat[Z_SND_STARTUP].dat,50,128,1001,0);

buffer=create_bitmap(SCREEN_W, SCREEN_H);

for (index=0;index<65;index++)
{
clear(buffer);

for (cnt=0;cnt<9;cnt++)
{
if (cnt!=C_ARML && cnt!=D_BARNEYPALETTE && cnt!=E_BLOOD && cnt!=F_CROSSHAIR)
     draw_sprite(buffer, barneydat[cnt].dat, spritex[cnt], spritey[cnt]);
}
armturn+=inc;
if (armturn>=35 && inc==4 && armturn<50)
     inc=-4;   /*flip flop incrementer*/
else
if (armturn<=219 && inc==-4 && armturn>150)
     inc=4;  /*flip flop incrementer*/

if (armturn>=251)
     armturn=5;
else
if (armturn<=4)
     armturn=250;

rotate_sprite(buffer, barneydat[C_ARML].dat,spritex[C_ARML], spritey[C_ARML],itofix(armturn));

   /* Blit to screen */
   blit(buffer, screen, 0,0,0,0,SCREEN_W,SCREEN_H);

rest(50);
if (key[KEY_ESC])
     {
     stop_sample(barneydat[Z_SND_STARTUP].dat);
     return(0);
     }
}
fade_out(32);
for(sitthere=0;sitthere<34;sitthere++)
{
rest(50);
if(key[KEY_ESC])
     {
     stop_sample(barneydat[Z_SND_STARTUP].dat);
     return(0);
     }
     
}

clear(screen);
fade_from(barneydat[D_BARNEYPALETTE].dat, barneydat[Z_PAL_RED].dat, 1);
for(sitthere=0;sitthere<148;sitthere++)
{
rest(50);
if(key[KEY_ESC])
     {
     stop_sample(barneydat[Z_SND_STARTUP].dat);
     return(0);
     }
}
}

void title(void)
{
int index;
BITMAP *buffer;

buffer=create_bitmap(SCREEN_W, SCREEN_H);

blit(barneydat[Z_PIC_TITLE].dat, screen,0,0,0,0,320,200);


fade_from(barneydat[Z_PAL_RED].dat, barneydat[D_BARNEYPALETTE].dat,1);

for (index=100;index>=0;index--)
{
clear(buffer);
blit(barneydat[Z_PIC_TITLE].dat, buffer,0,0,0,0,320,200);
stretch_sprite(buffer,barneydat[Z_PIC_ADVISORY].dat,230-index,120-index,71+(index*2),43+(index*2));
blit(buffer,screen,0,0,0,0,320,200);
}
play_sample(barneydat[Z_SND_WHAM].dat,50,128,1001,0);
while(!key[KEY_SPACE]);
fade_out(1);
clear(screen);
set_palette(barneydat[D_BARNEYPALETTE].dat);
}

void main()
{
   BITMAP *buffer;

   int sndyes;
   int mousecur;


   /* int arrays for holding width and height for detecting which body part
      was hit */

   int spritew[9];
   int spriteh[9];

   /* char array for telling me whether or not the limb is falling */
   char limbfall[9];

   /* int for angle of rotation */
   int limbturn[9]= {0,0,0,0,0,0,0,0,0};

   int cnt; /* counter variable */
   int bloodcnt; /* for blood animation \*!COOL!*/
   int lookup[9]={Z_ARMRBLOOD1, NULL, Z_ARMLBLOOD1, NULL, NULL, NULL, \
                  Z_HEADBLOOD1, Z_LEGLBLOOD1, Z_LEGRBLOOD1};
         /* lookup table for testing where blood should spew */

   allegro_init();
   install_timer();
   install_keyboard();

   if (install_mouse()==-1)
        {
        allegro_exit();
        printf("No mouse driver installed!!\n");
        exit(1);
        }
   sndyes=install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL);

   /* Set sprite x & y values */
   spritex[I_LEGR]=spritex[Z_LEGRBLOOD1]=spritex[Z_LEGRBLOOD2]=117;
   spritey[I_LEGR]=spritey[Z_LEGRBLOOD1]=spritey[Z_LEGRBLOOD2]=149;

   spritex[H_LEGL]=spritex[Z_LEGLBLOOD1]=spritex[Z_LEGLBLOOD2]=39;
   spritey[H_LEGL]=spritey[Z_LEGLBLOOD1]=spritey[Z_LEGLBLOOD2]=140;

   spritex[G_HEAD]=spritex[Z_HEADBLOOD1]=spritex[Z_HEADBLOOD2]=110;
   spritey[G_HEAD]=spritey[Z_HEADBLOOD1]=spritey[Z_HEADBLOOD2]=7;

   spritex[A_ARMR]=spritex[Z_ARMRBLOOD1]=spritex[Z_ARMRBLOOD2]=185;
   spritey[A_ARMR]=spritey[Z_ARMRBLOOD1]=spritey[Z_ARMRBLOOD2]=67;

   spritex[C_ARML]=spritex[Z_ARMLBLOOD1]=spritex[Z_ARMLBLOOD2]=75;
   spritey[C_ARML]=spritey[Z_ARMLBLOOD1]=spritey[Z_ARMLBLOOD2]=9;

            /* No blood spewing because of body falling, so don't
               initialize Z_BODYBLOOD#!  It doesn't exist! */

   spritex[B_BODY]=69;
   spritey[B_BODY]=56;

   /* Set sprite width and height values */
   spritew[I_LEGR]=74;    spriteh[I_LEGR]=30;
   spritew[H_LEGL]=71;    spriteh[H_LEGL]=40;
   spritew[G_HEAD]=101;   spriteh[G_HEAD]=59;
   spritew[A_ARMR]=43;    spriteh[A_ARMR]=51;
   spritew[C_ARML]=38;    spriteh[C_ARML]=66;
   spritew[B_BODY]=160;   spriteh[B_BODY]=93;

   set_gfx_mode(GFX_VGA, 320, 200, 0, 0);
   barneydat=load_datafile("barney.dat");
   
   if (!barneydat)
        {
        allegro_exit();
        printf("Error loading barney.dat!");
        exit(1);
        }

   set_pallete(barneydat[D_BARNEYPALETTE].dat);

   if (sndyes==0)    /* If sound initialization was successful */
   intro();

   title();         /* do the title screen anyhoo.. */

   mousecur=F_CROSSHAIR;

   set_mouse_sprite(barneydat[mousecur].dat);
   set_mouse_sprite_focus(12,12);

 
   /* allocate the memory buffer */
   buffer = create_bitmap(SCREEN_W, SCREEN_H);
   
   /* Hide mouse so we don't draw on top of it */
   show_mouse(NULL);

   while(!key[KEY_ESC])
   {
   clear(buffer);

   for (cnt=0;cnt<9;cnt++)
        {

        if (spritey[lookup[cnt]]<spritey[cnt] && lookup[cnt] != NULL)
        /* if corresponding limb has dropped */
               draw_sprite(buffer, barneydat[lookup[cnt]+bloodcnt].dat,spritex[lookup[cnt]],spritey[lookup[cnt]]);

        if (limbfall[cnt]==1)
                {
                limbturn[cnt]+=8;
                spritey[cnt]+=4;

                rotate_sprite(buffer,barneydat[cnt].dat,spritex[cnt],spritey[cnt],itofix(limbturn[cnt]));
                if (spritey[cnt]+spriteh[cnt]>200)
                    limbfall[cnt]=0;
                if (limbturn[cnt]==256)
                    limbturn[cnt]=0;
                }
         else
                /* if they're sprites, draw em! */
                if (cnt!=D_BARNEYPALETTE && cnt!=E_BLOOD && cnt!=F_CROSSHAIR)
                    {
                    draw_sprite(buffer,barneydat[cnt].dat, spritex[cnt], spritey[cnt]);
                    }      

         }
      
   if (mouse_b & 1)  /* Left mouse button */
          {
          play_sample(barneydat[Z_SND_GUN].dat,50,128,1001,0);
          for (cnt=0;cnt<9;cnt++)
               {
               if(cnt==D_BARNEYPALETTE || cnt==E_BLOOD || cnt==F_CROSSHAIR)
                    continue;

               if (mouse_x<spritex[cnt] || mouse_x>spritex[cnt]+spritew[cnt] || mouse_y<spritey[cnt] || mouse_y>spritey[cnt]+spriteh[cnt])
                    continue;

               if (cnt==B_BODY)
                    {
                    play_sample(barneydat[Z_SND_SCREAM].dat,50,128,1001,0);
                    draw_sprite(barneydat[B_BODY].dat, barneydat[E_BLOOD].dat,mouse_x-spritex[B_BODY]-7,mouse_y-spritey[B_BODY]-7);
                    }
               else
                    {
                    play_sample(barneydat[Z_SND_SCREAM].dat,50,128,1001,0);
                    limbfall[cnt]=1;
                    }
               break;
               }
           }
   /* show mouse for screen update */

   show_mouse(buffer);
   
   /* Blit to screen */
   blit(buffer, screen, 0,0,0,0,SCREEN_W,SCREEN_H);
     
   /* Hide mouse so we don't draw on top of it */
   show_mouse(NULL);

   /* Toggle bloodcnt */
   if (bloodcnt==1)
        bloodcnt=0;
   else
        bloodcnt=1;
    
   /* Wait 1/20 of a second */
   rest(50);
   }

   destroy_bitmap(buffer);

   remove_mouse();
   unload_datafile(barneydat);

   exit(0);
}
