#include <stdio.h>
#include <string.h>
#include <fcntl.h>


#ifndef MSDOS
#include <sys/file.h>
#endif

#define VERSION "4.00"

#define EMSIZE 8192   /* size of editor moves memory      	*/



	    /**** NOTHING TO CHANGE BELOW HERE ****/

/* I wouldn't change these if I were you - it won't give you a bigger screen */
#define ROWLEN 40
#define NOOFROWS 16

/* MSDOS modifications (M001) by Gregory H. Margo	*/
#ifdef	MSDOS
#define	R_BIN	"rb"	/* binary mode for non-text files */
#define	W_BIN	"wb"

#define	ASKNAME		/* ask user's name if not in environment 	*/
#ifndef TOS
#define	COMPARE_BY_NAME	/* compare users with name, not uid		*/
#undef	getchar		/* remove stdio's definition to use curses' 	*/
#define	getchar()	getch()	/* use curse's definition instead */
#endif	/* not TOS */

#else /* not MSDOS */
#define	R_BIN	"r"
#define	W_BIN	"w"
#define	VOIDSTAR
#endif

/* Save and Restore game additions (M002) by Gregory H. Margo	*/
/* mon_rec structure needed by save.c */
struct mon_rec {
    int x,y,mx,my;
    char under;
    struct mon_rec *next,*prev;
};

struct save_vars {
    int z_x, z_y,
	z_sx, z_sy,
	z_tx, z_ty,
	z_mx, z_my,
	z_diamonds,
	z_nf;
};

struct old_save_vars {
    int z_x, z_y,
	z_nx, z_ny,
	z_sx, z_sy,
	z_tx, z_ty,
	z_lx, z_ly,
	z_mx, z_my,
	z_bx, z_by,
	z_nbx, z_nby,
	z_max_score,
	z_diamonds,
	z_nf,
	z_hd,
	z_vd,
	z_xdirection,
	z_ydirection;
};

/* prototypes added by Gregory H. Margo */
#ifdef	LINT_ARGS	/* M001 */
/* DISPLAY.c */
extern  void map(char (*)[ROWLEN+1]);
extern  void display(int, int, char (*)[ROWLEN+1]);
extern char readtext(char *, int, int, int, int);
extern  char notify_end_game();

/* EDIT.C */
extern  void instruct(void);
extern  void noins(void);
extern  void editscreen(int, long *, int *, int, char *);

/* FALL.C */
extern  int check(int *, int *, int, int, int, int, int, int, char *);
extern  int fall(int *, int *, int, int, int, int, char *);

/* GAME.C */
extern  struct mon_rec *make_monster(int, int);
extern  char *playscreen(int *, long *, int *, int, char *);

/* ICON.C */
extern  void draw_symbol(int, int, int);

/* JUMP.C */
extern  void scrn_passwd(int, char *);
extern  void showpass(int);
extern  int jumpscreen(int);
extern  int getnum(void);

/* READ.C */
extern  int rscreen(int, int *);
extern  int wscreen(int, int);

/* SAVE.C */
extern  void save_game(int, long *, int *, int);
extern  int restore_game(int *, long *, int *, int *);

/* SCORES.C */
extern  int savescore(char *, long, int, char *);
extern  void delete_entry(int);
extern  int erase_scores(void);

#else

/* DISPLAY.c */
extern  void map();
extern  void display();
extern  char notify_end_game();
extern char readtext();

/* EDIT.C */
extern  void instruct();
extern  void noins();
extern  void editscreen();

/* FALL.C */
extern  int check();
extern  int fall();

/* GAME.C */
extern  struct mon_rec *make_monster();
extern  char *playscreen();

/* ICON.C */
extern  void draw_symbol();

/* JUMP.C */
extern  void scrn_passwd();
extern  void showpass();
extern  int jumpscreen();
extern  int getnum();

/* READ.C */
extern  int rscreen();
extern  int wscreen();

/* SAVE.C */
extern  void save_game();
extern  int restore_game();

/* SCORES.C */
extern  int savescore();
extern  void delete_entry();
extern  int erase_scores();

#endif

/* for monster movement */

#define viable(x,y) (((lscreen[y][x] == ' ') || (lscreen[y][x] == ':') ||\
	(lscreen[y][x] == '@') || (lscreen[y][x] == '+') ||\
	(lscreen[y][x] == 'S')) && (y >= 0) &&\
	(x >= 0) && (y < NOOFROWS) && (x < ROWLEN))
