Unit SBlaster;
{ Unit to init/deinit soundblaster and to play midi/digital sound }

interface

{$L MidPak}
{$L DigPak}
{$L MidAdv}
{$L MidAd}

Uses Dos,Crt;

Type TSound = Record
       Sound : Pointer;
       Len : Word;
       IsPlaying : ^Word;
       Freq : Word;
     End;

Procedure SetMidi(BaseAddr,Irq,DMA : Word);
{ This procedure !#MUST#! be called before InitMidi }
Procedure SetDigital(BaseAddr,Irq,DMA : Word);
{ This procedure !#MUST#! be called before InitDigital }
Procedure InitMidi;
Procedure RegisterXMidi(Midi : Pointer;Len : LongInt);
Procedure PlaySequence(Seq : Word);
Procedure SegueSequence(Seq,Act : Word);
Procedure MidiStop;
Procedure ResumePlaying;
Function SeqStatus(Seq : Word) : Word;
Function RelVolume : Word;
Procedure SetRelVolume(Vol : Word;Time : Word);
Procedure InitDigital;
Procedure MassageAudio(Snd : Pointer);
Procedure DigPlay2(Snd : Pointer);
Procedure StopDigital;
Function IsDig : Boolean;
Procedure DoneMidi;
Procedure DoneDigital;

implementation
Type TMidPak = Array[0..13455+$10] of byte;
     TDigPak = Array[0..4559+$10] of byte;
     TMidAdv = Array[0..14742+$10] of byte;
     TMidAd = Array[0..3621+$10] of byte;
     TWord = Record Low,Hi : Byte; End;
     TLong = Record Low,Hi : Word; End;

Var
MidPakP : ^TMidPak;
DigPakP : ^TDigPak;
MidAdvP : ^TMidAdv;
MidAdP : ^TMidAd;

Procedure MidPak; far; external;
Procedure DigPak; far; external;
Procedure MidAd; far; external;
Procedure MidAdv; far; external;

Procedure SetMidi(BaseAddr,Irq,DMA : Word);
Begin
  MidPakP^[$106]:=TWord(BaseAddr).Low;
  MidPakP^[$107]:=TWord(BaseAddr).Hi;
  MidPakP^[$108]:=TWord(Irq).Low;
  MidPakP^[$109]:=TWord(Irq).Hi;
  MidPakP^[$110]:=TWord(DMA).Low;
  MidPakP^[$111]:=TWord(DMA).Hi;
End;

Procedure SetDigital(BaseAddr,Irq,DMA : Word);
Begin
  DigPakP^[$106]:=TWord(BaseAddr).Low;
  DigPakP^[$107]:=TWord(BaseAddr).Hi;
  DigPakP^[$108]:=TWord(Irq).Low;
  DigPakP^[$109]:=TWord(Irq).Hi;
  DigPakP^[$110]:=TWord(DMA).Low;
  DigPakP^[$111]:=TWord(DMA).Hi;
End;

Procedure InitMidi;
Var M : Procedure;
R : Registers;
Begin
  @M:=Ptr(Seg(MidPakP^)-$10,$200);
  M;
  R.ax:=$710;
  R.bx:=Seg(MidAdvP^);
  R.cx:=0;
  R.dx:=Seg(MidAdP^);
  R.si:=0;
  Intr($66,R);
End;

Procedure RegisterXMidi(Midi : Pointer;Len : LongInt);
Var R : Registers;
Begin
  R.ax:=$704;
  R.cx:=Seg(Midi^);
  R.bx:=Ofs(Midi^);
  R.si:=TLong(Len).Low;
  R.di:=TLong(Len).Hi;
  Intr($66,R);
End;

Procedure PlaySequence(Seq : Word); assembler;
Asm
  mov ax,$702
  mov bx,Seq
  int $66
End;

Procedure SegueSequence(Seq,Act : Word); assembler;
Asm
  mov ax,$703
  mov bx,Seq
  mov cx,Act
  int $66
End;

Procedure MidiStop; assembler;
Asm
  mov ax,$705
  int $66
End;

Procedure ResumePlaying; assembler;
Asm
  mov ax,$70B
  int $66
End;

Function SeqStatus(Seq : Word) : Word; assembler;
Asm
  mov ax,$70C
  int $66
End;

Function RelVolume : Word; assembler;
Asm
  mov ax,$70E
  int $66
End;

Procedure SetRelVolume(Vol : Word;Time : Word); assembler;
Asm
  mov ax,$70F
  mov bx,Vol
  mov cx,Time
End;

Procedure DoneMidi;
Var M : Procedure;
Begin
  @M:=Ptr(Seg(MidPakP^)-$10,$203);
  M;
  Dispose(MidAdvP);
  Dispose(MidAdP);
  Dispose(MidPakP);
End;

Procedure InitDigital;
Var M : Procedure;
Begin
  @M:=Ptr(Seg(DigPakP^)-$10,$200);
  M;
End;

Procedure MassageAudio(Snd : Pointer);
Var R : Registers;
Begin
  R.ax:=$68A;
  R.ds:=Seg(Snd^);
  R.si:=Ofs(Snd^);
  Intr($66,R);
End;

Procedure DigPlay2(Snd : Pointer);
Var R : Registers;
Begin
  R.ax:=$68B;
  R.ds:=Seg(Snd^);
  R.si:=Ofs(Snd^);
  Intr($66,R);
End;

Function IsDig : Boolean; assembler;
Asm
  mov ax,$689
  int $66
End;

Procedure StopDigital; assembler;
Asm
  mov ax,$68F
  int $66
End;

Procedure DoneDigital;
Var M : Procedure;
Begin
  @M:=Ptr(Seg(DigPakP^)-$10,$203);
  M;
  Dispose(DigPakP);
End;

Begin
  New(MidPakP);
  MidPakP:=Ptr(Seg(MidPakP^)+1,0);
  Move(Ptr(Seg(MidPak),Ofs(MidPak))^,MidPakP^,SizeOf(MidPakP^));
  New(MidAdvP);
  MidAdvP:=Ptr(Seg(MidAdvP^)+1,0);
  Move(Ptr(Seg(MidAdv),Ofs(MidAdv))^,MidAdvP^,SizeOf(MidAdvP^));
  New(MidAdP);
  MidAdP:=Ptr(Seg(MidAdP^)+1,0);
  Move(Ptr(Seg(MidAd),Ofs(MidAd))^,MidAdP^,SizeOf(MidAdP^));
  New(DigPakP);
  DigPakP:=Ptr(Seg(DigPakP^)+1,0);
  Move(Ptr(Seg(DigPak),Ofs(DigPak))^,DigPakP^,SizeOf(DigPakP^));
End.