' Towers of Hanoi

DEFINT A-Z

DECLARE SUB initialize ()
DECLARE SUB Display ()
DECLARE SUB Refresh ()
DECLARE SUB Move (d, t)
DECLARE SUB Intro ()
DECLARE SUB Pause ()
DECLARE SUB MainGame ()
DECLARE SUB LoadMouse ()
DECLARE SUB MouseDriver (AX%, bx%, cx%, dx%)
DECLARE SUB MouseStatus (lb%, rb%, Xmouse%, Ymouse%)

DECLARE FUNCTION Topof (tower)
DECLARE FUNCTION MouseInit% ()
DECLARE FUNCTION Selected ()

CONST false = 0
CONST true = NOT false

DIM SHARED disc(10)
DIM SHARED top(3)
DIM SHARED mouse$
DIM SHARED active
DIM SHARED moves
DIM SHARED bailout
DIM SHARED max

CLS

initialize
Intro


COLOR 15

RESTORE
mouse$ = SPACE$(57)
FOR i% = 1 TO 57
  READ a$
  H$ = CHR$(VAL("&H" + a$))
  MID$(mouse$, i%, 1) = H$
NEXT i%

MouseData:
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

SUB Display

  FOR a = 1 TO 3
    top(a) = 21
  NEXT a

  offset = -10 - max
  i = 20 - max * 2
  j = 21 - max * 2

  e$ = STRING$(max, 32) + CHR$(179) + STRING$(max, 32)

  FOR a = max TO 1 STEP -1
    COLOR 9
    LOCATE a * 2 + i, offset + 25: PRINT e$
    LOCATE a * 2 + j, offset + 25: PRINT e$
    COLOR 12
    LOCATE a * 2 + i, offset + 50: PRINT e$
    LOCATE a * 2 + j, offset + 50: PRINT e$
    COLOR 10
    LOCATE a * 2 + i, offset + 75: PRINT e$
    LOCATE a * 2 + j, offset + 75:

PRINT e$
   
    COLOR 13
    t = disc(a)
    b$ = STRING$(max - a, 32)
    a$ = b$ + STRING$(a * 2 + 1, 219) + b$
    LOCATE top(t), t * 25 + offset
    PRINT a$
    top(t) = top(t) - 2
  NEXT a
 
  b$ = STRING$(max + 1, 196) + CHR$(193) + STRING$(max + 1, 196)
  COLOR 9: LOCATE 22, offset + 24: PRINT b$
  COLOR 12: LOCATE 22, offset + 49: PRINT b$
  COLOR 10: LOCATE 22, offset + 74: PRINT b$

  COLOR 15
  LOCATE 1, 1: PRINT "Moves ="; moves
  LOCATE 2, 1: PRINT "Min   ="; 2 ^ max - 1
END SUB

' Initialize
'
' Initialization subroutine.
' Set all disks to the first tower.
' Load the mouse driver.
'
SUB initialize

  moves = 0
  FOR a = 1 TO max
    disc(a) = 1
  NEXT a
  IF active = false THEN LoadMouse

END SUB

SUB Intro

  max = 5
 
  DO
    CLS
    COLOR 15

    PRINT "Towers of Hanoi"
    PRINT
    IF active = true THEN PRINT "Mouse Detected"
   
    LOCATE 4, 1
    PRINT "Skill (+/-) ="; max; " "
    PRINT
    PRINT "(A)utomatic"
    PRINT "(M)anual"
    PRINT "(I)nstructions"
    PRINT "(Q)uit"

    valid = false
    DO
      choice$ = UCASE$(INKEY$)
     
      IF choice$ = CHR$(27) THEN choice$ = "Q"
      IF choice$ = CHR$(61) THEN choice$ = "+"
      IF choice$ = "+" AND max < 10 THEN max = max + 1
      IF choice$ = "-" AND max > 2 THEN max = max - 1
      LOCATE 4, 1
      PRINT "Skill (+/-) ="; max; " "
     
      IF choice$ = "Q" THEN valid = true
      IF choice$ = "A" THEN valid = true
      IF choice$ = "M" THEN valid = true
      IF choice$ = "I" THEN valid = true

    LOOP WHILE valid = false

    IF choice$ = "A" THEN
      CLS
      initialize
      Display
      bailout = false
      Pause
      IF bailout = false THEN
        Move max, 3
        IF bailout = false THEN WHILE INKEY$ <> CHR$(27): WEND
      END IF
    END IF

    IF choice$ = "M" THEN
      MainGame
    END IF

    IF choice$ = "I" THEN
      LOCATE 12, 1
    END IF

  LOOP UNTIL choice$ = "Q"

END SUB

SUB LoadMouse

  RESTORE MouseData
  mouse$ = SPACE$(57)
  FOR i% = 1 TO 57
    READ a$
    H$ = CHR$(VAL("&H" + a$))
    MID$(mouse$, i%, 1) = H$
  NEXT i%

  a = MouseInit

'  DO
'    MouseStatus lb%, RB%, Xmouse%, Ymouse%
'    LOCATE 5, 1
'    PRINT "Mouse STUFF:  LB:"; lb%, "RB:"; RB%, "X:"; Xmouse%, "Y:"; Ymouse%
'  LOOP

END SUB

' MainGame
'
' User plays. First select block to take. Then tower to place on.
'
SUB MainGame

  initialize
  CLS
  Display

  gameplay = true
  DO
    Tfrom = 0
    Tdrop = 0
    DO
      WHILE Tfrom = 0
        Tfrom = Selected
        IF Tfrom = -1 THEN Tfrom = 0
        a$ = ""
        IF Tfrom = 0 THEN
          a$ = INKEY$
          Tfrom = INT(VAL(a$))
        END IF
        IF Tfrom > 3 THEN Tfrom = 0
        IF a$ = CHR$(27) THEN
          Tfrom = 4
          Tdrop = 4
          gameplay = 0
        END IF
      WEND
      IF gameplay = true THEN LOCATE 23, Tfrom * 25 - 17: PRINT "* Selected *"
      WHILE Tdrop = 0
        Tdrop = Selected
        a$ = ""
        IF Tdrop = 0 THEN
          a$ = INKEY$
          Tdrop = INT(VAL(a$))
          IF a$ = CHR$(8) THEN Tdrop = -1
        END IF
        IF a$ = CHR$(27) THEN
          Tfrom = 4
          Tdrop = 4
          gameplay = 0
        END IF
      WEND

      IF gameplay = true THEN
        IF Tdrop = -1 THEN
          LOCATE 23, 1
          PRINT STRING$(75, 32)
          Tfrom = 0
          Tdrop = 0
        END IF
        IF Topof(Tdrop) <= Topof(Tfrom) THEN Tdrop = 0
        IF Topof(Tfrom) = max + 1 THEN Tdrop = 0
      END IF
    
    LOOP UNTIL (Tfrom > 0) AND (Tdrop > 0)

    ' Move the piece
    IF gameplay = true THEN
      disc(Topof(Tfrom)) = Tdrop
      LOCATE 23, 1: PRINT STRING$(75, 32)
      moves = moves + 1
      Display
      DO
        MouseStatus lb%, rb%, Xmouse%, Ymouse%
      LOOP UNTIL lb% = 0
    END IF

   ' Test for a win
   test = true
   FOR a = 1 TO max
     IF disc(a) <> 3 THEN test = false
   NEXT a
   IF test = true THEN
     LOCATE 23, 30: PRINT "Congratulations - You Win"
     WHILE INKEY$ <> CHR$(27): WEND
     gameplay = false
   END IF
   
  LOOP WHILE gameplay = true

END SUB

' MouseDriver
'
' Subroutine to push four registers into the machine code subroutine.
'
SUB MouseDriver (AX%, bx%, cx%, dx%)
  DEF SEG = VARSEG(mouse$)
  mouse% = SADD(mouse$)
  CALL Absolute(AX%, bx%, cx%, dx%, mouse%)
END SUB

' MouseInit
'
' Call machine subroutine to initialize mouse.
' If initialization is succesful call routine to display cursor.
' Return whether the initialization was succesful.
'
FUNCTION MouseInit%
  AX% = 0
  MouseDriver AX%, 0, 0, 0
  MouseInit% = AX%
 
  active = false
  IF AX% THEN
    active = true
    AX% = 1
    MouseDriver AX%, 0, 0, 0
  END IF

END FUNCTION

' MouseStatus (lb%, RB%, Xmouse%, Ymouse%)
'
' Subroutine to return the current position and
' button status of the mouse.
'
' lb% = Left button status
' rb% = Right button status
' Xmouse% = X Position of mouse
' Ymouse% = Y Position of mouse
'
'
SUB MouseStatus (lb%, rb%, Xmouse%, Ymouse%)
  AX% = 3
  MouseDriver AX%, bx%, cx%, dx%
  lb% = ((bx% AND 1) <> 0)
  rb% = ((bx% AND 2) <> 0)
  Xmouse% = INT(cx% / 8)
  Ymouse% = INT(dx% / 8)
END SUB

' Move (d, t)
'
' A recursive algorith to move a particular disk from one tower
' to another. If this is the smallest disk then move directly.
' Else call this subroutine to move the disk above to the spare
' tower, move the disc to the desired tower then move the disc
' above on top, once again with by calling this same subroutine.
'
' d = disc to move
' t = destination tower
'
SUB Move (d, t)

  IF d = 1 THEN
    disc(d) = t
    Refresh
  ELSE
    
    f = disc(d)
    i = 0
    test = f * 4 + t
    IF test = 11 OR test = 14 THEN i = 1
    IF test = 7 OR test = 13 THEN i = 2
    IF test = 6 OR test = 9 THEN i = 3

    Move d - 1, i
    IF bailout = false THEN
      disc(d) = t
      Refresh
      IF bailout = false THEN Move d - 1, t
    END IF
  END IF

END SUB

' Pause
'
' Wait for a user to prompt for the computer to make the next move.
' First LOOP is to prevent button bounce. Second waits for user input.
' Note that button bounce only applies to the left button.
' The right button may be used for rapid viewing.
'
SUB Pause

  DO
    MouseStatus lb%, rb%, Xmouse%, Ymouse%
  LOOP UNTIL lb% = 0

  DO
    a$ = INKEY$
    MouseStatus lb%, rb%, Xmouse%, Ymouse%
  LOOP WHILE (a$ = "" AND lb% = 0 AND rb% = 0)
  IF a$ = CHR$(27) THEN bailout = true

END SUB

' Refresh
'
' An intermediate subroutine between automatic moves.
' Increase the move counter by one.
' Calls the display subroutine.
' Waits until the next move is to be made
'
SUB Refresh

  moves = moves + 1
  Display
  Pause
 
END SUB

' Selected
'
' Determine which, if any, tower has been selected.
' Return -1 if the right button is clicked.
'
FUNCTION Selected

  flag = 0

  MouseStatus lb%, rb%, Xmouse%, Ymouse%
  IF lb% <> 0 THEN
    flag = 2
    IF Xmouse < 29 THEN flag = 1
    IF Xmouse > 51 THEN flag = 3
  END IF
  IF rb% <> 0 THEN flag = -1

  Selected = flag

END FUNCTION

' Topof (tower)
'
' Scan the disks to find which is on top of a particular stack
' If the stack is empty, returns MAX+1 so that any disc can be placed there.
'
'  tower = tower to test
'
FUNCTION Topof (tower)

  IF tower > 0 THEN
    flag = max + 1
    FOR a = max TO 1 STEP -1
      IF disc(a) = tower THEN flag = a
    NEXT a
  ELSE
    IF tower = 0 THEN flag = max + 1
    IF tower = -1 THEN flag = max + 2
  END IF
 
  Topof = flag

END FUNCTION
