'$DYNAMIC
'$INCLUDE: 'graph13.bi'

DECLARE SUB LoadGeneralData ()
DECLARE SUB LoadMainPalet ()
DECLARE SUB DrawField ()
DECLARE SUB Quit ()
DECLARE SUB PlayGame ()
DECLARE SUB Intro ()
DECLARE SUB Menu ()
DECLARE SUB MakeMoves ()
DECLARE SUB CheckInput ()
DECLARE SUB MoveBlock (dir AS INTEGER, n AS INTEGER)
DECLARE FUNCTION MoveBlkPossible% (dir AS INTEGER, n AS INTEGER)
DECLARE SUB InitNewBlock (n AS INTEGER)
DECLARE SUB RotateBlock (dir AS INTEGER, n AS INTEGER)
DECLARE SUB UpdateField (n AS INTEGER)
DECLARE SUB InitNewPlay ()

'subs en functies uit Text13.bas
DECLARE SUB ExchangeFont (FONTtoLOAD$)
DECLARE SUB WriteText (Text$, x%, y%, col%)
DECLARE FUNCTION TextSize% (Text$)
DECLARE SUB DrawButton (x%, y%, Breedte%, Hoogte%, Status%)
DECLARE SUB TextButton (x%, y%, t$, Status%)
DECLARE FUNCTION Choise% (x%, y%, PickList$)
DECLARE FUNCTION KeyPressed% ()

'subs en functies uit Scrollie.bas
DECLARE SUB ScreenEffect (n AS INTEGER)
DECLARE SUB ScrollText (ScrollMessage$, y0 AS INTEGER)
DECLARE SUB GetScrollFontData ()

CONST TRUE = -1
CONST FALSE = 0
CONST Down = -80
CONST Up = -72
CONST PgDwn = -81
CONST PgUp = -73
CONST Home = -71
CONST EndLn = -79
CONST Left = -75
CONST Right = -77
CONST Enter = 13
CONST Esc = 27
CONST Sp = 32
CONST Tb = 9
CONST Back = 8
CONST F1 = -59, F2 = -60, F3 = -61, F4 = -62, F5 = -63, F6 = -64


CONST XBlockSize = 8
CONST YBlockSize = 8
CONST XMinBlockScreen = 0
CONST XMaxBlockScreen = 15
CONST YMinBlockScreen = 0
CONST YMaxBlockScreen = 20
CONST XpMin1 = 79
CONST XpMax1 = XpMin1 + (XMaxBlockScreen + 1) * XBlockSize - 1
CONST YpMin1 = 9
CONST YpMax1 = YpMin1 + (YMaxBlockScreen + 1) * YBlockSize - 1
CONST XpMinp1 = 20
CONST XpMaxp1 = XpMinp1 + (XMaxBlockScreen + 1) * XBlockSize - 1
CONST YpMinp1 = 9
CONST YpMaxp1 = YpMax1
CONST XpMinp2 = 170
CONST XpMaxp2 = XpMinp2 + (XMaxBlockScreen + 1) * XBlockSize - 1
CONST YpMinp2 = 9
CONST YpMaxp2 = YpMaxp1
CONST DataBytesBlk = XBlockSize * YBlockSize
CONST RealBytesBlk = XBlockSize * YBlockSize + 4
CONST RealWordsBlk = RealBytesBlk \ 2

TYPE Block
  x AS INTEGER
  y AS INTEGER
  Sort AS INTEGER
  Rotation AS INTEGER
END TYPE

DIM BlkSpr(0 TO RealWordsBlk - 1, 0 TO 2) AS INTEGER
DIM BlkFormData(0 TO 3, 0 TO 3, 1 TO 4, 1 TO 7) AS INTEGER  'xdata\y\draaiingen\soorten
DIM BlkField(XMinBlockScreen TO XMaxBlockScreen, YMinBlockScreen TO YMaxBlockScreen, 1 TO 2) AS INTEGER
DIM CurBlk(1 TO 2) AS Block
DIM NextBlk(1 TO 2) AS Block
DIM GameOver AS INTEGER
DIM Lifes AS INTEGER
DIM Score AS INTEGER
DIM Speed AS INTEGER
DIM ScoredXNumLines(1 TO 4) AS INTEGER
DIM PlayerMode AS INTEGER

DIM SHARED XpMin(1 TO 2) AS INTEGER, YpMin(1 TO 2) AS INTEGER
DIM SHARED XpMax(1 TO 2) AS INTEGER, YpMax(1 TO 2) AS INTEGER
DIM SHARED DirDx(0 TO 4) AS INTEGER
DIM SHARED DirDy(0 TO 4) AS INTEGER
 DirDx(0) = 0: DirDy(0) = 0  'direction 0 bestaat alleen zodat ik MoveBlock
 'ook kan gebruiken om het blok opnieuw te tekenen bij bijvoorbeeld een rotatie
 DirDx(1) = 0: DirDy(1) = -1
 DirDx(2) = 1: DirDy(2) = 0
 DirDx(3) = 0: DirDy(3) = 1
 DirDx(4) = -1: DirDy(4) = 0


 RANDOMIZE TIMER

 
 LoadGeneralData
 Intro

 DO
   Menu
 LOOP


END

REM $STATIC
SUB CheckInput
 SHARED GameOver AS INTEGER
 SHARED PlayerMode AS INTEGER
 DIM n AS INTEGER


 IF PlayerMode = 1 THEN
    
     SELECT CASE KeyPressed%
        CASE Esc:
            GameOver = -1
        CASE 43: 'plus ingedrukt: roteer naar rechts
            RotateBlock 1, 1
        CASE Enter: 'roteer naar links
            RotateBlock -1, 1
        CASE Down:
            IF MoveBlkPossible%(3, 1) THEN MoveBlock 3, 1
            'DO
            '  IF MoveBlkPossible%(3, 1) THEN
            '    MoveBlock 3, 1
            '  ELSE
            '    UpdateField 1
            '    InitNewBlock 1
            '    EXIT DO
            '  END IF
            'LOOP
        CASE Left:
            IF MoveBlkPossible%(4, 1) THEN MoveBlock 4, 1
        CASE Right:
            IF MoveBlkPossible%(2, 1) THEN MoveBlock 2, 1
     END SELECT

 ELSE

     SELECT CASE KeyPressed%
        CASE Esc:
            GameOver = -1

        'keys for player 1
        CASE 97, 65: '"a" -> move block to the left
            IF MoveBlkPossible%(4, 1) THEN MoveBlock 4, 1
        CASE 115, 83:  '"s" -> move block down
            IF MoveBlkPossible%(3, 1) THEN MoveBlock 3, 1
        CASE 100, 68:  '"d" -> move block right
            IF MoveBlkPossible%(2, 1) THEN MoveBlock 2, 1
        CASE 121, 89: '"y" ->  rotate to the right
            RotateBlock 1, 1
        CASE 116, 84: '"t" -> rotate to the left
            RotateBlock -1, 1
       
        'keys for player 2
        CASE 43: '+ pressed: rotate to the right
            RotateBlock 1, 2
        CASE Enter: 'rotate to the left
            RotateBlock -1, 2
        CASE Down:
            IF MoveBlkPossible%(3, 2) THEN MoveBlock 3, 2
        CASE Left:
            IF MoveBlkPossible%(4, 2) THEN MoveBlock 4, 2
        CASE Right:
            IF MoveBlkPossible%(2, 2) THEN MoveBlock 2, 2
     END SELECT

 END IF

END SUB

SUB DrawField
 SHARED PlayerMode AS INTEGER

 SHELL "mapview tetrisbg.map"
 IF PlayerMode = 1 THEN
   LINE (XpMin1, YpMin1)-(XpMax1, YpMax1), 0, BF
   LINE (XpMin1 - 1, YpMin1 - 1)-(XpMax1 + 1, YpMax1 + 1), 15, B
   LINE (XpMax1 + 30, YpMin1)-STEP(4 * XBlockSize, 4 * YBlockSize), 0, BF
   LINE (XpMax1 + 29, YpMin1 - 1)-STEP(4 * XBlockSize + 2, 4 * YBlockSize + 2), 15, B
   LINE (XpMax1 + 29, YpMax1 - 11)-STEP(4 * XBlockSize + 2, 11), 15, B
   LINE (XpMax1 + 30, YpMax1 - 10)-STEP(4 * XBlockSize, 9), 0, BF
   WriteText "0", XpMax1 + 55, YpMax1 - 10, 7
 ELSEIF PlayerMode = 2 THEN
   LINE (XpMinp1, YpMinp1)-(XpMaxp1, YpMaxp1), 0, BF
   LINE (XpMinp1 - 1, YpMinp1 - 1)-(XpMaxp1 + 1, YpMaxp1 + 1), 15, B
   LINE (XpMinp2, YpMinp2)-(XpMaxp2, YpMaxp2), 0, BF
   LINE (XpMinp2 - 1, YpMinp2 - 1)-(XpMaxp2 + 1, YpMaxp2 + 1), 15, B
 END IF

END SUB

SUB InitNewBlock (n AS INTEGER)

 SHARED CurBlk() AS Block
 SHARED NextBlk() AS Block
 SHARED BlkFormData() AS INTEGER
 SHARED BlkSpr() AS INTEGER
 SHARED GameOver AS INTEGER
 SHARED BlkField() AS INTEGER
 SHARED PlayerMode AS INTEGER
 
 DIM dxb AS INTEGER, dyb AS INTEGER


  CurBlk(n) = NextBlk(n)

  NextBlk(n).Sort = 1 + INT(RND * 7)
  NextBlk(n).Rotation = 1 + INT(RND * 4)
  NextBlk(n).y = YMinBlockScreen
  NextBlk(n).x = XMinBlockScreen + ((XMaxBlockScreen - XMinBlockScreen) \ 2)
  FOR dyb = 0 TO 3
  FOR dxb = 0 TO 3
     IF BlkFormData(dxb, dyb, CurBlk(n).Rotation, CurBlk(n).Sort) > 0 THEN
        IF BlkField(CurBlk(n).x + dxb, CurBlk(n).y + dyb, n) > 0 THEN GameOver = n
        PsetSprite XpMin(n) + XBlockSize * (CurBlk(n).x + dxb), YpMin(n) + YBlockSize * (CurBlk(n).y + dyb), BlkSpr(0, n)
     END IF
  NEXT dxb
  NEXT dyb
 

 IF PlayerMode = 1 THEN
   FOR dyb = 0 TO 3
   FOR dxb = 0 TO 3
     PsetSprite XpMax(1) + 30 + XBlockSize * dxb, YpMin(1) + YBlockSize * dyb, BlkSpr(0, BlkFormData(dxb, dyb, NextBlk(1).Rotation, NextBlk(1).Sort))
   NEXT dxb
   NEXT dyb
 END IF


END SUB

SUB InitNewPlay
 SHARED GameOver AS INTEGER
 SHARED Score AS INTEGER
 SHARED Speed AS INTEGER
 SHARED BlkField() AS INTEGER
 SHARED NextBlk() AS Block
 SHARED ScoredXNumLines() AS INTEGER
 SHARED PlayerMode AS INTEGER

 DIM n AS INTEGER
 DIM dxb AS INTEGER, dyb AS INTEGER
 DIM a$

 IF PlayerMode = 1 THEN
    XpMin(1) = XpMin1: YpMin(1) = YpMin1
    XpMax(1) = XpMax1: YpMax(1) = YpMax1
 ELSE
    XpMin(1) = XpMinp1: YpMin(1) = YpMinp1
    XpMax(1) = XpMaxp1: YpMax(1) = YpMaxp1
    XpMin(2) = XpMinp2: YpMin(2) = YpMinp2
    XpMax(2) = XpMaxp2: YpMax(2) = YpMaxp2
 END IF
               
 SHELL "mapview tetrisbg.map"
 a$ = "` PRESS ANY KEY TO START `"
 TextButton 160 - TextSize%(a$) \ 2, 85, a$, 0
 DO: LOOP UNTIL INKEY$ = ""
 DO: LOOP UNTIL INKEY$ <> ""

 DrawField

 FOR n = 1 TO PlayerMode

   NextBlk(n).Sort = 1 + INT(RND * 7)
   NextBlk(n).Rotation = 1 + INT(RND * 4)
   NextBlk(n).y = YMinBlockScreen
   NextBlk(n).x = XMinBlockScreen + ((XMaxBlockScreen - XMinBlockScreen) \ 2)
  
   FOR dyb = YMinBlockScreen TO YMaxBlockScreen
    FOR dxb = XMinBlockScreen TO XMaxBlockScreen
      BlkField(dxb, dyb, n) = 0
    NEXT dxb
   NEXT dyb
  
   InitNewBlock n

 NEXT n
  
 GameOver = FALSE
 Score = 0
 Speed = 0
 ScoredXNumLines(1) = 0
 ScoredXNumLines(2) = 0
 ScoredXNumLines(3) = 0
 ScoredXNumLines(4) = 0

END SUB

SUB Intro

DIM ScrollMessage$
DIM x%, y%, t%, n AS INTEGER
DIM c(1 TO 13) AS INTEGER, r(1 TO 13) AS INTEGER, g(1 TO 13) AS INTEGER, B(1 TO 13) AS INTEGER
c(1) = 22: c(2) = 23
FOR n = 3 TO 13: c(n) = 30 + n: NEXT n


SHELL "mapview tetristt.MAP"

FOR n = 1 TO 13
   GetPal c(n), x%, y%, t%
   r(n) = x%
   g(n) = y%
   B(n) = t%
NEXT n


FOR y% = 180 TO 189
 FOR x% = 74 TO 251
  SetPal y% - 178, 0, 0, 0
  IF Point13%(x%, y%) = 0 THEN Pset13 x%, y%, y% - 179
 NEXT x%
NEXT y%

DO: LOOP UNTIL INKEY$ = ""
DO
 FOR n = 1 TO 11
  IF INKEY$ <> "" THEN EXIT SUB
  SetPal n - 1, 0, 0, 0
  SetPal n, 63, 63, 63
  RetraceWait
  RetraceWait
  RetraceWait
 NEXT n
 FOR n = 11 TO 2 STEP -1
  IF INKEY$ <> "" THEN EXIT SUB
  SetPal n + 1, 0, 0, 0
  SetPal n, 63, 63, 63
  RetraceWait
  RetraceWait
  RetraceWait
 NEXT n
LOOP

END SUB

SUB LoadGeneralData
  SHARED BlkSpr()  AS INTEGER
  SHARED BlkFormData() AS INTEGER
 
  DIM m AS INTEGER, n AS INTEGER, Char AS STRING * 1
  DIM x AS INTEGER, y AS INTEGER

    'algemeen
    SCREEN 13
    ExchangeFont "scr13"
    GetScrollFontData
    LoadMainPalet
    MouseInit
   
    OPEN "blok.blk" FOR BINARY AS #1
     FOR m = 1 TO 2
      FOR n = 0 TO RealWordsBlk - 1
        GET #1, , BlkSpr(n, m)
      NEXT n
     NEXT m
    CLOSE #1
    BlkSpr(0, 0) = XBlockSize
    BlkSpr(1, 0) = YBlockSize
   
    FOR m = 1 TO 7
     OPEN "blok_" + LTRIM$(STR$(m)) + ".blk" FOR BINARY AS #1
       FOR n = 1 TO 4
         GET #1, , x: GET #1, , x
         FOR y = 0 TO 3
         FOR x = 0 TO 3
           GET #1, , Char
           BlkFormData(x, y, n, m) = ASC(Char)
         NEXT x
         NEXT y
       NEXT n
     CLOSE #1
    NEXT m

END SUB

SUB LoadMainPalet
 
  DIM col AS INTEGER, r AS INTEGER, g AS INTEGER, B AS INTEGER
  DIM Char AS STRING * 1
    
  OPEN "main.PAL" FOR BINARY AS #1
    FOR col = 0 TO 255
      GET #1, , Char: r = ASC(Char)
      GET #1, , Char: g = ASC(Char)
      GET #1, , Char: B = ASC(Char)
      SetPal col, r, g, B
    NEXT col
  CLOSE #1
 
  'save palette
  'OPEN "main.PAL" FOR BINARY AS #1
  '    FOR col = 0 TO 255
  '      GetPal col, r, g, b
  '      Char = CHR$(r AND 255)
  '      PUT #1, , Char
  '      Char = CHR$(g AND 255)
  '      PUT #1, , Char
  '      Char = CHR$(b AND 255)
  '      PUT #1, , Char
  '    NEXT col
  'CLOSE #1

END SUB

SUB Menu

 SHARED PlayerMode AS INTEGER

 DIM n AS INTEGER

  SHELL "mapview tetrisbg.map"
 
  DO
   n = Choise%(120, 80, "1 PLAYER`2 PLAYERS`QUIT")
  LOOP UNTIL n > 0

  SELECT CASE n
     CASE 1:
             PlayerMode = 1
             PlayGame
     CASE 2:
             PlayerMode = 2
             PlayGame
     CASE 3:
             Quit
  END SELECT
 
END SUB

FUNCTION MoveBlkPossible% (dir AS INTEGER, n AS INTEGER)
 SHARED BlkField() AS INTEGER
 SHARED BlkFormData() AS INTEGER
 SHARED CurBlk() AS Block
 
 DIM dxb AS INTEGER, dyb AS INTEGER

  FOR dyb = 0 TO 3
   FOR dxb = 0 TO 3
      IF BlkFormData(dxb, dyb, CurBlk(n).Rotation, CurBlk(n).Sort) > 0 THEN
        SELECT CASE dir  'blok wil buiten scherm ?
         CASE 2: IF CurBlk(n).x + dxb + 1 > XMaxBlockScreen THEN MoveBlkPossible% = FALSE: EXIT FUNCTION
         CASE 3: IF CurBlk(n).y + dyb + 1 > YMaxBlockScreen THEN MoveBlkPossible% = FALSE: EXIT FUNCTION
         CASE 4: IF CurBlk(n).x + dxb - 1 < XMinBlockScreen THEN MoveBlkPossible% = FALSE: EXIT FUNCTION
        END SELECT
        'raakt blok gevuld gedeelte veld ?
        IF BlkField(CurBlk(n).x + dxb + DirDx(dir), CurBlk(n).y + dyb + DirDy(dir), n) > 0 THEN
          MoveBlkPossible% = FALSE
          EXIT FUNCTION
        END IF
      END IF
   NEXT dxb
  NEXT dyb

  MoveBlkPossible% = TRUE

END FUNCTION

SUB MoveBlock (dir AS INTEGER, n AS INTEGER)

 SHARED BlkFormData() AS INTEGER
 SHARED BlkSpr() AS INTEGER
 SHARED CurBlk() AS Block

 DIM dxb AS INTEGER, dyb AS INTEGER

  'erase 'old' block
  FOR dyb = 0 TO 3
   FOR dxb = 0 TO 3
     IF BlkFormData(dxb, dyb, CurBlk(n).Rotation, CurBlk(n).Sort) > 0 THEN
        PsetSprite XpMin(n) + XBlockSize * (CurBlk(n).x + dxb), YpMin(n) + YBlockSize * (CurBlk(n).y + dyb), BlkSpr(0, 0)
     END IF
   NEXT dxb
  NEXT dyb
 
  'move block
  CurBlk(n).x = CurBlk(n).x + DirDx(dir)
  CurBlk(n).y = CurBlk(n).y + DirDy(dir)

  'draw block on new location
  FOR dyb = 0 TO 3
   FOR dxb = 0 TO 3
     IF BlkFormData(dxb, dyb, CurBlk(n).Rotation, CurBlk(n).Sort) > 0 THEN
        PsetSprite XpMin(n) + XBlockSize * (CurBlk(n).x + dxb), YpMin(n) + YBlockSize * (CurBlk(n).y + dyb), BlkSpr(0, n)
     END IF
   NEXT dxb
  NEXT dyb

END SUB

SUB PlayGame
 SHARED GameOver AS INTEGER
 SHARED Score AS INTEGER
 SHARED Speed AS INTEGER
 SHARED BlkField() AS INTEGER
 SHARED ScoredXNumLines() AS INTEGER
 SHARED PlayerMode AS INTEGER

 DIM n AS INTEGER
 DIM a$

  
  InitNewPlay

  DO
    FOR n = 1 TO (20 - Speed)
      RetraceWait
      CheckInput
    NEXT n
    FOR n = 1 TO PlayerMode
      IF MoveBlkPossible%(3, n) THEN
          MoveBlock 3, n
        ELSE
          UpdateField n
          InitNewBlock n
      END IF
    NEXT n
  LOOP UNTIL GameOver <> 0
  
  IF GameOver = -1 THEN EXIT SUB

  IF PlayerMode = 1 THEN
    DO: LOOP UNTIL INKEY$ = ""
    a$ = "`  YOUR SCORE WAS : " + STR$(Score) + " LINES  `"
    TextButton 160 - TextSize%(a$) \ 2, 85, a$, 0
    DO: LOOP UNTIL INKEY$ = ""
    DO: LOOP UNTIL INKEY$ <> ""
    ScreenEffect 4
   
    SHELL "mapview tetrisbg.map"
    ExchangeFont "tiny"
    n = 1
    WriteText "NUMBER OF TIMES" + STR$(n) + " LINE WAS ERASED   : " + STR$(ScoredXNumLines(n)), 35, 20 + n * 30, 4
    WriteText "NUMBER OF TIMES" + STR$(n) + " LINE WAS ERASED   : " + STR$(ScoredXNumLines(n)), 34, 20 + n * 30, 15
    FOR n = 2 TO 4
        WriteText "NUMBER OF TIMES" + STR$(n) + " LINES WERE ERASED : " + STR$(ScoredXNumLines(n)), 35, 20 + n * 30, 4
        WriteText "NUMBER OF TIMES" + STR$(n) + " LINES WERE ERASED : " + STR$(ScoredXNumLines(n)), 34, 20 + n * 30, 15
    NEXT n
    DO: LOOP UNTIL INKEY$ = ""
    DO: LOOP UNTIL INKEY$ <> ""
    ExchangeFont "scr13"
 
  ELSE

    DO: LOOP UNTIL INKEY$ = ""
    IF GameOver = 1 THEN
      ScrollText "PLAYER 2 WON !!!" + SPACE$(10), 183
    ELSEIF GameOver = 2 THEN
      ScrollText "PLAYER 1 WON !!!" + SPACE$(10), 183
    END IF
  END IF

END SUB

SUB Quit

 DIM ScrollMessage$

 ScreenEffect 1

 DO: LOOP UNTIL INKEY$ = ""

 ScrollMessage$ = "M.G.P. THANKS YOU FOR PLAYING THE FINAL TETRIS RIPOFF !      SPECIAL THANKS GO TO ROLAND GERAERTS,IVO VAN EE AND MY BIG BROTHER ERWIN...       "
 ScrollMessage$ = ScrollMessage$ + "IF YOU'VE GOT QUESTIONS OR REMARKS, YOU CAN CONTACT ME (MARCEL SMOLENAARS) BY E-MAIL AT SMOLENAA@SCI.KUN.NL                       "
 ScrollMessage$ = ScrollMessage$ + "THE MARCEL GOES PROGRAMMING (YEP, THAT'S WHAT M.G.P MEANS) SOFTWARE CORPORATION GREETS YA' ALL !"
 ScrollMessage$ = ScrollMessage$ + SPACE$(20)
 ScrollMessage$ = ScrollMessage$ + "PRODUCER : --MARCEL SMOLENAARS--" + SPACE$(20) + "PROGAMMER : --MARCEL SMOLENAARS--" + SPACE$(20) + "DESIGN : --MARCEL SMOLENAARS--"
 ScrollMessage$ = ScrollMessage$ + SPACE$(20) + "ORIGINAL IDEA : --NOT FROM MARCEL SMOLENAARS--"
 ScrollMessage$ = ScrollMessage$ + SPACE$(30)
 ScrollText ScrollMessage$, 83

 ScreenEffect 4

 SCREEN 0
 WIDTH 80, 25
 END

END SUB

SUB RotateBlock (dir AS INTEGER, n AS INTEGER)
 SHARED BlkFormData() AS INTEGER
 SHARED BlkSpr() AS INTEGER
 SHARED CurBlk() AS Block
 SHARED BlkField() AS INTEGER

 DIM dxb AS INTEGER, dyb AS INTEGER

  FOR dyb = 0 TO 3
   FOR dxb = 0 TO 3
     IF BlkFormData(dxb, dyb, CurBlk(n).Rotation, CurBlk(n).Sort) = 1 THEN
        PsetSprite XpMin(n) + XBlockSize * (CurBlk(n).x + dxb), YpMin(n) + YBlockSize * (CurBlk(n).y + dyb), BlkSpr(0, 0)
     END IF
   NEXT dxb
  NEXT dyb

  IF dir = 1 THEN
    CurBlk(n).Rotation = CurBlk(n).Rotation + 1
    IF CurBlk(n).Rotation = 5 THEN CurBlk(n).Rotation = 1
  END IF
  IF dir = -1 THEN
    CurBlk(n).Rotation = CurBlk(n).Rotation - 1
    IF CurBlk(n).Rotation = 0 THEN CurBlk(n).Rotation = 4
  END IF

  'zorgen dat blok niet uit scherm of midden op ander blok kan roteren
  FOR dyb = 0 TO 3
   FOR dxb = 0 TO 3
     IF BlkFormData(dxb, dyb, CurBlk(n).Rotation, CurBlk(n).Sort) > 0 THEN
       IF CurBlk(n).x + dxb > XMaxBlockScreen THEN CurBlk(n).x = CurBlk(n).x - 1
       IF CurBlk(n).x + dxb < XMinBlockScreen THEN CurBlk(n).x = CurBlk(n).x + 1
       IF CurBlk(n).y + dyb > YMaxBlockScreen THEN CurBlk(n).y = CurBlk(n).y - 1
       IF BlkField(CurBlk(n).x + dxb, CurBlk(n).y + dyb, n) > 0 THEN CurBlk(n).y = CurBlk(n).y - 1
     END IF
   NEXT dxb
  NEXT dyb
 
  FOR dyb = 0 TO 3
   FOR dxb = 0 TO 3
     IF BlkFormData(dxb, dyb, CurBlk(n).Rotation, CurBlk(n).Sort) > 0 THEN
        PsetSprite XpMin(n) + XBlockSize * (CurBlk(n).x + dxb), YpMin(n) + YBlockSize * (CurBlk(n).y + dyb), BlkSpr(0, n)
     END IF
   NEXT dxb
  NEXT dyb

END SUB

SUB UpdateField (Player AS INTEGER)
 SHARED BlkSpr() AS INTEGER
 SHARED BlkField() AS INTEGER
 SHARED BlkFormData() AS INTEGER
 SHARED CurBlk() AS Block
 SHARED Score AS INTEGER
 SHARED Speed AS INTEGER
 SHARED ScoredXNumLines() AS INTEGER
 SHARED PlayerMode AS INTEGER
 SHARED GameOver AS INTEGER

 DIM OtherPlayer AS INTEGER
 DIM dxb AS INTEGER, dyb AS INTEGER
 DIM n AS INTEGER
 DIM FullLine(1 TO 4) AS INTEGER, LineIsNotFull AS INTEGER
 DIM LineCnt AS INTEGER

  IF Player = 1 THEN OtherPlayer = 2 ELSE OtherPlayer = 1

  'laatste blok in veld opnemen
  FOR dyb = 0 TO 3
   FOR dxb = 0 TO 3
    IF NOT (CurBlk(Player).x + dxb > XMaxBlockScreen OR CurBlk(Player).y + dyb > YMaxBlockScreen OR CurBlk(Player).x + dxb < XMinBlockScreen) THEN
      IF BlkFormData(dxb, dyb, CurBlk(Player).Rotation, CurBlk(Player).Sort) > 0 THEN
        BlkField(CurBlk(Player).x + dxb, CurBlk(Player).y + dyb, Player) = Player
      END IF
    END IF
   NEXT dxb
  NEXT dyb

  LineCnt = 0

  'search for full lines and remember them
  FOR dyb = YMinBlockScreen TO YMaxBlockScreen
    LineIsNotFull = FALSE
    FOR dxb = XMinBlockScreen TO XMaxBlockScreen
      IF BlkField(dxb, dyb, Player) = 0 THEN LineIsNotFull = TRUE: EXIT FOR
    NEXT dxb
    IF LineIsNotFull = FALSE THEN
      LineCnt = LineCnt + 1
      FullLine(LineCnt) = dyb
    END IF
  NEXT dyb
 
  IF LineCnt = 0 THEN EXIT SUB

  IF PlayerMode = 1 THEN
   'remove lines and update score
   FOR n = 1 TO LineCnt
     Score = Score + 1
     PLAY "mf o2 l64 gabagab"
     LINE (XpMax(Player) + 30, YpMax(Player) - 10)-STEP(4 * XBlockSize, 8), 0, BF
     WriteText LTRIM$(STR$(Score)), XpMax(Player) + 63 - 8 * LEN(LTRIM$(STR$(Score))), YpMax(Player) - 10, 7
     FOR dyb = FullLine(n) TO (YMinBlockScreen + 1) STEP -1
      FOR dxb = XMinBlockScreen TO XMaxBlockScreen
         BlkField(dxb, dyb, Player) = BlkField(dxb, dyb - 1, Player)
         PsetSprite XpMin(Player) + XBlockSize * dxb, YpMin(Player) + YBlockSize * dyb, BlkSpr(0, BlkField(dxb, dyb, Player))
      NEXT dxb
     NEXT dyb
   NEXT n
   IF LineCnt > 0 THEN ScoredXNumLines(LineCnt) = ScoredXNumLines(LineCnt) + 1
   IF Speed <> Score \ 10 THEN PLAY "mf o2 l16g P16 l16a l4 b "
   Speed = Score \ 10
 
  ELSEIF PlayerMode = 2 THEN

   FOR n = 1 TO LineCnt
    
     PLAY "mf o2 l64 gabagab"
    
     'remove full lines from player that removed line
     FOR dyb = FullLine(n) TO (YMinBlockScreen + 1) STEP -1
     FOR dxb = XMinBlockScreen TO XMaxBlockScreen
       BlkField(dxb, dyb, Player) = BlkField(dxb, dyb - 1, Player)
       PsetSprite XpMin(Player) + XBlockSize * dxb, YpMin(Player) + YBlockSize * dyb, BlkSpr(0, BlkField(dxb, dyb, Player))
     NEXT dxb
     NEXT dyb
    
     'shift lines from other player up
     FOR dyb = YMinBlockScreen TO YMaxBlockScreen
      FOR dxb = XMinBlockScreen TO XMaxBlockScreen
        IF dyb > YMinBlockScreen THEN
            BlkField(dxb, dyb - 1, OtherPlayer) = BlkField(dxb, dyb, OtherPlayer)
            PsetSprite XpMin(OtherPlayer) + XBlockSize * dxb, YpMin(OtherPlayer) + YBlockSize * (dyb - 1), BlkSpr(0, BlkField(dxb, dyb - 1, OtherPlayer))
          ELSE
            IF BlkField(dxb, dyb, OtherPlayer) > 0 THEN GameOver = OtherPlayer
        END IF
      NEXT dxb
     NEXT dyb
    
     'add full line to other player
     FOR dxb = XMinBlockScreen TO XMaxBlockScreen  'fill bottom line other player
        BlkField(dxb, YMaxBlockScreen, OtherPlayer) = Player
     NEXT dxb
     'make places in bottom line from other player open that were filled last
     'by the player
     FOR dyb = 0 TO 3
      IF CurBlk(Player).y + dyb = FullLine(n) THEN
        FOR dxb = 0 TO 3
          IF BlkFormData(dxb, dyb, CurBlk(Player).Rotation, CurBlk(Player).Sort) > 0 THEN
           BlkField(CurBlk(Player).x + dxb, YMaxBlockScreen, OtherPlayer) = 0
          END IF
        NEXT dxb
      END IF
     NEXT dyb
    
     'draw new bottom line from other player
     FOR dxb = XMinBlockScreen TO XMaxBlockScreen
        PsetSprite XpMin(OtherPlayer) + XBlockSize * dxb, YpMin(OtherPlayer) + YBlockSize * YMaxBlockScreen, BlkSpr(0, BlkField(dxb, YMaxBlockScreen, OtherPlayer))
     NEXT dxb
    
     'redraw otherplayers block
     MoveBlock 0, OtherPlayer
  
   NEXT n

  END IF

END SUB

