Unit My_HSC;

Interface
Type HSC_Object=object
       _Notes:array[1..9] of byte;
       _DATA_52:array[1..8] of byte;
       _Instruments : Array [1..9] of Byte;
       _Equalizer   : Array [1..8] of Byte;
       _Playing     : Array [0..8] of Byte;
       _Pattern     : Byte;
       _Track       : Byte;
       _Position    : Byte;
       Song:pointer; size:word;
       Ok,Loaded:boolean;
       Constructor Init;
       Procedure Play;
       Procedure Stop;
       Procedure Fade;
       Procedure Load(s:string);
       Procedure FillVars;
       Destructor Done;
     end;
Implementation
Uses OplLib;

Constructor Hsc_Object.Init;
var m:boolean;
begin
  DetectOPL2;
  ASM
    MOV  m,0
    JNC  @@NoError
    MOV  m,1
  @@NoError:
  END;
  Loaded:=false; Ok:=m;
end;

Procedure Hsc_Object.Play;
begin
  if not Ok then if Loaded then PlayNewSong(False,seg(song^),ofs(song^));
end;

Procedure Hsc_Object.stop;
begin
  StopMusic;
  if loaded then begin
    freemem(song,size);
    loaded:=false;
  end;
end;

Procedure Hsc_Object.fade;
begin FadeOut end;

Procedure Hsc_Object.Load;
var f:file;
begin
  if loaded then stop;
  assign(f,s);
  {$I-} reset(f,1); {$I+}
  if ioresult<>0 then Loaded:=false else Loaded:=true;
  if Loaded then begin
    size:=filesize(f);
    getmem(song,size);
    blockread(f,song^,size);
    close(f);
  end;
end;

Procedure Hsc_Object.FillVars;
begin
  FillOPL2Vars;
  Move(Notes,_Notes,9);
  Move(Instruments,_Instruments,9);
  Move(Equalizer,_Equalizer,8);
  Move(Playing,_Playing,9);
  _Pattern:=Pattern;
  _Position:=Position;
  _Track:=track;
end;

Destructor Hsc_Object.Done;
begin
  Stop;
end;

end.