'I'll add more stocks & stuff as I work on it more.  You can feel free to
'change anything, but I would appreciate your sending me a new copy of it at
'bepman@geocities.com

'version 1.0: 41 stocks
'version 1.1: 50 stocks
'version 1.2: multiplayer option added
'version 1.3: took off INTEGER mode so the program didn't overflow when a
'             number was greater than 32767.  The numbers still appear to
'             be integers, though.
'version 1.4: the only difference was that the savegame option was,
'             after much ado and labor, finally fixed.  The problem appears
'             to have been that I saved the stock/person names w/o quotes,
'             so the program restored each word of the names as a different
'             variable.  This screwed everything up, but I finally figured
'             out I should use "write" instead of "print".  Everythin' happy.
'
'             I also added a few new little things here and there, fixing the
'             code up a bit, moving things around, etc.  General housekeeping.
'version 1.5: Mainest difference here is that there are now 80 stocks instead
'             of 50, filling up the second screen.  Also, I fixed some little
'             annoyances and changed the fluctuation algorithms a bit.

'by version 2.0, I hope to have real trend data and stuff where
'             you can make your own stocks & get money off of it.  one
'             idea is that you get a certain percentage of the money put
'             into it.  this program should be really cool by the time I
'             finish it.

'Feel free (even encouraged) to e-mail me at bepman@geocities.com,
'telling me what you think, what should be changed, and what should
'be added.


DECLARE SUB loadgame (name$, day!, DayOfWeek!, month!, year!)
DECLARE SUB SaveGame (name$, day!, DayOfWeek!, month!, year!)
DECLARE SUB BankOftheDamned (interest)
DECLARE SUB Rainbow (row, column, text$)
DECLARE SUB Credits ()
DECLARE SUB DefineStockElements ()
DECLARE SUB AnyNewStocks ()
DECLARE SUB NewStockValue (name$)
DECLARE SUB PurchaseStock ()
DECLARE SUB SellStock ()
DECLARE SUB RisenStock ()
DECLARE SUB LoweredStock ()
DECLARE SUB YourStocks ()
DECLARE SUB DisplayStockValue ()
DECLARE SUB instructions ()
DECLARE SUB tips ()
DECLARE SUB getpress ()
DECLARE SUB pause (howlong)
DECLARE SUB intro ()
DECLARE SUB Center (row, text$)
COMMON SHARED player AS INTEGER, players AS INTEGER, days AS INTEGER, turn AS INTEGER

DIM totalval(6)
DIM DayOfWeek$(7)
DIM colorval(16) AS INTEGER
DIM bluefade(16) AS INTEGER
DIM SHARED stock$(1 TO 80)          'an array for the stock names
DIM SHARED origstockval(1 TO 80)    'one for the stock's beginning values.
DIM SHARED stockval(1 TO 80)        'one for the current stock values.
DIM SHARED oldstockval(1 TO 80)     'one for the old stock values
DIM SHARED stock(1 TO 80, 1 TO 6)   'one for stocks on hand
DIM SHARED trend(1 TO 80)           'one for the trend of stocks
DIM SHARED trendold(1 TO 80)        'old trend values
DIM SHARED money(1 TO 6)            'money for up to 6 players
DIM SHARED bankaccount(1 TO 6)      'one for up to 6 bank accounts
DIM SHARED loan(1 TO 6)             'one for up to 6 loans
DIM SHARED name$(1 TO 6)            'one for...uh...the names?
'they're all SHARED just in case I need them to be.

DefineStockElements

DayOfWeek$(1) = "Sunday"
DayOfWeek$(2) = "Monday"
DayOfWeek$(3) = "Tuesday"
DayOfWeek$(4) = "Wednesday"
DayOfWeek$(5) = "Thursday"
DayOfWeek$(6) = "Friday"
DayOfWeek$(7) = "Saturday"

'instead of defining everything again, this loop does it just fine.
FOR x = 1 TO 80
        stockval(x) = origstockval(x)
NEXT
FOR x = 1 TO 80
        trend(x) = 3
NEXT x

FOR x = 1 TO 16
        colorval(x) = x + 15
NEXT x
colorval(16) = 15

bluefade(1) = 176
bluefade(2) = 177
bluefade(3) = 178
bluefade(4) = 199
bluefade(5) = 104
bluefade(6) = 105
bluefade(7) = 106
bluefade(8) = 127
bluefade(9) = 126
bluefade(10) = 128
bluefade(11) = 1
bluefade(12) = 55
bluefade(13) = 32
bluefade(14) = 33
bluefade(15) = 34
bluefade(16) = 35

RANDOMIZE TIMER
'define other variables
month = 12
day = 12                'This was the 1 year anniv. of the day
year = 1996             'BEP was invented (for those who care,
                        'which is a very small number of people)
FOR player = 1 TO 6
money(player) = 1000
stock(5, player) = 5
bankaccount(player) = 0
loan(player) = 0
NEXT player

totalval = 0
amountofstocks = 50
turn = 1
DayOfWeek = 5
player = 1

CLS

intro

CLS

COLOR 2
PRINT "            "
PRINT "                    "
PRINT "             "
PRINT "             "
PRINT "           "
PRINT "           "
PRINT "           "
PRINT "             "
PRINT "              "
PRINT "             "
PRINT "            "
PRINT "          "
PRINT "            "

COLOR 2: Center 12, "Stock Market Shark"
COLOR 11: Center 13, "A Strategy Game"
COLOR 14: Center 14, "by"
COLOR 12: Center 15, "Damon Amyx"
COLOR 15
getpress


begin:
DO
SCREEN 13
CLS
FOR x = 1 TO 16
        COLOR bluefade(x)
        LOCATE 5, 10: PRINT "** Main Menu **"
        COLOR colorval(x)
        LOCATE 7, 5: PRINT "[1] Start a new game"
        LOCATE 8, 5: PRINT "[2] Instructions"
        LOCATE 9, 5: PRINT "[3] Helpful Tips"
        LOCATE 10, 5: PRINT "[4] Credits and Acknowledgments"
        LOCATE 11, 5: PRINT "[5] Load an old game"
        LOCATE 12, 5: PRINT "[6] Quit"
        pause .03
NEXT
        INPUT "What is the number of your choice"; choice
LOOP UNTIL choice > 0 AND choice < 7
SCREEN 12
SELECT CASE choice
        CASE 1
                GOTO startgame
        CASE 2
                instructions
                GOTO begin
        CASE 3
                tips
                GOTO begin
        CASE 4
                Credits
                GOTO begin
        CASE 5
                SCREEN 9
                COLOR 7, 1
                CALL loadgame(name$, day, DayOfWeek, month, year)
                GOTO initialize
        CASE 6
                SYSTEM: END
END SELECT

startgame:
SCREEN 9
COLOR 7, 1
LOCATE 8, 1: INPUT "How many turns would you like to play for? (average=50)"; days: CLS
DO
LOCATE 9, 1: INPUT "How many players (1-6)"; players
LOOP UNTIL players > 0 AND players <= 6
CLS
FOR x = 1 TO players
badinput:
        CLS
        LOCATE 7, 1: PRINT "What is player"; x; "'s name"; : INPUT name$(x)
        IF LEN(name$(x)) >= 11 THEN PRINT "Name too long.  Max. 10 Characters.": getpress: GOTO badinput
NEXT x



DO
initialize:
totalval(player) = 0
FOR x = 1 TO 80
        totalval(player) = totalval(player) + stock(x, player) * stockval(x)
NEXT
totalval(player) = totalval(player) + money(player) + bankaccount(player) - loan(player)
CLS
                  
LOCATE 2, 1: PRINT DayOfWeek$(DayOfWeek); "  "; month; "/"; day; "/"; year
LOCATE 2, 30: PRINT "This is turn"; turn; "out of"; days
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
COLOR 15
stringa$ = "* Current Status of Stockbroker " + name$(player) + " *"
Center 1, stringa$
COLOR 15
Center 4, "* Options Menu *"
COLOR 7
LOCATE 5, 1: PRINT "[1] See stock values/Buy stocks"
LOCATE 5, 40: PRINT "[2] Visit the Bank"
LOCATE 6, 1: PRINT "[3] Sell stocks"
LOCATE 6, 40: PRINT "[4] See which stocks have risen in value"
LOCATE 7, 1: PRINT "[5] See stocks that lowered in value"
LOCATE 7, 40: PRINT "[6] See your stocks"
LOCATE 8, 1: PRINT "[7] End this turn"
LOCATE 8, 40: PRINT "[8] Save your game"
LOCATE 9, 1: PRINT "[9] Load a game"
LOCATE 9, 40: PRINT "[10] Quit the game"


LOCATE 15, 1: PRINT "Ŀ"
LOCATE 16, 1: PRINT "                                                                            "
LOCATE 17, 1: PRINT "                                                                            "
LOCATE 18, 1: PRINT "                                                                            "
LOCATE 19, 1: PRINT "                                                                            "
LOCATE 20, 1: PRINT "                                                                            "
LOCATE 21, 1: PRINT "                                                                            "
LOCATE 22, 1: PRINT ""

LOCATE 16, 3: PRINT "Total money on hand:      $"; money(player)
LOCATE 17, 3: PRINT "Total value, minus loan:  $"; totalval(player)
LOCATE 18, 3: PRINT "Assets after liquidation: $"; totalval(player) + loan(player)
LOCATE 19, 3: PRINT "Total money owed to bank: $"; loan(player)
LOCATE 20, 3: PRINT "Total money in bank:      $"; bankaccount(player)

row = 16
FOR y = 1 TO players
totalval(y) = 0
FOR x = 1 TO 80
        totalval(y) = totalval(y) + stock(x, y) * stockval(x)
NEXT
totalval(y) = totalval(y) + money(y) + bankaccount(y) - loan(y)
LOCATE row, 41: PRINT "Total assets of "; name$(y); ":"
LOCATE row, 68: PRINT "$"; totalval(y)
row = row + 1
NEXT


        
DO
        TIMESTRING$ = "Current Time: " + TIME$
        Center 12, TIMESTRING$
        LOCATE 10, 8: INPUT "What is your choice"; choice
LOOP UNTIL choice > 0 AND choice < 11

SELECT CASE choice
        CASE 1
                DisplayStockValue
        CASE 2
                CALL BankOftheDamned(interest)
        CASE 3
                SellStock
        CASE 4
                RisenStock
        CASE 5
                LoweredStock
        CASE 6
                YourStocks
        CASE 7
                GOTO TurnIsOver
        CASE 8
                CALL SaveGame(name$, day, DayOfWeek, month, year)
        CASE 9
                CALL loadgame(name$, day, DayOfWeek, month, year)
        CASE 10
                SYSTEM: END
END SELECT

IF turn = days THEN GOTO TheGameIsOver
day = day + 1
DayOfWeek = DayOfWeek + 1: IF DayOfWeek = 8 THEN DayOfWeek = 1
GOTO NewMonth
Part2:
IF month = 13 THEN
        month = 1
        year = year + 1
END IF
GOTO initialize
NewMonth:
        IF month = 1 AND day = 32 THEN month = month + 1: day = 1
        IF month = 2 THEN
                IF day = 29 AND INT(year / 4) <> year / 4 THEN month = month + 1: day = 1
                IF day = 30 AND INT(year / 4) = year / 4 AND year <> 2000 THEN month = month + 1: day = 1
        END IF
        IF month = 3 AND day = 32 THEN month = month + 1: day = 1
        IF month = 4 AND day = 31 THEN month = month + 1: day = 1
        IF month = 5 AND day = 32 THEN month = month + 1: day = 1
        IF month = 6 AND day = 31 THEN month = month + 1: day = 1
        IF month = 7 AND day = 32 THEN month = month + 1: day = 1
        IF month = 8 AND day = 32 THEN month = month + 1: day = 1
        IF month = 9 AND day = 31 THEN month = month + 1: day = 1
        IF month = 10 AND day = 32 THEN month = month + 1: day = 1
        IF month = 11 AND day = 31 THEN month = month + 1: day = 1
        IF month = 12 AND day = 32 THEN month = month + 1: day = 1
GOTO Part2

'-------------------------------------------------------------------------'

TurnIsOver:
FOR x = 1 TO 80
        oldstockval(x) = stockval(x)
NEXT x
CALL NewStockValue(name$)
interest = 1
CALL BankOftheDamned(interest)
player = player + 1: IF player = players + 1 THEN player = 1: turn = turn + 1
LOOP UNTIL turn = days + 1

'-------------------------------------------------------------------------'

TheGameIsOver:
CLS
BEEP
pause .5
BEEP
COLOR 15
Rainbow 2, 7, "** The Game is Over! **"
COLOR 7
LOCATE 4, 17: PRINT "Stockbroker 1 thru"; players; "have completed the game!"
l = 6
FOR player = 1 TO players
LOCATE l, 17: PRINT "Total Assets after turn"; days; "for player "; name$(player); ":  $"; totalval(player)
l = l + 1
NEXT player
Center 22, "Email comments, suggestions, and questions to: bepman@geocities.com"

'
SUB AnyNewStocks
FOR x = 1 TO 80
        IF stock$(x) = "" THEN GOSUB ThereMightBeAnother
NEXT x
EXIT SUB
ThereMightBeAnother:
        i = INT(100 * RND)
        IF i >= 19 THEN GOSUB ThereIsAnother
        RETURN
ThereIsAnother:
        i = INT(28 * RND) + 1
        SELECT CASE i
                CASE 1
                        stock$(x) = "Casio Electronics"
                        origstockval(x) = 500
                        stockval(x) = 500
                CASE 2
                        stock$(x) = "Simon & Schuster"
                        origstockval(x) = 550
                        stockval(x) = 550
                CASE 3
                        stock$(x) = "Fuji"
                        origstockval(x) = 320
                        stockval(x) = 320
                CASE 4
                        stock$(x) = "Marvel"
                        origstockval(x) = 500
                        stockval(x) = 500
                CASE 5
                        stock$(x) = "Dream Works"
                        origstockval(x) = 200
                        stockval(x) = 200
                CASE 6
                        stock$(x) = "Capcom"
                        origstockval(x) = 350
                        stockval(x) = 350
                CASE 7
                        stock$(x) = "Sony"
                        origstockval(x) = 425
                        stockval(x) = 425
                CASE 8
                        stock$(x) = "Always Tampons" 'Sam Shev (phone #:
                        origstockval(x) = 175        '408-241-2494) told
                        stockval(x) = 175            'me to make this...
                CASE 9
                        stock$(x) = "Warner Brothers"
                        origstockval(x) = 250
                        stockval(x) = 250
                CASE 10
                        stock$(x) = "SJUSD"
                        origstockval(x) = 300
                        stockval(x) = 300
                CASE 11
                        stock$(x) = "Galaxy Informer"
                        origstockval(x) = 100
                        stockval(x) = 200
                CASE 12
                        stock$(x) = "Beef & Pork"
                        origstockval(x) = 150
                        stockval(x) = 150
                CASE 13
                        stock$(x) = "CompuSoft"
                        origstockval(x) = 200
                        stockval(x) = 200
                CASE 14
                        stock$(x) = "Hanes"
                        origstockval(x) = 175
                        stockval(x) = 175
                CASE 15
                        stock$(x) = "Kodak"
                        origstockval(x) = 350
                        stockval(x) = 350
                CASE 16
                        stock$(x) = "Webster's"
                        origstockval(x) = 775
                        stockval(x) = 775
                CASE 17
                        stock$(x) = "American Comics"
                        origstockval(x) = 400
                        stockval(x) = 400
                CASE 18
                        stock$(x) = "Penway"
                        origstockval(x) = 200
                        stockval(x) = 200
                CASE 19
                        stock$(x) = "Harvard Univ."
                        origstockval(x) = 650
                        stockval(x) = 650
                CASE 20
                        stock$(x) = "E=mc"
                        origstockval(x) = 50
                        stockval(x) = 50
                CASE 21
                        stock$(x) = "Craftsman"
                        origstockval(x) = 375
                        stockval(x) = 375
                CASE 22
                        stock$(x) = "Century Theaters"
                        origstockval(x) = 120
                        stockval(x) = 120
                CASE 23
                        stock$(x) = "Metatools"
                        origstockval(x) = 445
                        stockval(x) = 445
                CASE 24
                        stock$(x) = "Mead"
                        origstockval(x) = 200
                        stockval(x) = 200
                CASE 25
                        stock$(x) = "Osklonatovich"
                        origstockval(x) = 30
                        stockval(x) = 30
                CASE 26
                        stock$(x) = "Honeysuckle Ent."
                        origstockval(x) = 225
                        stockval(x) = 225
                CASE 27
                        stock$(x) = "Wilbur Co."
                        origstockval(x) = 72
                        stockval(x) = 72
                CASE 28
                        stock$(x) = "Pitney-Bowes"
                        origstockval(x) = 200
                        stockval(x) = 200

        END SELECT
        CLS
        BEEP
        pause .5
        BEEP
        COLOR 15
        Center 5, "** NEWS FLASH **"
        Center 6, "A new stock has presented itself on the market!"
        COLOR 7
        LOCATE 8, 17: PRINT "Number:"; x
        LOCATE 9, 17: PRINT "Name: "; stock$(x)
        LOCATE 10, 17: PRINT "Value:"; stockval(x)
        Center 12, "As part of an advertisement campaign to spread"
        Center 13, "their company's popularity, they decide to give"
        Center 14, "you a few free stocks!"
        freestocks = INT(3 * RND) + 1
        LOCATE 15, 17: PRINT "Holdings:"; freestocks
        stock(x, player) = freestocks
        trend(x) = 3 + RND(freestocks * .2)
        getpress
        RETURN
END SUB

'
SUB BankOftheDamned (interest)
beginning:
IF interest = 1 THEN GOTO InterestRate
CLS
COLOR 15
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
Center 1, "* Statewide Bank of Tiggie, Inc. *"
LOCATE 2, 1: PRINT "Current APR: .6%--Current LPR: .7%"
Center 3, "Options"
COLOR 7
LOCATE 5, 6: PRINT "[1] Make a withdrawal"
LOCATE 5, 36: PRINT "[2] Pay back part, or all of, a loan"
LOCATE 6, 3: PRINT "[3] Make a deposit"
LOCATE 6, 29: PRINT "[4] Take out a loan"
LOCATE 6, 56: PRINT "[5] Leave the bank"
LOCATE 7, 4: INPUT "What is your choice"; action
SELECT CASE action
        CASE 1
                LOCATE 9, 1: PRINT "You have $"; bankaccount(player); "in your account."
                DO
                LOCATE 10, 1: INPUT "How much money would you like to withdraw"; withdrawl
                IF withdrawl < 0 THEN PRINT : PRINT "Ethan, you know you can't do that."
                LOOP UNTIL withdrawl <= bankaccount(player) AND withdrawl >= 0
                bankaccount(player) = bankaccount(player) - withdrawl
                money(player) = money(player) + withdrawl
                LOCATE 12, 5: PRINT "New Bank Account Info:"
                LOCATE 13, 5: PRINT "Money in Bank:  $"; bankaccount(player)
                LOCATE 14, 5: PRINT "Money on Hand:  $"; money(player)
                COLOR 15
                LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
                COLOR 7
                getpress
        CASE 2
                LOCATE 9, 1: PRINT "You owe the bank $"; loan(player); "."
                DO
                LOCATE 10, 1: INPUT "How much would you like to pay back"; payback
                LOOP UNTIL payback <= money(player) AND payback <= loan(player) AND payback >= 0
                loan(player) = loan(player) - payback
                money(player) = money(player) - payback
                LOCATE 12, 5: PRINT "New Loan Info:"
                LOCATE 13, 5: PRINT "Money Owed:    $"; loan(player)
                LOCATE 14, 5: PRINT "Money on Hand: $"; money(player)
                COLOR 15
                LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
                COLOR 7
                getpress
        CASE 3
                LOCATE 9, 1: PRINT "You have $"; bankaccount(player); "in your account."
                DO
                LOCATE 10, 1: INPUT "How much would you like to deposit"; deposit
                LOOP UNTIL deposit <= money(player) AND deposit >= 0
                bankaccount(player) = bankaccount(player) + deposit
                money(player) = money(player) - deposit
                LOCATE 12, 5: PRINT "New Bank Account Info:"
                LOCATE 13, 5: PRINT "Money in Bank:  $"; bankaccount(player)
                LOCATE 14, 5: PRINT "Money on Hand:  $"; money(player)
                COLOR 15
                LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
                COLOR 7
                getpress
        CASE 4
                LOCATE 9, 1: PRINT "The maximum loan you can take out is $10000."
                DO
                LOCATE 10, 1: INPUT "What size loan would you like"; takeloan
                IF takeloan = 0 THEN EXIT SUB
                LOOP UNTIL takeloan + loan(player) <= 10000 AND takeloan >= 0
                loan(player) = loan(player) + takeloan
                money(player) = money(player) + takeloan
                LOCATE 12, 5: PRINT "New Loan Info:"
                LOCATE 13, 5: PRINT "Money Owed:    $"; loan(player)
                LOCATE 14, 5: PRINT "Money on Hand: $"; money(player)
                COLOR 15
                LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
                COLOR 7
                getpress
        CASE 5
                EXIT SUB
END SELECT
GOTO beginning
InterestRate:
        IF player = 7 THEN player = 1
        loan(player) = INT(loan(player) + (loan(player) * .007))
        bankaccount(player) = INT(bankaccount(player) + (bankaccount(player) * .006))
        interest = 0
END SUB

SUB Center (row, text$)
c = 40 - (LEN(text$) / 2)
LOCATE row, c: PRINT text$
END SUB

'
SUB Credits
CLS
REDIM colorval(16) AS INTEGER
FOR x = 1 TO 16
        colorval(x) = x + 15
NEXT x
colorval(16) = 15

SCREEN 13
FOR x = 1 TO 16
        COLOR colorval(x)
        pause .035
        LOCATE 1, 4: PRINT "Special Thanks and Acknowledgments to:"
        LOCATE 5, 2: PRINT " Jonathan Shev, for beta-testing this"
        LOCATE 6, 4: PRINT "program for hours on end"
        LOCATE 8, 2: PRINT " Samuel and Aaron Shev, for giving me"
        LOCATE 9, 4: PRINT "so many names for stocks"
        LOCATE 11, 2: PRINT " Myself, for creating this kewl pro-"
        LOCATE 12, 4: PRINT "gram. Email @ bepman@geocities.com"
NEXT x
        WHILE INKEY$ = "": WEND
SCREEN 12: COLOR 7
END SUB

'
SUB DefineStockElements
'Define all the stock elements

stock$(1) = "Hershey's Chocolate": origstockval(1) = 300
stock$(2) = "Tootsie Roll": origstockval(2) = 550
stock$(3) = "Odwalla": origstockval(3) = 200
stock$(4) = "Ghirardelli": origstockval(4) = 250
stock$(5) = "Coca Cola": origstockval(5) = 75
stock$(6) = "Pepsi": origstockval(6) = 100
stock$(7) = "Nike": origstockval(7) = 500
stock$(8) = "Intel": origstockval(8) = 650
stock$(9) = "Micro$oft": origstockval(9) = 625
stock$(10) = "Wizards of the Coast": origstockval(10) = 1075    '**MAGIC RULES**   5th edition $UK$
stock$(11) = "Iomega": origstockval(11) = 560
stock$(12) = "Apogee": origstockval(12) = 400
stock$(13) = "Epic MegaGames": origstockval(13) = 440
stock$(14) = "Apple": origstockval(14) = 375
stock$(15) = "Macintosh": origstockval(15) = 540
stock$(16) = "Dell": origstockval(16) = 400
stock$(17) = "Levi's": origstockval(17) = 420
stock$(18) = "IBM": origstockval(18) = 750
stock$(19) = "UPN 44": origstockval(19) = 625
stock$(20) = "Toys R Us": origstockval(20) = 200
stock$(21) = "Ford": origstockval(21) = 230
stock$(22) = "Chevrolet": origstockval(22) = 250
stock$(23) = "Volkswagen": origstockval(23) = 240
stock$(24) = "Honda": origstockval(24) = 220
stock$(25) = "Mitsubishi": origstockval(25) = 260
stock$(26) = "Fleer": origstockval(26) = 600
stock$(27) = "TriStar Film": origstockval(27) = 400
stock$(28) = "Columbia Film": origstockval(28) = 375
stock$(29) = "MitchellFilm, Ltd.": origstockval(29) = 100
stock$(30) = "Paramount, Inc.": origstockval(30) = 740
stock$(31) = "Bic": origstockval(31) = 300
stock$(32) = "Mensa, Ltd.": origstockval(32) = 320
stock$(33) = "Penway": origstockval(33) = 150
stock$(34) = "Kleenex": origstockval(34) = 150
stock$(35) = "Megatest": origstockval(35) = 300
stock$(36) = "Bepman & Tiggie": origstockval(36) = 700      'this stock RULES!!!
stock$(37) = "Harper's Magazine": origstockval(37) = 90
stock$(38) = "Canon": origstockval(38) = 360
stock$(39) = "Creative": origstockval(39) = 270
stock$(40) = "Sunshine": origstockval(40) = 100
stock$(41) = "Veritas": origstockval(41) = 300
stock$(42) = "Image Comics": origstockval(42) = 275
stock$(43) = "Shev Inc.": origstockval(43) = 100   'If you don't like it, then you can "SHEV" it up your ass.
stock$(44) = "Sega": origstockval(44) = 345
stock$(45) = "Nintendo": origstockval(45) = 170
stock$(46) = "Daily Bugle": origstockval(46) = 200
stock$(47) = "Xavier": origstockval(47) = 375
stock$(48) = "Disney": origstockval(48) = 500
stock$(49) = "BraUn": origstockval(49) = 250
stock$(50) = "Logitech": origstockval(50) = 270
stock$(51) = "Casio": origstockval(51) = 320
stock$(52) = "Viacom": origstockval(52) = 3200
stock$(53) = "Reebok": origstockval(53) = 750
stock$(54) = "Chaosium": origstockval(54) = 535
stock$(55) = "Decipher": origstockval(55) = 640
stock$(56) = "Maxis": origstockval(56) = 300
stock$(57) = "Westwood Studios": origstockval(57) = 950
stock$(58) = "Nestle": origstockval(58) = 220
stock$(59) = "Netcom": origstockval(59) = 230
stock$(60) = "Integrated Systems": origstockval(60) = 440
stock$(61) = "Reese's": origstockval(61) = 110
stock$(62) = "Converse All-Star": origstockval(62) = 300
stock$(63) = "LucasArts": origstockval(63) = 475
stock$(64) = "Red Devil Fireworks": origstockval(64) = 100
stock$(65) = "POW Productions": origstockval(65) = 225
stock$(66) = "Trojan Rubber Co.": origstockval(66) = 650
stock$(67) = "McCullough Chainsaw": origstockval(67) = 275
stock$(68) = "Huckleberry, Inc.": origstockval(68) = 75
stock$(69) = "Rockport Shoes": origstockval(69) = 420
stock$(70) = "Durham Meat Co.": origstockval(70) = 125
stock$(71) = "San Jose Tofu": origstockval(71) = 215
stock$(72) = "GeoCities": origstockval(72) = 700
stock$(73) = "Specialized": origstockval(73) = 580
stock$(74) = "Bianchi": origstockval(74) = 520
stock$(75) = "Rainbird Sprinklers": origstockval(75) = 225
stock$(76) = "Diamondback": origstockval(76) = 750
stock$(77) = "Insanity Dreams": origstockval(77) = 1200         'yes, in some small way, I am sucking up to Laz and Krusty.
stock$(78) = "Bep, Inc.": origstockval(78) = 465         'whee.  Myself, incorporated.
stock$(79) = "Baskin-Robbins": origstockval(79) = 275
stock$(80) = "Hebrew National": origstockval(80) = 610

'whew! thank god that part was over.  it took way too long.

END SUB

'
SUB DisplayStockValue
'display current stock values
HappyOne:
CLS
COLOR 15
LOCATE 1, 2: PRINT "#"
LOCATE 1, 5: PRINT "Stock"
LOCATE 1, 27: PRINT "Value"
LOCATE 2, 73: PRINT "$"; money(player)
COLOR 7
l = 2
FOR x = 1 TO 20
        IF stock$(x) = "" THEN GOTO NextTime
        LOCATE l, 1: PRINT x
        IF stock(x, player) > 0 THEN COLOR 15
        LOCATE l, 5: PRINT stock$(x)
        COLOR 7
        LOCATE l, 27: PRINT "$"; stockval(x)
        l = l + 1
NextTime:
NEXT

COLOR 15
LOCATE 1, 37: PRINT "#"
LOCATE 1, 40: PRINT "Stock"
LOCATE 1, 62: PRINT "Value"
COLOR 7
l = 2
FOR x = 21 TO 40
        IF stock$(x) = "" THEN GOTO NextTimeAgain
        LOCATE l, 36: PRINT x
        IF stock(x, player) > 0 THEN COLOR 15
        LOCATE l, 40: PRINT stock$(x)
        COLOR 7
        LOCATE l, 62: PRINT "$"; stockval(x)
        l = l + 1
NextTimeAgain:
NEXT
getmore2:
Center 23, "[P]urchase a stock, or [C]ontinue"
WHILE z$ = "": z$ = INKEY$: WEND
IF z$ = "c" THEN z$ = "": GOTO Next20...
IF z$ = "p" THEN GOSUB BuyAStock: z$ = "": GOTO HappyOne
z$ = ""
GOTO getmore2

Next20...:
FOR i = 1 TO 1000: NEXT i
HappyTwo:
CLS
COLOR 15
LOCATE 1, 2: PRINT "#"
LOCATE 1, 5: PRINT "Stock"
LOCATE 1, 27: PRINT "Value"
LOCATE 2, 73: PRINT "$"; money(player)

COLOR 7
l = 2
FOR x = 41 TO 60
        IF stock$(x) = "" THEN GOTO NextTimeAgainBlahBlah
        LOCATE l, 1: PRINT x
        IF stock(x, player) > 0 THEN COLOR 15
        LOCATE l, 5: PRINT stock$(x)
        COLOR 7
        LOCATE l, 27: PRINT "$"; stockval(x)
        l = l + 1
NextTimeAgainBlahBlah:
NEXT x

MoreYay:
l = 2
COLOR 15
LOCATE 1, 37: PRINT "#"
LOCATE 1, 40: PRINT "Stock"
LOCATE 1, 62: PRINT "Value"
COLOR 7
FOR x = 61 TO 80
        IF stock$(x) = "" THEN GOTO NextTimeAgainBep
        LOCATE l, 36: PRINT x
        IF stock(x, player) > 0 THEN COLOR 15
        LOCATE l, 40: PRINT stock$(x)
        COLOR 7
        LOCATE l, 62: PRINT "$"; stockval(x)
        l = l + 1
NextTimeAgainBep:
NEXT x

getmore4:
Center 23, "[P]urchase a stock, or [C]ontinue"
WHILE z$ = "": z$ = INKEY$: WEND
IF z$ = "c" THEN GOTO AllDone
IF z$ = "p" THEN GOSUB BuyAStock: z$ = "": GOTO HappyTwo
z$ = ""
GOTO getmore4
BuyAStock:
DO
DO
COLOR 1
LOCATE 23: PRINT ""
COLOR 7
LOCATE 23, 12: INPUT "What stock (1-80) would you like to buy"; number
COLOR 1
LOCATE 23: PRINT ""
COLOR 7
IF number = 0 THEN EXIT SUB
LOOP UNTIL number > 0 AND number < 81
LOOP UNTIL stock$(number) <> ""
some = INT(money(player) / stockval(number))
LOCATE 23, 12: PRINT "You can afford"; some; "of "; stock$(number); " stock."
SLEEP
COLOR 1
LOCATE 23: PRINT ""
COLOR 7
DO
LOCATE 23, 12: INPUT "How many would you like to purchase"; quantity
COLOR 1
LOCATE 23: PRINT ""
COLOR 7
LOOP UNTIL quantity <= some AND quantity >= 0
price = quantity * stockval(number)
LOCATE 23, 12: PRINT "You just bought"; quantity; "of "; stock$(number); " for $"; price
COLOR 1
WHILE INKEY$ = "": WEND
LOCATE 23: PRINT ""
COLOR 7
money(player) = money(player) - price
stock(number, player) = stock(number, player) + quantity
trend(number) = trend(number) + (.2 * quantity)
COLOR 1
LOCATE 2, 73: PRINT ""
COLOR 15
LOCATE 2, 73: PRINT "$"; money(player)
COLOR 7
RETURN


AllDone:
END SUB

SUB getpress
Center 23, "<Press a key>"
WHILE INKEY$ = "": WEND
END SUB

SUB instructions
CLS
COLOR 2
Center 1, "Instructions for 'Stock Market Shark'"
COLOR 15
PRINT
PRINT
PRINT "   You start out as a lowly stockbroker with pocket money of $1000"
PRINT "and 5 shares of stock in Coca-Cola.  You have 50 turns to do as many"
PRINT "things as you can and make as much money as possible."
PRINT "   All stocks, as in real life, go up and down in value.  If a"
PRINT "stock goes down to below 5% of its original value, it will crash."
PRINT "There is also a .1% chance that any given stock, no matter how "
PRINT "prosperous, will crash.  So beware of investing in stocks that are"
PRINT "much lower than in value than they used to be.  The maximum fluct-"
PRINT "uation of a stock is 15% of its original value."
PRINT "   Also, if a stock has crashed, there is a 40% chance that after any"
PRINT "turn is over, a new stock will appear in its place.  A news flash will"
PRINT "make this shown."
PRINT
COLOR 5
PRINT "It would also be a good idea to see the 'Helpful Tips'."
getpress
END SUB

SUB intro
SCREEN 12
LINE (200, 120)-(420, 170), 1
LINE (420, 170)-(214, 200), 1
LINE (214, 200)-(340, 160), 1
LINE (340, 160)-(200, 120), 1
PAINT (350, 160), 5, 1
LINE (360, 330)-(310, 210), 1
LINE (310, 210)-(260, 316), 1
LINE (260, 316)-(310, 236), 1
LINE (310, 236)-(360, 330), 1
PAINT (325, 250), 5, 1

COLOR 1: LOCATE 20, 48: PRINT "[": COLOR 5: LOCATE 20, 49: PRINT "C": COLOR 1: LOCATE 20, 50: PRINT "]"
Center 25, "Presents"
pause 2
END SUB

SUB loadgame (name$, day, DayOfWeek, month, year)
CLS
beginnin:


COLOR 15
Center 1, "* Load Game *"
COLOR 7
LOCATE 3, 1: INPUT "What directory (e.g., C:\DAMON\BT)"; directory$
IF directory$ = "" THEN GOTO bipfippie
SHELL directory$
bipfippie:
SHELL "DIR .SAV"
LOCATE 13, 4: INPUT "What is the name of your saved game"; filename$
filename$ = filename$ + ".sav"
OPEN filename$ FOR INPUT AS #1
INPUT #1, player
INPUT #1, players
INPUT #1, days
INPUT #1, day
INPUT #1, DayOfWeek
INPUT #1, month
INPUT #1, year
INPUT #1, turn
FOR la = 1 TO players
INPUT #1, name$(la)
INPUT #1, loan(la)
INPUT #1, bankaccount(la)
INPUT #1, money(la)
NEXT la

FOR x = 1 TO 80
        INPUT #1, stock$(x): IF stock$(x) = "Untaken" THEN stock$(x) = ""
        INPUT #1, origstockval(x)
        INPUT #1, oldstockval(x)
        INPUT #1, stockval(x)
        INPUT #1, trend(x)
        INPUT #1, trendold(x)
NEXT x

FOR x = 1 TO 80
FOR la = 1 TO players
INPUT #1, stock(x, la)
NEXT la
NEXT x
CLOSE
EXIT SUB

CantLoad:
LOCATE 15, 1: PRINT "There is no file by that name."
getpress
CLS
GOTO beginnin

END SUB

'
SUB LoweredStock
CLS
LOCATE 1, 2: PRINT "#"
LOCATE 1, 5: PRINT "Name"
LOCATE 1, 26: PRINT "Value"
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
l = 3
FOR x = 1 TO 20
        IF stock$(x) = "" THEN GOTO NextTime3
        IF oldstockval(x) > stockval(x) THEN
                LOCATE l, 1: PRINT x
                IF stock(x, player) > 0 THEN COLOR 15
                LOCATE l, 5: PRINT stock$(x)
                COLOR 7
                LOCATE l, 26: PRINT "$"; stockval(x)
                LOCATE l, 35: PRINT "-"; oldstockval(x) - stockval(x)
                l = l + 1
        END IF
NextTime3:
NEXT x
getpress

CLS
LOCATE 1, 2: PRINT "#"
LOCATE 1, 5: PRINT "Name"
LOCATE 1, 26: PRINT "Value"
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
l = 3
FOR x = 21 TO 40
        IF stock$(x) = "" THEN GOTO NextTimeMoreLa
        IF oldstockval(x) > stockval(x) THEN
                LOCATE l, 1: PRINT x
                IF stock(x, player) > 0 THEN COLOR 15
                LOCATE l, 5: PRINT stock$(x)
                COLOR 7
                LOCATE l, 26: PRINT "$"; stockval(x)
                LOCATE l, 35: PRINT "-"; oldstockval(x) - stockval(x)
                l = l + 1
        END IF
NextTimeMoreLa:
NEXT x
getpress

CLS
LOCATE 1, 2: PRINT "#"
LOCATE 1, 5: PRINT "Name"
LOCATE 1, 26: PRINT "Value"
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
l = 3
FOR x = 41 TO 60
        IF stock$(x) = "" THEN GOTO NextTimeYouToo
        IF oldstockval(x) > stockval(x) THEN
                LOCATE l, 1: PRINT x
                IF stock(x, player) > 0 THEN COLOR 15
                LOCATE l, 5: PRINT stock$(x)
                COLOR 7
                LOCATE l, 26: PRINT "$"; stockval(x)
                LOCATE l, 35: PRINT "-"; oldstockval(x) - stockval(x)
                l = l + 1
        END IF
NextTimeYouToo:
NEXT x
getpress

CLS
LOCATE 1, 2: PRINT "#"
LOCATE 1, 5: PRINT "Name"
LOCATE 1, 26: PRINT "Value"
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
l = 3
FOR x = 61 TO 80
        IF stock$(x) = "" THEN GOTO NextTimeMoreLaLa
        IF oldstockval(x) > stockval(x) THEN
                LOCATE l, 1: PRINT x
                IF stock(x, player) > 0 THEN COLOR 15
                LOCATE l, 5: PRINT stock$(x)
                COLOR 7
                LOCATE l, 26: PRINT "$"; stockval(x)
                LOCATE l, 35: PRINT "-"; oldstockval(x) - stockval(x)
                l = l + 1
        END IF
NextTimeMoreLaLa:
NEXT x
getpress


END SUB

'
SUB NewStockValue (name$)
FOR x = 1 TO 80
        stockval(x) = INT(stockval(x))
        IF stock$(x) = "" THEN GOTO NextTime4
        IF stockval(x) >= 2.4 * origstockval(x) THEN GOSUB Split2For1
        trend(x) = trend(x) - (CSNG(.4 * RND) - CSNG(.3 * RND))
        i = INT(150 * RND)
        IF i = 52 THEN
                'whoa!  stock is about to die
                'the trendy stock's worst nightmare
                trend(x) = 0
                'it had to end sometime.
        END IF
        d = INT(trend(x) * RND)
        IF d = 0 THEN
                stockval(x) = stockval(x) - INT((.15 * origstockval(x)) * RND)
        ELSE
                stockval(x) = stockval(x) + INT((.15 * origstockval(x)) * RND)
        END IF
        IF stockval(x) < INT(.05 * origstockval(x)) THEN
                reason$ = "The value fell too low to be maintained."
                GOSUB StockIsDead
                GOSUB ItsAllGone
        END IF
        i = INT(2000 * RND)
        IF i < 1 THEN
                reason$ = "The company was taken over by corrupt businessmen and it fell."
                GOSUB StockIsDead
                GOSUB ItsAllGone
        END IF
NextTime4:
NEXT
AnyNewStocks'?
GOTO EndOfSub
StockIsDead:
        CLS
        BEEP: FOR i = 1 TO 4000: NEXT i: BEEP
        PRINT
        PRINT
        COLOR 15
        Center 3, "** News Flash **"
        COLOR 7
        LOCATE 5, 4: PRINT stock$(x); " stock has crashed!  The value of it"
        LOCATE 6, 4: PRINT "is now 0 and your holdings are now 0."
        LOCATE 8, 4: PRINT "Reason: "; reason$
        WHILE INKEY$ = "": WEND
        RETURN
ItsAllGone:
        stock$(x) = ""
        origstockval(x) = 0
        stockval(x) = 0
        oldstockval(x) = 0
        FOR y = 1 TO 6
        stock(x, y) = 0
        NEXT y
        RETURN
Split2For1:
        CLS
        BEEP: pause .5: BEEP
        COLOR 15
        FOR z = 1 TO players
        stock(x, z) = stock(x, z) * 2
        NEXT z
        stockval(x) = stockval(x) / 2
        Center 2, "****************"
        Center 3, "*  NEWS FLASH  *"
        Center 4, "****************"
        COLOR 7
        LOCATE 6, 10: PRINT stock$(x); " stock's value has skyrocketed so high"
        LOCATE 7, 10: PRINT "and its popularity has been so amazingly great"
        LOCATE 8, 10: PRINT "that it has split 2 for 1!!!"
        Center 10, "New Holdings:"
        l = 13
        FOR i = 1 TO 6
                IF name$(i) = "" THEN GOTO nexti
                LOCATE l, 10: PRINT name$(i); ": "; stock(x, i); "shares at a value of"; stockval(x); "each"
                l = l + 1
nexti:
        NEXT i
        pause 5
        RETURN
EndOfSub:
money(player) = INT(money(player))
END SUB

SUB pause (howlong)
starttime = TIMER
WHILE howlong > timepast
        timepast = TIMER - starttime
7 IF INKEY$ <> "" THEN EXIT SUB
WEND
END SUB

'
SUB Rainbow (row, column, text$)
SCREEN 13
a = LEN(text$)
x = 33
y = 55
keepgoing:
FOR i = x TO x + a - 1
        COLOR i
        LOCATE row, i - x + 1 + column
        PRINT MID$(text$, i - x + 1, 1)
        FOR z = 1 TO 100: NEXT
        IF INKEY$ <> "" THEN GOTO exitsub
NEXT
x = x + 1: IF x = 56 THEN x = 33
GOTO keepgoing
exitsub:
SCREEN 9
END SUB

'
SUB RisenStock
CLS
LOCATE 1, 2: PRINT "#"
LOCATE 1, 5: PRINT "Name"
LOCATE 1, 26: PRINT "Value"
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
l = 3
FOR x = 1 TO 20
        IF stock$(x) = "" THEN GOTO NextTime2
        IF oldstockval(x) < stockval(x) THEN
                LOCATE l, 1: PRINT x
                IF stock(x, player) > 0 THEN COLOR 15
                LOCATE l, 5: PRINT stock$(x)
                COLOR 7
                LOCATE l, 26: PRINT stockval(x)
                LOCATE l, 33: PRINT "+"; stockval(x) - oldstockval(x)
                l = l + 1
        END IF
NextTime2:
NEXT x
getpress
CLS
LOCATE 1, 2: PRINT "#"
LOCATE 1, 5: PRINT "Name"
LOCATE 1, 26: PRINT "Value"
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
l = 3

FOR x = 21 TO 40
        IF stock$(x) = "" THEN GOTO NextTimeAgainSomeMore
        IF oldstockval(x) < stockval(x) THEN
                LOCATE l, 1: PRINT x
                IF stock(x, player) > 0 THEN COLOR 15
                LOCATE l, 5: PRINT stock$(x)
                COLOR 7
                LOCATE l, 26: PRINT stockval(x)
                LOCATE l, 33: PRINT "+"; stockval(x) - oldstockval(x)
                l = l + 1
        END IF
NextTimeAgainSomeMore:
NEXT x
getpress

CLS
LOCATE 1, 2: PRINT "#"
LOCATE 1, 5: PRINT "Name"
LOCATE 1, 26: PRINT "Value"
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
l = 3

FOR x = 41 TO 60
        IF stock$(x) = "" THEN GOTO NextTimeAgainEvenMore
        IF oldstockval(x) < stockval(x) THEN
                LOCATE l, 1: PRINT x
                IF stock(x, player) > 0 THEN COLOR 15
                LOCATE l, 5: PRINT stock$(x)
                COLOR 7
                LOCATE l, 26: PRINT stockval(x)
                LOCATE l, 33: PRINT "+"; stockval(x) - oldstockval(x)
                l = l + 1
        END IF
NextTimeAgainEvenMore:
NEXT
getpress

CLS
LOCATE 1, 2: PRINT "#"
LOCATE 1, 5: PRINT "Name"
LOCATE 1, 26: PRINT "Value"
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
l = 3
FOR x = 61 TO 80
        IF stock$(x) = "" THEN GOTO NextTimeAgainSomeMoreYetMore
        IF oldstockval(x) < stockval(x) THEN
                LOCATE l, 1: PRINT x
                IF stock(x, player) > 0 THEN COLOR 15
                LOCATE l, 5: PRINT stock$(x)
                COLOR 7
                LOCATE l, 26: PRINT stockval(x)
                LOCATE l, 33: PRINT "+"; stockval(x) - oldstockval(x)
                l = l + 1
        END IF
NextTimeAgainSomeMoreYetMore:
NEXT x
getpress

END SUB

SUB SaveGame (name$, day, DayOfWeek, month, year)
MoronKilledIt:
CLS
COLOR 15
Center 1, "* Save Game *"
COLOR 7
LOCATE 3, 1: INPUT "What directory"; directory$
SHELL directory$
SHELL "DIR .SAV"

LOCATE 13, 4: INPUT "What is the save name for your file (no ext.)"; filename$
filename$ = filename$ + ".sav"
OPEN filename$ FOR APPEND AS #1
PRINT #1, "hi"
CLOSE
KILL filename$
OPEN filename$ FOR APPEND AS #1
WRITE #1, player
WRITE #1, players
WRITE #1, days
WRITE #1, day
WRITE #1, DayOfWeek
WRITE #1, month
WRITE #1, year
WRITE #1, turn
FOR la = 1 TO players
WRITE #1, name$(la)
WRITE #1, loan(la)
WRITE #1, bankaccount(la)
WRITE #1, money(la)
NEXT la

FOR x = 1 TO 80
        WRITE #1, stock$(x): IF stock$(x) = "" THEN WRITE #1, "Untaken"
        WRITE #1, origstockval(x)
        WRITE #1, oldstockval(x)
        WRITE #1, stockval(x)
        WRITE #1, trend(x)
        WRITE #1, trendold(x)
NEXT x

FOR x = 1 TO 80
FOR la = 1 TO players
WRITE #1, stock(x, la)
NEXT la
NEXT x

LOCATE 15, 1: PRINT "Your file has been saved as "; LCASE$(filename$); "."
getpress
CLOSE
END SUB

SUB SellStock
TopOfDeScreen:
CLS
COLOR 15
Center 1, "Sell Stocks"
COLOR 7
LOCATE 2, 2: PRINT "#"
LOCATE 2, 5: PRINT "Name"
LOCATE 2, 30: PRINT "Value"
LOCATE 2, 37: PRINT "Quantity"
LOCATE 2, 48: PRINT "Total val."
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
l = 4
FOR x = 1 TO 80
        IF stock(x, player) > 0 THEN
                LOCATE l, 1: PRINT x
                LOCATE l, 5: PRINT stock$(x)
                LOCATE l, 30: PRINT "$"; stockval(x)
                LOCATE l, 36: PRINT stock(x, player)
                LOCATE l, 48: PRINT "$"; stockval(x) * stock(x, player)
                l = l + 1
        END IF
NEXT
DO
DO
LOCATE 20, 1: PRINT "(Type '0' to exit)"
LOCATE 19, 1: INPUT "Which stock (1-80) would you like to sell"; sell
IF sell = 0 THEN EXIT SUB
LOOP UNTIL sell > 0 AND sell < 81
LOOP UNTIL stock$(sell) <> ""
IF stock(sell, player) = 0 THEN LOCATE 21, 1: PRINT "You have no shares in "; stock$(sell); " stock.": getpress:  GOTO TopOfDeScreen
LOCATE 20, 1: PRINT "You have"; stock(sell, player); "shares in "; stock$(sell); " stock.  How many do"
LOCATE 21, 1: INPUT "you want to sell"; howmany
IF howmany < 0 OR howmany > stock(sell, player) THEN PRINT "You don't have that many!": CALL getpress: GOTO TopOfDeScreen
LOCATE 22, 1: PRINT "You sold"; howmany; "of "; stock$(sell); " stock for $"; howmany * stockval(sell)
money(player) = money(player) + (stockval(sell) * howmany)
stock(sell, player) = stock(sell, player) - howmany
getpress
GOTO TopOfDeScreen
END SUB

SUB tips
CLS
COLOR 2
Center 1, "Tips for 'Stock Market Shark'"
PRINT : PRINT
COLOR 15
PRINT "[1] Don't invest in really cheap stocks for too long.  It's a very"
PRINT "    risky thing to do."
PRINT "[2] Change your holdings once in a while."
PRINT "[3] First invest in cheap stocks for a time, and then start investing"
PRINT "    in the more expensive ones."
PRINT "[4] It's likely a good idea to spread your investments out, but don't"
PRINT "    too much."

'there will undoubtedly be more after beta testing
'and I actually finish the program
getpress
END SUB

'
SUB YourStocks
CLS
LOCATE 1, 2: PRINT "#"
LOCATE 1, 5: PRINT "Name"
LOCATE 1, 27: PRINT "Value"
LOCATE 1, 34: PRINT "Shares"
LOCATE 1, 42: PRINT "Change since last turn"
LOCATE 2, 59: PRINT "Cash on Hand: $"; money(player)
l = 3
FOR x = 1 TO 80
        IF stock(x, player) > 0 AND stock$(x) <> "" THEN
                LOCATE l, 1: PRINT x
                LOCATE l, 5: PRINT stock$(x)
                LOCATE l, 27: PRINT "$"; stockval(x)
                LOCATE l, 34: PRINT stock(x, player)
                LOCATE l, 41
                IF stockval(x) - oldstockval(x) > 0 THEN
                        PRINT "+";
                END IF
                PRINT stockval(x) - oldstockval(x)
                l = l + 1
        END IF
NEXT x
WHILE INKEY$ = "": WEND
END SUB

