'---- -  
'           ** SMILEYS SMALL ADVENTURE (MAPMAKER) **
'                  Created by Davey W Taylor
'
' This program is used to convert maps from ASCII format to BINARY
' used my Smileys Small Adventure. To create your own levels follow
' theese directions: An ASCII level file should look like this:
'
' Level Title
' Width,Height
' ASCII Level
'
' Theese are the ASCII chars:
'  X - Black             - Floor           W - Wall
'  1 - 10 point bonus  2 - 100 points      3 - 1000 points
'  r - Red key         g - Green key       b - Blue key
'  R - Red door        G - Green door      B - Blue door
'  L - Life            S - Start           E - Exit
'  D - Secret door     T - Trap
'
' Check out SSA1.ASC for an example of an ASCII level
'---     
' ** If you have any comments / suggestions / questions, my email is: **
' ** audio.squad@mailbox.swipnet.se                         <<< EMAIL **
CLS
PRINT "MAP converter for Smileys Small Adventure (SMILEY.BAS)"
PRINT
LINE INPUT "Input (ASCII file)                                : ", i$
LINE INPUT "Output(BINARY file - SSAx.MAP where x=level number: ", o$
OPEN i$ FOR INPUT AS #1
 OPEN o$ FOR OUTPUT AS #2
 LINE INPUT #1, t$
 x$ = CHR$(LEN(t$))
 PRINT #2, x$; t$;
 INPUT #1, xs$, ys$
 x$ = CHR$(VAL(xs$)) + CHR$(VAL(ys$))
 PRINT #2, x$;
 PRINT VAL(xs$); VAL(ys$)
 FOR y% = 1 TO VAL(ys$)
  INPUT #1, x$
  FOR x% = 1 TO VAL(xs$)
   SELECT CASE MID$(x$, x%, 1)
    CASE "X", "x": o% = 0
    CASE " ": o% = INT(RND * 4) + 5
    CASE "W", "w": o% = INT(RND * 3) + 1
    CASE "1": o% = 9
    CASE "2": o% = 10
    CASE "3": o% = 11
    CASE "r": o% = 12
    CASE "g": o% = 13
    CASE "b": o% = 14
    CASE "R": o% = 15
    CASE "G": o% = 16
    CASE "B": o% = 17
    CASE "L", "l": o% = 18
    CASE "S", "s": o% = 19
    CASE "E", "e": o% = 20
    CASE "D", "d": o% = 21
    CASE "T", "t": o% = 22
    CASE ELSE: o% = 0
   END SELECT
   PRINT #2, CHR$(o%);
  NEXT x%
 NEXT y%
CLOSE #1, #2
PRINT "Don't forget!! If you create any great levels, please send them to me!!!"
PRINT "My email is: audio.squad@mailbox.swipnet.se"

