unit routines;

interface

procedure setmode(mode : byte);
procedure plot (x,y : word; colour : byte);
procedure fastclear (colour : byte);
procedure fastcleararea(colour : byte; x,y,length,height : word);
procedure setcolour(number : word; red,green,blue : byte);

implementation

procedure setmode(mode : byte); assembler;

asm
  mov ah,0
  mov al,mode
  int $10

end;

procedure plot (x,y : word; colour : byte); assembler;

asm
  mov ax,$0a000
  mov es,ax
  mov bx,y
  mov ax,320
  mul bx
  mov bx,x
  add ax,bx
  mov di,ax
  mov al,colour
  stosb
end;

procedure fastclear (colour : byte); assembler;
asm
  mov ax,$0a000
  mov es,ax
  xor di,di
  mov cx,64000
  mov al,colour
  rep stosb
end;

procedure fastcleararea(colour : byte; x,y,length,height : word); assembler;

asm
  mov ax,$0a000
  mov es,ax
  xor di,di
  mov bx,y
  mov ax,320
  mul bx
  mov bx,x
  add ax,bx
  mov di,ax
  mov ax,320
  mov bx,length
  sub ax,bx
  mov bx,ax
  mov dx,height
  mov al,colour
 @myloop:
  mov cx,length
  rep stosb
  dec dx
  add di,bx
  cmp dx,0
  jnz @myloop
end;

procedure setcolour(number : word; red,green,blue : byte); assembler;

asm
  mov ax,$1010
  mov bx,number
  mov ch,green
  mov cl,blue
  mov dh,red
  int $010


end;

end.