'                                     
'       ۰           ۰              ۱
'       ۰    ۰  ۰    ۰  ۰   ۰  ۰    ۰     ۱    ۱        
'          ۰    ۰  ۰   ۰  ۰           ۱       ۱
'       ۰   ۰    ۰  ۰   ۰  ۰          ۱       
'       ۰        ۰    ۰  ۰   ۰  ۰   ۰          ۱      ۱
'       ۰            ۰    ۰                 
'                                              
'
'                           L E V E L  E D I T O R
'
'       Copyright (C) DarkDreams Software, 1997
'
'       Programmed by: DarkDread
'
'       darkdread@geocities.com
'       http://www.GeoCities.com/SiliconValley/Pines/1732/
'
'       You can use this editor to create *.p97 level files which are
'       compatible with Pong 97.  Note that, although you can load and edit
'       the first 15 level??.p97 files, you cannot save your modified versions
'       as level??.p97 files.
'
'       To select a block, just enter the number or letter beside the block
'       description while in the editor.
'
'       0 - Blank (Use to erase unwanted blocks)
'       1 - Flashing wall block
'       2 - Steel wall block
'       3 - Player two slow down
'       4 - Player one slow down
'       5 - Player one speed up
'       6 - Player two speed up
'       7 - Player two extend
'       8 - Player one extend
'       9 - Player one shrink
'       A - Player two shrink
'       B - Pulsating block
'       C - Face of evil
'       D - Castle wall block
'
'       To load a level, just press 'l' while in the editor and enter the
'       name (No extension) of the level you wish to load.
'       To save, just hit Esc to exit and it will prompt you to save.  Hit
'       'y' and then type in a name (No extension) and your level will be
'       saved.  No you can load PONG97.BAS and play your own level!
'
'       If you fancy your levels to be good then, by all means, send them to
'       me (darkdread@geocities.com), and I'll put them up on my page with
'       your name beide 'em!
'
'       Enjoy.
'
'                       Hail from the Darkness...
'
'                                                ... DarkDread
'

DECLARE SUB Fence ()
DECLARE SUB SelectFence ()
DECLARE SUB SaveLevel ()
DECLARE SUB EnterName ()
DECLARE SUB Pulse ()
DECLARE SUB DrawField ()
DECLARE SUB LoadLevel ()
DECLARE SUB LoadBlocks ()
DECLARE SUB CursorBlink ()
DECLARE SUB PutCursor ()
DECLARE SUB PutOld ()
DECLARE SUB UpdateStatus ()

DEFINT A-Z

CONST True = -1, False = 0

DIM SHARED Block1(201)
DIM SHARED Block2(201)
DIM SHARED Block3(201)
DIM SHARED Block4(201)
DIM SHARED Block5(201)
DIM SHARED Block6(201)
DIM SHARED Block7(201)
DIM SHARED Block8(201)
DIM SHARED Block9(201)
DIM SHARED Block10(201)
DIM SHARED Block11(201)
DIM SHARED Block12(201)
DIM SHARED Block13(201)
DIM SHARED Cursor(201)
DIM SHARED CursorMask(201)

DIM SHARED Level(1 TO 16, 1 TO 9)

DIM SHARED CursorX AS INTEGER, CursorY AS INTEGER
DIM SHARED Colour AS INTEGER
DIM SHARED CurrentBlock AS INTEGER
DIM SHARED FenceType AS INTEGER
DIM SHARED Name$
DIM SHARED FileExist AS INTEGER

ON ERROR GOTO ErrorHandler

Colour = 9
CursorX = 2: CursorY = 2
Green = 34: Red = 9: Blue = 34

SCREEN 13

CALL LoadBlocks
CALL SelectFence
CALL DrawField
CALL PutCursor

DO
   
    SELECT CASE INKEY$
    CASE CHR$(0) + CHR$(72)
        CALL PutOld
        CursorY = CursorY - 1
        IF CursorY = 1 THEN CursorY = 2
        CALL PutCursor
    CASE CHR$(0) + CHR$(80)
        CALL PutOld
        CursorY = CursorY + 1
        IF CursorY = 9 THEN CursorY = 8
        CALL PutCursor
    CASE CHR$(0) + CHR$(77)
        CALL PutOld
        CursorX = CursorX + 1
        IF CursorX = 16 THEN CursorX = 15
        CALL PutCursor
    CASE CHR$(0) + CHR$(75)
        CALL PutOld
        CursorX = CursorX - 1
        IF CursorX = 1 THEN CursorX = 2
        CALL PutCursor
    CASE CHR$(32)
        IF CursorX > 7 AND CursorX < 10 AND CursorY > 3 AND CursorY < 6 THEN
            ELSE
                Level(CursorX, CursorY) = CurrentBlock
                CALL PutOld
                CALL PutCursor
        END IF
    CASE IS = "0"
        CurrentBlock = 0
        CALL UpdateStatus
    CASE IS = "1"
        CurrentBlock = 1
        CALL UpdateStatus
    CASE IS = "2"
        CurrentBlock = 2
        CALL UpdateStatus
    CASE IS = "3"
        CurrentBlock = 3
        CALL UpdateStatus
    CASE IS = "4"
        CurrentBlock = 4
        CALL UpdateStatus
    CASE IS = "5"
        CurrentBlock = 5
        CALL UpdateStatus
    CASE IS = "6"
        CurrentBlock = 6
        CALL UpdateStatus
    CASE IS = "7"
        CurrentBlock = 7
        CALL UpdateStatus
    CASE IS = "8"
        CurrentBlock = 8
        CALL UpdateStatus
    CASE IS = "9"
        CurrentBlock = 9
        CALL UpdateStatus
    CASE IS = "A", "a"
        CurrentBlock = 10
        CALL UpdateStatus
    CASE IS = "B", "b"
        CurrentBlock = 11
        CALL UpdateStatus
    CASE IS = "C", "c"
        CurrentBlock = 12
        CALL UpdateStatus
    CASE IS = "D", "d"
        CurrentBlock = 13
        CALL UpdateStatus
    CASE IS = "l", "L"
        LINE (40, 79)-(280, 119), 0, BF
        LOCATE 12, 15
        PRINT "Load? [y/n]"
        GetLevel$ = LCASE$(INPUT$(1))

        IF GetLevel$ = "y" THEN

            LOCATE 12, 5
            PRINT "Enter a name: ........"
            CALL EnterName
            FileExist = True
            Action$ = "load"
            OPEN Name$ + ".p97" FOR INPUT AS #1
            CLOSE #1
            IF FileExist THEN
                CALL LoadLevel
            END IF
            Name$ = ""

        END IF
        CALL DrawField
        CALL PutCursor

    CASE CHR$(27)
        Done = True
    END SELECT

    CALL CursorBlink
    CALL Pulse

LOOP UNTIL Done

LINE (40, 79)-(280, 119), 0, BF
LOCATE 12, 15
PRINT "Save? [y/n]"
PutLevel$ = LCASE$(INPUT$(1))

IF PutLevel$ = "y" THEN
   
    Action$ = "save"
    DO
        Name$ = ""
        LOCATE 12, 5
        PRINT "Enter a name: ........       "
        CALL EnterName
        OPEN Name$ + ".p97" FOR INPUT AS #1
        CLOSE #1
        IF FileExist AND INSTR(LCASE$(Name$), "level") = 0 AND Name$ <> "" THEN
            LOCATE 12, 5
            PRINT "File exists! Overwrite? [y/n]"
            Choice$ = LCASE$(INPUT$(1))
            IF Choice$ = "y" THEN FileExist = False ELSE FileExist = True
        END IF

        IF INSTR(LCASE$(Name$), "level") = 0 AND NOT FileExist AND Name$ <> "" THEN
                CALL SaveLevel
                Correct = True
            ELSEIF INSTR(LCASE$(Name$), "level") <> 0 THEN
                LOCATE 12, 5
                PRINT "Not a valid name!        "
                WHILE INKEY$ = "": WEND
        END IF
        FileExist = True

    LOOP UNTIL Correct

END IF

SYSTEM

ErrorHandler:
SELECT CASE ERR
CASE IS = 53
    IF Action$ = "save" THEN
            FileExist = False
            RESUME NEXT
        ELSEIF Action$ = "load" THEN
            FileExist = False
            LOCATE 12, 5
            PRINT "File not found!            "
            WHILE INKEY$ = "": WEND
            RESUME NEXT
    END IF
CASE IS = 64
    IF Action$ = "save" THEN
        LOCATE 12, 5
        PRINT "Not a valid file name!"
        WHILE INKEY$ = "": WEND
        RESUME NEXT
    END IF
CASE ELSE
    SCREEN 0: WIDTH 80
    PRINT "An unexpected program error has occured.  The error code was:"; ERR
    PRINT "Why not be a dear (Or a moose, if you want), and e-mail me with the error code  "
    PRINT "number.  Thanks.                                         darkdread@geocities.com"
    WHILE INKEY$ = "": WEND
END SELECT

SYSTEM

SUB CursorBlink STATIC

    Colour = Colour + 1
    IF Colour = 60 THEN Colour = 10
   
    OUT &H3C8, 250: OUT &H3C9, Colour: OUT &H3C9, Colour: OUT &H3C9, Colour

END SUB

SUB DrawField
   
    LINE (0, 0)-(319, 199), 0, BF

    LINE (0, 0)-(319, 19), 195, B
    LINE (1, 1)-(318, 18), 120, B
    LINE (2, 2)-(317, 17), 10, B
    LINE (3, 3)-(316, 16), 120, B

    CALL Fence
    CALL UpdateStatus
  
    FOR Y = 2 TO 8
        FOR X = 2 TO 15
            IF Level(X, Y) = 0 THEN
                    LINE ((X - 1) * 20, Y * 20)-(((X - 1) * 20) + 19, (Y * 20) + 19), 0, BF
                ELSEIF Level(X, Y) = 1 THEN
                    PUT ((X - 1) * 20, Y * 20), Block1, PSET
                ELSEIF Level(X, Y) = 2 THEN
                    PUT ((X - 1) * 20, Y * 20), Block2, PSET
                ELSEIF Level(X, Y) = 3 THEN
                    PUT ((X - 1) * 20, Y * 20), Block3, PSET
                ELSEIF Level(X, Y) = 4 THEN
                    PUT ((X - 1) * 20, Y * 20), Block4, PSET
                ELSEIF Level(X, Y) = 5 THEN
                    PUT ((X - 1) * 20, Y * 20), Block5, PSET
                ELSEIF Level(X, Y) = 6 THEN
                    PUT ((X - 1) * 20, Y * 20), Block6, PSET
                ELSEIF Level(X, Y) = 7 THEN
                    PUT ((X - 1) * 20, Y * 20), Block7, PSET
                ELSEIF Level(X, Y) = 8 THEN
                    PUT ((X - 1) * 20, Y * 20), Block8, PSET
                ELSEIF Level(X, Y) = 9 THEN
                    PUT ((X - 1) * 20, Y * 20), Block9, PSET
                ELSEIF Level(X, Y) = 10 THEN
                    PUT ((X - 1) * 20, Y * 20), Block10, PSET
                ELSEIF Level(X, Y) = 11 THEN
                    PUT ((X - 1) * 20, Y * 20), Block11, PSET
                ELSEIF Level(X, Y) = 12 THEN
                    PUT ((X - 1) * 20, Y * 20), Block12, PSET
                ELSEIF Level(X, Y) = 13 THEN
                    PUT ((X - 1) * 20, Y * 20), Block13, PSET
            END IF
        NEXT X
    NEXT Y

END SUB

SUB EnterName STATIC
           
    DO
       
        N$ = INPUT$(1)
        IF N$ = CHR$(8) THEN
            IF Length = 9 THEN Length = 8
            IF Length <> 0 THEN Length = Length - 1
            Name$ = LEFT$(Name$, Length)
            LOCATE 12, 19: PRINT Name$ + "."
        END IF
        IF N$ = CHR$(13) AND Length > 0 THEN EXIT DO
        IF N$ <> CHR$(8) THEN
            IF N$ > CHR$(47) AND N$ < CHR$(58) OR N$ > CHR$(64) AND N$ < CHR$(91) OR N$ > CHR$(96) AND N$ < CHR$(123) THEN
                Name$ = Name$ + N$
                IF Length < 8 THEN Length = Length + 1
            END IF
        END IF
        IF Length = 8 THEN Name$ = LEFT$(Name$, 8)
        LOCATE 12, 19: PRINT Name$
   
    LOOP

END SUB

SUB Fence

    IF FenceType = 1 THEN
            FOR Y = 20 TO 198 STEP 20
                PUT (0, Y), Block2, PSET
                PUT (300, Y), Block2, PSET
            NEXT Y
        ELSEIF FenceType = 2 THEN
            FOR Y = 20 TO 198 STEP 20
                PUT (0, Y), Block11, PSET
                PUT (300, Y), Block11, PSET
            NEXT Y
        ELSEIF FenceType = 3 THEN
            FOR Y = 20 TO 198 STEP 20
                PUT (0, Y), Block13, PSET
                PUT (300, Y), Block13, PSET
            NEXT Y
    END IF

END SUB

SUB LoadBlocks
   
    DEF SEG = VARSEG(Block1(0)): BLOAD "BLOCK1.BSG", VARPTR(Block1(0))
    DEF SEG = VARSEG(Block2(0)): BLOAD "BLOCK2.BSG", VARPTR(Block2(0))
    DEF SEG = VARSEG(Block3(0)): BLOAD "BLOCK3.BSG", VARPTR(Block3(0))
    DEF SEG = VARSEG(Block4(0)): BLOAD "BLOCK4.BSG", VARPTR(Block4(0))
    DEF SEG = VARSEG(Block5(0)): BLOAD "BLOCK5.BSG", VARPTR(Block5(0))
    DEF SEG = VARSEG(Block6(0)): BLOAD "BLOCK6.BSG", VARPTR(Block6(0))
    DEF SEG = VARSEG(Block7(0)): BLOAD "BLOCK7.BSG", VARPTR(Block7(0))
    DEF SEG = VARSEG(Block8(0)): BLOAD "BLOCK8.BSG", VARPTR(Block8(0))
    DEF SEG = VARSEG(Block9(0)): BLOAD "BLOCK9.BSG", VARPTR(Block9(0))
    DEF SEG = VARSEG(Block10(0)): BLOAD "BLOCK10.BSG", VARPTR(Block10(0))
    DEF SEG = VARSEG(Block11(0)): BLOAD "BLOCK11.BSG", VARPTR(Block11(0))
    DEF SEG = VARSEG(Block12(0)): BLOAD "BLOCK12.BSG", VARPTR(Block12(0))
    DEF SEG = VARSEG(Block13(0)): BLOAD "BLOCK13.BSG", VARPTR(Block13(0))

    LINE (0, 0)-(19, 19), 250, B
    GET (0, 0)-(19, 19), Cursor
   
    LINE (0, 0)-(19, 19), 0, B
    LINE (1, 1)-(18, 18), 255, BF
    GET (0, 0)-(19, 19), CursorMask

    CLS

END SUB

SUB LoadLevel

    OPEN Name$ + ".p97" FOR INPUT AS #1

    INPUT #1, FenceType
    FOR Y = 2 TO 8
        FOR X = 2 TO 15
            INPUT #1, Level(X, Y)
        NEXT X
    NEXT Y

    CLOSE #1

END SUB

SUB Pulse STATIC
   
    Green = Green + 1: Red = Red + 1: Blue = Blue + 1
    IF Green = 61 THEN Green = 10
    IF Red = 61 THEN Red = 10
    IF Blue = 61 THEN Blue = 10

    OUT &H3C8, 254: OUT &H3C9, 0: OUT &H3C9, Green: OUT &H3C9, 0
    OUT &H3C8, 253: OUT &H3C9, Red: OUT &H3C9, 0: OUT &H3C9, 0
    OUT &H3C8, 252: OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, Blue

END SUB

SUB PutCursor
       
    PUT ((CursorX - 1) * 20, CursorY * 20), CursorMask, AND
    PUT ((CursorX - 1) * 20, CursorY * 20), Cursor, XOR

END SUB

SUB PutOld
           
    IF Level(CursorX, CursorY) = 0 THEN
             LINE ((CursorX - 1) * 20, CursorY * 20)-((CursorX - 1) * 20 + 19, (CursorY * 20) + 19), 0, BF
        ELSEIF Level(CursorX, CursorY) = 1 THEN
             PUT ((CursorX - 1) * 20, CursorY * 20), Block1, PSET
        ELSEIF Level(CursorX, CursorY) = 2 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block2, PSET
        ELSEIF Level(CursorX, CursorY) = 3 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block3, PSET
        ELSEIF Level(CursorX, CursorY) = 4 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block4, PSET
        ELSEIF Level(CursorX, CursorY) = 5 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block5, PSET
        ELSEIF Level(CursorX, CursorY) = 6 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block6, PSET
        ELSEIF Level(CursorX, CursorY) = 7 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block7, PSET
        ELSEIF Level(CursorX, CursorY) = 8 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block8, PSET
        ELSEIF Level(CursorX, CursorY) = 9 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block9, PSET
        ELSEIF Level(CursorX, CursorY) = 10 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block10, PSET
        ELSEIF Level(CursorX, CursorY) = 11 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block11, PSET
        ELSEIF Level(CursorX, CursorY) = 12 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block12, PSET
        ELSEIF Level(CursorX, CursorY) = 13 THEN
            PUT ((CursorX - 1) * 20, CursorY * 20), Block13, PSET
    END IF

END SUB

SUB SaveLevel
   
    OPEN Name$ + ".p97" FOR OUTPUT AS #1
   
    WRITE #1, FenceType
    FOR Y = 2 TO 8
        FOR X = 2 TO 15
            WRITE #1, Level(X, Y)
        NEXT X
    NEXT Y

    CLOSE #1

END SUB

SUB SelectFence

    COLOR 4
    LOCATE 9, 4
    PRINT "Select background block:  [1 - 3]"
    LOCATE 12, 4
    PRINT "1          2          3          "
    PUT (50, 88), Block2, PSET
    PUT (135, 88), Block11, PSET
    PUT (220, 88), Block13, PSET
   
    FenceType = VAL(INPUT$(1))
    IF FenceType < 1 OR FenceType > 3 THEN FenceType = 1

END SUB

SUB UpdateStatus
   
    COLOR 1
    LOCATE 2, 2
    PRINT "PONG 97 LEVEL EDIT"
    COLOR 2
    LOCATE 2, 23
    PRINT "CURRENT BLOCK:"
    LOCATE 2, 37
    PRINT USING "##"; CurrentBlock
    COLOR 15

END SUB

