program petris;

uses color,attools,tasten,mouse,font,filer;

type xytypus=record
                   x,y:integer;
             end;

const varname=                          'Petris.Var';
      hiscorefilename=                  'Petris.His';
      version=                          '2.4';
      text=                             'Visit http://www.datacomm.ch/asuter';

var xy       :array[1..7,1..4,1..4]      of xytypus;
    drill    :array[1..7,1..4,1..4]      of xytypus;
    free     :array[1..7,1..4,1..3,1..4] of xytypus;
    i        :array[1..5]                of integer;
    blockx   :                              integer;
    blocky   :                              integer;
    turbo    :                              integer;
    bloecke  :                              integer;
    linien   :                              integer;
    level    :                              integer;
    punkte   :                              integer;
    anzeigean:                              boolean;
    gameover :                              boolean;
    mouseja  :                              boolean;
    tasteja  :                              byte;
    taste    :                              byte;
    tasteo   :                              byte;
    blocktyp :                              byte;
    blockrich:                              byte;
    blocknext:                              byte;

procedure petbox(x,y:integer;col:byte);

const hcol:array [0..8] of byte =((0),(33),(48),(52),(40),(36),(65),(29),(19));
      marklinecol=55;

var i:integer;

begin
     box(x,y,x+9,y+9,col);
     fbox(x+1,y+1,x+8,y+8,hcol[col]);
end;

procedure polygon(col:byte);

var i:integer;

begin
     for i:=1 to 4 do
         petbox(blockx+xy[blocktyp,blockrich,i].x*10,
                blocky+xy[blocktyp,blockrich,i].y*10,col);
end;

procedure anzeige(on:boolean);

var i:integer;
    savemark:byte;

begin
     fbox(220,119,280,179,0);
     if on then
        for i:=1 to 4 do
            petbox(240+xy[blocknext,1,i].x*10,
                   139+xy[blocknext,1,i].y*10,blocknext);
end;

procedure message(s:string);

begin
     fbox(110,60,209,110,15);
     outtext(s,160-length(s)*2,82,0);
end;

procedure zaehler(bloeckeo,linieno,levelo,punkteo:integer);

begin
     outtext(int2str(bloeckeo),253,10,9);
     outtext(int2str(linieno),253,20,9);
     outtext(int2str(levelo),253,30,9);
     outtext(int2str(punkteo),253,40,9);
     outtext(int2str(bloecke),253,10,0);
     outtext(int2str(linien),253,20,0);
     outtext(int2str(level),253,30,0);
     outtext(int2str(punkte),253,40,0);
end;

procedure hiscore;

var f:file of byte;
    i:integer;

procedure writeif(s:string);

var b:byte;
    bc:byte;

begin
     for b:=1 to 12 do
         begin
              bc:=ord(s[b]);
              write(f,bc);
         end;
end;

function readif:string;

var s:string;
    b:byte;
    bc:byte;

begin
     s:='';
     for b:=1 to 12 do
         begin
              read(f,bc);
              s:=s+' ';
              s[b]:=chr(bc);
         end;
     readif:=s;
end;

begin
     assign(f,hiscorefilename);
     if not fileexist(hiscorefilename) then
        begin
             rewrite(f);
             writeif('PETRIS '+version+'  ');
             writeif('        1000');
             writeif('datacomm.ch ');
             writeif('         400');
             writeif('PETER SUTER ');
             writeif('         300');
             writeif('CLAU CURTINS');
             writeif('         200');
             writeif('TURBO PASCAL');
             writeif('         100');
             writeif('PETRIS '+version+'  ');
             writeif('         100');
             writeif('datacomm.ch ');
             writeif('          40');
             writeif('PETER SUTER ');
             writeif('          30');
             writeif('CLAU CURTINS');
             writeif('          20');
             writeif('TURBO PASCAL');
             writeif('          10');
             close(f);
        end;
     reset(f);
     for i:=1 to 10 do
         begin
              outtext(readif,10,10*i+30+((i-1) div 5)*20,2);
              outtext(readif,53,10*i+30+((i-1) div 5)*20,2);
         end;
     close(f);
end;

procedure gameovertest(var ende:boolean);

var i:integer;

begin
     ende:=false;
     for i:=1 to 4 do
         if getpixel(blockx+xy[blocktyp,blockrich,i].x*10+5,
                     blocky+xy[blocktyp,blockrich,i].y*10+5)<>0 then ende:=true;
end;

procedure linientest(wo:integer);

var i,ii:integer;
    full:boolean;
    farbe:array [1..10] of byte;
    opunkte:integer;

begin
     if (wo<180) and (wo>0) then
        begin
             full:=true;
             for i:=1 to 10 do
                 if getpixel(105+i*10,wo+3)=0 then full:=false;
             if full then
                begin
                     for i:=wo div 10 downto 1 do
                         begin
{                              sound((i mod 3)*10+300);}
                              for ii:=1 to 10 do
                                  farbe[ii]:=getpixel(105+ii*10,i*10-1);
                              for ii:=1 to 10 do
                                  petbox(100+ii*10,i*10,farbe[ii]);
                              fbox(110,0,209,9,0);
{                              nosound;}
                         end;
                     opunkte:=punkte;
                     inc(punkte,((180-wo) div 10) * ((level div 3)+1));
                     inc(linien);
                     if linien mod 10=0 then
                        begin
                             inc(level);
                             if turbo<19 then inc(turbo);
                             zaehler(bloecke,linien-1,level-1,opunkte);
                        end
                     else
                         begin
                             zaehler(bloecke,linien-1,level,opunkte);
                         end;
                end;
        end;
end;

procedure scoretest;

var f:file of byte;
    his:array [1..5,1..2] of record
                                   name:string;
                                   punlin:string;
                             end;
    rang:byte;

procedure writeif(s:string);

var b:byte;
    bc:byte;

begin
     for b:=1 to 12 do
         begin
              bc:=ord(s[b]);
              write(f,bc);
         end;
end;

function readif:string;

var s:string;
    b:byte;
    bc:byte;

begin
     s:='';
     for b:=1 to 12 do
         begin
              read(f,bc);
              s:=s+' ';
              s[b]:=chr(bc);
         end;
     readif:=s;
end;

begin
     assign(f,hiscorefilename);
     reset(f);
     for i[2]:=1 to 2 do
     begin
     rang:=6;
     for i[1]:=1 to 5 do
         begin
              his[i[1],i[2]].name:=readif;
              his[i[1],i[2]].punlin:=readif;
         end;
     if i[2]=1 then
        begin
             for i[1]:=1 to 5 do
                 if punkte>str2int(his[i[1],i[2]].punlin) then dec(rang);
        end
     else
         begin
              for i[1]:=1 to 5 do
                  if linien>str2int(his[i[1],i[2]].punlin) then dec(rang);
         end;
     if rang<>6 then
        begin
             for i[1]:=1 to 5 do
                 begin
                      outtext(his[i[1],i[2]].name,10,10*i[1]+30+(i[2]-1)*70,9);
                      outtext(his[i[1],i[2]].punlin,53,10*i[1]+30+(i[2]-1)*70,9);
                 end;
             for i[1]:=5 downto rang do
                 begin
                      his[i[1],i[2]].name:=his[i[1]-1,i[2]].name;
                      his[i[1],i[2]].punlin:=his[i[1]-1,i[2]].punlin;
                 end;
             his[rang,i[2]].name:='';
             if i[2]=1 then his[rang,i[2]].punlin:=int2str(punkte)
                       else his[rang,i[2]].punlin:=int2str(linien);
              while length(his[rang,i[2]].punlin)<12 do his[rang,i[2]].punlin:=' '+his[rang,i[2]].punlin;
             for i[1]:=1 to 5 do
                 begin
                      outtext(his[i[1],i[2]].name,10,10*i[1]+30+(i[2]-1)*70,2);
                      outtext(his[i[1],i[2]].punlin,53,10*i[1]+30+(i[2]-1)*70,2);
                 end;
             message('Bitte Name eingeben');
             intext('',his[rang,i[2]].name,6,10*rang+30+(i[2]-1)*70,2,9,12);
             his[rang,i[2]].name:=upstring(his[rang,i[2]].name);
             while length(his[rang,i[2]].name)<12 do his[rang,i[2]].name:=his[rang,i[2]].name+' ';
        end;
     end;
     close(f);
     rewrite(f);
     for i[2]:=1 to 2 do
     for i[1]:=1 to 5 do
         begin
              writeif(his[i[1],i[2]].name);
              writeif(his[i[1],i[2]].punlin);
         end;
     close(f);
end;

procedure initbild;

begin
     randomize;
     initgraphmode;
     fbox(0,0,319,199,9);
     fbox(110,0,209,179,0);
     outtext('Bloecke:',220,10,0);
     outtext('Linien :',220,20,0);
     outtext('Level  :',220,30,0);
     outtext('Punkte :',220,40,0);
     outtext('Petris '+version+' Copyright 1997',215,60,7);
     outtext('by Peter Suter',235,70,11);
     outtext('Idee:',215,80,7);
     outtext('Programming:',215,90,7);
     outtext('Systemprog.:',215,100,7);
     outtext('Peter Suter',270,80,4);
     outtext('Peter Suter',270,90,4);
     outtext('Clau Curtins',270,100,4);
     outtext('Hiscore:',41,10,1);
     outtext('Punkte:',43,27,4);
     outtext('Linien:',43,97,4);
     outtext(text,(320-strlen(text)) div 2,187,4);
     hiscore;
end;

procedure initconst;

var datei:file of xytypus;

begin
     assign(datei,varname);
     reset(datei);
     for i[1]:=1 to 7 do
         for i[2]:=1 to 4 do
             for i[3]:=1 to 4 do
                 read(datei,xy[i[1],i[2],i[3]]);
     for i[1]:=1 to 7 do
         for i[2]:=1 to 4 do
             for i[3]:=1 to 3 do
                 for i[4]:=1 to 4 do
                     read(datei,free[i[1],i[2],i[3],i[4]]);
     for i[1]:=1 to 6 do
         for i[2]:=1 to 4 do
             for i[3]:=1 to 4 do
                 read(datei,drill[i[1],i[2],i[3]]);
     close(datei);
end;

procedure initvar;


begin
     anzeigean:=true;
     gameover:=false;
     blocknext:=random(7)+1;
     turbo:=0;
     bloecke:=0;
     linien:=0;
     level:=0;
     punkte:=0;
end;

procedure initblock;

var savemark:byte;

begin
     for i[2]:=-1 to 2 do
         linientest(blocky+i[2]*10);
     blocktyp:=blocknext;
     blocknext:=random(7)+1;
     blockrich:=1;
     blockx:=150;
     blocky:=10;
     setmousexy(blockx,blocky);
     inc(bloecke);
     gameovertest(gameover);
     polygon(blocktyp);
     anzeige(anzeigean);
     zaehler(bloecke-1,linien,level,punkte);
end;

function frei(wahl:byte):boolean;

begin
     case wahl of
          1:if (getpixel(blockx+5+free[blocktyp,blockrich,1,1].x*10,blocky+5+free[blocktyp,blockrich,1,1].y*10)=0)
            and(getpixel(blockx+5+free[blocktyp,blockrich,1,2].x*10,blocky+5+free[blocktyp,blockrich,1,2].y*10)=0)
            and(getpixel(blockx+5+free[blocktyp,blockrich,1,3].x*10,blocky+5+free[blocktyp,blockrich,1,3].y*10)=0)
            and(getpixel(blockx+5+free[blocktyp,blockrich,1,4].x*10,blocky+5+free[blocktyp,blockrich,1,4].y*10)=0)
            then frei:=true
            else frei:=false;
          2:if (getpixel(blockx+5+free[blocktyp,blockrich,2,1].x*10,blocky+5+free[blocktyp,blockrich,2,1].y*10)=0)
            and(getpixel(blockx+5+free[blocktyp,blockrich,2,2].x*10,blocky+5+free[blocktyp,blockrich,2,2].y*10)=0)
            and(getpixel(blockx+5+free[blocktyp,blockrich,2,3].x*10,blocky+5+free[blocktyp,blockrich,2,3].y*10)=0)
            and(getpixel(blockx+5+free[blocktyp,blockrich,2,4].x*10,blocky+5+free[blocktyp,blockrich,2,4].y*10)=0)
            then frei:=true
            else frei:=false;
          3:if (getpixel(blockx+5+free[blocktyp,blockrich,3,1].x*10,blocky+5+free[blocktyp,blockrich,3,1].y*10)=0)
            and(getpixel(blockx+5+free[blocktyp,blockrich,3,2].x*10,blocky+5+free[blocktyp,blockrich,3,2].y*10)=0)
            and(getpixel(blockx+5+free[blocktyp,blockrich,3,3].x*10,blocky+5+free[blocktyp,blockrich,3,3].y*10)=0)
            and(getpixel(blockx+5+free[blocktyp,blockrich,3,4].x*10,blocky+5+free[blocktyp,blockrich,3,4].y*10)=0)
            then frei:=true
            else frei:=false;
     end;
end;

function drehen:boolean;

begin
     if (getpixel(blockx+5+drill[blocktyp,blockrich,1].x*10,blocky+5+drill[blocktyp,blockrich,1].y*10)=0)
     and(getpixel(blockx+5+drill[blocktyp,blockrich,2].x*10,blocky+5+drill[blocktyp,blockrich,2].y*10)=0)
     and(getpixel(blockx+5+drill[blocktyp,blockrich,3].x*10,blocky+5+drill[blocktyp,blockrich,3].y*10)=0)
     and(getpixel(blockx+5+drill[blocktyp,blockrich,4].x*10,blocky+5+drill[blocktyp,blockrich,4].y*10)=0)
     then drehen:=true
     else drehen:=false;
     if blocktyp=7 then drehen:=true;
end;

procedure play;

begin
     initblock;
     anzeige(anzeigean);
     repeat
           for i[1]:=1 to 20-turbo do
               begin
                    tasteo:=taste;
                    taste:=readport;
                    if (taste=tasteo)and(taste in [15,57,75,77,81]) then inc(tasteja)
                                                                    else tasteja:=1;
                    if not (tasteja in [0,2..7]) then
                       begin
                            if taste<$80 then polygon(0);
                            case taste of
                                 75:if frei(1) then begin dec(blockx,10); setmousexy(blockx,blocky); end;
                                 77:if frei(2) then begin inc(blockx,10); setmousexy(blockx,blocky); end;
                                 80:if frei(3) then begin inc(blocky,10); i[1]:=1; setmousexy(blockx,blocky); end;
                                 81:begin while frei(3) do inc(blocky,10); i[1]:=20-turbo; end;
                                 57:if drehen then begin inc(blockrich);if blockrich>4 then blockrich:=1; end;
                                 15:begin anzeigean:=not(anzeigean); anzeige(anzeigean); end;
                                  1:break;
                            end;
                            if taste<$80 then polygon(blocktyp);
                            if (taste=80) and not frei(3) then initblock;
                       end;
                    if (getmousex+10<=blockx) and frei(1) then
                       begin
                            polygon(0);
                            dec(blockx,10);
                            polygon(blocktyp);
                       end;
                    if (getmousex-10>=blockx) and frei(2) then
                       begin
                            polygon(0);
                            inc(blockx,10);
                            polygon(blocktyp);
                       end;
                    if (getmousey-10>=blocky) and frei(3) then
                       begin
                            polygon(0);
                            inc(blocky,10);
                            i[1]:=1;
                            polygon(blocktyp);
                       end;
                    if (getmousekey=1) and drehen  and mouseja then
                       begin
                            polygon(0);
                            inc(blockrich);
                            if blockrich>4 then blockrich:=1;
                            polygon(blocktyp);
                            mouseja:=false;
                       end;
                    if (getmousekey=2) and mouseja then
                       begin
                            polygon(0);
                            while frei(3) do
                                  begin
                                       inc(blocky,10);
                                       i[1]:=20-turbo;
                                  end;
                            polygon(blocktyp);
                            mouseja:=false;
                       end;
                    if getmousekey=0 then mouseja:=true;
                    nokey;
                    if gameover then break;
                    wait(40);
               end;
           if frei(3) then
              begin
                   polygon(0);
                   inc(blocky,10);
                   polygon(blocktyp);
              end
           else
               begin
                    if not gameover then initblock;
               end;
     until (taste=1) or gameover;
     if gameover then
        begin
             for i[1]:=1 to 20 do
                 begin
{                      sound(i[1]*10+200);
                      delay(10);
                      nosound;            }
                 end;
             message('Game Over');
             wait(1000);
        end;
end;

begin
     if mouseloaded then initmouse(110,0,180,209);
     initconst;
     initbild;
     repeat
           fbox(110,0,209,179,0);
           fbox(250,0,319,50,9);
           initvar;
           zaehler(0,0,0,0);
           anzeige(false);
           message('Druecke eine Taste');
           nokey;
           repeat until key;
           fbox(110,0,209,179,0);
           play;
           scoretest;
           message('Noch ein Spiel?');
           repeat
                 taste:=ord(upcase(chr(readbyte)));
           until chr(taste) in ['J','N'];
     until chr(taste)='N';
     inittextmode;
end.