Unit Font;

{.$Define CrtHasNoBugs}

Interface

{$IfDef CrtHasNoBugs}
Uses Color,Tasten,ATTools,FX,Crt;
{$Else}
Uses Color,Tasten,ATTools,FX;
{$EndIf}

Const Text1='Visit http://www.datacomm.ch/asuter';

Const Ascii_Data:Array [0..45] Of Word=(0,                              { }
                                        23535,15083,29263,15211,29391,  {A,B,C,D,E}
                                        4815,31311,23533,9362,11044,    {F,G,H,I,J}
                                        23277,29257,23421,24573,11114,  {K,L,M,N,O}
                                        5103,15215,22511,31183,9367,    {P,Q,R,S,T}
                                        31597,11117,24429,23213,9389,   {U,V,W,X,Y}
                                        29351,                          {Z}        { <-  <=>?@ }
                                        2728,1488,5120,448,8192,        {*,+,,,-,.}
                                        5268,                           {/}
                                        11114,18740,29351,31143,18926,  {0,1,2,3,4}
                                        31183,31695,4775,10922,31215,   {5,6,7,8,9}
                                        1040,5136,                      {:,;}      { <-  [ }
                                        17553);                         {\}        { <-  ] }

      Ascii=[1..45];
      Breakable:Boolean=True;

Function StrLen(Text:String):Word;
Procedure OutChar(Letter:Char; X,Y:Word; Col:Byte);
Procedure OutText(Text:String; X,Y:Word; Col:Byte);
Procedure SpellText(Text:String; X,Y:Word; DelayTime:Word; Col:Byte);
Procedure FadeInText(Text:String; X,Y:Word; Col:Byte);
Procedure FadeOutText(Text:String; X,Y:Word; Col:Byte);
Procedure RollText(Text:String; X,Y:Word; DelayTime:Word; Col,DelCol:Byte);
Procedure InText(Message:String; Var Text:String; X,Y:Word; MaxLength:Word; Col,DelCol:Byte);

Implementation

Function StrLen;

Begin
     StrLen:=Length(Text)*4-1;
End;

Function ConvertChar(Letter:Char):Byte;

Begin
     Case Ord(Letter) Of
          65..90:ConvertChar:=Ord(Letter)-64;
          97..122:ConvertChar:=Ord(Letter)-96;
          42..59:ConvertChar:=Ord(Letter)-15;
          92:ConvertChar:=Ord(Letter)-47;

     Else ConvertChar:=0;
     End;
End;

Procedure OutChar;

Var I:Integer;

Begin
     For I:=1 To 15 Do
         If (Ascii_Data[ConvertChar(Letter)] And Hoch(2,I-1))=Hoch(2,I-1) Then
            PutPixel(X+((I-1) Mod 3),Y+((I-1) Div 3),Col);
End;

Procedure OutText;

Var I:Integer;

Begin
     If Length(Text)>0 Then
        For I:=1 To Length(Text) Do
            OutChar(Text[I],X+(I-1)*4,Y,Col);
End;

Procedure SpellText;

Var I:Integer;
    Breaked:Boolean;

Begin
     Breaked:=False;
     For I:=1 To Length(Text) Do
         Begin
              If Key Then Breaked:=True;
              NoKey;
              If ConvertChar(Text[I]) In Ascii Then
                 OutChar(Text[I],X+(I-1)*4,Y,Col);
              If Not(Breakable And Breaked) Then
                 Begin
{$IfDef CrtHasNoBugs}
                      If ConvertChar(Text[I]) in Ascii Then Sound(100);
                      Delay(3);
                      NoSound;
                      Delay(DelayTime);
{$Else}
                      Wait(DelayTime);
{$EndIf}
                 End;
         End;
End;

Procedure FadeInText;

Var I:Integer;
    SaveR,SaveG,SaveB:Byte;
    R,G,B:Byte;

Begin
     GetPal(Col,SaveR,SaveG,SaveB);
     R:=0;
     G:=0;
     B:=0;
     SetPal(Col,R,G,B);
     For I:=1 To Length(Text) Do
         OutChar(Text[I],X+(I-1)*4,Y,Col);
     For I:=0 To 63 Do
         Begin
              If R<SaveR Then Inc(R);
              If G<SaveG Then Inc(G);
              If B<SaveB Then Inc(B);
              SetPal(Col,R,G,B);
              WaitRetrace;
         End;
End;

Procedure FadeOutText;

Var I:Integer;
    R,G,B:Byte;

Begin
     For I:=1 To Length(Text) Do
         OutChar(Text[I],X+(I-1)*4,Y,Col);
     GetPal(Col,R,G,B);
     For I:=0 To 63 Do
         Begin
              If R>0 Then Dec(R);
              If G>0 Then Dec(G);
              If B>0 Then Dec(B);
              SetPal(Col,R,G,B);
              WaitRetrace;
         End;
End;

Procedure RollText;

Var I,II:Integer;

Procedure RollChar(Letter:Char; X,Y:Word; Stadium:Byte; Col:Byte);

Var I:Integer;

Begin
     For I:=1 To 15 Do
         If (Ascii_Data[ConvertChar(Letter)] And Hoch(2,I-1))=Hoch(2,I-1) Then
            Case (I-1) Div 3 Of
                 0:PutPixel(X+((I-1) Mod 3),Y+((I-1) Div 3)+(Stadium-1),Col);
                 1:PutPixel(X+((I-1) Mod 3),Y+((I-1) Div 3)+(Stadium Div 3+Stadium Div 4),Col);
                 2:PutPixel(X+((I-1) Mod 3),Y+((I-1) Div 3),Col);
                 3:PutPixel(X+((I-1) Mod 3),Y+((I-1) Div 3)-(Stadium Div 3+Stadium Div 4),Col);
                 4:PutPixel(X+((I-1) Mod 3),Y+((I-1) Div 3)-(Stadium-1),Col);
            End;
End;

Begin
     For I:=2 To 5 Do
         Begin
              For II:=1 To Length(Text) Do
                  RollChar(Text[II],X+(II-1)*4,Y,I,Col);
{$IfDef CrtHasNoBugs}
              Delay(DelayTime);
{$Else}
              Wait(DelayTime);
{$EndIf}
              For II:=1 To Length(Text) Do
                  RollChar(Text[II],X+(II-1)*4,Y,I,DelCol);
         End;
     For I:=4 DownTo 1 Do
         Begin
              For II:=1 To Length(Text) Do
                  RollChar(Text[II],X+(II-1)*4,Y,I,Col);
{$IfDef CrtHasNoBugs}
              Delay(DelayTime);
{$Else}
              Wait(DelayTime);
{$EndIf}
              For II:=1 To Length(Text) Do
                  RollChar(Text[II],X+(II-1)*4,Y,I,DelCol);
         End;
End;

Procedure InText;

Var Ch:Char;
    SS:String;

Begin
     SS:=Text;
     OutText(Message,X,Y,Col);
     OutText(SS,X+StrLen(Message)+3,Y,Col);
     Repeat
{$IfDef CrtHasNoBugs}
           Ch:=ReadKey;
{$Else}
           Ch:=Chr(ReadByte);
{$EndIf}
           If Ch=#8 Then
              If Length(SS)>0 Then
                 Begin
                      OutChar(SS[Length(SS)],X+StrLen(Message)+StrLen(SS),y,DelCol);
                      Delete(SS,Length(SS),1);
                 End;
           If Ch=#32 Then
              If (Length(SS)<MaxLength) Then SS:=SS+' ';
           If Ord(Ch)>32 Then
              If (Length(SS)<MaxLength) Then
                 Begin
                      SS:=SS+Ch;
                      OutChar(Ch,X+StrLen(Message)+StrLen(SS),Y,Col);
                 End;
     Until (Ch=#13) Or
           (Ch=#27);
     If Ch=#13 Then Text:=SS
               Else Text:='';
End;

Begin
     WriteLn(Text1);
End.