Unit Color;

{$G+}

Interface

Const Text1='Visit http://www.datacomm.ch/asuter';

Procedure InitGraphMode;
Procedure InitTextMode;
Procedure PutPixel(x,y:Word;Col:Byte);
Function GetPixel(x,y:Word):Byte;
Procedure Line(a,b,c,d:Word;Col:Byte);
Procedure HLine(X,Y,Breite:Word;Col:Byte);
Procedure VLine(X,Y,Hoehe:Word;Col:Byte);
Procedure Box(x1,y1,x2,y2:Word;Col:Byte);
Procedure FBox(x1,y1,x2,y2:Word;Col:Byte);
Procedure Circle(x,y,Rad:Word;Col:Byte);
Procedure FCircle(x,y,Rad:Word;Col:Byte);
Procedure Ellipse(x,y,Rad1,Rad2:Word;Col:Byte);

Implementation

Procedure InitGraphMode;Assembler;

Asm
   mov ax,$0013
   int 10h
End;

Procedure InitTextMode;Assembler;

Asm
   mov ax,$0003
   int 10h
End;

Procedure PutPixel;Assembler;

Asm
   mov di,$a000
   mov es,di
   mov di,y
   mov ax,y
   shl di,8
   shl ax,6
   add di,ax
   add di,x
   sub di,321
   mov al,Col
   stosb
End;

Function GetPixel;Assembler;

Asm
   push ds
   mov ax,$a000
   mov ds,ax
   mov si,y
   mov ax,y
   shl si,8
   shl ax,6
   add si,ax
   add si,x
   sub si,321
   lodsb
   pop ds
End;

Procedure Line;

Function Sign(a:integer):Integer;

Begin
     If a>0 Then Sign:=+1;
     If a<0 Then Sign:=-1;
     If a=0 Then Sign:=0;
End;

Var i,s,d1x,d1y,d2x,d2y,u,v,m,n:Integer;

Begin
     u:= c - a;
     v:= d - b;
     d1x:= Sign(u);
     d1y:= Sign(v);
     d2x:= Sign(u);
     d2y:= 0;
     m:= Abs(u);
     n := Abs(v);
     If Not (M>N) Then
     Begin
          d2x := 0 ;
          d2y := Sign(v);
          m := Abs(v);
          n := Abs(u);
     End;
     s := m ShR 1;
     For i := 0 To M Do
     Begin
          PutPixel(a,b,Col);
          Asm
             mov ax,n
             add s,ax         {s := s + n;}
             mov ax,s
             cmp ax,m
             jb @elseif       {IF not (s<m) THEN BEGIN}
             mov ax,m
             sub s,ax         {s := s - m;}
             mov ax,d1x
             add a,ax         {a:= a + d1x;}
             mov ax,d1y
             add b,ax         {b := b + d1y;}
             jmp @endif       {end}
          @elseif:            {ELSE BEGIN}
             mov ax,d2x
             add a,ax         {a := a + d2x;}
             mov ax,d2y
             add b,ax         {b := b + d2y;}
          @endif:             {END;}
          End;
     End;
END;

Procedure HLine;Assembler;

Asm
   mov ax,$a000
   mov es,ax
   mov di,y
   mov ax,y
   shl di,8
   shl ax,6
   add di,ax
   add di,X
   sub di,321
   mov cx,Breite
   inc cx
   mov al,Col
   rep stosb
End;

Procedure VLine;Assembler;

Asm
   mov ax,$a000
   mov es,ax
   mov di,y
   mov ax,y
   shl di,8
   shl ax,6
   add di,ax
   add di,x
   sub di,321
   mov cx,Hoehe
   inc cx
   mov al,Col
   @repeat:
           stosb
           add di,319
   loop @repeat
End;

Procedure Box(x1,y1,x2,y2:Word;Col:Byte);Assembler;

Asm
   mov ax,$a000
   mov es,ax
   mov ax,320
   mov si,y2
   cmp si,y1
   jb @weiter3
   mul y1
   mov bx,y2
   sub bx,y1
   jmp @weiter2
   @weiter3:
   mul y2
   mov bx,y1
   sub bx,y2
   @weiter2:
   dec bx
   mov si,x2
   cmp si,x1
   jb @weiter4
   add ax,x1
   mov cx,x2
   sub cx,x1
   jmp @weiter5
   @weiter4:
   add ax,x2
   mov cx,x1
   sub cx,x2
   @weiter5:
   inc cx
   sub ax,321
   mov di,ax
   mov al,Col
   push di
   push cx
   rep stosb
   pop cx
   cmp bx,0
   jz @weiter
   pop di
   add di,320
   push di
   @repeat:
           stosb
           add di,cx
           sub di,2
           stosb
           dec bx
           jz @weiter
           pop di
           add di,320
           push di
   jmp @repeat
   @weiter:
   pop di
   add di,320
   rep stosb
End;

Procedure FBox;Assembler;

Asm
   mov ax,$a000
   mov es,ax
   mov ax,320
   mov si,y2
   cmp si,y1
   jb @weiter3
   mul y1
   mov bx,y2
   sub bx,y1
   jmp @weiter2
   @weiter3:
   mul y2
   mov bx,y1
   sub bx,y2
   @weiter2:
   mov si,x2
   cmp si,x1
   jb @weiter4
   add ax,x1
   mov cx,x2
   sub cx,x1
   jmp @weiter5
   @weiter4:
   add ax,x2
   mov cx,x1
   sub cx,x2
   @weiter5:
   sub ax,321
   mov di,ax
   push di
   inc bx
   inc cx
   push cx
   mov al,Col
   @repeat:
           rep stosb
           dec bx
           jz @weiter
           pop cx
           pop di
           add di,320
           push di
           push cx
   jmp @repeat
   @weiter:
   pop di
   pop cx
End;

procedure circle;

var error:integer;
    px,py:integer;

begin
     px:=0;
     py:=rad;
     error:=1-rad;
     while px<=py do
           begin
                putpixel(x+px,y+py,col);
                putpixel(x+px,y-py,col);
                putpixel(x-px,y+py,col);
                putpixel(x-px,y-py,col);
                putpixel(x+py,y+px,col);
                putpixel(x+py,y-px,col);
                putpixel(x-py,y+px,col);
                putpixel(x-py,y-px,col);
                inc(px);
                if error>=0 then
                   begin
                        dec(py);
                        error:=error-2*py;
                   end;
                error:=error+2*px+1;
           end;
end;

procedure fcircle;

var error:integer;
    px,py:integer;

begin
     px:=0;
     py:=rad;
     error:=1-rad;
     while px<=py do
           begin
                hline(x-px,y-py,2*px,col);
                hline(x-px,y+py,2*px,col);
                hline(x-py,y-px,2*py,col);
                hline(x-py,y+px,2*py,col);
                inc(px);
                if error>=0 then
                   begin
                        dec(py);
                        error:=error-2*py;
                   end;
                error:=error+2*px+1;
           end;
end;

Procedure Ellipse;

Var elx,ely :Integer;
    aa,aa2,bb,bb2,d,dx,dy :LongInt;

begin
     elx := 0;
     ely := Rad2;
     aa := LongInt(Rad1) * Rad1;
     aa2 := 2 * aa;
     bb := LongInt(Rad2) * Rad2;
     bb2 := 2 * bb;
     d := bb - aa * Rad2 + aa Div 4;
     dx := 0; dy := aa2 * rad2;
     PutPixel(x, y - ely, Col);
     PutPixel(x, y + ely, Col);
     putpixel(x - rad1, y, Col);
     putpixel(x + rad1, y, Col);
     WHILE (dx < dy) DO
           BEGIN
                IF (d > 0) THEN
                   BEGIN
                        Dec(ely);
                        Dec(dy, aa2);
                        Dec(d, dy);
                   END;
                Inc(elx);
                Inc(dx, bb2);
                Inc(d, bb + dx);
                putpixel(x + elx, y + ely, col);
                putpixel(x - elx, y + ely, col);
                putpixel(x + elx, y - ely, col);
                putpixel(x - elx, y - ely, col);
           END;
     Inc(d, (3 * (aa - bb) DIV 2 - (dx + dy)) DIV 2);
     WHILE (ely > 0) DO
           BEGIN
                IF (d < 0) THEN
                   BEGIN
                        Inc(elx);
                        Inc(dx, bb2);
                        Inc(d, bb + dx);
                   END;
                Dec(ely);
                Dec(dy, aa2);
                Inc(d, aa - dy);
                putpixel(x + elx, y + ely, col);
                putpixel(x - elx, y + ely, col);
                putpixel(x + elx, y - ely, col);
                putpixel(x - elx, y - ely, col);
           END;
End;


Begin
     WriteLn(Text1);
End.