' The constant delay below can be altered to play faster or slower.
' The root constant should point to these files if they're not in the QB
' default directory. Jester@T-Online.de

DECLARE SUB pause (breakValue%)
DECLARE SUB handleBricks (brick() AS ANY, ball AS ANY, won%)
DECLARE SUB pasteBrick (brick() AS ANY, n%, pasteMode%)
DECLARE SUB intro ()
DECLARE SUB getPics (lvl%)
DECLARE SUB collisionBB (brick() AS ANY, ball AS ANY, bricks%)
DECLARE SUB handleBall (ball AS ANY, ballOut%)
DECLARE SUB playSfx (blasterNum AS INTEGER) ' SFX by Tim Truman
DECLARE SUB setSoundFX ()
DECLARE SUB fade (value AS INTEGER)
DECLARE SUB putPic (fileName$)
DECLARE SUB setCol (n%, col() AS ANY)
DECLARE SUB getPal (fileName$)
DECLARE SUB pasteBricks (brick() AS ANY, n%)
DECLARE SUB collisionPB (paddle AS ANY, ball AS ANY)
DECLARE SUB handlePaddle (paddle AS ANY, mouse AS ANY)
DECLARE SUB mouseStatus (m AS ANY)
DECLARE SUB mouseGet ()
DECLARE SUB mouseDriver (AX%, bx%, CX%, dx%)
DECLARE SUB pastePaddle (paddle AS ANY, pasteMode%)
DECLARE SUB pasteBall (ball AS ANY, pasteMode%)
DECLARE SUB createBricks (brick() AS ANY, brickx%, bricky%)
DECLARE FUNCTION playGame% (lvl%, cheat%, brickn%, brickx%, bricky%)
DECLARE FUNCTION form$ (number%)

'############################################## Change these values #####
CONST delay = 150
CONST root = "" 'c:\main\sprache\qb45\mine\pearl\pearl5\
'########################################################################

CONST false = 0, true = NOT false
CONST screenMode = 13, palMax = 255, colMax = 255, byte = 255, intens = 63, atbMax = 63
CONST minx = 0 + 1, miny = 0 + 1, limx = 319 - 1, limy = 199 - 1
CONST midx = limx \ 2, midy = limy \ 2
CONST fadeMax = 20, fadeVal = .9
CONST brickMax = 48

TYPE sprite
  x    AS INTEGER
  y    AS INTEGER
  sx   AS INTEGER
  sy   AS INTEGER
  size AS INTEGER
END TYPE

TYPE rect
  x      AS INTEGER
  y      AS INTEGER
  sizex  AS INTEGER
  sizey  AS INTEGER
  status AS INTEGER
END TYPE

TYPE setup
  lvl     AS INTEGER
  cheat   AS INTEGER
END TYPE

TYPE mouseType
  left    AS INTEGER
  middle  AS INTEGER
  right   AS INTEGER
  x       AS INTEGER
  y       AS INTEGER
  visible AS INTEGER
END TYPE

TYPE pal
  red   AS SINGLE
  green AS SINGLE
  blue  AS SINGLE
END TYPE

DIM SHARED mouseDat AS STRING
DIM ballBack%(1000), picBall%(1000), maskBall%(1000)
DIM picPaddle%(1300), backPaddle%(1300)
DIM picBrick%(1000), picBrickx%(1000), backBrick%(420, brickMax)
DIM col(colMax) AS pal
DIM blaster(25) AS STRING, channel(8) AS STRING

intro
DO
  level% = level% + 1
LOOP UNTIL NOT playGame%(level%, false, brickMax, 20, 10)
CLS : PALETTE
END

mouseData:
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

channels:
DATA "&hB0&h20&h23&h40&h43&h60&h63&h80&h83&hA0&HBD&HC0&HE0&HE3&hB0"
DATA "&hB1&h21&h24&h41&h44&h61&h64&h81&h84&hA1&HBD&HC1&HE1&HE4&hB1"
DATA "&hB2&h22&h25&h42&h45&h62&h65&h82&h85&hA2&HBD&HC2&HE2&HE5&hB2"
DATA "&hB3&h28&h2B&h48&h4B&h68&h6B&h88&h8B&hA3&HBD&HC3&HE8&HEB&hB3"
DATA "&hB4&h29&h2C&h49&h4C&h69&h6C&h89&h8C&hA4&HBD&HC4&HE9&HEC&hB4"
DATA "&hB5&h2A&h2D&h4A&h4D&h6A&h6D&h8A&h8D&hA5&HBD&HC5&HEA&HED&hB5"
DATA "&hB6&h30&h33&h50&h53&h70&h73&h90&h93&hA6&HBD&HC6&HF0&HF3&hB6"
DATA "&hB7&h31&h34&h51&h54&h71&h74&h91&h94&hA7&HBD&HC7&HF1&HF4&hB7"
DATA "&hB8&h32&h35&h52&h55&h72&h75&h92&h95&hA8&HBD&HC8&HF2&HF5&hB8"

various:
DATA "&H00&H00&H00&H00&H00&HF0&H5C&H78&H06&H0F&HC0&H0E&H00&H03&H37&H0"
DATA "&H00&HC0&H40&H00&H00&HC1&HC5&HB4&HD4&H74&HC0&H00&H00&H00&H21&H1"
DATA "&H00&H0C&H01&H06&H02&H5E&H8D&H5B&H9F&H80&HC0&H08&H00&H00&H36&H4"
DATA "&H00&H03&H03&H00&H03&HF2&HE3&H23&H25&H25&HC0&H00&H00&H00&H3F&H3"
DATA "&H00&H80&H00&H00&H00&HF0&HB9&HA2&H04&H89&HC0&H0E&H00&H00&H20&H1"
DATA "&H00&H00&H00&H00&H00&H82&H34&HA2&HC7&H89&HC0&H02&H00&H02&H24&H0"
DATA "&H00&H00&H00&H03&H00&H42&H81&HA9&H23&H06&HC0&H06&H01&H01&H2A&H3"
DATA "&H00&H00&H00&H03&H03&H82&H75&HA9&H28&H25&HC0&H02&H00&H00&H3F&H0"
DATA "&H00&H00&H00&H03&H03&H82&H75&HA4&H24&H25&HC0&H04&H00&H00&H2F&H0"
DATA "&H00&H0F&H00&H03&H03&H82&H72&HA9&H28&H25&HC0&H0E&H03&H03&H3F&H0"
DATA "&H00&H04&H00&H00&H00&H85&H00&HCF&H00&HFF&HC0&H09&H01&H00&H33&H0"
DATA "&H00&H06&H00&H03&H03&HEC&HE2&H28&H28&H00&HC0&H01&H00&H00&H39&H0"
DATA "&H00&H00&H00&H03&H03&H82&H73&HA9&H28&H25&HC0&H04&H01&H03&H23&H0"
DATA "&H00&H40&H00&H00&H00&H45&HC2&H64&H04&HF4&HC0&H00&H00&H03&H25&H0"
DATA "&H00&H00&H00&H03&H00&HA3&H54&HA5&HA6&HDC&HC0&H00&H00&H00&H27&H0"
DATA "&H00&H00&H00&H03&H03&H64&H65&HA9&H68&H25&HC0&H05&H01&H01&H33&H0"
DATA "&H00&HC0&HC0&H03&H03&H64&H65&HA9&H68&H25&HC0&H05&H01&H01&H33&H0"
DATA "&H00&H00&H00&H00&H03&H56&H65&HAB&HA1&H25&HC0&H00&H00&H00&H27&H0"
DATA "&H00&H00&H00&H00&H03&H4D&HAC&H49&H18&H25&HC0&H02&H01&H01&H3B&H0"
DATA "&H00&H00&H00&H00&H00&HA4&H10&H49&H58&H89&HC0&H01&H01&H03&H24&H1"
DATA "&H00&H00&H00&H00&H00&H82&H34&HA2&HC7&H89&HC0&H0E&H00&H03&H20&H0"
DATA "&H00&H00&H00&H00&H1E&H49&H88&H5B&H2F&H00&HC0&H07&H03&H00&H2E&H0"
DATA "&H00&H00&H00&H00&H1E&H55&H88&H5B&H2F&H00&HC0&H07&H03&H00&H2E&H0"
DATA "&H00&H00&H00&H06&H02&H55&H8D&H5B&H9F&HCF&HC0&H08&H00&H00&H38&H0"
DATA "&H00&HC1&HC0&H0C&H11&HA0&H30&H5B&H9F&HCF&HC0&H08&H00&H00&H30&H1"
DATA "&H00&H00&H00&H00&H00&H00&H00&H00&H00&H00&HC0&H00&H00&H00&H20&H1"

SUB collisionBB (brick() AS rect, ball AS sprite, bricks%)

  FOR n% = LBOUND(brick) TO UBOUND(brick)
    IF brick(n%).status >= 1 THEN
      IF (ball.x - ball.size \ 2 <= brick(n%).x + brick(n%).sizex \ 2 AND ball.x + ball.size \ 2 + 1 >= brick(n%).x - brick(n%).sizex \ 2) THEN
        IF (ball.y - ball.size \ 2 <= brick(n%).y + brick(n%).sizey \ 2 AND ball.y + ball.size \ 2 + 1 >= brick(n%).y - brick(n%).sizey \ 2) THEN
          playSfx 16
          ball.sy = ball.sy * -1
          IF brick(n%).status = 1 THEN
            bricks% = bricks% - 1
            IF bricks% > 0 THEN
              brick(n%).status = 0
              pasteBrick brick(), n%, false
            ELSE
              brick(n%).status = 4
            END IF
          ELSEIF brick(n%).status = 2 THEN
            brick(n%).status = 1
            pasteBrick brick(), n%, true
          END IF
          IF RND * 10 > 8 THEN
            IF (ball.x - ball.size \ 2 >= brick(n%).x + brick(n%).sizex \ 2 - 2 AND ball.sx < 0) OR (ball.x + ball.size \ 2 <= brick(n%).x - brick(n%).sizex \ 2 + 2 AND ball.sx > 0) THEN ball.sx = ball.sx * -1
          END IF
        END IF
      END IF
    END IF
  NEXT

END SUB

SUB collisionPB (paddle AS rect, ball AS sprite)

  IF (ball.x - ball.size \ 2 <= paddle.x + paddle.sizex \ 2 AND ball.x + ball.size \ 2 >= paddle.x - paddle.sizex \ 2) THEN
    IF (ball.y - ball.size \ 2 <= paddle.y + paddle.sizey \ 2 AND ball.y + ball.size \ 2 >= paddle.y - paddle.sizey \ 2) THEN
      playSfx 2
      ball.sy = ball.sy * -1
      IF (ball.x - ball.size \ 2 >= paddle.x + paddle.sizex \ 2 - 2 AND ball.sx < 0) OR (ball.x + ball.size \ 2 <= paddle.x - paddle.sizex \ 2 + 2 AND ball.sx > 0) THEN ball.sx = ball.sx * -1
    END IF
  END IF

END SUB

SUB createBricks (brick() AS rect, brickx%, bricky%)

  SHARED backBrick%()
  xoff% = 22
  yoff% = bricky%
  
  FOR x% = 1 TO UBOUND(brick) \ 4
    FOR y% = 1 TO 4
      n% = n% + 1
      brick(n%).x = x% * (brickx% + 1) + xoff%
      brick(n%).y = yoff% + y% * (bricky% + 1)
      brick(n%).sizex = brickx%
      brick(n%).sizey = bricky%
      IF y% = 3 THEN
        brick(n%).status = 2
      ELSE
        brick(n%).status = 1
      END IF
      'IF x% = UBOUND(brick) \ 4 AND y% = 4 THEN brick(n%).status = 3 '''
      GET (brick(n%).x - brick(n%).sizex \ 2, brick(n%).y - brick(n%).sizey \ 2)-(brick(n%).x + brick(n%).sizex \ 2, brick(n%).y + brick(n%).sizey \ 2), backBrick%(0, n%)
      pasteBrick brick(), n%, true
    NEXT
  NEXT

END SUB

SUB fade (value AS INTEGER)

 SHARED col() AS pal
 DIM i AS INTEGER, n AS INTEGER, clock AS SINGLE

  IF SGN(value) = -1 THEN
    FOR n = 0 TO ABS(value)
      FOR i = 0 TO colMax
        col(i).red = col(i).red * fadeVal
        col(i).green = col(i).green * fadeVal
        col(i).blue = col(i).blue * fadeVal
      NEXT
      clock = TIMER
      DO UNTIL clock + .001 - TIMER <= 0: LOOP
      FOR nn% = 0 TO palMax
        setCol nn%, col()
      NEXT
    NEXT
  ELSE
    FOR n = 0 TO value
      FOR i = 0 TO colMax
        col(i).red = col(i).red / fadeVal
        col(i).green = col(i).green / fadeVal
        col(i).blue = col(i).blue / fadeVal
      NEXT
      clock = TIMER
      DO UNTIL clock + .001 - TIMER <= 0
      LOOP
      FOR nn% = 0 TO palMax
        setCol nn%, col()
      NEXT
    NEXT
  END IF

END SUB

FUNCTION form$ (number%)

  form$ = RTRIM$(LTRIM$(STR$(number%)))

END FUNCTION

SUB getPal (fileName$)

  SHARED col() AS pal
  OPEN root + fileName$ + ".pal" FOR INPUT AS #1
    FOR i% = 1 TO 3
      LINE INPUT #1, dummy$
    NEXT
    FOR n% = 0 TO palMax
      INPUT #1, dummy2%
      col(n%).red = dummy2% \ 4
      INPUT #1, dummy2%
      col(n%).green = dummy2% \ 4
      INPUT #1, dummy2%
      col(n%).blue = dummy2% \ 4
      setCol n%, col()
    NEXT
  CLOSE #1
  col(0).red = 0: col(0).green = 0: col(0).blue = 0
  setCol 0, col()
  col(palMax).red = intens: col(palMax).green = intens: col(palMax).blue = intens
  setCol palMax, col()

END SUB

SUB getPics (lvl%)

  SHARED picPaddle%(), picBrick%(), picBrickx%(), picBall%(), maskBall%()

  DEF SEG = VARSEG(picPaddle%(0))
    BLOAD root + "paddle" + form$(lvl%) + ".grh", VARPTR(picPaddle%(0))
  DEF SEG
  DEF SEG = VARSEG(picBrick%(0))
    BLOAD root + "brick" + form$(lvl%) + ".grh", VARPTR(picBrick%(0))
  DEF SEG
  DEF SEG = VARSEG(picBrickx%(0))
    BLOAD root + "brickx" + form$(lvl%) + ".grh", VARPTR(picBrickx%(0))
  DEF SEG
  DEF SEG = VARSEG(picBall%(0))
    BLOAD root + "ball" + form$(lvl%) + ".grh", VARPTR(picBall%(0))
  DEF SEG
  DEF SEG = VARSEG(maskBall%(0))
    BLOAD root + "ball1x.grh", VARPTR(maskBall%(0)) '''
  DEF SEG
 
END SUB

SUB handleBall (ball AS sprite, ballOut%)

  IF ball.sx <> 0 OR ball.sy <> 0 THEN
    IF ball.x - ball.size \ 2 < minx OR ball.x + ball.size \ 2 > limx THEN ball.sx = ball.sx * -1: playSfx 1
    IF ball.y - ball.size \ 2 < miny OR ball.y + ball.size \ 2 > limy THEN ball.sy = ball.sy * -1: playSfx 1
    pasteBall ball, false
    ball.x = ball.x + ball.sx
    ball.y = ball.y + ball.sy
    IF ball.y + ball.size \ 2 > limy - 3 THEN
      playSfx 1
      ballOut% = true
    ELSE
      pasteBall ball, true
    END IF
  END IF

END SUB

SUB handleBricks (brick() AS rect, ball AS sprite, won%)

  SHARED backBrick%()
  STATIC speedx%
  FOR n% = LBOUND(brick) TO UBOUND(brick)
    IF brick(n%).status = 3 THEN
      IF brick(n%).y - brick(n%).sizey \ 2 > miny + 3 THEN
        pasteBrick brick(), n%, false
        brick(n%).y = brick(n%).y - 1
        GET (brick(n%).x - brick(n%).sizex \ 2, brick(n%).y - brick(n%).sizey \ 2)-(brick(n%).x + brick(n%).sizex \ 2, brick(n%).y + brick(n%).sizey \ 2), backBrick%(0, n%)
        pasteBrick brick(), n%, true
      ELSE
        IF ball.y - RND * 50 > midy THEN
          speedx% = RND * 2 - 1
        ELSE
          IF brick(n%).x + brick(n%).sizex - 2 < ball.x THEN
            IF ABS(speedx%) < 10 THEN speedx% = speedx% + 1
          ELSEIF brick(n%).x - brick(n%).sizex + 2 > ball.x THEN
            IF ABS(speedx%) < 10 THEN speedx% = speedx% - 1
          ELSE
            IF RND * 100 > 30 AND ABS(speedx%) > 2 THEN speedx% = speedx% - SGN(speedx%)
          END IF
        END IF
        IF speedx% <> 0 THEN
          IF brick(n%).x - brick(n%).sizex \ 2 + speedx% > minx + 3 AND brick(n%).x + brick(n%).sizex \ 2 + speedx% < limx - 3 THEN
            pasteBrick brick(), n%, false
            brick(n%).x = brick(n%).x + speedx%
            GET (brick(n%).x - brick(n%).sizex \ 2, brick(n%).y - brick(n%).sizey \ 2)-(brick(n%).x + brick(n%).sizex \ 2, brick(n%).y + brick(n%).sizey \ 2), backBrick%(0, n%)
            pasteBrick brick(), n%, true
          ELSE
            speedx% = 0
          END IF
        END IF
        IF ball.y < miny + brick(n%).sizey + 3 THEN
          playSfx 15
          won% = true
          pasteBall ball, false
        END IF
      END IF
    ELSEIF brick(n%).status = 4 THEN
      IF RND * 200 > 197 THEN brick(n%).status = 3
    END IF
  NEXT

END SUB

SUB handlePaddle (paddle AS rect, mouse AS mouseType)
   
  SHARED picPaddle%()
  oldx% = paddle.x
  oldy% = paddle.y
  mouseStatus mouse
  IF mouse.x < minx + paddle.sizex \ 2 THEN
    mouse.x = minx + paddle.sizex \ 2
  ELSEIF mouse.x > limx - paddle.sizex \ 2 THEN
    mouse.x = limx - paddle.sizex \ 2
  END IF
  IF mouse.x <> oldx% THEN
    pastePaddle paddle, false
    paddle.x = mouse.x
    pastePaddle paddle, true
    oldx% = paddle.x
  END IF

END SUB

SUB intro

  SCREEN screenMode
  CLS
  getPal "back0"
  fade -20
  BLOAD root + "back0.grh"
  fade 20
  SLEEP 10
  fade -20
  CLS

END SUB

SUB mouseDriver (AX%, bx%, CX%, dx%)

  DEF SEG = VARSEG(mouseDat)
  mouse% = SADD(mouseDat)
  CALL Absolute(AX%, bx%, CX%, dx%, mouse%)

END SUB

SUB mouseGet

  mouseDat = SPACE$(57)
  RESTORE mouseData
  FOR i% = 1 TO 57
    READ A$
    H$ = CHR$(VAL("&H" + A$))
    MID$(mouseDat, i%, 1) = H$
  NEXT

END SUB

SUB mousePut

  AX% = 4
  CX% = x%
  dx% = y%
  mouseDriver AX%, 0, CX%, dx%

END SUB

SUB mouseStatus (m AS mouseType)

  lb% = m.left
  RB% = m.right
  xMouse% = m.x
  yMouse% = m.y
  AX% = 3
  mouseDriver AX%, bx%, CX%, dx%
  lb% = ((bx% AND 1) <> 0)
  RB% = ((bx% AND 2) <> 0)
  xMouse% = CX%
  yMouse% = dx%
  m.left = ABS(lb%)
  m.right = ABS(RB%)
  m.x = xMouse% \ 2
  m.y = yMouse% \ 2 + midy

END SUB

SUB pasteBall (ball AS sprite, pasteMode%)

  SHARED ballBack%()
  SHARED picBall%()
  SHARED maskBall%()

  IF pasteMode% THEN
    GET (ball.x - ball.size \ 2, ball.y - ball.size \ 2)-(ball.x + ball.size \ 2, ball.y + ball.size \ 2), ballBack%
    PUT (ball.x - ball.size \ 2, ball.y - ball.size \ 2), maskBall%, AND
    PUT (ball.x - ball.size \ 2, ball.y - ball.size \ 2), picBall%, OR
  ELSE
    PUT (ball.x - ball.size \ 2, ball.y - ball.size \ 2), ballBack%, PSET
  END IF

END SUB

SUB pasteBrick (brick() AS rect, n%, pasteMode%)

  SHARED picBrick%(), picBrickx%(), backBrick%()
 
  IF pasteMode% THEN
    'GET (brick(n%).x - brick(n%).sizex \ 2, brick(n%).y - brick(n%).sizey \ 2)-(brick(n%).x + brick(n%).sizex \ 2, brick(n%).y + brick(n%).sizey \ 2), backBrick%(0, n%)
    IF brick(n%).status = 1 OR brick(n%).status = 3 THEN
      PUT (brick(n%).x - brick(n%).sizex \ 2, brick(n%).y - brick(n%).sizey \ 2), picBrick%, PSET
    ELSE 'IF brick(n%).status = 2 THEN
      PUT (brick(n%).x - brick(n%).sizex \ 2, brick(n%).y - brick(n%).sizey \ 2), picBrickx%, PSET
    END IF
  ELSE
    PUT (brick(n%).x - brick(n%).sizex \ 2, brick(n%).y - brick(n%).sizey \ 2), backBrick%(0, n%), PSET
  END IF

END SUB

SUB pastePaddle (paddle AS rect, pasteMode%)

  SHARED picPaddle%()
  SHARED backPaddle%()

  IF pasteMode% THEN
    GET (paddle.x - paddle.sizex \ 2, paddle.y - paddle.sizey \ 2)-(paddle.x + paddle.sizex \ 2, paddle.y + paddle.sizey \ 2), backPaddle%
    PUT (paddle.x - paddle.sizex \ 2, paddle.y - paddle.sizey \ 2), picPaddle%, PSET
  ELSE
    PUT (paddle.x - paddle.sizex \ 2, paddle.y - paddle.sizey \ 2), backPaddle%, PSET
  END IF

END SUB

SUB pause (breakValue%)

  STATIC dummy1%, dummy2%
  FOR dummy1% = 0 TO breakValue%
    FOR dummy2% = 1 TO delay
    NEXT
  NEXT

END SUB

FUNCTION playGame% (lvl%, cheat%, brickn%, brickx%, bricky%)

  DIM paddle AS rect, ball AS sprite, brick(brickn%) AS rect, game AS setup
  DIM mouse AS mouseType
 
  RANDOMIZE TIMER
  setSoundFX
  fileName$ = "back" + form$(lvl%)
  SCREEN screenMode
  CLS
  getPal fileName$
  fade -20
  game.lvl = lvl%: game.cheat = cheat%
  BLOAD root + fileName$ + ".GRH"
  getPics lvl%
  createBricks brick(), brickx%, bricky%
  ball.x = midx + RND * 40: ball.y = midy: ball.sx = 1: ball.sy = 1: ball.size = 8
  IF RND * 100 > 97 THEN ball.sx = ball.sx * -1
  paddle.sizey = 8: paddle.x = midx: paddle.y = limy - paddle.sizey \ 2: paddle.sizex = 26:
  pasteBall ball, true
  pastePaddle paddle, true
  mouseGet
  fade 20
  breakValue% = 100 / (lvl% - lvl% / 3)
  bricks% = brickn%

  DO
    handlePaddle paddle, mouse
    handleBall ball, ballOut%
    handleBricks brick(), ball, won%
    collisionPB paddle, ball
    collisionBB brick(), ball, bricks%
    IF delay > 0 THEN pause breakValue%
  LOOP UNTIL INKEY$ = CHR$(27) OR ballOut% OR won%

  IF ballOut% THEN lvl% = lvl% - 1
  IF ballOut% OR won% THEN
    playGame% = true
    IF won% AND lvl% = 4 THEN
      fade -20
      CLS
      getPal "back5"
      fade -20
      BLOAD root + "back5.grh"
      fade 20
      playGame% = false
      playSfx 13
      SLEEP 10
    END IF
  ELSE
    playGame% = false
  END IF
  fade -20

END FUNCTION

SUB playSfx (blasterNum AS INTEGER)

  SHARED channel() AS STRING, blaster() AS STRING ', options AS gameSetting
  DIM chanIndex AS INTEGER, in AS INTEGER, d AS INTEGER, B AS INTEGER
  DIM reg AS STRING, regX AS INTEGER
  DIM dat AS STRING, datX AS INTEGER

  'IF options.soundFX = false THEN EXIT SUB
  chanIndex = VAL(MID$(blaster(blasterNum), 61, 4))
  FOR in = 1 TO 60 STEP 4
    reg = MID$(channel(chanIndex), in, 4)
    regX = VAL(reg)
    dat = MID$(blaster(blasterNum), in, 4)
    datX = VAL(dat)
    OUT &H388, regX
    FOR d = 1 TO 6
      B = INP(&H388)
    NEXT
    OUT &H389, datX
    FOR d = 1 TO 35
      B = INP(&H388)
    NEXT
  NEXT

END SUB

SUB setCol (n%, col() AS pal)

  OUT &H3C8, n%
  OUT &H3C9, INT(col(n%).red)
  OUT &H3C9, INT(col(n%).green)
  OUT &H3C9, INT(col(n%).blue)

END SUB

SUB setSoundFX

  SHARED channel() AS STRING, blaster() AS STRING
  DIM i AS INTEGER
  RESTORE channels
    FOR i = 0 TO 8
      READ channel(i)
    NEXT
  RESTORE various
    FOR i = 0 TO 25
      READ blaster(i)
    NEXT
  CLOSE #1

END SUB

