DECLARE SUB getStickData ()
DECLARE SUB gameTime (plr AS ANY, spr AS ANY, init AS INTEGER)
DECLARE SUB show (plr AS ANY, spr AS ANY)
DECLARE SUB move (spr AS ANY, initAll AS INTEGER, player AS ANY)
DECLARE SUB flood (x AS INTEGER, y AS INTEGER)
DECLARE SUB slowDown (spr AS ANY)
DECLARE SUB changeTile (nr AS INTEGER)
DECLARE SUB killCol ()
DECLARE SUB intro ()
DECLARE SUB paste (tile AS INTEGER, x AS INTEGER, y AS INTEGER, tileNr AS INTEGER)
DECLARE SUB lensFlare (spr AS ANY)
DECLARE SUB handleSpeed (spr AS ANY)
DECLARE SUB scroll (spx AS INTEGER, spy AS INTEGER, brdrxx AS INTEGER, brdrxy AS INTEGER)
DECLARE SUB light (value AS INTEGER)
DECLARE SUB centerPrint (text AS STRING, yOff AS INTEGER)
DECLARE SUB setCol (i%, R%, g%, B%)
DECLARE SUB clearTiles ()
DECLARE SUB playSfx (blasterNum AS INTEGER)
DECLARE SUB setSoundFX ()
DECLARE SUB colScroll (startCol%, endCol%, loops%)
DECLARE SUB colorize ()
DECLARE SUB delay ()
DECLARE SUB flip ()
DECLARE SUB setSprite (spr AS ANY, x AS INTEGER, y AS INTEGER, sx AS INTEGER, sy AS INTEGER, sz AS INTEGER, col AS INTEGER, rd AS INTEGER)
DECLARE FUNCTION MULTIKEY% (T)
DECLARE FUNCTION getPoints% ()
DECLARE FUNCTION game% ()
DECLARE FUNCTION create% (sprx AS INTEGER, spry AS INTEGER, viewx AS INTEGER, viewy AS INTEGER, level AS INTEGER)
DECLARE FUNCTION joyX% ()
DECLARE FUNCTION joyY% ()
DECLARE FUNCTION joyB1% ()
DECLARE FUNCTION joyB2% ()

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
CONST root = "" '"c:\main\sprache\qb45\mine\pearl\pearl4\"
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

CONST false = 0
CONST true = NOT false
CONST minX = 0, minY = 0, limx = 319, limy = 199
CONST midx = limx \ 2, midy = limy \ 2 + 3
CONST colMax = 255
CONST size = 16
CONST mores = 5
CONST viewx = 9, viewy = 5
CONST vwx = 152, vwy = 88
CONST tileStart = 100, tileMax = 200
CONST speedLimit = 5
CONST midxMvwx = midx - vwx, midxPvwx = midx + vwx ' pre-calculate
CONST midyMvwy = midy - vwy, midyPvwy = midy + vwy '
CONST sprMax = 12
CONST keyLeft = 75, keyRight = 77, keyUp = 72, keyDown = 80, keySpace = 57, keyEsc = 1
'CONST keyArrow = 42

TYPE sprite
  x    AS INTEGER
  y    AS INTEGER
  sx   AS INTEGER ' speed x
  sy   AS INTEGER '       y
  sz   AS INTEGER ' size
  col  AS INTEGER ' color
  nrg  AS INTEGER ' energy (boolean)
END TYPE

TYPE status
  lvl     AS INTEGER ' level
  pnts    AS INTEGER ' points
  p       AS INTEGER ' points needed
  lives   AS INTEGER
  falling AS INTEGER ' boolean
  gliding AS INTEGER ' boolean
  heart   AS INTEGER
  timeLft AS INTEGER
  noJump  AS INTEGER
END TYPE

TYPE pal
  red AS INTEGER
  green AS INTEGER
  blue AS INTEGER
END TYPE

DIM stickRight%, stickLeft%, stickUp%, stickDown%
DIM blaster(25) AS STRING
DIM channel(8) AS STRING

SCREEN 13
COLOR 255
getStickData
setSoundFX
intro
dummy% = MULTIKEY%(-1)

DO
  '$DYNAMIC
  REDIM back(1500) AS INTEGER
  REDIM pic(27000) AS INTEGER
  REDIM tiles(tileStart - 1 TO tileMax + 1) AS STRING * 2
  CLS
LOOP UNTIL NOT game%

dummy% = MULTIKEY%(-2)
END

channels:
DATA "&hB0&h20&h23&h40&h43&h60&h63&h80&h83&hA0&HBD&HC0&HE0&HE3&hB0"
DATA "&hB1&h21&h24&h41&h44&h61&h64&h81&h84&hA1&HBD&HC1&HE1&HE4&hB1"
DATA "&hB2&h22&h25&h42&h45&h62&h65&h82&h85&hA2&HBD&HC2&HE2&HE5&hB2"
DATA "&hB3&h28&h2B&h48&h4B&h68&h6B&h88&h8B&hA3&HBD&HC3&HE8&HEB&hB3"
DATA "&hB4&h29&h2C&h49&h4C&h69&h6C&h89&h8C&hA4&HBD&HC4&HE9&HEC&hB4"
DATA "&hB5&h2A&h2D&h4A&h4D&h6A&h6D&h8A&h8D&hA5&HBD&HC5&HEA&HED&hB5"
DATA "&hB6&h30&h33&h50&h53&h70&h73&h90&h93&hA6&HBD&HC6&HF0&HF3&hB6"
DATA "&hB7&h31&h34&h51&h54&h71&h74&h91&h94&hA7&HBD&HC7&HF1&HF4&hB7"
DATA "&hB8&h32&h35&h52&h55&h72&h75&h92&h95&hA8&HBD&HC8&HF2&HF5&hB8"

various:
DATA "&H00&H00&H00&H00&H00&HF0&H5C&H78&H06&H0F&HC0&H0E&H00&H03&H37&H0"
DATA "&H00&HC0&H40&H00&H00&HC1&HC5&HB4&HD4&H74&HC0&H00&H00&H00&H21&H1"
DATA "&H00&H0C&H01&H06&H02&H5E&H8D&H5B&H9F&H80&HC0&H08&H00&H00&H36&H4"
DATA "&H00&H03&H03&H00&H03&HF2&HE3&H23&H25&H25&HC0&H00&H00&H00&H3F&H3"
DATA "&H00&H80&H00&H00&H00&HF0&HB9&HA2&H04&H89&HC0&H0E&H00&H00&H20&H1"
DATA "&H00&H00&H00&H00&H00&H82&H34&HA2&HC7&H89&HC0&H02&H00&H02&H24&H0"
DATA "&H00&H00&H00&H03&H00&H42&H81&HA9&H23&H06&HC0&H06&H01&H01&H2A&H3"
DATA "&H00&H00&H00&H03&H03&H82&H75&HA9&H28&H25&HC0&H02&H00&H00&H3F&H0"
DATA "&H00&H00&H00&H03&H03&H82&H75&HA4&H24&H25&HC0&H04&H00&H00&H2F&H0"
DATA "&H00&H0F&H00&H03&H03&H82&H72&HA9&H28&H25&HC0&H0E&H03&H03&H3F&H0"
DATA "&H00&H04&H00&H00&H00&H85&H00&HCF&H00&HFF&HC0&H09&H01&H00&H33&H0"
DATA "&H00&H06&H00&H03&H03&HEC&HE2&H28&H28&H00&HC0&H01&H00&H00&H39&H0"
DATA "&H00&H00&H00&H03&H03&H82&H73&HA9&H28&H25&HC0&H04&H01&H03&H23&H0"
DATA "&H00&H40&H00&H00&H00&H45&HC2&H64&H04&HF4&HC0&H00&H00&H03&H25&H0"
DATA "&H00&H00&H00&H03&H00&HA3&H54&HA5&HA6&HDC&HC0&H00&H00&H00&H27&H0"
DATA "&H00&H00&H00&H03&H03&H64&H65&HA9&H68&H25&HC0&H05&H01&H01&H33&H0"
DATA "&H00&HC0&HC0&H03&H03&H64&H65&HA9&H68&H25&HC0&H05&H01&H01&H33&H0"
DATA "&H00&H00&H00&H00&H03&H56&H65&HAB&HA1&H25&HC0&H00&H00&H00&H27&H0"
DATA "&H00&H00&H00&H00&H03&H4D&HAC&H49&H18&H25&HC0&H02&H01&H01&H3B&H0"
DATA "&H00&H00&H00&H00&H00&HA4&H10&H49&H58&H89&HC0&H01&H01&H03&H24&H1"
DATA "&H00&H00&H00&H00&H00&H82&H34&HA2&HC7&H89&HC0&H0E&H00&H03&H20&H0"
DATA "&H00&H00&H00&H00&H1E&H49&H88&H5B&H2F&H00&HC0&H07&H03&H00&H2E&H0"
DATA "&H00&H00&H00&H00&H1E&H55&H88&H5B&H2F&H00&HC0&H07&H03&H00&H2E&H0"
DATA "&H00&H00&H00&H06&H02&H55&H8D&H5B&H9F&HCF&HC0&H08&H00&H00&H38&H0"
DATA "&H00&HC1&HC0&H0C&H11&HA0&H30&H5B&H9F&HCF&HC0&H08&H00&H00&H30&H1"
DATA "&H00&H00&H00&H00&H00&H00&H00&H00&H00&H00&HC0&H00&H00&H00&H20&H1"

lvl0:
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1
DATA 4,4,4,1,1,4,3,3,3,3,3,3,3,4,1,1,1,4,4
DATA 3,3,4,1,1,4,3,3,3,3,3,3,3,4,4,4,4,4,3
DATA 2,3,4,1,1,4,3,3,3,0,3,3,3,3,3,3,3,3,3
DATA 3,3,4,1,1,4,3,3,3,3,3,3,3,4,4,4,4,4,3
DATA 4,4,4,1,1,4,3,3,3,3,3,3,3,4,1,1,1,4,4
DATA 1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

lvl1:
DATA 1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,2,1,2,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,3,1,3,1,1,3,4,4,4,4,4,1,1,1,1,1,1,1
DATA 1,3,1,3,1,1,3,4,3,3,3,4,1,1,1,1,1,1,1
DATA 1,3,3,3,1,1,3,3,3,0,3,4,1,1,1,1,1,1,1
DATA 1,3,1,3,1,1,3,4,3,3,3,4,1,1,1,1,1,1,1
DATA 1,3,1,3,1,1,3,4,4,4,4,4,1,1,1,1,1,1,1
DATA 1,2,1,2,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

lvl2:
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,2,5,5,5,5,5,5,0,1,1,1,1,1,1,1,1
DATA 1,1,1,5,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1
DATA 1,1,1,8,1,1,1,1,1,1,8,1,1,1,1,1,1,1,1
DATA 1,1,1,5,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1
DATA 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
DATA 1,1,1,1,1,1,5,1,1,1,1,1,1,1,5,1,1,1,1
DATA 1,1,1,1,1,1,8,1,1,1,1,1,1,1,5,1,1,1,1
DATA 1,1,1,1,1,1,5,1,1,1,1,1,1,1,5,1,1,1,1
DATA 1,1,1,1,1,1,2,5,5,5,5,5,5,5,2,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

lvl3:
DATA 1,1,1,1,1,3,1,1,1,1,1,1,1,1,1,3,1,3,1
DATA 2,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,1,2,2
DATA 1,1,1,1,1,3,1,3,0,3,1,3,1,1,1,3,1,1,1
DATA 3,2,2,2,3,3,1,3,1,3,1,3,3,3,3,3,3,3,3
DATA 1,1,1,1,1,3,1,3,1,3,1,1,1,3,1,3,1,1,1
DATA 1,3,3,3,1,3,1,3,1,3,3,3,1,3,1,3,1,3,1
DATA 1,2,1,3,1,3,1,3,1,1,1,3,1,3,1,3,1,3,1
DATA 1,2,1,3,1,3,3,3,1,3,3,3,1,3,1,3,1,3,1
DATA 1,2,1,3,1,3,1,1,1,3,1,1,1,3,1,3,1,3,1
DATA 1,3,3,3,1,3,3,3,3,3,2,2,2,3,1,3,1,3,1
DATA 1,1,1,1,1,3,1,1,1,1,1,1,1,1,1,3,1,3,1

lvl4:
DATA 1,1,5,1,1,4,5,4,1,1,1,4,5,4,1,1,3,1,3
DATA 1,1,5,2,2,5,5,5,5,6,5,5,5,5,2,2,2,3,3
DATA 1,1,5,1,1,4,5,4,1,0,1,4,5,4,1,1,3,1,1
DATA 1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1
DATA 1,1,5,1,1,1,3,4,4,4,4,4,3,1,1,1,5,1,1
DATA 1,1,5,1,1,1,3,3,3,3,3,3,3,1,1,1,5,1,1
DATA 1,1,5,1,1,1,3,4,3,3,3,4,3,1,1,1,5,1,1
DATA 1,1,5,1,3,3,3,4,4,4,4,4,3,3,3,1,5,1,1
DATA 5,5,8,5,3,4,8,1,1,1,1,1,8,4,3,5,8,5,2
DATA 1,1,1,1,1,1,8,1,1,1,1,1,8,1,1,1,1,1,1
DATA 1,1,1,1,1,1,2,1,1,1,1,1,2,1,1,1,1,1,7

lvl5:
DATA 1,5,1,1,5,1,1,1,1,1,1,1,1,1,5,1,1,5,1
DATA 1,5,1,1,5,1,1,1,1,0,1,1,1,1,5,1,1,5,1
DATA 5,8,5,5,8,3,3,1,1,5,1,1,3,3,8,5,5,2,5
DATA 1,1,1,1,1,1,5,1,1,8,1,1,5,1,1,1,1,1,1
DATA 1,1,1,1,1,1,5,1,1,3,1,1,5,1,1,1,1,1,1
DATA 1,1,1,1,1,1,8,3,3,3,3,3,8,1,1,1,1,1,1
DATA 1,1,1,1,1,1,5,9,9,9,9,9,5,1,1,1,1,1,1
DATA 1,1,1,1,1,1,5,9,9,9,9,9,5,1,1,1,1,1,1
DATA 1,1,1,1,1,1,5,9,9,9,9,9,5,1,1,1,1,1,1
DATA 3,3,1,1,2,3,8,8,8,8,8,8,8,2,3,1,1,3,3
DATA 1,5,1,1,5,1,1,1,1,1,1,1,1,1,5,1,1,5,1

lvl6:
DATA 1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1
DATA 1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1
DATA 1,1,1,1,1,5,4,4,4,4,4,4,4,5,1,1,1,1,1
DATA 1,1,1,1,1,5,2,4,3,3,3,4,2,5,5,5,5,6,1
DATA 1,1,1,1,1,5,2,1,3,3,3,1,2,5,1,1,1,5,1
DATA 1,1,1,1,1,5,2,7,3,3,3,7,2,5,1,1,1,5,1
DATA 5,5,5,5,5,8,2,4,3,3,3,4,2,5,1,1,2,8,2
DATA 1,1,1,1,1,5,2,4,4,4,4,4,2,5,1,1,5,1,1
DATA 1,1,1,1,1,5,2,3,4,4,4,3,2,5,1,1,5,1,1
DATA 1,1,1,1,1,5,2,5,4,0,4,5,2,5,5,5,8,1,1
DATA 1,1,1,1,1,1,1,8,1,8,1,8,1,1,1,1,1,1,1

lvl7:
DATA 1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,7,1,1,1
DATA 1,1,1,1,1,3,1,1,1,5,5,3,1,1,1,3,1,1,1
DATA 1,1,1,1,1,3,1,1,1,5,6,3,1,1,1,3,1,1,1
DATA 1,1,1,1,1,1,1,1,1,5,5,3,1,1,1,1,1,1,1
DATA 1,1,1,1,1,3,1,1,1,1,1,1,1,1,1,3,1,1,1
DATA 1,1,1,1,1,3,3,1,3,3,1,3,3,1,3,3,1,1,1
DATA 1,1,1,1,1,8,1,1,1,1,1,1,1,1,1,8,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 9,9,2,1,1,0,1,1,1,1,1,1,1,1,1,3,9,9,9
DATA 1,1,1,1,1,8,1,1,1,1,1,1,1,1,1,8,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

lvl8:
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 3,1,3,3,3,1,1,1,1,1,0,1,1,3,3,3,1,3,3
DATA 2,1,9,1,2,1,3,5,5,5,5,1,1,3,1,2,1,9,1
DATA 2,1,9,1,2,1,3,4,4,4,8,4,4,3,1,2,1,9,1
DATA 2,1,9,1,2,1,3,4,3,3,3,3,4,3,1,2,1,9,1
DATA 2,1,9,1,2,1,3,4,3,3,3,3,4,3,1,2,1,9,1
DATA 2,1,9,1,2,1,3,4,3,3,3,3,3,3,1,2,1,9,1
DATA 3,3,3,1,3,3,3,4,4,4,4,4,4,4,1,3,3,3,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

lvl9:
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 4,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4
DATA 4,1,1,1,1,4,5,5,5,5,5,5,5,4,5,5,5,5,5
DATA 4,1,1,1,1,4,5,5,5,5,5,5,5,4,5,5,5,5,5
DATA 4,1,1,1,1,4,5,5,4,3,3,3,3,4,5,5,4,5,5
DATA 4,1,1,1,1,4,5,5,4,3,3,3,3,4,5,5,4,5,5
DATA 4,1,1,1,1,4,5,5,4,4,4,4,4,4,5,5,4,5,5
DATA 4,1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,4,5,5
DATA 4,1,1,1,1,4,5,5,5,5,5,5,5,5,5,5,4,0,2
DATA 4,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

' 0: Goal
' 1: Water
' 2: Red Button (limited)
' 3: Blue plate
' 4: Pyramid bumper
' 5: Ice
' 6: Heart (maximum 1)
' 7: Small blue plate
' 8: One direction ice
' 9: Weird floor

lvlSample:
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

REM $STATIC
SUB centerPrint (text AS STRING, yOff AS INTEGER)

  LOCATE 14 + yOff, 20 - LEN(text) \ 2: PRINT text;

END SUB

SUB changeTile (nr AS INTEGER)

  SHARED tiles() AS STRING * 2
  SELECT CASE LEFT$(tiles(nr), 1)
    CASE " ": MID$(tiles(nr), 1, 1) = "_"
    CASE "_": MID$(tiles(nr), 1, 1) = " "
  END SELECT
  playSfx 1
  SELECT CASE LEFT$(tiles(nr), 1)
    CASE " "
      setCol nr, 42, 0, 0
      setCol nr + 1, 22, 0, 0
      setCol nr + 2, 62, 0, 0
    CASE "_": setCol nr, 0, 42, 42
      setCol nr, 32, 0, 0
      setCol nr + 1, 52, 0, 0
      setCol nr + 2, 12, 0, 0
  END SELECT
  
END SUB

SUB clearTiles

  SHARED tiles() AS STRING * 2
  FOR N% = tileStart TO tileMax
    tiles(N%) = "  "
  NEXT

END SUB

SUB colorize

  PALETTE ' restore
 
  FOR pal% = 0 TO 10 ' water
    setCol pal% + 20, 0, 0, pal% * 4 + 20
  NEXT
  FOR pal% = tileStart TO tileMax STEP 3 ' tiles
    setCol pal%, 42, 0, 0
    setCol pal% + 1, 22, 0, 0
    setCol pal% + 2, 62, 0, 0
  NEXT
 
  setCol 7, 42, 42, 42 ' same grey

  setCol 16, 30, 30, 30 ' pyramid bumper
  setCol 17, 40, 40, 40
  setCol 18, 50, 50, 50
  setCol 19, 60, 60, 60

  setCol 35, 0, 38, 38 ' end (/start)
  setCol 36, 0, 38, 38
 
  setCol 37, 42, 42, 42 ' ice
  setCol 38, 22, 22, 22
  setCol 39, 62, 62, 62

  setCol 40, 52, 5, 5 ' heart

  setCol 42, 42, 42, 42 ' arrow
  setCol 43, 22, 22, 22
  setCol 44, 62, 62, 62

  setCol 45, 58, 58, 58 'Floor
  setCol 46, 5, 5, 5

  setCol 250, 10, 10, 43 ' pearl silhouette
  setCol 251, 20, 20, 53 '       body
  setCol 252, 30, 30, 63 '       lens flare
 
  setCol 253, 10, 0, 0 ' water shade
 
  setCol 254, 0, 0, 0    ' text hide
  setCol 255, 63, 63, 63 ' text show

END SUB

SUB colScroll (startCol%, endCol%, loops%)

  STATIC nrn%
  nrn% = nrn% + 1
  IF nrn% = 2 THEN
    nrn% = 0
  ELSE
    EXIT SUB
  END IF
 
  DIM col(colMax) AS pal, i AS INTEGER

  FOR i = startCol% TO endCol%
    OUT &H3C7, i
    col(i).red = INP(&H3C9)
    col(i).green = INP(&H3C9)
    col(i).blue = INP(&H3C9)
  NEXT

  FOR l% = 1 TO loops%
    FOR N% = startCol% TO endCol%
      FOR i = startCol% TO endCol% - 1
        col(i).red = col(i + 1).red
        col(i).green = col(i + 1).green
        col(i).blue = col(i + 1).blue
        OUT &H3C8, i
        OUT &H3C9, col(i).red
        OUT &H3C9, col(i).green
        OUT &H3C9, col(i).blue
      NEXT
      col(endCol%).red = col(startCol%).red
      col(endCol%).green = col(startCol%).green
      col(endCol%).blue = col(startCol%).blue
      OUT &H3C8, endCol%
      OUT &H3C9, col(endCol%).red
      OUT &H3C9, col(endCol%).green
      OUT &H3C9, col(endCol%).blue
    NEXT
  NEXT

END SUB

FUNCTION create% (sprx AS INTEGER, spry AS INTEGER, viewx AS INTEGER, viewy AS INTEGER, level AS INTEGER)

  RANDOMIZE TIMER
  SELECT CASE level
    CASE 0: RESTORE lvl0
    CASE 1: RESTORE lvl1
    CASE 2: RESTORE lvl2
    CASE 3: RESTORE lvl3
    CASE 4: RESTORE lvl4
    CASE 5: RESTORE lvl5
    CASE 6: RESTORE lvl6
    CASE 7: RESTORE lvl7
    CASE 8: RESTORE lvl8
    CASE 9: RESTORE lvl9
    CASE ELSE
      CLS
      playSfx 16
      SLEEP 3: centerPrint "Well done", -2
      SLEEP 3: centerPrint "You guided the pearl successfully", -1
      SLEEP 3: centerPrint "Be proud of your pearl guiding skills", 0
      SLEEP 3: centerPrint "The pearl lives happily ever after", 1
      SLEEP 3: CLS
      SLEEP 3: centerPrint "Hmm ok", 0
      SLEEP 3: centerPrint "There IS no real ending to this game", 1
      SLEEP 3
      light -20
      create% = 0
      EXIT FUNCTION
  END SELECT

  killCol
  FOR y% = spry - viewy TO spry + viewy
    FOR x% = sprx - viewx TO sprx + viewx
      READ map%
      paste map%, x% - sprx, y% - spry, tileNr%
      IF map% = 2 THEN
        p% = p% + 1
        tileNr% = tileNr% + 3
      END IF
    NEXT
  NEXT
  colorize
  create% = p%

END FUNCTION

SUB delay

  clock! = TIMER
  DO UNTIL clock! + .001 - TIMER <= 0
  LOOP

END SUB

SUB flood (x AS INTEGER, y AS INTEGER)
 
  FOR ny% = -size \ 2 TO size \ 2
    FOR nx% = -size \ 2 TO size \ 2
      tp% = POINT(midx + x * size + nx% - size \ 4, midy + y * size + ny% - size \ 4)
      IF ((tp% >= 20 AND tp% <= 28) OR tp% = 253) OR tp% = 0 THEN ' OR (x = -viewx OR y = -viewy) THEN
        PSET (midx + x * size + nx%, midy + y * size + ny%), 20 + INT(RND * (size \ 2))
      ELSE
        PSET (midx + x * size + nx%, midy + y * size + ny%), 253 + RND
      END IF
    NEXT
  NEXT

END SUB

FUNCTION game%

  STATIC spr AS sprite, player AS status
 
  setSprite spr, midx, midy - 5, 0, 0, 7, 250, true
  clearTiles
  move spr, true, player
 
  player.gliding = false
  player.falling = false
  player.noJump = false
 
  IF player.lives = 0 THEN
    player.lives = 3
    player.lvl = 0 ' cheat
    player.pnts = 0
    player.timeLft = 100
  END IF
  player.p = create%(spr.x \ size, spr.y \ size, 9, 5, player.lvl)
  IF player.p = 0 THEN
    game% = false
    EXIT FUNCTION
  END IF
  show player, spr
  gameTime player, spr, true

  DO
    clockx! = TIMER
    move spr, false, player
    colScroll 20, 20 + size \ 2, 1
    'IF RND * 400 > 397 THEN playSfx 20 ' water sound
    gameTime player, spr, false
    DO UNTIL clockx! + .001 - TIMER <= 0
    LOOP
  LOOP UNTIL MULTIKEY%(keyEsc) OR spr.nrg = false OR player.pnts = player.p
  player.heart = false
 
  IF player.pnts = player.p THEN
    player.lvl = player.lvl + 1
    CLS
    game% = true
  ELSEIF spr.nrg = false THEN
    player.lives = player.lives - 1
    game% = true
    FOR i% = 0 TO 30
      delay
      colScroll 20, 20 + size \ 2, 1
    NEXT
    CLS
    IF player.timeLft = 0 THEN
      centerPrint "Time Out", 0
    ELSE
      centerPrint "You drowned", 0
    END IF
    SLEEP 1
    CLS
    IF player.lives = 0 THEN
      centerPrint "Game Over", 0
    ELSE
      centerPrint "Try again", 0
    END IF
    SLEEP 2
  ELSE
    game% = false
  END IF

  player.timeLft = 100

END FUNCTION

SUB gameTime (plr AS status, spr AS sprite, init AS INTEGER)
 
  STATIC tic%
  IF init THEN tic% = 0
  IF tic% > 0 AND tic% < 30 THEN
    tic% = tic% + 1
  ELSE
    tic% = 1
    plr.timeLft = plr.timeLft - 1
    IF plr.timeLft <= 0 THEN
      spr.nrg = 0
      playSfx 12
    END IF
    LINE (100 + plr.timeLft * 2 + 1, 1)-(300, 6), 8, BF
    LINE (100, 1)-STEP(plr.timeLft * 2, 5), 1, BF
    LINE (100, 1)-STEP(plr.timeLft * 2, 5), 9, B
  END IF

END SUB

FUNCTION getPoints%
 
  SHARED tiles() AS STRING * 2
  FOR N% = tileStart TO tileMax
    SELECT CASE tiles(N%)
      CASE "_x", "_x", "_x", "_x"
        points% = points% + 1
    END SELECT
  NEXT
  getPoints% = points%

END FUNCTION

SUB getStickData

  SHARED stickRight%, stickLeft%, stickUp%, stickDown%
  OPEN root + "joystick.dat" FOR INPUT AS #1
    LINE INPUT #1, temp$
    FOR N% = 1 TO 4
      LINE INPUT #1, temp$
      tempVal% = VAL(temp$)
      SELECT CASE N%
        CASE 1: stickLeft% = tempVal%
        CASE 2: stickRight% = tempVal%
        CASE 3: stickUp% = tempVal%
        CASE 4: stickDown% = tempVal%
      END SELECT
    NEXT
  CLOSE #1

END SUB

SUB handleSpeed (spr AS sprite)
 
  newSx% = joyX%
  newSy% = joyY%
 
  IF newSx% = 0 THEN
    IF spr.sx > 0 THEN
      spr.sx = spr.sx - 1
    ELSEIF spr.sx < 0 THEN
      spr.sx = spr.sx + 1
    END IF
  END IF
  IF newSy% = 0 THEN 'AND RND * 10 < 4
    IF spr.sy > 0 THEN
      spr.sy = spr.sy - 1
    ELSEIF spr.sy < 0 THEN
      spr.sy = spr.sy + 1
    END IF
  END IF
 
  spr.sx = spr.sx + newSx%
  spr.sy = spr.sy + newSy%

END SUB

SUB intro

  COLOR 15
  light -10
  centerPrint "Pearl 4 Beta (freeware)", -1
  centerPrint "Copyright (C) 1997 by Philipp Lenssen", 0
  centerPrint "(Jester@T-Online.de)", 1
  light 10
  SLEEP 1
  light -20
  CLS

END SUB

FUNCTION joyB1%
 
  IF STRIG(1) OR MULTIKEY%(keySpace) THEN
    joyB1% = true
  ELSE
    joyB1% = false
  END IF

END FUNCTION

FUNCTION joyB2%

  ' not used
  IF STRIG(2) THEN
    joyB2% = true
  ELSE
    joyB2% = false
  END IF

END FUNCTION

FUNCTION joyX%

  SHARED stickRight%, stickLeft%
  SELECT CASE STICK(0)
    CASE IS <= stickLeft% + 5: joyX% = -1
    CASE IS >= stickRight% - 5: joyX% = 1
    CASE ELSE
      'IF MULTIKEY%(keyArrow) THEN
        IF MULTIKEY%(keyLeft) THEN
          joyX% = -1
        ELSEIF MULTIKEY%(keyRight) THEN
          joyX% = 1
      '  END IF
      ELSE
        joyX% = 0
      END IF
  END SELECT

END FUNCTION

FUNCTION joyY%
 
  SHARED stickUp%, stickDown%
  SELECT CASE STICK(1)
    CASE IS <= stickUp% + 5: joyY% = -1
    CASE IS >= stickDown% - 5: joyY% = 1
    CASE ELSE
      'IF MULTIKEY%(keyArrow) THEN
        IF MULTIKEY%(keyUp) THEN
          joyY% = -1
        ELSEIF MULTIKEY%(keyDown) THEN
          joyY% = 1
      '  END IF
      ELSE
        joyY% = 0
      END IF
  END SELECT

END FUNCTION

SUB killCol

  FOR N% = 0 TO colMax
    setCol N%, 0, 0, 0
  NEXT

END SUB

SUB light (value AS INTEGER)

 DIM i AS INTEGER, N AS INTEGER, col AS pal
 DIM clock AS SINGLE

 IF SGN(value) = -1 THEN
  FOR N = 0 TO ABS(value)
    FOR i = 0 TO colMax
      OUT &H3C7, i
        col.red = INP(&H3C9)
        col.green = INP(&H3C9)
        col.blue = INP(&H3C9)
        OUT &H3C8, i
        OUT &H3C9, .9 * col.red
        OUT &H3C9, .9 * col.green
        OUT &H3C9, .9 * col.blue
      NEXT
      clock = TIMER
      DO UNTIL clock + .001 - TIMER <= 0
      LOOP
    NEXT
  ELSE '## never used
    FOR N = 0 TO value
      FOR i = 0 TO colMax
        OUT &H3C7, i
        col.red = INP(&H3C9)
        col.green = INP(&H3C9)
        col.blue = INP(&H3C9)
        OUT &H3C8, i
        OUT &H3C9, col.red / .9
        OUT &H3C9, col.green / .9
        OUT &H3C9, col.blue / .9
      NEXT
      clock = TIMER
      DO UNTIL clock + .001 - TIMER <= 0
      LOOP
    NEXT
  END IF

END SUB

SUB move (spr AS sprite, initAll AS INTEGER, player AS status)
 
  STATIC init%, ltc%
  SHARED tiles() AS STRING * 2
  SHARED back() AS INTEGER
 
  IF initAll THEN
    init% = 0
    spr.sy = 2
    EXIT SUB
  END IF
 
  IF joyB1% AND spr.sz = 7 AND NOT player.gliding AND NOT player.falling AND NOT player.noJump THEN
    spr.sz = sprMax
    playSfx 17
  END IF
 
  IF NOT player.gliding AND NOT player.falling THEN handleSpeed spr
  IF NOT player.gliding THEN slowDown spr

  IF player.gliding AND spr.sx = 0 AND spr.sy = 0 THEN spr.sy = 1 '''

  IF spr.sx <> 0 OR spr.sy <> 0 OR spr.sz > 7 THEN
   
    IF spr.sz > 7 THEN spr.sz = spr.sz - 1

    'IF RND * 20 + (ABS(spd.sx) + ABS(spd.sy)) * 2 > 12 THEN playSfx 18
   
    IF NOT init% THEN
      init% = true
      FOR f% = 0 TO 7 STEP 1
        spr.sz = f%
        GET (midx - sprMax - mores, midy - sprMax - mores)-STEP(sprMax * 2 + mores, sprMax * 2 + mores), back
        CIRCLE (midx, midy), spr.sz, spr.col
        PAINT STEP(0, 0), spr.col + 1, spr.col
        colScroll 20, 20 + size \ 2, 1
        delay
        PUT (midx - sprMax - mores, midy - sprMax - mores), back, PSET
      NEXT
      playSfx 16
    END IF
   
    FOR nn% = 1 TO 2
      IF nn% = 1 THEN
        spdx% = SGN(spr.sx)
        spdy% = 0
      ELSE
        spdx% = 0
        spdy% = SGN(spr.sy)
      END IF
      tcol% = POINT(midx + spdx% * (spr.sz + 1), midy + spdy% * spr.sz)
      IF tcol% >= 16 AND tcol% <= 19 THEN
        snd% = true
        IF spdx% <> 0 THEN
          spr.sx = spr.sx * -1
        ELSEIF spdy% <> 0 THEN
          spr.sy = spr.sy * -1
        END IF
      END IF
    NEXT
    IF snd% = true THEN playSfx 2

    scroll spr.sx, spr.sy, ABS(spr.sx), ABS(spr.sy)
    PUT (midx - sprMax - spr.sx - mores, midy - sprMax - spr.sy - mores), back, PSET
   
    player.gliding = false
    IF player.falling = true THEN
      spr.sz = spr.sz - 1
      IF spr.sz = 0 THEN
        playSfx 4
        spr.nrg = false
      END IF
    END IF
   
    player.noJump = false
    tcol% = POINT(midx, midy)
    IF spr.sz <> 7 THEN tcol% = -1
    IF (tcol% >= 20 AND tcol% <= 28) OR tcol% = 253 THEN '''<=20+size\2
      player.falling = true
      water% = true
    ELSEIF tcol% >= tileStart AND tcol% <= tileMax THEN
      IF ltc% <> tcol% AND RIGHT$(tiles(tcol%), 1) = "x" THEN
        changeTile tcol%
        released% = false
      END IF
    ELSEIF tcol% = 35 THEN
      player.pnts = getPoints%
      IF player.pnts = player.p THEN
        playSfx 10
        SLEEP 1
        EXIT SUB
      END IF
    ELSEIF tcol% >= 37 AND tcol% <= 39 THEN
      player.gliding = true
    ELSEIF tcol% = 40 AND player.heart = false THEN
      setCol 40, 0, 42, 42
      playSfx 18
      player.heart = true
      player.lives = player.lives + 1
      show player, spr
    ELSEIF tcol% >= 42 AND tcol% <= 44 THEN
      spr.sx = 0
      IF spr.sy = 0 THEN spr.sy = 1
      spr.sy = -ABS(spr.sy)
      player.gliding = true
    ELSEIF tcol% >= 45 AND tcol% <= 46 THEN
      spr.sx = SGN(spr.sx) * INT(RND * speedLimit - 1)
      IF spr.sx = 0 THEN spr.sx = RND * 4 - 2
      spr.sy = SGN(spr.sy) * INT(RND * speedLimit - 1)
      IF spr.sy = 0 THEN spr.sy = RND * 4 - 2
      player.noJump = true
    END IF
   
    ltc% = tcol%
    GET (midx - sprMax - mores, midy - sprMax - mores)-STEP(sprMax * 2 + mores, sprMax * 2 + mores), back
    IF (spr.sz <= 7 AND water%) OR (spr.sz >= 7 AND NOT water%) THEN ''' <
      CIRCLE (midx, midy), spr.sz, spr.col
      IF spr.sz > 0 THEN
        PAINT STEP(0, 0), spr.col + 1, spr.col
        CIRCLE (midx - spr.sz \ 3, midy - spr.sz \ 3), spr.sz \ 4, spr.col + 2
        PAINT STEP(0, 0), spr.col + 2, spr.col + 2
      END IF
    END IF
  END IF

END SUB

FUNCTION MULTIKEY% (T)

' t = -1: init, t = -2: re init

STATIC kbcontrol%(), kbmatrix%(), Firsttime, StatusFlag

IF Firsttime = 0 THEN          'Initalize
 DIM kbcontrol%(128)
 DIM kbmatrix%(128)
 code$ = ""
 code$ = code$ + "E91D00E93C00000000000000000000000000000000000000000000000000"
 code$ = code$ + "00001E31C08ED8BE24000E07BF1400FCA5A58CC38EC0BF2400B85600FAAB"
 code$ = code$ + "89D8ABFB1FCB1E31C08EC0BF2400BE14000E1FFCFAA5A5FB1FCBFB9C5053"
 code$ = code$ + "51521E560657E460B401A8807404B400247FD0E088C3B700B0002E031E12"
 code$ = code$ + "002E8E1E100086E08907E4610C82E661247FE661B020E6205F075E1F5A59"
 code$ = code$ + "5B589DCF"
 DEF SEG = VARSEG(kbcontrol%(0))
 FOR i% = 0 TO 155                     ' Load ASM
     d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
     POKE VARPTR(kbcontrol%(0)) + i%, d%
 NEXT i%
 i& = 16       ' I think this stuff connects the interrupt with kbmatrix%()
 N& = VARSEG(kbmatrix%(0)): l& = N& AND 255: h& = ((N& AND &HFF00) \ 256): POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
 N& = VARPTR(kbmatrix%(0)): l& = N& AND 255: h& = ((N& AND &HFF00) \ 256): POKE i&, l&: POKE i& + 1, h&: i& = i& + 2
 DEF SEG
 Firsttime = 1
END IF

SELECT CASE T
 CASE 1 TO 128 ' Return status
  MULTIKEY% = kbmatrix%(T) * -1 ' boolean
 CASE -1
  IF StatusFlag = 0 THEN
   DEF SEG = VARSEG(kbcontrol%(0))
   CALL ABSOLUTE(0)                     ' Run interrupt
   DEF SEG
   StatusFlag = 1
  END IF
 CASE -2
  IF StatusFlag = 1 THEN
   DEF SEG = VARSEG(kbcontrol%(0))      ' Turn off interrupt
   CALL ABSOLUTE(3)
   DEF SEG
   StatusFlag = 0
  END IF
END SELECT

END FUNCTION

SUB paste (tile AS INTEGER, x AS INTEGER, y AS INTEGER, tileNr AS INTEGER)

  SHARED tiles() AS STRING * 2
  SELECT CASE tile
    CASE 0
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 36, BF
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2 - 1, midy + y * size + size \ 2 - 1), 11, B
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 1, B
      CIRCLE (midx + x * size, midy + y * size), size \ 4, 35
      PAINT STEP(0, 0), 35, 35
    CASE 1
      flood x, y
    CASE 2
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), tileNr + tileStart, BF
      MID$(tiles(tileNr + tileStart), 2, 1) = "x"
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2 - 1, midy + y * size + size \ 2 - 1), tileNr + tileStart + 1, B
      MID$(tiles(tileNr + tileStart + 1), 2, 1) = "."
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), tileNr + tileStart + 2, B
      MID$(tiles(tileNr + tileStart + 2), 2, 1) = "."
    CASE 3
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 3, BF
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2 - 1, midy + y * size + size \ 2 - 1), 1, B
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 11, B
    CASE 4
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 16, B
      LINE (midx + x * size + size \ 2, midy + y * size - size \ 2)-(midx + x * size - size \ 2, midy + y * size + size \ 2), 16
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 16
     
      PAINT (midx + x * size, midy + y * size - size \ 4), 18, 16
      PAINT (midx + x * size - size \ 4, midy + y * size), 19, 16
      PAINT (midx + x * size, midy + y * size + size \ 4), 17, 16
      PAINT (midx + x * size + size \ 4, midy + y * size), 16, 16
     
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2 - 1, midy + y * size + size \ 2 - 1), 16, B
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 18, B
    CASE 5
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 37, BF
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2 - 1, midy + y * size + size \ 2 - 1), 38, B
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 39, B
    CASE 6
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 3, BF
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2 - 1, midy + y * size + size \ 2 - 1), 1, B
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 11, B
      COLOR 254
      LOCATE 1: PRINT CHR$(3)
      FOR px% = 0 TO 8
        FOR py% = 0 TO 8
          IF POINT(px%, py%) = 254 THEN PSET (midx + x * size + px% - 4, midy + y * size + py% - 4), 40
       NEXT
      NEXT
      LOCATE 1: PRINT " " '''
      COLOR 255
    CASE 7
      flood x, y
      LINE (midx + x * size - size \ 2, midy + y * size - 1)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 3, BF
      LINE (midx + x * size - size \ 2, midy + y * size - 1)-(midx + x * size + size \ 2 - 1, midy + y * size + size \ 2 - 1), 1, B
      LINE (midx + x * size - size \ 2, midy + y * size - 1)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 11, B
    CASE 8
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 42, BF
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2 - 1, midy + y * size + size \ 2 - 1), 43, B
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 44, B
      COLOR 254
      LOCATE 1: PRINT CHR$(24)
      FOR px% = 0 TO 8
        FOR py% = 0 TO 8
          IF POINT(px%, py%) = 254 THEN PSET (midx + x * size + px% - 4, midy + y * size + py% - 4), 43
       NEXT
      NEXT
      LOCATE 1: PRINT " " '''
      COLOR 255
    CASE 9
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size + size \ 2, midy + y * size + size \ 2), 46, BF
      FOR ny% = -size \ 2 TO size \ 2
        FOR nx% = -size \ 2 TO size \ 2
          IF RND * 100 < 1 THEN
            PSET (midx + x * size + nx%, midy + y * size + ny%), 45
          END IF
        NEXT
      NEXT
      LINE (midx + x * size - size \ 2, midy + y * size - size \ 2)-(midx + x * size - 1, midy + y * size - 1), 45, BF
      LINE STEP(1, 1)-STEP(size \ 2, size \ 2), 45, BF
      FOR ny% = -size \ 2 TO -1
        FOR nx% = -size \ 2 TO -1
          IF RND * 100 < 1 THEN
            PSET (midx + x * size + nx%, midy + y * size + ny%), 46
          END IF
        NEXT
      NEXT
      FOR ny% = 0 TO size \ 2
        FOR nx% = 0 TO size \ 2
          IF RND * 100 < 1 THEN
            PSET (midx + x * size + nx%, midy + y * size + ny%), 46
          END IF
        NEXT
      NEXT
  END SELECT
  
END SUB

SUB playSfx (blasterNum AS INTEGER)

  SHARED channel() AS STRING, blaster() AS STRING ', options AS gameSetting
  DIM chanIndex AS INTEGER, in AS INTEGER, d AS INTEGER, B AS INTEGER
  DIM reg AS STRING, regX AS INTEGER
  DIM dat AS STRING, datX AS INTEGER

  'IF options.soundFX = false THEN EXIT SUB
  chanIndex = VAL(MID$(blaster(blasterNum), 61, 4))
  FOR in = 1 TO 60 STEP 4
    reg = MID$(channel(chanIndex), in, 4)
    regX = VAL(reg)
    dat = MID$(blaster(blasterNum), in, 4)
    datX = VAL(dat)
    OUT &H388, regX
    FOR d = 1 TO 6
      B = INP(&H388)
    NEXT
    OUT &H389, datX
    FOR d = 1 TO 35
      B = INP(&H388)
    NEXT
  NEXT

END SUB

SUB scroll (spx AS INTEGER, spy AS INTEGER, brdrx AS INTEGER, brdry AS INTEGER)

  SHARED pic() AS INTEGER
  DIM lxpic(2000) AS INTEGER
 
  IF SGN(spx) = -1 THEN
    GET (midxMvwx, midyMvwy)-(midxPvwx - brdrx, midyPvwy), pic
    GET (midxPvwx - brdrx, midyMvwy)-(midxPvwx, midyPvwy), lxpic
    PUT (midxMvwx + brdrx, midyMvwy), pic, PSET
    PUT (midxMvwx, midyMvwy), lxpic, PSET
  ELSEIF SGN(spx) = 1 THEN
    GET (midxMvwx + brdrx, midyMvwy)-(midxPvwx, midyPvwy), pic
    GET (midxMvwx, midyMvwy)-(midxMvwx + brdrx, midyPvwy), lxpic
    PUT (midxMvwx, midyMvwy), pic, PSET
    PUT (midxPvwx - brdrx, midyMvwy), lxpic, PSET
  END IF
  IF SGN(spy) = -1 THEN
    GET (midxMvwx, midyMvwy)-(midxPvwx, midyPvwy - brdry), pic
    GET (midxMvwx, midyPvwy - brdry)-(midxPvwx, midyPvwy), lxpic
    PUT (midxMvwx, midyMvwy + brdry), pic, PSET
    PUT (midxMvwx, midyMvwy), lxpic, PSET
  ELSEIF SGN(spy) = 1 THEN
    GET (midxMvwx, midyMvwy + brdry)-(midxPvwx, midyPvwy), pic
    GET (midxMvwx, midyMvwy)-(midxPvwx, midyMvwy + brdry), lxpic
    PUT (midxMvwx, midyMvwy), pic, PSET
    PUT (midxMvwx, midyPvwy - brdry), lxpic, PSET
  END IF

END SUB

SUB setCol (i%, R%, g%, B%)
 
  OUT &H3C8, i%
  OUT &H3C9, R%
  OUT &H3C9, g%
  OUT &H3C9, B%

END SUB

SUB setSoundFX

  SHARED channel() AS STRING, blaster() AS STRING
  DIM i AS INTEGER
  RESTORE channels
    FOR i = 0 TO 8
      READ channel(i)
    NEXT
  RESTORE various
    FOR i = 0 TO 25
      READ blaster(i)
    NEXT
  CLOSE #1

END SUB

SUB setSprite (spr AS sprite, x AS INTEGER, y AS INTEGER, sx AS INTEGER, sy AS INTEGER, sz AS INTEGER, col AS INTEGER, nrg AS INTEGER)

  spr.x = x
  spr.y = y
  spr.sx = sx
  spr.sy = sy
  spr.sz = sz
  spr.col = col
  spr.nrg = nrg

END SUB

SUB show (plr AS status, spr AS sprite)
 
  FOR N% = 1 TO plr.lives - 1
    CIRCLE ((7 + 6) * N%, (7 - 2)), 7 - 2, spr.col
    PAINT STEP(0, 0), spr.col + 1, spr.col
    CIRCLE ((7 + 6) * N% - 7 \ 3, (7 - 2) - 7 \ 3), (7 - 2) \ 4, spr.col + 2
    PAINT STEP(0, 0), spr.col + 2, spr.col + 2
  NEXT

END SUB

SUB slowDown (spr AS sprite)
 
  IF spr.sx > speedLimit THEN
    spr.sx = spr.sx - 1
  ELSEIF spr.sx < -speedLimit THEN
    spr.sx = spr.sx + 1
  END IF
  IF spr.sy > speedLimit THEN
    spr.sy = spr.sy - 1
  ELSEIF spr.sy < -speedLimit THEN
    spr.sy = spr.sy + 1
  END IF

END SUB

